/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_BACKEND_H__
#define __OGMRIP_BACKEND_H__

#include <ogmjob-exec.h>
#include <ogmrip-container.h>
#include <ogmrip-dvdcpy.h>
#include <ogmrip-audio.h>
#include <ogmrip-video.h>
#include <ogmrip-subp.h>

G_BEGIN_DECLS

gdouble  ogmrip_backend_wav_watch         (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipAudio     *audio);
gdouble  ogmrip_backend_acopy_watch       (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipAudio     *audio);
gdouble  ogmrip_backend_xvid_watch        (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipVideo     *video);
gdouble  ogmrip_backend_lavc_watch        (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipVideo     *video);
gdouble  ogmrip_backend_x264_watch        (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipVideo     *video);
gdouble  ogmrip_backend_yuv4mpeg_watch    (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipVideo     *video);
gdouble  ogmrip_backend_crop_watch        (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipVideo     *video);
gdouble  ogmrip_backend_dvdcpy_watch      (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipVideo     *video);
gdouble  ogmrip_backend_ogg_merge_watch   (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipContainer *ogg);
gdouble  ogmrip_backend_ogg_split_watch   (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipContainer *ogg);
gdouble  ogmrip_backend_matroska_watch    (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipContainer *matroska);
gdouble  ogmrip_backend_avi_watch         (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipContainer *avi);
gdouble  ogmrip_backend_lavf_watch        (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipContainer *lavf);
gdouble  ogmrip_backend_vobsub_watch      (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipSubp      *subp);
gdouble  ogmrip_backend_pgm_watch         (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipSubp      *subp);
gdouble  ogmrip_backend_ocr_watch         (OGMJobExec      *exec, 
                                           const gchar     *buffer, 
                                           OGMRipSubp      *subp);

gchar ** ogmrip_backend_wav_command       (OGMRipAudio     *audio,
                                           gboolean        header,
                                           const gchar     *input,
                                           const gchar     *output);
gchar ** ogmrip_backend_acopy_command     (OGMRipAudio     *audio,
                                           const gchar     *input,
                                           const gchar     *output);
gchar ** ogmrip_backend_vorbis_command    (OGMRipAudio     *audio,
                                           const gchar     *input,
                                           const gchar     *output);
gchar ** ogmrip_backend_mp3_command       (OGMRipAudio     *audio,
                                           const gchar     *input,
                                           const gchar     *output);
gchar ** ogmrip_backend_aac_command       (OGMRipAudio     *audio,
                                           const gchar     *input,
                                           const gchar     *output);
gchar ** ogmrip_backend_xvid_command      (OGMRipVideo     *video,
                                           const gchar     *input,
                                           const gchar     *output,
                                           const gchar     *log);
gchar ** ogmrip_backend_lavc_command      (OGMRipVideo     *video,
                                           const gchar     *input,
                                           const gchar     *output, 
                                           const gchar     *log);
gchar ** ogmrip_backend_x264_command      (OGMRipVideo     *video,
                                           const gchar     *input,
                                           const gchar     *output, 
                                           const gchar     *log);
gchar ** ogmrip_backend_yuv4mpeg_command  (OGMRipVideo     *video,
                                           const gchar     *input,
                                           const gchar     *output, 
                                           const gchar     *log);
gchar ** ogmrip_backend_theora_command    (OGMRipVideo     *video,
                                           const gchar     *input,
                                           const gchar     *output, 
                                           const gchar     *log);
gchar ** ogmrip_backend_crop_command      (OGMRipVideo     *video,
                                           const gchar     *input,
                                           const gchar     *output);

gchar ** ogmrip_backend_dvdcpy_command    (OGMRipDvdCpy    *video, 
                                           const gchar     *input, 
                                           const gchar     *output);

gchar ** ogmrip_backend_vobsub_command    (OGMRipSubp      *subp,
                                           const gchar     *input,
                                           const gchar     *output);
gchar ** ogmrip_backend_pgm_command       (OGMRipSubp      *subp,
                                           const gchar     *input,
                                           const gchar     *output);
gchar ** ogmrip_backend_ocr_command       (OGMRipSubp      *subp,
                                           const gchar     *input,
                                           const gchar     *output);
gchar ** ogmrip_backend_srt_command       (OGMRipSubp      *subp,
                                           const gchar     *input,
                                           const gchar     *output);

gchar ** ogmrip_backend_avi_command       (OGMRipContainer *avi);
gchar ** ogmrip_backend_ogg_split_command (OGMRipContainer *ogg,
                                           const gchar     *input);
gchar ** ogmrip_backend_ogg_merge_command (OGMRipContainer *ogg,
                                           const gchar     *output);
gchar ** ogmrip_backend_matroska_command  (OGMRipContainer *matroska);
gchar ** ogmrip_backend_mp4_command       (OGMRipContainer *mp4);

gchar ** ogmrip_backend_copy_command      (OGMRipContainer *container,
                                           const gchar     *input,
                                           const gchar     *output);

G_END_DECLS

#endif /* __OGMRIP_BACKEND_H__ */

