/*

Copyright (C) 2000 John W. Eaton

This file is part of Octave.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, write to the Free
Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.

*/

#if defined (__GNUG__) && defined (USE_PRAGMA_INTERFACE_IMPLEMENTATION)
#pragma implementation
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "c-file-ptr-stream.h"

#ifndef SEEK_SET
#define SEEK_SET 0
#endif

#ifndef SEEK_CUR
#define SEEK_CUR 1
#endif

#ifndef SEEK_END
#define SEEK_END 2
#endif

c_file_ptr_buf::~c_file_ptr_buf (void)
{
  close ();
}

// XXX FIXME XXX -- I'm sure there is room for improvement here...

c_file_ptr_buf::int_type
c_file_ptr_buf::overflow (int_type c)
{
#if defined (CXX_ISO_COMPLIANT_LIBRARY)
  if (f)
    return (c != traits_type::eof ()) ? fputc (c, f) : flush ();
  else
    return traits_type::not_eof (c);
#else
  if (f)
    return (c != EOF) ? fputc (c, f) : flush ();
  else
    return EOF;
#endif
}

c_file_ptr_buf::int_type
c_file_ptr_buf::underflow_common (bool bump)
{
  if (f)
    {
      int_type c = fgetc (f);

      if (! bump
#if defined (CXX_ISO_COMPLIANT_LIBRARY)
	  && c != traits_type::eof ())
#else
	  && c != EOF)
#endif
	ungetc (c, f);

      return c;
    }
  else
#if defined (CXX_ISO_COMPLIANT_LIBRARY)
    return traits_type::eof ();
#else
    return EOF;
#endif
}

c_file_ptr_buf::int_type
c_file_ptr_buf::pbackfail (int_type c)
{
#if defined (CXX_ISO_COMPLIANT_LIBRARY)
  return (c != traits_type::eof () && f) ? ungetc (c, f) : 
    traits_type::not_eof (c);
#else
  return (c != EOF && f) ? ungetc (c, f) : EOF;
#endif
}

std::streamsize
c_file_ptr_buf::xsputn (const char* s, std::streamsize n)
{
  if (f)
    return fwrite (s, 1, n, f);
  else
    return 0;
}

std::streamsize
c_file_ptr_buf::xsgetn (char *s, std::streamsize n)
{
  if (f)
    return fread (s, 1, n, f);
  else
    return 0;
}

static inline int
seekdir_to_whence (std::ios::seekdir dir)
{
  return ((dir == std::ios::beg) ? SEEK_SET :
	  (dir == std::ios::cur) ? SEEK_CUR :
	  (dir == std::ios::end) ? SEEK_END :
	  dir);
}

std::streampos
c_file_ptr_buf::seekoff (std::streamoff offset, std::ios::seekdir dir,
			 std::ios::openmode)
{
  // XXX FIXME XXX
#if 0
  if (f)
    {
      fseek (f, offset, seekdir_to_whence (dir));

      return ftell (f);
    }
  else
    return 0;
#endif
  return -1;
}

std::streampos
c_file_ptr_buf::seekpos (std::streampos offset, std::ios::openmode)
{
  // XXX FIXME XXX
#if 0  
  if (f)
    {
      fseek (f, offset, SEEK_SET);

      return ftell (f);
    }
  else
    return 0;
#endif
  return -1;
}

int
c_file_ptr_buf::sync (void)
{
  flush ();

  return 0;
}

int
c_file_ptr_buf::flush (void)
{
  return f ? fflush (f) : EOF;
}

int
c_file_ptr_buf::close (void)
{
  int retval = -1;

  flush ();

  if (f)
    {
      retval = cf (f);
      f = 0;
    }

  return retval;
}

/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; End: ***
*/

