/* netcmds.h - upsd support structure details

   Copyright (C) 2001  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

static void do_sendver(struct sockaddr_in *dest, char *arg, char *rest);
static void do_sendans(struct sockaddr_in *dest, char *arg, char *rest);
static void do_sendhelp(struct sockaddr_in *dest, char *arg, char *rest);
static void do_listvars(struct sockaddr_in *dest, char *arg, char *rest);
static void do_logout(struct sockaddr_in *dest, char *arg, char *rest);
static void do_login(struct sockaddr_in *dest, char *arg, char *rest);
static void do_password(struct sockaddr_in *dest, char *arg, char *rest);
static void do_listrw(struct sockaddr_in *dest, char *arg, char *rest);
static void do_vartype(struct sockaddr_in *dest, char *arg, char *rest);
static void do_vardesc(struct sockaddr_in *dest, char *arg, char *rest);
static void do_enum(struct sockaddr_in *dest, char *arg, char *rest);
static void do_set(struct sockaddr_in *dest, char *arg, char *rest);
static void do_instcmd(struct sockaddr_in *dest, char *arg, char *rest);
static void do_listinstcmd(struct sockaddr_in *dest, char *arg, char *rest);
static void do_instcmddesc(struct sockaddr_in *dest, char *arg, char *rest);
static void do_fsd(struct sockaddr_in *dest, char *arg, char *rest);
static void do_master(struct sockaddr_in *dest, char *arg, char *rest);
static void do_username(struct sockaddr_in *dest, char *arg, char *rest);
void do_starttls(struct sockaddr_in *dest, char *arg, char *rest);

/* netcmds[] - map net commands to functions */

struct {
	char	*name;
	void	(*func)(struct sockaddr_in *dest, char *arg, char *rest);
}	netcmds[] =
{
	{ "VER",	do_sendver		},
	{ "REQ",	do_sendans		},
	{ "HELP",	do_sendhelp		},
	{ "LISTVARS",	do_listvars		},
	{ "LOGOUT", 	do_logout		},
	{ "LOGIN",	do_login		},
	{ "PASSWORD",	do_password		},
	{ "LISTRW",	do_listrw		},
	{ "VARTYPE",	do_vartype		},
	{ "VARDESC",	do_vardesc		},
	{ "ENUM",	do_enum			},
	{ "SET",	do_set			},
	{ "INSTCMD",	do_instcmd		},
	{ "LISTINSTCMD",do_listinstcmd		},
	{ "INSTCMDDESC",do_instcmddesc		},
	{ "FSD",	do_fsd			},
	{ "MASTER",	do_master		},
	{ "USERNAME",	do_username		},
	{ "STARTTLS",	do_starttls		},
	{ NULL,		(void(*)())(NULL)	}
};
