#ifndef NUT_SHARED_H
#define NUT_SHARED_H

/* shared.h - shared data structures for upsd and model-specific modules */

/* itype - holds info (variable name, variable value) */

/* size of the values stored within the array */
#define VALSIZE 32

/* used in an array and stored in shared memory or to state file */
typedef struct {
	int	type;
	char	value[VALSIZE];
	int	flags;			/* see FLAGS_* below 		*/
	int	auxdata;		/* length, # entries, enumtype	*/
}	itype;

/* these values are only used between processes on the same host... */

#define INFO_MEMBERS	0x0000		/* number of info entries 	*/
#define INFO_MFR	0x0001		/* manufacturer string		*/
#define INFO_MODEL	0x0002		/* model string			*/
#define INFO_SERIAL	0x0003		/* serial number		*/
#define INFO_UTILITY	0x0004		/* incoming utility voltage	*/
#define INFO_BATTPCT	0x0005		/* battery charge (percent)	*/
#define INFO_STATUS	0x0006		/* status (OL, OB, LB, etc.)	*/
#define INFO_UPSTEMP	0x0007		/* temperature (degrees C)	*/
#define INFO_ACFREQ	0x0008		/* AC frequency (Hz)		*/
#define INFO_LOADPCT	0x0009		/* load on UPS (percent)	*/
#define INFO_LOWXFER	0x000A		/* low transfer voltage		*/
#define INFO_HIGHXFER	0x000B		/* high transfer voltage	*/
#define INFO_AMBHUMID	0x000C		/* ambient humidity (percent)	*/
#define INFO_AMBTEMP	0x000D		/* ambient temperature (deg C)	*/
#define INFO_CONTACTS   0x000F		/* dry contacts                 */
#define INFO_UPSIDENT	0x0010		/* ups identification (string)  */
#define INFO_WAKEDELAY	0x0011		/* seconds to delay at poweron	*/
#define INFO_LINESENS	0x0012		/* line sensitivity		*/
#define INFO_BATTVOLT   0x0013		/* Battery Voltage		*/
#define INFO_OUTVOLT    0x0014		/* Output Voltage		*/
#define INFO_WAKETHRSH	0x0015		/* battery threshold for poweron*/
#define INFO_REQVOLT	0x0016		/* Requested output voltage	*/
#define INFO_LOBATTIME	0x0017		/* run time when lo-bat starts	*/
#define INFO_PDNGRACE	0x0018		/* grace from cmd and powerdown	*/
#define INFO_ALRMDELAY	0x0019		/* delay before OB warning	*/
#define INFO_SLFTSTINT	0x001A		/* intervals between self tests	*/
#define INFO_FIRMREV	0x001B		/* Firmware revision		*/
#define INFO_REG1	0x001C		/* Register 1			*/
#define INFO_REG2	0x001D		/* Register 2			*/
#define INFO_REG3	0x001E		/* Register 3			*/
#define INFO_LINEQUAL	0x001F		/* Line quality			*/
#define INFO_BATTPACKS	0x0020		/* Installed battery packs	*/
#define INFO_XFERWHY	0x0021		/* Reason for last transfer	*/
#define INFO_MAXUTIL	0x0022		/* Max utility voltage seen	*/
#define INFO_MINUTIL	0x0023		/* Min utility voltage seen	*/
#define INFO_SLFTSTRES	0x0024		/* Last self test result	*/
#define INFO_RUNTIME	0x0025		/* Predicted runtime on batt	*/
#define INFO_MFRDATE	0x0026		/* Manufacturing date		*/
#define INFO_BATTDATE	0x0027		/* last battery change date	*/
#define INFO_TEMPMAX	0x0028		/* Max temperature setting 	*/
#define INFO_TEMPMIN	0x0029		/* Min temperature setting 	*/
#define INFO_HUMDMAX	0x002A		/* Max humidity setting 	*/
#define INFO_HUMDMIN	0x002B		/* Min humidity setting 	*/
#define INFO_FIRMREV1	0x002C		/* Firmware revision (more)	*/
#define INFO_NOMBATVLT	0x002D		/* Nominal battery voltage 	*/
#define INFO_COPYRIGHT	0x002E		/* UPS F/W Copyright Info	*/
#define INFO_FIRMREV2	0x002F		/* Firmware revision (aux device)*/
#define INFO_DIPSWCH	0x0030		/* DIP switch settings		*/
#define INFO_OUTVLTSEL	0x0031		/* Output voltage selection	*/
#define INFO_CURRENT	0x0032		/* Output Current		*/
#define INFO_LOADPWR	0x0033		/* Load power percentage	*/
#define INFO_LANGUAGE	0x0034		/* Front panel language		*/
#define INFO_BADPACKS	0x0035		/* Bad battery packs installed	*/
#define INFO_ALRMENA	0x0036		/* Alarm enable                 */
#define INFO_ALRMSTAT	0x0037		/* Alarm status			*/
#define INFO_AMBTEMP2	0x0038		/* Ambient temperature 2 	*/
#define INFO_AMBHUMID2	0x0039		/* Ambient Humidity 2		*/
#define INFO_GRACEDELAY	0x003A		/* Shutdown delay		*/
#define INFO_RTHRESH	0x003B		/* Return threshold (batt %)	*/
#define INFO_ALRMDEL	0x003C		/* Alarm delay			*/
/* the 89 sec variables */
#define INFO_ALRM_PWRWAIT	0x003d	/* Awaiting Power Alarm		*/
#define INFO_ALRM_BADBYPASS	0x003e	/* Bypass Bad Alarm		*/
#define INFO_ALRM_CHARGFAIL	0x003f	/* Charger Failure Alarm	*/
#define INFO_ALRM_FANFAIL	0x0040	/* Fan Failure Alarm		*/
#define INFO_ALRM_FUSEFAIL	0x0041	/* Fuse Failure Alarm		*/
#define INFO_ALRM_GENERAL	0x0042	/* General Fault Alarm		*/
#define INFO_ALRM_BADINPUT	0x0043	/* Input Bad Alarm		*/
#define INFO_ALRM_BADOUTPUT	0x0044	/* Output Bad Alarm		*/
#define INFO_ALRM_OUTPUTOFF	0x0045	/* Output Off Alarm		*/
#define INFO_ALRM_OVERLOAD	0x0046	/* Overload Alarm		*/
#define INFO_ALRM_IMMSHUT	0x0047	/* Shutdown Imminent Alm	*/
#define INFO_ALRM_PENDSHUT	0x0048	/* Shutdown Pending Alm		*/
#define INFO_ALRM_SYSOFF	0x0049	/* System Off Alarm		*/
#define INFO_ALRM_TEMP		0x004a	/* Temperature Alarm		*/
#define INFO_ALRM_UPSSHUT	0x004b	/* UPS Shutdown Alarm		*/
#define INFO_AUDIBLEALRM	0x004c	/* Audible Alarm		*/
#define INFO_AUTORESTART	0x004d	/* Auto Restart			*/
#define INFO_BATT_CHARGE	0x004e	/* Battery Charge		*/
#define INFO_BATT_COND		0x004f	/* Battery Condition		*/
#define INFO_BATT_CURRENT	0x0050	/* Battery Current		*/
#define INFO_BATT_DATE		0x0051	/* Battery Installed		*/
#define INFO_BATT_STATUS	0x0052	/* Battery Status		*/
#define INFO_BATT_TEMP		0x0053	/* Battery Temperature		*/
#define INFO_BATT_VOLT		INFO_BATTVOLT	/* Battery Voltage		*/
#define INFO_BYPASS_CURRENT1	0x0055	/* Bypass Current 1		*/
#define INFO_BYPASS_CURRENT2	0x0056	/* Bypass Current 2		*/
#define INFO_BYPASS_CURRENT3	0x0057	/* Bypass Current 3		*/
#define INFO_BYPASS_FREQ	0x0058	/* Bypass Frequency		*/
#define INFO_BYPASS_NLINES	0x0059	/* Bypass Num Lines		*/
#define INFO_BYPASS_PWR1	0x005a	/* Bypass Power	1		*/
#define INFO_BYPASS_PWR2	0x005b	/* Bypass Power 2		*/
#define INFO_BYPASS_PWR3	0x005c	/* Bypass Power 3		*/
#define INFO_BYPASS_VOLT1	0x005d	/* Bypass Voltage 1		*/
#define INFO_BYPASS_VOLT2	0x005e	/* Bypass Voltage 2		*/
#define INFO_BYPASS_VOLT3	0x005f	/* Bypass Voltage 3		*/
#define INFO_BATT_PCT		INFO_BATTPCT	/* Estimated Charge		*/
/* use  INFO_RUNTIME            for        Estimated Minutes		*/
/* use  INFO_HIGHXFER           for        High Volt Xfer Pt            */
/* use  INFO_UPSIDENT           for        Identification               */
#define INFO_IN_CURRENT1	0x0060	/* Input Current 1		*/
#define INFO_IN_CURRENT2	0x0061	/* Input Current 2		*/
#define INFO_IN_CURRENT3	0x0062	/* Input Current 3		*/
#define INFO_IN_ACFREQ1		0x0063	/* Input Frequency 1		*/
#define INFO_IN_ACFREQ2		0x0064	/* Input Frequency 2		*/
#define INFO_IN_ACFREQ3		0x0065	/* Input Frequency 3		*/
#define INFO_IN_LINEBADS	0x0066	/* Input Line Bads		*/
#define INFO_IN_NLINES		0x0067	/* Input Num Lines		*/
#define INFO_IN_PWR1		0x0068	/* Input Power 1		*/
#define INFO_IN_PWR2		0x0069	/* Input Power 2		*/
#define INFO_IN_PWR3		0x006a	/* Input Power 3		*/
#define INFO_IN_VOLT1		0x006b	/* Input Voltage 1		*/
#define INFO_IN_VOLT2		0x006c	/* Input Voltage 2		*/
#define INFO_IN_VOLT3		0x006d	/* Input Voltage 3		*/
/* use  INFO_LOWXFER            for        Low Volt Xfer Pt             */
/* use  INFO_MFR                for        Manufacturer                 */
/* use  INFO_MODEL              for        Model                        */
#define INFO_NOM_BATTLIFE	0x006e	/* Nominal Battery Life		*/
#define INFO_NOM_IN_FREQ	0x006f	/* Nominal Input Frequency		*/
#define INFO_NOM_IN_VOLT	0x0070	/* Nominal Input Voltage	*/
#define INFO_NOM_LOBATTIME	INFO_LOBATTIME	/* Nominal Low Battery Time	*/
#define INFO_NOM_OUT_FREQ	0x0071	/* Nominal Output Frequency		*/
#define INFO_NOM_OUT_PWR	0x0072	/* Nominal Output Power		*/
#define INFO_NOM_OUT_VOLT	INFO_REQVOLT	/* Nominal Output Voltage		*/
#define INFO_NOM_VA_RATE	0x0073	/* Nominal VA Rating		*/
#define INFO_OUT_CURRENT1	0x0074	/* Output Current 1		*/
#define INFO_OUT_CURRENT2	0x0075	/* Output Current 2		*/
#define INFO_OUT_CURRENT3	0x0076	/* Output Current 3		*/
#define INFO_OUT_FREQ		0x0077	/* Output Frequency		*/
#define INFO_OUT_LOADPCT1	0x0078	/* Output Load 1			*/
#define INFO_OUT_LOADPCT2	0x0079	/* Output Load 2		*/
#define INFO_OUT_LOADPCT3	0x007a	/* Output Load 3		*/
#define INFO_OUT_NLINES		0x007b	/* Output Num Lines		*/
#define INFO_OUT_LOADPWR1	0x007c	/* Output Power 1			*/
#define INFO_OUT_LOADPWR2	0x007d	/* Output Power 2		*/
#define INFO_OUT_LOADPWR3	0x007e	/* Output Power 3		*/
#define INFO_OUT_SOURCE		0x007f	/* Output Source		*/
#define INFO_OUT_VOLT1		0x0080	/* Output Voltage 1		*/
#define INFO_OUT_VOLT2		0x0081	/* Output Voltage 2		*/
#define INFO_OUT_VOLT3		0x0082	/* Output Voltage 3		*/
#define INFO_RBTWDUR		0x0083	/* Reboot With Duration		*/
#define INFO_SECSONBATT		0x0084	/* Seconds on Battery		*/
#define INFO_SHUTTYPE		0x0085	/* Shutdown Type		*/
#define INFO_DELAYSHUT		0x0086	/* Shutdown After Delay		*/
/* use  INFO_FIRMREV            for        Software Version             */
/* use  INFO_WAKEDELAY          for        Startup After Delay          */
#define INFO_SLFTSTDETAIL	0x0087	/* Test Results Detail		*/
#define INFO_SLFTSTSUM		INFO_SLFTSTRES	/* Test Results Summary	*/
#define INFO_SLFTSTTYPE		0x0088	/* Test Type			*/
#define INFO_BAUDRATE		0x0089	/* Baud Rate			*/
#define INFO_OUT_VA			0x008a	/* Apparent Power (volts * amps)(watts) */
#define INFO_OUT_POWER		0x008b	/* Actual Power (watts) */
#define INFO_TIME				0x008c	/* Time according to the ups */
#define INFO_DATE				0x008d	/* Date according to the ups */

/* HEP 2002-04-04 */
#define INFO_LOBATTPCT          0x0090  /* Limit for raising LB flag    */
/* HEP 2002-04-08 */
#define INFO_LOTRIMXFER         0x0091  /* Lower threshold for trimming */
#define INFO_HITRIMXFER         0x0092  /* Upper threshold for trimming */
#define INFO_LOBOOSTXFER        0x0093  /* Lower threshold for boosting */
#define INFO_HIBOOSTXFER        0x0094  /* Upper threshold for boosting */
#define INFO_BATT_RUNTIME       0x00a0  /* Remaining time on batt [secs]*/

#define	INFO_SYSMASK	0xF000		/* mask for system level INFOs  */
#define	INFO_MTIME	0xFFFA		/* last modified time		*/
#define INFO_INSTCMD	0xFFFB		/* supported instant command	*/
#define INFO_ENUM	0xFFFC		/* holder for an ENUM value	*/
#define	INFO_MSGID	0xFFFD		/* message queue ID             */
#define INFO_SHMID	0xFFFE		/* shared memory struct ID      */
#define INFO_UNUSED	0xFFFF		/* this entry is not being used */

/* message queue identifiers */

#define UPSMSG_TOUPSD	0x1000		/* message to upsd from model   */
#define UPSMSG_TOMODEL	0x1001		/* message from upsd to model   */
#define UPSMSG_MAXLEN	128		/* maximum length permitted	*/

/* message queue struct commands */

#define UPSMSG_CMDMASK	0xA100		/* command mask			*/
#define UPSMSG_CMDSDD	0xA101		/* dead, replaced by instcmd    */
#define UPSMSG_CMDSET	0xA102		/* set variable to value	*/
#define UPSMSG_INSTCMD	0xA103		/* do an instant command	*/

#define UPSMSG_REPMASK	0xAE00		/* reply mask			*/
#define UPSMSG_REPOK	0xAE01		/* command completed OK		*/
#define UPSMSG_REPAGAIN 0xAE02		/* try command again		*/

#define UPSMSG_ERRMASK	0xAF00		/* error mask			*/
#define UPSMSG_ERRNI	0xAF01		/* error: cmd not implemented	*/
#define UPSMSG_ERRRO	0xAF02		/* error: read-only variable	*/
#define UPSMSG_ERRCF	0xAF03		/* error: command failed	*/

typedef struct {
	int	cmdtype;
	int	auxcmd;
	int	dlen;
	char	data[UPSMSG_MAXLEN];		/* up to dlen bytes long */
}	msgtype;

/* flags from the info array */
#define FLAG_RW		0x0001		/* variable is read/write	  */
#define FLAG_ENUM	0x0002		/* variable is an enumerated type */
#define FLAG_STRING	0x0004		/* variable is a string           */
#define FLAG_WONLY	0x0008		/* variable is write only         */

/* instant commands that models may support */
#define CMD_OFF		0x2000		/* turn the UPS load off	  */
#define CMD_ON		0x2001		/* turn the UPS load on		  */
#define CMD_SDRET	0x2002		/* shutdown+return in auxdata min */
#define CMD_BTEST0	0x2003		/* stop battery test		  */
#define CMD_BTEST1	0x2004		/* start battery test		  */
#define CMD_CAL0	0x2005		/* stop runtime calibration	  */
#define CMD_CAL1	0x2006		/* start runtime calibration	  */
#define CMD_FPTEST	0x2007		/* test the front panel		  */
#define CMD_DUMB	0x2008		/* Turn dumb			  */
#define CMD_SIMPWF	0x2009		/* Simulate power failure	  */
#define CMD_SOFTDOWN	0x200A		/* Soft shutdown		  */
#define CMD_SHUTDOWN	0x200B		/* Shutdown after grace period	  */
#define CMD_BYPASS	0x200C		/* Switch to bypass mode	  */
#define CMD_RSTMINMAX	0x200D	/* Reset min and max utility readings */

/* info access functions */

int findinfo(const itype *info, int size, int offset, int type);

#endif /* NUT_SHARED_H */
