/* Written to work with MicroDowell BBox UPS.
   This model is based on MicroDowell (www.microdowell.com) models.
    
   Copyright (C) 2000  Gilberto Iob <research@microdowell.com>
   Copyright (C) 2002  Aleksandar Topuzovic <aleksandar.topuzovic@avl.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


#define INFO_MAX 16
#include "main.h"
#include "microdowell.h"

extern	int	sddelay;

static int ups_model_ok (char *buf, unsigned buflen);
static int polling_ok (char *buf, unsigned buflen);
void instcmd (int auxcmd, int dlen, char *data);
void setvar (int auxcmd, int dlen, char *data);

void set_flag (int *val, int flag)
{
	*val = (*val |= flag);
}
        
void clear_flag (int *val, int flag)  
{
	*val = (*val ^= (*val & flag));
}

int is_set (int num, int flag)
{
	return ((num & flag) == flag);
}

static int polling_ok (char *buf, unsigned buflen) /* Everything OK!!! */
{
	if ((buflen==NUM_POLLING_BYTES) && (buf[0]==91) && (buf[NUM_POLLING_BYTES-1]==93) && (buf[1]==1))
	{
		return (1);	/* Polling OK */
	}
	else
	{
		return (0);	/* Polling FAILED */
	}
}

/*
	Indetify UPS Model and revision
*/
static int ups_model_ok (char *buf, unsigned buflen) /* Everything OK!!! */
{
	char upsSerial[5];
	int upsRelease = 0;
	
	if ((buflen==NUM_MODEL_BYTES) && (buf[0]==91) &&
	    (buf[NUM_MODEL_BYTES-1]==93) && (buf[1]==10))
	{
		if ((buf[2] == 'S') && (buf[3] == 'H'))
		{
			upsRelease = (buf[4] - '0') * 10 + buf[6] - '0';
			if (upsRelease < 40)
			{
				addinfo (INFO_MODEL, "BBox Pro PnP", FLAG_STRING, 12);
				upslogx(LOG_NOTICE, "BBox Pro PnP rev. %d on %s.\n", upsRelease, device_path);
			} else {
				addinfo (INFO_MODEL, "BBox Pro USB", FLAG_STRING, 12);
				upslogx(LOG_NOTICE, "BBox Pro USB rev. %d on %s.\n", upsRelease, device_path);
			}
			sprintf (upsSerial, "SH%c.%c", buf[4], buf[6]);
			addinfo (INFO_SERIAL, upsSerial, FLAG_STRING, 5);
			return (100 + upsRelease);
		}
		else if ((buf[2] == 'M') && (buf[3] == 'D'))
		{
			upsRelease = (buf[4] - '0') * 10 + buf[6] - '0';
			if (upsRelease < 30)
			{
				addinfo (INFO_MODEL, "BBox Interactive PnP", FLAG_STRING, 20);
				upslogx(LOG_NOTICE, "BBox Interactive PnP rev. %d on %s.\n", upsRelease, device_path);
			} else {
				addinfo (INFO_MODEL, "BBox Interactive USB", FLAG_STRING, 20);
				upslogx(LOG_NOTICE, "BBox Interactive USB rev. %d on %s.\n", upsRelease, device_path);
			}
			sprintf (upsSerial, "MD%c.%c", buf[4], buf[6]);
			addinfo (INFO_SERIAL, upsSerial, FLAG_STRING, 5);
			return (upsRelease);
		}
		else if ((buf[2] == 'B') && (buf[3] == '5'))
		{
			upsRelease = (buf[4] - '0') * 10 + buf[6] - '0';
			addinfo (INFO_MODEL, "HiBox USB", FLAG_STRING, 9);
			upslogx(LOG_NOTICE, "HiBox USB rev. %d on %s.\n", upsRelease, device_path);
			sprintf (upsSerial, "B5%c.%c", buf[4], buf[6]);			
			addinfo (INFO_SERIAL, upsSerial, FLAG_STRING, 5);
			return (upsRelease);
		}
		else	   
			return (0);
	}
	else
		return (0);
}

#if 0	/* not being used right now */
static int setupstime () /* Everything OK!!! */
{
	time_t 		now;
	struct tm	*timeptr;
	unsigned char 	upshour;
        
	time (&now);
	timeptr = localtime (&now);

        if (upssendchar (CMD_SETTIMER) != 1)
        	return (-1);
	usleep (CHAR_DELAY);
        upshour = (unsigned char) ((timeptr->tm_wday - 1) * 24 + timeptr->tm_hour);
        if (upssendchar (upshour) != 1)
        	return (-1);
	usleep (CHAR_DELAY);
        if (upssendchar ((unsigned char)timeptr->tm_min) != 1)
        	return (-1);
	usleep (CHAR_DELAY);
        if (upssendchar ((unsigned char)timeptr->tm_sec) != 1)
        	return (-1);
	usleep (CHAR_DELAY);
	
	return (1);	
}
#endif


void upsdrv_initinfo(void) /* Everything OK!!! */
{
	unsigned char 	i, ret;
	int		ret0 = 0;
        char   		raw_data[NUM_OF_BYTES_FROM_UPS];

        /* write constant data for this model */
	
	addinfo (INFO_MFR, "MicroDowell", FLAG_STRING, 12); /* OK */

        upsh.instcmd = instcmd;
/*	upsh.setvar = setvar;*/

        for (i = 0; (i < 5) && (ret0 == 0); i++)  /* Try to read from UPS 5 times */
	{
		if (upssendchar (SEND_MODEL) != 1) { /* Get model information */
			upslogx(LOG_NOTICE, "%s writing error", device_path);
		} else {
			ret = upsrecvchars(raw_data, NUM_MODEL_BYTES);	/* Read data from UPS */
			ret0 = ups_model_ok(raw_data, ret);		/* Test if UPS is OK */
		}
	}
	if (ret0 == 0) { 
		printf ("Unable to identify MicroDowell UPS connected: %d \n",ret0);
		fatalx("Unable to identify MicroDowell UPS connected");
	} else {	/* ret0 is the UPS revision number */
		myups.upsmodel = ret0;
		ret0 = 0;
        	for (i = 0; (i < 5) && (ret0 == 0); i++)  /* Try to read from UPS 5 times */
		{
			if (upssendchar (SEND_DATA) != 1) { 		/* Get UPS status (POLL) */
				upslogx(LOG_NOTICE, "%s writing error", device_path);
			} else {
				ret = upsrecvchars(raw_data, NUM_POLLING_BYTES);
				ret0 = polling_ok(raw_data, ret);
			}
		}	
	}
	
	if (ret0 == 0) {
		printf ("Unable to communicate with MicroDowell UPS connected. \n");
		fatalx("Unable to communicate with MicroDowell UPS connected");
	} else {
		printf ("Communication with MicroDowell UPS started on %s.\n", device_path);
	}
        
        /* add other things to monitor */

	addinfo (INFO_ACFREQ, "", 0, 0);		/* Mains frequency */
	addinfo (INFO_BATTVOLT, "", 0, 0);		/* Battery voltage */
	addinfo (INFO_LOADPCT, "", 0, 0);		/* Load percent */
	addinfo (INFO_STATUS, "", 0, 0);		/* UPS Status */
	addinfo (INFO_UTILITY, "", 0, 0);		/* Mains input voltage */
	addinfo (INFO_UPSTEMP, "", 0, 0);		/* UPS Temperature */
	
	addinfo(INFO_BATTPCT, "", 0, 0);		/* Battery percent */

	/* now add the instant commands */

        addinfo (INFO_INSTCMD, "", 0, CMD_ON);
        addinfo (INFO_INSTCMD, "", 0, CMD_OFF);
        addinfo (INFO_INSTCMD, "", 0, CMD_BTEST1);
	
	upsdrv_updateinfo ();
}

void upsdrv_updateinfo(void) /* Everything OK!!! */
{
        char   		raw_data[NUM_OF_BYTES_FROM_UPS];
	unsigned char 	i, ret;
	int		ret0 = 0;

	char	val[32];
	unsigned char loadpct;

	nolongertimeout ();

	for (i = 0; (i < 5) && (ret0 == 0); i++) 
		{
		if (upssendchar (SEND_DATA) != 1) { 
		   upslogx(LOG_NOTICE, "%s writing error", device_path);
		} else {
		   ret = upsrecvchars(raw_data, NUM_POLLING_BYTES);
		   ret0 = polling_ok(raw_data, ret);
		}
	}
	
	myups.acfreq = 61440.0 / ((255 - (unsigned char)raw_data[ACFREQ_H]) * 256 + (256 - (unsigned char)raw_data[ACFREQ_L]));
	setinfo(INFO_ACFREQ, "%04.1f", myups.acfreq); 
	
	myups.utility = 1.84 * (unsigned char)raw_data[UTILITY]; 
	setinfo(INFO_UTILITY, "%05.1f", myups.utility);

	myups.battvolt = (1.0 * (unsigned char)raw_data[BATTVOLT]) / 16.82;
	if (myups.upsmodel > 100)
		myups.battvolt *= 2.0;
	setinfo(INFO_BATTVOLT, "%05.2f", myups.battvolt);

	setinfo(INFO_BATTPCT, "%05.2f", 24/myups.battvolt*100);
	
	myups.loadpct = 0;
	if (myups.upsmodel > 100)
	{
		*val = 0;
		loadpct = (unsigned char)raw_data[LOADPCT];
		if (loadpct < LOAD_T0)
		{
			strcat(val, "0  ");
		}
		else if ((loadpct >= LOAD_T0) && (loadpct < LOAD_T1))
		{
			strcat(val, "25 ");
			myups.loadpct += 25;
		}
		else if ((loadpct >= LOAD_T1) && (loadpct < LOAD_T2))
		{
			strcat(val, "50 ");
			myups.loadpct += 50;
		}
		else if ((loadpct >= LOAD_T2) && (loadpct < LOAD_T3))
		{
			strcat(val, "75 ");
			myups.loadpct += 75;
		}
		else if ((loadpct >= LOAD_T3) && (loadpct < LOAD_T4))
		{
			strcat(val, "100");
			myups.loadpct += 100;
		}
		else if (loadpct >= LOAD_T4) 
		{
			strcat(val, "120");
			myups.loadpct += 120;
		}
		/*setinfo(INFO_LOADPCT, "%s", val);*/
		setinfo(INFO_LOADPCT, "%d", (int)(100./47 * loadpct));
	}
	else
	{
		*val = 0;
		myups.upstemp = 27.0;
		strcat(val, "27.0");
		setinfo(INFO_UPSTEMP, "%s", val);
	}
	
	myups.upshour = (unsigned char)raw_data[UPS_HOUR];	/* UPS internal clock */
	myups.upsmin = (unsigned char)raw_data[UPS_MIN];
	myups.upssec = (unsigned char)raw_data[UPS_SEC];
	myups.houron = (unsigned char)raw_data[UPS_HOUR_ON];
	myups.minon = (unsigned char)raw_data[UPS_MIN_ON];
	myups.houroff = (unsigned char)raw_data[UPS_HOUR_OFF];
	myups.sddelay = (unsigned char)raw_data[SD_DELAY];

	status_init();
	
	if (!(raw_data[STATUS] & MAINS_FAILURE))
	{
		status_set("OL");
		myups.battruntime = 0;
		if (!is_set(myups.status, ST_ONLINE))
		{
			set_flag (&myups.status, ST_ONLINE);
			clear_flag (&myups.status, ST_ONBATT);
		}
	}
	else 
	{
		status_set("OB");
		if (!is_set(myups.status, ST_ONBATT))
		{
			set_flag (&myups.status, ST_ONBATT);
			clear_flag (&myups.status, ST_ONLINE);
		}
		if (myups.maxbattruntime > 0) {
			if (++myups.battruntime > myups.maxbattruntime) {
				status_set("LB");
				set_flag (&myups.status, ST_LOWBATT);
			}
				
		}
	}
	
	if (raw_data[STATUS] & LOW_BAT)
	{
		status_set("LB");
		if (!is_set(myups.status, ST_LOWBATT))
		{
			set_flag (&myups.status, ST_LOWBATT);
		}
	}
	if (raw_data[STATUS] & END_BAT)
		status_set("EB");

	if (raw_data[STATUS] & HIGH_TEMP)
		status_set("HT");

	if (raw_data[STATUS] & DANGER_TEMP)
		status_set("DT");

	status_commit ();

	writeinfo();
}

void upsdrv_shutdown(void) /* Everything OK!!! */
{
        unsigned char data;
        
        printf ("Initiating forced UPS shutdown!\n");
        
        if (upssendchar (CMD_SCHEDULING) != 1)
	usleep (CHAR_DELAY);
        
        data = 255;
        if (upssendchar (data) != 1)
	usleep (CHAR_DELAY);
        
        data = 0;
        if (upssendchar (data) != 1)
	usleep (CHAR_DELAY);
        
        data = 255;
        if (upssendchar (data) != 1)
	usleep (CHAR_DELAY);
        
        if (sddelay == 0)
        	sddelay = 60;
        if ((myups.upsmodel > 21) && (myups.upsmodel <100))
        	sddelay = sddelay / 2 + 1;
        else if (myups.upsmodel > 130) 
        	sddelay = sddelay / 4 + 1;
        
        data = (unsigned char)sddelay;
        if (upssendchar (data) != 1)
	usleep (CHAR_DELAY);
        
        data = 0;
        if (upssendchar (data) != 1)
	sleep (2);
	
        if (upssendchar (CMD_STDBY) != 1)
	usleep (CHAR_DELAY);
	if (is_set(myups.status, ST_ONBATT)) {
	        if (upssendchar (CMD_BEND) != 1)
		usleep (CHAR_DELAY);
	}
}


void instcmd (int auxcmd, int dlen, char *data)
{
	/* TODO: reply to upsd? */

        switch (auxcmd) {
                case CMD_ON:        
                        break;
                case CMD_OFF:        
                        break;
                case CMD_BTEST1:
                        if (upssendchar (CMD_BATTEST) != 1)
                        	printf ("Unable to start battery test \n");
                        break;
                default:
                        upslogx(LOG_INFO, "instcmd: unknown type 0x%04x", auxcmd);
        }
}

void upsdrv_help(void)
{
        printf ("Not implemented yet:\n" );
}

void upsdrv_makevartable(void)
{
	addvar(VAR_VALUE, "linevoltage", "Specify line voltage.");
	addvar(VAR_VALUE, "batruntime", "Specify battery run time.");
}

void upsdrv_banner(void)
{
	printf("Network UPS Tools - Microdowell UPS driver 0.01 (%s)\n\n", UPS_VERSION);
}

void upsdrv_initups(void)
{
	open_serial(device_path, B1200);
}

/* tell main how many items you need */
int upsdrv_infomax(void)
{
	return 128;
}
