/* upsd.h - support structures and other minor details

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

/*
 * Much of the content from here was also useful to the
 * model drivers, so has been moved into include/shared-tables.h
 * instead of being within the daemon specific include file
 *
 */

#ifndef STANDALONE
void do_sendver (struct sockaddr_in *dest, char *arg, char *rest);
void do_sendans (struct sockaddr_in *dest, char *arg, char *rest);
void do_sendhelp (struct sockaddr_in *dest, char *arg, char *rest);
void do_listvars (struct sockaddr_in *dest, char *arg, char *rest);
void do_logout (struct sockaddr_in *dest, char *arg, char *rest);
void do_login (struct sockaddr_in *dest, char *arg, char *rest);
void do_password (struct sockaddr_in *dest, char *arg, char *rest);
void do_listrw (struct sockaddr_in *dest, char *arg, char *rest);
void do_vartype (struct sockaddr_in *dest, char *arg, char *rest);
void do_vardesc (struct sockaddr_in *dest, char *arg, char *rest);
void do_enum (struct sockaddr_in *dest, char *arg, char *rest);
void do_set (struct sockaddr_in *dest, char *arg, char *rest);
void do_instcmd (struct sockaddr_in *dest, char *arg, char *rest);
void do_listinstcmd (struct sockaddr_in *dest, char *arg, char *rest);
void do_instcmddesc (struct sockaddr_in *dest, char *arg, char *rest);
void do_fsd (struct sockaddr_in *dest, char *arg, char *rest);
void do_master (struct sockaddr_in *dest, char *arg, char *rest);

/* netcmds[] - map net commands to functions */

struct {
	char	*name;
	void	(*func)(struct sockaddr_in *dest, char *arg, char *rest);
}	netcmds[] =
{
	{ "VER",	do_sendver		},
	{ "REQ",	do_sendans		},
	{ "HELP",	do_sendhelp		},
	{ "LISTVARS",	do_listvars		},
	{ "LOGOUT", 	do_logout		},
	{ "LOGIN",	do_login		},
	{ "PASSWORD",	do_password		},
	{ "LISTRW",	do_listrw		},
	{ "VARTYPE",	do_vartype		},
	{ "VARDESC",	do_vardesc		},
	{ "ENUM",	do_enum			},
	{ "SET",	do_set			},
	{ "INSTCMD",	do_instcmd		},
	{ "LISTINSTCMD",do_listinstcmd		},
	{ "INSTCMDDESC",do_instcmddesc		},
	{ "FSD",	do_fsd			},
	{ "MASTER",	do_master		},
	{ NULL,		(void(*)())(NULL)	}
};

#endif
