/* statedebug.c - debugging tool for writing support programs

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "config.h"
#include "shared.h"
#include <netinet/in.h>
#define STANDALONE
#include "upsd.h"
#include "proto.h"

/* dummy funcs to keep upsd.h stuff happy */
void sendver (struct sockaddr_in *dest, char *arg) {}
void sendans (struct sockaddr_in *dest, char *arg) {}
void sendhelp (struct sockaddr_in *dest, char *arg) {}
void listvars (struct sockaddr_in *dest, char *arg) {}

char *fname (int cmdnum)
{
	int	i;

	for (i = 0; netvars[i].name != NULL; i++)
		if (netvars[i].type == cmdnum)
			return (netvars[i].name);

	return (strdup ("UNKNOWN"));
}

void display (char *fn)
{
	itype	info;
	int	ifd, ret, i, count;

	ifd = open (fn, O_RDONLY);
	if (ifd < 0) {
		perror ("open");
		exit (1);
	}

	ret = read (ifd, &info, sizeof(itype));
	if (ret < 1) {
		perror ("read");
		exit (1);
	}

	if (info.type == INFO_SHMID) {
		printf ("Shared memory ID: %s\n", info.value);
		close (ifd);
		return;
	}

	count = atoi(info.value);
	for (i = 0; i < count - 1; i++) {
		ret = read (ifd, &info, sizeof(itype));
		printf ("%2i: %15s = %s\n", i, fname(info.type), info.value);
	}

	close (ifd);

	return;
}

int main (int argc, char **argv)
{
	struct	stat fs;
	int 	lastmtime = 0;
        int continuous = 0;
        char *file;

       if (argc != 2 && argc != 3) {
            printf ("usage: %s [-c] <state file>\n", argv[0]);
            printf("use -c for continuous read (with 30s delay)\n");
            exit (1);
        }

        if (!strncmp(argv[1], "-c", 2)) {
            file = argv[2];
            continuous = 1;
        } else
            file = argv[1];

       do {
           if (stat (file, &fs)) {
               perror ("stat");
               exit (1);
           }

           if (fs.st_mtime != lastmtime) {
               lastmtime = fs.st_mtime;
               printf ("\n");
               display (file);
           }
           if (continuous)
               sleep(30);

       } while (continuous);

	return 0;
}
