/* mustekups.h - model capability table

   Copyright (C) 2000 Jeremy Maccelari <visualn@iafrica.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              

   This is a direct hack of the fentonups.h file written by Russell
   Kroll. I have taken the structure and used it to support Mustek UPSes.

   I have taken what specs I have from the manual and the rest are
   either measured on a 425 or 1400 or guessed.

*/

struct {
	char	*mtext;
	char	*desc;
	float	lowvolt;
	float	voltrange;
	int	lowxfer;
	int	lownorm;
	int	highnorm;
	int	highxfer;
	int	has_temp;
}	modeltab[] =
{
	/* Mustek Electronics RSA models */
	{ "Pro 280", "Mustek Pro 280", 10.5, 1.5, 200, 210, 230, 240, 1 },
	{ "Pro 425", "Mustek Pro 425", 10.5, 1.5, 200, 210, 230, 240, 1 },
	{ "Pro 650", "Mustek Pro 650", 10.5, 1.5, 200, 210, 230, 240, 1 },
	{ "Pro 800", "Mustek Pro 800", 10.5, 1.5, 200, 210, 230, 240, 1 },
	{ "Pro 1100", "Mustek Pro 1100", 21.5, 2.5, 200, 210, 230, 240, 1 },
	{ "Pro 1400", "Mustek Pro 1400", 21.5, 2.5, 200, 210, 230, 240, 1 },
	{ NULL,    NULL,		  0, 0,   0,   0,   0,   0, 0 }
};
