/* apcsmart.h - serial commands for APC smart protocol units

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

#define GO_SMART	'Y'
#define REQ_MODEL	0x01	/* ^A */
#define REQ_SERIAL	'n'
#define REQ_UTILITY	'L'
#define REQ_BATTPCT	'f'
#define REQ_STATUS	'Q'
#define REQ_UPSTEMP	'C'
#define REQ_ACFREQ	'F'
#define REQ_LOADPCT	'P'
#define REQ_LOWXFER	'l'
#define REQ_HIGHXFER	'u'
#define REQ_AMBHUMID	'h'
#define REQ_CONTACTS    'i'
#define REQ_AMBTEMP	't'
#define REQ_UPSIDENT	'c'
#define REQ_WAKEDELAY   'r'
#define REQ_LINESENS	's'
#define REQ_BATTDATE	'x'
#define REQ_BATTVOLT	'B'
#define REQ_OUTVOLT	'O'
#define REQ_CAPABILITIES 26
#define NEXT_VAL	'-'
#define REQ_FPTEST	'A'
#define REQ_BTEST	'U'
#define REQ_SOFTDOWN	'S'
#define REQ_SHUTDOWN	'K'
#define REQ_OFF		'Z'
#define REQ_ON		0x0E	/* ^N */
#define REQ_CAL		'D'
#define ENDCHAR 10		/* APC ends responses with LF */
#define IGNCHARS "\015+$|!"	/* special characters to ignore */

/* dangerous instant commands must be reconfirmed within a 12 second window */
#define CONFIRM_DANGEROUS_COMMANDS 1
#define MINCMDTIME	3
#define MAXCMDTIME	15
