/* shared-tables.h - tables of info from shared.h, but 
   prolly only used for info output/parsing

   Copyright (C) 2000 Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

/* Originally in upsd.h, separated out because I wanted the text
   strings while working on table driven stuff in the apc-smart
   module
	Nigel Metheringham <Nigel.Metheringham@vdata.co.uk>
*/

/* netvars[] - map text strings from the network to internal identifiers */

struct netvars_t {
	char	*name;
	int	type;
	char	*desc;
}	netvars[] =
{
	{ "MFR",	INFO_MFR,	"Manufacturer"		},
	{ "MODEL",	INFO_MODEL,	"Model"			},
	{ "SERIAL",	INFO_SERIAL,	"Serial number"		},
	{ "UTILITY",	INFO_UTILITY,	"Utility voltage"	},
	{ "BATTPCT",	INFO_BATTPCT,	"Battery percentage"	},
	{ "STATUS",	INFO_STATUS,	"Status"		},
	{ "UPSTEMP",	INFO_UPSTEMP,	"UPS temperature"	},
	{ "ACFREQ",	INFO_ACFREQ,	"AC frequency"		},
	{ "LOADPCT",	INFO_LOADPCT,	"Load percentage"	},
	{ "LOWXFER", 	INFO_LOWXFER,	"Low transfer voltage"	},
	{ "HIGHXFER",	INFO_HIGHXFER,	"High transfer voltage"	},
	{ "AMBHUMID",	INFO_AMBHUMID,	"Ambient humidity"	},
	{ "AMBTEMP",	INFO_AMBTEMP,	"Ambient temperature"	},
	{ "CONTACTS",   INFO_CONTACTS,  "Dry contacts"		},
	{ "UPSIDENT",	INFO_UPSIDENT,	"UPS identification"	},
	{ "WAKEDELAY",	INFO_WAKEDELAY,	"Wake-up delay"		},
	{ "LINESENS",	INFO_LINESENS,	"Line sensitivity"	},
	{ "WAKETHRSH",	INFO_WAKETHRSH,	"Battery powerup thres" },
	{ "REQVOLT",	INFO_REQVOLT,	"Requested output volts"},
	{ "LOBATTIME",	INFO_LOBATTIME,	"Battery time before LB"},
	{ "PDNGRACE",	INFO_PDNGRACE,	"Delay on powerdown"	},
	{ "ALRMDELAY",	INFO_ALRMDELAY,	"Delay before alert"	}, 
	{ "SLFTSTINT",	INFO_SLFTSTINT,	"Selftest intervals"	},
	{ "FIRMREV",	INFO_FIRMREV,	"Firmware revision" 	},
	{ "OUTVOLT",	INFO_OUTVOLT,	"Output voltage"	},
	{ "REG1",	INFO_REG1,	"Register 1"		},
	{ "REG2",	INFO_REG2,	"Register 2"		},
	{ "REG3",	INFO_REG3,	"Register 3"		},
	{ "LINEQUAL",	INFO_LINEQUAL,	"Line quality"		},
	{ "BATTPACKS",	INFO_BATTPACKS,	"Installed battery packs"	},
	{ "BATTVOLT",	INFO_BATTVOLT,	"Current battery voltage"	},
	{ "XFERWHY",	INFO_XFERWHY,	"Reason for last transfer"	},
	{ "MAXUTIL",	INFO_MAXUTIL,	"Max utility voltage seen"	},
	{ "MINUTIL",	INFO_MINUTIL,	"Min utility voltage seen"	},
	{ "SLFTSTRES",	INFO_SLFTSTRES,	"Last self test result"		},
	{ "RUNTIME",	INFO_RUNTIME,	"Predicted runtime on batt"	},
	{ "MFRDATE",	INFO_MFRDATE,	"Manufacturing date"	},
	{ "BATTDATE",	INFO_BATTDATE,	"Battery change date"	},
	{ "TEMPMAX",	INFO_TEMPMAX,	"Max temperature setting"	},
	{ "TEMPMIN",	INFO_TEMPMIN,	"Min temperature setting"	},
	{ "HUMDMAX",	INFO_HUMDMAX,	"Max humidity setting"	},
	{ "HUMDMIN",	INFO_HUMDMIN,	"Min humidity setting"	},
	{ "FIRMREV1",	INFO_FIRMREV1,	"Firmware revision (more)"	},
	{ "FIRMREV2",	INFO_FIRMREV2,	"Firmware revision (aux device)"},
	{ "NOMBATVLT",	INFO_NOMBATVLT,	"Nominal battery voltage"	},
	{ "COPYRIGHT",	INFO_COPYRIGHT,	"UPS F/W Copyright Info"	},
	{ "DIPSWCH",	INFO_DIPSWCH,	"DIPSWCH"	},
	{ "OUTVLTSEL",	INFO_OUTVLTSEL,	"Output voltage selection"	},
	{ "CURRENT",	INFO_CURRENT,	"Output Load Current"	},
	{ "LOADPWR",	INFO_LOADPWR,	"Apparent load power %"	},
	{ "LANGUAGE",	INFO_LANGUAGE,	"Front panel language"	},
	{ "BADPACKS",	INFO_BADPACKS,	"Bad battery packs installed"	},
	{ "ALRMENA",	INFO_ALRMENA,	"Alarm enable"		},
	{ "ALRMSTAT",	INFO_ALRMSTAT,	"Alarm status"		},
	{ "AMBTEMP2",	INFO_AMBTEMP2,	"AMBTEMP2"		},
	{ "AMBHUMID2",	INFO_AMBHUMID2,	"AMBHUMID2"		},

	{ NULL,		INFO_UNUSED, 	NULL			}
};


/* instcmds[] - instant commands sent via SysV IPC msg queues */
struct instcmds_t {
	char	*name;
	int	cmd;
	char	*desc;
}	instcmds[] =
{
	{ "FPTEST",	CMD_FPTEST,	"Front panel test"		},
	{ "BTEST0",	CMD_BTEST0,	"Stop battery test"		},
	{ "BTEST1",	CMD_BTEST1,	"Start battery test"		},
	{ "OFF",	CMD_OFF,	"Turn off load"			},
	{ "ON",		CMD_ON,		"Turn on load"			},
	{ "CAL0",	CMD_CAL0,	"Stop runtime calibration"	},
	{ "CAL1",	CMD_CAL1,	"Start runtime calibration"	},
	{ "SDRET",	CMD_SDRET,	"Shutdown+return in auxdata min"},
	{ "DUMB",	CMD_DUMB,	"Turn dumb" 			},
	{ "SIMPWF",	CMD_SIMPWF,	"Simulate power failure"	},
	{ "SOFTDOWN",	CMD_SOFTDOWN,	"Soft shutdown"			},
	{ "SHUTDOWN",	CMD_SHUTDOWN,	"Shutdown after grace period" 	},
	{ "BYPASS",	CMD_BYPASS,	"Switch to Bypass mode" 	},
	{ NULL,		0,		NULL				}
};
