/* upscmd - simple "client" to test instant commands via upsd

   Copyright (C) 2000  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

#include <pwd.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include "common.h"
#include "upsfetch.h"
#include "proto.h"

	int	fd;

void usage (char *prog)
{
	printf ("usage: %s [-l] <ups> [<cmd>]\n", prog);
	exit (1);
}

void listvars (char *rawname)
{
	char	buf[SMALLBUF], buf2[SMALLBUF], *ptr, *upsname, *host, *tmp, *savename,
		*q, *desc;

	savename = strdup (rawname);

	/* handle upsname@hostname syntax and split up parts */
	ptr = strchr (rawname, '@');
	if (ptr != NULL) {
		*ptr = '\0';
		upsname = rawname;
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = rawname;
	}

	fd = upsconnect (host);
	if (fd < 0) {
		printf ("Unable to connect to %s - %s\n", host,
		        upsstrerror(upserror));
		exit (1);
	}

	if (upsname)
		snprintf (buf, sizeof(buf), "LISTINSTCMD %s\n", upsname);
	else
		snprintf (buf, sizeof(buf), "LISTINSTCMD\n");

	upssendraw (fd, buf);

	if (upsreadraw (fd, buf, sizeof(buf)) < 0) {
		printf ("List instant commands failed: %s\n", 
		        upsstrerror(upserror));
		exit (1);
	}
	
	if (strncmp("INSTCMDS", buf, 7)) {
		printf ("Invalid response from server: %s", buf);
		exit (1);
	}

	/* INSTCMDS <cmd1> <cmd2> ... <cmdn> */

	/* point at first instant command */
	ptr = strchr (buf, ' ');

	if (!ptr) {
		printf ("No instant commands are supported on UPS [%s]\n",
		        savename);
		exit (0);
	}

	ptr++;

	/* INSTCMDS <@ups> ... - may skip another word */
	if (ptr[0] == '@') {
		ptr = strchr (ptr, ' ');
		if (!ptr) {
			printf ("No instant commands found on this UPS!\n");
			exit (0);
		}
		ptr++;
	}

	printf ("Instant commands supported on UPS [%s]:\n\n", savename);

	while (ptr) {
		tmp = ptr;
		ptr = strchr (tmp, ' ');
		if (ptr) {
			*ptr = '\0';
			ptr++;
		}

		printf ("%s - ", tmp);

		/* now get description for this command */

		snprintf (buf2, sizeof(buf2), "INSTCMDDESC %s\n", tmp);
		upssendraw (fd, buf2);

		if (upsreadraw (fd, buf2, sizeof(buf2)) < 0) {
			printf ("Description fetch failed: %s\n", 
			        upsstrerror(upserror));
			continue;
		}

		q = strchr (buf2, '"');
		if (!q) {
			printf ("Invalid description received from server (1)\n");
			continue;
		}

		desc = ++q;
		q = strchr (desc, '"');
		if (!q) {
			printf ("Invalid description received from server (2)\n");
			continue;
		}

		*q = '\0';
		printf ("%s\n", desc);
	}

	exit (0);
}

int main (int argc, char **argv)
{
	char	*upsname, *ptr, *host, *prog, buf[SMALLBUF], *pw;
	int	i;

	prog = argv[0];

	while ((i = getopt(argc, argv, "+l:h")) != EOF) {
		switch (i) {
			case 'l':
				listvars (optarg);
				break;
			case 'h':
			default:
				usage (prog);
				break;
		}
	}

	argc -= optind;
	argv += optind;

	if (argc < 2)
		usage(prog);

	/* handle upsname@hostname syntax and split up parts */
	ptr = strstr (argv[0], "@");
	if (ptr != NULL) {
		ptr[0] = 0;
		upsname = argv[0];
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = argv[0];
	}

	fd = upsconnect (host);
	if (fd < 0) {
		printf ("Unable to connect to %s - %s\n", host,
		        upsstrerror(upserror));
		exit (1);
	}

	pw = getpass ("Password: ");

	snprintf (buf, sizeof(buf), "PASSWORD %s\n", pw);
	upssendraw (fd, buf);

	if (upsreadraw (fd, buf, sizeof(buf)) < 0) {
		printf ("Set password failed: %s\n", upsstrerror(upserror));
		exit (1);
	}

	if (upsname)
		snprintf (buf, sizeof(buf), "INSTCMD %s@%s\n", argv[1], 
		          upsname);
	else
		snprintf (buf, sizeof(buf), "INSTCMD %s\n", argv[1]);

	upssendraw (fd, buf);

	if (upsreadraw (fd, buf, sizeof(buf)) < 0) {
		printf ("Instant command failed: %s\n", upsstrerror(upserror));
		exit (1);
	}
	
	return (0);
}
