/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                        Stefano Suin <stefano@unipi.it>
 *                        (Stefano contributed to version 1.0)
 *                      
 * 			  Centro SERRA, University of Pisa
 * 			  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ntop.h"

/*
*********************************************************
 * 
 * The information contained in this file 
 * has been provided by Ethernet-codes@Cavebear.com.
 *
 * http://www.cavebear.com/CaveBear/Ethernet/vendor.html
 *
 * Courtesy of "William R. McDonough" <wrmcd@wilmcd.com>.
 *
 * ******************************************************
 */

extern unsigned int webMode;

typedef struct {
  unsigned long vendorId;
  char* vendorName;
} VendorInfo;

static VendorInfo vendorInfo[] = {
  { 0x000001, "SuperLAN-2U" },
  { 0x000002, "BBN (was internal usage only, no longer used)" },
  { 0x000009, "powerpipes?" },
  { 0x00000C, "Cisco" },
  { 0x00000E, "Fujitsu" },
  { 0x00000F, "NeXT" },
  { 0x000010, "Hughes LAN Systems (formerly Sytek)" },
  { 0x000011, "Tektronix" },
  { 0x000015, "Datapoint Corporation" },
  { 0x000018, "Webster Computer Corporation, Appletalk/Ethernet Gateway" },
  { 0x00001A, "AMD (?)" },
  { 0x00001B, "Novell (now Eagle Technology)" },
  { 0x00001C, "JDR Microdevices, generic, NE2000 drivers" },
  { 0x00001D, "Cabletron" },
  { 0x00001F, "Cryptall Communications Corp." },
  { 0x000020, "DIAB (Data Intdustrier AB)" },
  { 0x000021, "SC&C (PAM Soft&Hardware also reported)" },
  { 0x000022, "Visual Technology" },
  { 0x000023, "ABB Automation AB, Dept. Q" },
  { 0x000024, "Olicom" },
  { 0x000029, "IMC" },
  { 0x00002A, "TRW" },
  { 0x00002C, "NRC - Network Resources Corporation - MultiGate Hub1+, Hub2, etc" },
  { 0x000032, "GPT Limited (reassigned from GEC Computers Ltd)" },
  { 0x000037, "Oxford Metrics Ltd" },
  { 0x00003B, "Hyundai/Axil Sun clones" },
  { 0x00003C, "Auspex" },
  { 0x00003D, "AT&T" },
  { 0x00003F, "Syntrex Inc" },
  { 0x000044, "Castelle" },
  { 0x000046, "ISC-Bunker Ramo, An Olivetti Company" },
  { 0x000048, "Epson" },
  { 0x000049, "Apricot Ltd." },
  { 0x00004B, "APT-ICL also reported" },
  { 0x00004C, "NEC Corporation" },
  { 0x00004F, "Logicraft 386-Ware P.C. Emulator" },
  { 0x000051, "Hob Electronic Gmbh & Co. KG" },
  { 0x000052, "Optical Data Systems" },
  { 0x000055, "AT&T" },
  { 0x000058, "Racore Computer Products Inc" },
  { 0x00005A, "SK (Schneider & Koch in Europe and Syskonnect outside of Europe)" },
  { 0x00005A, "Xerox 806 (unregistered)" },
  { 0x00005B, "Eltec" },
  { 0x00005D, "RCE" },
  { 0x00005E, "U.S. Department of Defense (IANA)" },
  { 0x00005F, "Sumitomo" },
  { 0x000061, "Gateway Communications" },
  { 0x000062, "Honeywell" },
  { 0x000063, "Hewlett-Packard, LanProbe" },
  { 0x000064, "Yokogawa Digital Computer Corp" },
  { 0x000065, "Network General" },
  { 0x000066, "Talaris" },
  { 0x000068, "Rosemount Controls" },
  { 0x000069, "Concord Communications, Inc (although someone said Silicon Graphics)" },
  { 0x00006B, "MIPS" },
  { 0x00006D, "Case" },
  { 0x00006E, "Artisoft, Inc." },
  { 0x00006F, "Madge Networks Ltd., Token-ring adapters" },
  { 0x000073, "DuPont" },
  { 0x000075, "Bell Northern Research (BNR)" },
  { 0x000077, "Interphase, [Used in other systems, e.g. MIPS, Motorola]" },
  { 0x000078, "Labtam Australia" },
  { 0x000079, "Networth Incorporated, [bought by Compaq, used in Netelligent series]" },
  { 0x00007A, "Ardent" },
  { 0x00007B, "Research Machines" },
  { 0x00007D, "Cray Research Superservers,Inc, [Also Harris (3M) (old)]" },
  { 0x00007E, "NetFRAME multiprocessor network servers" },
  { 0x00007F, "Linotype-Hell AG, Linotronic typesetters" },
  { 0x000080, "Cray Communications" },
  { 0x000081, "Synoptics" },
  { 0x000083, "Olicom" },
  { 0x000084, "Aquila (?), ADI Systems Inc.(?)" },
  { 0x000086, "Gateway Communications Inc. (then Megahertz & now 3Com)" },
  { 0x000087, "Hitachi" },
  { 0x000089, "Cayman Systems Gatorbox" },
  { 0x00008A, "Datahouse Information Systems" },
  { 0x00008E, "Solbourne(?), Jupiter(?) (I've had confirming mail on Solbourne)" },
  { 0x000092, "Unisys, Cogent (both reported)" },
  { 0x000093, "Proteon" },
  { 0x000094, "Asante MAC" },
  { 0x000095, "Sony/Tektronix" },
  { 0x000097, "Epoch" },
  { 0x000098, "Cross Com" },
  { 0x000099, "Memorex Telex Corporations" },
  { 0x00009F, "Ameristar Technology" },
  { 0x0000A0, "Sanyo Electronics" },
  { 0x0000A2, "Wellfleet" },
  { 0x0000A3, "Network Application Technology (NAT)" },
  { 0x0000A4, "Acorn" },
  { 0x0000A5, "Compatible Systems Corporation" },
  { 0x0000A6, "Network General (internal assignment, not for products)" },
  { 0x0000A7, "Network Computing Devices (NCD) X-terminals" },
  { 0x0000A8, "Stratus Computer, Inc." },
  { 0x0000A9, "Network Systems" },
  { 0x0000AA, "Xerox Xerox machines" },
  { 0x0000AC, "Conware Netzpartner, [had Apollo, claimed incorrect]" },
  { 0x0000AE, "Dassault Automatismes et Telecommunications" },
  { 0x0000AF, "Nuclear Data Acquisition Interface Modules (AIM)" },
  { 0x0000B0, "RND (RAD Network Devices)" },
  { 0x0000B1, "Alpha Microsystems Inc." },
  { 0x0000B3, "CIMLinc" },
  { 0x0000B4, "Edimax" },
  { 0x0000B5, "Datability Terminal Servers" },
  { 0x0000B6, "Micro-matic Research" },
  { 0x0000B7, "Dove Fastnet" },
  { 0x0000BB, "TRI-DATA Systems Inc., Netway products, 3274 emulators" },
  { 0x0000BC, "Allen-Bradley" },
  { 0x0000C0, "Western Digital now SMC (Std. Microsystems Corp.)" },
  { 0x0000C1, "Olicom A/S" },
  { 0x0000C5, "Farallon Computing Inc" },
  { 0x0000C6, "HP Intelligent Networks Operation (formerly Eon Systems)" },
  { 0x0000C8, "Altos" },
  { 0x0000C9, "Emulex Terminal Servers, Print Servers" },
  { 0x0000CA, "LANcity Cable Modems (now owned by BayNetworks)" },
  { 0x0000CC, "Densan Co., Ltd." },
  { 0x0000CD, "Industrial Research Limited" },
  { 0x0000D0, "Develcon Electronics, Ltd." },
  { 0x0000D1, "Adaptec, Inc. Nodem product" },
  { 0x0000D2, "SBE Inc" },
  { 0x0000D3, "Wang Labs" },
  { 0x0000D4, "PureData" },
  { 0x0000D7, "Dartmouth College (NED Router)" },
  { 0x0000D8, "old Novell NE1000's (before about 1987?) (also 3Com)" },
  { 0x0000DD, "Gould" },
  { 0x0000DE, "Unigraph" },
  { 0x0000E1, "Hitachi (laptop built-in)" },
  { 0x0000E2, "Acer Counterpoint" },
  { 0x0000E3, "Integrated Micro Products Ltd" },
  { 0x0000E4, "mips?" },
  { 0x0000E6, "Aptor Produits De Comm Indust" },
  { 0x0000E8, "Accton Technology Corporation" },
  { 0x0000E9, "ISICAD, Inc." },
  { 0x0000ED, "April" },
  { 0x0000EE, "Network Designers Limited [also KNX Ltd, a former division]" },
  { 0x0000EF, "Alantec (now owned by ForeSystems)" },
  { 0x0000F0, "Samsung" },
  { 0x0000F2, "Spider Communications, (Montreal, not Spider Systems)" },
  { 0x0000F3, "Gandalf Data Ltd. - Canada" },
  { 0x0000F4, "Allied Telesis, Inc." },
  { 0x0000F6, "A.M.C. (Applied Microsystems Corp.)" },
  { 0x0000F8, "DEC" },
  { 0x0000FB, "Rechner zur Kommunikation" },
  { 0x0000FD, "High Level Hardware (Orion, UK)" },
  { 0x0000FF, "Camtec Electronics (UK) Ltd." },
  { 0x000102, "BBN internal usage (not registered)" },
  { 0x000143, "IEEE 802" },
  { 0x000150, "Megahertz (now 3Com) modem" },
  { 0x000163, "NDC (National Datacomm Corporation)" },
  { 0x000168, "W&G (Wandel & Goltermann) [incorrect according to W&G]" },
  { 0x0001C8, "Thomas Conrad Corp." },
  { 0x0001FA, "Compaq (PageMarq printers)" },
  { 0x000204, "Novell NE3200" },
  { 0x000205, "Hamilton (Sparc Clones)" },
  { 0x000216, "ESI (Extended Systems, Inc) print servers" },
  { 0x000288, "Global Village (PCcard in Mac portable)" },
  { 0x0003C6, "Morning Star Technologies Inc" },
  { 0x000400, "Lexmark (Print Server)" },
  { 0x0004AC, "IBM PCMCIA Ethernet adapter." },
  { 0x000502, "Apple (PCI bus Macs)" },
  { 0x00059A, "PowerComputing (Mac clone)" },
  { 0x0005A8, "PowerComputing Mac clones" },
  { 0x00060D, "Hewlett-Packard JetDirect token-ring interfaces" },
  { 0x000629, "IBM RISC6000 system" },
  { 0x00067C, "Cisco" },
  { 0x0006C1, "Cisco" },
  { 0x000701, "Racal-Datacom" },
  { 0x00070D, "Cisco 2511 Token Ring" },
  { 0x000852, "Technically Elite Concepts" },
  { 0x000855, "Fermilab" },
  { 0x0008C7, "Compaq" },
  { 0x00100B, "Cisco Systems Catalyst 2924-XL" },
  { 0x00100D, "Cisco Systems Catalyst 2924-XL" },
  { 0x001011, "Cisco Systems Cisco 75xx" },
  { 0x00101F, "Cisco Systems Catalyst 2901" },
  { 0x00102F, "Cisco Systems Cisco 5000" },
  { 0x00104B, "3Com 3C905-TX PCI" },
  { 0x00105A, "3Com Fast Etherlink XL in a Gateway 2000" },
  { 0x001079, "Cisco 5500 Router" },
  { 0x00107A, "Ambicom (was Tandy?)" },
  { 0x00107B, "Cisco Systems" },
  { 0x0010A4, "Xircom RealPort 10/100 PC Card" },
  { 0x0010A6, "Cisco" },
  { 0x0010D7, "Argosy EN 220 Fast Ethernet PCMCIA" },
  { 0x0010F6, "Cisco" },
  { 0x001700, "Kabel" },
  { 0x002000, "Lexmark (Print Server)" },
  { 0x002005, "simpletech" },
  { 0x002008, "Cable & Computer Technology" },
  { 0x00200C, "Adastra Systems Corp" },
  { 0x002011, "Canopus Co Ltd" },
  { 0x002017, "Orbotech" },
  { 0x002018, "Realtek" },
  { 0x00201A, "Nbase" },
  { 0x002025, "Control Technology Inc (Industrial Controls and Network Interfaces)" },
  { 0x002028, "Bloomberg" },
  { 0x00202B, "ATML (Advanced Telecommunications Modules, Ltd.)" },
  { 0x002035, "IBM - mainframes, Etherjet printers" },
  { 0x002036, "BMC Software" },
  { 0x002042, "Datametrics Corp" },
  { 0x002045, "SolCom Systems Limited" },
  { 0x002048, "Fore Systems Inc" },
  { 0x00204B, "Autocomputer Co Ltd" },
  { 0x00204C, "Mitron Computer Pte Ltd" },
  { 0x002056, "Neoproducts" },
  { 0x002061, "Dynatech Communications Inc" },
  { 0x002063, "Wipro Infotech Ltd" },
  { 0x002066, "General Magic Inc" },
  { 0x002067, "Node Runner Inc" },
  { 0x00206B, "Minolta Co., Ltd, Network printers" },
  { 0x002078, "Runtop Inc" },
  { 0x002085, "3Com SuperStack II UPS management module" },
  { 0x00208A, "Sonix Communications Ltd" },
  { 0x00208B, "Focus Enhancements" },
  { 0x00208C, "Galaxy Networks Inc" },
  { 0x002094, "Cubix Corporation" },
  { 0x0020A5, "Newer Technology" },
  { 0x0020A6, "Proxim Inc" },
  { 0x0020AF, "3Com Corporation" },
  { 0x0020B6, "Agile Networks Inc" },
  { 0x0020B9, "Metricom, Inc." },
  { 0x0020C5, "Eagle NE2000" },
  { 0x0020C6, "NECTEC" },
  { 0x0020D0, "Versalynx Corp. The One Port terminal server" },
  { 0x0020D2, "RAD Data Communications Ltd" },
  { 0x0020D3, "OST (Ouet Standard Telematique)" },
  { 0x0020D8, "NetWave" },
  { 0x0020DA, "Xylan" },
  { 0x0020DC, "Densitron Taiwan Ltd" },
  { 0x0020E0, "PreMax PE-200 (PCMCIA NE2000-clone card, sold by InfoExpress)" },
  { 0x0020E5, "Apex Data" },
  { 0x0020EE, "Gtech Corporation" },
  { 0x0020F6, "Net Tek & Karlnet Inc" },
  { 0x0020F8, "Carrera Computers Inc" },
  { 0x0020FC, "Matrox" },
  { 0x004001, "Zero One Technology Co Ltd (ZyXEL?)" },
  { 0x004005, "TRENDware International Inc.; Linksys; Simple Net; all three reported" },
  { 0x004009, "Tachibana Tectron Co Ltd" },
  { 0x00400B, "Crescendo (now owned by Cisco)" },
  { 0x00400C, "General Micro Systems, Inc." },
  { 0x00400D, "LANNET Data Communications" },
  { 0x004010, "Sonic Mac Ethernet interfaces" },
  { 0x004011, "Facilities Andover Environmental Controllers" },
  { 0x004013, "NTT Data Communication Systems Corp" },
  { 0x004014, "Comsoft Gmbh" },
  { 0x004015, "Ascom" },
  { 0x004017, "XCd XJet - HP printer server card" },
  { 0x00401C, "AST Pentium/90 PC (emulating AMD EISA card)" },
  { 0x00401F, "Colorgraph Ltd" },
  { 0x004020, "Pilkington Communication" },
  { 0x004023, "Logic Corporation" },
  { 0x004025, "Molecular Dynamics" },
  { 0x004026, "Melco Inc" },
  { 0x004027, "SMC Massachusetts" },
  { 0x004028, "Netcomm" },
  { 0x00402A, "Canoga-Perkins" },
  { 0x00402B, "TriGem" },
  { 0x00402F, "Xlnt Designs Inc (XDI)" },
  { 0x004030, "GK Computer" },
  { 0x004032, "Digital Communications" },
  { 0x004033, "Addtron Technology Co., Ltd." },
  { 0x004036, "TribeStar" },
  { 0x004039, "Optec Daiichi Denko Co Ltd" },
  { 0x00403C, "Forks, Inc." },
  { 0x004041, "Fujikura Ltd." },
  { 0x004043, "Nokia Data Communications" },
  { 0x004048, "SMD Informatica S.A." },
  { 0x00404C, "Hypertec Pty Ltd." },
  { 0x00404D, "Telecomm Techniques" },
  { 0x00404F, "Space & Naval Warfare Systems" },
  { 0x004050, "Ironics, Incorporated" },
  { 0x004052, "Star Technologies Inc" },
  { 0x004053, "Datum [Bancomm Division] TymServe 2000" },
  { 0x004054, "Thinking Machines Corporation" },
  { 0x004057, "Lockheed-Sanders" },
  { 0x004059, "Yoshida Kogyo K.K." },
  { 0x00405B, "Funasset Limited" },
  { 0x00405D, "Star-Tek Inc" },
  { 0x004066, "Hitachi Cable, Ltd." },
  { 0x004067, "Omnibyte Corporation" },
  { 0x004068, "Extended Systems" },
  { 0x004069, "Lemcom Systems Inc" },
  { 0x00406A, "Kentek Information Systems Inc" },
  { 0x00406E, "Corollary, Inc." },
  { 0x00406F, "Sync Research Inc" },
  { 0x004072, "Applied Innovation" },
  { 0x004074, "Cable and Wireless" },
  { 0x004076, "AMP Incorporated" },
  { 0x004078, "Wearnes Automation Pte Ltd" },
  { 0x00407F, "Agema Infrared Systems AB" },
  { 0x004082, "Laboratory Equipment Corp" },
  { 0x004085, "SAAB Instruments AB" },
  { 0x004086, "Michels & Kleberhoff Computer" },
  { 0x004087, "Ubitrex Corporation" },
  { 0x004088, "Mobuis NuBus (Mac) combination video/EtherTalk" },
  { 0x00408A, "TPS Teleprocessing Sys. Gmbh" },
  { 0x00408C, "Axis Communications AB" },
  { 0x00408E, "CXR/Digilog" },
  { 0x00408F, "WM-Data Minfo AB" },
  { 0x004090, "Ansel Communications - PC NE2000 compatible twisted-pair ethernet cards" },
  { 0x004091, "Procomp Industria Eletronica" },
  { 0x004092, "ASP Computer Products, Inc." },
  { 0x004094, "Shographics Inc" },
  { 0x004095, "Eagle Technologies [UMC also reported]" },
  { 0x004096, "Telesystems SLW Inc" },
  { 0x00409A, "Network Express Inc" },
  { 0x00409C, "Transware" },
  { 0x00409D, "DigiBoard, Ethernet-ISDN bridges" },
  { 0x00409E, "Concurrent Technologies Ltd." },
  { 0x00409F, "Lancast/Casat Technology Inc" },
  { 0x0040A4, "Rose Electronics" },
  { 0x0040A6, "Cray Research Inc." },
  { 0x0040AA, "Valmet Automation Inc" },
  { 0x0040AD, "SMA Regelsysteme Gmbh" },
  { 0x0040AE, "Delta Controls, Inc." },
  { 0x0040AF, "Digital Products, Inc. (DPI)." },
  { 0x0040B4, "3Com K.K." },
  { 0x0040B5, "Video Technology Computers Ltd" },
  { 0x0040B6, "Computerm Corporation" },
  { 0x0040B9, "MACQ Electronique SA" },
  { 0x0040BD, "Starlight Networks Inc" },
  { 0x0040C1, "Bizerba-Werke Wilheim Kraut" },
  { 0x0040C2, "Applied Computing Devices" },
  { 0x0040C3, "Fischer and Porter Co." },
  { 0x0040C5, "Micom Communications Corp." },
  { 0x0040C6, "Fibernet Research, Inc." },
  { 0x0040C7, "Danpex Corporation" },
  { 0x0040C8, "Milan Technology Corp." },
  { 0x0040CC, "Silcom Manufacturing Technology Inc" },
  { 0x0040CF, "Strawberry Tree Inc" },
  { 0x0040D0, "DEC/Compaq" },
  { 0x0040D2, "Pagine Corporation" },
  { 0x0040D4, "Gage Talker Corp." },
  { 0x0040D7, "Studio Gen Inc" },
  { 0x0040D8, "Ocean Office Automation Ltd" },
  { 0x0040DC, "Tritec Electronic Gmbh" },
  { 0x0040DF, "Digalog Systems, Inc." },
  { 0x0040E1, "Marner International Inc" },
  { 0x0040E2, "Mesa Ridge Technologies Inc" },
  { 0x0040E3, "Quin Systems Ltd" },
  { 0x0040E5, "Sybus Corporation" },
  { 0x0040E7, "Arnos Instruments & Computer" },
  { 0x0040E9, "Accord Systems, Inc." },
  { 0x0040EA, "PlainTree Systems Inc" },
  { 0x0040ED, "Network Controls International Inc" },
  { 0x0040F0, "Micro Systems Inc" },
  { 0x0040F1, "Chuo Electronics Co., Ltd." },
  { 0x0040F4, "Cameo Communications, Inc." },
  { 0x0040F5, "OEM Engines" },
  { 0x0040F6, "Katron Computers Inc" },
  { 0x0040F9, "Combinet" },
  { 0x0040FA, "Microboards Inc" },
  { 0x0040FB, "Cascade Communications Corp." },
  { 0x0040FD, "LXE" },
  { 0x0040FF, "Telebit Corporation, Personal NetBlazer" },
  { 0x004854, "Digital SemiConductor, 21143/2 based 10/100" },
  { 0x004F49, "Realtek" },
  { 0x004F4B, "Pine Technology Ltd." },
  { 0x005004, "3Com 3C90X" },
  { 0x00500F, "Cisco" },
  { 0x00504D, "Repotec Group" },
  { 0x00504E, "UMC UM9008 NE2000-compatible ISA Card for PC" },
  { 0x006008, "3Com 3Com PCI form factor 3C905 TX board" },
  { 0x006009, "Cisco Catalyst 5000 Ethernet switch" },
  { 0x006025, "Active Imaging Inc." },
  { 0x00602F, "Cisco" },
  { 0x006030, "VillageTronic used on Amiga" },
  { 0x00603E, "Cisco 100Mbps interface" },
  { 0x006047, "Cisco" },
  { 0x00604E, "Cycle Computer (Sun MotherBoard Replacements)" },
  { 0x006052, "Realtek (RTL 8029 == PCI NE2000)" },
  { 0x00605C, "Cisco" },
  { 0x006067, "Acer Lan" },
  { 0x006070, "Cisco routers (2524 and 4500)" },
  { 0x006083, "Cisco Systems, Inc., 3620/3640 routers" },
  { 0x00608C, "3Com (1990 onwards)" },
  { 0x006094, "AMD PCNET PCI" },
  { 0x006097, "3Com" },
  { 0x0060B0, "Hewlett-Packard" },
  { 0x008000, "Multitech Systems Inc" },
  { 0x008001, "Periphonics Corporation" },
  { 0x008004, "Antlow Computers, Ltd." },
  { 0x008005, "Cactus Computer Inc." },
  { 0x008006, "Compuadd Corporation" },
  { 0x008007, "Dlog NC-Systeme" },
  { 0x008009, "Jupiter Systems (older MX-600 series machines)" },
  { 0x00800D, "Vosswinkel FU" },
  { 0x00800F, "SMC (Standard Microsystem Corp.)" },
  { 0x008010, "Commodore" },
  { 0x008012, "IMS Corp. IMS failure analysis tester" },
  { 0x008013, "Thomas Conrad Corp." },
  { 0x008015, "Seiko Systems Inc" },
  { 0x008016, "Wandel & Goltermann" },
  { 0x008017, "PFU" },
  { 0x008019, "Dayna Communications, Etherprint product" },
  { 0x00801A, "Bell Atlantic" },
  { 0x00801B, "Kodiak Technology" },
  { 0x00801C, "Cisco" },
  { 0x00801E, "AMD PCNET 32 PCI" },
  { 0x008021, "Newbridge Networks Corporation" },
  { 0x008023, "Integrated Business Networks" },
  { 0x008024, "Kalpana" },
  { 0x008026, "Network Products Corporation" },
  { 0x008029, "Microdyne Corporation" },
  { 0x00802A, "Test Systems & Simulations Inc" },
  { 0x00802C, "The Sage Group PLC" },
  { 0x00802D, "Xylogics, Inc. Annex terminal servers" },
  { 0x00802E, "Plexcom, Inc." },
  { 0x008033, "Formation (?)" },
  { 0x008034, "SMT-Goupil" },
  { 0x008035, "Technology Works" },
  { 0x008037, "Ericsson Business Comm." },
  { 0x008038, "Data Research & Applications" },
  { 0x00803B, "APT Communications, Inc." },
  { 0x00803D, "Surigiken Co Ltd" },
  { 0x00803E, "Synernetics" },
  { 0x00803F, "Hyundai Electronics" },
  { 0x008042, "Force Computers" },
  { 0x008043, "Networld Inc" },
  { 0x008045, "Matsushita Electric Ind Co" },
  { 0x008046, "University of Toronto" },
  { 0x008048, "Compex, used by Commodore and DEC at least" },
  { 0x008049, "Nissin Electric Co Ltd" },
  { 0x00804C, "Contec Co., Ltd." },
  { 0x00804D, "Cyclone Microsystems, Inc." },
  { 0x008051, "ADC Fibermux" },
  { 0x008052, "Network Professor" },
  { 0x008057, "Adsoft Ltd" },
  { 0x00805A, "Tulip Computers International BV" },
  { 0x00805B, "Condor Systems, Inc." },
  { 0x00805C, "Agilis(?)" },
  { 0x00805F, "Compaq Computer Corporation" },
  { 0x008060, "Network Interface Corporation" },
  { 0x008062, "Interface Co." },
  { 0x008063, "Richard Hirschmann Gmbh & Co" },
  { 0x008064, "Wyse" },
  { 0x008067, "Square D Company" },
  { 0x008069, "Computone Systems" },
  { 0x00806A, "ERI (Empac Research Inc.)" },
  { 0x00806B, "Schmid Telecommunication" },
  { 0x00806C, "Cegelec Projects Ltd" },
  { 0x00806D, "Century Systems Corp." },
  { 0x00806E, "Nippon Steel Corporation" },
  { 0x00806F, "Onelan Ltd" },
  { 0x008071, "SAI Technology" },
  { 0x008072, "Microplex Systems Ltd" },
  { 0x008074, "Fisher Controls" },
  { 0x008079, "Microbus Designs Ltd" },
  { 0x00807B, "Artel Communications Corp." },
  { 0x00807C, "FiberCom" },
  { 0x00807D, "Equinox Systems Inc" },
  { 0x008082, "PEP Modular Computers Gmbh" },
  { 0x008086, "Computer Generation Inc." },
  { 0x008087, "Okidata" },
  { 0x00808A, "Summit (?)" },
  { 0x00808B, "Dacoll Limited" },
  { 0x00808C, "Netscout Systems (formerly Frontier Software Development)" },
  { 0x00808D, "Westcove Technology BV" },
  { 0x00808E, "Radstone Technology" },
  { 0x008090, "Microtek International Inc" },
  { 0x008092, "Japan Computer Industry, Inc." },
  { 0x008093, "Xyron Corporation" },
  { 0x008094, "Sattcontrol AB" },
  { 0x008096, "HDS (Human Designed Systems) X terminals" },
  { 0x008098, "TDK Corporation" },
  { 0x00809A, "Novus Networks Ltd" },
  { 0x00809B, "Justsystem Corporation" },
  { 0x00809D, "Datacraft Manufactur'g Pty Ltd" },
  { 0x00809F, "Alcatel Business Systems" },
  { 0x0080A1, "Microtest" },
  { 0x0080A3, "Lantronix, (see also 0800A3)" },
  { 0x0080A6, "Republic Technology Inc" },
  { 0x0080A7, "Measurex Corp" },
  { 0x0080AD, "CNet Technology Used by Telebit (among others)" },
  { 0x0080AE, "Hughes Network Systems" },
  { 0x0080AF, "Allumer Co., Ltd." },
  { 0x0080B1, "Softcom A/S" },
  { 0x0080B2, "NET (Network Equipment Technologies)" },
  { 0x0080B6, "Themis corporation" },
  { 0x0080BA, "Specialix (Asia) Pte Ltd" },
  { 0x0080C0, "Penril Datability Networks" },
  { 0x0080C2, "IEEE 802.1 Committee" },
  { 0x0080C6, "Soho" },
  { 0x0080C7, "Xircom, Inc." },
  { 0x0080C8, "D-Link, (also Solectek Pocket Adapters, and LinkSys PCMCIA)" },
  { 0x0080C9, "Alberta Microelectronic Centre" },
  { 0x0080CE, "Broadcast Television Systems" },
  { 0x0080D0, "Computer Products International" },
  { 0x0080D3, "Shiva Appletalk-Ethernet interface" },
  { 0x0080D4, "Chase Limited" },
  { 0x0080D6, "Apple Mac Portable(?)" },
  { 0x0080D7, "Fantum Electronics" },
  { 0x0080D8, "Network Peripherals" },
  { 0x0080DA, "Bruel & Kjaer" },
  { 0x0080E0, "XTP Systems Inc" },
  { 0x0080E3, "Coral (?)" },
  { 0x0080E7, "Lynwood Scientific Dev Ltd" },
  { 0x0080EA, "The Fiber Company" },
  { 0x0080F0, "Kyushu Matsushita Electric Co" },
  { 0x0080F1, "Opus" },
  { 0x0080F3, "Sun Electronics Corp" },
  { 0x0080F4, "Telemechanique Electrique" },
  { 0x0080F5, "Quantel Ltd" },
  { 0x0080F7, "Zenith Communications Products" },
  { 0x0080FB, "BVM Limited" },
  { 0x0080FE, "Azure Technologies Inc" },
  { 0x009027, "Intel EtherXpress Pro 10/100" },
  { 0x0090B1, "Cisco" },
  { 0x00902B, "Cisco Ethernet Switches and Light Streams" },
  { 0x009086, "Cisco" },
  { 0x009092, "Cisco" },
  { 0x0090AB, "Cisco" },
  { 0x0090F2, "Cisco Ethernet Switches and Light Streams" },
  { 0x00A000, "Bay Networks Ethernet switch" },
  { 0x00A024, "3Com" },
  { 0x00A040, "Apple (PCI Mac)" },
  { 0x00A04B, "Sonic Systems Inc., EtherFE 10/100 PCI for Mac or PC" },
  { 0x00A073, "Com21" },
  { 0x00A083, "Intel" },
  { 0x00A092, "Intermate International, [LAN printer interfaces]" },
  { 0x00A0AE, "Network Peripherals, Inc." },
  { 0x00A0C9, "Intel (PRO100B and PRO100+) [used on Cisco PIX firewall among others]" },
  { 0x00A0CC, "Lite-On, (used by MacSense in Adapter for Mac, also seen in PCs)" },
  { 0x00A0D1, "National Semiconductor, [COMPAQ Docking Station]" },
  { 0x00A0D2, "Allied Telesyn" },
  { 0x00AA00, "Intel" },
  { 0x00B0D0, "Computer Products International" },
  { 0x00C000, "Lanoptics Ltd" },
  { 0x00C001, "Diatek Patient Managment" },
  { 0x00C002, "Sercomm Corporation" },
  { 0x00C003, "Globalnet Communications" },
  { 0x00C004, "Japan Business Computer Co.Ltd" },
  { 0x00C005, "Livingston Enterprises Inc, Portmaster (OEMed by Cayman)" },
  { 0x00C006, "Nippon Avionics Co Ltd" },
  { 0x00C007, "Pinnacle Data Systems Inc" },
  { 0x00C008, "Seco SRL" },
  { 0x00C009, "KT Technology (s) Pte Inc" },
  { 0x00C00A, "Micro Craft" },
  { 0x00C00B, "Norcontrol A.S." },
  { 0x00C00C, "ARK PC Technology, Inc." },
  { 0x00C00D, "Advanced Logic Research Inc" },
  { 0x00C00E, "Psitech Inc" },
  { 0x00C00F, "QNX Software Systems Ltd. [also Quantum Software Systems Ltd]" },
  { 0x00C011, "Interactive Computing Devices" },
  { 0x00C012, "Netspan Corp" },
  { 0x00C013, "Netrix" },
  { 0x00C014, "Telematics Calabasas" },
  { 0x00C015, "New Media Corp" },
  { 0x00C016, "Electronic Theatre Controls" },
  { 0x00C017, "Fluke" },
  { 0x00C018, "Lanart Corp" },
  { 0x00C01A, "Corometrics Medical Systems" },
  { 0x00C01B, "Socket Communications" },
  { 0x00C01C, "Interlink Communications Ltd." },
  { 0x00C01D, "Grand Junction Networks, Inc." },
  { 0x00C01F, "S.E.R.C.E.L." },
  { 0x00C020, "Arco Electronic, Control Ltd." },
  { 0x00C021, "Netexpress" },
  { 0x00C023, "Tutankhamon Electronics" },
  { 0x00C024, "Eden Sistemas De Computacao SA" },
  { 0x00C025, "Dataproducts Corporation" },
  { 0x00C027, "Cipher Systems, Inc." },
  { 0x00C028, "Jasco Corporation" },
  { 0x00C029, "Kabel Rheydt AG" },
  { 0x00C02A, "Ohkura Electric Co" },
  { 0x00C02B, "Gerloff Gesellschaft Fur" },
  { 0x00C02C, "Centrum Communications, Inc." },
  { 0x00C02D, "Fuji Photo Film Co., Ltd." },
  { 0x00C02E, "Netwiz" },
  { 0x00C02F, "Okuma Corp" },
  { 0x00C030, "Integrated Engineering B. V." },
  { 0x00C031, "Design Research Systems, Inc." },
  { 0x00C032, "I-Cubed Limited" },
  { 0x00C033, "Telebit Corporation" },
  { 0x00C034, "Dale Computer Corporation" },
  { 0x00C035, "Quintar Company" },
  { 0x00C036, "Raytech Electronic Corp" },
  { 0x00C039, "Silicon Systems" },
  { 0x00C03B, "Multiaccess Computing Corp" },
  { 0x00C03C, "Tower Tech S.R.L." },
  { 0x00C03D, "Wiesemann & Theis Gmbh" },
  { 0x00C03E, "Fa. Gebr. Heller Gmbh" },
  { 0x00C03F, "Stores Automated Systems Inc" },
  { 0x00C040, "ECCI" },
  { 0x00C041, "Digital Transmission Systems" },
  { 0x00C042, "Datalux Corp." },
  { 0x00C043, "Stratacom" },
  { 0x00C044, "Emcom Corporation" },
  { 0x00C045, "Isolation Systems Inc" },
  { 0x00C046, "Kemitron Ltd" },
  { 0x00C047, "Unimicro Systems Inc" },
  { 0x00C048, "Bay Technical Associates" },
  { 0x00C049, "US Robotics Total Control (tm) NETServer Card" },
  { 0x00C04D, "Mitec Ltd" },
  { 0x00C04E, "Comtrol Corporation" },
  { 0x00C04F, "Dell" },
  { 0x00C050, "Toyo Denki Seizo K.K." },
  { 0x00C051, "Advanced Integration Research" },
  { 0x00C055, "Modular Computing Technologies" },
  { 0x00C056, "Somelec" },
  { 0x00C057, "Myco Electronics" },
  { 0x00C058, "Dataexpert Corp" },
  { 0x00C059, "Nippondenso Corp" },
  { 0x00C05B, "Networks Northwest Inc" },
  { 0x00C05C, "Elonex PLC" },
  { 0x00C05D, "L&N Technologies" },
  { 0x00C05E, "Vari-Lite Inc" },
  { 0x00C060, "ID Scandinavia A/S" },
  { 0x00C061, "Solectek Corporation" },
  { 0x00C063, "Morning Star Technologies Inc, May be miswrite of 0003C6" },
  { 0x00C064, "General Datacomm Ind Inc" },
  { 0x00C065, "Scope Communications Inc" },
  { 0x00C066, "Docupoint, Inc." },
  { 0x00C067, "United Barcode Industries" },
  { 0x00C068, "Philp Drake Electronics Ltd" },
  { 0x00C069, "California Microwave Inc" },
  { 0x00C06A, "Zahner-Elektrik Gmbh & Co KG" },
  { 0x00C06B, "OSI Plus Corporation" },
  { 0x00C06C, "SVEC Computer Corp" },
  { 0x00C06D, "Boca Research, Inc." },
  { 0x00C06F, "Komatsu Ltd" },
  { 0x00C070, "Sectra Secure-Transmission AB" },
  { 0x00C071, "Areanex Communications, Inc." },
  { 0x00C072, "KNX Ltd" },
  { 0x00C073, "Xedia Corporation" },
  { 0x00C074, "Toyoda Automatic Loom Works Ltd" },
  { 0x00C075, "Xante Corporation" },
  { 0x00C076, "I-Data International A-S" },
  { 0x00C077, "Daewoo Telecom Ltd" },
  { 0x00C078, "Computer Systems Engineering" },
  { 0x00C079, "Fonsys Co Ltd" },
  { 0x00C07A, "Priva BV" },
  { 0x00C07B, "Ascend Communications, ISDN bridges/routers" },
  { 0x00C07D, "RISC Developments Ltd" },
  { 0x00C07F, "Nupon Computing Corp" },
  { 0x00C080, "Netstar Inc" },
  { 0x00C081, "Metrodata Ltd" },
  { 0x00C082, "Moore Products Co" },
  { 0x00C084, "Data Link Corp Ltd" },
  { 0x00C085, "Canon" },
  { 0x00C086, "The Lynk Corporation" },
  { 0x00C087, "UUNET Technologies Inc" },
  { 0x00C089, "Telindus Distribution" },
  { 0x00C08A, "Lauterbach Datentechnik Gmbh" },
  { 0x00C08B, "RISQ Modular Systems Inc" },
  { 0x00C08C, "Performance Technologies Inc" },
  { 0x00C08D, "Tronix Product Development" },
  { 0x00C08E, "Network Information Technology" },
  { 0x00C08F, "Matsushita Electric Works, Ltd." },
  { 0x00C090, "Praim S.R.L." },
  { 0x00C091, "Jabil Circuit, Inc." },
  { 0x00C092, "Mennen Medical Inc" },
  { 0x00C093, "Alta Research Corp." },
  { 0x00C095, "Znyx (Network Appliance box); Jupiter Systems (MX-700 series)" },
  { 0x00C096, "Tamura Corporation" },
  { 0x00C097, "Archipel SA" },
  { 0x00C098, "Chuntex Electronic Co., Ltd." },
  { 0x00C09B, "Reliance Comm/Tec, R-Tec Systems Inc" },
  { 0x00C09C, "TOA Electronic Ltd" },
  { 0x00C09D, "Distributed Systems Int'l, Inc." },
  { 0x00C09F, "Quanta Computer Inc" },
  { 0x00C0A0, "Advance Micro Research, Inc." },
  { 0x00C0A1, "Tokyo Denshi Sekei Co" },
  { 0x00C0A2, "Intermedium A/S" },
  { 0x00C0A3, "Dual Enterprises Corporation" },
  { 0x00C0A4, "Unigraf OY" },
  { 0x00C0A7, "SEEL Ltd" },
  { 0x00C0A8, "GVC Corporation" },
  { 0x00C0A9, "Barron McCann Ltd" },
  { 0x00C0AA, "Silicon Valley Computer" },
  { 0x00C0AB, "Jupiter Technology Inc" },
  { 0x00C0AC, "Gambit Computer Communications" },
  { 0x00C0AD, "Computer Communication Systems" },
  { 0x00C0AE, "Towercom Co Inc DBA PC House" },
  { 0x00C0B0, "GCC Technologies,Inc." },
  { 0x00C0B2, "Norand Corporation" },
  { 0x00C0B3, "Comstat Datacomm Corporation" },
  { 0x00C0B4, "Myson Technology Inc" },
  { 0x00C0B5, "Corporate Network Systems Inc" },
  { 0x00C0B6, "Meridian Data Inc" },
  { 0x00C0B7, "American Power Conversion Corp" },
  { 0x00C0B8, "Fraser's Hill Ltd." },
  { 0x00C0B9, "Funk Software Inc" },
  { 0x00C0BA, "Netvantage" },
  { 0x00C0BB, "Forval Creative Inc" },
  { 0x00C0BD, "Inex Technologies, Inc." },
  { 0x00C0BE, "Alcatel - Sel" },
  { 0x00C0BF, "Technology Concepts Ltd" },
  { 0x00C0C0, "Shore Microsystems Inc" },
  { 0x00C0C1, "Quad/Graphics Inc" },
  { 0x00C0C2, "Infinite Networks Ltd." },
  { 0x00C0C3, "Acuson Computed Sonography" },
  { 0x00C0C4, "Computer Operational" },
  { 0x00C0C5, "SID Informatica" },
  { 0x00C0C6, "Personal Media Corp" },
  { 0x00C0C8, "Micro Byte Pty Ltd" },
  { 0x00C0C9, "Bailey Controls Co" },
  { 0x00C0CA, "Alfa, Inc." },
  { 0x00C0CB, "Control Technology Corporation" },
  { 0x00C0CD, "Comelta S.A." },
  { 0x00C0D0, "Ratoc System Inc" },
  { 0x00C0D1, "Comtree Technology Corporation (EFA also reported)" },
  { 0x00C0D2, "Syntellect Inc" },
  { 0x00C0D4, "Axon Networks Inc" },
  { 0x00C0D5, "Quancom Electronic Gmbh" },
  { 0x00C0D6, "J1 Systems, Inc." },
  { 0x00C0D9, "Quinte Network Confidentiality Equipment Inc" },
  { 0x00C0DB, "IPC Corporation (Pte) Ltd" },
  { 0x00C0DC, "EOS Technologies, Inc." },
  { 0x00C0DE, "ZComm Inc" },
  { 0x00C0DF, "Kye Systems Corp" },
  { 0x00C0E1, "Sonic Solutions" },
  { 0x00C0E2, "Calcomp, Inc." },
  { 0x00C0E3, "Ositech Communications Inc" },
  { 0x00C0E4, "Landis & Gyr Powers Inc" },
  { 0x00C0E5, "GESPAC S.A." },
  { 0x00C0E6, "TXPORT" },
  { 0x00C0E7, "Fiberdata AB" },
  { 0x00C0E8, "Plexcom Inc" },
  { 0x00C0E9, "Oak Solutions Ltd" },
  { 0x00C0EA, "Array Technology Ltd." },
  { 0x00C0EC, "Dauphin Technology" },
  { 0x00C0ED, "US Army Electronic Proving Ground" },
  { 0x00C0EE, "Kyocera Corporation" },
  { 0x00C0EF, "Abit Corporation" },
  { 0x00C0F0, "Kingston Technology Corporation" },
  { 0x00C0F1, "Shinko Electric Co Ltd" },
  { 0x00C0F2, "Transition Engineering Inc" },
  { 0x00C0F3, "Network Communications Corp" },
  { 0x00C0F4, "Interlink System Co., Ltd." },
  { 0x00C0F5, "Metacomp Inc" },
  { 0x00C0F6, "Celan Technology Inc." },
  { 0x00C0F7, "Engage Communication, Inc." },
  { 0x00C0F8, "About Computing Inc." },
  { 0x00C0FA, "Canary Communications Inc" },
  { 0x00C0FB, "Advanced Technology Labs" },
  { 0x00C0FC, "ASDG Incorporated" },
  { 0x00C0FD, "Prosum" },
  { 0x00C0FF, "Box Hill Systems Corporation" },
  { 0x00DD00, "Ungermann-Bass IBM RT" },
  { 0x00DD01, "Ungermann-Bass" },
  { 0x00DD08, "Ungermann-Bass" },
  { 0x00E011, "Uniden Corporation" },
  { 0x00E014, "Cisco" },
  { 0x00E016, "rapid-city (now a part of bay networks)" },
  { 0x00E01E, "Cisco Lightstream 1010, 36xx router" },
  { 0x00E029, "SMC EtherPower II 10/100" },
  { 0x00E02C, "AST - built into 5166M PC motherboard (win95 id's as Intel)" },
  { 0x00E034, "Cisco" },
  { 0x00E039, "Paradyne 7112 T1 DSU/CSU" },
  { 0x00E04F, "Cisco" },
  { 0x00E07D, "Encore (Netronix?), 10/100 PCI Fast ethernet card" },
  { 0x00E081, "Tyan Computer Corp., Onboard Intel 82558 10/100" },
  { 0x00E083, "Jato Technologies, Inc." },
  { 0x00E08F, "Cisco Systems Catalyst 2900 series" },
  { 0x00E098, "Linksys PCMCIA card" },
  { 0x00E0A3, "Cisco Systems Catalyst 1924" },
  { 0x00E0B0, "Cisco Systems Various systems reported" },
  { 0x00E0B8, "AMD PCNet in a Gateway 2000" },
  { 0x00E0C5, "BCOM Electronics Inc." },
  { 0x00E0F7, "Cisco" },
  { 0x00E0F9, "Cisco" },
  { 0x00E0FE, "Cisco" },
  { 0x020406, "BBN internal usage (not registered)" },
  { 0x020701, "Interlan [now Racal-InterLAN] DEC (UNIBUS or QBUS), Apollo, Cisco" },
  { 0x020701, "Racal-Datacom" },
  { 0x026060, "3Com" },
  { 0x026086, "Satelcom MegaPac (UK)" },
  { 0x02608C, "3Com IBM PC; Imagen; Valid; Cisco; Macintosh" },
  { 0x02A0C9, "Intel" },
  { 0x02AA3C, "Olivetti" },
  { 0x02CF1F, "CMC Masscomp; Silicon Graphics; Prime EXL" },
  { 0x02E03B, "Prominet Corporation, Gigabit Ethernet Switch" },
  { 0x02E6D3, "BTI (Bus-Tech, Inc.), IBM Mainframes" },
  { 0x048845, "Bay Networks token ring line card" },
  { 0x080001, "Computer Vision" },
  { 0x080002, "3Com (formerly Bridge)" },
  { 0x080003, "ACC (Advanced Computer Communications)" },
  { 0x080005, "Symbolics Symbolics LISP machines" },
  { 0x080006, "Siemens Nixdorf PC clone" },
  { 0x080007, "Apple" },
  { 0x080008, "BBN (Bolt Beranek and Newman, Inc.)" },
  { 0x080009, "Hewlett-Packard" },
  { 0x08000A, "Nestar Systems" },
  { 0x08000B, "Unisys also Ascom-Timeplex (former Unisys subsidiary)" },
  { 0x08000D, "ICL (International Computers, Ltd.)" },
  { 0x08000E, "NCR/AT&T" },
  { 0x08000F, "SMC (Standard Microsystems Corp.)" },
  { 0x080010, "AT&T [misrepresentation of 800010?]" },
  { 0x080011, "Tektronix, Inc." },
  { 0x080014, "Excelan BBN Butterfly, Masscomp, Silicon Graphics" },
  { 0x080017, "National Semiconductor Corp. (used to have Network System Corp., wrong NSC)" },
  { 0x08001A, "Tiara? (used to have Data General)" },
  { 0x08001B, "Data General" },
  { 0x08001E, "Apollo" },
  { 0x08001F, "Sharp" },
  { 0x080020, "Sun" },
  { 0x080022, "NBI (Nothing But Initials)" },
  { 0x080023, "Matsushita Denso" },
  { 0x080025, "CDC" },
  { 0x080026, "Norsk Data (Nord)" },
  { 0x080027, "PCS Computer Systems GmbH" },
  { 0x080028, "TI Explorer" },
  { 0x08002B, "DEC" },
  { 0x08002E, "Metaphor" },
  { 0x08002F, "Prime Computer Prime 50-Series LHC300" },
  { 0x080030, "CERN" },
  { 0x080032, "Tigan" },
  { 0x080036, "Intergraph CAE stations" },
  { 0x080037, "Fuji Xerox" },
  { 0x080038, "Bull" },
  { 0x080039, "Spider Systems" },
  { 0x08003B, "Torus Systems" },
  { 0x08003D, "cadnetix" },
  { 0x08003E, "Motorola VME bus processor modules" },
  { 0x080041, "DCA (Digital Comm. Assoc.)" },
  { 0x080044, "DSI (DAVID Systems, Inc.)" },
  { 0x080045, "???? (maybe Xylogics, but they claim not to know this number)" },
  { 0x080046, "Sony" },
  { 0x080047, "Sequent" },
  { 0x080048, "Eurotherm Gauging Systems" },
  { 0x080049, "Univation" },
  { 0x08004C, "Encore" },
  { 0x08004E, "BICC [3Com bought BICC, so may appear on 3Com equipment as well]" },
  { 0x080051, "Experdata" },
  { 0x080056, "Stanford University" },
  { 0x080057, "Evans & Sutherland (?)" },
  { 0x080058, "??? DECsystem-20" },
  { 0x08005A, "IBM" },
  { 0x080066, "AGFA printers, phototypesetters etc." },
  { 0x080067, "Comdesign" },
  { 0x080068, "Ridge" },
  { 0x080069, "Silicon Graphics" },
  { 0x08006A, "ATTst (?)" },
  { 0x08006E, "Excelan" },
  { 0x080070, "Mitsubishi" },
  { 0x080074, "Casio" },
  { 0x080075, "DDE (Danish Data Elektronik A/S)" },
  { 0x080077, "TSL (now Retix)" },
  { 0x080079, "Silicon Graphics" },
  { 0x08007C, "Vitalink TransLAN III" },
  { 0x080080, "XIOS" },
  { 0x080081, "Crosfield Electronics" },
  { 0x080083, "Seiko Denshi" },
  { 0x080086, "Imagen/QMS" },
  { 0x080087, "Xyplex terminal servers" },
  { 0x080088, "McDATA Corporation" },
  { 0x080089, "Kinetics AppleTalk-Ethernet interface" },
  { 0x08008B, "Pyramid" },
  { 0x08008D, "XyVision XyVision machines" },
  { 0x08008E, "Tandem / Solbourne Computer ?" },
  { 0x08008F, "Chipcom Corp." },
  { 0x080090, "Retix, Inc. Bridges" },
  { 0x09006A, "AT&T" },
  { 0x10005A, "IBM" },
  { 0x100090, "Hewlett-Packard Advisor products" },
  { 0x1000D4, "DEC" },
  { 0x1000E0, "Apple A/UX (modified addresses for licensing)" },
  { 0x2E2E2E, "LAA (Locally Administered Address) for Meditech Systems" },
  { 0x3C0000, "3Com dual function (V.34 modem + Ethernet) card" },
  { 0x400003, "Net Ware (?)" },
  { 0x444553, "Microsoft (Windows95 internal adapters)" },
  { 0x444649, "DFI (Diamond Flower Industries)" },
  { 0x475443, "GTC (Not registered!), (This number is a multicast!)" },
  { 0x484453, "HDS ???" },
  { 0x484C00, "Network Solutions" },
  { 0x4854E8, "winbond?" },
  { 0x4C424C, "Information Modes software modified addresses (not registered?)" },
  { 0x525400, "UpTech?" },
  { 0x52544C, "Novell 2000" },
  { 0x5254AB, "REALTEK (a Realtek 8029 based PCI Card)" },
  { 0x565857, "Aculab plc audio bridges" },
  { 0x800010, "AT&T [misrepresented as 080010? One source claims this is correct]" },
  { 0x80AD00, "CNET Technology Inc. (Probably an error, see instead 0080AD)" },
  { 0xAA0000, "DEC obsolete" },
  { 0xAA0001, "DEC obsolete" },
  { 0xAA0002, "DEC obsolete" },
  { 0xAA0003, "DEC Global physical address for some DEC machines" },
  { 0xAA0004, "DEC Local logical address for DECNET systems" },
  { 0xC00000, "Western Digital (may be reversed 00 00 C0?)" },
  { 0xEC1000, "Enance Source Co., Ltd., PC clones(?)" },
  { 0xFFFFFF, "IP Broadcast" },
  { 0x0, NULL }
};  

VendorInfo* vendorHash[HASHNAMESIZE];

/* *********************************** */

static void addVendorTableEntry(VendorInfo* entry) {
  u_int idx;

  idx = (u_int)(entry->vendorId % HASHNAMESIZE);

#ifdef DEBUG
  printf("%d %x '%s'\n", idx,
	 entry->vendorId,
	 entry->vendorName);
#endif

  for(;;) {
    if(vendorHash[idx] == NULL) {      
      vendorHash[idx] = entry;
      break;
    }    
    idx = (idx+1)%HASHNAMESIZE;
  }
}

/* *********************************** */

char* getVendorInfo(u_char* ethAddress) {
  u_int idx;
  unsigned long vendorValue;
  VendorInfo* cursor;

  vendorValue = 256*256*(unsigned long)ethAddress[0] 
    + 256*(unsigned long)ethAddress[1] 
    + (unsigned long)ethAddress[2];
  idx = (u_int)((u_int)vendorValue % HASHNAMESIZE);

#ifdef DEBUG
  printf("%d %ld\n", idx, vendorValue);
#endif

  for(;;) {
    cursor = vendorHash[idx];
    
    if(vendorHash[idx] == NULL) {
      /* Unknown vendor */
      return("");
    } else if(vendorHash[idx] != NULL) {
      if(vendorHash[idx]->vendorId == vendorValue) {
	if(webMode) {
	  static char vendorName[256];
	  int a, b;

	  for(a=0, b=0; vendorHash[idx]->vendorName[a] != '\0'; a++)
	    if(vendorHash[idx]->vendorName[a] == ' ') {
	      vendorName[b++] = '&';
	      vendorName[b++] = 'n';
	      vendorName[b++] = 'b';
	      vendorName[b++] = 's';
	      vendorName[b++] = 'p';
	      vendorName[b++] = ';';
	    } else
	      vendorName[b++] = vendorHash[idx]->vendorName[a];

	  vendorName[b] = '\0';	    
	  return(vendorName);
	} else
	  return(vendorHash[idx]->vendorName);

      }
    }

    idx = (idx+1)%HASHNAMESIZE;
  }
}

/* *********************************** */

void createVendorTable() 
{
  int idx;

  for(idx=0; vendorInfo[idx].vendorId != 0x0; idx++)
    addVendorTableEntry(&vendorInfo[idx]);
}

