/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <string.h>
#include "prototypes.h"
extern struct in_addr ipaddr;
extern char *username;


void user_copy(user_data * src, user_data * dst)
{
    strncpy(dst->username, src->username, MAX_USER_NAME);
    dst->hostaddr.s_addr = src->hostaddr.s_addr;
}

void htonuser(user_data * src, user_data * dst)
{
    strncpy(dst->username, src->username, MAX_USER_NAME);
    dst->hostaddr.s_addr = htonl(src->hostaddr.s_addr);
}

void ntohuser(user_data * src, user_data * dst)
{
    strncpy(dst->username, src->username, MAX_USER_NAME);
    dst->hostaddr.s_addr = ntohl(src->hostaddr.s_addr);
}

int user_cmp(user_data * src, user_data * dst)
{
    if ((dst->hostaddr.s_addr == src->hostaddr.s_addr) &&
	(strcmp(dst->username, src->username) == 0))
	return TRUE;
    else
	return FALSE;
}

void init_local_user(user_data * me)
{
	strncpy(me->username, username, MAX_USER_NAME-1);
    me->hostaddr.s_addr = ipaddr.s_addr;
}

int is_a_null_name(user_data * name)
{
    return (strcmp("NULL", name->username) == 0);
}

void set_null_name(user_data * name)
{
    strcpy(name->username, "NULL");
    name->hostaddr.s_addr = 0;
}
