#include "tcl.h"
#include "tk.h"
#define CURRENT_PROTOCOL_VERSION 2
#define NT_PROTOCOL_CHECKBYTE 234
typedef struct ntheader_s 
{
  unsigned char checkbyte;
  unsigned char version_no;
  unsigned char msgtype;
  struct timeval timestamp;
} ntheader;

#define LINEMSG  (unsigned char)1
#define BLOCKMSG (unsigned char)2
#define SESSIONMSG (unsigned char)3
#define RTX_ADVERT (unsigned char)4
#define RTX_REQUEST (unsigned char)5
#define PAGE_INFO_REQUEST (unsigned char)6
/*PAGE_INFO currently unused - to be used for netpageinfo block*/
#define PAGE_INFO (unsigned char)7
/*BLOCK_INFO_REQUEST currently unused*/
#define BLOCK_INFO_REQUEST (unsigned char)8
/*BLOCK_INFO currently unused*/
#define BLOCK_INFO (unsigned char)9
/*LINE_RTX_REQUEST currently unused - using RTX_SPECIFIC_REQUEST instead*/
#define LINE_RTX_REQUEST (unsigned char)10
#define RTX_SPECIFIC_REQUEST (unsigned char)11
#define LEAVE_CONF (unsigned char)12
#define POINTERMSG (unsigned char)13
#define RECENT_ADVERT (unsigned char)14
/*UNKNOWNLINEMSG is for internal use only, it is never sent*/
#define UNKNOWNLINEMSG (unsigned char)15
/*NEW ADDITION FOR CHECKSUM*/
#define BLOCK_RTX_REQUEST (unsigned char)17
#define BLOCK_INFO_REQUEST2 (unsigned char)18

/*#define MAX_PACKET_QUEUE_LEN 1024*/
#define MAX_PACKET_QUEUE_LEN 10000
/*#define DEFAULT_DATA_RATE 4096*/
#define DEFAULT_DATA_RATE 8192
#define MAX_NO_OF_REQUESTS 40
#define MAX_SESSION_NAME_LEN 255
#define MAX_NUMBER_RECENT 20
#define MAX_PACKET_SIZE 2048

/* checksum algorithm - now in version 2 */

#define CHECKSUM_ALGORITHM_VERSION 2				

typedef struct 
{
  struct in_addr ipaddr;
  unsigned short pid;
  unsigned short idnum;
} netid;

typedef struct 
{
  netid lineid;
  netid blockid;
  netid previd;
  netid nextid;
  user_data modifier;
  u_int8 no_of_chars;
  u_int8 xpos;
  u_int16 linenum; /*set to LINE_DELETED when the line is deleted*/
  u_int16 ypos;
  char line_data[MAX_LINE_LEN];
} netline;

typedef struct
{
  netid blockid;
  netid previd;  /*used to determine stacking order*/
  netid nextid;  /*used to determine stacking order*/
  netid first_line;
  user_data originator;
  user_data modifier;
  typeface face;
  u_int8 status;
  u_int8 xpos;
  u_int16 ypos;
  int no_of_lines;
} netblock;

typedef struct
{
  user_data ud;
  u_int8 textnamelen;
  u_int8 col;
  char textname[MAX_SESSION_NAME_LEN];
} netsession;

/***********************************************************************
 Retransmission advertisement token
 used with type RTX_ADVERT
 ***********************************************************************/
typedef struct
{
  u_int16 key;
  u_int8 mask;
} netrtxadvert;

/***********************************************************************
 Retransmission request
 Sent with message type RTX_REQUEST
 ***********************************************************************/
typedef struct
{
  struct in_addr source;
} netrtxrequest;

/*Page info request*/
/*use netrtxrequest, with PAGE_INFO_REQUEST*/
/*may need to modify this for multiple pages*/
#define netpagerequest netrtxrequest

/***********************************************************************
 Retransmission request for specific data
 Sent with message type RTX_SPECIFIC_REQUEST
 ***********************************************************************/
typedef struct
{
  struct in_addr source;
  unsigned int no_of_items;
  netid ids[MAX_NO_OF_REQUESTS];
} netrtxspecificrequest;

/***********************************************************************
 Advertisement of most recent items seen
 Sent with message type RTX_RECENT_ADVERT
 ***********************************************************************/
typedef struct
{
  netid id;
  u_int8 type;
  struct timeval last_mod;
} netrecentitem;

typedef struct
{
  unsigned int no_of_entries;
  netrecentitem entries[MAX_NUMBER_RECENT];
} netrecentadvert;

/***********************************************************************
 used with type BLOCK_RTX_REQUEST
 I have used this, :-) and this is a smiley face!
 ***********************************************************************/
typedef struct
{
  struct in_addr target;
  netid blockid;
} netblockrtxrequest;



/***********************************************************************
 used with type BLOCK_INFO_REQUEST
 not sure if we ever use this :-)	IT IS used now for checksum
 ***********************************************************************/

typedef struct
{
  struct in_addr target;
  netid blockid;
}  netblockinforequest;

/* for version 2 of the checksum algorithm */
typedef struct
{
  struct in_addr target;
}  netblockinforequest2;


/* new jim version - net block info - used to send a block's checksum */
typedef struct
{
  struct in_addr source;
  u_int16 no_of_lines;
  u_int8 checksum_version;			/* version of the checksum algorithm being used.*/
  netid blockid;
  char checksum[20]; 
} netblockinfo;

/* old version */
/***********************************************************************
 block description message containing a list of 
 blocks and their timestamps and checksums.
 Sent with message type BLOCK_INFO 
 ***********************************************************************/
/* old version

typedef struct 
{
  netid lineid;
  struct timeval timestamp;
  int checksum;
} line_info;

typedef struct
{
  struct in_addr source;
  u_int16 no_of_lines;
  line_info *first_line;
} netblockinfo;

  */
/* NEW DESCRIPTION of NETPAGEINFO - Jim version */
/***********************************************************************
 page description message containing the number of blocks contained in 
 the transmitting page, and it's checksum. Taken the list of blocks out
 because 1. could have a really large no. of blocks, 2. make this message 
 smaller so that I can transmit it whenever I want without too many overheads
 ***********************************************************************/

typedef struct
{
  struct timeval timestamp;				/* to transmit the time of the last */
										/*   edit to the page*/
  struct in_addr source;				/* address of message's transmitter*/
  u_int16 no_of_blocks;					/* no. of blocks in the page*/
  u_int8 checksum_version;					/* version of the checksum algorithm that we*/
										/*  are using - to be able to use the checksum's*/
										/*  being broadcase we must have the same checksum*/
										/*  checking version.*/
  char checksum[20];							/* page's checksum*/
} netpageinfo;


/* OLD DESCRIPTION of NETPAGEINFO */
/***********************************************************************
 page description message containing a list of 
 blocks and their timestamps and checksums
 used with type PAGE_INFO 
 ***********************************************************************/

/* old netpageinfo
typedef struct 
{
  netid lineid;
  struct timeval timestamp;
  int checksum;
} block_info;

typedef struct
{
  struct in_addr source;
  u_int16 no_of_blocks;
  block_info *first_block;
} netpageinfo;
*/

/***********************************************************************
 line retransmit request
 sent with message type LINE_RTX_REQUEST
 ***********************************************************************/
typedef struct
{
  struct in_addr source;
  netid lineid;
} netlinertxrequest;


/***********************************************************************
 shared pointer details
 sent with message type POINTERMSG
 ***********************************************************************/
#define DELETE_POINTER 0xff
typedef struct
{
  int x;
  int y;
  netid id;
  char style[STYLE_LEN];
  char username[MAX_USER_NAME];
  u_int8 col;
} netpointer;


/***********************************************************************
 general packet and queue typedefs 
 ***********************************************************************/
  
typedef struct
{
  int type;
  char id[20]; /*should be MAX_ID_LEN*/
  void *ptr;
} packet;

typedef struct 
{
  packet qdata[MAX_PACKET_QUEUE_LEN];
  int queue_size;
  int queue_first;
  int queue_last;
  struct timeval last_time;
  int last_size;
  int data_rate;
  Tk_TimerToken event_token;
} queue;

