#source location
#set src_dir /cs/research/mice/speedy/home/mhandley/tcl
#source $src_dir/net_balloon.tcl

#Use same colours as rat
#general
#option add *tixBalloonBg gray50
#option add *tixBalloonFg white
#test

option add *foreground black startupFile
option add *activeBackground gray85 startupFile
option add *selectBackground gray85 startupFile
option add *scrollbarBackground gray50 startupFile
option add *scrollbarForeground gray80 startupFile
option add *scrollbarActiveForeground gray95 startupFile
option add *Checkbutton.anchor w startupFile
option add *Radiobutton.anchor w startupFile
option add *Radiobutton.relief flat startupFile
option add *Scale.sliderForeground gray80 startupFile
option add *Scale.activeForeground gray85 startupFile
option add *Scale.background gray80 startupFile
option add *selector forestgreen startupFile
option add *disabledBackground gray80 widgetDefault
option add *canvasBackground gray95 widgetDefault
option add *disabledForeground gray50 widgetDefault
option add *hotForeground blue widgetDefault
option add *activehotForeground red widgetDefault
option add *balloonHelp 0
option add *fontSize normal widgetDefault
option add *participants 1 widgetDefault

if {$tcl_platform(platform) == "unix"} {
	. configure -background gray80
	option add *background gray80 startupFile
	option add *font \
	 -*-helvetica-bold-r-normal--12-*-$charset \
	 widgetDefault
	option add *ntInfoFont \
	  -*-helvetica-medium-r-normal--10-*-$charset \
	 widgetDefault
	option add *ntUserFont \
	 -*-helvetica-bold-r-normal--10-*-$charset \
	  widgetDefault
	option add *mediumFont \
	  -*-helvetica-bold-r-normal--10-*-$charset \
	 widgetDefault
} else {
	. configure -background gray75
	option add *background gray75 startupFile
	option add *font \
	  -*-helvetica-bold-r-normal--12-*-iso8859-1 \
	  widgetDefault
	option add *ntInfoFont \
	  -*-helvetica-medium-r-normal--12-*-iso8859-1 \
	  widgetDefault
	option add *ntUserFont \
	  -*-helvetica-bold-r-normal--12-*-iso8859-1 \
	  widgetDefault
	option add *mediumFont \
	  -*-helvetica-bold-r-normal--12-*-iso8859-1 \
	  widgetDefault
}
set balloonHelp 0
#if { [option get . balloonHelp nt] == 0 } {
#  tixBalloonManual  
#  set balloonHelp 0
#}
set infofont [option get . ntInfoFont nt]
set userfont [option get . ntUserFont nt]
set backcol [option get . background nt]
set canvcol [option get . canvasBackground nt]
set webproxy ""
lognewwindow .
frame .m
#frame .m.top -borderwidth 2 -relief sunken
frame .m.cp -borderwidth 2 -relief groove
frame .m.in -borderwidth 2 -relief groove
frame .m.l
frame .m.l.ss -borderwidth 2 -relief groove
frame .m.l.txt -borderwidth 2 -relief sunken

label .m.cp.l -text "UCL Network Text Editor $NT_VERSION"

############################################
# setup fonts
############################################
proc init_fonts {size newfh newfw} {
	global fhu fwu fh fw charset tcl_platform font cur_font

	if {$tcl_platform(platform) == "unix"} {
		set fonts [list -adobe-courier-medium-r-normal--*-$size-75-75-*-*-$charset\
			-adobe-courier-medium-o-normal--*-$size-75-75-*-*-$charset\
			-adobe-courier-bold-r-normal--*-$size-75-75-*-*-$charset\
			-adobe-courier-bold-o-normal--*-$size-75-75-*-*-$charset]
		set fontnames {Normal Italic Bold "Bold Italic"}
	} else {
		set fonts [font families]
		set result ""
		foreach f $fonts {
			if {[string match "*Courier New*" $f]} {
				lappend result $f
				}
		}
		set result [lsort $result]
		set fonts ""
		foreach f $result {
			lappend fonts "{$f} {$size} normal"
			lappend fonts "{$f} {$size} normal italic"
			lappend fonts "{$f} {$size} bold"
			lappend fonts "{$f} {$size} bold italic"
		}		

		set fontnames ""
		foreach f $result {
			lappend fontnames "$f Normal"
			lappend fontnames "$f Italic" 
			lappend fontnames "$f Bold" 
			lappend fontnames "$f Bold Italic"
		}
	}

	set i 0
	foreach fontn $fontnames {
	 set fontname($i) $fontn
	 incr i
	}
	set i 0

	set fontsize [option get . fontSize nt]

	#these should really be derived automatically
	set fw $newfw
	set fh $newfh

	# font height and width constants that shouldn't be changed.
	set fwu 7
	set fhu 13

	# delete the menu if it exists
	.m.cp.font.m delete 0 999
	foreach fonti $fonts {
		set font($i) $fonti
		.m.cp.font.m add command -label $fontname($i) -font $fonti \
			-command "set_font $i"
		incr i
	}
	.m.cp.font.m entryconfigure $cur_font -background gray85
}

proc view {size newfh newfw} {
	global fh fw charset tcl_platform

	# for each of the text items on the canvas change the size and re-position them
	foreach item [.m.l.txt.c find all] {
		catch {
			set font [.m.l.txt.c itemconfigure $item -font]
			if {$tcl_platform(platform) == "unix"} {
				if {[string match *medium-r* $font]} {.m.l.txt.c itemconfigure $item -font "-adobe-courier-medium-r-normal--*-$size-75-75-*-*-$charset"}
				if {[string match *medium-o* $font]} {.m.l.txt.c itemconfigure $item -font "-adobe-courier-medium-o-normal--*-$size-75-75-*-*-$charset"}
				if {[string match *bold-r* $font]} {.m.l.txt.c itemconfigure $item -font "-adobe-courier-bold-r-normal--*-$size-75-75-*-*-$charset"}
				if {[string match *bold-o* $font]} {.m.l.txt.c itemconfigure $item -font "-adobe-courier-bold-o-normal--*-$size-75-75-*-*-$charset"}
			} else {
				if {[string match *normal* $font]} {.m.l.txt.c itemconfigure $item -font "{[lindex [lindex $font 4] 0]} $size normal"}
				if {[string match *bold* $font]} {.m.l.txt.c itemconfigure $item -font "{[lindex [lindex $font 4] 0]} $size bold"}
				if {[string match *italic* $font]} {.m.l.txt.c itemconfigure $item -font "{[lindex [lindex $font 4] 0]} $size italic"}
				if {[string match {*bold italic*} $font]} {.m.l.txt.c itemconfigure $item -font "{[lindex [lindex $font 4] 0]} $size bold italic"}
			}
			set x [lindex [.m.l.txt.c coords $item] 0]
			set y [lindex [.m.l.txt.c coords $item] 1]
			set newy [expr $y/$fh]
			set newy [expr $newy*$newfh]	
			set newx [expr $x/$fw]
			set newx [expr $newx*$newfw]
			.m.l.txt.c coords $item $newx $newy	
		}
	}
	init_fonts $size $newfh $newfw
	grow_canvas
	update
}


############################################
# menus
############################################

menubutton .m.cp.file -text "File" -width 6 -menu .m.cp.file.m -relief raised \
    -borderwidth 1
menu .m.cp.file.m -tearoff 0
.m.cp.file.m add command -label "Load Plain Text" -command "load_text plain"
.m.cp.file.m add command -label "Load Structured Text" -command "load_text struct"
.m.cp.file.m add command -label "Save Plain Text" -command "save_text plain"
.m.cp.file.m add command -label "Save Structured Text" -command "save_text struct"
.m.cp.file.m add command -label "Quit                   (Ctrl-Q)" -command "quit"
wm protocol . WM_DELETE_WINDOW exit

menubutton .m.cp.edit -text "Edit" -width 6 -relief raised -borderwidth 1 \
    -menu .m.cp.edit.m
menu .m.cp.edit.m -tearoff 0
#.m.cp.edit.m add command -label "Undo" -command undo -state disabled
.m.cp.edit.m add command -label "Delete Block      (Ctrl-R)" \
    -command {try_to_delete_block $cur_block}
.m.cp.edit.m add command -label "Un-Delete Block (Ctrl-T)" \
	-command {try_to_undelete_block}
.m.cp.edit.m add command -label "Lower Block      (Ctrl-L)" \
    -command {lower_block $cur_block}
.m.cp.edit.m add command -label "Raise Block      (Ctrl-O)" \
	-command {raise_block $cur_block}
.m.cp.edit.m add command -label "Cut Block        (Ctrl-X)" \
	-command {cut_block $cur_block}
.m.cp.edit.m add command -label "Copy Block       (Ctrl-X)" \
	-command {copy_block $cur_block}
.m.cp.edit.m add command -label "Paste Block      (Ctrl-V)" \
	-command {paste_block}

menubutton .m.cp.col -text Colour -width 6 -menu .m.cp.col.m -relief raised \
    -borderwidth 1
menu .m.cp.col.m -activeforeground grey -tearoff 0
set cur_col 7
set colours {orange3 red yellow3 forestgreen blue magenta purple black}
set i 0
foreach coli $colours {
    set col($i) $coli
    .m.cp.col.m add command -label $coli -background $coli \
	-activebackground $coli -command "set_col $i"
    incr i
}

menubutton .m.cp.font -text Font -width 6 -menu .m.cp.font.m -relief raised \
    -borderwidth 1
menu .m.cp.font.m -tearoff 0

# set current font to bold
set cur_font 2

if {$tcl_platform(platform) == "unix"} {
	init_fonts 120 13 7
} else {
	init_fonts 9 16 7
}

menubutton .m.cp.view -text View -width 6 -menu .m.cp.view.m  -relief raised \
    -borderwidth 1
menu .m.cp.view.m -tearoff 0

# view proc: point size, font height, font width
set view 1
if {$tcl_platform(platform) == "unix"} {
	.m.cp.view.m add radiobutton -label "100%" -command {view 120 13 7} -variable view -value 1
	.m.cp.view.m add radiobutton -label "111%" -command {view 130 14 8} -variable view
	.m.cp.view.m add radiobutton -label "122%" -command {view 140 15 9} -variable view
	.m.cp.view.m add radiobutton -label "133%" -command {view 150 16 9} -variable view
	.m.cp.view.m add radiobutton -label "144%" -command {view 160 17 10} -variable view
	.m.cp.view.m add radiobutton -label "155%" -command {view 170 18 11} -variable view
} else {
	.m.cp.view.m add radiobutton -label "100%" -command {view 9 16 7} -variable view -value 1
	.m.cp.view.m add radiobutton -label "111%" -command {view 10 16 8} -variable view 
	.m.cp.view.m add radiobutton -label "122%" -command {view 11 17 9} -variable view 
	.m.cp.view.m add radiobutton -label "133%" -command {view 12 18 10} -variable view 
	.m.cp.view.m add radiobutton -label "144%" -command {view 13 20 10} -variable view 
	.m.cp.view.m add radiobutton -label "155%" -command {view 14 22 11} -variable view 
}

menubutton .m.cp.options -text Options -width 6 -menu .m.cp.options.m  -relief raised \
    -borderwidth 1
menu .m.cp.options.m -tearoff 0
set part_vis [option get . participants nt]
.m.cp.options.m add checkbutton -label "Participants List" -variable part_vis \
    -command {show_participants $part_vis}
set block_vis 1
.m.cp.options.m add checkbutton -label "Current Block Info" -variable block_vis \
    -command {show_block_info $block_vis}
set check_sum_active 0
.m.cp.options.m add checkbutton -label "Checksum Protocols" -variable check_sum_active \
    -command {set_checksum_active $check_sum_active}
set deselect_blocks 1
.m.cp.options.m add checkbutton -label "Deselect blocks when idle" -variable deselect_blocks \
	-command {check_activity}
set minimise_updates 1
.m.cp.options.m add checkbutton -label "Minimise screen updates" -variable minimise_updates \
	-command {ui_active_block $minimise_updates}

button .m.cp.help -text Help -width 6 -relief raised \
    -borderwidth 1 -command {webdisp help:about}

pack .m.cp.file .m.cp.edit .m.cp.col .m.cp.font .m.cp.view .m.cp.options -side left -fill y
pack .m.cp.help -side right -padx 0 -pady 0
pack .m.cp.l -side right -expand true -fill x

label .m.in.l -text "Block:" -font $infofont
label .m.in.bid -text "None" -font $infofont -width 16 -relief sunken \
    -borderwidth 1
label .m.in.cl -text "Created by:" -font $infofont
label .m.in.cid -text "" -font $infofont -width 20 -relief sunken \
    -borderwidth 1
label .m.in.ml -text "Changed by:" -font $infofont
label .m.in.mid -text "" -font $infofont -width 20 -relief sunken \
    -borderwidth 1
label .m.in.mtl -text " at:" -font $infofont
label .m.in.mt -text "00:00" -font $infofont -width 5 -relief sunken \
    -borderwidth 1
label .m.in.lck -bitmap "unlocked" -font $infofont -width 6


pack .m.in.l .m.in.bid -side left
pack  .m.in.lck -side left -ipadx 10
pack .m.in.cl .m.in.cid  \
    .m.in.ml .m.in.mid  \
    .m.in.mtl .m.in.mt -side left

proc show_block_info {flag} {
    if {$flag==1} {
	pack .m.in -side top -after .m.cp -fill x
    } else {
	pack forget .m.in
    }
}
############################################
#Session window stuff
############################################
frame .m.l.ss.l -borderwidth 0
button .m.l.ss.l.l -text "Participants" -command hide_participants \
    -relief flat
set keep_users FALSE
checkbutton .m.l.ss.l.keep -text "Keep" -command {ui_keep_userlist $keep_users} \
    -relief flat -variable keep_users -onvalue TRUE -offvalue FALSE\
    -font $infofont -borderwidth 1
frame .m.l.ss.f -relief sunken -borderwidth 2
scrollbar .m.l.ss.f.sb
text .m.l.ss.f.lb -width 20 -height 20 -relief flat -font $userfont \
    -yscroll ".m.l.ss.f.sb set" -wrap none -borderwidth 0
.m.l.ss.f.sb configure -command ".m.l.ss.f.lb yview" \
    -background [option get . background Mtool] \
    -troughcolor [option get . scrollbarBackground Mtool] \
    -borderwidth 1 -relief flat
bind .m.l.ss.f.lb <KeyPress> "break"
bind .m.l.ss.f.lb <B1-Motion> "break"
bind .m.l.ss.f.lb <1> "break"
.m.l.ss.f.lb tag configure inactive -foreground [option get . disabledForeground nt]
wnamemap .m.l.ss.f.lb participants-list
wnamemap .m.l.ss.f.sb participants-list-scrollbar
checkbutton .m.l.ss.readonly -text "Read Only" -relief flat \
    -font $userfont -borderwidth 1 -command {set_readable_mode $readonly} \
    -anchor w -highlightthickness 0
checkbutton .m.l.ss.locking -text "Lock New Items" -relief flat \
    -font $userfont -borderwidth 1 -command {set_lock_mode $locking} \
    -anchor w -highlightthickness 0
checkbutton .m.l.ss.encrypt -text "Encrypt Session" -relief flat \
    -font $userfont -borderwidth 1 -command {set_key $encrypt} \
    -anchor w -highlightthickness 0
label .m.l.ss.logo -bitmap "ucl"
pack .m.l.ss.f.lb -side left -fill both -anchor nw
pack .m.l.ss.f.sb -side right -fill y 
pack .m.l.ss.l -side top -fill x
pack .m.l.ss.l.l -side left -fill both
pack .m.l.ss.l.keep -side top -fill y -expand true -padx 0 -ipadx 0
pack .m.l.ss.f -side top -fill both
pack .m.l.ss.readonly -side top -anchor w -fill x
pack .m.l.ss.locking -side top -anchor w -fill x -pady 0 -ipady 0
pack .m.l.ss.encrypt -side top -anchor w -fill x -pady 0 -ipady 0
pack .m.l.ss.logo -side top -anchor w

proc set_checksum_active {status} {
	
	ui_set_checksum_status $status
}

proc hide_participants {} {
    global part_vis
    pack forget .m.l.ss
    set part_vis 0
}
proc show_participants {flag} {
    if {$flag==1} {
		pack forget .m.l.hsb
		pack .m.l.ss -before .m.l.txt -side right -fill both
		pack .m.l.hsb -side bottom -fill x -padx 2
    } else {
		pack forget .m.l.ss
    }
}
############################################
#Canvas stuff
############################################

set canvypos 0
set canvxpos 0

# smaller canvas size for windows
if {$tcl_platform(platform)=="windows"} {
	canvas .m.l.txt.c -height [expr 32 * $fh] -width [expr 90 * $fw] \
		-relief flat \
		-yscrollincrement $fh -background $canvcol \
		-confine true
} else {
	canvas .m.l.txt.c -height [expr 40 * $fh] -width [expr 90 * $fw] \
		-relief flat \
		-yscrollincrement $fh -background $canvcol \
		-confine true
}

scrollbar .m.l.txt.sb -command "scroll_canvas_y" \
    -background [option get . background Mtool] \
    -troughcolor [option get . scrollbarBackground Mtool] \
    -borderwidth 1 

scrollbar .m.l.hsb -command "scroll_canvas_x" \
    -background [option get . background Mtool] \
    -troughcolor [option get . scrollbarBackground Mtool] \
    -borderwidth 1 -orient horizontal

wnamemap .m.l.txt.c main-editor-panel
wnamemap .m.l.txt.sb main-editor-panel-scrollbar_y
wnamemap .m.l.hsb main-editor-panel-scrollbar_x

# The tcl/tk canvas speedup for windows doesn't support dashed lines
if {$tcl_platform(platform) == "unix"} {
	.m.l.txt.c addtag margin withtag \
	  [.m.l.txt.c create line [expr 90 * $fw] 0 [expr 90 * $fw] 520\
	 -stipple dashed -width 3]
} else {
	.m.l.txt.c addtag margin withtag \
	  [.m.l.txt.c create line [expr 90 * $fw] 0 [expr 90 * $fw] 520\
	 -fill gray80 -width 2]
}

#activity indicator
set activity_indicator ".m.l.ss.c2"
canvas $activity_indicator -width 20 -height 150 \
    -background $backcol -relief sunken -borderwidth 2
pack $activity_indicator -side top -fill both
$activity_indicator addtag win withtag \
    [$activity_indicator create rectangle 0 0 100 [expr 40 * $fh] \
     -fill $canvcol]
wnamemap .m.l.ss.c2 minimap

proc set_activity {max height top bottom} {
    global c2max c2top c2bottom c2height c2width activity_indicator
    set c2height [lindex [$activity_indicator configure -height] 4]
    set c2width [lindex [$activity_indicator configure -width] 3]
    set y1 [expr (($top * $c2height) / $max)]
    set y2 [expr (($bottom * $c2height) / $max)]
    $activity_indicator coords win 0 $y1 $c2width $y2
    set c2max $max
    set c2top $top
    set c2bottom $bottom
}

#set c2ctr 0
proc indicate_activity {id y pcol} {
    global col activity_indicator
    global c2max c2top c2bottom c2height c2width c2markers
    set y1 [expr ($y * $c2height) / $c2max]
    set code [catch {set tmp $c2markers($id)}]
    if {$code==0} {
	set c2markers($id) 1
	$activity_indicator coords $id 0 $y1 $c2width [expr $y1 + 10]
	return
    }
    set c2markers($id) 1
    $activity_indicator addtag $id withtag \
	[$activity_indicator create rectangle 0 $y1 20 [expr $y1 + 10] \
	 -fill $col($pcol)]
    after 5000 "$activity_indicator delete $id; unset c2markers($id)"
#    incr c2ctr
}

proc gc_dummy {a b c d} {
    grow_canvas
}
proc int {i} {
    return [lindex [split $i "."] 0]
}
proc grow_canvas {} {
    global fw fh canvypos canvxpos
    set ymax [lindex [.m.l.txt.c bbox all] 3]
    if {$ymax == ""} { set ymax 0.0 }
    set top [.m.l.txt.c canvasy 0]
	set left [.m.l.txt.c canvasx 0]
	set canvxpos [int $left]
    set canvypos [int $top]
    set height [lindex [.m.l.txt.c configure -height] 4]
    set bottom [.m.l.txt.c canvasy $height]
    if { ($ymax < $bottom) && ($ymax<$height) } {
		set ymax $bottom
    }
    .m.l.txt.c configure -scrollregion "0.0 0.0 {[expr $fw*110]} $ymax"
    if {$top < -$fh} {
		.m.l.txt.c yview scroll [expr -[int $top]/$fh] units
    }
    if {$ymax <= $bottom} {
		.m.l.txt.c yview moveto [expr 1.0-($height.0/$ymax)]
    }
    .m.l.txt.sb set [lindex [.m.l.txt.c yview] 0] [lindex [.m.l.txt.c yview] 1]
	.m.l.hsb set [lindex [.m.l.txt.c xview] 0] [lindex [.m.l.txt.c xview] 1]
    set_activity $ymax $height $top $bottom
    .m.l.txt.c coords margin [expr 90 * $fw] 0 [expr 90 * $fw] [expr $ymax -4]
}

proc scroll_canvas_y args {
    eval ".m.l.txt.c yview $args"
    grow_canvas
}

proc scroll_canvas_x args {
    eval ".m.l.txt.c xview $args"
    grow_canvas
}

#  -font -Adobe-Courier-Bold-R-Normal-*-120-* \
#  -yscroll ".m.l.txt.sb set" -wrap none
#scrollbar .m.l.txt.sb -command ".m.l.txt.t yview" \
#  -background [option get . scrollbarBackground Mtool] \
#  -foreground [option get . scrollbarForeground Mtool] \
#  -activeforeground [option get . scrollbarActiveForeground Mtool]

# check if there's been any activity in the last 60 secs
# if not then deactivate any blocks to reduce canvas updates.

proc check_activity {} {
	global last_update deselect_blocks
	if {$deselect_blocks == 0} {return}
	set curtime [expr [clock seconds] - 60]
	if {$curtime <=60} {after 60000 {check_activity}}
	if {$curtime >= $last_update} {
		.m.in.cid configure -text ""
		.m.in.mid configure -text ""
		.m.in.mt configure -text ""
		.m.in.bid configure -text "none" -foreground black
		focus .
		ui_active_block NULL
		after 60000 {check_activity}
	} else {
		after [expr $last_update - $curtime + 1] {check_activity}
	}
}
set last_update [clock seconds]
check_activity

proc set_info_display {} {
    global cur_block exists

	if {$cur_block=="bid0"}	{
	return
	}

	set tmp $exists($cur_block)
	if {$tmp==0} {
		#if block is deleted
		set creator ""
		set user ""
		 } else {
    
		set creator [ui_get_creator $cur_block]
		set user [lindex [split $creator "@"] 0]
		}

#catch all this in case we have problems with deleted blocks
    catch {
	
	.m.in.cid configure -text $creator

	if {$tmp==0} {
		#if cur_block is deleted
		.m.in.mid configure -text ""
		.m.in.mt configure -text ""
		.m.in.bid configure -text "none" 
	} else {
		#if cur_block not deleted
		.m.in.mid configure -text [ui_get_modifier $cur_block]
		.m.in.mt configure -text [ui_get_modification_time $cur_block]
		.m.in.bid configure -text $user:[string range $cur_block 9 end]
	}
	
	.m.in.bid configure -foreground \
	    [ lindex \
	     [.m.l.txt.c itemconfigure $cur_block -fill] \
		 4]
	if {[ui_get_lock_status $cur_block] == "LOCKED"} {
	    .m.in.lck configure -bitmap locked
	} else {
	    .m.in.lck configure -bitmap "unlocked"
	}
    
	}

}
proc insertWithTags {w text args} {
    set start [$w index insert]
    $w insert insert $text
    foreach tag [$w tag names $start] {
        $w tag remove $tag $start insert
    }
    foreach i $args {
        $w tag add $i $start insert
    }
}

#insertWithTags .m.l.txt.t {                                                                              
#} blank

set cur_block bid0
set exists($cur_block) 0 
set cur_line 0
#Emacs command bindings
bind .m.l.txt.c <Any-KeyPress>  "insert_char %x %y %A "

bind .m.l.txt.c <Control-a> move_linestart
bind .m.l.txt.c <Control-e> move_lineend
bind .m.l.txt.c <Control-n> move_down
bind .m.l.txt.c <Down> move_down
bind .m.l.txt.c <Control-p> move_up
bind .m.l.txt.c <Up> move_up
bind .m.l.txt.c <Control-f> move_fwd
bind .m.l.txt.c <Right> move_fwd
bind .m.l.txt.c <Meta-f> move_fwd
bind .m.l.txt.c <Control-b> move_bwd
bind .m.l.txt.c <Left> move_bwd
bind .m.l.txt.c <Meta-b> move_bwd
#bind .m.l.txt.c <Control-v> page_down
#bind .m.l.txt.c <Meta-v> page_up
bind .m.l.txt.c <Control-k> delete_to_end_of_line
#bind .m.l.txt.c <Control-y> insert_cut_buffer
bind .m.l.txt.c <Control-d> "move_fwd;delete_char"
bind .m.l.txt.c <Control-l> {lower_block $cur_block}
bind .m.l.txt.c <Control-o> {raise_block $cur_block}
bind .m.l.txt.c <Return> insert_cr
bind .m.l.txt.c <Delete> {delete_char;break}
bind .m.l.txt.c <BackSpace> {delete_char;break}
#bind .m.l.txt.c <Control-@> set_mark
#bind .m.l.txt.c <Control-w> delete_from_mark
bind .m.l.txt.c <Meta-Delete> delete_char
#bind .m.l.txt.c <Meta-\>> end_of_block
#bind .m.l.txt.c <Meta-<> start_of_block
bind .m.l.txt.c <Control-r> {try_to_delete_block $cur_block}
bind .m.l.txt.c <Control-t> try_to_undelete_block
bind .m.l.txt.c <Control-q> quit
bind .m.l.txt.c <Control-x> {cut_block $cur_block}
bind .m.l.txt.c <Control-c> {copy_block $cur_block}
bind .m.l.txt.c <Control-v> {paste_block}

bind .m.l.txt.c <1> {findblock [expr %x + $canvxpos] [expr %y + $canvypos]}
if {$tcl_platform(platform)=="unix"} {
    bind .m.l.txt.c  <B2-Motion> {moveblock [expr %x + $canvxpos] [expr %y + $canvypos]}
    bind .m.l.txt.c <ButtonRelease-2> {grow_canvas;clear_move_block}
} else {

# A hack to get the control key and mouse button to move text in Windows
    bind .m.l.txt.c <KeyPress-Control_L> {bind .m.l.txt.c <1> ""}
    bind .m.l.txt.c <KeyRelease-Control_L> {reset_binding}
    bind .m.l.txt.c  <Control-B1-Motion> {moveblock [expr %x + $canvxpos] [expr %y + $canvypos]}
    bind .m.l.txt.c <Control-ButtonRelease-1> {grow_canvas;clear_move_block}
}

proc reset_binding {} {
	bind .m.l.txt.c <1> {findblock [expr %x + $canvxpos] [expr %y + $canvypos]}
}

#the following binding would display all of the block id's in the page, but would then
#screw up by stopping the mouse from insertng new blocks so I'm removing it to prevent 
#accidental discovery by users - Jim
#bind .m.l.txt.c <Control-i> ui_print_ds
#replace with this 'useless' binding to prevent ctrl-i doing funny things.
bind .m.l.txt.c <Control-i> ""

bind .m.l.txt.c <3> {create_my_shared_pointer [expr %x + $canvxpos] [expr %y + $canvypos]}
bind .m.l.txt.c <B3-Motion> {move_my_shared_pointer [expr %x + $canvxpos] [expr %y + $canvypos]}
bind .m.l.txt.c <ButtonRelease-3> {delete_my_shared_pointer}

proc set_readable_mode {flag} {
    if {$flag==1} {
	read_only
    } else {
	read_write
    }
}

proc read_only {} {
    bind .m.l.txt.c <Any-KeyPress> ""
    bind .m.l.txt.c <Return> ""
    bind .m.l.txt.c <Delete> ""
    bind .m.l.txt.c <B2-Motion> ""
    bind .m.l.txt.c <1> ""
    pack forget .m.cp.edit
    pack forget .m.cp.font
    pack forget .m.cp.col
}

proc read_write {} {
    bind .m.l.txt.c <Any-KeyPress>  "insert_char %x %y %A "
    bind .m.l.txt.c <Return> insert_cr
    bind .m.l.txt.c <Delete> delete_char
    bind .m.l.txt.c  <B2-Motion> {moveblock [expr %x + $canvxpos] [expr %y + $canvypos]}
    bind .m.l.txt.c <1> {findblock [expr %x + $canvxpos] [expr %y + $canvypos]}
    pack .m.cp.edit -side left -after .m.cp.file
    pack .m.cp.col -side left -after .m.cp.edit
    pack .m.cp.font -side left -after .m.cp.col
}

proc set_lock_mode {flag} {
    if {$flag==1} {
	ui_set_lock_mode LOCKED
    } else {
	ui_set_lock_mode NORMAL
    }
}

proc set_col {coli} {
    global cur_block
    global col
    global cur_col exists

     set cur_col $coli
    ui_set_my_colour $cur_col

	set tmp $exists($cur_block)
	if {$tmp==0} {
		return }

   
    if {[ui_get_my_lock_status $cur_block] == "LOCKED" } { 
	display_lock $cur_block
	return 
    }
    .m.l.txt.c itemconfigure $cur_block -fill $col($coli)
    ui_set_block_colour $cur_block $coli
    set_info_display
}

proc set_font {fonti} {
    global cur_block font exists cur_font
	
	.m.cp.font.m entryconfigure $cur_font -background ""
	.m.cp.font.m entryconfigure $fonti -background gray85

	set cur_font $fonti

    set tmp $exists($cur_block)
	if {$tmp==0} {
		return }

    if {[ui_get_my_lock_status $cur_block] == "LOCKED" } { 
	display_lock $cur_block
	return 
    }
    .m.l.txt.c itemconfigure $cur_block -font $font($fonti)

    ui_set_block_font $cur_block $fonti
    set_info_display
}

proc set_posn {x y} {
    global cur_block
    global fw fh
    ui_set_block_posn $cur_block [expr $x/$fw] [expr $y/$fh]
}

set last_line 0


proc findblock {x y} {
  global cur_block
#  puts findblock
  new_block $x $y
}

#called from C to undisplay the block 
proc delete_block {id} {
	
	#fade block by changing the stipple (fill pattern) over time
    .m.l.txt.c itemconfigure $id -stipple gray75
    after 250 .m.l.txt.c itemconfigure $id -stipple gray50
    after 500 .m.l.txt.c itemconfigure $id -stipple gray33
    after 750 .m.l.txt.c itemconfigure $id -stipple gray25
	#now delete the block
    after 1000 .m.l.txt.c delete $id
	
}

#called from menu to actually delete it
proc try_to_delete_block {id} {
    global xpos ypos fw fh cur_col fhu fwu
	global exists

	
	#an extra piece of code to prevent us from trying to delete already deleted blocks

	set tmp $exists($id)
	if {$tmp==0} {
		return }
	
    if {[ui_get_my_lock_status $id] == "LOCKED"} {
	display_lock $id
	return
    } else {
	ui_send_shared_pointer [expr $xpos($id) * $fwu] \
	    [expr $ypos($id) * $fhu] $cur_col eraser
	after 250 ui_send_shared_pointer [expr $xpos($id) * $fwu + 20] \
	    [expr $ypos($id) * $fhu]  $cur_col eraser
	after 500 ui_send_shared_pointer [expr $xpos($id) * $fwu + 40] \
	    [expr $ypos($id) * $fhu] $cur_col eraser
	after 750 ui_send_shared_pointer [expr $xpos($id) * $fwu + 20] \
	    [expr $ypos($id) * $fhu] $cur_col eraser
	after 1000 ui_send_shared_pointer [expr $xpos($id) * $fwu] \
	    [expr $ypos($id) * $fhu] $cur_col eraser
	ui_delete_block $id
	delete_block $id

	# set status of this block as deleted, remove our knowledge of it..
	# I am using exists as 1=block has been created and still exists
	# 0=block has been created and has now been deleted.
			
	set exists($id) 0

	set_info_display
	grow_canvas
    }	
}

proc set_delete_status {id} {
	global exists

	set tmp $exists($id)
	if {$tmp==0} {return}
	
	delete_block $id
	# set status of this block as deleted, remove our knowledge of it..
	# I am using exists as 1=block has been created and still exists
	# 0=block has been created and has now been deleted.
	set exists($id) 0	
}

#called from menu to try to undo last block deletion
# working fine.
proc try_to_undelete_block {} {
		
	set newid [ui_generate_id]
	
	#call function in ui_fns.c

	ui_undelete_block $newid

	set_info_display
}

proc lower_block {id} {
	global exists
    #first check that block exists
	set tmp $exists($id)
	if {$tmp==0} {
		return }
	
	.m.l.txt.c lower $id
}

proc raise_block {id} {
	global exists
	#first check that block exists
	set tmp $exists($id)
	if {$tmp==0} {
		return }

	.m.l.txt.c raise $id
}


proc cut_block {id} {
	global exists clipboard
	#first check that block exists
	set tmp $exists($id)
	if {$tmp==0} {
		return }

	#ok we now know that the block exists. Copy it and delete it.
	#this is done by ui_fns command ui_cut_block, which deletes the block and stores
	#a reference to it.
	ui_copy_block $id

	set clipboard $id

	#delete from store as a deleted block
	try_to_delete_block $id	
}

proc copy_block {id} {
	global exists clipboard
	#first check that block exists
	set tmp $exists($id)
	if {$tmp==0} {
		return }

	set clipboard $id

	ui_copy_block $id

}

proc paste_block {} {
	ui_paste_block
}

proc startmoveblock {block x y} {
    global cur_block
    global cursor_x cursor_y send_y send_x
    global xpos ypos
    global fw fh
    global px py
    global move_block_end
    global old_block
    set lock [ui_get_my_lock_status $block]
    if { $lock == "LOCKED" } { 
	set cur_block $block
	display_lock $block
	return 
    }
    set move_block_end 0
    set cursor_x [expr $x - ($xpos($block) * $fw)]
    set cursor_y [expr $y - ($ypos($block) * $fh)]
    
	#jim change
	#set send_y [expr $y - ($ypos($block) * $fhu)]
	set send_y [expr $y - ($ypos($block) * $fh)]
	set send_x [expr $x - ($xpos($block) * $fw)]

    set px 0
    set py 0
#    puts "block: $block"
    
	set_cur_block $block $x $y
    flash_block $block
    set old_block 0
    set_info_display
}

proc moveblock {x y} {
    global cur_block fh fw fhu fwu
    global cursor_x cursor_y xpos ypos send_y send_x
    global cur_col
    global px py
    global move_block_end
    set lock [ui_get_my_lock_status $cur_block]
    if { $lock == "LOCKED" } { 
	display_lock $cur_block
	return 
    }
    if { $move_block_end == 1 } { return }
    set nx [expr $x - $cursor_x]
    set ny [expr $y - $cursor_y]
    set nx [expr $nx -($nx%$fw)]
    set ny [expr $ny -($ny%$fh)]
    if {($nx < 0)} { set nx 0 }
    if {($ny < 0)} { set ny 0 }

# adjust pointer...
    set send_ny [expr $y - $send_y]
	set send_nx [expr $x - $send_x]
	#jim change
    #set send_ny [expr $send_ny -($send_ny%$fh)]
    
	if {($send_ny < 0)} { set send_ny 0}
	if {($send_nx < 0)} { set send_nx 0}

    if {($nx!=$px)|($ny!=$py)} {
	
	#jim's changes
	set newy [expr $send_ny/$fh]
	set newy [expr $newy*$fhu]	
	
	set newx [expr $send_nx/$fw]
	set newx [expr $newx*$fwu]	

	ui_send_shared_pointer $newx $newy $cur_col hand
	#ui_send_shared_pointer $nx $send_ny $cur_col hand
	#end of jim's changes 
	set_posn $nx $ny
	set px $nx
	set py $ny
	set xpos($cur_block) [expr $nx/$fw]
	set ypos($cur_block) [expr $ny/$fh]
#	puts "pos: $xpos($cur_block),$ypos($cur_block)"
	.m.l.txt.c coords $cur_block $nx $ny
    }
}

proc clear_move_block {} {
    global move_block_end
    set move_block_end 1
}


# extra support function for 
proc delete_char2 {} {
  global cur_block exists
  global xpos ypos
  global xp yp fhu last_update
  global curline curlnum fw fh cur_col
  
	set tmp $exists($cur_block)
	if {$tmp==0} {
		return }

  if {[ui_get_my_lock_status $cur_block] == "LOCKED" } { 
      display_lock $cur_block
      return 
  }

  set last_update [clock seconds]
  set pos [.m.l.txt.c index $cur_block insert]
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set xcpos [.m.l.txt.c index $cur_block xinsert]
  set ycpos [.m.l.txt.c index $cur_block yinsert]
  set lstart [.m.l.txt.c index $cur_block linestart]
  set lend [.m.l.txt.c index $cur_block lineend]
  set curline [string range $txt $lstart $lend]


  if { [string index $txt [expr $pos-1]]=="\n"} {
      ui_delete_line $cur_block $ycpos
  }
 
  textBs .m.l.txt.c $cur_block
  set pos [.m.l.txt.c index $cur_block insert]
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set xcpos [.m.l.txt.c index $cur_block xinsert]
  set ycpos [.m.l.txt.c index $cur_block yinsert]
  set lstart [.m.l.txt.c index $cur_block linestart]
  set lend [.m.l.txt.c index $cur_block lineend]
  set curline [string range $txt $lstart $lend]
  #ui_set_line $cur_block $ycpos $curline
  #ui_send_shared_pointer [expr $fw * ($xpos($cur_block) + $xcpos)] \
  #    [expr $fhu * ($ypos($cur_block) + $ycpos)]\
  #        $cur_col pen
  #set_info_display
}

# function added by jim to resemble the emacs ctrl-k command

proc delete_to_end_of_line {} {
	global cur_block exists

	#replace current line with the current line before the cursor's position
	
	# return if no block to work with
	if {$exists($cur_block)==0} {
		return
		}
	
	# stuff from insert char modified for our purposes
	#set pos [.m.l.txt.c index $cur_block insert]
	#set xcpos [.m.l.txt.c index $cur_block xinsert]
	#set ycpos [.m.l.txt.c index $cur_block yinsert]
	#set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
	#set lstart [.m.l.txt.c index $cur_block linestart]
	#set lend [.m.l.txt.c index $cur_block lineend]
	#set curline [string range $txt $lstart $lend]


	set loop_until 1
	
    # THIS IS WHERE ALL OF THE ERRORS WERE!!!! - didn't like doing it on the last line
	#  -- therefore last line doesn't have a closing \n, need to use some other form of
	#     detection method.
    # I have now implemented above plan.

	set pos [.m.l.txt.c index $cur_block insert]
		set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]

	set end_pos [string first "\n" [string range $txt $pos end] ]
	if {$end_pos == -1} {
		#.m.l.txt.c icursor $cur_block end
		set i [string length $txt]
		set i [expr $i-$pos]
		while {$i>0} {
			set i [expr $i-1]
			move_fwd
			delete_char2
		}

	} else {

	set pos [.m.l.txt.c index $cur_block insert]
	set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
	if { [string index $txt $pos]=="\n"} {
		move_fwd
		delete_char2
	} else {


		while {$loop_until==1} {
			set pos [.m.l.txt.c index $cur_block insert]
			set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]

			if { [string index $txt $pos]=="\n"} {
				set loop_until 0						
				} else {
				move_fwd
				delete_char2
				}
			} 


		}

	}

	#OK - now we update the line and resend it
		
	# now re-send the line.
	set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
	set ycpos [.m.l.txt.c index $cur_block yinsert]
	set lstart [.m.l.txt.c index $cur_block linestart]
	set lend [.m.l.txt.c index $cur_block lineend]
	set curline [string range $txt $lstart $lend]
	ui_set_line $cur_block $ycpos $curline

}

proc move_linestart {} {
  global cur_block exists
    set tmp $exists($cur_block)
	if {$tmp==0} {
		return }
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set pos [.m.l.txt.c index $cur_block insert]
  set newpos [string last "\n" [string range $txt 0 [expr $pos - 1]] ]
  .m.l.txt.c icursor $cur_block [expr $newpos + 1]
}

proc move_lineend {} {
  global cur_block exists
  set tmp $exists($cur_block)
	if {$tmp==0} {
		return }
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set pos [.m.l.txt.c index $cur_block insert]
  set newpos [string first "\n" [string range $txt $pos end] ]
  if {$newpos == -1} {
      .m.l.txt.c icursor $cur_block end
  } else {
      .m.l.txt.c icursor $cur_block [expr $pos + $newpos]
  }
}

proc move_fwd {} {
  global cur_block exists 
	set tmp $exists($cur_block)
	if {$tmp==0} {
		return }

  .m.l.txt.c icursor $cur_block [expr [.m.l.txt.c index $cur_block insert] + 1]
}

proc move_bwd {} {
  global cur_block exists
  	set tmp $exists($cur_block)
	if {$tmp==0} {
		return }
  .m.l.txt.c icursor $cur_block [expr [.m.l.txt.c index $cur_block insert] - 1]
}

proc move_up {} {
  global cur_block exists
  	set tmp $exists($cur_block)
	if {$tmp==0} {
		return }

  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set pos [.m.l.txt.c index $cur_block insert]
  set newpos [string last "\n" [string range $txt 0 [expr $pos - 1]] ]
  if {$newpos == -1} { return }
  set linepos [expr $pos - $newpos]
  set prevstart [string last "\n" [string range $txt 0 [expr $newpos - 1]] ]
  .m.l.txt.c icursor $cur_block [expr $linepos + $prevstart]
  set lnum [.m.l.txt.c index $cur_block yinsert]
  move_up_out_of_window $cur_block $lnum
}

proc move_down {} {
  global cur_block exists 
  	set tmp $exists($cur_block)
	if {$tmp==0} {
		return }
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set pos [.m.l.txt.c index $cur_block insert]
  set linestart [string last "\n" [string range $txt 0 [expr $pos - 1]] ]
  set nextstart [string first "\n" [string range $txt $pos end ]]
  set linepos [expr $pos - $linestart]
  if {$nextstart==-1} {
      return
  }
  .m.l.txt.c icursor $cur_block [expr $linepos + $nextstart + $pos]
  set lnum [.m.l.txt.c index $cur_block yinsert]
  move_down_out_of_window $cur_block $lnum
}

proc insert_cr {} {
  global cur_block exists 
  global curline curlnum
  global max_block_size last_update

  set tmp $exists($cur_block)
  if {$tmp==0} {return}
  set lock [ui_get_my_lock_status $cur_block]
  if { $lock == "LOCKED" } { 
      display_lock $cur_block
      return 
  }
  
  set last_update [clock seconds]
  #default max_block_size is 200, but allow us to change it if user changes their mind
  set max_block_size [ui_get_max_block_size]

  # get the current number of lines in the chosen block
  set ysize [ ui_get_block_length $cur_block ]
  
  if { $ysize>=$max_block_size } {
	# if the current block is already max_line, or more, lines long, then we can't add any more.
	# This is to avoid a lot of problems with running out of memory in block processing. 
	# This also enforces the 'max_no_of_lines' variable set by the user.
	return
  }

  set oldpos [.m.l.txt.c index $cur_block insert]
  set oldlnum [.m.l.txt.c index $cur_block yinsert]
  .m.l.txt.c insert $cur_block insert "\n"

  set pos [.m.l.txt.c index $cur_block insert]
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  ui_new_line $cur_block $oldlnum

  set lstart [.m.l.txt.c index $cur_block linestart]
  set lend [.m.l.txt.c index $cur_block lineend]
  set curline [string range $txt $lstart $lend]
  set curlnum [.m.l.txt.c index $cur_block yinsert]
  ui_set_line $cur_block $curlnum $curline

  get_line $txt $oldpos
  ui_set_line $cur_block $curlnum $curline

  set_info_display
  update

#see whether this takes us off the bottom of the screen
  move_down_out_of_window $cur_block $curlnum
  update
  grow_canvas
}

proc move_down_out_of_window {id lnum} {
  global xpos ypos fh fw
  set height [lindex [.m.l.txt.c configure -height] 4]
  set bottom [.m.l.txt.c canvasy $height]
  if {[expr $fh * ($lnum + $ypos($id) + 2)] > $bottom } {
      set ymax [lindex [.m.l.txt.c bbox all] 3]
      if {$ymax == ""} { set ymax 0.0 }
      set top [expr ([.m.l.txt.c canvasy 0]+$fh) / $ymax]
      .m.l.txt.c yview moveto $top
      .m.l.txt.sb set [lindex [.m.l.txt.c yview] 0] [lindex [.m.l.txt.c yview] 1]
      grow_canvas
  }
}

proc move_up_out_of_window {id lnum} {
  global xpos ypos fh fw
  set top [.m.l.txt.c canvasy 0]
  if {[expr $fh * ($lnum + $ypos($id) + 0)] < $top } {
      set ymax [lindex [.m.l.txt.c bbox all] 3]
      if {$ymax == ""} { set ymax 0.0 }
      set top [expr ([.m.l.txt.c canvasy 0]-$fh) / $ymax]
      if {$top < 0} { set top 0 }
      .m.l.txt.c yview moveto $top
      .m.l.txt.sb set [lindex [.m.l.txt.c yview] 0] [lindex [.m.l.txt.c yview] 1]
      grow_canvas
  }
}

proc insert_char {x y A} {
  global cur_block 
  global xpos ypos
  global xp yp
  global curline curlnum cur_col
  global fh fw fhu fwu
  global exists
  set lock [ui_get_my_lock_status $cur_block]

  if { $lock == "LOCKED" } { 
      display_lock $cur_block
      return 
  }

  # if block doesn't exist - return


  set tmp $exists($cur_block)
  if ($tmp==0) {
    return
	}

  # set code [catch {set tmp $exists($cur_block)}]
  # if {$code==0} {
  #	 return
  # } 

  #catch {set xcpos [.m.l.txt.c index $cur_block xinsert]}
  set xcpos [.m.l.txt.c index $cur_block xinsert]
  if {[expr $xcpos + $xpos($cur_block)] == 89} {
      insert_cr
  }

  if {[string compare $A "\n"] == 0} {return}
  .m.l.txt.c insert $cur_block insert $A
  set pos [.m.l.txt.c index $cur_block insert]
  set xcpos [.m.l.txt.c index $cur_block xinsert]
  set ycpos [.m.l.txt.c index $cur_block yinsert]
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set lstart [.m.l.txt.c index $cur_block linestart]
  set lend [.m.l.txt.c index $cur_block lineend]
  set curline [string range $txt $lstart $lend]
  catch {ui_set_line $cur_block $ycpos $curline}
  ui_send_shared_pointer [expr $fwu * ($xpos($cur_block) + $xcpos)] \
      [expr $fhu * ($ypos($cur_block) + $ycpos)]\
	  $cur_col pen
  set_info_display
}

proc get_line {txt pos} {
  global curline
  global curlnum
  set lines [split $txt "\n"]
#  puts $lines
  set offset 0
  set lnum 0
  set curline ""
  set curlnum 0
  foreach line $lines {
      if {[expr $offset + [string length $line]] >= $pos} {
	  set curline $line
	  set curlnum $lnum
	  break
      }
      incr lnum
      set offset [expr $offset + [string length $line] + 1]
  }
}

proc delete_char {} {
  global cur_block exists
  global xpos ypos
  global xp yp fhu fwu
  global curline curlnum fw fh cur_col
  
	set tmp $exists($cur_block)
	if {$tmp==0} {
		return }

  if {[ui_get_my_lock_status $cur_block] == "LOCKED" } { 
      display_lock $cur_block
      return 
  }
  set pos [.m.l.txt.c index $cur_block insert]
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set xcpos [.m.l.txt.c index $cur_block xinsert]
  set ycpos [.m.l.txt.c index $cur_block yinsert]
  set lstart [.m.l.txt.c index $cur_block linestart]
  set lend [.m.l.txt.c index $cur_block lineend]
  set curline [string range $txt $lstart $lend]


  if { [string index $txt [expr $pos-1]]=="\n"} {
      ui_delete_line $cur_block $ycpos
  }
 
  textBs .m.l.txt.c $cur_block
  set pos [.m.l.txt.c index $cur_block insert]
  set txt [lindex [.m.l.txt.c itemconfigure $cur_block -text] 4]
  set xcpos [.m.l.txt.c index $cur_block xinsert]
  set ycpos [.m.l.txt.c index $cur_block yinsert]
  set lstart [.m.l.txt.c index $cur_block linestart]
  set lend [.m.l.txt.c index $cur_block lineend]
  set curline [string range $txt $lstart $lend]
  ui_set_line $cur_block $ycpos $curline
  ui_send_shared_pointer [expr $fwu * ($xpos($cur_block) + $xcpos)] \
      [expr $fhu * ($ypos($cur_block) + $ycpos)]\
          $cur_col pen
  set_info_display
}

proc textBs {w b} {
    set char [expr {[$w index $b insert] - 1}]
    if {$char >= 0} {$w dchar $b $char}
}

proc set_block_posn {blockid x y} {
    global fw fh
    global xpos ypos
    .m.l.txt.c coords $blockid \
	[expr $fw * $x] [expr $fh * $y]
    set xpos($blockid) $x
    set ypos($blockid) $y
    grow_canvas
}

proc set_block_colour {id coli} {
    global col
    global cur_block
    .m.l.txt.c  itemconfigure $id -fill $col($coli)
    if {$id == $cur_block} {set_info_display}
}

proc set_block_font {id fonti} {
    global font
    .m.l.txt.c itemconfigure $id -font $font($fonti)
}

proc set_block {id str x y fonti coli} {
    global exists
    global cur_block xpos ypos fw fh
    set code [catch {set tmp $exists($id)}]
    if {$code==1} {
        set exists($id) 1
	create_block_item $id $x $y $fonti $coli
    }
    
	#get current cursor-x/y position - we will get the nearest graphic position and 
	# go from there..

    set xcpos [.m.l.txt.c index $id xinsert]
	set ycpos [.m.l.txt.c index $id yinsert]
	
	set xdisp [ expr [ expr $xcpos + $x] * $fw]
	set ydisp [ expr [ expr $ycpos + $y] * $fh]

	#set the block's string
	.m.l.txt.c itemconfigure $id -text $str

	#reset cursor-x/y in this block as the graphical position it was before
	#this is better than it was but it still doesn't cope well with line 
	#insertion or deletion.
	.m.l.txt.c icursor $id @$xdisp,$ydisp
	
    if {$cur_block==$id} { set_info_display }
    grow_canvas
}

proc tcol {tag col} {
  .m.l.txt.t tag configure $tag -foreground $col
}

proc get_cur_tag {} {
  global cur_block
#  puts "cur block now $cur_block"
}

set maxid 1
set old_block 0

proc new_block {x y} {
  global cur_block xpos ypos col cur_col font cur_font
  global maxid exists fw fh old_block last_update
  set last_update [clock seconds]
  if {$old_block==1} {
#    puts oldblock
    set_info_display
    flash_block $cur_block
	ui_active_block $cur_block
    set old_block 0
    return
  }
  set y [expr $y / $fh]
  set x [expr $x / $fw]
  set cur_block [ui_generate_id]
  ui_active_block $cur_block
  set cur_line 0
  set xpos($cur_block) $x
  set ypos($cur_block) $y
#don't know why I need this catch when I'm returning TCK_OK
  catch { ui_new_block $cur_block $xpos($cur_block) $ypos($cur_block) \
      $cur_col $cur_font }
  set exists($cur_block) 1
  create_block_item $cur_block $x $y $cur_font $cur_col
  .m.l.txt.c icursor $cur_block @$x,$y
  .m.l.txt.c focus $cur_block
  focus -force .m.l.txt.c
  set_info_display
}

proc set_cur_block {w x y} {
    global cur_block
    global old_block
    set old_block 1
#    puts "cur_block: $w"
    set cur_block $w
    .m.l.txt.c icursor $w @$x,$y
    .m.l.txt.c focus $w
    focus -force .m.l.txt.c
}

set flash_col none
proc flash_block {id} {
    global flash_col
#another global needed to make this re-entrant
    if {$flash_col == "none"} {
	set flash_col [lindex [.m.l.txt.c itemconfigure $id -fill] 4]
    }
    .m.l.txt.c itemconfigure $id -fill gray80
    after 150 ".m.l.txt.c itemconfigure $id -fill $flash_col; \
               set flash_col \"none\""
}

pack append .m.l.txt \
    .m.l.txt.sb {right filly} \
    .m.l.txt.c {left fill expand}
	

if {$part_vis==1} {
    pack .m.l.ss -side right -fill both 
}
pack .m.l.hsb -side bottom -fill x -padx 2
pack .m.l.txt -side top -fill both -expand true


pack append .m \
     .m.cp {top fillx} \
     .m.in {top fillx} \
     .m.l {top fill expand}

pack append . .m {top fill expand}
wm minsize . 600 200

#call it now to initialise the scrollbar...
grow_canvas
update

proc load_text {mode} {
	global load_mode
	set load_mode $mode

	set types {
		{{Text File} {.txt}  }
	}
	if {[string compare $mode "plain"]==0} {
		set wtitle "Select a plain text file to load:"
	} else {
		set wtitle "Select an nte structured file to load:"
	}
	set filename [tk_getOpenFile -defaultextension .txt \
		-filetypes $types \
		-parent . -title $wtitle]

	if {$filename == ""} return
	load_text_file $load_mode $filename
}

proc load_text_file {mode file} {
  global cur_block
  global cur_line
  global cur_col
  global cur_font
  global xpos ypos
  global font
  global exists
  if {[file isdirectory $file]} {
    .load.f.lb delete 0 end
    cd $file
    .load.f.lb insert end ".."
    foreach i [glob *] {
      .load.f.lb insert end $i
    }
    .load.entry delete 0 end
    .load.entry insert 0 [pwd]
  } elseif {[file readable $file]} {
      if {$mode=="plain"} {
	  set cur_block [ui_generate_id]
	  set ypos($cur_block) 0
	  set xpos($cur_block) 0
	  ui_new_block $cur_block 0 0 $cur_col $cur_font
	  set exists($cur_block) 1
	  create_block_item $cur_block 0 0 $cur_font $cur_col
	  ui_load_text_file $file
	  grow_canvas
	  set_col $cur_col
	  set_font $cur_font
	  catch {destroy .load}
	  update
	  set_info_display
      } else {
	  ui_load_struct_file $file
	  catch {destroy .load}
      }
  } else {
      error "File not readable"
  }
}

proc save_text {mode} {
	global save_mode
	set save_mode $mode

	set types {
		{{Text File} {.txt}  }
	}
	if {[string compare $mode "plain"]==0} {
		set wtitle "Select a plain text file to save:"
	} else {
		set wtitle "Select an nte structured file to save:"
	}
	set filename [tk_getSaveFile -defaultextension .txt \
		-filetypes $types \
		-parent . -title $wtitle]

	if {$filename == ""} return

	set save_pptnts [tk_dialog ".dialog" "save file" "save participant information?" "" 1 "Yes" "No" ]

	save_text_file $save_pptnts $save_mode $filename 
}


proc save_text_file {save_pptns mode file} {
  global cur_block
  global cur_line
  global cur_col
  global cur_font
  global xpos ypos
  global font
  global exists
  if {[file isdirectory $file]} {
    .save.f.lb delete 0 end
    cd $file
    .save.f.lb insert end ".."
    foreach i [glob *] {
      .save.f.lb insert end $i
    }
    .save.entry delete 0 end
    .save.entry insert 0 [pwd]
  } else {
      if {$mode=="plain"} {
	  ui_save_text_file $save_pptns $file
      } else {
	  ui_save_struct_file $file
      }
      catch {destroy .save}
      update
      set_info_display
  }
}

proc quit {} {
    ui_quit
    destroy .
}
proc add_participant {c} {
    global c_str col
#    puts "add: $c_str, $c"
    set pos [.m.l.ss.f.lb index end-1c]
#    .m.l.ss.f.lb configure -state normal
    .m.l.ss.f.lb insert end "$c_str\n"
    .m.l.ss.f.lb tag add "l$c_str" $pos end-1c
    .m.l.ss.f.lb tag configure "l$c_str" -foreground $col($c)
    .m.l.ss.f.lb tag bind "l$c_str" <1> "show_participant_details %y"
#    .m.l.ss.f.lb configure -state disabled
}
proc update_participant_details {pos y} {
	set details [get_participant_by_number [expr $pos -1]]
	if {$details==""} return
	.pt$pos.f.l4 configure -text "Packets received: [lindex $details 5]"
	after 1000 "participant_timer $pos $y"
}

proc participant_timer {pos y} {
	if {[winfo exists .pt$pos]} {update_participant_details $pos $y}
}

proc show_participant_details {y} {
    global col
    set pos [.m.l.ss.f.lb index @0,$y]
    set pos [lindex [split $pos "."] 0]
    set details [get_participant_by_number [expr $pos -1]]
    catch {destroy .pt$pos}
    toplevel .pt$pos 
    wm title .pt$pos "Participant Details"
    frame .pt$pos.f -borderwidth 2 -relief groove
    pack .pt$pos.f -side top -fill both
    label .pt$pos.f.l1 -text [lindex $details 0]
    pack .pt$pos.f.l1 -side top -anchor nw
    label .pt$pos.f.l2 -text "NTE version: [lindex $details 1]"
    pack .pt$pos.f.l2 -side top -anchor nw
    label .pt$pos.f.l3 -text "Platform: [lindex $details 2]"
    pack .pt$pos.f.l3 -side top -anchor nw
	label .pt$pos.f.l4 -text "Packets received: [lindex $details 5]"
    pack .pt$pos.f.l4 -side top -anchor nw
    frame .pt$pos.f.f -borderwidth 0
    pack .pt$pos.f.f -side top -fill x -expand true
    label .pt$pos.f.f.l1 -text "Current colour:"
    pack .pt$pos.f.f.l1 -side left
    label .pt$pos.f.f.l2 -text "        " -background $col([lindex $details 3])
    pack .pt$pos.f.f.l2 -side right -fill x -expand true

    button .pt$pos.f.dismiss -text "Dismiss" -command "destroy .pt$pos"
    pack .pt$pos.f.dismiss -side top -fill x -expand true
	after 1000 "participant_timer $pos $y"
}
proc rm_participant {n} {
#    .m.l.ss.f.lb configure -state normal
    .m.l.ss.f.lb delete [expr $n + 1].0 "[expr $n + 2].0"
#    .m.l.ss.f.lb configure -state disabled
}

#proc clear_participants {} {
#    .m.l.ss.f.lb delete 2.0 end
#}

proc uncolour_participant {n c} {
    global col
#    puts "uncolour $n $c"
#    .m.l.ss.f.lb configure -state normal
#    .m.l.ss.f.lb tag remove "l$c" [expr $n + 1].0 "[expr $n + 1].0 lineend"
#    .m.l.ss.f.lb configure -state disabled
}

proc colour_participant {n c} {
    global col
#    puts "colour $n $c"
#    .m.l.ss.f.lb configure -state normal
#    .m.l.ss.f.lb tag add "l$c" [expr $n + 1].0 "[expr $n + 1].0 lineend"
    set tags [.m.l.ss.f.lb tag names [expr $n + 1].0]
    .m.l.ss.f.lb tag configure [lindex $tags 0] -foreground $col($c)
#    .m.l.ss.f.lb configure -state disabled
#    puts $col($c)
}

proc activate_participant {n} {
#    .m.l.ss.f.lb configure -state normal
    .m.l.ss.f.lb tag remove inactive [expr $n + 2].0 "[expr $n + 1].0 lineend"
#    .m.l.ss.f.lb configure -state disabled
}

proc deactivate_participant {n} {
#    .m.l.ss.f.lb configure -state normal
    .m.l.ss.f.lb tag add inactive [expr $n + 1].0 "[expr $n + 1].0 lineend"
#    .m.l.ss.f.lb configure -state disabled
}

proc create_my_shared_pointer {x y} {
    global cur_col
    create_shared_pointer myid me $x $y $cur_col arrow
}
proc create_shared_pointer {id name x y pcol style} {
    global pxpos pypos
    global col font fw fh
    indicate_activity $id $y $pcol
    if {$style=="arrow"} {
	.m.l.txt.c addtag $id withtag \
	    [.m.l.txt.c create \
	     polygon 0 0 10 0 6 4 35 25 25 25 25 35 4 6 0 10 0 0 \
		 -fill $col($pcol)]
	.m.l.txt.c addtag $id.bg withtag \
            [.m.l.txt.c create \
	     rectangle [expr $x + 25] [expr $y + 25] \
		 [expr $x + 27 + [expr [string length $name] * $fw]] \
		 [expr $y + 25 + $fh ] -fill white -outline $col($pcol) ]
	.m.l.txt.c addtag $id.label withtag \
	    [.m.l.txt.c create \
	     text [expr $x + 26] [expr $y + 25] -fill $col($pcol) -anchor nw \
		 -text $name -font $font(2)]
    }
    if {$style=="oldhand"} {
        .m.l.txt.c addtag $id withtag \
            [.m.l.txt.c create \
             polygon \
		 0 -10  20 -10  20 0  15 0  15 -3  -3 -3  -3 15  0 15 \
		 0 20  -10 20  -10 0  -20 -10 -10 -20 \
                 -fill $col($pcol)]
	.m.l.txt.c addtag $id.bg withtag \
            [.m.l.txt.c create \
	     rectangle [expr $x - 2] [expr $y - 23] \
		 [expr $x + [expr [string length $name] * $fw]] \
		 [expr $y - 23 + $fh] -fill white -outline ""]
        .m.l.txt.c addtag $id.label withtag \
            [.m.l.txt.c create \
             text [expr $x - 2] [expr $y - 23] -fill $col($pcol) -anchor nw \
                 -text $name  -font $font(2)]
    }
    if {$style=="hand"} {
        .m.l.txt.c addtag $id withtag \
            [.m.l.txt.c create \
            bitmap 0 0 -foreground $col($pcol) -anchor ne \
                 -bitmap "digger" ]
	.m.l.txt.c addtag $id.bg withtag \
            [.m.l.txt.c create \
	     rectangle [expr $x - 42] [expr $y - 15] \
		 [expr $x + [expr [string length $name] * $fw] - 40] \
		 [expr $y - 15 + $fh] -fill white -outline $col($pcol)]
        .m.l.txt.c addtag $id.label withtag \
            [.m.l.txt.c create \
             text [expr $x - 42] [expr $y - 15] -fill $col($pcol) -anchor nw \
                 -text $name  -font $font(2)]
    }
    if {$style=="lock"} {
        .m.l.txt.c addtag $id withtag \
            [.m.l.txt.c create \
	     bitmap 0 0 -foreground $col($pcol) -anchor nw \
                 -bitmap "locked" ]
	.m.l.txt.c addtag $id.bg withtag \
            [.m.l.txt.c create \
	     rectangle [expr $x + 20] $y \
		 [expr $x + 22 + [expr [string length $name] * $fw]] \
		 [expr $y + 1 + $fh ] -fill white -outline $col($pcol) ]
        .m.l.txt.c addtag $id.label withtag \
            [.m.l.txt.c create \
             text [expr $x +20] $y -fill $col($pcol) -anchor nw \
                 -text $name  -font $font(2)]
    }
    if {$style=="eraser"} {
        .m.l.txt.c addtag $id withtag \
            [.m.l.txt.c create \
	     bitmap 0 0 -foreground $col($pcol) -anchor nw \
                 -bitmap "eraser" ]
	.m.l.txt.c addtag $id.bg withtag \
            [.m.l.txt.c create \
	     rectangle [expr $x + 32] $y \
		 [expr $x + 34 + [expr [string length $name] * $fw]] \
		 [expr $y + 1 + $fh ] -fill white -outline $col($pcol) ]
        .m.l.txt.c addtag $id.label withtag \
            [.m.l.txt.c create \
             text [expr $x +30] $y -fill $col($pcol) -anchor nw \
                 -text $name  -font $font(2)]
    }
    if {$style=="pen"} {
        .m.l.txt.c addtag $id withtag \
            [.m.l.txt.c create \
	     bitmap 0 0 -foreground $col($pcol) -anchor s \
                 -bitmap "pen" ]
	.m.l.txt.c addtag $id.bg withtag \
            [.m.l.txt.c create \
	     rectangle [expr $x + 8] [expr $y - 30]\
		 [expr $x + 10 + [expr [string length $name] * $fw]] \
		 [expr $y -30 + $fh ] -fill white -outline $col($pcol) ]
        .m.l.txt.c addtag $id.label withtag \
            [.m.l.txt.c create \
             text [expr $x +9] [expr $y - 30] -fill $col($pcol) -anchor nw \
                 -text $name  -font $font(2)]
    }
    .m.l.txt.c move $id $x $y 
    set pxpos($id) $x
    set pypos($id) $y
}

proc move_my_shared_pointer {x y} {
    global cur_col fhu fh fwu fw
    
	#((ADDED LINES - JIM))
	set newy [expr $y*$fhu]
	set newy [expr $newy/$fh]  
	
	set newx [expr $x*$fwu]
	set newx [expr $newx/$fw]  
	move_shared_pointer myid me $newx $newy $cur_col arrow
	#changes made by jim, to transmit 'unix friendly' pointer.
	#replaced next line and added two extra lines above
	
	#ui_send_shared_pointer $x $y $cur_col arrow  
	
	
	
	ui_send_shared_pointer $newx $newy $cur_col arrow
}

# pointer_style - used to store the last style of shared pointer drawn.
set pointer_style "none"

proc move_shared_pointer {id name x y pcol style} {
    global pxpos pypos fhu fh fwu fw pointer_style
    
	
	if {($x==65535)&&($y==65535)} {
	catch {
	    delete_shared_pointer $id
	}
	return
    }
    
	# convert pointer y co-ords- this was setup for windows
		set newy [expr $y*$fh]
		set y [expr $newy/$fhu]
		set newx [expr $x*$fw]
		set x [expr $newx/$fwu]

    indicate_activity $id $y $pcol
    
	# extra jim bit - to make sure pointer is drawn using the correct style
	if {$pointer_style!=$style} { 		
		set pointer_style $style
		delete_shared_pointer $id
		create_shared_pointer $id $name $x $y $pcol $style
		after 5000 "delete_shared_pointer $id"
	}
		
	if { [catch {
		set nx [expr $x - $pxpos($id)]
		set ny [expr $y - $pypos($id)]
		.m.l.txt.c move $id.label $nx $ny
		.m.l.txt.c move $id $nx $ny
		.m.l.txt.c move $id.bg $nx $ny
		set pxpos($id) $x
		set pypos($id) $y
	  } ] == 1} {
	

			create_shared_pointer $id $name $x $y $pcol $style
			after 5000 "delete_shared_pointer $id"
	
		}
}

proc delete_my_shared_pointer {} {
    delete_shared_pointer myid
    ui_send_shared_pointer 65535 65535 0 arrow
}

proc delete_shared_pointer {id} {
    global pxpos pypos
    catch {
	.m.l.txt.c delete $id
	.m.l.txt.c delete $id.bg
	.m.l.txt.c delete $id.label
	unset pxpos($id)
	unset pypos($id)
    }

}
proc display_lock {blockid} {
    global xpos ypos
    global fw fh
    flash_block $blockid
    delete_shared_pointer lockid
    create_shared_pointer lockid "locked" \
	[expr $xpos($blockid) * $fw] [expr $ypos($blockid) * $fh] \
	7 lock
    after 1000 delete_shared_pointer lockid
}

proc create_block_item {id x y fonti coli} {
global xpos ypos fw fh font col tcl_platform
	.m.l.txt.c addtag $id withtag \
	    [.m.l.txt.c create text [expr $x * $fw] [expr $y * $fh] -anchor nw\
	     -fill $col($coli) -font $font($fonti)]
        .m.l.txt.c bind $id <1> \
            "set_cur_block $id \[expr %x + \[set canvxpos\]\] \[expr %y + \[set canvypos\]\]"
        if {$tcl_platform(platform) == "unix"} {
	    .m.l.txt.c bind $id <2> \
		"startmoveblock $id \[expr %x + \[set canvxpos\]\] \[expr %y + \[set canvypos\]\]"
	} else {
	    .m.l.txt.c bind $id <Control-ButtonPress-1> \
		"startmoveblock $id \[expr %x + \[set canvxpos\]\] \[expr %y + \[set canvypos\]\]"
	}
	set xpos($id) $x
	set ypos($id) $y
}

proc set_key {enc} {
    if {$enc==1} {
	global encrypt
	set encrypt 0
	catch {destroy .key}
	toplevel .key
	wm title .key "Set Encryption Key **(enc==1)**"
	message .key.m -text "Enter the pass phrase for this session:" -aspect 400
	pack .key.m -side top

	password .key.key -width 30 -relief sunken -borderwidth 1 \
	    -variable tmppass
	pack .key.key -side top -fill x -expand true
	label .key.msg -relief raised -borderwidth 1
	pack .key.msg -side top -fill x -expand true
	frame .key.f -borderwidth 0
	button .key.f.set -text "Enable Encryption" \
	    -command {enable_encryption $tmppass} \
	    -relief raised -borderwidth 1
	bind .key.key <Return> {enable_encryption $tmppass}
	button .key.f.cancel -text "Cancel" -command "destroy .key" \
	    -borderwidth 1
	pack .key.f -side top -fill x -expand true
	pack .key.f.set -side left -fill x -expand true
	pack .key.f.cancel -side left -fill x -expand true
    } else {
	reset_participants
	set_encryption_key ""
    }
}

proc enable_encryption {key} {
    if {[string length $key]<6} {
	bell
	.key.msg configure -text "Key must be at least 8 chars"
	after 3000 .key.msg configure -text \"\"
    } else {
	set_encryption_key $key
	global encrypt
	set encrypt 1
	reset_participants
	catch {destroy .key}
    }
}
grow_canvas

set error_display 0
set error_string "Previous versions of NTE are in use\
	- to prevent instabilty please advise participants to upgrade."

proc remove_error {} {
	global error_display
	destroy .m.in.error
	pack .m.in.l .m.in.bid -side left
	pack  .m.in.lck -side left -ipadx 10
	pack .m.in.cl .m.in.cid  \
		.m.in.ml .m.in.mid  \
		.m.in.mtl .m.in.mt -side left
	set error_display 1
}

proc upgrade_error {} {
	global error_display error_string
	if {$error_display==1} {return}
	label .m.in.error -text $error_string -foreground darkred
	pack forget .m.in.l .m.in.bid .m.in.lck \
		.m.in.cl .m.in.cid \
		.m.in.ml .m.in.mid \
		.m.in.mtl .m.in.mt
	pack propagate .m.in 0
	pack .m.in.error -side left
	after 700 {.m.in.error configure -text ""}
	after 1400 {.m.in.error configure -text $error_string}
	after 2100 {.m.in.error configure -text ""}
	after 2800 {.m.in.error configure -text $error_string}
	after 20000 {remove_error}
}
