#include <stdio.h>	/*stderr*/
#include <stdlib.h>	/*(malloc)*/
#include "mem.h"	/*(memXXX)*/

static void *
memAlloc(size_t size)
{
    void *p;

    p = malloc(size);
    if (p == NULL) {
	fprintf(stderr, "mem: No enough core.\n");
	exit(1);
    }
    return p;
}

/* allocate process-life memory */
void *
memPerm(unsigned size)
{
    return memAlloc(size);
}

typedef struct SLMINFO {
    void *p;
    struct SLMINFO *next;
} SlmInfo;

static SlmInfo *top;

/* allocate song-life memory */
void *
memSong(unsigned size)
{
    SlmInfo *sip;

    sip = memAlloc(sizeof(SlmInfo));
    sip->p = memAlloc(size);
    sip->next = top;
    top = sip;
    return sip->p;
}

/* free all song-life memory */
void
memSongFree(void)
{
    SlmInfo *sip;
    for (; top != NULL; top = sip) {
	sip = top->next;
	free(top->p);
	free(top);
    }
}
