#
# tcl/ex/newmcast/cmcast-250.tcl
#
# Copyright (C) 1997 by USC/ISI
# All rights reserved.                                            
#                                                                
# Redistribution and use in source and binary forms are permitted
# provided that the above copyright notice and this paragraph are
# duplicated in all such forms and that any documentation, advertising
# materials, and other materials related to such distribution and use
# acknowledge that the software was developed by the University of
# Southern California, Information Sciences Institute.  The name of the
# University may not be used to endorse or promote products derived from
# this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# 
# Contributed by Polly Huang (USC/ISI), http://www-scf.usc.edu/~bhuang
# 
#
# Generated by sgb2nsctr, sgb2nsctr created by Polly Huang
# GRAPH (#nodes #edges id uu vv ww xx yy zz):
# 250 12420 geo(0,{250,100,3,0.200,0.250,75.000}) 100 

set verbose 1
set ns [new Simulator]
Simulator set EnableMcast_ 1
Simulator set NumberInterfaces_ 1
Node expandaddr
set g [Node allocaddr]

if {$verbose} { puts "creating 250 nodes..." }
for {set i 0} {$i < 250} {incr i} {
	set n($i) [$ns node]
}

# EDGES (from-node to-node length a b):
if {$verbose} { puts -nonewline "Creating links 0..."; flush stdout }
$ns duplex-link $n(0) $n(245) 1.5Mb 430ms DropTail
$ns duplex-link $n(0) $n(236) 1.5Mb 60ms DropTail
$ns duplex-link $n(0) $n(217) 1.5Mb 410ms DropTail
$ns duplex-link $n(0) $n(213) 1.5Mb 200ms DropTail
$ns duplex-link $n(0) $n(209) 1.5Mb 680ms DropTail
$ns duplex-link $n(0) $n(194) 1.5Mb 530ms DropTail
$ns duplex-link $n(0) $n(190) 1.5Mb 680ms DropTail
$ns duplex-link $n(0) $n(186) 1.5Mb 520ms DropTail
$ns duplex-link $n(0) $n(185) 1.5Mb 340ms DropTail
$ns duplex-link $n(0) $n(172) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "10..."; flush stdout }
$ns duplex-link $n(0) $n(171) 1.5Mb 610ms DropTail
$ns duplex-link $n(0) $n(169) 1.5Mb 500ms DropTail
$ns duplex-link $n(0) $n(161) 1.5Mb 610ms DropTail
$ns duplex-link $n(0) $n(159) 1.5Mb 360ms DropTail
$ns duplex-link $n(0) $n(149) 1.5Mb 630ms DropTail
$ns duplex-link $n(0) $n(146) 1.5Mb 340ms DropTail
$ns duplex-link $n(0) $n(136) 1.5Mb 450ms DropTail
$ns duplex-link $n(0) $n(134) 1.5Mb 420ms DropTail
$ns duplex-link $n(0) $n(133) 1.5Mb 630ms DropTail
$ns duplex-link $n(0) $n(110) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "20..."; flush stdout }
$ns duplex-link $n(0) $n(106) 1.5Mb 130ms DropTail
$ns duplex-link $n(0) $n(91) 1.5Mb 170ms DropTail
$ns duplex-link $n(0) $n(90) 1.5Mb 400ms DropTail
$ns duplex-link $n(0) $n(85) 1.5Mb 300ms DropTail
$ns duplex-link $n(0) $n(83) 1.5Mb 240ms DropTail
$ns duplex-link $n(0) $n(79) 1.5Mb 150ms DropTail
$ns duplex-link $n(0) $n(78) 1.5Mb 390ms DropTail
$ns duplex-link $n(0) $n(76) 1.5Mb 280ms DropTail
$ns duplex-link $n(0) $n(75) 1.5Mb 250ms DropTail
$ns duplex-link $n(0) $n(72) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "30..."; flush stdout }
$ns duplex-link $n(0) $n(67) 1.5Mb 520ms DropTail
$ns duplex-link $n(0) $n(62) 1.5Mb 500ms DropTail
$ns duplex-link $n(0) $n(55) 1.5Mb 400ms DropTail
$ns duplex-link $n(0) $n(50) 1.5Mb 540ms DropTail
$ns duplex-link $n(0) $n(48) 1.5Mb 260ms DropTail
$ns duplex-link $n(0) $n(39) 1.5Mb 400ms DropTail
$ns duplex-link $n(0) $n(34) 1.5Mb 300ms DropTail
$ns duplex-link $n(0) $n(32) 1.5Mb 390ms DropTail
$ns duplex-link $n(0) $n(30) 1.5Mb 720ms DropTail
$ns duplex-link $n(0) $n(16) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "40..."; flush stdout }
$ns duplex-link $n(0) $n(14) 1.5Mb 390ms DropTail
$ns duplex-link $n(1) $n(244) 1.5Mb 220ms DropTail
$ns duplex-link $n(1) $n(242) 1.5Mb 830ms DropTail
$ns duplex-link $n(1) $n(229) 1.5Mb 620ms DropTail
$ns duplex-link $n(1) $n(219) 1.5Mb 790ms DropTail
$ns duplex-link $n(1) $n(215) 1.5Mb 980ms DropTail
$ns duplex-link $n(1) $n(210) 1.5Mb 300ms DropTail
$ns duplex-link $n(1) $n(209) 1.5Mb 30ms DropTail
$ns duplex-link $n(1) $n(208) 1.5Mb 290ms DropTail
$ns duplex-link $n(1) $n(192) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "50..."; flush stdout }
$ns duplex-link $n(1) $n(187) 1.5Mb 740ms DropTail
$ns duplex-link $n(1) $n(180) 1.5Mb 840ms DropTail
$ns duplex-link $n(1) $n(174) 1.5Mb 650ms DropTail
$ns duplex-link $n(1) $n(169) 1.5Mb 380ms DropTail
$ns duplex-link $n(1) $n(163) 1.5Mb 620ms DropTail
$ns duplex-link $n(1) $n(159) 1.5Mb 620ms DropTail
$ns duplex-link $n(1) $n(152) 1.5Mb 690ms DropTail
$ns duplex-link $n(1) $n(149) 1.5Mb 500ms DropTail
$ns duplex-link $n(1) $n(148) 1.5Mb 440ms DropTail
$ns duplex-link $n(1) $n(142) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "60..."; flush stdout }
$ns duplex-link $n(1) $n(140) 1.5Mb 940ms DropTail
$ns duplex-link $n(1) $n(139) 1.5Mb 700ms DropTail
$ns duplex-link $n(1) $n(125) 1.5Mb 270ms DropTail
$ns duplex-link $n(1) $n(121) 1.5Mb 370ms DropTail
$ns duplex-link $n(1) $n(96) 1.5Mb 520ms DropTail
$ns duplex-link $n(1) $n(95) 1.5Mb 300ms DropTail
$ns duplex-link $n(1) $n(92) 1.5Mb 600ms DropTail
$ns duplex-link $n(1) $n(84) 1.5Mb 280ms DropTail
$ns duplex-link $n(1) $n(81) 1.5Mb 510ms DropTail
$ns duplex-link $n(1) $n(79) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "70..."; flush stdout }
$ns duplex-link $n(1) $n(77) 1.5Mb 420ms DropTail
$ns duplex-link $n(1) $n(74) 1.5Mb 270ms DropTail
$ns duplex-link $n(1) $n(73) 1.5Mb 820ms DropTail
$ns duplex-link $n(1) $n(65) 1.5Mb 880ms DropTail
$ns duplex-link $n(1) $n(59) 1.5Mb 710ms DropTail
$ns duplex-link $n(1) $n(58) 1.5Mb 290ms DropTail
$ns duplex-link $n(1) $n(53) 1.5Mb 1130ms DropTail
$ns duplex-link $n(1) $n(45) 1.5Mb 180ms DropTail
$ns duplex-link $n(1) $n(33) 1.5Mb 900ms DropTail
$ns duplex-link $n(1) $n(30) 1.5Mb 50ms DropTail
if {$verbose} { puts -nonewline "80..."; flush stdout }
$ns duplex-link $n(1) $n(27) 1.5Mb 420ms DropTail
$ns duplex-link $n(1) $n(23) 1.5Mb 1030ms DropTail
$ns duplex-link $n(1) $n(9) 1.5Mb 460ms DropTail
$ns duplex-link $n(1) $n(6) 1.5Mb 390ms DropTail
$ns duplex-link $n(2) $n(246) 1.5Mb 670ms DropTail
$ns duplex-link $n(2) $n(245) 1.5Mb 60ms DropTail
$ns duplex-link $n(2) $n(243) 1.5Mb 520ms DropTail
$ns duplex-link $n(2) $n(233) 1.5Mb 230ms DropTail
$ns duplex-link $n(2) $n(225) 1.5Mb 1110ms DropTail
$ns duplex-link $n(2) $n(221) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "90..."; flush stdout }
$ns duplex-link $n(2) $n(219) 1.5Mb 330ms DropTail
$ns duplex-link $n(2) $n(218) 1.5Mb 740ms DropTail
$ns duplex-link $n(2) $n(217) 1.5Mb 370ms DropTail
$ns duplex-link $n(2) $n(214) 1.5Mb 930ms DropTail
$ns duplex-link $n(2) $n(212) 1.5Mb 640ms DropTail
$ns duplex-link $n(2) $n(205) 1.5Mb 580ms DropTail
$ns duplex-link $n(2) $n(203) 1.5Mb 70ms DropTail
$ns duplex-link $n(2) $n(202) 1.5Mb 580ms DropTail
$ns duplex-link $n(2) $n(197) 1.5Mb 740ms DropTail
$ns duplex-link $n(2) $n(193) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "100..."; flush stdout }
$ns duplex-link $n(2) $n(191) 1.5Mb 690ms DropTail
$ns duplex-link $n(2) $n(189) 1.5Mb 110ms DropTail
$ns duplex-link $n(2) $n(187) 1.5Mb 550ms DropTail
$ns duplex-link $n(2) $n(168) 1.5Mb 970ms DropTail
$ns duplex-link $n(2) $n(166) 1.5Mb 820ms DropTail
$ns duplex-link $n(2) $n(165) 1.5Mb 1150ms DropTail
$ns duplex-link $n(2) $n(160) 1.5Mb 780ms DropTail
$ns duplex-link $n(2) $n(155) 1.5Mb 720ms DropTail
$ns duplex-link $n(2) $n(154) 1.5Mb 400ms DropTail
$ns duplex-link $n(2) $n(146) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "110..."; flush stdout }
$ns duplex-link $n(2) $n(145) 1.5Mb 840ms DropTail
$ns duplex-link $n(2) $n(134) 1.5Mb 800ms DropTail
$ns duplex-link $n(2) $n(128) 1.5Mb 350ms DropTail
$ns duplex-link $n(2) $n(122) 1.5Mb 290ms DropTail
$ns duplex-link $n(2) $n(119) 1.5Mb 800ms DropTail
$ns duplex-link $n(2) $n(109) 1.5Mb 680ms DropTail
$ns duplex-link $n(2) $n(104) 1.5Mb 560ms DropTail
$ns duplex-link $n(2) $n(90) 1.5Mb 530ms DropTail
$ns duplex-link $n(2) $n(77) 1.5Mb 860ms DropTail
$ns duplex-link $n(2) $n(75) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "120..."; flush stdout }
$ns duplex-link $n(2) $n(74) 1.5Mb 900ms DropTail
$ns duplex-link $n(2) $n(69) 1.5Mb 580ms DropTail
$ns duplex-link $n(2) $n(61) 1.5Mb 870ms DropTail
$ns duplex-link $n(2) $n(60) 1.5Mb 250ms DropTail
$ns duplex-link $n(2) $n(59) 1.5Mb 380ms DropTail
$ns duplex-link $n(2) $n(57) 1.5Mb 230ms DropTail
$ns duplex-link $n(2) $n(52) 1.5Mb 690ms DropTail
$ns duplex-link $n(2) $n(49) 1.5Mb 470ms DropTail
$ns duplex-link $n(2) $n(47) 1.5Mb 640ms DropTail
$ns duplex-link $n(2) $n(44) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "130..."; flush stdout }
$ns duplex-link $n(2) $n(41) 1.5Mb 820ms DropTail
$ns duplex-link $n(2) $n(39) 1.5Mb 450ms DropTail
$ns duplex-link $n(2) $n(24) 1.5Mb 440ms DropTail
$ns duplex-link $n(2) $n(21) 1.5Mb 1030ms DropTail
$ns duplex-link $n(2) $n(19) 1.5Mb 520ms DropTail
$ns duplex-link $n(2) $n(17) 1.5Mb 950ms DropTail
$ns duplex-link $n(2) $n(14) 1.5Mb 830ms DropTail
$ns duplex-link $n(3) $n(249) 1.5Mb 170ms DropTail
$ns duplex-link $n(3) $n(243) 1.5Mb 460ms DropTail
$ns duplex-link $n(3) $n(242) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "140..."; flush stdout }
$ns duplex-link $n(3) $n(240) 1.5Mb 650ms DropTail
$ns duplex-link $n(3) $n(235) 1.5Mb 540ms DropTail
$ns duplex-link $n(3) $n(227) 1.5Mb 690ms DropTail
$ns duplex-link $n(3) $n(223) 1.5Mb 810ms DropTail
$ns duplex-link $n(3) $n(215) 1.5Mb 850ms DropTail
$ns duplex-link $n(3) $n(212) 1.5Mb 670ms DropTail
$ns duplex-link $n(3) $n(208) 1.5Mb 480ms DropTail
$ns duplex-link $n(3) $n(204) 1.5Mb 750ms DropTail
$ns duplex-link $n(3) $n(201) 1.5Mb 800ms DropTail
$ns duplex-link $n(3) $n(193) 1.5Mb 1020ms DropTail
if {$verbose} { puts -nonewline "150..."; flush stdout }
$ns duplex-link $n(3) $n(179) 1.5Mb 880ms DropTail
$ns duplex-link $n(3) $n(153) 1.5Mb 430ms DropTail
$ns duplex-link $n(3) $n(147) 1.5Mb 220ms DropTail
$ns duplex-link $n(3) $n(137) 1.5Mb 230ms DropTail
$ns duplex-link $n(3) $n(134) 1.5Mb 970ms DropTail
$ns duplex-link $n(3) $n(105) 1.5Mb 390ms DropTail
$ns duplex-link $n(3) $n(102) 1.5Mb 410ms DropTail
$ns duplex-link $n(3) $n(99) 1.5Mb 690ms DropTail
$ns duplex-link $n(3) $n(96) 1.5Mb 370ms DropTail
$ns duplex-link $n(3) $n(95) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "160..."; flush stdout }
$ns duplex-link $n(3) $n(89) 1.5Mb 330ms DropTail
$ns duplex-link $n(3) $n(88) 1.5Mb 360ms DropTail
$ns duplex-link $n(3) $n(77) 1.5Mb 740ms DropTail
$ns duplex-link $n(3) $n(72) 1.5Mb 660ms DropTail
$ns duplex-link $n(3) $n(71) 1.5Mb 600ms DropTail
$ns duplex-link $n(3) $n(66) 1.5Mb 390ms DropTail
$ns duplex-link $n(3) $n(61) 1.5Mb 680ms DropTail
$ns duplex-link $n(3) $n(52) 1.5Mb 770ms DropTail
$ns duplex-link $n(3) $n(41) 1.5Mb 890ms DropTail
$ns duplex-link $n(3) $n(33) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "170..."; flush stdout }
$ns duplex-link $n(3) $n(30) 1.5Mb 770ms DropTail
$ns duplex-link $n(3) $n(29) 1.5Mb 350ms DropTail
$ns duplex-link $n(3) $n(28) 1.5Mb 570ms DropTail
$ns duplex-link $n(3) $n(15) 1.5Mb 140ms DropTail
$ns duplex-link $n(3) $n(7) 1.5Mb 520ms DropTail
$ns duplex-link $n(3) $n(6) 1.5Mb 480ms DropTail
$ns duplex-link $n(3) $n(5) 1.5Mb 210ms DropTail
$ns duplex-link $n(3) $n(4) 1.5Mb 530ms DropTail
$ns duplex-link $n(4) $n(246) 1.5Mb 210ms DropTail
$ns duplex-link $n(4) $n(241) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "180..."; flush stdout }
$ns duplex-link $n(4) $n(240) 1.5Mb 800ms DropTail
$ns duplex-link $n(4) $n(236) 1.5Mb 360ms DropTail
$ns duplex-link $n(4) $n(235) 1.5Mb 670ms DropTail
$ns duplex-link $n(4) $n(234) 1.5Mb 430ms DropTail
$ns duplex-link $n(4) $n(228) 1.5Mb 720ms DropTail
$ns duplex-link $n(4) $n(221) 1.5Mb 60ms DropTail
$ns duplex-link $n(4) $n(220) 1.5Mb 670ms DropTail
$ns duplex-link $n(4) $n(219) 1.5Mb 500ms DropTail
$ns duplex-link $n(4) $n(218) 1.5Mb 650ms DropTail
$ns duplex-link $n(4) $n(217) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "190..."; flush stdout }
$ns duplex-link $n(4) $n(213) 1.5Mb 360ms DropTail
$ns duplex-link $n(4) $n(201) 1.5Mb 310ms DropTail
$ns duplex-link $n(4) $n(200) 1.5Mb 460ms DropTail
$ns duplex-link $n(4) $n(199) 1.5Mb 720ms DropTail
$ns duplex-link $n(4) $n(198) 1.5Mb 670ms DropTail
$ns duplex-link $n(4) $n(197) 1.5Mb 550ms DropTail
$ns duplex-link $n(4) $n(189) 1.5Mb 710ms DropTail
$ns duplex-link $n(4) $n(171) 1.5Mb 250ms DropTail
$ns duplex-link $n(4) $n(163) 1.5Mb 330ms DropTail
$ns duplex-link $n(4) $n(156) 1.5Mb 30ms DropTail
if {$verbose} { puts -nonewline "200..."; flush stdout }
$ns duplex-link $n(4) $n(155) 1.5Mb 110ms DropTail
$ns duplex-link $n(4) $n(147) 1.5Mb 380ms DropTail
$ns duplex-link $n(4) $n(133) 1.5Mb 440ms DropTail
$ns duplex-link $n(4) $n(129) 1.5Mb 230ms DropTail
$ns duplex-link $n(4) $n(127) 1.5Mb 290ms DropTail
$ns duplex-link $n(4) $n(126) 1.5Mb 470ms DropTail
$ns duplex-link $n(4) $n(125) 1.5Mb 210ms DropTail
$ns duplex-link $n(4) $n(122) 1.5Mb 520ms DropTail
$ns duplex-link $n(4) $n(117) 1.5Mb 500ms DropTail
$ns duplex-link $n(4) $n(115) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "210..."; flush stdout }
$ns duplex-link $n(4) $n(113) 1.5Mb 680ms DropTail
$ns duplex-link $n(4) $n(104) 1.5Mb 250ms DropTail
$ns duplex-link $n(4) $n(88) 1.5Mb 320ms DropTail
$ns duplex-link $n(4) $n(75) 1.5Mb 560ms DropTail
$ns duplex-link $n(4) $n(72) 1.5Mb 340ms DropTail
$ns duplex-link $n(4) $n(66) 1.5Mb 230ms DropTail
$ns duplex-link $n(4) $n(61) 1.5Mb 160ms DropTail
$ns duplex-link $n(4) $n(58) 1.5Mb 190ms DropTail
$ns duplex-link $n(4) $n(55) 1.5Mb 40ms DropTail
$ns duplex-link $n(4) $n(54) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "220..."; flush stdout }
$ns duplex-link $n(4) $n(48) 1.5Mb 450ms DropTail
$ns duplex-link $n(4) $n(43) 1.5Mb 600ms DropTail
$ns duplex-link $n(4) $n(40) 1.5Mb 510ms DropTail
$ns duplex-link $n(4) $n(37) 1.5Mb 650ms DropTail
$ns duplex-link $n(4) $n(33) 1.5Mb 660ms DropTail
$ns duplex-link $n(4) $n(18) 1.5Mb 150ms DropTail
$ns duplex-link $n(4) $n(12) 1.5Mb 360ms DropTail
$ns duplex-link $n(4) $n(11) 1.5Mb 260ms DropTail
$ns duplex-link $n(5) $n(216) 1.5Mb 500ms DropTail
$ns duplex-link $n(5) $n(199) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "230..."; flush stdout }
$ns duplex-link $n(5) $n(196) 1.5Mb 300ms DropTail
$ns duplex-link $n(5) $n(195) 1.5Mb 720ms DropTail
$ns duplex-link $n(5) $n(194) 1.5Mb 160ms DropTail
$ns duplex-link $n(5) $n(188) 1.5Mb 90ms DropTail
$ns duplex-link $n(5) $n(186) 1.5Mb 430ms DropTail
$ns duplex-link $n(5) $n(183) 1.5Mb 500ms DropTail
$ns duplex-link $n(5) $n(182) 1.5Mb 680ms DropTail
$ns duplex-link $n(5) $n(181) 1.5Mb 240ms DropTail
$ns duplex-link $n(5) $n(176) 1.5Mb 240ms DropTail
$ns duplex-link $n(5) $n(175) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "240..."; flush stdout }
$ns duplex-link $n(5) $n(173) 1.5Mb 210ms DropTail
$ns duplex-link $n(5) $n(171) 1.5Mb 750ms DropTail
$ns duplex-link $n(5) $n(163) 1.5Mb 210ms DropTail
$ns duplex-link $n(5) $n(158) 1.5Mb 710ms DropTail
$ns duplex-link $n(5) $n(156) 1.5Mb 500ms DropTail
$ns duplex-link $n(5) $n(154) 1.5Mb 490ms DropTail
$ns duplex-link $n(5) $n(138) 1.5Mb 330ms DropTail
$ns duplex-link $n(5) $n(135) 1.5Mb 620ms DropTail
$ns duplex-link $n(5) $n(134) 1.5Mb 800ms DropTail
$ns duplex-link $n(5) $n(121) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "250..."; flush stdout }
$ns duplex-link $n(5) $n(120) 1.5Mb 240ms DropTail
$ns duplex-link $n(5) $n(119) 1.5Mb 460ms DropTail
$ns duplex-link $n(5) $n(115) 1.5Mb 520ms DropTail
$ns duplex-link $n(5) $n(107) 1.5Mb 90ms DropTail
$ns duplex-link $n(5) $n(99) 1.5Mb 490ms DropTail
$ns duplex-link $n(5) $n(95) 1.5Mb 490ms DropTail
$ns duplex-link $n(5) $n(94) 1.5Mb 260ms DropTail
$ns duplex-link $n(5) $n(90) 1.5Mb 160ms DropTail
$ns duplex-link $n(5) $n(86) 1.5Mb 760ms DropTail
$ns duplex-link $n(5) $n(83) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "260..."; flush stdout }
$ns duplex-link $n(5) $n(82) 1.5Mb 700ms DropTail
$ns duplex-link $n(5) $n(79) 1.5Mb 220ms DropTail
$ns duplex-link $n(5) $n(78) 1.5Mb 770ms DropTail
$ns duplex-link $n(5) $n(76) 1.5Mb 650ms DropTail
$ns duplex-link $n(5) $n(67) 1.5Mb 620ms DropTail
$ns duplex-link $n(5) $n(61) 1.5Mb 630ms DropTail
$ns duplex-link $n(5) $n(54) 1.5Mb 230ms DropTail
$ns duplex-link $n(5) $n(50) 1.5Mb 310ms DropTail
$ns duplex-link $n(5) $n(46) 1.5Mb 340ms DropTail
$ns duplex-link $n(5) $n(43) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "270..."; flush stdout }
$ns duplex-link $n(5) $n(40) 1.5Mb 230ms DropTail
$ns duplex-link $n(5) $n(32) 1.5Mb 450ms DropTail
$ns duplex-link $n(5) $n(28) 1.5Mb 390ms DropTail
$ns duplex-link $n(5) $n(26) 1.5Mb 740ms DropTail
$ns duplex-link $n(5) $n(21) 1.5Mb 700ms DropTail
$ns duplex-link $n(5) $n(20) 1.5Mb 470ms DropTail
$ns duplex-link $n(5) $n(15) 1.5Mb 300ms DropTail
$ns duplex-link $n(5) $n(14) 1.5Mb 750ms DropTail
$ns duplex-link $n(5) $n(6) 1.5Mb 430ms DropTail
$ns duplex-link $n(6) $n(249) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "280..."; flush stdout }
$ns duplex-link $n(6) $n(241) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(234) 1.5Mb 340ms DropTail
$ns duplex-link $n(6) $n(230) 1.5Mb 630ms DropTail
$ns duplex-link $n(6) $n(229) 1.5Mb 410ms DropTail
$ns duplex-link $n(6) $n(224) 1.5Mb 390ms DropTail
$ns duplex-link $n(6) $n(223) 1.5Mb 350ms DropTail
$ns duplex-link $n(6) $n(220) 1.5Mb 590ms DropTail
$ns duplex-link $n(6) $n(212) 1.5Mb 290ms DropTail
$ns duplex-link $n(6) $n(208) 1.5Mb 120ms DropTail
$ns duplex-link $n(6) $n(207) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "290..."; flush stdout }
$ns duplex-link $n(6) $n(184) 1.5Mb 140ms DropTail
$ns duplex-link $n(6) $n(176) 1.5Mb 230ms DropTail
$ns duplex-link $n(6) $n(151) 1.5Mb 410ms DropTail
$ns duplex-link $n(6) $n(149) 1.5Mb 410ms DropTail
$ns duplex-link $n(6) $n(147) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(137) 1.5Mb 320ms DropTail
$ns duplex-link $n(6) $n(134) 1.5Mb 590ms DropTail
$ns duplex-link $n(6) $n(133) 1.5Mb 430ms DropTail
$ns duplex-link $n(6) $n(131) 1.5Mb 610ms DropTail
$ns duplex-link $n(6) $n(117) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "300..."; flush stdout }
$ns duplex-link $n(6) $n(115) 1.5Mb 220ms DropTail
$ns duplex-link $n(6) $n(113) 1.5Mb 590ms DropTail
$ns duplex-link $n(6) $n(111) 1.5Mb 280ms DropTail
$ns duplex-link $n(6) $n(106) 1.5Mb 250ms DropTail
$ns duplex-link $n(6) $n(104) 1.5Mb 160ms DropTail
$ns duplex-link $n(6) $n(103) 1.5Mb 420ms DropTail
$ns duplex-link $n(6) $n(102) 1.5Mb 220ms DropTail
$ns duplex-link $n(6) $n(91) 1.5Mb 480ms DropTail
$ns duplex-link $n(6) $n(89) 1.5Mb 610ms DropTail
$ns duplex-link $n(6) $n(80) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "310..."; flush stdout }
$ns duplex-link $n(6) $n(68) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(65) 1.5Mb 490ms DropTail
$ns duplex-link $n(6) $n(61) 1.5Mb 200ms DropTail
$ns duplex-link $n(6) $n(59) 1.5Mb 360ms DropTail
$ns duplex-link $n(6) $n(58) 1.5Mb 250ms DropTail
$ns duplex-link $n(6) $n(55) 1.5Mb 80ms DropTail
$ns duplex-link $n(6) $n(53) 1.5Mb 750ms DropTail
$ns duplex-link $n(6) $n(51) 1.5Mb 330ms DropTail
$ns duplex-link $n(6) $n(49) 1.5Mb 410ms DropTail
$ns duplex-link $n(6) $n(48) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "320..."; flush stdout }
$ns duplex-link $n(6) $n(47) 1.5Mb 400ms DropTail
$ns duplex-link $n(6) $n(43) 1.5Mb 510ms DropTail
$ns duplex-link $n(6) $n(35) 1.5Mb 580ms DropTail
$ns duplex-link $n(6) $n(34) 1.5Mb 490ms DropTail
$ns duplex-link $n(6) $n(33) 1.5Mb 580ms DropTail
$ns duplex-link $n(6) $n(27) 1.5Mb 300ms DropTail
$ns duplex-link $n(6) $n(21) 1.5Mb 330ms DropTail
$ns duplex-link $n(6) $n(20) 1.5Mb 820ms DropTail
$ns duplex-link $n(6) $n(17) 1.5Mb 360ms DropTail
$ns duplex-link $n(6) $n(16) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "330..."; flush stdout }
$ns duplex-link $n(6) $n(14) 1.5Mb 460ms DropTail
$ns duplex-link $n(6) $n(11) 1.5Mb 290ms DropTail
$ns duplex-link $n(7) $n(244) 1.5Mb 180ms DropTail
$ns duplex-link $n(7) $n(242) 1.5Mb 660ms DropTail
$ns duplex-link $n(7) $n(241) 1.5Mb 470ms DropTail
$ns duplex-link $n(7) $n(238) 1.5Mb 360ms DropTail
$ns duplex-link $n(7) $n(235) 1.5Mb 730ms DropTail
$ns duplex-link $n(7) $n(234) 1.5Mb 500ms DropTail
$ns duplex-link $n(7) $n(233) 1.5Mb 620ms DropTail
$ns duplex-link $n(7) $n(228) 1.5Mb 800ms DropTail
if {$verbose} { puts -nonewline "340..."; flush stdout }
$ns duplex-link $n(7) $n(219) 1.5Mb 560ms DropTail
$ns duplex-link $n(7) $n(218) 1.5Mb 740ms DropTail
$ns duplex-link $n(7) $n(214) 1.5Mb 100ms DropTail
$ns duplex-link $n(7) $n(200) 1.5Mb 540ms DropTail
$ns duplex-link $n(7) $n(199) 1.5Mb 800ms DropTail
$ns duplex-link $n(7) $n(193) 1.5Mb 840ms DropTail
$ns duplex-link $n(7) $n(185) 1.5Mb 550ms DropTail
$ns duplex-link $n(7) $n(182) 1.5Mb 570ms DropTail
$ns duplex-link $n(7) $n(174) 1.5Mb 490ms DropTail
$ns duplex-link $n(7) $n(166) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "350..."; flush stdout }
$ns duplex-link $n(7) $n(165) 1.5Mb 310ms DropTail
$ns duplex-link $n(7) $n(163) 1.5Mb 380ms DropTail
$ns duplex-link $n(7) $n(161) 1.5Mb 180ms DropTail
$ns duplex-link $n(7) $n(160) 1.5Mb 270ms DropTail
$ns duplex-link $n(7) $n(141) 1.5Mb 130ms DropTail
$ns duplex-link $n(7) $n(130) 1.5Mb 140ms DropTail
$ns duplex-link $n(7) $n(124) 1.5Mb 250ms DropTail
$ns duplex-link $n(7) $n(117) 1.5Mb 550ms DropTail
$ns duplex-link $n(7) $n(115) 1.5Mb 80ms DropTail
$ns duplex-link $n(7) $n(101) 1.5Mb 710ms DropTail
if {$verbose} { puts -nonewline "360..."; flush stdout }
$ns duplex-link $n(7) $n(100) 1.5Mb 690ms DropTail
$ns duplex-link $n(7) $n(98) 1.5Mb 110ms DropTail
$ns duplex-link $n(7) $n(95) 1.5Mb 70ms DropTail
$ns duplex-link $n(7) $n(92) 1.5Mb 460ms DropTail
$ns duplex-link $n(7) $n(90) 1.5Mb 390ms DropTail
$ns duplex-link $n(7) $n(86) 1.5Mb 590ms DropTail
$ns duplex-link $n(7) $n(82) 1.5Mb 760ms DropTail
$ns duplex-link $n(7) $n(80) 1.5Mb 440ms DropTail
$ns duplex-link $n(7) $n(79) 1.5Mb 450ms DropTail
$ns duplex-link $n(7) $n(78) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "370..."; flush stdout }
$ns duplex-link $n(7) $n(73) 1.5Mb 600ms DropTail
$ns duplex-link $n(7) $n(68) 1.5Mb 380ms DropTail
$ns duplex-link $n(7) $n(65) 1.5Mb 650ms DropTail
$ns duplex-link $n(7) $n(62) 1.5Mb 260ms DropTail
$ns duplex-link $n(7) $n(59) 1.5Mb 480ms DropTail
$ns duplex-link $n(7) $n(58) 1.5Mb 230ms DropTail
$ns duplex-link $n(7) $n(55) 1.5Mb 80ms DropTail
$ns duplex-link $n(7) $n(54) 1.5Mb 300ms DropTail
$ns duplex-link $n(7) $n(45) 1.5Mb 110ms DropTail
$ns duplex-link $n(7) $n(40) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "380..."; flush stdout }
$ns duplex-link $n(7) $n(22) 1.5Mb 300ms DropTail
$ns duplex-link $n(7) $n(18) 1.5Mb 220ms DropTail
$ns duplex-link $n(7) $n(15) 1.5Mb 660ms DropTail
$ns duplex-link $n(7) $n(13) 1.5Mb 20ms DropTail
$ns duplex-link $n(7) $n(9) 1.5Mb 350ms DropTail
$ns duplex-link $n(8) $n(243) 1.5Mb 360ms DropTail
$ns duplex-link $n(8) $n(242) 1.5Mb 270ms DropTail
$ns duplex-link $n(8) $n(241) 1.5Mb 440ms DropTail
$ns duplex-link $n(8) $n(238) 1.5Mb 570ms DropTail
$ns duplex-link $n(8) $n(233) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "390..."; flush stdout }
$ns duplex-link $n(8) $n(224) 1.5Mb 580ms DropTail
$ns duplex-link $n(8) $n(221) 1.5Mb 490ms DropTail
$ns duplex-link $n(8) $n(220) 1.5Mb 220ms DropTail
$ns duplex-link $n(8) $n(217) 1.5Mb 110ms DropTail
$ns duplex-link $n(8) $n(216) 1.5Mb 600ms DropTail
$ns duplex-link $n(8) $n(208) 1.5Mb 430ms DropTail
$ns duplex-link $n(8) $n(207) 1.5Mb 250ms DropTail
$ns duplex-link $n(8) $n(206) 1.5Mb 670ms DropTail
$ns duplex-link $n(8) $n(205) 1.5Mb 380ms DropTail
$ns duplex-link $n(8) $n(196) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "400..."; flush stdout }
$ns duplex-link $n(8) $n(195) 1.5Mb 790ms DropTail
$ns duplex-link $n(8) $n(192) 1.5Mb 730ms DropTail
$ns duplex-link $n(8) $n(189) 1.5Mb 370ms DropTail
$ns duplex-link $n(8) $n(182) 1.5Mb 730ms DropTail
$ns duplex-link $n(8) $n(174) 1.5Mb 230ms DropTail
$ns duplex-link $n(8) $n(163) 1.5Mb 250ms DropTail
$ns duplex-link $n(8) $n(161) 1.5Mb 670ms DropTail
$ns duplex-link $n(8) $n(154) 1.5Mb 580ms DropTail
$ns duplex-link $n(8) $n(149) 1.5Mb 310ms DropTail
$ns duplex-link $n(8) $n(147) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "410..."; flush stdout }
$ns duplex-link $n(8) $n(142) 1.5Mb 500ms DropTail
$ns duplex-link $n(8) $n(137) 1.5Mb 240ms DropTail
$ns duplex-link $n(8) $n(136) 1.5Mb 450ms DropTail
$ns duplex-link $n(8) $n(130) 1.5Mb 620ms DropTail
$ns duplex-link $n(8) $n(127) 1.5Mb 300ms DropTail
$ns duplex-link $n(8) $n(121) 1.5Mb 460ms DropTail
$ns duplex-link $n(8) $n(112) 1.5Mb 340ms DropTail
$ns duplex-link $n(8) $n(109) 1.5Mb 590ms DropTail
$ns duplex-link $n(8) $n(102) 1.5Mb 310ms DropTail
$ns duplex-link $n(8) $n(100) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "420..."; flush stdout }
$ns duplex-link $n(8) $n(88) 1.5Mb 260ms DropTail
$ns duplex-link $n(8) $n(86) 1.5Mb 800ms DropTail
$ns duplex-link $n(8) $n(70) 1.5Mb 720ms DropTail
$ns duplex-link $n(8) $n(69) 1.5Mb 410ms DropTail
$ns duplex-link $n(8) $n(68) 1.5Mb 700ms DropTail
$ns duplex-link $n(8) $n(61) 1.5Mb 610ms DropTail
$ns duplex-link $n(8) $n(59) 1.5Mb 160ms DropTail
$ns duplex-link $n(8) $n(54) 1.5Mb 180ms DropTail
$ns duplex-link $n(8) $n(53) 1.5Mb 590ms DropTail
$ns duplex-link $n(8) $n(51) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "430..."; flush stdout }
$ns duplex-link $n(8) $n(50) 1.5Mb 200ms DropTail
$ns duplex-link $n(8) $n(41) 1.5Mb 790ms DropTail
$ns duplex-link $n(8) $n(40) 1.5Mb 330ms DropTail
$ns duplex-link $n(8) $n(37) 1.5Mb 710ms DropTail
$ns duplex-link $n(8) $n(21) 1.5Mb 650ms DropTail
$ns duplex-link $n(8) $n(18) 1.5Mb 400ms DropTail
$ns duplex-link $n(8) $n(17) 1.5Mb 500ms DropTail
$ns duplex-link $n(8) $n(16) 1.5Mb 240ms DropTail
$ns duplex-link $n(9) $n(235) 1.5Mb 770ms DropTail
$ns duplex-link $n(9) $n(231) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "440..."; flush stdout }
$ns duplex-link $n(9) $n(216) 1.5Mb 950ms DropTail
$ns duplex-link $n(9) $n(215) 1.5Mb 970ms DropTail
$ns duplex-link $n(9) $n(209) 1.5Mb 430ms DropTail
$ns duplex-link $n(9) $n(207) 1.5Mb 350ms DropTail
$ns duplex-link $n(9) $n(203) 1.5Mb 900ms DropTail
$ns duplex-link $n(9) $n(200) 1.5Mb 840ms DropTail
$ns duplex-link $n(9) $n(199) 1.5Mb 1070ms DropTail
$ns duplex-link $n(9) $n(194) 1.5Mb 480ms DropTail
$ns duplex-link $n(9) $n(186) 1.5Mb 170ms DropTail
$ns duplex-link $n(9) $n(183) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "450..."; flush stdout }
$ns duplex-link $n(9) $n(171) 1.5Mb 560ms DropTail
$ns duplex-link $n(9) $n(163) 1.5Mb 450ms DropTail
$ns duplex-link $n(9) $n(160) 1.5Mb 580ms DropTail
$ns duplex-link $n(9) $n(157) 1.5Mb 440ms DropTail
$ns duplex-link $n(9) $n(152) 1.5Mb 570ms DropTail
$ns duplex-link $n(9) $n(140) 1.5Mb 780ms DropTail
$ns duplex-link $n(9) $n(133) 1.5Mb 90ms DropTail
$ns duplex-link $n(9) $n(112) 1.5Mb 580ms DropTail
$ns duplex-link $n(9) $n(111) 1.5Mb 260ms DropTail
$ns duplex-link $n(9) $n(110) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "460..."; flush stdout }
$ns duplex-link $n(9) $n(105) 1.5Mb 150ms DropTail
$ns duplex-link $n(9) $n(101) 1.5Mb 670ms DropTail
$ns duplex-link $n(9) $n(100) 1.5Mb 760ms DropTail
$ns duplex-link $n(9) $n(98) 1.5Mb 230ms DropTail
$ns duplex-link $n(9) $n(95) 1.5Mb 380ms DropTail
$ns duplex-link $n(9) $n(93) 1.5Mb 660ms DropTail
$ns duplex-link $n(9) $n(89) 1.5Mb 620ms DropTail
$ns duplex-link $n(9) $n(84) 1.5Mb 610ms DropTail
$ns duplex-link $n(9) $n(83) 1.5Mb 850ms DropTail
$ns duplex-link $n(9) $n(79) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "470..."; flush stdout }
$ns duplex-link $n(9) $n(78) 1.5Mb 980ms DropTail
$ns duplex-link $n(9) $n(77) 1.5Mb 640ms DropTail
$ns duplex-link $n(9) $n(71) 1.5Mb 680ms DropTail
$ns duplex-link $n(9) $n(68) 1.5Mb 710ms DropTail
$ns duplex-link $n(9) $n(67) 1.5Mb 420ms DropTail
$ns duplex-link $n(9) $n(53) 1.5Mb 930ms DropTail
$ns duplex-link $n(9) $n(46) 1.5Mb 760ms DropTail
$ns duplex-link $n(9) $n(44) 1.5Mb 420ms DropTail
$ns duplex-link $n(9) $n(37) 1.5Mb 930ms DropTail
$ns duplex-link $n(9) $n(35) 1.5Mb 920ms DropTail
if {$verbose} { puts -nonewline "480..."; flush stdout }
$ns duplex-link $n(9) $n(34) 1.5Mb 890ms DropTail
$ns duplex-link $n(9) $n(33) 1.5Mb 560ms DropTail
$ns duplex-link $n(9) $n(32) 1.5Mb 880ms DropTail
$ns duplex-link $n(9) $n(22) 1.5Mb 290ms DropTail
$ns duplex-link $n(9) $n(15) 1.5Mb 410ms DropTail
$ns duplex-link $n(9) $n(11) 1.5Mb 150ms DropTail
$ns duplex-link $n(9) $n(10) 1.5Mb 480ms DropTail
$ns duplex-link $n(10) $n(239) 1.5Mb 770ms DropTail
$ns duplex-link $n(10) $n(225) 1.5Mb 970ms DropTail
$ns duplex-link $n(10) $n(224) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "490..."; flush stdout }
$ns duplex-link $n(10) $n(220) 1.5Mb 180ms DropTail
$ns duplex-link $n(10) $n(218) 1.5Mb 1020ms DropTail
$ns duplex-link $n(10) $n(215) 1.5Mb 890ms DropTail
$ns duplex-link $n(10) $n(213) 1.5Mb 800ms DropTail
$ns duplex-link $n(10) $n(209) 1.5Mb 860ms DropTail
$ns duplex-link $n(10) $n(200) 1.5Mb 970ms DropTail
$ns duplex-link $n(10) $n(196) 1.5Mb 400ms DropTail
$ns duplex-link $n(10) $n(193) 1.5Mb 1080ms DropTail
$ns duplex-link $n(10) $n(190) 1.5Mb 400ms DropTail
$ns duplex-link $n(10) $n(185) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "500..."; flush stdout }
$ns duplex-link $n(10) $n(181) 1.5Mb 200ms DropTail
$ns duplex-link $n(10) $n(177) 1.5Mb 520ms DropTail
$ns duplex-link $n(10) $n(175) 1.5Mb 450ms DropTail
$ns duplex-link $n(10) $n(173) 1.5Mb 410ms DropTail
$ns duplex-link $n(10) $n(171) 1.5Mb 930ms DropTail
$ns duplex-link $n(10) $n(164) 1.5Mb 870ms DropTail
$ns duplex-link $n(10) $n(158) 1.5Mb 890ms DropTail
$ns duplex-link $n(10) $n(156) 1.5Mb 680ms DropTail
$ns duplex-link $n(10) $n(155) 1.5Mb 580ms DropTail
$ns duplex-link $n(10) $n(153) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "510..."; flush stdout }
$ns duplex-link $n(10) $n(149) 1.5Mb 440ms DropTail
$ns duplex-link $n(10) $n(148) 1.5Mb 550ms DropTail
$ns duplex-link $n(10) $n(147) 1.5Mb 330ms DropTail
$ns duplex-link $n(10) $n(143) 1.5Mb 970ms DropTail
$ns duplex-link $n(10) $n(126) 1.5Mb 980ms DropTail
$ns duplex-link $n(10) $n(109) 1.5Mb 790ms DropTail
$ns duplex-link $n(10) $n(106) 1.5Mb 710ms DropTail
$ns duplex-link $n(10) $n(101) 1.5Mb 360ms DropTail
$ns duplex-link $n(10) $n(98) 1.5Mb 600ms DropTail
$ns duplex-link $n(10) $n(97) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "520..."; flush stdout }
$ns duplex-link $n(10) $n(94) 1.5Mb 480ms DropTail
$ns duplex-link $n(10) $n(92) 1.5Mb 370ms DropTail
$ns duplex-link $n(10) $n(83) 1.5Mb 710ms DropTail
$ns duplex-link $n(10) $n(80) 1.5Mb 280ms DropTail
$ns duplex-link $n(10) $n(74) 1.5Mb 640ms DropTail
$ns duplex-link $n(10) $n(73) 1.5Mb 600ms DropTail
$ns duplex-link $n(10) $n(69) 1.5Mb 620ms DropTail
$ns duplex-link $n(10) $n(56) 1.5Mb 740ms DropTail
$ns duplex-link $n(10) $n(55) 1.5Mb 650ms DropTail
$ns duplex-link $n(10) $n(52) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "530..."; flush stdout }
$ns duplex-link $n(10) $n(48) 1.5Mb 360ms DropTail
$ns duplex-link $n(10) $n(45) 1.5Mb 800ms DropTail
$ns duplex-link $n(10) $n(44) 1.5Mb 730ms DropTail
$ns duplex-link $n(10) $n(36) 1.5Mb 350ms DropTail
$ns duplex-link $n(10) $n(34) 1.5Mb 920ms DropTail
$ns duplex-link $n(10) $n(30) 1.5Mb 940ms DropTail
$ns duplex-link $n(10) $n(17) 1.5Mb 670ms DropTail
$ns duplex-link $n(10) $n(15) 1.5Mb 100ms DropTail
$ns duplex-link $n(10) $n(13) 1.5Mb 710ms DropTail
$ns duplex-link $n(10) $n(12) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "540..."; flush stdout }
$ns duplex-link $n(11) $n(238) 1.5Mb 520ms DropTail
$ns duplex-link $n(11) $n(230) 1.5Mb 850ms DropTail
$ns duplex-link $n(11) $n(225) 1.5Mb 420ms DropTail
$ns duplex-link $n(11) $n(223) 1.5Mb 630ms DropTail
$ns duplex-link $n(11) $n(222) 1.5Mb 350ms DropTail
$ns duplex-link $n(11) $n(207) 1.5Mb 290ms DropTail
$ns duplex-link $n(11) $n(203) 1.5Mb 900ms DropTail
$ns duplex-link $n(11) $n(197) 1.5Mb 790ms DropTail
$ns duplex-link $n(11) $n(196) 1.5Mb 180ms DropTail
$ns duplex-link $n(11) $n(195) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "550..."; flush stdout }
$ns duplex-link $n(11) $n(187) 1.5Mb 660ms DropTail
$ns duplex-link $n(11) $n(177) 1.5Mb 780ms DropTail
$ns duplex-link $n(11) $n(169) 1.5Mb 540ms DropTail
$ns duplex-link $n(11) $n(162) 1.5Mb 340ms DropTail
$ns duplex-link $n(11) $n(161) 1.5Mb 340ms DropTail
$ns duplex-link $n(11) $n(136) 1.5Mb 190ms DropTail
$ns duplex-link $n(11) $n(130) 1.5Mb 310ms DropTail
$ns duplex-link $n(11) $n(129) 1.5Mb 380ms DropTail
$ns duplex-link $n(11) $n(128) 1.5Mb 560ms DropTail
$ns duplex-link $n(11) $n(126) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "560..."; flush stdout }
$ns duplex-link $n(11) $n(124) 1.5Mb 450ms DropTail
$ns duplex-link $n(11) $n(121) 1.5Mb 320ms DropTail
$ns duplex-link $n(11) $n(114) 1.5Mb 840ms DropTail
$ns duplex-link $n(11) $n(112) 1.5Mb 530ms DropTail
$ns duplex-link $n(11) $n(100) 1.5Mb 730ms DropTail
$ns duplex-link $n(11) $n(95) 1.5Mb 240ms DropTail
$ns duplex-link $n(11) $n(88) 1.5Mb 400ms DropTail
$ns duplex-link $n(11) $n(73) 1.5Mb 660ms DropTail
$ns duplex-link $n(11) $n(64) 1.5Mb 540ms DropTail
$ns duplex-link $n(11) $n(62) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "570..."; flush stdout }
$ns duplex-link $n(11) $n(58) 1.5Mb 430ms DropTail
$ns duplex-link $n(11) $n(55) 1.5Mb 230ms DropTail
$ns duplex-link $n(11) $n(53) 1.5Mb 910ms DropTail
$ns duplex-link $n(11) $n(52) 1.5Mb 680ms DropTail
$ns duplex-link $n(11) $n(51) 1.5Mb 260ms DropTail
$ns duplex-link $n(11) $n(49) 1.5Mb 400ms DropTail
$ns duplex-link $n(11) $n(48) 1.5Mb 470ms DropTail
$ns duplex-link $n(11) $n(41) 1.5Mb 750ms DropTail
$ns duplex-link $n(11) $n(39) 1.5Mb 410ms DropTail
$ns duplex-link $n(11) $n(34) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "580..."; flush stdout }
$ns duplex-link $n(11) $n(26) 1.5Mb 460ms DropTail
$ns duplex-link $n(11) $n(24) 1.5Mb 420ms DropTail
$ns duplex-link $n(11) $n(13) 1.5Mb 220ms DropTail
$ns duplex-link $n(12) $n(249) 1.5Mb 420ms DropTail
$ns duplex-link $n(12) $n(242) 1.5Mb 440ms DropTail
$ns duplex-link $n(12) $n(234) 1.5Mb 270ms DropTail
$ns duplex-link $n(12) $n(233) 1.5Mb 250ms DropTail
$ns duplex-link $n(12) $n(231) 1.5Mb 470ms DropTail
$ns duplex-link $n(12) $n(230) 1.5Mb 490ms DropTail
$ns duplex-link $n(12) $n(222) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "590..."; flush stdout }
$ns duplex-link $n(12) $n(221) 1.5Mb 390ms DropTail
$ns duplex-link $n(12) $n(215) 1.5Mb 590ms DropTail
$ns duplex-link $n(12) $n(212) 1.5Mb 390ms DropTail
$ns duplex-link $n(12) $n(209) 1.5Mb 600ms DropTail
$ns duplex-link $n(12) $n(207) 1.5Mb 110ms DropTail
$ns duplex-link $n(12) $n(203) 1.5Mb 530ms DropTail
$ns duplex-link $n(12) $n(190) 1.5Mb 420ms DropTail
$ns duplex-link $n(12) $n(186) 1.5Mb 330ms DropTail
$ns duplex-link $n(12) $n(185) 1.5Mb 160ms DropTail
$ns duplex-link $n(12) $n(183) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "600..."; flush stdout }
$ns duplex-link $n(12) $n(181) 1.5Mb 400ms DropTail
$ns duplex-link $n(12) $n(169) 1.5Mb 590ms DropTail
$ns duplex-link $n(12) $n(165) 1.5Mb 700ms DropTail
$ns duplex-link $n(12) $n(164) 1.5Mb 520ms DropTail
$ns duplex-link $n(12) $n(150) 1.5Mb 470ms DropTail
$ns duplex-link $n(12) $n(149) 1.5Mb 380ms DropTail
$ns duplex-link $n(12) $n(144) 1.5Mb 640ms DropTail
$ns duplex-link $n(12) $n(142) 1.5Mb 470ms DropTail
$ns duplex-link $n(12) $n(128) 1.5Mb 280ms DropTail
$ns duplex-link $n(12) $n(127) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "610..."; flush stdout }
$ns duplex-link $n(12) $n(123) 1.5Mb 220ms DropTail
$ns duplex-link $n(12) $n(107) 1.5Mb 60ms DropTail
$ns duplex-link $n(12) $n(106) 1.5Mb 330ms DropTail
$ns duplex-link $n(12) $n(102) 1.5Mb 140ms DropTail
$ns duplex-link $n(12) $n(100) 1.5Mb 360ms DropTail
$ns duplex-link $n(12) $n(99) 1.5Mb 490ms DropTail
$ns duplex-link $n(12) $n(84) 1.5Mb 580ms DropTail
$ns duplex-link $n(12) $n(77) 1.5Mb 500ms DropTail
$ns duplex-link $n(12) $n(74) 1.5Mb 430ms DropTail
$ns duplex-link $n(12) $n(72) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "620..."; flush stdout }
$ns duplex-link $n(12) $n(69) 1.5Mb 240ms DropTail
$ns duplex-link $n(12) $n(64) 1.5Mb 300ms DropTail
$ns duplex-link $n(12) $n(47) 1.5Mb 260ms DropTail
$ns duplex-link $n(12) $n(46) 1.5Mb 360ms DropTail
$ns duplex-link $n(12) $n(41) 1.5Mb 610ms DropTail
$ns duplex-link $n(12) $n(39) 1.5Mb 140ms DropTail
$ns duplex-link $n(12) $n(35) 1.5Mb 540ms DropTail
$ns duplex-link $n(12) $n(29) 1.5Mb 360ms DropTail
$ns duplex-link $n(12) $n(13) 1.5Mb 400ms DropTail
$ns duplex-link $n(13) $n(249) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "630..."; flush stdout }
$ns duplex-link $n(13) $n(248) 1.5Mb 590ms DropTail
$ns duplex-link $n(13) $n(219) 1.5Mb 560ms DropTail
$ns duplex-link $n(13) $n(205) 1.5Mb 300ms DropTail
$ns duplex-link $n(13) $n(200) 1.5Mb 520ms DropTail
$ns duplex-link $n(13) $n(185) 1.5Mb 550ms DropTail
$ns duplex-link $n(13) $n(183) 1.5Mb 230ms DropTail
$ns duplex-link $n(13) $n(160) 1.5Mb 250ms DropTail
$ns duplex-link $n(13) $n(159) 1.5Mb 480ms DropTail
$ns duplex-link $n(13) $n(144) 1.5Mb 630ms DropTail
$ns duplex-link $n(13) $n(138) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "640..."; flush stdout }
$ns duplex-link $n(13) $n(133) 1.5Mb 420ms DropTail
$ns duplex-link $n(13) $n(132) 1.5Mb 290ms DropTail
$ns duplex-link $n(13) $n(131) 1.5Mb 760ms DropTail
$ns duplex-link $n(13) $n(129) 1.5Mb 300ms DropTail
$ns duplex-link $n(13) $n(127) 1.5Mb 270ms DropTail
$ns duplex-link $n(13) $n(125) 1.5Mb 220ms DropTail
$ns duplex-link $n(13) $n(107) 1.5Mb 460ms DropTail
$ns duplex-link $n(13) $n(104) 1.5Mb 320ms DropTail
$ns duplex-link $n(13) $n(89) 1.5Mb 730ms DropTail
$ns duplex-link $n(13) $n(86) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "650..."; flush stdout }
$ns duplex-link $n(13) $n(84) 1.5Mb 250ms DropTail
$ns duplex-link $n(13) $n(78) 1.5Mb 710ms DropTail
$ns duplex-link $n(13) $n(69) 1.5Mb 320ms DropTail
$ns duplex-link $n(13) $n(64) 1.5Mb 660ms DropTail
$ns duplex-link $n(13) $n(58) 1.5Mb 210ms DropTail
$ns duplex-link $n(13) $n(56) 1.5Mb 460ms DropTail
$ns duplex-link $n(13) $n(49) 1.5Mb 510ms DropTail
$ns duplex-link $n(13) $n(48) 1.5Mb 490ms DropTail
$ns duplex-link $n(13) $n(42) 1.5Mb 300ms DropTail
$ns duplex-link $n(13) $n(31) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "660..."; flush stdout }
$ns duplex-link $n(13) $n(29) 1.5Mb 270ms DropTail
$ns duplex-link $n(13) $n(24) 1.5Mb 500ms DropTail
$ns duplex-link $n(14) $n(247) 1.5Mb 390ms DropTail
$ns duplex-link $n(14) $n(246) 1.5Mb 320ms DropTail
$ns duplex-link $n(14) $n(245) 1.5Mb 780ms DropTail
$ns duplex-link $n(14) $n(243) 1.5Mb 430ms DropTail
$ns duplex-link $n(14) $n(240) 1.5Mb 760ms DropTail
$ns duplex-link $n(14) $n(237) 1.5Mb 770ms DropTail
$ns duplex-link $n(14) $n(236) 1.5Mb 350ms DropTail
$ns duplex-link $n(14) $n(235) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "670..."; flush stdout }
$ns duplex-link $n(14) $n(231) 1.5Mb 600ms DropTail
$ns duplex-link $n(14) $n(218) 1.5Mb 230ms DropTail
$ns duplex-link $n(14) $n(211) 1.5Mb 710ms DropTail
$ns duplex-link $n(14) $n(198) 1.5Mb 1090ms DropTail
$ns duplex-link $n(14) $n(194) 1.5Mb 900ms DropTail
$ns duplex-link $n(14) $n(190) 1.5Mb 940ms DropTail
$ns duplex-link $n(14) $n(183) 1.5Mb 760ms DropTail
$ns duplex-link $n(14) $n(176) 1.5Mb 660ms DropTail
$ns duplex-link $n(14) $n(172) 1.5Mb 940ms DropTail
$ns duplex-link $n(14) $n(165) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "680..."; flush stdout }
$ns duplex-link $n(14) $n(163) 1.5Mb 550ms DropTail
$ns duplex-link $n(14) $n(159) 1.5Mb 70ms DropTail
$ns duplex-link $n(14) $n(153) 1.5Mb 900ms DropTail
$ns duplex-link $n(14) $n(145) 1.5Mb 100ms DropTail
$ns duplex-link $n(14) $n(144) 1.5Mb 100ms DropTail
$ns duplex-link $n(14) $n(141) 1.5Mb 610ms DropTail
$ns duplex-link $n(14) $n(139) 1.5Mb 720ms DropTail
$ns duplex-link $n(14) $n(128) 1.5Mb 860ms DropTail
$ns duplex-link $n(14) $n(115) 1.5Mb 650ms DropTail
$ns duplex-link $n(14) $n(109) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "690..."; flush stdout }
$ns duplex-link $n(14) $n(104) 1.5Mb 430ms DropTail
$ns duplex-link $n(14) $n(100) 1.5Mb 610ms DropTail
$ns duplex-link $n(14) $n(99) 1.5Mb 610ms DropTail
$ns duplex-link $n(14) $n(95) 1.5Mb 510ms DropTail
$ns duplex-link $n(14) $n(84) 1.5Mb 420ms DropTail
$ns duplex-link $n(14) $n(81) 1.5Mb 500ms DropTail
$ns duplex-link $n(14) $n(75) 1.5Mb 250ms DropTail
$ns duplex-link $n(14) $n(70) 1.5Mb 120ms DropTail
$ns duplex-link $n(14) $n(68) 1.5Mb 200ms DropTail
$ns duplex-link $n(14) $n(65) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "700..."; flush stdout }
$ns duplex-link $n(14) $n(43) 1.5Mb 430ms DropTail
$ns duplex-link $n(14) $n(35) 1.5Mb 400ms DropTail
$ns duplex-link $n(14) $n(32) 1.5Mb 710ms DropTail
$ns duplex-link $n(14) $n(27) 1.5Mb 270ms DropTail
$ns duplex-link $n(14) $n(23) 1.5Mb 600ms DropTail
$ns duplex-link $n(14) $n(22) 1.5Mb 650ms DropTail
$ns duplex-link $n(14) $n(21) 1.5Mb 650ms DropTail
$ns duplex-link $n(14) $n(19) 1.5Mb 470ms DropTail
$ns duplex-link $n(14) $n(15) 1.5Mb 1020ms DropTail
$ns duplex-link $n(15) $n(249) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "710..."; flush stdout }
$ns duplex-link $n(15) $n(242) 1.5Mb 70ms DropTail
$ns duplex-link $n(15) $n(229) 1.5Mb 230ms DropTail
$ns duplex-link $n(15) $n(228) 1.5Mb 1040ms DropTail
$ns duplex-link $n(15) $n(223) 1.5Mb 940ms DropTail
$ns duplex-link $n(15) $n(221) 1.5Mb 680ms DropTail
$ns duplex-link $n(15) $n(216) 1.5Mb 690ms DropTail
$ns duplex-link $n(15) $n(211) 1.5Mb 420ms DropTail
$ns duplex-link $n(15) $n(208) 1.5Mb 610ms DropTail
$ns duplex-link $n(15) $n(205) 1.5Mb 610ms DropTail
$ns duplex-link $n(15) $n(203) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "720..."; flush stdout }
$ns duplex-link $n(15) $n(197) 1.5Mb 990ms DropTail
$ns duplex-link $n(15) $n(196) 1.5Mb 360ms DropTail
$ns duplex-link $n(15) $n(194) 1.5Mb 170ms DropTail
$ns duplex-link $n(15) $n(189) 1.5Mb 480ms DropTail
$ns duplex-link $n(15) $n(174) 1.5Mb 210ms DropTail
$ns duplex-link $n(15) $n(168) 1.5Mb 740ms DropTail
$ns duplex-link $n(15) $n(159) 1.5Mb 970ms DropTail
$ns duplex-link $n(15) $n(151) 1.5Mb 490ms DropTail
$ns duplex-link $n(15) $n(149) 1.5Mb 370ms DropTail
$ns duplex-link $n(15) $n(142) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "730..."; flush stdout }
$ns duplex-link $n(15) $n(138) 1.5Mb 330ms DropTail
$ns duplex-link $n(15) $n(137) 1.5Mb 360ms DropTail
$ns duplex-link $n(15) $n(120) 1.5Mb 270ms DropTail
$ns duplex-link $n(15) $n(116) 1.5Mb 630ms DropTail
$ns duplex-link $n(15) $n(115) 1.5Mb 610ms DropTail
$ns duplex-link $n(15) $n(111) 1.5Mb 630ms DropTail
$ns duplex-link $n(15) $n(106) 1.5Mb 730ms DropTail
$ns duplex-link $n(15) $n(97) 1.5Mb 710ms DropTail
$ns duplex-link $n(15) $n(95) 1.5Mb 650ms DropTail
$ns duplex-link $n(15) $n(86) 1.5Mb 1030ms DropTail
if {$verbose} { puts -nonewline "740..."; flush stdout }
$ns duplex-link $n(15) $n(81) 1.5Mb 530ms DropTail
$ns duplex-link $n(15) $n(62) 1.5Mb 890ms DropTail
$ns duplex-link $n(15) $n(51) 1.5Mb 770ms DropTail
$ns duplex-link $n(15) $n(48) 1.5Mb 410ms DropTail
$ns duplex-link $n(15) $n(40) 1.5Mb 520ms DropTail
$ns duplex-link $n(15) $n(39) 1.5Mb 260ms DropTail
$ns duplex-link $n(15) $n(21) 1.5Mb 800ms DropTail
$ns duplex-link $n(15) $n(20) 1.5Mb 640ms DropTail
$ns duplex-link $n(16) $n(240) 1.5Mb 800ms DropTail
$ns duplex-link $n(16) $n(238) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "750..."; flush stdout }
$ns duplex-link $n(16) $n(227) 1.5Mb 810ms DropTail
$ns duplex-link $n(16) $n(225) 1.5Mb 650ms DropTail
$ns duplex-link $n(16) $n(224) 1.5Mb 720ms DropTail
$ns duplex-link $n(16) $n(219) 1.5Mb 580ms DropTail
$ns duplex-link $n(16) $n(218) 1.5Mb 970ms DropTail
$ns duplex-link $n(16) $n(213) 1.5Mb 690ms DropTail
$ns duplex-link $n(16) $n(201) 1.5Mb 660ms DropTail
$ns duplex-link $n(16) $n(197) 1.5Mb 880ms DropTail
$ns duplex-link $n(16) $n(187) 1.5Mb 720ms DropTail
$ns duplex-link $n(16) $n(180) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "760..."; flush stdout }
$ns duplex-link $n(16) $n(177) 1.5Mb 700ms DropTail
$ns duplex-link $n(16) $n(174) 1.5Mb 90ms DropTail
$ns duplex-link $n(16) $n(171) 1.5Mb 630ms DropTail
$ns duplex-link $n(16) $n(169) 1.5Mb 730ms DropTail
$ns duplex-link $n(16) $n(167) 1.5Mb 860ms DropTail
$ns duplex-link $n(16) $n(160) 1.5Mb 600ms DropTail
$ns duplex-link $n(16) $n(149) 1.5Mb 80ms DropTail
$ns duplex-link $n(16) $n(142) 1.5Mb 330ms DropTail
$ns duplex-link $n(16) $n(138) 1.5Mb 70ms DropTail
$ns duplex-link $n(16) $n(127) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "770..."; flush stdout }
$ns duplex-link $n(16) $n(117) 1.5Mb 460ms DropTail
$ns duplex-link $n(16) $n(104) 1.5Mb 470ms DropTail
$ns duplex-link $n(16) $n(85) 1.5Mb 390ms DropTail
$ns duplex-link $n(16) $n(75) 1.5Mb 840ms DropTail
$ns duplex-link $n(16) $n(71) 1.5Mb 640ms DropTail
$ns duplex-link $n(16) $n(67) 1.5Mb 490ms DropTail
$ns duplex-link $n(16) $n(58) 1.5Mb 620ms DropTail
$ns duplex-link $n(16) $n(55) 1.5Mb 400ms DropTail
$ns duplex-link $n(16) $n(51) 1.5Mb 480ms DropTail
$ns duplex-link $n(16) $n(50) 1.5Mb 60ms DropTail
if {$verbose} { puts -nonewline "780..."; flush stdout }
$ns duplex-link $n(16) $n(49) 1.5Mb 260ms DropTail
$ns duplex-link $n(16) $n(45) 1.5Mb 510ms DropTail
$ns duplex-link $n(16) $n(42) 1.5Mb 710ms DropTail
$ns duplex-link $n(16) $n(40) 1.5Mb 540ms DropTail
$ns duplex-link $n(16) $n(37) 1.5Mb 880ms DropTail
$ns duplex-link $n(16) $n(36) 1.5Mb 510ms DropTail
$ns duplex-link $n(16) $n(34) 1.5Mb 860ms DropTail
$ns duplex-link $n(16) $n(18) 1.5Mb 440ms DropTail
$ns duplex-link $n(17) $n(237) 1.5Mb 890ms DropTail
$ns duplex-link $n(17) $n(236) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "790..."; flush stdout }
$ns duplex-link $n(17) $n(233) 1.5Mb 730ms DropTail
$ns duplex-link $n(17) $n(227) 1.5Mb 960ms DropTail
$ns duplex-link $n(17) $n(225) 1.5Mb 360ms DropTail
$ns duplex-link $n(17) $n(220) 1.5Mb 720ms DropTail
$ns duplex-link $n(17) $n(203) 1.5Mb 1010ms DropTail
$ns duplex-link $n(17) $n(199) 1.5Mb 1020ms DropTail
$ns duplex-link $n(17) $n(190) 1.5Mb 320ms DropTail
$ns duplex-link $n(17) $n(188) 1.5Mb 590ms DropTail
$ns duplex-link $n(17) $n(185) 1.5Mb 620ms DropTail
$ns duplex-link $n(17) $n(178) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "800..."; flush stdout }
$ns duplex-link $n(17) $n(177) 1.5Mb 890ms DropTail
$ns duplex-link $n(17) $n(176) 1.5Mb 360ms DropTail
$ns duplex-link $n(17) $n(156) 1.5Mb 280ms DropTail
$ns duplex-link $n(17) $n(155) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(148) 1.5Mb 360ms DropTail
$ns duplex-link $n(17) $n(147) 1.5Mb 480ms DropTail
$ns duplex-link $n(17) $n(146) 1.5Mb 410ms DropTail
$ns duplex-link $n(17) $n(145) 1.5Mb 690ms DropTail
$ns duplex-link $n(17) $n(140) 1.5Mb 860ms DropTail
$ns duplex-link $n(17) $n(131) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "810..."; flush stdout }
$ns duplex-link $n(17) $n(130) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(129) 1.5Mb 470ms DropTail
$ns duplex-link $n(17) $n(117) 1.5Mb 650ms DropTail
$ns duplex-link $n(17) $n(110) 1.5Mb 160ms DropTail
$ns duplex-link $n(17) $n(107) 1.5Mb 530ms DropTail
$ns duplex-link $n(17) $n(106) 1.5Mb 610ms DropTail
$ns duplex-link $n(17) $n(103) 1.5Mb 400ms DropTail
$ns duplex-link $n(17) $n(95) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(91) 1.5Mb 820ms DropTail
$ns duplex-link $n(17) $n(90) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "820..."; flush stdout }
$ns duplex-link $n(17) $n(89) 1.5Mb 770ms DropTail
$ns duplex-link $n(17) $n(79) 1.5Mb 590ms DropTail
$ns duplex-link $n(17) $n(70) 1.5Mb 680ms DropTail
$ns duplex-link $n(17) $n(68) 1.5Mb 600ms DropTail
$ns duplex-link $n(17) $n(59) 1.5Mb 570ms DropTail
$ns duplex-link $n(17) $n(53) 1.5Mb 1030ms DropTail
$ns duplex-link $n(17) $n(51) 1.5Mb 190ms DropTail
$ns duplex-link $n(17) $n(46) 1.5Mb 840ms DropTail
$ns duplex-link $n(17) $n(45) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(31) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "830..."; flush stdout }
$ns duplex-link $n(17) $n(28) 1.5Mb 970ms DropTail
$ns duplex-link $n(17) $n(26) 1.5Mb 450ms DropTail
$ns duplex-link $n(17) $n(22) 1.5Mb 370ms DropTail
$ns duplex-link $n(18) $n(247) 1.5Mb 330ms DropTail
$ns duplex-link $n(18) $n(245) 1.5Mb 630ms DropTail
$ns duplex-link $n(18) $n(244) 1.5Mb 380ms DropTail
$ns duplex-link $n(18) $n(239) 1.5Mb 180ms DropTail
$ns duplex-link $n(18) $n(228) 1.5Mb 600ms DropTail
$ns duplex-link $n(18) $n(222) 1.5Mb 330ms DropTail
$ns duplex-link $n(18) $n(216) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "840..."; flush stdout }
$ns duplex-link $n(18) $n(214) 1.5Mb 320ms DropTail
$ns duplex-link $n(18) $n(213) 1.5Mb 260ms DropTail
$ns duplex-link $n(18) $n(202) 1.5Mb 450ms DropTail
$ns duplex-link $n(18) $n(194) 1.5Mb 540ms DropTail
$ns duplex-link $n(18) $n(187) 1.5Mb 330ms DropTail
$ns duplex-link $n(18) $n(182) 1.5Mb 400ms DropTail
$ns duplex-link $n(18) $n(179) 1.5Mb 470ms DropTail
$ns duplex-link $n(18) $n(169) 1.5Mb 350ms DropTail
$ns duplex-link $n(18) $n(168) 1.5Mb 340ms DropTail
$ns duplex-link $n(18) $n(162) 1.5Mb 70ms DropTail
if {$verbose} { puts -nonewline "850..."; flush stdout }
$ns duplex-link $n(18) $n(154) 1.5Mb 470ms DropTail
$ns duplex-link $n(18) $n(149) 1.5Mb 450ms DropTail
$ns duplex-link $n(18) $n(145) 1.5Mb 350ms DropTail
$ns duplex-link $n(18) $n(144) 1.5Mb 480ms DropTail
$ns duplex-link $n(18) $n(139) 1.5Mb 350ms DropTail
$ns duplex-link $n(18) $n(136) 1.5Mb 200ms DropTail
$ns duplex-link $n(18) $n(133) 1.5Mb 460ms DropTail
$ns duplex-link $n(18) $n(122) 1.5Mb 380ms DropTail
$ns duplex-link $n(18) $n(111) 1.5Mb 340ms DropTail
$ns duplex-link $n(18) $n(95) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "860..."; flush stdout }
$ns duplex-link $n(18) $n(88) 1.5Mb 180ms DropTail
$ns duplex-link $n(18) $n(87) 1.5Mb 170ms DropTail
$ns duplex-link $n(18) $n(79) 1.5Mb 250ms DropTail
$ns duplex-link $n(18) $n(68) 1.5Mb 310ms DropTail
$ns duplex-link $n(18) $n(67) 1.5Mb 270ms DropTail
$ns duplex-link $n(18) $n(62) 1.5Mb 310ms DropTail
$ns duplex-link $n(18) $n(54) 1.5Mb 240ms DropTail
$ns duplex-link $n(18) $n(53) 1.5Mb 690ms DropTail
$ns duplex-link $n(18) $n(52) 1.5Mb 340ms DropTail
$ns duplex-link $n(18) $n(44) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "870..."; flush stdout }
$ns duplex-link $n(18) $n(42) 1.5Mb 440ms DropTail
$ns duplex-link $n(18) $n(36) 1.5Mb 450ms DropTail
$ns duplex-link $n(18) $n(34) 1.5Mb 440ms DropTail
$ns duplex-link $n(18) $n(32) 1.5Mb 620ms DropTail
$ns duplex-link $n(18) $n(28) 1.5Mb 670ms DropTail
$ns duplex-link $n(18) $n(22) 1.5Mb 230ms DropTail
$ns duplex-link $n(18) $n(21) 1.5Mb 390ms DropTail
$ns duplex-link $n(18) $n(19) 1.5Mb 140ms DropTail
$ns duplex-link $n(19) $n(247) 1.5Mb 460ms DropTail
$ns duplex-link $n(19) $n(241) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "880..."; flush stdout }
$ns duplex-link $n(19) $n(238) 1.5Mb 250ms DropTail
$ns duplex-link $n(19) $n(237) 1.5Mb 450ms DropTail
$ns duplex-link $n(19) $n(234) 1.5Mb 170ms DropTail
$ns duplex-link $n(19) $n(232) 1.5Mb 520ms DropTail
$ns duplex-link $n(19) $n(225) 1.5Mb 600ms DropTail
$ns duplex-link $n(19) $n(223) 1.5Mb 400ms DropTail
$ns duplex-link $n(19) $n(219) 1.5Mb 210ms DropTail
$ns duplex-link $n(19) $n(209) 1.5Mb 560ms DropTail
$ns duplex-link $n(19) $n(206) 1.5Mb 480ms DropTail
$ns duplex-link $n(19) $n(205) 1.5Mb 70ms DropTail
if {$verbose} { puts -nonewline "890..."; flush stdout }
$ns duplex-link $n(19) $n(203) 1.5Mb 560ms DropTail
$ns duplex-link $n(19) $n(201) 1.5Mb 600ms DropTail
$ns duplex-link $n(19) $n(196) 1.5Mb 310ms DropTail
$ns duplex-link $n(19) $n(180) 1.5Mb 480ms DropTail
$ns duplex-link $n(19) $n(179) 1.5Mb 460ms DropTail
$ns duplex-link $n(19) $n(169) 1.5Mb 470ms DropTail
$ns duplex-link $n(19) $n(164) 1.5Mb 380ms DropTail
$ns duplex-link $n(19) $n(162) 1.5Mb 210ms DropTail
$ns duplex-link $n(19) $n(153) 1.5Mb 510ms DropTail
$ns duplex-link $n(19) $n(146) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "900..."; flush stdout }
$ns duplex-link $n(19) $n(136) 1.5Mb 320ms DropTail
$ns duplex-link $n(19) $n(129) 1.5Mb 60ms DropTail
$ns duplex-link $n(19) $n(125) 1.5Mb 450ms DropTail
$ns duplex-link $n(19) $n(120) 1.5Mb 340ms DropTail
$ns duplex-link $n(19) $n(114) 1.5Mb 500ms DropTail
$ns duplex-link $n(19) $n(111) 1.5Mb 450ms DropTail
$ns duplex-link $n(19) $n(106) 1.5Mb 180ms DropTail
$ns duplex-link $n(19) $n(94) 1.5Mb 80ms DropTail
$ns duplex-link $n(19) $n(93) 1.5Mb 480ms DropTail
$ns duplex-link $n(19) $n(91) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "910..."; flush stdout }
$ns duplex-link $n(19) $n(90) 1.5Mb 260ms DropTail
$ns duplex-link $n(19) $n(89) 1.5Mb 450ms DropTail
$ns duplex-link $n(19) $n(85) 1.5Mb 170ms DropTail
$ns duplex-link $n(19) $n(84) 1.5Mb 480ms DropTail
$ns duplex-link $n(19) $n(82) 1.5Mb 500ms DropTail
$ns duplex-link $n(19) $n(74) 1.5Mb 450ms DropTail
$ns duplex-link $n(19) $n(70) 1.5Mb 400ms DropTail
$ns duplex-link $n(19) $n(69) 1.5Mb 90ms DropTail
$ns duplex-link $n(19) $n(68) 1.5Mb 400ms DropTail
$ns duplex-link $n(19) $n(64) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "920..."; flush stdout }
$ns duplex-link $n(19) $n(63) 1.5Mb 480ms DropTail
$ns duplex-link $n(19) $n(61) 1.5Mb 360ms DropTail
$ns duplex-link $n(19) $n(56) 1.5Mb 230ms DropTail
$ns duplex-link $n(19) $n(52) 1.5Mb 350ms DropTail
$ns duplex-link $n(19) $n(49) 1.5Mb 320ms DropTail
$ns duplex-link $n(19) $n(29) 1.5Mb 420ms DropTail
$ns duplex-link $n(19) $n(27) 1.5Mb 420ms DropTail
$ns duplex-link $n(19) $n(25) 1.5Mb 190ms DropTail
$ns duplex-link $n(19) $n(24) 1.5Mb 290ms DropTail
$ns duplex-link $n(20) $n(249) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "930..."; flush stdout }
$ns duplex-link $n(20) $n(248) 1.5Mb 450ms DropTail
$ns duplex-link $n(20) $n(234) 1.5Mb 550ms DropTail
$ns duplex-link $n(20) $n(229) 1.5Mb 710ms DropTail
$ns duplex-link $n(20) $n(227) 1.5Mb 340ms DropTail
$ns duplex-link $n(20) $n(226) 1.5Mb 930ms DropTail
$ns duplex-link $n(20) $n(207) 1.5Mb 690ms DropTail
$ns duplex-link $n(20) $n(205) 1.5Mb 700ms DropTail
$ns duplex-link $n(20) $n(200) 1.5Mb 930ms DropTail
$ns duplex-link $n(20) $n(196) 1.5Mb 770ms DropTail
$ns duplex-link $n(20) $n(195) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "940..."; flush stdout }
$ns duplex-link $n(20) $n(193) 1.5Mb 850ms DropTail
$ns duplex-link $n(20) $n(190) 1.5Mb 890ms DropTail
$ns duplex-link $n(20) $n(188) 1.5Mb 500ms DropTail
$ns duplex-link $n(20) $n(171) 1.5Mb 1150ms DropTail
$ns duplex-link $n(20) $n(169) 1.5Mb 1080ms DropTail
$ns duplex-link $n(20) $n(158) 1.5Mb 1110ms DropTail
$ns duplex-link $n(20) $n(155) 1.5Mb 830ms DropTail
$ns duplex-link $n(20) $n(147) 1.5Mb 580ms DropTail
$ns duplex-link $n(20) $n(141) 1.5Mb 1090ms DropTail
$ns duplex-link $n(20) $n(132) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "950..."; flush stdout }
$ns duplex-link $n(20) $n(125) 1.5Mb 1080ms DropTail
$ns duplex-link $n(20) $n(123) 1.5Mb 520ms DropTail
$ns duplex-link $n(20) $n(120) 1.5Mb 710ms DropTail
$ns duplex-link $n(20) $n(106) 1.5Mb 710ms DropTail
$ns duplex-link $n(20) $n(93) 1.5Mb 1100ms DropTail
$ns duplex-link $n(20) $n(92) 1.5Mb 860ms DropTail
$ns duplex-link $n(20) $n(89) 1.5Mb 310ms DropTail
$ns duplex-link $n(20) $n(82) 1.5Mb 720ms DropTail
$ns duplex-link $n(20) $n(73) 1.5Mb 460ms DropTail
$ns duplex-link $n(20) $n(68) 1.5Mb 980ms DropTail
if {$verbose} { puts -nonewline "960..."; flush stdout }
$ns duplex-link $n(20) $n(61) 1.5Mb 990ms DropTail
$ns duplex-link $n(20) $n(60) 1.5Mb 370ms DropTail
$ns duplex-link $n(20) $n(54) 1.5Mb 690ms DropTail
$ns duplex-link $n(20) $n(51) 1.5Mb 1120ms DropTail
$ns duplex-link $n(20) $n(50) 1.5Mb 770ms DropTail
$ns duplex-link $n(20) $n(44) 1.5Mb 950ms DropTail
$ns duplex-link $n(20) $n(31) 1.5Mb 210ms DropTail
$ns duplex-link $n(20) $n(27) 1.5Mb 1020ms DropTail
$ns duplex-link $n(20) $n(24) 1.5Mb 530ms DropTail
$ns duplex-link $n(21) $n(245) 1.5Mb 1010ms DropTail
if {$verbose} { puts -nonewline "970..."; flush stdout }
$ns duplex-link $n(21) $n(240) 1.5Mb 1040ms DropTail
$ns duplex-link $n(21) $n(234) 1.5Mb 670ms DropTail
$ns duplex-link $n(21) $n(233) 1.5Mb 800ms DropTail
$ns duplex-link $n(21) $n(228) 1.5Mb 930ms DropTail
$ns duplex-link $n(21) $n(226) 1.5Mb 620ms DropTail
$ns duplex-link $n(21) $n(223) 1.5Mb 520ms DropTail
$ns duplex-link $n(21) $n(219) 1.5Mb 730ms DropTail
$ns duplex-link $n(21) $n(211) 1.5Mb 790ms DropTail
$ns duplex-link $n(21) $n(209) 1.5Mb 40ms DropTail
$ns duplex-link $n(21) $n(206) 1.5Mb 970ms DropTail
if {$verbose} { puts -nonewline "980..."; flush stdout }
$ns duplex-link $n(21) $n(200) 1.5Mb 620ms DropTail
$ns duplex-link $n(21) $n(197) 1.5Mb 740ms DropTail
$ns duplex-link $n(21) $n(191) 1.5Mb 780ms DropTail
$ns duplex-link $n(21) $n(182) 1.5Mb 680ms DropTail
$ns duplex-link $n(21) $n(176) 1.5Mb 460ms DropTail
$ns duplex-link $n(21) $n(172) 1.5Mb 770ms DropTail
$ns duplex-link $n(21) $n(171) 1.5Mb 150ms DropTail
$ns duplex-link $n(21) $n(167) 1.5Mb 990ms DropTail
$ns duplex-link $n(21) $n(153) 1.5Mb 980ms DropTail
$ns duplex-link $n(21) $n(148) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "990..."; flush stdout }
$ns duplex-link $n(21) $n(142) 1.5Mb 200ms DropTail
$ns duplex-link $n(21) $n(139) 1.5Mb 650ms DropTail
$ns duplex-link $n(21) $n(137) 1.5Mb 440ms DropTail
$ns duplex-link $n(21) $n(136) 1.5Mb 210ms DropTail
$ns duplex-link $n(21) $n(135) 1.5Mb 170ms DropTail
$ns duplex-link $n(21) $n(126) 1.5Mb 630ms DropTail
$ns duplex-link $n(21) $n(117) 1.5Mb 720ms DropTail
$ns duplex-link $n(21) $n(111) 1.5Mb 170ms DropTail
$ns duplex-link $n(21) $n(102) 1.5Mb 550ms DropTail
$ns duplex-link $n(21) $n(99) 1.5Mb 970ms DropTail
if {$verbose} { puts -nonewline "1000..."; flush stdout }
$ns duplex-link $n(21) $n(91) 1.5Mb 810ms DropTail
$ns duplex-link $n(21) $n(89) 1.5Mb 890ms DropTail
$ns duplex-link $n(21) $n(86) 1.5Mb 680ms DropTail
$ns duplex-link $n(21) $n(85) 1.5Mb 360ms DropTail
$ns duplex-link $n(21) $n(81) 1.5Mb 450ms DropTail
$ns duplex-link $n(21) $n(78) 1.5Mb 830ms DropTail
$ns duplex-link $n(21) $n(77) 1.5Mb 380ms DropTail
$ns duplex-link $n(21) $n(75) 1.5Mb 770ms DropTail
$ns duplex-link $n(21) $n(74) 1.5Mb 230ms DropTail
$ns duplex-link $n(21) $n(73) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "1010..."; flush stdout }
$ns duplex-link $n(21) $n(63) 1.5Mb 780ms DropTail
$ns duplex-link $n(21) $n(61) 1.5Mb 280ms DropTail
$ns duplex-link $n(21) $n(59) 1.5Mb 660ms DropTail
$ns duplex-link $n(21) $n(56) 1.5Mb 620ms DropTail
$ns duplex-link $n(21) $n(42) 1.5Mb 220ms DropTail
$ns duplex-link $n(21) $n(26) 1.5Mb 240ms DropTail
$ns duplex-link $n(21) $n(23) 1.5Mb 970ms DropTail
$ns duplex-link $n(22) $n(244) 1.5Mb 360ms DropTail
$ns duplex-link $n(22) $n(240) 1.5Mb 630ms DropTail
$ns duplex-link $n(22) $n(238) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "1020..."; flush stdout }
$ns duplex-link $n(22) $n(236) 1.5Mb 350ms DropTail
$ns duplex-link $n(22) $n(229) 1.5Mb 190ms DropTail
$ns duplex-link $n(22) $n(228) 1.5Mb 750ms DropTail
$ns duplex-link $n(22) $n(227) 1.5Mb 610ms DropTail
$ns duplex-link $n(22) $n(223) 1.5Mb 560ms DropTail
$ns duplex-link $n(22) $n(221) 1.5Mb 310ms DropTail
$ns duplex-link $n(22) $n(216) 1.5Mb 710ms DropTail
$ns duplex-link $n(22) $n(208) 1.5Mb 250ms DropTail
$ns duplex-link $n(22) $n(201) 1.5Mb 580ms DropTail
$ns duplex-link $n(22) $n(196) 1.5Mb 100ms DropTail
if {$verbose} { puts -nonewline "1030..."; flush stdout }
$ns duplex-link $n(22) $n(192) 1.5Mb 540ms DropTail
$ns duplex-link $n(22) $n(186) 1.5Mb 210ms DropTail
$ns duplex-link $n(22) $n(183) 1.5Mb 280ms DropTail
$ns duplex-link $n(22) $n(177) 1.5Mb 530ms DropTail
$ns duplex-link $n(22) $n(175) 1.5Mb 170ms DropTail
$ns duplex-link $n(22) $n(174) 1.5Mb 290ms DropTail
$ns duplex-link $n(22) $n(172) 1.5Mb 330ms DropTail
$ns duplex-link $n(22) $n(165) 1.5Mb 610ms DropTail
$ns duplex-link $n(22) $n(162) 1.5Mb 280ms DropTail
$ns duplex-link $n(22) $n(161) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "1040..."; flush stdout }
$ns duplex-link $n(22) $n(157) 1.5Mb 350ms DropTail
$ns duplex-link $n(22) $n(151) 1.5Mb 310ms DropTail
$ns duplex-link $n(22) $n(150) 1.5Mb 590ms DropTail
$ns duplex-link $n(22) $n(143) 1.5Mb 670ms DropTail
$ns duplex-link $n(22) $n(142) 1.5Mb 350ms DropTail
$ns duplex-link $n(22) $n(141) 1.5Mb 420ms DropTail
$ns duplex-link $n(22) $n(124) 1.5Mb 490ms DropTail
$ns duplex-link $n(22) $n(122) 1.5Mb 300ms DropTail
$ns duplex-link $n(22) $n(121) 1.5Mb 280ms DropTail
$ns duplex-link $n(22) $n(117) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "1050..."; flush stdout }
$ns duplex-link $n(22) $n(114) 1.5Mb 700ms DropTail
$ns duplex-link $n(22) $n(111) 1.5Mb 340ms DropTail
$ns duplex-link $n(22) $n(110) 1.5Mb 260ms DropTail
$ns duplex-link $n(22) $n(105) 1.5Mb 240ms DropTail
$ns duplex-link $n(22) $n(103) 1.5Mb 610ms DropTail
$ns duplex-link $n(22) $n(97) 1.5Mb 340ms DropTail
$ns duplex-link $n(22) $n(88) 1.5Mb 170ms DropTail
$ns duplex-link $n(22) $n(86) 1.5Mb 670ms DropTail
$ns duplex-link $n(22) $n(83) 1.5Mb 560ms DropTail
$ns duplex-link $n(22) $n(75) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "1060..."; flush stdout }
$ns duplex-link $n(22) $n(73) 1.5Mb 430ms DropTail
$ns duplex-link $n(22) $n(71) 1.5Mb 400ms DropTail
$ns duplex-link $n(22) $n(67) 1.5Mb 390ms DropTail
$ns duplex-link $n(22) $n(62) 1.5Mb 500ms DropTail
$ns duplex-link $n(22) $n(57) 1.5Mb 570ms DropTail
$ns duplex-link $n(22) $n(54) 1.5Mb 10ms DropTail
$ns duplex-link $n(22) $n(49) 1.5Mb 190ms DropTail
$ns duplex-link $n(22) $n(46) 1.5Mb 480ms DropTail
$ns duplex-link $n(22) $n(39) 1.5Mb 180ms DropTail
$ns duplex-link $n(22) $n(26) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "1070..."; flush stdout }
$ns duplex-link $n(22) $n(23) 1.5Mb 620ms DropTail
$ns duplex-link $n(23) $n(247) 1.5Mb 830ms DropTail
$ns duplex-link $n(23) $n(246) 1.5Mb 550ms DropTail
$ns duplex-link $n(23) $n(244) 1.5Mb 940ms DropTail
$ns duplex-link $n(23) $n(242) 1.5Mb 850ms DropTail
$ns duplex-link $n(23) $n(235) 1.5Mb 180ms DropTail
$ns duplex-link $n(23) $n(227) 1.5Mb 40ms DropTail
$ns duplex-link $n(23) $n(220) 1.5Mb 540ms DropTail
$ns duplex-link $n(23) $n(217) 1.5Mb 520ms DropTail
$ns duplex-link $n(23) $n(215) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "1080..."; flush stdout }
$ns duplex-link $n(23) $n(211) 1.5Mb 360ms DropTail
$ns duplex-link $n(23) $n(210) 1.5Mb 790ms DropTail
$ns duplex-link $n(23) $n(187) 1.5Mb 330ms DropTail
$ns duplex-link $n(23) $n(186) 1.5Mb 810ms DropTail
$ns duplex-link $n(23) $n(185) 1.5Mb 450ms DropTail
$ns duplex-link $n(23) $n(180) 1.5Mb 690ms DropTail
$ns duplex-link $n(23) $n(178) 1.5Mb 470ms DropTail
$ns duplex-link $n(23) $n(174) 1.5Mb 830ms DropTail
$ns duplex-link $n(23) $n(159) 1.5Mb 600ms DropTail
$ns duplex-link $n(23) $n(157) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "1090..."; flush stdout }
$ns duplex-link $n(23) $n(156) 1.5Mb 740ms DropTail
$ns duplex-link $n(23) $n(144) 1.5Mb 530ms DropTail
$ns duplex-link $n(23) $n(143) 1.5Mb 450ms DropTail
$ns duplex-link $n(23) $n(138) 1.5Mb 790ms DropTail
$ns duplex-link $n(23) $n(126) 1.5Mb 600ms DropTail
$ns duplex-link $n(23) $n(124) 1.5Mb 820ms DropTail
$ns duplex-link $n(23) $n(122) 1.5Mb 370ms DropTail
$ns duplex-link $n(23) $n(119) 1.5Mb 960ms DropTail
$ns duplex-link $n(23) $n(116) 1.5Mb 410ms DropTail
$ns duplex-link $n(23) $n(115) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "1100..."; flush stdout }
$ns duplex-link $n(23) $n(114) 1.5Mb 490ms DropTail
$ns duplex-link $n(23) $n(111) 1.5Mb 900ms DropTail
$ns duplex-link $n(23) $n(109) 1.5Mb 500ms DropTail
$ns duplex-link $n(23) $n(95) 1.5Mb 730ms DropTail
$ns duplex-link $n(23) $n(93) 1.5Mb 830ms DropTail
$ns duplex-link $n(23) $n(92) 1.5Mb 900ms DropTail
$ns duplex-link $n(23) $n(82) 1.5Mb 340ms DropTail
$ns duplex-link $n(23) $n(79) 1.5Mb 380ms DropTail
$ns duplex-link $n(23) $n(77) 1.5Mb 700ms DropTail
$ns duplex-link $n(23) $n(68) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "1110..."; flush stdout }
$ns duplex-link $n(23) $n(58) 1.5Mb 800ms DropTail
$ns duplex-link $n(23) $n(54) 1.5Mb 630ms DropTail
$ns duplex-link $n(23) $n(51) 1.5Mb 960ms DropTail
$ns duplex-link $n(23) $n(44) 1.5Mb 760ms DropTail
$ns duplex-link $n(23) $n(43) 1.5Mb 160ms DropTail
$ns duplex-link $n(23) $n(37) 1.5Mb 250ms DropTail
$ns duplex-link $n(23) $n(32) 1.5Mb 140ms DropTail
$ns duplex-link $n(23) $n(31) 1.5Mb 280ms DropTail
$ns duplex-link $n(23) $n(30) 1.5Mb 1040ms DropTail
$ns duplex-link $n(23) $n(24) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "1120..."; flush stdout }
$ns duplex-link $n(24) $n(241) 1.5Mb 390ms DropTail
$ns duplex-link $n(24) $n(234) 1.5Mb 380ms DropTail
$ns duplex-link $n(24) $n(229) 1.5Mb 190ms DropTail
$ns duplex-link $n(24) $n(216) 1.5Mb 560ms DropTail
$ns duplex-link $n(24) $n(213) 1.5Mb 560ms DropTail
$ns duplex-link $n(24) $n(191) 1.5Mb 720ms DropTail
$ns duplex-link $n(24) $n(187) 1.5Mb 530ms DropTail
$ns duplex-link $n(24) $n(185) 1.5Mb 110ms DropTail
$ns duplex-link $n(24) $n(184) 1.5Mb 410ms DropTail
$ns duplex-link $n(24) $n(178) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "1130..."; flush stdout }
$ns duplex-link $n(24) $n(169) 1.5Mb 730ms DropTail
$ns duplex-link $n(24) $n(165) 1.5Mb 800ms DropTail
$ns duplex-link $n(24) $n(164) 1.5Mb 640ms DropTail
$ns duplex-link $n(24) $n(152) 1.5Mb 290ms DropTail
$ns duplex-link $n(24) $n(147) 1.5Mb 90ms DropTail
$ns duplex-link $n(24) $n(131) 1.5Mb 600ms DropTail
$ns duplex-link $n(24) $n(123) 1.5Mb 80ms DropTail
$ns duplex-link $n(24) $n(108) 1.5Mb 280ms DropTail
$ns duplex-link $n(24) $n(104) 1.5Mb 340ms DropTail
$ns duplex-link $n(24) $n(102) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "1140..."; flush stdout }
$ns duplex-link $n(24) $n(91) 1.5Mb 470ms DropTail
$ns duplex-link $n(24) $n(84) 1.5Mb 710ms DropTail
$ns duplex-link $n(24) $n(83) 1.5Mb 520ms DropTail
$ns duplex-link $n(24) $n(72) 1.5Mb 520ms DropTail
$ns duplex-link $n(24) $n(65) 1.5Mb 390ms DropTail
$ns duplex-link $n(24) $n(63) 1.5Mb 750ms DropTail
$ns duplex-link $n(24) $n(46) 1.5Mb 400ms DropTail
$ns duplex-link $n(24) $n(40) 1.5Mb 270ms DropTail
$ns duplex-link $n(24) $n(36) 1.5Mb 220ms DropTail
$ns duplex-link $n(24) $n(34) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "1150..."; flush stdout }
$ns duplex-link $n(25) $n(247) 1.5Mb 650ms DropTail
$ns duplex-link $n(25) $n(244) 1.5Mb 650ms DropTail
$ns duplex-link $n(25) $n(236) 1.5Mb 220ms DropTail
$ns duplex-link $n(25) $n(232) 1.5Mb 550ms DropTail
$ns duplex-link $n(25) $n(224) 1.5Mb 300ms DropTail
$ns duplex-link $n(25) $n(221) 1.5Mb 530ms DropTail
$ns duplex-link $n(25) $n(219) 1.5Mb 60ms DropTail
$ns duplex-link $n(25) $n(217) 1.5Mb 250ms DropTail
$ns duplex-link $n(25) $n(213) 1.5Mb 380ms DropTail
$ns duplex-link $n(25) $n(197) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "1160..."; flush stdout }
$ns duplex-link $n(25) $n(194) 1.5Mb 360ms DropTail
$ns duplex-link $n(25) $n(190) 1.5Mb 600ms DropTail
$ns duplex-link $n(25) $n(184) 1.5Mb 470ms DropTail
$ns duplex-link $n(25) $n(177) 1.5Mb 240ms DropTail
$ns duplex-link $n(25) $n(172) 1.5Mb 420ms DropTail
$ns duplex-link $n(25) $n(171) 1.5Mb 710ms DropTail
$ns duplex-link $n(25) $n(146) 1.5Mb 450ms DropTail
$ns duplex-link $n(25) $n(139) 1.5Mb 220ms DropTail
$ns duplex-link $n(25) $n(130) 1.5Mb 650ms DropTail
$ns duplex-link $n(25) $n(128) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "1170..."; flush stdout }
$ns duplex-link $n(25) $n(125) 1.5Mb 640ms DropTail
$ns duplex-link $n(25) $n(123) 1.5Mb 320ms DropTail
$ns duplex-link $n(25) $n(122) 1.5Mb 90ms DropTail
$ns duplex-link $n(25) $n(119) 1.5Mb 660ms DropTail
$ns duplex-link $n(25) $n(116) 1.5Mb 460ms DropTail
$ns duplex-link $n(25) $n(108) 1.5Mb 210ms DropTail
$ns duplex-link $n(25) $n(107) 1.5Mb 180ms DropTail
$ns duplex-link $n(25) $n(100) 1.5Mb 170ms DropTail
$ns duplex-link $n(25) $n(84) 1.5Mb 660ms DropTail
$ns duplex-link $n(25) $n(82) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "1180..."; flush stdout }
$ns duplex-link $n(25) $n(80) 1.5Mb 260ms DropTail
$ns duplex-link $n(25) $n(69) 1.5Mb 260ms DropTail
$ns duplex-link $n(25) $n(64) 1.5Mb 360ms DropTail
$ns duplex-link $n(25) $n(60) 1.5Mb 70ms DropTail
$ns duplex-link $n(25) $n(59) 1.5Mb 150ms DropTail
$ns duplex-link $n(25) $n(49) 1.5Mb 290ms DropTail
$ns duplex-link $n(25) $n(46) 1.5Mb 170ms DropTail
$ns duplex-link $n(25) $n(33) 1.5Mb 310ms DropTail
$ns duplex-link $n(25) $n(32) 1.5Mb 300ms DropTail
$ns duplex-link $n(25) $n(30) 1.5Mb 800ms DropTail
if {$verbose} { puts -nonewline "1190..."; flush stdout }
$ns duplex-link $n(26) $n(247) 1.5Mb 40ms DropTail
$ns duplex-link $n(26) $n(242) 1.5Mb 920ms DropTail
$ns duplex-link $n(26) $n(222) 1.5Mb 650ms DropTail
$ns duplex-link $n(26) $n(213) 1.5Mb 410ms DropTail
$ns duplex-link $n(26) $n(212) 1.5Mb 420ms DropTail
$ns duplex-link $n(26) $n(207) 1.5Mb 470ms DropTail
$ns duplex-link $n(26) $n(199) 1.5Mb 690ms DropTail
$ns duplex-link $n(26) $n(198) 1.5Mb 900ms DropTail
$ns duplex-link $n(26) $n(197) 1.5Mb 540ms DropTail
$ns duplex-link $n(26) $n(196) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "1200..."; flush stdout }
$ns duplex-link $n(26) $n(193) 1.5Mb 750ms DropTail
$ns duplex-link $n(26) $n(191) 1.5Mb 600ms DropTail
$ns duplex-link $n(26) $n(185) 1.5Mb 740ms DropTail
$ns duplex-link $n(26) $n(177) 1.5Mb 900ms DropTail
$ns duplex-link $n(26) $n(174) 1.5Mb 750ms DropTail
$ns duplex-link $n(26) $n(164) 1.5Mb 570ms DropTail
$ns duplex-link $n(26) $n(155) 1.5Mb 350ms DropTail
$ns duplex-link $n(26) $n(152) 1.5Mb 580ms DropTail
$ns duplex-link $n(26) $n(149) 1.5Mb 630ms DropTail
$ns duplex-link $n(26) $n(148) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "1210..."; flush stdout }
$ns duplex-link $n(26) $n(146) 1.5Mb 220ms DropTail
$ns duplex-link $n(26) $n(143) 1.5Mb 580ms DropTail
$ns duplex-link $n(26) $n(133) 1.5Mb 660ms DropTail
$ns duplex-link $n(26) $n(128) 1.5Mb 860ms DropTail
$ns duplex-link $n(26) $n(127) 1.5Mb 520ms DropTail
$ns duplex-link $n(26) $n(122) 1.5Mb 730ms DropTail
$ns duplex-link $n(26) $n(121) 1.5Mb 260ms DropTail
$ns duplex-link $n(26) $n(117) 1.5Mb 710ms DropTail
$ns duplex-link $n(26) $n(110) 1.5Mb 350ms DropTail
$ns duplex-link $n(26) $n(101) 1.5Mb 880ms DropTail
if {$verbose} { puts -nonewline "1220..."; flush stdout }
$ns duplex-link $n(26) $n(96) 1.5Mb 460ms DropTail
$ns duplex-link $n(26) $n(92) 1.5Mb 730ms DropTail
$ns duplex-link $n(26) $n(91) 1.5Mb 700ms DropTail
$ns duplex-link $n(26) $n(83) 1.5Mb 770ms DropTail
$ns duplex-link $n(26) $n(78) 1.5Mb 630ms DropTail
$ns duplex-link $n(26) $n(76) 1.5Mb 530ms DropTail
$ns duplex-link $n(26) $n(71) 1.5Mb 530ms DropTail
$ns duplex-link $n(26) $n(68) 1.5Mb 230ms DropTail
$ns duplex-link $n(26) $n(60) 1.5Mb 740ms DropTail
$ns duplex-link $n(26) $n(57) 1.5Mb 860ms DropTail
if {$verbose} { puts -nonewline "1230..."; flush stdout }
$ns duplex-link $n(26) $n(55) 1.5Mb 280ms DropTail
$ns duplex-link $n(26) $n(50) 1.5Mb 630ms DropTail
$ns duplex-link $n(26) $n(43) 1.5Mb 710ms DropTail
$ns duplex-link $n(26) $n(33) 1.5Mb 890ms DropTail
$ns duplex-link $n(27) $n(249) 1.5Mb 880ms DropTail
$ns duplex-link $n(27) $n(234) 1.5Mb 480ms DropTail
$ns duplex-link $n(27) $n(220) 1.5Mb 860ms DropTail
$ns duplex-link $n(27) $n(200) 1.5Mb 250ms DropTail
$ns duplex-link $n(27) $n(199) 1.5Mb 530ms DropTail
$ns duplex-link $n(27) $n(198) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "1240..."; flush stdout }
$ns duplex-link $n(27) $n(184) 1.5Mb 380ms DropTail
$ns duplex-link $n(27) $n(182) 1.5Mb 330ms DropTail
$ns duplex-link $n(27) $n(177) 1.5Mb 810ms DropTail
$ns duplex-link $n(27) $n(174) 1.5Mb 790ms DropTail
$ns duplex-link $n(27) $n(173) 1.5Mb 720ms DropTail
$ns duplex-link $n(27) $n(153) 1.5Mb 930ms DropTail
$ns duplex-link $n(27) $n(151) 1.5Mb 630ms DropTail
$ns duplex-link $n(27) $n(138) 1.5Mb 650ms DropTail
$ns duplex-link $n(27) $n(136) 1.5Mb 360ms DropTail
$ns duplex-link $n(27) $n(127) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "1250..."; flush stdout }
$ns duplex-link $n(27) $n(124) 1.5Mb 130ms DropTail
$ns duplex-link $n(27) $n(123) 1.5Mb 770ms DropTail
$ns duplex-link $n(27) $n(115) 1.5Mb 430ms DropTail
$ns duplex-link $n(27) $n(107) 1.5Mb 620ms DropTail
$ns duplex-link $n(27) $n(106) 1.5Mb 310ms DropTail
$ns duplex-link $n(27) $n(100) 1.5Mb 700ms DropTail
$ns duplex-link $n(27) $n(96) 1.5Mb 430ms DropTail
$ns duplex-link $n(27) $n(92) 1.5Mb 780ms DropTail
$ns duplex-link $n(27) $n(90) 1.5Mb 620ms DropTail
$ns duplex-link $n(27) $n(86) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "1260..."; flush stdout }
$ns duplex-link $n(27) $n(78) 1.5Mb 470ms DropTail
$ns duplex-link $n(27) $n(74) 1.5Mb 520ms DropTail
$ns duplex-link $n(27) $n(68) 1.5Mb 70ms DropTail
$ns duplex-link $n(27) $n(66) 1.5Mb 410ms DropTail
$ns duplex-link $n(27) $n(65) 1.5Mb 640ms DropTail
$ns duplex-link $n(27) $n(56) 1.5Mb 350ms DropTail
$ns duplex-link $n(27) $n(48) 1.5Mb 620ms DropTail
$ns duplex-link $n(27) $n(45) 1.5Mb 270ms DropTail
$ns duplex-link $n(27) $n(32) 1.5Mb 830ms DropTail
$ns duplex-link $n(28) $n(248) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "1270..."; flush stdout }
$ns duplex-link $n(28) $n(244) 1.5Mb 960ms DropTail
$ns duplex-link $n(28) $n(229) 1.5Mb 640ms DropTail
$ns duplex-link $n(28) $n(218) 1.5Mb 750ms DropTail
$ns duplex-link $n(28) $n(200) 1.5Mb 830ms DropTail
$ns duplex-link $n(28) $n(190) 1.5Mb 810ms DropTail
$ns duplex-link $n(28) $n(185) 1.5Mb 350ms DropTail
$ns duplex-link $n(28) $n(178) 1.5Mb 520ms DropTail
$ns duplex-link $n(28) $n(174) 1.5Mb 710ms DropTail
$ns duplex-link $n(28) $n(167) 1.5Mb 340ms DropTail
$ns duplex-link $n(28) $n(164) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "1280..."; flush stdout }
$ns duplex-link $n(28) $n(163) 1.5Mb 480ms DropTail
$ns duplex-link $n(28) $n(161) 1.5Mb 1030ms DropTail
$ns duplex-link $n(28) $n(157) 1.5Mb 870ms DropTail
$ns duplex-link $n(28) $n(148) 1.5Mb 660ms DropTail
$ns duplex-link $n(28) $n(144) 1.5Mb 810ms DropTail
$ns duplex-link $n(28) $n(142) 1.5Mb 950ms DropTail
$ns duplex-link $n(28) $n(136) 1.5Mb 830ms DropTail
$ns duplex-link $n(28) $n(129) 1.5Mb 590ms DropTail
$ns duplex-link $n(28) $n(125) 1.5Mb 980ms DropTail
$ns duplex-link $n(28) $n(123) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "1290..."; flush stdout }
$ns duplex-link $n(28) $n(119) 1.5Mb 810ms DropTail
$ns duplex-link $n(28) $n(114) 1.5Mb 770ms DropTail
$ns duplex-link $n(28) $n(109) 1.5Mb 690ms DropTail
$ns duplex-link $n(28) $n(100) 1.5Mb 240ms DropTail
$ns duplex-link $n(28) $n(97) 1.5Mb 640ms DropTail
$ns duplex-link $n(28) $n(96) 1.5Mb 580ms DropTail
$ns duplex-link $n(28) $n(92) 1.5Mb 790ms DropTail
$ns duplex-link $n(28) $n(88) 1.5Mb 500ms DropTail
$ns duplex-link $n(28) $n(85) 1.5Mb 690ms DropTail
$ns duplex-link $n(28) $n(84) 1.5Mb 1000ms DropTail
if {$verbose} { puts -nonewline "1300..."; flush stdout }
$ns duplex-link $n(28) $n(83) 1.5Mb 370ms DropTail
$ns duplex-link $n(28) $n(82) 1.5Mb 640ms DropTail
$ns duplex-link $n(28) $n(80) 1.5Mb 490ms DropTail
$ns duplex-link $n(28) $n(78) 1.5Mb 760ms DropTail
$ns duplex-link $n(28) $n(76) 1.5Mb 700ms DropTail
$ns duplex-link $n(28) $n(74) 1.5Mb 910ms DropTail
$ns duplex-link $n(28) $n(66) 1.5Mb 580ms DropTail
$ns duplex-link $n(28) $n(65) 1.5Mb 290ms DropTail
$ns duplex-link $n(28) $n(59) 1.5Mb 400ms DropTail
$ns duplex-link $n(28) $n(55) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "1310..."; flush stdout }
$ns duplex-link $n(28) $n(49) 1.5Mb 480ms DropTail
$ns duplex-link $n(28) $n(36) 1.5Mb 240ms DropTail
$ns duplex-link $n(29) $n(246) 1.5Mb 470ms DropTail
$ns duplex-link $n(29) $n(244) 1.5Mb 170ms DropTail
$ns duplex-link $n(29) $n(237) 1.5Mb 760ms DropTail
$ns duplex-link $n(29) $n(223) 1.5Mb 670ms DropTail
$ns duplex-link $n(29) $n(218) 1.5Mb 910ms DropTail
$ns duplex-link $n(29) $n(215) 1.5Mb 910ms DropTail
$ns duplex-link $n(29) $n(213) 1.5Mb 620ms DropTail
$ns duplex-link $n(29) $n(199) 1.5Mb 980ms DropTail
if {$verbose} { puts -nonewline "1320..."; flush stdout }
$ns duplex-link $n(29) $n(198) 1.5Mb 400ms DropTail
$ns duplex-link $n(29) $n(196) 1.5Mb 150ms DropTail
$ns duplex-link $n(29) $n(195) 1.5Mb 860ms DropTail
$ns duplex-link $n(29) $n(192) 1.5Mb 480ms DropTail
$ns duplex-link $n(29) $n(190) 1.5Mb 200ms DropTail
$ns duplex-link $n(29) $n(179) 1.5Mb 830ms DropTail
$ns duplex-link $n(29) $n(174) 1.5Mb 270ms DropTail
$ns duplex-link $n(29) $n(170) 1.5Mb 530ms DropTail
$ns duplex-link $n(29) $n(168) 1.5Mb 290ms DropTail
$ns duplex-link $n(29) $n(158) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "1330..."; flush stdout }
$ns duplex-link $n(29) $n(154) 1.5Mb 780ms DropTail
$ns duplex-link $n(29) $n(149) 1.5Mb 120ms DropTail
$ns duplex-link $n(29) $n(148) 1.5Mb 290ms DropTail
$ns duplex-link $n(29) $n(145) 1.5Mb 690ms DropTail
$ns duplex-link $n(29) $n(138) 1.5Mb 140ms DropTail
$ns duplex-link $n(29) $n(130) 1.5Mb 360ms DropTail
$ns duplex-link $n(29) $n(126) 1.5Mb 760ms DropTail
$ns duplex-link $n(29) $n(125) 1.5Mb 480ms DropTail
$ns duplex-link $n(29) $n(120) 1.5Mb 230ms DropTail
$ns duplex-link $n(29) $n(118) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "1340..."; flush stdout }
$ns duplex-link $n(29) $n(114) 1.5Mb 870ms DropTail
$ns duplex-link $n(29) $n(112) 1.5Mb 530ms DropTail
$ns duplex-link $n(29) $n(109) 1.5Mb 600ms DropTail
$ns duplex-link $n(29) $n(105) 1.5Mb 50ms DropTail
$ns duplex-link $n(29) $n(90) 1.5Mb 290ms DropTail
$ns duplex-link $n(29) $n(83) 1.5Mb 790ms DropTail
$ns duplex-link $n(29) $n(77) 1.5Mb 550ms DropTail
$ns duplex-link $n(29) $n(76) 1.5Mb 770ms DropTail
$ns duplex-link $n(29) $n(74) 1.5Mb 120ms DropTail
$ns duplex-link $n(29) $n(73) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "1350..."; flush stdout }
$ns duplex-link $n(29) $n(71) 1.5Mb 610ms DropTail
$ns duplex-link $n(29) $n(69) 1.5Mb 450ms DropTail
$ns duplex-link $n(29) $n(68) 1.5Mb 610ms DropTail
$ns duplex-link $n(29) $n(63) 1.5Mb 850ms DropTail
$ns duplex-link $n(29) $n(62) 1.5Mb 500ms DropTail
$ns duplex-link $n(29) $n(60) 1.5Mb 600ms DropTail
$ns duplex-link $n(29) $n(59) 1.5Mb 440ms DropTail
$ns duplex-link $n(29) $n(56) 1.5Mb 620ms DropTail
$ns duplex-link $n(29) $n(54) 1.5Mb 230ms DropTail
$ns duplex-link $n(29) $n(53) 1.5Mb 900ms DropTail
if {$verbose} { puts -nonewline "1360..."; flush stdout }
$ns duplex-link $n(29) $n(44) 1.5Mb 320ms DropTail
$ns duplex-link $n(29) $n(42) 1.5Mb 540ms DropTail
$ns duplex-link $n(29) $n(35) 1.5Mb 860ms DropTail
$ns duplex-link $n(29) $n(32) 1.5Mb 850ms DropTail
$ns duplex-link $n(30) $n(249) 1.5Mb 790ms DropTail
$ns duplex-link $n(30) $n(247) 1.5Mb 290ms DropTail
$ns duplex-link $n(30) $n(235) 1.5Mb 990ms DropTail
$ns duplex-link $n(30) $n(232) 1.5Mb 860ms DropTail
$ns duplex-link $n(30) $n(228) 1.5Mb 980ms DropTail
$ns duplex-link $n(30) $n(224) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "1370..."; flush stdout }
$ns duplex-link $n(30) $n(223) 1.5Mb 550ms DropTail
$ns duplex-link $n(30) $n(216) 1.5Mb 1230ms DropTail
$ns duplex-link $n(30) $n(206) 1.5Mb 1040ms DropTail
$ns duplex-link $n(30) $n(204) 1.5Mb 270ms DropTail
$ns duplex-link $n(30) $n(197) 1.5Mb 780ms DropTail
$ns duplex-link $n(30) $n(193) 1.5Mb 990ms DropTail
$ns duplex-link $n(30) $n(184) 1.5Mb 340ms DropTail
$ns duplex-link $n(30) $n(181) 1.5Mb 1030ms DropTail
$ns duplex-link $n(30) $n(180) 1.5Mb 880ms DropTail
$ns duplex-link $n(30) $n(168) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "1380..."; flush stdout }
$ns duplex-link $n(30) $n(163) 1.5Mb 650ms DropTail
$ns duplex-link $n(30) $n(162) 1.5Mb 420ms DropTail
$ns duplex-link $n(30) $n(152) 1.5Mb 720ms DropTail
$ns duplex-link $n(30) $n(150) 1.5Mb 1080ms DropTail
$ns duplex-link $n(30) $n(149) 1.5Mb 550ms DropTail
$ns duplex-link $n(30) $n(147) 1.5Mb 670ms DropTail
$ns duplex-link $n(30) $n(145) 1.5Mb 580ms DropTail
$ns duplex-link $n(30) $n(144) 1.5Mb 780ms DropTail
$ns duplex-link $n(30) $n(140) 1.5Mb 970ms DropTail
$ns duplex-link $n(30) $n(139) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "1390..."; flush stdout }
$ns duplex-link $n(30) $n(136) 1.5Mb 300ms DropTail
$ns duplex-link $n(30) $n(135) 1.5Mb 230ms DropTail
$ns duplex-link $n(30) $n(131) 1.5Mb 1000ms DropTail
$ns duplex-link $n(30) $n(130) 1.5Mb 150ms DropTail
$ns duplex-link $n(30) $n(123) 1.5Mb 810ms DropTail
$ns duplex-link $n(30) $n(120) 1.5Mb 630ms DropTail
$ns duplex-link $n(30) $n(113) 1.5Mb 1000ms DropTail
$ns duplex-link $n(30) $n(109) 1.5Mb 600ms DropTail
$ns duplex-link $n(30) $n(107) 1.5Mb 720ms DropTail
$ns duplex-link $n(30) $n(100) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "1400..."; flush stdout }
$ns duplex-link $n(30) $n(94) 1.5Mb 570ms DropTail
$ns duplex-link $n(30) $n(84) 1.5Mb 260ms DropTail
$ns duplex-link $n(30) $n(80) 1.5Mb 700ms DropTail
$ns duplex-link $n(30) $n(78) 1.5Mb 870ms DropTail
$ns duplex-link $n(30) $n(73) 1.5Mb 850ms DropTail
$ns duplex-link $n(30) $n(67) 1.5Mb 200ms DropTail
$ns duplex-link $n(30) $n(64) 1.5Mb 900ms DropTail
$ns duplex-link $n(30) $n(61) 1.5Mb 320ms DropTail
$ns duplex-link $n(30) $n(59) 1.5Mb 750ms DropTail
$ns duplex-link $n(30) $n(55) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "1410..."; flush stdout }
$ns duplex-link $n(30) $n(49) 1.5Mb 750ms DropTail
$ns duplex-link $n(30) $n(48) 1.5Mb 760ms DropTail
$ns duplex-link $n(30) $n(40) 1.5Mb 830ms DropTail
$ns duplex-link $n(30) $n(37) 1.5Mb 930ms DropTail
$ns duplex-link $n(30) $n(33) 1.5Mb 940ms DropTail
$ns duplex-link $n(30) $n(31) 1.5Mb 1020ms DropTail
$ns duplex-link $n(31) $n(249) 1.5Mb 650ms DropTail
$ns duplex-link $n(31) $n(247) 1.5Mb 880ms DropTail
$ns duplex-link $n(31) $n(244) 1.5Mb 850ms DropTail
$ns duplex-link $n(31) $n(240) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "1420..."; flush stdout }
$ns duplex-link $n(31) $n(229) 1.5Mb 550ms DropTail
$ns duplex-link $n(31) $n(223) 1.5Mb 750ms DropTail
$ns duplex-link $n(31) $n(217) 1.5Mb 300ms DropTail
$ns duplex-link $n(31) $n(208) 1.5Mb 700ms DropTail
$ns duplex-link $n(31) $n(205) 1.5Mb 490ms DropTail
$ns duplex-link $n(31) $n(195) 1.5Mb 660ms DropTail
$ns duplex-link $n(31) $n(194) 1.5Mb 360ms DropTail
$ns duplex-link $n(31) $n(188) 1.5Mb 350ms DropTail
$ns duplex-link $n(31) $n(187) 1.5Mb 480ms DropTail
$ns duplex-link $n(31) $n(170) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "1430..."; flush stdout }
$ns duplex-link $n(31) $n(148) 1.5Mb 560ms DropTail
$ns duplex-link $n(31) $n(145) 1.5Mb 760ms DropTail
$ns duplex-link $n(31) $n(139) 1.5Mb 350ms DropTail
$ns duplex-link $n(31) $n(126) 1.5Mb 760ms DropTail
$ns duplex-link $n(31) $n(122) 1.5Mb 200ms DropTail
$ns duplex-link $n(31) $n(120) 1.5Mb 530ms DropTail
$ns duplex-link $n(31) $n(118) 1.5Mb 720ms DropTail
$ns duplex-link $n(31) $n(115) 1.5Mb 780ms DropTail
$ns duplex-link $n(31) $n(113) 1.5Mb 120ms DropTail
$ns duplex-link $n(31) $n(108) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "1440..."; flush stdout }
$ns duplex-link $n(31) $n(100) 1.5Mb 160ms DropTail
$ns duplex-link $n(31) $n(95) 1.5Mb 700ms DropTail
$ns duplex-link $n(31) $n(94) 1.5Mb 450ms DropTail
$ns duplex-link $n(31) $n(92) 1.5Mb 710ms DropTail
$ns duplex-link $n(31) $n(85) 1.5Mb 580ms DropTail
$ns duplex-link $n(31) $n(80) 1.5Mb 400ms DropTail
$ns duplex-link $n(31) $n(79) 1.5Mb 320ms DropTail
$ns duplex-link $n(31) $n(75) 1.5Mb 550ms DropTail
$ns duplex-link $n(31) $n(66) 1.5Mb 480ms DropTail
$ns duplex-link $n(31) $n(64) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "1450..."; flush stdout }
$ns duplex-link $n(31) $n(61) 1.5Mb 780ms DropTail
$ns duplex-link $n(31) $n(52) 1.5Mb 620ms DropTail
$ns duplex-link $n(31) $n(51) 1.5Mb 920ms DropTail
$ns duplex-link $n(31) $n(41) 1.5Mb 750ms DropTail
$ns duplex-link $n(31) $n(35) 1.5Mb 460ms DropTail
$ns duplex-link $n(32) $n(248) 1.5Mb 460ms DropTail
$ns duplex-link $n(32) $n(234) 1.5Mb 350ms DropTail
$ns duplex-link $n(32) $n(229) 1.5Mb 690ms DropTail
$ns duplex-link $n(32) $n(227) 1.5Mb 100ms DropTail
$ns duplex-link $n(32) $n(222) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "1460..."; flush stdout }
$ns duplex-link $n(32) $n(211) 1.5Mb 290ms DropTail
$ns duplex-link $n(32) $n(203) 1.5Mb 140ms DropTail
$ns duplex-link $n(32) $n(193) 1.5Mb 610ms DropTail
$ns duplex-link $n(32) $n(183) 1.5Mb 890ms DropTail
$ns duplex-link $n(32) $n(182) 1.5Mb 610ms DropTail
$ns duplex-link $n(32) $n(169) 1.5Mb 890ms DropTail
$ns duplex-link $n(32) $n(164) 1.5Mb 500ms DropTail
$ns duplex-link $n(32) $n(158) 1.5Mb 950ms DropTail
$ns duplex-link $n(32) $n(153) 1.5Mb 320ms DropTail
$ns duplex-link $n(32) $n(147) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "1470..."; flush stdout }
$ns duplex-link $n(32) $n(146) 1.5Mb 720ms DropTail
$ns duplex-link $n(32) $n(134) 1.5Mb 660ms DropTail
$ns duplex-link $n(32) $n(133) 1.5Mb 830ms DropTail
$ns duplex-link $n(32) $n(126) 1.5Mb 710ms DropTail
$ns duplex-link $n(32) $n(125) 1.5Mb 910ms DropTail
$ns duplex-link $n(32) $n(124) 1.5Mb 890ms DropTail
$ns duplex-link $n(32) $n(122) 1.5Mb 320ms DropTail
$ns duplex-link $n(32) $n(120) 1.5Mb 670ms DropTail
$ns duplex-link $n(32) $n(119) 1.5Mb 900ms DropTail
$ns duplex-link $n(32) $n(118) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "1480..."; flush stdout }
$ns duplex-link $n(32) $n(116) 1.5Mb 270ms DropTail
$ns duplex-link $n(32) $n(114) 1.5Mb 620ms DropTail
$ns duplex-link $n(32) $n(112) 1.5Mb 350ms DropTail
$ns duplex-link $n(32) $n(110) 1.5Mb 840ms DropTail
$ns duplex-link $n(32) $n(108) 1.5Mb 510ms DropTail
$ns duplex-link $n(32) $n(95) 1.5Mb 770ms DropTail
$ns duplex-link $n(32) $n(89) 1.5Mb 370ms DropTail
$ns duplex-link $n(32) $n(87) 1.5Mb 760ms DropTail
$ns duplex-link $n(32) $n(79) 1.5Mb 390ms DropTail
$ns duplex-link $n(32) $n(73) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "1490..."; flush stdout }
$ns duplex-link $n(32) $n(70) 1.5Mb 730ms DropTail
$ns duplex-link $n(32) $n(67) 1.5Mb 890ms DropTail
$ns duplex-link $n(32) $n(62) 1.5Mb 890ms DropTail
$ns duplex-link $n(32) $n(55) 1.5Mb 750ms DropTail
$ns duplex-link $n(32) $n(54) 1.5Mb 620ms DropTail
$ns duplex-link $n(32) $n(50) 1.5Mb 740ms DropTail
$ns duplex-link $n(32) $n(48) 1.5Mb 390ms DropTail
$ns duplex-link $n(32) $n(44) 1.5Mb 800ms DropTail
$ns duplex-link $n(32) $n(39) 1.5Mb 510ms DropTail
$ns duplex-link $n(32) $n(35) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "1500..."; flush stdout }
$ns duplex-link $n(33) $n(247) 1.5Mb 880ms DropTail
$ns duplex-link $n(33) $n(238) 1.5Mb 680ms DropTail
$ns duplex-link $n(33) $n(226) 1.5Mb 550ms DropTail
$ns duplex-link $n(33) $n(221) 1.5Mb 690ms DropTail
$ns duplex-link $n(33) $n(220) 1.5Mb 10ms DropTail
$ns duplex-link $n(33) $n(217) 1.5Mb 120ms DropTail
$ns duplex-link $n(33) $n(214) 1.5Mb 730ms DropTail
$ns duplex-link $n(33) $n(210) 1.5Mb 820ms DropTail
$ns duplex-link $n(33) $n(205) 1.5Mb 500ms DropTail
$ns duplex-link $n(33) $n(192) 1.5Mb 920ms DropTail
if {$verbose} { puts -nonewline "1510..."; flush stdout }
$ns duplex-link $n(33) $n(190) 1.5Mb 510ms DropTail
$ns duplex-link $n(33) $n(180) 1.5Mb 170ms DropTail
$ns duplex-link $n(33) $n(170) 1.5Mb 710ms DropTail
$ns duplex-link $n(33) $n(167) 1.5Mb 570ms DropTail
$ns duplex-link $n(33) $n(166) 1.5Mb 920ms DropTail
$ns duplex-link $n(33) $n(164) 1.5Mb 730ms DropTail
$ns duplex-link $n(33) $n(160) 1.5Mb 710ms DropTail
$ns duplex-link $n(33) $n(159) 1.5Mb 840ms DropTail
$ns duplex-link $n(33) $n(157) 1.5Mb 720ms DropTail
$ns duplex-link $n(33) $n(156) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "1520..."; flush stdout }
$ns duplex-link $n(33) $n(151) 1.5Mb 280ms DropTail
$ns duplex-link $n(33) $n(140) 1.5Mb 400ms DropTail
$ns duplex-link $n(33) $n(139) 1.5Mb 210ms DropTail
$ns duplex-link $n(33) $n(116) 1.5Mb 370ms DropTail
$ns duplex-link $n(33) $n(104) 1.5Mb 480ms DropTail
$ns duplex-link $n(33) $n(99) 1.5Mb 510ms DropTail
$ns duplex-link $n(33) $n(87) 1.5Mb 720ms DropTail
$ns duplex-link $n(33) $n(83) 1.5Mb 530ms DropTail
$ns duplex-link $n(33) $n(76) 1.5Mb 770ms DropTail
$ns duplex-link $n(33) $n(75) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "1530..."; flush stdout }
$ns duplex-link $n(33) $n(71) 1.5Mb 540ms DropTail
$ns duplex-link $n(33) $n(67) 1.5Mb 770ms DropTail
$ns duplex-link $n(33) $n(64) 1.5Mb 90ms DropTail
$ns duplex-link $n(33) $n(60) 1.5Mb 270ms DropTail
$ns duplex-link $n(33) $n(57) 1.5Mb 450ms DropTail
$ns duplex-link $n(33) $n(44) 1.5Mb 690ms DropTail
$ns duplex-link $n(33) $n(35) 1.5Mb 670ms DropTail
$ns duplex-link $n(34) $n(248) 1.5Mb 720ms DropTail
$ns duplex-link $n(34) $n(242) 1.5Mb 1010ms DropTail
$ns duplex-link $n(34) $n(238) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "1540..."; flush stdout }
$ns duplex-link $n(34) $n(231) 1.5Mb 680ms DropTail
$ns duplex-link $n(34) $n(230) 1.5Mb 410ms DropTail
$ns duplex-link $n(34) $n(220) 1.5Mb 790ms DropTail
$ns duplex-link $n(34) $n(218) 1.5Mb 110ms DropTail
$ns duplex-link $n(34) $n(217) 1.5Mb 710ms DropTail
$ns duplex-link $n(34) $n(215) 1.5Mb 230ms DropTail
$ns duplex-link $n(34) $n(209) 1.5Mb 790ms DropTail
$ns duplex-link $n(34) $n(203) 1.5Mb 680ms DropTail
$ns duplex-link $n(34) $n(188) 1.5Mb 760ms DropTail
$ns duplex-link $n(34) $n(182) 1.5Mb 90ms DropTail
if {$verbose} { puts -nonewline "1550..."; flush stdout }
$ns duplex-link $n(34) $n(178) 1.5Mb 470ms DropTail
$ns duplex-link $n(34) $n(176) 1.5Mb 640ms DropTail
$ns duplex-link $n(34) $n(171) 1.5Mb 660ms DropTail
$ns duplex-link $n(34) $n(168) 1.5Mb 720ms DropTail
$ns duplex-link $n(34) $n(166) 1.5Mb 140ms DropTail
$ns duplex-link $n(34) $n(147) 1.5Mb 620ms DropTail
$ns duplex-link $n(34) $n(143) 1.5Mb 40ms DropTail
$ns duplex-link $n(34) $n(141) 1.5Mb 700ms DropTail
$ns duplex-link $n(34) $n(124) 1.5Mb 520ms DropTail
$ns duplex-link $n(34) $n(121) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "1560..."; flush stdout }
$ns duplex-link $n(34) $n(118) 1.5Mb 700ms DropTail
$ns duplex-link $n(34) $n(117) 1.5Mb 550ms DropTail
$ns duplex-link $n(34) $n(115) 1.5Mb 710ms DropTail
$ns duplex-link $n(34) $n(111) 1.5Mb 770ms DropTail
$ns duplex-link $n(34) $n(106) 1.5Mb 260ms DropTail
$ns duplex-link $n(34) $n(102) 1.5Mb 430ms DropTail
$ns duplex-link $n(34) $n(98) 1.5Mb 700ms DropTail
$ns duplex-link $n(34) $n(97) 1.5Mb 310ms DropTail
$ns duplex-link $n(34) $n(94) 1.5Mb 500ms DropTail
$ns duplex-link $n(34) $n(89) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "1570..."; flush stdout }
$ns duplex-link $n(34) $n(86) 1.5Mb 160ms DropTail
$ns duplex-link $n(34) $n(84) 1.5Mb 560ms DropTail
$ns duplex-link $n(34) $n(82) 1.5Mb 150ms DropTail
$ns duplex-link $n(34) $n(77) 1.5Mb 390ms DropTail
$ns duplex-link $n(34) $n(76) 1.5Mb 40ms DropTail
$ns duplex-link $n(34) $n(73) 1.5Mb 350ms DropTail
$ns duplex-link $n(34) $n(63) 1.5Mb 60ms DropTail
$ns duplex-link $n(34) $n(42) 1.5Mb 670ms DropTail
$ns duplex-link $n(35) $n(244) 1.5Mb 900ms DropTail
$ns duplex-link $n(35) $n(242) 1.5Mb 960ms DropTail
if {$verbose} { puts -nonewline "1580..."; flush stdout }
$ns duplex-link $n(35) $n(241) 1.5Mb 290ms DropTail
$ns duplex-link $n(35) $n(238) 1.5Mb 420ms DropTail
$ns duplex-link $n(35) $n(237) 1.5Mb 460ms DropTail
$ns duplex-link $n(35) $n(233) 1.5Mb 430ms DropTail
$ns duplex-link $n(35) $n(230) 1.5Mb 200ms DropTail
$ns duplex-link $n(35) $n(225) 1.5Mb 910ms DropTail
$ns duplex-link $n(35) $n(213) 1.5Mb 330ms DropTail
$ns duplex-link $n(35) $n(201) 1.5Mb 910ms DropTail
$ns duplex-link $n(35) $n(192) 1.5Mb 820ms DropTail
$ns duplex-link $n(35) $n(180) 1.5Mb 800ms DropTail
if {$verbose} { puts -nonewline "1590..."; flush stdout }
$ns duplex-link $n(35) $n(172) 1.5Mb 800ms DropTail
$ns duplex-link $n(35) $n(170) 1.5Mb 470ms DropTail
$ns duplex-link $n(35) $n(168) 1.5Mb 840ms DropTail
$ns duplex-link $n(35) $n(167) 1.5Mb 200ms DropTail
$ns duplex-link $n(35) $n(164) 1.5Mb 190ms DropTail
$ns duplex-link $n(35) $n(163) 1.5Mb 480ms DropTail
$ns duplex-link $n(35) $n(158) 1.5Mb 790ms DropTail
$ns duplex-link $n(35) $n(156) 1.5Mb 680ms DropTail
$ns duplex-link $n(35) $n(152) 1.5Mb 370ms DropTail
$ns duplex-link $n(35) $n(146) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "1600..."; flush stdout }
$ns duplex-link $n(35) $n(143) 1.5Mb 250ms DropTail
$ns duplex-link $n(35) $n(138) 1.5Mb 820ms DropTail
$ns duplex-link $n(35) $n(137) 1.5Mb 800ms DropTail
$ns duplex-link $n(35) $n(136) 1.5Mb 720ms DropTail
$ns duplex-link $n(35) $n(129) 1.5Mb 470ms DropTail
$ns duplex-link $n(35) $n(128) 1.5Mb 680ms DropTail
$ns duplex-link $n(35) $n(116) 1.5Mb 620ms DropTail
$ns duplex-link $n(35) $n(115) 1.5Mb 800ms DropTail
$ns duplex-link $n(35) $n(113) 1.5Mb 340ms DropTail
$ns duplex-link $n(35) $n(110) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "1610..."; flush stdout }
$ns duplex-link $n(35) $n(107) 1.5Mb 560ms DropTail
$ns duplex-link $n(35) $n(106) 1.5Mb 340ms DropTail
$ns duplex-link $n(35) $n(102) 1.5Mb 430ms DropTail
$ns duplex-link $n(35) $n(98) 1.5Mb 780ms DropTail
$ns duplex-link $n(35) $n(94) 1.5Mb 520ms DropTail
$ns duplex-link $n(35) $n(89) 1.5Mb 640ms DropTail
$ns duplex-link $n(35) $n(88) 1.5Mb 470ms DropTail
$ns duplex-link $n(35) $n(86) 1.5Mb 390ms DropTail
$ns duplex-link $n(35) $n(85) 1.5Mb 570ms DropTail
$ns duplex-link $n(35) $n(84) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "1620..."; flush stdout }
$ns duplex-link $n(35) $n(73) 1.5Mb 240ms DropTail
$ns duplex-link $n(35) $n(68) 1.5Mb 530ms DropTail
$ns duplex-link $n(35) $n(64) 1.5Mb 730ms DropTail
$ns duplex-link $n(35) $n(58) 1.5Mb 690ms DropTail
$ns duplex-link $n(35) $n(57) 1.5Mb 270ms DropTail
$ns duplex-link $n(35) $n(47) 1.5Mb 800ms DropTail
$ns duplex-link $n(35) $n(41) 1.5Mb 380ms DropTail
$ns duplex-link $n(36) $n(245) 1.5Mb 230ms DropTail
$ns duplex-link $n(36) $n(244) 1.5Mb 720ms DropTail
$ns duplex-link $n(36) $n(241) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "1630..."; flush stdout }
$ns duplex-link $n(36) $n(229) 1.5Mb 410ms DropTail
$ns duplex-link $n(36) $n(214) 1.5Mb 700ms DropTail
$ns duplex-link $n(36) $n(212) 1.5Mb 500ms DropTail
$ns duplex-link $n(36) $n(211) 1.5Mb 10ms DropTail
$ns duplex-link $n(36) $n(204) 1.5Mb 770ms DropTail
$ns duplex-link $n(36) $n(193) 1.5Mb 750ms DropTail
$ns duplex-link $n(36) $n(173) 1.5Mb 60ms DropTail
$ns duplex-link $n(36) $n(149) 1.5Mb 570ms DropTail
$ns duplex-link $n(36) $n(142) 1.5Mb 710ms DropTail
$ns duplex-link $n(36) $n(123) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "1640..."; flush stdout }
$ns duplex-link $n(36) $n(120) 1.5Mb 390ms DropTail
$ns duplex-link $n(36) $n(118) 1.5Mb 580ms DropTail
$ns duplex-link $n(36) $n(117) 1.5Mb 90ms DropTail
$ns duplex-link $n(36) $n(115) 1.5Mb 640ms DropTail
$ns duplex-link $n(36) $n(111) 1.5Mb 690ms DropTail
$ns duplex-link $n(36) $n(109) 1.5Mb 530ms DropTail
$ns duplex-link $n(36) $n(108) 1.5Mb 330ms DropTail
$ns duplex-link $n(36) $n(107) 1.5Mb 200ms DropTail
$ns duplex-link $n(36) $n(103) 1.5Mb 920ms DropTail
$ns duplex-link $n(36) $n(91) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "1650..."; flush stdout }
$ns duplex-link $n(36) $n(88) 1.5Mb 270ms DropTail
$ns duplex-link $n(36) $n(86) 1.5Mb 720ms DropTail
$ns duplex-link $n(36) $n(84) 1.5Mb 790ms DropTail
$ns duplex-link $n(36) $n(79) 1.5Mb 220ms DropTail
$ns duplex-link $n(36) $n(65) 1.5Mb 220ms DropTail
$ns duplex-link $n(36) $n(63) 1.5Mb 670ms DropTail
$ns duplex-link $n(36) $n(53) 1.5Mb 320ms DropTail
$ns duplex-link $n(36) $n(50) 1.5Mb 460ms DropTail
$ns duplex-link $n(36) $n(48) 1.5Mb 140ms DropTail
$ns duplex-link $n(36) $n(47) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "1660..."; flush stdout }
$ns duplex-link $n(36) $n(40) 1.5Mb 130ms DropTail
$ns duplex-link $n(36) $n(39) 1.5Mb 230ms DropTail
$ns duplex-link $n(37) $n(245) 1.5Mb 480ms DropTail
$ns duplex-link $n(37) $n(242) 1.5Mb 980ms DropTail
$ns duplex-link $n(37) $n(240) 1.5Mb 440ms DropTail
$ns duplex-link $n(37) $n(234) 1.5Mb 280ms DropTail
$ns duplex-link $n(37) $n(233) 1.5Mb 460ms DropTail
$ns duplex-link $n(37) $n(232) 1.5Mb 220ms DropTail
$ns duplex-link $n(37) $n(231) 1.5Mb 790ms DropTail
$ns duplex-link $n(37) $n(223) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "1670..."; flush stdout }
$ns duplex-link $n(37) $n(218) 1.5Mb 200ms DropTail
$ns duplex-link $n(37) $n(208) 1.5Mb 690ms DropTail
$ns duplex-link $n(37) $n(205) 1.5Mb 440ms DropTail
$ns duplex-link $n(37) $n(203) 1.5Mb 530ms DropTail
$ns duplex-link $n(37) $n(199) 1.5Mb 270ms DropTail
$ns duplex-link $n(37) $n(198) 1.5Mb 1040ms DropTail
$ns duplex-link $n(37) $n(189) 1.5Mb 550ms DropTail
$ns duplex-link $n(37) $n(187) 1.5Mb 190ms DropTail
$ns duplex-link $n(37) $n(165) 1.5Mb 940ms DropTail
$ns duplex-link $n(37) $n(156) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "1680..."; flush stdout }
$ns duplex-link $n(37) $n(155) 1.5Mb 640ms DropTail
$ns duplex-link $n(37) $n(153) 1.5Mb 660ms DropTail
$ns duplex-link $n(37) $n(152) 1.5Mb 380ms DropTail
$ns duplex-link $n(37) $n(146) 1.5Mb 560ms DropTail
$ns duplex-link $n(37) $n(144) 1.5Mb 290ms DropTail
$ns duplex-link $n(37) $n(135) 1.5Mb 710ms DropTail
$ns duplex-link $n(37) $n(133) 1.5Mb 910ms DropTail
$ns duplex-link $n(37) $n(131) 1.5Mb 140ms DropTail
$ns duplex-link $n(37) $n(117) 1.5Mb 490ms DropTail
$ns duplex-link $n(37) $n(116) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "1690..."; flush stdout }
$ns duplex-link $n(37) $n(115) 1.5Mb 800ms DropTail
$ns duplex-link $n(37) $n(113) 1.5Mb 380ms DropTail
$ns duplex-link $n(37) $n(103) 1.5Mb 900ms DropTail
$ns duplex-link $n(37) $n(98) 1.5Mb 770ms DropTail
$ns duplex-link $n(37) $n(90) 1.5Mb 680ms DropTail
$ns duplex-link $n(37) $n(83) 1.5Mb 180ms DropTail
$ns duplex-link $n(37) $n(82) 1.5Mb 90ms DropTail
$ns duplex-link $n(37) $n(81) 1.5Mb 520ms DropTail
$ns duplex-link $n(37) $n(76) 1.5Mb 210ms DropTail
$ns duplex-link $n(37) $n(75) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "1700..."; flush stdout }
$ns duplex-link $n(37) $n(73) 1.5Mb 260ms DropTail
$ns duplex-link $n(37) $n(71) 1.5Mb 250ms DropTail
$ns duplex-link $n(37) $n(68) 1.5Mb 510ms DropTail
$ns duplex-link $n(37) $n(64) 1.5Mb 760ms DropTail
$ns duplex-link $n(37) $n(60) 1.5Mb 430ms DropTail
$ns duplex-link $n(37) $n(51) 1.5Mb 880ms DropTail
$ns duplex-link $n(37) $n(46) 1.5Mb 350ms DropTail
$ns duplex-link $n(37) $n(42) 1.5Mb 830ms DropTail
$ns duplex-link $n(38) $n(235) 1.5Mb 490ms DropTail
$ns duplex-link $n(38) $n(228) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "1710..."; flush stdout }
$ns duplex-link $n(38) $n(226) 1.5Mb 1020ms DropTail
$ns duplex-link $n(38) $n(223) 1.5Mb 270ms DropTail
$ns duplex-link $n(38) $n(214) 1.5Mb 720ms DropTail
$ns duplex-link $n(38) $n(213) 1.5Mb 170ms DropTail
$ns duplex-link $n(38) $n(211) 1.5Mb 570ms DropTail
$ns duplex-link $n(38) $n(207) 1.5Mb 520ms DropTail
$ns duplex-link $n(38) $n(206) 1.5Mb 340ms DropTail
$ns duplex-link $n(38) $n(203) 1.5Mb 660ms DropTail
$ns duplex-link $n(38) $n(194) 1.5Mb 790ms DropTail
$ns duplex-link $n(38) $n(190) 1.5Mb 920ms DropTail
if {$verbose} { puts -nonewline "1720..."; flush stdout }
$ns duplex-link $n(38) $n(188) 1.5Mb 720ms DropTail
$ns duplex-link $n(38) $n(178) 1.5Mb 440ms DropTail
$ns duplex-link $n(38) $n(156) 1.5Mb 560ms DropTail
$ns duplex-link $n(38) $n(153) 1.5Mb 740ms DropTail
$ns duplex-link $n(38) $n(151) 1.5Mb 470ms DropTail
$ns duplex-link $n(38) $n(143) 1.5Mb 80ms DropTail
$ns duplex-link $n(38) $n(141) 1.5Mb 690ms DropTail
$ns duplex-link $n(38) $n(135) 1.5Mb 570ms DropTail
$ns duplex-link $n(38) $n(129) 1.5Mb 400ms DropTail
$ns duplex-link $n(38) $n(124) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "1730..."; flush stdout }
$ns duplex-link $n(38) $n(115) 1.5Mb 690ms DropTail
$ns duplex-link $n(38) $n(112) 1.5Mb 380ms DropTail
$ns duplex-link $n(38) $n(110) 1.5Mb 680ms DropTail
$ns duplex-link $n(38) $n(106) 1.5Mb 230ms DropTail
$ns duplex-link $n(38) $n(102) 1.5Mb 400ms DropTail
$ns duplex-link $n(38) $n(101) 1.5Mb 630ms DropTail
$ns duplex-link $n(38) $n(86) 1.5Mb 180ms DropTail
$ns duplex-link $n(38) $n(78) 1.5Mb 130ms DropTail
$ns duplex-link $n(38) $n(77) 1.5Mb 390ms DropTail
$ns duplex-link $n(38) $n(75) 1.5Mb 50ms DropTail
if {$verbose} { puts -nonewline "1740..."; flush stdout }
$ns duplex-link $n(38) $n(70) 1.5Mb 260ms DropTail
$ns duplex-link $n(38) $n(67) 1.5Mb 620ms DropTail
$ns duplex-link $n(38) $n(61) 1.5Mb 470ms DropTail
$ns duplex-link $n(38) $n(56) 1.5Mb 170ms DropTail
$ns duplex-link $n(38) $n(51) 1.5Mb 750ms DropTail
$ns duplex-link $n(38) $n(42) 1.5Mb 670ms DropTail
$ns duplex-link $n(38) $n(40) 1.5Mb 440ms DropTail
$ns duplex-link $n(39) $n(248) 1.5Mb 100ms DropTail
$ns duplex-link $n(39) $n(244) 1.5Mb 520ms DropTail
$ns duplex-link $n(39) $n(241) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "1750..."; flush stdout }
$ns duplex-link $n(39) $n(237) 1.5Mb 390ms DropTail
$ns duplex-link $n(39) $n(225) 1.5Mb 760ms DropTail
$ns duplex-link $n(39) $n(223) 1.5Mb 690ms DropTail
$ns duplex-link $n(39) $n(212) 1.5Mb 530ms DropTail
$ns duplex-link $n(39) $n(209) 1.5Mb 680ms DropTail
$ns duplex-link $n(39) $n(186) 1.5Mb 370ms DropTail
$ns duplex-link $n(39) $n(185) 1.5Mb 120ms DropTail
$ns duplex-link $n(39) $n(184) 1.5Mb 410ms DropTail
$ns duplex-link $n(39) $n(178) 1.5Mb 250ms DropTail
$ns duplex-link $n(39) $n(173) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "1760..."; flush stdout }
$ns duplex-link $n(39) $n(170) 1.5Mb 560ms DropTail
$ns duplex-link $n(39) $n(157) 1.5Mb 530ms DropTail
$ns duplex-link $n(39) $n(155) 1.5Mb 360ms DropTail
$ns duplex-link $n(39) $n(145) 1.5Mb 700ms DropTail
$ns duplex-link $n(39) $n(141) 1.5Mb 610ms DropTail
$ns duplex-link $n(39) $n(139) 1.5Mb 40ms DropTail
$ns duplex-link $n(39) $n(137) 1.5Mb 260ms DropTail
$ns duplex-link $n(39) $n(136) 1.5Mb 450ms DropTail
$ns duplex-link $n(39) $n(132) 1.5Mb 290ms DropTail
$ns duplex-link $n(39) $n(126) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "1770..."; flush stdout }
$ns duplex-link $n(39) $n(125) 1.5Mb 670ms DropTail
$ns duplex-link $n(39) $n(120) 1.5Mb 160ms DropTail
$ns duplex-link $n(39) $n(97) 1.5Mb 450ms DropTail
$ns duplex-link $n(39) $n(92) 1.5Mb 340ms DropTail
$ns duplex-link $n(39) $n(90) 1.5Mb 100ms DropTail
$ns duplex-link $n(39) $n(89) 1.5Mb 250ms DropTail
$ns duplex-link $n(39) $n(88) 1.5Mb 230ms DropTail
$ns duplex-link $n(39) $n(76) 1.5Mb 680ms DropTail
$ns duplex-link $n(39) $n(74) 1.5Mb 480ms DropTail
$ns duplex-link $n(39) $n(73) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "1780..."; flush stdout }
$ns duplex-link $n(39) $n(67) 1.5Mb 570ms DropTail
$ns duplex-link $n(39) $n(60) 1.5Mb 280ms DropTail
$ns duplex-link $n(39) $n(57) 1.5Mb 500ms DropTail
$ns duplex-link $n(39) $n(54) 1.5Mb 180ms DropTail
$ns duplex-link $n(39) $n(45) 1.5Mb 590ms DropTail
$ns duplex-link $n(40) $n(244) 1.5Mb 680ms DropTail
$ns duplex-link $n(40) $n(241) 1.5Mb 200ms DropTail
$ns duplex-link $n(40) $n(238) 1.5Mb 430ms DropTail
$ns duplex-link $n(40) $n(236) 1.5Mb 250ms DropTail
$ns duplex-link $n(40) $n(235) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "1790..."; flush stdout }
$ns duplex-link $n(40) $n(229) 1.5Mb 450ms DropTail
$ns duplex-link $n(40) $n(223) 1.5Mb 570ms DropTail
$ns duplex-link $n(40) $n(222) 1.5Mb 300ms DropTail
$ns duplex-link $n(40) $n(220) 1.5Mb 310ms DropTail
$ns duplex-link $n(40) $n(215) 1.5Mb 420ms DropTail
$ns duplex-link $n(40) $n(210) 1.5Mb 630ms DropTail
$ns duplex-link $n(40) $n(205) 1.5Mb 290ms DropTail
$ns duplex-link $n(40) $n(203) 1.5Mb 330ms DropTail
$ns duplex-link $n(40) $n(202) 1.5Mb 430ms DropTail
$ns duplex-link $n(40) $n(199) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "1800..."; flush stdout }
$ns duplex-link $n(40) $n(195) 1.5Mb 520ms DropTail
$ns duplex-link $n(40) $n(191) 1.5Mb 490ms DropTail
$ns duplex-link $n(40) $n(189) 1.5Mb 220ms DropTail
$ns duplex-link $n(40) $n(187) 1.5Mb 310ms DropTail
$ns duplex-link $n(40) $n(185) 1.5Mb 180ms DropTail
$ns duplex-link $n(40) $n(179) 1.5Mb 530ms DropTail
$ns duplex-link $n(40) $n(175) 1.5Mb 510ms DropTail
$ns duplex-link $n(40) $n(174) 1.5Mb 550ms DropTail
$ns duplex-link $n(40) $n(165) 1.5Mb 860ms DropTail
$ns duplex-link $n(40) $n(163) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "1810..."; flush stdout }
$ns duplex-link $n(40) $n(159) 1.5Mb 560ms DropTail
$ns duplex-link $n(40) $n(158) 1.5Mb 710ms DropTail
$ns duplex-link $n(40) $n(150) 1.5Mb 250ms DropTail
$ns duplex-link $n(40) $n(137) 1.5Mb 490ms DropTail
$ns duplex-link $n(40) $n(136) 1.5Mb 540ms DropTail
$ns duplex-link $n(40) $n(127) 1.5Mb 520ms DropTail
$ns duplex-link $n(40) $n(120) 1.5Mb 420ms DropTail
$ns duplex-link $n(40) $n(113) 1.5Mb 180ms DropTail
$ns duplex-link $n(40) $n(112) 1.5Mb 100ms DropTail
$ns duplex-link $n(40) $n(110) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "1820..."; flush stdout }
$ns duplex-link $n(40) $n(108) 1.5Mb 250ms DropTail
$ns duplex-link $n(40) $n(107) 1.5Mb 210ms DropTail
$ns duplex-link $n(40) $n(101) 1.5Mb 190ms DropTail
$ns duplex-link $n(40) $n(97) 1.5Mb 340ms DropTail
$ns duplex-link $n(40) $n(95) 1.5Mb 510ms DropTail
$ns duplex-link $n(40) $n(94) 1.5Mb 260ms DropTail
$ns duplex-link $n(40) $n(73) 1.5Mb 140ms DropTail
$ns duplex-link $n(40) $n(68) 1.5Mb 590ms DropTail
$ns duplex-link $n(40) $n(57) 1.5Mb 230ms DropTail
$ns duplex-link $n(40) $n(56) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "1830..."; flush stdout }
$ns duplex-link $n(40) $n(55) 1.5Mb 490ms DropTail
$ns duplex-link $n(40) $n(45) 1.5Mb 640ms DropTail
$ns duplex-link $n(40) $n(42) 1.5Mb 810ms DropTail
$ns duplex-link $n(41) $n(247) 1.5Mb 410ms DropTail
$ns duplex-link $n(41) $n(246) 1.5Mb 330ms DropTail
$ns duplex-link $n(41) $n(244) 1.5Mb 760ms DropTail
$ns duplex-link $n(41) $n(243) 1.5Mb 430ms DropTail
$ns duplex-link $n(41) $n(233) 1.5Mb 660ms DropTail
$ns duplex-link $n(41) $n(231) 1.5Mb 610ms DropTail
$ns duplex-link $n(41) $n(223) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "1840..."; flush stdout }
$ns duplex-link $n(41) $n(219) 1.5Mb 520ms DropTail
$ns duplex-link $n(41) $n(217) 1.5Mb 780ms DropTail
$ns duplex-link $n(41) $n(210) 1.5Mb 410ms DropTail
$ns duplex-link $n(41) $n(208) 1.5Mb 570ms DropTail
$ns duplex-link $n(41) $n(198) 1.5Mb 1090ms DropTail
$ns duplex-link $n(41) $n(196) 1.5Mb 730ms DropTail
$ns duplex-link $n(41) $n(181) 1.5Mb 940ms DropTail
$ns duplex-link $n(41) $n(178) 1.5Mb 510ms DropTail
$ns duplex-link $n(41) $n(175) 1.5Mb 760ms DropTail
$ns duplex-link $n(41) $n(170) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "1850..."; flush stdout }
$ns duplex-link $n(41) $n(169) 1.5Mb 340ms DropTail
$ns duplex-link $n(41) $n(160) 1.5Mb 310ms DropTail
$ns duplex-link $n(41) $n(159) 1.5Mb 80ms DropTail
$ns duplex-link $n(41) $n(158) 1.5Mb 530ms DropTail
$ns duplex-link $n(41) $n(155) 1.5Mb 550ms DropTail
$ns duplex-link $n(41) $n(151) 1.5Mb 600ms DropTail
$ns duplex-link $n(41) $n(147) 1.5Mb 670ms DropTail
$ns duplex-link $n(41) $n(124) 1.5Mb 410ms DropTail
$ns duplex-link $n(41) $n(107) 1.5Mb 660ms DropTail
$ns duplex-link $n(41) $n(98) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "1860..."; flush stdout }
$ns duplex-link $n(41) $n(96) 1.5Mb 520ms DropTail
$ns duplex-link $n(41) $n(95) 1.5Mb 520ms DropTail
$ns duplex-link $n(41) $n(90) 1.5Mb 720ms DropTail
$ns duplex-link $n(41) $n(87) 1.5Mb 380ms DropTail
$ns duplex-link $n(41) $n(83) 1.5Mb 480ms DropTail
$ns duplex-link $n(41) $n(81) 1.5Mb 500ms DropTail
$ns duplex-link $n(41) $n(80) 1.5Mb 730ms DropTail
$ns duplex-link $n(41) $n(75) 1.5Mb 230ms DropTail
$ns duplex-link $n(41) $n(68) 1.5Mb 220ms DropTail
$ns duplex-link $n(41) $n(57) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "1870..."; flush stdout }
$ns duplex-link $n(41) $n(55) 1.5Mb 520ms DropTail
$ns duplex-link $n(42) $n(246) 1.5Mb 430ms DropTail
$ns duplex-link $n(42) $n(245) 1.5Mb 1070ms DropTail
$ns duplex-link $n(42) $n(241) 1.5Mb 650ms DropTail
$ns duplex-link $n(42) $n(231) 1.5Mb 260ms DropTail
$ns duplex-link $n(42) $n(222) 1.5Mb 720ms DropTail
$ns duplex-link $n(42) $n(221) 1.5Mb 300ms DropTail
$ns duplex-link $n(42) $n(203) 1.5Mb 1140ms DropTail
$ns duplex-link $n(42) $n(190) 1.5Mb 740ms DropTail
$ns duplex-link $n(42) $n(180) 1.5Mb 940ms DropTail
if {$verbose} { puts -nonewline "1880..."; flush stdout }
$ns duplex-link $n(42) $n(162) 1.5Mb 380ms DropTail
$ns duplex-link $n(42) $n(158) 1.5Mb 110ms DropTail
$ns duplex-link $n(42) $n(149) 1.5Mb 660ms DropTail
$ns duplex-link $n(42) $n(147) 1.5Mb 700ms DropTail
$ns duplex-link $n(42) $n(146) 1.5Mb 330ms DropTail
$ns duplex-link $n(42) $n(140) 1.5Mb 920ms DropTail
$ns duplex-link $n(42) $n(139) 1.5Mb 770ms DropTail
$ns duplex-link $n(42) $n(131) 1.5Mb 910ms DropTail
$ns duplex-link $n(42) $n(112) 1.5Mb 710ms DropTail
$ns duplex-link $n(42) $n(105) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "1890..."; flush stdout }
$ns duplex-link $n(42) $n(102) 1.5Mb 610ms DropTail
$ns duplex-link $n(42) $n(99) 1.5Mb 980ms DropTail
$ns duplex-link $n(42) $n(88) 1.5Mb 620ms DropTail
$ns duplex-link $n(42) $n(77) 1.5Mb 280ms DropTail
$ns duplex-link $n(42) $n(71) 1.5Mb 640ms DropTail
$ns duplex-link $n(42) $n(69) 1.5Mb 520ms DropTail
$ns duplex-link $n(42) $n(65) 1.5Mb 850ms DropTail
$ns duplex-link $n(42) $n(64) 1.5Mb 950ms DropTail
$ns duplex-link $n(42) $n(63) 1.5Mb 680ms DropTail
$ns duplex-link $n(42) $n(62) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "1900..."; flush stdout }
$ns duplex-link $n(42) $n(57) 1.5Mb 970ms DropTail
$ns duplex-link $n(42) $n(55) 1.5Mb 350ms DropTail
$ns duplex-link $n(42) $n(50) 1.5Mb 680ms DropTail
$ns duplex-link $n(42) $n(47) 1.5Mb 730ms DropTail
$ns duplex-link $n(43) $n(248) 1.5Mb 540ms DropTail
$ns duplex-link $n(43) $n(241) 1.5Mb 210ms DropTail
$ns duplex-link $n(43) $n(239) 1.5Mb 390ms DropTail
$ns duplex-link $n(43) $n(237) 1.5Mb 370ms DropTail
$ns duplex-link $n(43) $n(234) 1.5Mb 180ms DropTail
$ns duplex-link $n(43) $n(227) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "1910..."; flush stdout }
$ns duplex-link $n(43) $n(222) 1.5Mb 550ms DropTail
$ns duplex-link $n(43) $n(220) 1.5Mb 570ms DropTail
$ns duplex-link $n(43) $n(219) 1.5Mb 210ms DropTail
$ns duplex-link $n(43) $n(215) 1.5Mb 160ms DropTail
$ns duplex-link $n(43) $n(211) 1.5Mb 380ms DropTail
$ns duplex-link $n(43) $n(209) 1.5Mb 870ms DropTail
$ns duplex-link $n(43) $n(204) 1.5Mb 680ms DropTail
$ns duplex-link $n(43) $n(203) 1.5Mb 420ms DropTail
$ns duplex-link $n(43) $n(201) 1.5Mb 870ms DropTail
$ns duplex-link $n(43) $n(199) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "1920..."; flush stdout }
$ns duplex-link $n(43) $n(197) 1.5Mb 320ms DropTail
$ns duplex-link $n(43) $n(192) 1.5Mb 790ms DropTail
$ns duplex-link $n(43) $n(187) 1.5Mb 170ms DropTail
$ns duplex-link $n(43) $n(185) 1.5Mb 450ms DropTail
$ns duplex-link $n(43) $n(184) 1.5Mb 640ms DropTail
$ns duplex-link $n(43) $n(169) 1.5Mb 640ms DropTail
$ns duplex-link $n(43) $n(165) 1.5Mb 920ms DropTail
$ns duplex-link $n(43) $n(164) 1.5Mb 220ms DropTail
$ns duplex-link $n(43) $n(160) 1.5Mb 480ms DropTail
$ns duplex-link $n(43) $n(156) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "1930..."; flush stdout }
$ns duplex-link $n(43) $n(153) 1.5Mb 530ms DropTail
$ns duplex-link $n(43) $n(143) 1.5Mb 300ms DropTail
$ns duplex-link $n(43) $n(138) 1.5Mb 720ms DropTail
$ns duplex-link $n(43) $n(134) 1.5Mb 380ms DropTail
$ns duplex-link $n(43) $n(132) 1.5Mb 410ms DropTail
$ns duplex-link $n(43) $n(123) 1.5Mb 590ms DropTail
$ns duplex-link $n(43) $n(119) 1.5Mb 940ms DropTail
$ns duplex-link $n(43) $n(113) 1.5Mb 250ms DropTail
$ns duplex-link $n(43) $n(107) 1.5Mb 450ms DropTail
$ns duplex-link $n(43) $n(106) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "1940..."; flush stdout }
$ns duplex-link $n(43) $n(105) 1.5Mb 760ms DropTail
$ns duplex-link $n(43) $n(104) 1.5Mb 360ms DropTail
$ns duplex-link $n(43) $n(103) 1.5Mb 880ms DropTail
$ns duplex-link $n(43) $n(100) 1.5Mb 200ms DropTail
$ns duplex-link $n(43) $n(95) 1.5Mb 610ms DropTail
$ns duplex-link $n(43) $n(80) 1.5Mb 540ms DropTail
$ns duplex-link $n(43) $n(77) 1.5Mb 550ms DropTail
$ns duplex-link $n(43) $n(74) 1.5Mb 800ms DropTail
$ns duplex-link $n(43) $n(73) 1.5Mb 130ms DropTail
$ns duplex-link $n(43) $n(70) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "1950..."; flush stdout }
$ns duplex-link $n(43) $n(65) 1.5Mb 170ms DropTail
$ns duplex-link $n(44) $n(249) 1.5Mb 640ms DropTail
$ns duplex-link $n(44) $n(247) 1.5Mb 210ms DropTail
$ns duplex-link $n(44) $n(238) 1.5Mb 290ms DropTail
$ns duplex-link $n(44) $n(227) 1.5Mb 770ms DropTail
$ns duplex-link $n(44) $n(226) 1.5Mb 610ms DropTail
$ns duplex-link $n(44) $n(223) 1.5Mb 370ms DropTail
$ns duplex-link $n(44) $n(217) 1.5Mb 580ms DropTail
$ns duplex-link $n(44) $n(216) 1.5Mb 950ms DropTail
$ns duplex-link $n(44) $n(212) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "1960..."; flush stdout }
$ns duplex-link $n(44) $n(211) 1.5Mb 610ms DropTail
$ns duplex-link $n(44) $n(208) 1.5Mb 90ms DropTail
$ns duplex-link $n(44) $n(205) 1.5Mb 270ms DropTail
$ns duplex-link $n(44) $n(204) 1.5Mb 190ms DropTail
$ns duplex-link $n(44) $n(200) 1.5Mb 460ms DropTail
$ns duplex-link $n(44) $n(198) 1.5Mb 690ms DropTail
$ns duplex-link $n(44) $n(192) 1.5Mb 220ms DropTail
$ns duplex-link $n(44) $n(185) 1.5Mb 550ms DropTail
$ns duplex-link $n(44) $n(183) 1.5Mb 280ms DropTail
$ns duplex-link $n(44) $n(176) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "1970..."; flush stdout }
$ns duplex-link $n(44) $n(175) 1.5Mb 330ms DropTail
$ns duplex-link $n(44) $n(174) 1.5Mb 550ms DropTail
$ns duplex-link $n(44) $n(169) 1.5Mb 270ms DropTail
$ns duplex-link $n(44) $n(168) 1.5Mb 160ms DropTail
$ns duplex-link $n(44) $n(165) 1.5Mb 310ms DropTail
$ns duplex-link $n(44) $n(161) 1.5Mb 190ms DropTail
$ns duplex-link $n(44) $n(156) 1.5Mb 50ms DropTail
$ns duplex-link $n(44) $n(152) 1.5Mb 430ms DropTail
$ns duplex-link $n(44) $n(146) 1.5Mb 110ms DropTail
$ns duplex-link $n(44) $n(143) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "1980..."; flush stdout }
$ns duplex-link $n(44) $n(142) 1.5Mb 260ms DropTail
$ns duplex-link $n(44) $n(140) 1.5Mb 680ms DropTail
$ns duplex-link $n(44) $n(125) 1.5Mb 180ms DropTail
$ns duplex-link $n(44) $n(124) 1.5Mb 180ms DropTail
$ns duplex-link $n(44) $n(119) 1.5Mb 680ms DropTail
$ns duplex-link $n(44) $n(116) 1.5Mb 960ms DropTail
$ns duplex-link $n(44) $n(112) 1.5Mb 450ms DropTail
$ns duplex-link $n(44) $n(106) 1.5Mb 340ms DropTail
$ns duplex-link $n(44) $n(81) 1.5Mb 260ms DropTail
$ns duplex-link $n(44) $n(75) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "1990..."; flush stdout }
$ns duplex-link $n(44) $n(74) 1.5Mb 250ms DropTail
$ns duplex-link $n(44) $n(73) 1.5Mb 560ms DropTail
$ns duplex-link $n(44) $n(71) 1.5Mb 440ms DropTail
$ns duplex-link $n(44) $n(63) 1.5Mb 600ms DropTail
$ns duplex-link $n(44) $n(62) 1.5Mb 190ms DropTail
$ns duplex-link $n(44) $n(61) 1.5Mb 140ms DropTail
$ns duplex-link $n(44) $n(59) 1.5Mb 480ms DropTail
$ns duplex-link $n(44) $n(55) 1.5Mb 70ms DropTail
$ns duplex-link $n(44) $n(52) 1.5Mb 450ms DropTail
$ns duplex-link $n(44) $n(51) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "2000..."; flush stdout }
$ns duplex-link $n(44) $n(49) 1.5Mb 520ms DropTail
$ns duplex-link $n(44) $n(47) 1.5Mb 460ms DropTail
$ns duplex-link $n(44) $n(46) 1.5Mb 670ms DropTail
$ns duplex-link $n(45) $n(248) 1.5Mb 680ms DropTail
$ns duplex-link $n(45) $n(245) 1.5Mb 900ms DropTail
$ns duplex-link $n(45) $n(242) 1.5Mb 770ms DropTail
$ns duplex-link $n(45) $n(236) 1.5Mb 470ms DropTail
$ns duplex-link $n(45) $n(224) 1.5Mb 570ms DropTail
$ns duplex-link $n(45) $n(222) 1.5Mb 520ms DropTail
$ns duplex-link $n(45) $n(206) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "2010..."; flush stdout }
$ns duplex-link $n(45) $n(202) 1.5Mb 590ms DropTail
$ns duplex-link $n(45) $n(194) 1.5Mb 740ms DropTail
$ns duplex-link $n(45) $n(190) 1.5Mb 550ms DropTail
$ns duplex-link $n(45) $n(189) 1.5Mb 840ms DropTail
$ns duplex-link $n(45) $n(181) 1.5Mb 870ms DropTail
$ns duplex-link $n(45) $n(180) 1.5Mb 740ms DropTail
$ns duplex-link $n(45) $n(176) 1.5Mb 400ms DropTail
$ns duplex-link $n(45) $n(169) 1.5Mb 250ms DropTail
$ns duplex-link $n(45) $n(164) 1.5Mb 610ms DropTail
$ns duplex-link $n(45) $n(158) 1.5Mb 90ms DropTail
if {$verbose} { puts -nonewline "2020..."; flush stdout }
$ns duplex-link $n(45) $n(148) 1.5Mb 280ms DropTail
$ns duplex-link $n(45) $n(147) 1.5Mb 510ms DropTail
$ns duplex-link $n(45) $n(144) 1.5Mb 610ms DropTail
$ns duplex-link $n(45) $n(128) 1.5Mb 740ms DropTail
$ns duplex-link $n(45) $n(120) 1.5Mb 500ms DropTail
$ns duplex-link $n(45) $n(116) 1.5Mb 1050ms DropTail
$ns duplex-link $n(45) $n(115) 1.5Mb 180ms DropTail
$ns duplex-link $n(45) $n(110) 1.5Mb 190ms DropTail
$ns duplex-link $n(45) $n(89) 1.5Mb 820ms DropTail
$ns duplex-link $n(45) $n(75) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "2030..."; flush stdout }
$ns duplex-link $n(45) $n(74) 1.5Mb 260ms DropTail
$ns duplex-link $n(45) $n(73) 1.5Mb 650ms DropTail
$ns duplex-link $n(45) $n(72) 1.5Mb 420ms DropTail
$ns duplex-link $n(45) $n(71) 1.5Mb 520ms DropTail
$ns duplex-link $n(45) $n(46) 1.5Mb 770ms DropTail
$ns duplex-link $n(46) $n(249) 1.5Mb 710ms DropTail
$ns duplex-link $n(46) $n(246) 1.5Mb 490ms DropTail
$ns duplex-link $n(46) $n(240) 1.5Mb 160ms DropTail
$ns duplex-link $n(46) $n(222) 1.5Mb 430ms DropTail
$ns duplex-link $n(46) $n(218) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "2040..."; flush stdout }
$ns duplex-link $n(46) $n(212) 1.5Mb 440ms DropTail
$ns duplex-link $n(46) $n(208) 1.5Mb 650ms DropTail
$ns duplex-link $n(46) $n(207) 1.5Mb 450ms DropTail
$ns duplex-link $n(46) $n(206) 1.5Mb 240ms DropTail
$ns duplex-link $n(46) $n(204) 1.5Mb 780ms DropTail
$ns duplex-link $n(46) $n(202) 1.5Mb 550ms DropTail
$ns duplex-link $n(46) $n(200) 1.5Mb 610ms DropTail
$ns duplex-link $n(46) $n(198) 1.5Mb 780ms DropTail
$ns duplex-link $n(46) $n(186) 1.5Mb 680ms DropTail
$ns duplex-link $n(46) $n(180) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "2050..."; flush stdout }
$ns duplex-link $n(46) $n(179) 1.5Mb 540ms DropTail
$ns duplex-link $n(46) $n(171) 1.5Mb 870ms DropTail
$ns duplex-link $n(46) $n(169) 1.5Mb 770ms DropTail
$ns duplex-link $n(46) $n(168) 1.5Mb 820ms DropTail
$ns duplex-link $n(46) $n(163) 1.5Mb 330ms DropTail
$ns duplex-link $n(46) $n(162) 1.5Mb 550ms DropTail
$ns duplex-link $n(46) $n(159) 1.5Mb 620ms DropTail
$ns duplex-link $n(46) $n(149) 1.5Mb 730ms DropTail
$ns duplex-link $n(46) $n(146) 1.5Mb 600ms DropTail
$ns duplex-link $n(46) $n(144) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "2060..."; flush stdout }
$ns duplex-link $n(46) $n(143) 1.5Mb 520ms DropTail
$ns duplex-link $n(46) $n(135) 1.5Mb 740ms DropTail
$ns duplex-link $n(46) $n(125) 1.5Mb 790ms DropTail
$ns duplex-link $n(46) $n(124) 1.5Mb 760ms DropTail
$ns duplex-link $n(46) $n(123) 1.5Mb 430ms DropTail
$ns duplex-link $n(46) $n(116) 1.5Mb 340ms DropTail
$ns duplex-link $n(46) $n(115) 1.5Mb 730ms DropTail
$ns duplex-link $n(46) $n(96) 1.5Mb 420ms DropTail
$ns duplex-link $n(46) $n(95) 1.5Mb 640ms DropTail
$ns duplex-link $n(46) $n(93) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "2070..."; flush stdout }
$ns duplex-link $n(46) $n(89) 1.5Mb 320ms DropTail
$ns duplex-link $n(46) $n(87) 1.5Mb 640ms DropTail
$ns duplex-link $n(46) $n(85) 1.5Mb 520ms DropTail
$ns duplex-link $n(46) $n(80) 1.5Mb 420ms DropTail
$ns duplex-link $n(46) $n(77) 1.5Mb 670ms DropTail
$ns duplex-link $n(46) $n(76) 1.5Mb 480ms DropTail
$ns duplex-link $n(46) $n(73) 1.5Mb 140ms DropTail
$ns duplex-link $n(46) $n(70) 1.5Mb 630ms DropTail
$ns duplex-link $n(46) $n(67) 1.5Mb 760ms DropTail
$ns duplex-link $n(46) $n(61) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "2080..."; flush stdout }
$ns duplex-link $n(46) $n(60) 1.5Mb 130ms DropTail
$ns duplex-link $n(46) $n(57) 1.5Mb 90ms DropTail
$ns duplex-link $n(46) $n(47) 1.5Mb 590ms DropTail
$ns duplex-link $n(47) $n(241) 1.5Mb 520ms DropTail
$ns duplex-link $n(47) $n(240) 1.5Mb 710ms DropTail
$ns duplex-link $n(47) $n(235) 1.5Mb 590ms DropTail
$ns duplex-link $n(47) $n(233) 1.5Mb 450ms DropTail
$ns duplex-link $n(47) $n(231) 1.5Mb 470ms DropTail
$ns duplex-link $n(47) $n(217) 1.5Mb 270ms DropTail
$ns duplex-link $n(47) $n(211) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "2090..."; flush stdout }
$ns duplex-link $n(47) $n(201) 1.5Mb 680ms DropTail
$ns duplex-link $n(47) $n(198) 1.5Mb 260ms DropTail
$ns duplex-link $n(47) $n(194) 1.5Mb 280ms DropTail
$ns duplex-link $n(47) $n(178) 1.5Mb 340ms DropTail
$ns duplex-link $n(47) $n(174) 1.5Mb 110ms DropTail
$ns duplex-link $n(47) $n(173) 1.5Mb 460ms DropTail
$ns duplex-link $n(47) $n(172) 1.5Mb 230ms DropTail
$ns duplex-link $n(47) $n(162) 1.5Mb 450ms DropTail
$ns duplex-link $n(47) $n(160) 1.5Mb 570ms DropTail
$ns duplex-link $n(47) $n(159) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "2100..."; flush stdout }
$ns duplex-link $n(47) $n(156) 1.5Mb 410ms DropTail
$ns duplex-link $n(47) $n(150) 1.5Mb 670ms DropTail
$ns duplex-link $n(47) $n(140) 1.5Mb 610ms DropTail
$ns duplex-link $n(47) $n(138) 1.5Mb 90ms DropTail
$ns duplex-link $n(47) $n(136) 1.5Mb 380ms DropTail
$ns duplex-link $n(47) $n(131) 1.5Mb 770ms DropTail
$ns duplex-link $n(47) $n(124) 1.5Mb 640ms DropTail
$ns duplex-link $n(47) $n(117) 1.5Mb 370ms DropTail
$ns duplex-link $n(47) $n(114) 1.5Mb 880ms DropTail
$ns duplex-link $n(47) $n(102) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "2110..."; flush stdout }
$ns duplex-link $n(47) $n(101) 1.5Mb 480ms DropTail
$ns duplex-link $n(47) $n(98) 1.5Mb 310ms DropTail
$ns duplex-link $n(47) $n(93) 1.5Mb 700ms DropTail
$ns duplex-link $n(47) $n(91) 1.5Mb 640ms DropTail
$ns duplex-link $n(47) $n(88) 1.5Mb 330ms DropTail
$ns duplex-link $n(47) $n(87) 1.5Mb 540ms DropTail
$ns duplex-link $n(47) $n(84) 1.5Mb 670ms DropTail
$ns duplex-link $n(47) $n(81) 1.5Mb 330ms DropTail
$ns duplex-link $n(47) $n(78) 1.5Mb 910ms DropTail
$ns duplex-link $n(47) $n(74) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "2120..."; flush stdout }
$ns duplex-link $n(47) $n(69) 1.5Mb 450ms DropTail
$ns duplex-link $n(47) $n(64) 1.5Mb 290ms DropTail
$ns duplex-link $n(47) $n(63) 1.5Mb 860ms DropTail
$ns duplex-link $n(47) $n(60) 1.5Mb 460ms DropTail
$ns duplex-link $n(47) $n(59) 1.5Mb 290ms DropTail
$ns duplex-link $n(47) $n(57) 1.5Mb 680ms DropTail
$ns duplex-link $n(47) $n(55) 1.5Mb 390ms DropTail
$ns duplex-link $n(48) $n(249) 1.5Mb 460ms DropTail
$ns duplex-link $n(48) $n(225) 1.5Mb 760ms DropTail
$ns duplex-link $n(48) $n(224) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "2130..."; flush stdout }
$ns duplex-link $n(48) $n(223) 1.5Mb 590ms DropTail
$ns duplex-link $n(48) $n(218) 1.5Mb 660ms DropTail
$ns duplex-link $n(48) $n(217) 1.5Mb 150ms DropTail
$ns duplex-link $n(48) $n(216) 1.5Mb 490ms DropTail
$ns duplex-link $n(48) $n(215) 1.5Mb 550ms DropTail
$ns duplex-link $n(48) $n(214) 1.5Mb 560ms DropTail
$ns duplex-link $n(48) $n(212) 1.5Mb 420ms DropTail
$ns duplex-link $n(48) $n(200) 1.5Mb 620ms DropTail
$ns duplex-link $n(48) $n(187) 1.5Mb 390ms DropTail
$ns duplex-link $n(48) $n(186) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "2140..."; flush stdout }
$ns duplex-link $n(48) $n(179) 1.5Mb 610ms DropTail
$ns duplex-link $n(48) $n(178) 1.5Mb 160ms DropTail
$ns duplex-link $n(48) $n(159) 1.5Mb 600ms DropTail
$ns duplex-link $n(48) $n(156) 1.5Mb 450ms DropTail
$ns duplex-link $n(48) $n(155) 1.5Mb 350ms DropTail
$ns duplex-link $n(48) $n(153) 1.5Mb 320ms DropTail
$ns duplex-link $n(48) $n(150) 1.5Mb 370ms DropTail
$ns duplex-link $n(48) $n(144) 1.5Mb 650ms DropTail
$ns duplex-link $n(48) $n(141) 1.5Mb 620ms DropTail
$ns duplex-link $n(48) $n(129) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "2150..."; flush stdout }
$ns duplex-link $n(48) $n(128) 1.5Mb 220ms DropTail
$ns duplex-link $n(48) $n(127) 1.5Mb 400ms DropTail
$ns duplex-link $n(48) $n(121) 1.5Mb 400ms DropTail
$ns duplex-link $n(48) $n(115) 1.5Mb 500ms DropTail
$ns duplex-link $n(48) $n(107) 1.5Mb 70ms DropTail
$ns duplex-link $n(48) $n(103) 1.5Mb 780ms DropTail
$ns duplex-link $n(48) $n(100) 1.5Mb 270ms DropTail
$ns duplex-link $n(48) $n(98) 1.5Mb 450ms DropTail
$ns duplex-link $n(48) $n(92) 1.5Mb 480ms DropTail
$ns duplex-link $n(48) $n(91) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "2160..."; flush stdout }
$ns duplex-link $n(48) $n(90) 1.5Mb 190ms DropTail
$ns duplex-link $n(48) $n(82) 1.5Mb 600ms DropTail
$ns duplex-link $n(48) $n(78) 1.5Mb 650ms DropTail
$ns duplex-link $n(48) $n(69) 1.5Mb 280ms DropTail
$ns duplex-link $n(48) $n(63) 1.5Mb 620ms DropTail
$ns duplex-link $n(48) $n(54) 1.5Mb 230ms DropTail
$ns duplex-link $n(49) $n(245) 1.5Mb 480ms DropTail
$ns duplex-link $n(49) $n(244) 1.5Mb 520ms DropTail
$ns duplex-link $n(49) $n(240) 1.5Mb 540ms DropTail
$ns duplex-link $n(49) $n(238) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "2170..."; flush stdout }
$ns duplex-link $n(49) $n(235) 1.5Mb 430ms DropTail
$ns duplex-link $n(49) $n(217) 1.5Mb 90ms DropTail
$ns duplex-link $n(49) $n(205) 1.5Mb 380ms DropTail
$ns duplex-link $n(49) $n(203) 1.5Mb 530ms DropTail
$ns duplex-link $n(49) $n(199) 1.5Mb 900ms DropTail
$ns duplex-link $n(49) $n(195) 1.5Mb 780ms DropTail
$ns duplex-link $n(49) $n(187) 1.5Mb 560ms DropTail
$ns duplex-link $n(49) $n(183) 1.5Mb 430ms DropTail
$ns duplex-link $n(49) $n(175) 1.5Mb 290ms DropTail
$ns duplex-link $n(49) $n(172) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "2180..."; flush stdout }
$ns duplex-link $n(49) $n(170) 1.5Mb 580ms DropTail
$ns duplex-link $n(49) $n(169) 1.5Mb 740ms DropTail
$ns duplex-link $n(49) $n(167) 1.5Mb 630ms DropTail
$ns duplex-link $n(49) $n(158) 1.5Mb 680ms DropTail
$ns duplex-link $n(49) $n(154) 1.5Mb 570ms DropTail
$ns duplex-link $n(49) $n(148) 1.5Mb 330ms DropTail
$ns duplex-link $n(49) $n(147) 1.5Mb 110ms DropTail
$ns duplex-link $n(49) $n(145) 1.5Mb 730ms DropTail
$ns duplex-link $n(49) $n(141) 1.5Mb 610ms DropTail
$ns duplex-link $n(49) $n(140) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "2190..."; flush stdout }
$ns duplex-link $n(49) $n(139) 1.5Mb 70ms DropTail
$ns duplex-link $n(49) $n(130) 1.5Mb 630ms DropTail
$ns duplex-link $n(49) $n(124) 1.5Mb 680ms DropTail
$ns duplex-link $n(49) $n(118) 1.5Mb 410ms DropTail
$ns duplex-link $n(49) $n(109) 1.5Mb 580ms DropTail
$ns duplex-link $n(49) $n(107) 1.5Mb 120ms DropTail
$ns duplex-link $n(49) $n(93) 1.5Mb 740ms DropTail
$ns duplex-link $n(49) $n(89) 1.5Mb 260ms DropTail
$ns duplex-link $n(49) $n(86) 1.5Mb 790ms DropTail
$ns duplex-link $n(49) $n(75) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "2200..."; flush stdout }
$ns duplex-link $n(49) $n(73) 1.5Mb 440ms DropTail
$ns duplex-link $n(49) $n(71) 1.5Mb 480ms DropTail
$ns duplex-link $n(49) $n(64) 1.5Mb 150ms DropTail
$ns duplex-link $n(49) $n(60) 1.5Mb 300ms DropTail
$ns duplex-link $n(49) $n(58) 1.5Mb 660ms DropTail
$ns duplex-link $n(49) $n(56) 1.5Mb 530ms DropTail
$ns duplex-link $n(49) $n(54) 1.5Mb 190ms DropTail
$ns duplex-link $n(49) $n(51) 1.5Mb 630ms DropTail
$ns duplex-link $n(50) $n(249) 1.5Mb 210ms DropTail
$ns duplex-link $n(50) $n(245) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "2210..."; flush stdout }
$ns duplex-link $n(50) $n(237) 1.5Mb 630ms DropTail
$ns duplex-link $n(50) $n(230) 1.5Mb 770ms DropTail
$ns duplex-link $n(50) $n(209) 1.5Mb 520ms DropTail
$ns duplex-link $n(50) $n(206) 1.5Mb 820ms DropTail
$ns duplex-link $n(50) $n(202) 1.5Mb 130ms DropTail
$ns duplex-link $n(50) $n(194) 1.5Mb 330ms DropTail
$ns duplex-link $n(50) $n(191) 1.5Mb 840ms DropTail
$ns duplex-link $n(50) $n(189) 1.5Mb 570ms DropTail
$ns duplex-link $n(50) $n(188) 1.5Mb 280ms DropTail
$ns duplex-link $n(50) $n(186) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "2220..."; flush stdout }
$ns duplex-link $n(50) $n(179) 1.5Mb 840ms DropTail
$ns duplex-link $n(50) $n(177) 1.5Mb 650ms DropTail
$ns duplex-link $n(50) $n(176) 1.5Mb 170ms DropTail
$ns duplex-link $n(50) $n(175) 1.5Mb 100ms DropTail
$ns duplex-link $n(50) $n(172) 1.5Mb 280ms DropTail
$ns duplex-link $n(50) $n(167) 1.5Mb 810ms DropTail
$ns duplex-link $n(50) $n(163) 1.5Mb 340ms DropTail
$ns duplex-link $n(50) $n(158) 1.5Mb 570ms DropTail
$ns duplex-link $n(50) $n(154) 1.5Mb 720ms DropTail
$ns duplex-link $n(50) $n(149) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "2230..."; flush stdout }
$ns duplex-link $n(50) $n(147) 1.5Mb 230ms DropTail
$ns duplex-link $n(50) $n(146) 1.5Mb 470ms DropTail
$ns duplex-link $n(50) $n(145) 1.5Mb 740ms DropTail
$ns duplex-link $n(50) $n(139) 1.5Mb 260ms DropTail
$ns duplex-link $n(50) $n(136) 1.5Mb 340ms DropTail
$ns duplex-link $n(50) $n(126) 1.5Mb 800ms DropTail
$ns duplex-link $n(50) $n(125) 1.5Mb 600ms DropTail
$ns duplex-link $n(50) $n(119) 1.5Mb 270ms DropTail
$ns duplex-link $n(50) $n(117) 1.5Mb 410ms DropTail
$ns duplex-link $n(50) $n(116) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "2240..."; flush stdout }
$ns duplex-link $n(50) $n(114) 1.5Mb 880ms DropTail
$ns duplex-link $n(50) $n(112) 1.5Mb 460ms DropTail
$ns duplex-link $n(50) $n(109) 1.5Mb 620ms DropTail
$ns duplex-link $n(50) $n(105) 1.5Mb 210ms DropTail
$ns duplex-link $n(50) $n(101) 1.5Mb 520ms DropTail
$ns duplex-link $n(50) $n(93) 1.5Mb 670ms DropTail
$ns duplex-link $n(50) $n(71) 1.5Mb 580ms DropTail
$ns duplex-link $n(50) $n(70) 1.5Mb 730ms DropTail
$ns duplex-link $n(50) $n(66) 1.5Mb 330ms DropTail
$ns duplex-link $n(50) $n(65) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "2250..."; flush stdout }
$ns duplex-link $n(50) $n(57) 1.5Mb 720ms DropTail
$ns duplex-link $n(50) $n(56) 1.5Mb 610ms DropTail
$ns duplex-link $n(50) $n(55) 1.5Mb 360ms DropTail
$ns duplex-link $n(51) $n(247) 1.5Mb 310ms DropTail
$ns duplex-link $n(51) $n(246) 1.5Mb 440ms DropTail
$ns duplex-link $n(51) $n(241) 1.5Mb 630ms DropTail
$ns duplex-link $n(51) $n(239) 1.5Mb 480ms DropTail
$ns duplex-link $n(51) $n(238) 1.5Mb 490ms DropTail
$ns duplex-link $n(51) $n(233) 1.5Mb 780ms DropTail
$ns duplex-link $n(51) $n(232) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "2260..."; flush stdout }
$ns duplex-link $n(51) $n(231) 1.5Mb 90ms DropTail
$ns duplex-link $n(51) $n(227) 1.5Mb 970ms DropTail
$ns duplex-link $n(51) $n(221) 1.5Mb 180ms DropTail
$ns duplex-link $n(51) $n(213) 1.5Mb 580ms DropTail
$ns duplex-link $n(51) $n(212) 1.5Mb 580ms DropTail
$ns duplex-link $n(51) $n(209) 1.5Mb 50ms DropTail
$ns duplex-link $n(51) $n(208) 1.5Mb 220ms DropTail
$ns duplex-link $n(51) $n(203) 1.5Mb 1070ms DropTail
$ns duplex-link $n(51) $n(202) 1.5Mb 600ms DropTail
$ns duplex-link $n(51) $n(201) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "2270..."; flush stdout }
$ns duplex-link $n(51) $n(187) 1.5Mb 690ms DropTail
$ns duplex-link $n(51) $n(185) 1.5Mb 700ms DropTail
$ns duplex-link $n(51) $n(179) 1.5Mb 770ms DropTail
$ns duplex-link $n(51) $n(178) 1.5Mb 510ms DropTail
$ns duplex-link $n(51) $n(174) 1.5Mb 570ms DropTail
$ns duplex-link $n(51) $n(171) 1.5Mb 190ms DropTail
$ns duplex-link $n(51) $n(169) 1.5Mb 390ms DropTail
$ns duplex-link $n(51) $n(165) 1.5Mb 180ms DropTail
$ns duplex-link $n(51) $n(162) 1.5Mb 340ms DropTail
$ns duplex-link $n(51) $n(160) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "2280..."; flush stdout }
$ns duplex-link $n(51) $n(156) 1.5Mb 220ms DropTail
$ns duplex-link $n(51) $n(151) 1.5Mb 720ms DropTail
$ns duplex-link $n(51) $n(150) 1.5Mb 990ms DropTail
$ns duplex-link $n(51) $n(145) 1.5Mb 570ms DropTail
$ns duplex-link $n(51) $n(141) 1.5Mb 60ms DropTail
$ns duplex-link $n(51) $n(126) 1.5Mb 650ms DropTail
$ns duplex-link $n(51) $n(124) 1.5Mb 290ms DropTail
$ns duplex-link $n(51) $n(113) 1.5Mb 910ms DropTail
$ns duplex-link $n(51) $n(111) 1.5Mb 130ms DropTail
$ns duplex-link $n(51) $n(106) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "2290..."; flush stdout }
$ns duplex-link $n(51) $n(101) 1.5Mb 870ms DropTail
$ns duplex-link $n(51) $n(100) 1.5Mb 860ms DropTail
$ns duplex-link $n(51) $n(98) 1.5Mb 220ms DropTail
$ns duplex-link $n(51) $n(94) 1.5Mb 470ms DropTail
$ns duplex-link $n(51) $n(88) 1.5Mb 530ms DropTail
$ns duplex-link $n(51) $n(87) 1.5Mb 310ms DropTail
$ns duplex-link $n(51) $n(85) 1.5Mb 350ms DropTail
$ns duplex-link $n(51) $n(82) 1.5Mb 900ms DropTail
$ns duplex-link $n(51) $n(78) 1.5Mb 850ms DropTail
$ns duplex-link $n(51) $n(73) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "2300..."; flush stdout }
$ns duplex-link $n(51) $n(71) 1.5Mb 650ms DropTail
$ns duplex-link $n(51) $n(63) 1.5Mb 800ms DropTail
$ns duplex-link $n(52) $n(244) 1.5Mb 700ms DropTail
$ns duplex-link $n(52) $n(238) 1.5Mb 170ms DropTail
$ns duplex-link $n(52) $n(231) 1.5Mb 570ms DropTail
$ns duplex-link $n(52) $n(226) 1.5Mb 950ms DropTail
$ns duplex-link $n(52) $n(223) 1.5Mb 170ms DropTail
$ns duplex-link $n(52) $n(220) 1.5Mb 750ms DropTail
$ns duplex-link $n(52) $n(205) 1.5Mb 300ms DropTail
$ns duplex-link $n(52) $n(200) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "2310..."; flush stdout }
$ns duplex-link $n(52) $n(190) 1.5Mb 860ms DropTail
$ns duplex-link $n(52) $n(189) 1.5Mb 660ms DropTail
$ns duplex-link $n(52) $n(186) 1.5Mb 640ms DropTail
$ns duplex-link $n(52) $n(181) 1.5Mb 810ms DropTail
$ns duplex-link $n(52) $n(179) 1.5Mb 120ms DropTail
$ns duplex-link $n(52) $n(173) 1.5Mb 540ms DropTail
$ns duplex-link $n(52) $n(168) 1.5Mb 610ms DropTail
$ns duplex-link $n(52) $n(166) 1.5Mb 200ms DropTail
$ns duplex-link $n(52) $n(165) 1.5Mb 690ms DropTail
$ns duplex-link $n(52) $n(158) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "2320..."; flush stdout }
$ns duplex-link $n(52) $n(157) 1.5Mb 450ms DropTail
$ns duplex-link $n(52) $n(153) 1.5Mb 760ms DropTail
$ns duplex-link $n(52) $n(142) 1.5Mb 710ms DropTail
$ns duplex-link $n(52) $n(139) 1.5Mb 600ms DropTail
$ns duplex-link $n(52) $n(132) 1.5Mb 380ms DropTail
$ns duplex-link $n(52) $n(120) 1.5Mb 680ms DropTail
$ns duplex-link $n(52) $n(111) 1.5Mb 660ms DropTail
$ns duplex-link $n(52) $n(110) 1.5Mb 590ms DropTail
$ns duplex-link $n(52) $n(96) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(95) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "2330..."; flush stdout }
$ns duplex-link $n(52) $n(88) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(87) 1.5Mb 340ms DropTail
$ns duplex-link $n(52) $n(81) 1.5Mb 400ms DropTail
$ns duplex-link $n(52) $n(77) 1.5Mb 290ms DropTail
$ns duplex-link $n(52) $n(74) 1.5Mb 690ms DropTail
$ns duplex-link $n(52) $n(71) 1.5Mb 200ms DropTail
$ns duplex-link $n(52) $n(65) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(64) 1.5Mb 770ms DropTail
$ns duplex-link $n(52) $n(60) 1.5Mb 490ms DropTail
$ns duplex-link $n(52) $n(57) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "2340..."; flush stdout }
$ns duplex-link $n(53) $n(246) 1.5Mb 690ms DropTail
$ns duplex-link $n(53) $n(242) 1.5Mb 780ms DropTail
$ns duplex-link $n(53) $n(241) 1.5Mb 470ms DropTail
$ns duplex-link $n(53) $n(240) 1.5Mb 40ms DropTail
$ns duplex-link $n(53) $n(230) 1.5Mb 220ms DropTail
$ns duplex-link $n(53) $n(228) 1.5Mb 570ms DropTail
$ns duplex-link $n(53) $n(227) 1.5Mb 170ms DropTail
$ns duplex-link $n(53) $n(224) 1.5Mb 510ms DropTail
$ns duplex-link $n(53) $n(218) 1.5Mb 670ms DropTail
$ns duplex-link $n(53) $n(214) 1.5Mb 980ms DropTail
if {$verbose} { puts -nonewline "2350..."; flush stdout }
$ns duplex-link $n(53) $n(206) 1.5Mb 290ms DropTail
$ns duplex-link $n(53) $n(197) 1.5Mb 680ms DropTail
$ns duplex-link $n(53) $n(186) 1.5Mb 870ms DropTail
$ns duplex-link $n(53) $n(181) 1.5Mb 440ms DropTail
$ns duplex-link $n(53) $n(172) 1.5Mb 620ms DropTail
$ns duplex-link $n(53) $n(169) 1.5Mb 960ms DropTail
$ns duplex-link $n(53) $n(164) 1.5Mb 580ms DropTail
$ns duplex-link $n(53) $n(160) 1.5Mb 780ms DropTail
$ns duplex-link $n(53) $n(153) 1.5Mb 300ms DropTail
$ns duplex-link $n(53) $n(142) 1.5Mb 1010ms DropTail
if {$verbose} { puts -nonewline "2360..."; flush stdout }
$ns duplex-link $n(53) $n(140) 1.5Mb 200ms DropTail
$ns duplex-link $n(53) $n(139) 1.5Mb 520ms DropTail
$ns duplex-link $n(53) $n(136) 1.5Mb 870ms DropTail
$ns duplex-link $n(53) $n(133) 1.5Mb 870ms DropTail
$ns duplex-link $n(53) $n(127) 1.5Mb 840ms DropTail
$ns duplex-link $n(53) $n(119) 1.5Mb 920ms DropTail
$ns duplex-link $n(53) $n(118) 1.5Mb 880ms DropTail
$ns duplex-link $n(53) $n(115) 1.5Mb 930ms DropTail
$ns duplex-link $n(53) $n(108) 1.5Mb 580ms DropTail
$ns duplex-link $n(53) $n(102) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "2370..."; flush stdout }
$ns duplex-link $n(53) $n(96) 1.5Mb 610ms DropTail
$ns duplex-link $n(53) $n(92) 1.5Mb 890ms DropTail
$ns duplex-link $n(53) $n(90) 1.5Mb 630ms DropTail
$ns duplex-link $n(53) $n(81) 1.5Mb 620ms DropTail
$ns duplex-link $n(53) $n(80) 1.5Mb 570ms DropTail
$ns duplex-link $n(53) $n(76) 1.5Mb 640ms DropTail
$ns duplex-link $n(53) $n(72) 1.5Mb 640ms DropTail
$ns duplex-link $n(53) $n(70) 1.5Mb 810ms DropTail
$ns duplex-link $n(53) $n(69) 1.5Mb 600ms DropTail
$ns duplex-link $n(53) $n(63) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "2380..."; flush stdout }
$ns duplex-link $n(53) $n(62) 1.5Mb 970ms DropTail
$ns duplex-link $n(53) $n(55) 1.5Mb 820ms DropTail
$ns duplex-link $n(54) $n(247) 1.5Mb 530ms DropTail
$ns duplex-link $n(54) $n(230) 1.5Mb 620ms DropTail
$ns duplex-link $n(54) $n(226) 1.5Mb 400ms DropTail
$ns duplex-link $n(54) $n(222) 1.5Mb 120ms DropTail
$ns duplex-link $n(54) $n(213) 1.5Mb 480ms DropTail
$ns duplex-link $n(54) $n(182) 1.5Mb 620ms DropTail
$ns duplex-link $n(54) $n(176) 1.5Mb 10ms DropTail
$ns duplex-link $n(54) $n(167) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "2390..."; flush stdout }
$ns duplex-link $n(54) $n(165) 1.5Mb 610ms DropTail
$ns duplex-link $n(54) $n(163) 1.5Mb 180ms DropTail
$ns duplex-link $n(54) $n(155) 1.5Mb 180ms DropTail
$ns duplex-link $n(54) $n(150) 1.5Mb 590ms DropTail
$ns duplex-link $n(54) $n(131) 1.5Mb 640ms DropTail
$ns duplex-link $n(54) $n(123) 1.5Mb 250ms DropTail
$ns duplex-link $n(54) $n(122) 1.5Mb 300ms DropTail
$ns duplex-link $n(54) $n(115) 1.5Mb 290ms DropTail
$ns duplex-link $n(54) $n(108) 1.5Mb 200ms DropTail
$ns duplex-link $n(54) $n(102) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "2400..."; flush stdout }
$ns duplex-link $n(54) $n(95) 1.5Mb 280ms DropTail
$ns duplex-link $n(54) $n(93) 1.5Mb 560ms DropTail
$ns duplex-link $n(54) $n(84) 1.5Mb 540ms DropTail
$ns duplex-link $n(54) $n(82) 1.5Mb 720ms DropTail
$ns duplex-link $n(54) $n(77) 1.5Mb 500ms DropTail
$ns duplex-link $n(54) $n(76) 1.5Mb 620ms DropTail
$ns duplex-link $n(54) $n(66) 1.5Mb 170ms DropTail
$ns duplex-link $n(54) $n(62) 1.5Mb 510ms DropTail
$ns duplex-link $n(54) $n(61) 1.5Mb 440ms DropTail
$ns duplex-link $n(54) $n(60) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "2410..."; flush stdout }
$ns duplex-link $n(54) $n(56) 1.5Mb 450ms DropTail
$ns duplex-link $n(54) $n(55) 1.5Mb 260ms DropTail
$ns duplex-link $n(55) $n(248) 1.5Mb 520ms DropTail
$ns duplex-link $n(55) $n(243) 1.5Mb 280ms DropTail
$ns duplex-link $n(55) $n(236) 1.5Mb 350ms DropTail
$ns duplex-link $n(55) $n(231) 1.5Mb 160ms DropTail
$ns duplex-link $n(55) $n(225) 1.5Mb 340ms DropTail
$ns duplex-link $n(55) $n(221) 1.5Mb 70ms DropTail
$ns duplex-link $n(55) $n(220) 1.5Mb 630ms DropTail
$ns duplex-link $n(55) $n(219) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "2420..."; flush stdout }
$ns duplex-link $n(55) $n(218) 1.5Mb 670ms DropTail
$ns duplex-link $n(55) $n(217) 1.5Mb 510ms DropTail
$ns duplex-link $n(55) $n(216) 1.5Mb 890ms DropTail
$ns duplex-link $n(55) $n(215) 1.5Mb 700ms DropTail
$ns duplex-link $n(55) $n(206) 1.5Mb 730ms DropTail
$ns duplex-link $n(55) $n(196) 1.5Mb 270ms DropTail
$ns duplex-link $n(55) $n(189) 1.5Mb 690ms DropTail
$ns duplex-link $n(55) $n(187) 1.5Mb 460ms DropTail
$ns duplex-link $n(55) $n(184) 1.5Mb 70ms DropTail
$ns duplex-link $n(55) $n(182) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "2430..."; flush stdout }
$ns duplex-link $n(55) $n(181) 1.5Mb 710ms DropTail
$ns duplex-link $n(55) $n(180) 1.5Mb 590ms DropTail
$ns duplex-link $n(55) $n(164) 1.5Mb 540ms DropTail
$ns duplex-link $n(55) $n(159) 1.5Mb 450ms DropTail
$ns duplex-link $n(55) $n(155) 1.5Mb 70ms DropTail
$ns duplex-link $n(55) $n(151) 1.5Mb 480ms DropTail
$ns duplex-link $n(55) $n(147) 1.5Mb 350ms DropTail
$ns duplex-link $n(55) $n(141) 1.5Mb 200ms DropTail
$ns duplex-link $n(55) $n(140) 1.5Mb 630ms DropTail
$ns duplex-link $n(55) $n(139) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "2440..."; flush stdout }
$ns duplex-link $n(55) $n(127) 1.5Mb 250ms DropTail
$ns duplex-link $n(55) $n(124) 1.5Mb 250ms DropTail
$ns duplex-link $n(55) $n(117) 1.5Mb 470ms DropTail
$ns duplex-link $n(55) $n(115) 1.5Mb 150ms DropTail
$ns duplex-link $n(55) $n(114) 1.5Mb 610ms DropTail
$ns duplex-link $n(55) $n(113) 1.5Mb 660ms DropTail
$ns duplex-link $n(55) $n(110) 1.5Mb 130ms DropTail
$ns duplex-link $n(55) $n(106) 1.5Mb 320ms DropTail
$ns duplex-link $n(55) $n(102) 1.5Mb 300ms DropTail
$ns duplex-link $n(55) $n(95) 1.5Mb 20ms DropTail
if {$verbose} { puts -nonewline "2450..."; flush stdout }
$ns duplex-link $n(55) $n(88) 1.5Mb 290ms DropTail
$ns duplex-link $n(55) $n(85) 1.5Mb 100ms DropTail
$ns duplex-link $n(55) $n(77) 1.5Mb 280ms DropTail
$ns duplex-link $n(55) $n(72) 1.5Mb 340ms DropTail
$ns duplex-link $n(55) $n(71) 1.5Mb 410ms DropTail
$ns duplex-link $n(55) $n(67) 1.5Mb 150ms DropTail
$ns duplex-link $n(55) $n(62) 1.5Mb 260ms DropTail
$ns duplex-link $n(55) $n(60) 1.5Mb 520ms DropTail
$ns duplex-link $n(55) $n(56) 1.5Mb 390ms DropTail
$ns duplex-link $n(56) $n(248) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "2460..."; flush stdout }
$ns duplex-link $n(56) $n(239) 1.5Mb 160ms DropTail
$ns duplex-link $n(56) $n(234) 1.5Mb 150ms DropTail
$ns duplex-link $n(56) $n(230) 1.5Mb 380ms DropTail
$ns duplex-link $n(56) $n(227) 1.5Mb 410ms DropTail
$ns duplex-link $n(56) $n(226) 1.5Mb 850ms DropTail
$ns duplex-link $n(56) $n(220) 1.5Mb 620ms DropTail
$ns duplex-link $n(56) $n(219) 1.5Mb 260ms DropTail
$ns duplex-link $n(56) $n(218) 1.5Mb 300ms DropTail
$ns duplex-link $n(56) $n(217) 1.5Mb 520ms DropTail
$ns duplex-link $n(56) $n(216) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "2470..."; flush stdout }
$ns duplex-link $n(56) $n(212) 1.5Mb 60ms DropTail
$ns duplex-link $n(56) $n(210) 1.5Mb 410ms DropTail
$ns duplex-link $n(56) $n(209) 1.5Mb 650ms DropTail
$ns duplex-link $n(56) $n(207) 1.5Mb 350ms DropTail
$ns duplex-link $n(56) $n(206) 1.5Mb 370ms DropTail
$ns duplex-link $n(56) $n(205) 1.5Mb 200ms DropTail
$ns duplex-link $n(56) $n(198) 1.5Mb 860ms DropTail
$ns duplex-link $n(56) $n(188) 1.5Mb 570ms DropTail
$ns duplex-link $n(56) $n(185) 1.5Mb 450ms DropTail
$ns duplex-link $n(56) $n(184) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "2480..."; flush stdout }
$ns duplex-link $n(56) $n(172) 1.5Mb 680ms DropTail
$ns duplex-link $n(56) $n(170) 1.5Mb 210ms DropTail
$ns duplex-link $n(56) $n(165) 1.5Mb 690ms DropTail
$ns duplex-link $n(56) $n(162) 1.5Mb 280ms DropTail
$ns duplex-link $n(56) $n(153) 1.5Mb 630ms DropTail
$ns duplex-link $n(56) $n(151) 1.5Mb 340ms DropTail
$ns duplex-link $n(56) $n(150) 1.5Mb 500ms DropTail
$ns duplex-link $n(56) $n(134) 1.5Mb 320ms DropTail
$ns duplex-link $n(56) $n(133) 1.5Mb 690ms DropTail
$ns duplex-link $n(56) $n(129) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "2490..."; flush stdout }
$ns duplex-link $n(56) $n(125) 1.5Mb 460ms DropTail
$ns duplex-link $n(56) $n(116) 1.5Mb 710ms DropTail
$ns duplex-link $n(56) $n(113) 1.5Mb 420ms DropTail
$ns duplex-link $n(56) $n(110) 1.5Mb 520ms DropTail
$ns duplex-link $n(56) $n(106) 1.5Mb 70ms DropTail
$ns duplex-link $n(56) $n(105) 1.5Mb 590ms DropTail
$ns duplex-link $n(56) $n(103) 1.5Mb 650ms DropTail
$ns duplex-link $n(56) $n(100) 1.5Mb 360ms DropTail
$ns duplex-link $n(56) $n(99) 1.5Mb 400ms DropTail
$ns duplex-link $n(56) $n(96) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "2500..."; flush stdout }
$ns duplex-link $n(56) $n(90) 1.5Mb 480ms DropTail
$ns duplex-link $n(56) $n(86) 1.5Mb 270ms DropTail
$ns duplex-link $n(56) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(56) $n(84) 1.5Mb 470ms DropTail
$ns duplex-link $n(56) $n(82) 1.5Mb 290ms DropTail
$ns duplex-link $n(56) $n(81) 1.5Mb 290ms DropTail
$ns duplex-link $n(56) $n(80) 1.5Mb 480ms DropTail
$ns duplex-link $n(56) $n(76) 1.5Mb 170ms DropTail
$ns duplex-link $n(56) $n(74) 1.5Mb 620ms DropTail
$ns duplex-link $n(56) $n(58) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "2510..."; flush stdout }
$ns duplex-link $n(57) $n(248) 1.5Mb 460ms DropTail
$ns duplex-link $n(57) $n(235) 1.5Mb 110ms DropTail
$ns duplex-link $n(57) $n(234) 1.5Mb 280ms DropTail
$ns duplex-link $n(57) $n(223) 1.5Mb 650ms DropTail
$ns duplex-link $n(57) $n(221) 1.5Mb 760ms DropTail
$ns duplex-link $n(57) $n(218) 1.5Mb 510ms DropTail
$ns duplex-link $n(57) $n(213) 1.5Mb 490ms DropTail
$ns duplex-link $n(57) $n(209) 1.5Mb 980ms DropTail
$ns duplex-link $n(57) $n(208) 1.5Mb 720ms DropTail
$ns duplex-link $n(57) $n(204) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "2520..."; flush stdout }
$ns duplex-link $n(57) $n(201) 1.5Mb 1000ms DropTail
$ns duplex-link $n(57) $n(197) 1.5Mb 520ms DropTail
$ns duplex-link $n(57) $n(189) 1.5Mb 270ms DropTail
$ns duplex-link $n(57) $n(180) 1.5Mb 610ms DropTail
$ns duplex-link $n(57) $n(176) 1.5Mb 580ms DropTail
$ns duplex-link $n(57) $n(173) 1.5Mb 230ms DropTail
$ns duplex-link $n(57) $n(156) 1.5Mb 720ms DropTail
$ns duplex-link $n(57) $n(151) 1.5Mb 260ms DropTail
$ns duplex-link $n(57) $n(150) 1.5Mb 120ms DropTail
$ns duplex-link $n(57) $n(141) 1.5Mb 890ms DropTail
if {$verbose} { puts -nonewline "2530..."; flush stdout }
$ns duplex-link $n(57) $n(140) 1.5Mb 70ms DropTail
$ns duplex-link $n(57) $n(134) 1.5Mb 570ms DropTail
$ns duplex-link $n(57) $n(128) 1.5Mb 470ms DropTail
$ns duplex-link $n(57) $n(127) 1.5Mb 750ms DropTail
$ns duplex-link $n(57) $n(124) 1.5Mb 810ms DropTail
$ns duplex-link $n(57) $n(119) 1.5Mb 890ms DropTail
$ns duplex-link $n(57) $n(118) 1.5Mb 770ms DropTail
$ns duplex-link $n(57) $n(115) 1.5Mb 810ms DropTail
$ns duplex-link $n(57) $n(113) 1.5Mb 80ms DropTail
$ns duplex-link $n(57) $n(109) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "2540..."; flush stdout }
$ns duplex-link $n(57) $n(108) 1.5Mb 450ms DropTail
$ns duplex-link $n(57) $n(107) 1.5Mb 430ms DropTail
$ns duplex-link $n(57) $n(100) 1.5Mb 90ms DropTail
$ns duplex-link $n(57) $n(99) 1.5Mb 60ms DropTail
$ns duplex-link $n(57) $n(95) 1.5Mb 710ms DropTail
$ns duplex-link $n(57) $n(79) 1.5Mb 340ms DropTail
$ns duplex-link $n(57) $n(72) 1.5Mb 480ms DropTail
$ns duplex-link $n(57) $n(64) 1.5Mb 530ms DropTail
$ns duplex-link $n(57) $n(60) 1.5Mb 230ms DropTail
$ns duplex-link $n(57) $n(59) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "2550..."; flush stdout }
$ns duplex-link $n(58) $n(247) 1.5Mb 50ms DropTail
$ns duplex-link $n(58) $n(243) 1.5Mb 410ms DropTail
$ns duplex-link $n(58) $n(238) 1.5Mb 270ms DropTail
$ns duplex-link $n(58) $n(237) 1.5Mb 860ms DropTail
$ns duplex-link $n(58) $n(233) 1.5Mb 710ms DropTail
$ns duplex-link $n(58) $n(232) 1.5Mb 580ms DropTail
$ns duplex-link $n(58) $n(229) 1.5Mb 640ms DropTail
$ns duplex-link $n(58) $n(227) 1.5Mb 820ms DropTail
$ns duplex-link $n(58) $n(217) 1.5Mb 710ms DropTail
$ns duplex-link $n(58) $n(202) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "2560..."; flush stdout }
$ns duplex-link $n(58) $n(197) 1.5Mb 500ms DropTail
$ns duplex-link $n(58) $n(196) 1.5Mb 500ms DropTail
$ns duplex-link $n(58) $n(191) 1.5Mb 550ms DropTail
$ns duplex-link $n(58) $n(188) 1.5Mb 730ms DropTail
$ns duplex-link $n(58) $n(184) 1.5Mb 290ms DropTail
$ns duplex-link $n(58) $n(177) 1.5Mb 830ms DropTail
$ns duplex-link $n(58) $n(175) 1.5Mb 490ms DropTail
$ns duplex-link $n(58) $n(167) 1.5Mb 820ms DropTail
$ns duplex-link $n(58) $n(140) 1.5Mb 750ms DropTail
$ns duplex-link $n(58) $n(134) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "2570..."; flush stdout }
$ns duplex-link $n(58) $n(131) 1.5Mb 740ms DropTail
$ns duplex-link $n(58) $n(123) 1.5Mb 730ms DropTail
$ns duplex-link $n(58) $n(118) 1.5Mb 350ms DropTail
$ns duplex-link $n(58) $n(117) 1.5Mb 650ms DropTail
$ns duplex-link $n(58) $n(116) 1.5Mb 1060ms DropTail
$ns duplex-link $n(58) $n(113) 1.5Mb 790ms DropTail
$ns duplex-link $n(58) $n(112) 1.5Mb 540ms DropTail
$ns duplex-link $n(58) $n(107) 1.5Mb 590ms DropTail
$ns duplex-link $n(58) $n(104) 1.5Mb 370ms DropTail
$ns duplex-link $n(58) $n(97) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "2580..."; flush stdout }
$ns duplex-link $n(58) $n(95) 1.5Mb 210ms DropTail
$ns duplex-link $n(58) $n(84) 1.5Mb 60ms DropTail
$ns duplex-link $n(58) $n(81) 1.5Mb 380ms DropTail
$ns duplex-link $n(58) $n(73) 1.5Mb 620ms DropTail
$ns duplex-link $n(58) $n(70) 1.5Mb 280ms DropTail
$ns duplex-link $n(58) $n(68) 1.5Mb 200ms DropTail
$ns duplex-link $n(58) $n(63) 1.5Mb 540ms DropTail
$ns duplex-link $n(58) $n(59) 1.5Mb 610ms DropTail
$ns duplex-link $n(59) $n(244) 1.5Mb 560ms DropTail
$ns duplex-link $n(59) $n(238) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "2590..."; flush stdout }
$ns duplex-link $n(59) $n(233) 1.5Mb 170ms DropTail
$ns duplex-link $n(59) $n(222) 1.5Mb 130ms DropTail
$ns duplex-link $n(59) $n(218) 1.5Mb 690ms DropTail
$ns duplex-link $n(59) $n(217) 1.5Mb 120ms DropTail
$ns duplex-link $n(59) $n(215) 1.5Mb 580ms DropTail
$ns duplex-link $n(59) $n(211) 1.5Mb 140ms DropTail
$ns duplex-link $n(59) $n(206) 1.5Mb 510ms DropTail
$ns duplex-link $n(59) $n(203) 1.5Mb 450ms DropTail
$ns duplex-link $n(59) $n(199) 1.5Mb 770ms DropTail
$ns duplex-link $n(59) $n(197) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "2600..."; flush stdout }
$ns duplex-link $n(59) $n(195) 1.5Mb 640ms DropTail
$ns duplex-link $n(59) $n(192) 1.5Mb 700ms DropTail
$ns duplex-link $n(59) $n(188) 1.5Mb 170ms DropTail
$ns duplex-link $n(59) $n(187) 1.5Mb 430ms DropTail
$ns duplex-link $n(59) $n(184) 1.5Mb 410ms DropTail
$ns duplex-link $n(59) $n(171) 1.5Mb 690ms DropTail
$ns duplex-link $n(59) $n(170) 1.5Mb 490ms DropTail
$ns duplex-link $n(59) $n(168) 1.5Mb 590ms DropTail
$ns duplex-link $n(59) $n(162) 1.5Mb 400ms DropTail
$ns duplex-link $n(59) $n(161) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "2610..."; flush stdout }
$ns duplex-link $n(59) $n(157) 1.5Mb 510ms DropTail
$ns duplex-link $n(59) $n(155) 1.5Mb 350ms DropTail
$ns duplex-link $n(59) $n(154) 1.5Mb 420ms DropTail
$ns duplex-link $n(59) $n(152) 1.5Mb 180ms DropTail
$ns duplex-link $n(59) $n(143) 1.5Mb 640ms DropTail
$ns duplex-link $n(59) $n(137) 1.5Mb 330ms DropTail
$ns duplex-link $n(59) $n(132) 1.5Mb 230ms DropTail
$ns duplex-link $n(59) $n(130) 1.5Mb 610ms DropTail
$ns duplex-link $n(59) $n(128) 1.5Mb 200ms DropTail
$ns duplex-link $n(59) $n(106) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "2620..."; flush stdout }
$ns duplex-link $n(59) $n(105) 1.5Mb 440ms DropTail
$ns duplex-link $n(59) $n(91) 1.5Mb 370ms DropTail
$ns duplex-link $n(59) $n(88) 1.5Mb 150ms DropTail
$ns duplex-link $n(59) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(59) $n(82) 1.5Mb 630ms DropTail
$ns duplex-link $n(59) $n(81) 1.5Mb 230ms DropTail
$ns duplex-link $n(59) $n(76) 1.5Mb 570ms DropTail
$ns duplex-link $n(59) $n(75) 1.5Mb 540ms DropTail
$ns duplex-link $n(59) $n(70) 1.5Mb 610ms DropTail
$ns duplex-link $n(59) $n(67) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "2630..."; flush stdout }
$ns duplex-link $n(59) $n(66) 1.5Mb 220ms DropTail
$ns duplex-link $n(59) $n(63) 1.5Mb 650ms DropTail
$ns duplex-link $n(60) $n(241) 1.5Mb 240ms DropTail
$ns duplex-link $n(60) $n(229) 1.5Mb 450ms DropTail
$ns duplex-link $n(60) $n(228) 1.5Mb 550ms DropTail
$ns duplex-link $n(60) $n(226) 1.5Mb 700ms DropTail
$ns duplex-link $n(60) $n(225) 1.5Mb 860ms DropTail
$ns duplex-link $n(60) $n(224) 1.5Mb 350ms DropTail
$ns duplex-link $n(60) $n(223) 1.5Mb 610ms DropTail
$ns duplex-link $n(60) $n(210) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "2640..."; flush stdout }
$ns duplex-link $n(60) $n(209) 1.5Mb 810ms DropTail
$ns duplex-link $n(60) $n(205) 1.5Mb 330ms DropTail
$ns duplex-link $n(60) $n(204) 1.5Mb 710ms DropTail
$ns duplex-link $n(60) $n(189) 1.5Mb 180ms DropTail
$ns duplex-link $n(60) $n(187) 1.5Mb 350ms DropTail
$ns duplex-link $n(60) $n(178) 1.5Mb 250ms DropTail
$ns duplex-link $n(60) $n(157) 1.5Mb 600ms DropTail
$ns duplex-link $n(60) $n(153) 1.5Mb 270ms DropTail
$ns duplex-link $n(60) $n(151) 1.5Mb 40ms DropTail
$ns duplex-link $n(60) $n(150) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "2650..."; flush stdout }
$ns duplex-link $n(60) $n(149) 1.5Mb 600ms DropTail
$ns duplex-link $n(60) $n(146) 1.5Mb 520ms DropTail
$ns duplex-link $n(60) $n(141) 1.5Mb 720ms DropTail
$ns duplex-link $n(60) $n(135) 1.5Mb 650ms DropTail
$ns duplex-link $n(60) $n(131) 1.5Mb 340ms DropTail
$ns duplex-link $n(60) $n(126) 1.5Mb 620ms DropTail
$ns duplex-link $n(60) $n(119) 1.5Mb 670ms DropTail
$ns duplex-link $n(60) $n(116) 1.5Mb 380ms DropTail
$ns duplex-link $n(60) $n(100) 1.5Mb 140ms DropTail
$ns duplex-link $n(60) $n(96) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "2660..."; flush stdout }
$ns duplex-link $n(60) $n(93) 1.5Mb 730ms DropTail
$ns duplex-link $n(60) $n(92) 1.5Mb 610ms DropTail
$ns duplex-link $n(60) $n(90) 1.5Mb 330ms DropTail
$ns duplex-link $n(60) $n(81) 1.5Mb 320ms DropTail
$ns duplex-link $n(60) $n(69) 1.5Mb 330ms DropTail
$ns duplex-link $n(60) $n(64) 1.5Mb 330ms DropTail
$ns duplex-link $n(60) $n(62) 1.5Mb 700ms DropTail
$ns duplex-link $n(61) $n(237) 1.5Mb 800ms DropTail
$ns duplex-link $n(61) $n(229) 1.5Mb 600ms DropTail
$ns duplex-link $n(61) $n(223) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "2670..."; flush stdout }
$ns duplex-link $n(61) $n(215) 1.5Mb 670ms DropTail
$ns duplex-link $n(61) $n(212) 1.5Mb 310ms DropTail
$ns duplex-link $n(61) $n(205) 1.5Mb 290ms DropTail
$ns duplex-link $n(61) $n(199) 1.5Mb 620ms DropTail
$ns duplex-link $n(61) $n(187) 1.5Mb 440ms DropTail
$ns duplex-link $n(61) $n(184) 1.5Mb 260ms DropTail
$ns duplex-link $n(61) $n(176) 1.5Mb 430ms DropTail
$ns duplex-link $n(61) $n(169) 1.5Mb 130ms DropTail
$ns duplex-link $n(61) $n(165) 1.5Mb 320ms DropTail
$ns duplex-link $n(61) $n(163) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "2680..."; flush stdout }
$ns duplex-link $n(61) $n(161) 1.5Mb 220ms DropTail
$ns duplex-link $n(61) $n(160) 1.5Mb 120ms DropTail
$ns duplex-link $n(61) $n(156) 1.5Mb 180ms DropTail
$ns duplex-link $n(61) $n(151) 1.5Mb 580ms DropTail
$ns duplex-link $n(61) $n(143) 1.5Mb 500ms DropTail
$ns duplex-link $n(61) $n(137) 1.5Mb 500ms DropTail
$ns duplex-link $n(61) $n(135) 1.5Mb 110ms DropTail
$ns duplex-link $n(61) $n(129) 1.5Mb 310ms DropTail
$ns duplex-link $n(61) $n(127) 1.5Mb 450ms DropTail
$ns duplex-link $n(61) $n(123) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "2690..."; flush stdout }
$ns duplex-link $n(61) $n(104) 1.5Mb 320ms DropTail
$ns duplex-link $n(61) $n(101) 1.5Mb 760ms DropTail
$ns duplex-link $n(61) $n(100) 1.5Mb 680ms DropTail
$ns duplex-link $n(61) $n(86) 1.5Mb 400ms DropTail
$ns duplex-link $n(61) $n(70) 1.5Mb 260ms DropTail
$ns duplex-link $n(62) $n(244) 1.5Mb 410ms DropTail
$ns duplex-link $n(62) $n(236) 1.5Mb 450ms DropTail
$ns duplex-link $n(62) $n(223) 1.5Mb 270ms DropTail
$ns duplex-link $n(62) $n(221) 1.5Mb 230ms DropTail
$ns duplex-link $n(62) $n(214) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "2700..."; flush stdout }
$ns duplex-link $n(62) $n(199) 1.5Mb 650ms DropTail
$ns duplex-link $n(62) $n(197) 1.5Mb 500ms DropTail
$ns duplex-link $n(62) $n(188) 1.5Mb 760ms DropTail
$ns duplex-link $n(62) $n(186) 1.5Mb 440ms DropTail
$ns duplex-link $n(62) $n(184) 1.5Mb 320ms DropTail
$ns duplex-link $n(62) $n(170) 1.5Mb 220ms DropTail
$ns duplex-link $n(62) $n(164) 1.5Mb 520ms DropTail
$ns duplex-link $n(62) $n(163) 1.5Mb 510ms DropTail
$ns duplex-link $n(62) $n(156) 1.5Mb 240ms DropTail
$ns duplex-link $n(62) $n(153) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "2710..."; flush stdout }
$ns duplex-link $n(62) $n(152) 1.5Mb 540ms DropTail
$ns duplex-link $n(62) $n(149) 1.5Mb 620ms DropTail
$ns duplex-link $n(62) $n(148) 1.5Mb 360ms DropTail
$ns duplex-link $n(62) $n(138) 1.5Mb 590ms DropTail
$ns duplex-link $n(62) $n(130) 1.5Mb 180ms DropTail
$ns duplex-link $n(62) $n(122) 1.5Mb 690ms DropTail
$ns duplex-link $n(62) $n(119) 1.5Mb 870ms DropTail
$ns duplex-link $n(62) $n(112) 1.5Mb 560ms DropTail
$ns duplex-link $n(62) $n(111) 1.5Mb 370ms DropTail
$ns duplex-link $n(62) $n(109) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "2720..."; flush stdout }
$ns duplex-link $n(62) $n(103) 1.5Mb 220ms DropTail
$ns duplex-link $n(62) $n(96) 1.5Mb 430ms DropTail
$ns duplex-link $n(62) $n(95) 1.5Mb 240ms DropTail
$ns duplex-link $n(62) $n(86) 1.5Mb 420ms DropTail
$ns duplex-link $n(62) $n(83) 1.5Mb 720ms DropTail
$ns duplex-link $n(62) $n(70) 1.5Mb 280ms DropTail
$ns duplex-link $n(62) $n(66) 1.5Mb 410ms DropTail
$ns duplex-link $n(62) $n(63) 1.5Mb 540ms DropTail
$ns duplex-link $n(63) $n(241) 1.5Mb 360ms DropTail
$ns duplex-link $n(63) $n(235) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "2730..."; flush stdout }
$ns duplex-link $n(63) $n(226) 1.5Mb 1100ms DropTail
$ns duplex-link $n(63) $n(219) 1.5Mb 480ms DropTail
$ns duplex-link $n(63) $n(218) 1.5Mb 70ms DropTail
$ns duplex-link $n(63) $n(215) 1.5Mb 260ms DropTail
$ns duplex-link $n(63) $n(209) 1.5Mb 820ms DropTail
$ns duplex-link $n(63) $n(203) 1.5Mb 740ms DropTail
$ns duplex-link $n(63) $n(192) 1.5Mb 670ms DropTail
$ns duplex-link $n(63) $n(191) 1.5Mb 50ms DropTail
$ns duplex-link $n(63) $n(190) 1.5Mb 1000ms DropTail
$ns duplex-link $n(63) $n(182) 1.5Mb 100ms DropTail
if {$verbose} { puts -nonewline "2740..."; flush stdout }
$ns duplex-link $n(63) $n(164) 1.5Mb 110ms DropTail
$ns duplex-link $n(63) $n(160) 1.5Mb 400ms DropTail
$ns duplex-link $n(63) $n(156) 1.5Mb 610ms DropTail
$ns duplex-link $n(63) $n(142) 1.5Mb 850ms DropTail
$ns duplex-link $n(63) $n(141) 1.5Mb 730ms DropTail
$ns duplex-link $n(63) $n(138) 1.5Mb 860ms DropTail
$ns duplex-link $n(63) $n(124) 1.5Mb 540ms DropTail
$ns duplex-link $n(63) $n(121) 1.5Mb 510ms DropTail
$ns duplex-link $n(63) $n(112) 1.5Mb 470ms DropTail
$ns duplex-link $n(63) $n(111) 1.5Mb 800ms DropTail
if {$verbose} { puts -nonewline "2750..."; flush stdout }
$ns duplex-link $n(63) $n(106) 1.5Mb 310ms DropTail
$ns duplex-link $n(63) $n(105) 1.5Mb 820ms DropTail
$ns duplex-link $n(63) $n(98) 1.5Mb 740ms DropTail
$ns duplex-link $n(63) $n(94) 1.5Mb 560ms DropTail
$ns duplex-link $n(63) $n(91) 1.5Mb 370ms DropTail
$ns duplex-link $n(63) $n(86) 1.5Mb 140ms DropTail
$ns duplex-link $n(63) $n(69) 1.5Mb 420ms DropTail
$ns duplex-link $n(63) $n(68) 1.5Mb 350ms DropTail
$ns duplex-link $n(63) $n(65) 1.5Mb 470ms DropTail
$ns duplex-link $n(64) $n(233) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "2760..."; flush stdout }
$ns duplex-link $n(64) $n(231) 1.5Mb 720ms DropTail
$ns duplex-link $n(64) $n(230) 1.5Mb 610ms DropTail
$ns duplex-link $n(64) $n(228) 1.5Mb 880ms DropTail
$ns duplex-link $n(64) $n(225) 1.5Mb 920ms DropTail
$ns duplex-link $n(64) $n(224) 1.5Mb 660ms DropTail
$ns duplex-link $n(64) $n(218) 1.5Mb 910ms DropTail
$ns duplex-link $n(64) $n(214) 1.5Mb 690ms DropTail
$ns duplex-link $n(64) $n(200) 1.5Mb 880ms DropTail
$ns duplex-link $n(64) $n(199) 1.5Mb 990ms DropTail
$ns duplex-link $n(64) $n(196) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "2770..."; flush stdout }
$ns duplex-link $n(64) $n(193) 1.5Mb 980ms DropTail
$ns duplex-link $n(64) $n(187) 1.5Mb 650ms DropTail
$ns duplex-link $n(64) $n(182) 1.5Mb 830ms DropTail
$ns duplex-link $n(64) $n(181) 1.5Mb 150ms DropTail
$ns duplex-link $n(64) $n(166) 1.5Mb 960ms DropTail
$ns duplex-link $n(64) $n(165) 1.5Mb 950ms DropTail
$ns duplex-link $n(64) $n(156) 1.5Mb 620ms DropTail
$ns duplex-link $n(64) $n(153) 1.5Mb 260ms DropTail
$ns duplex-link $n(64) $n(151) 1.5Mb 320ms DropTail
$ns duplex-link $n(64) $n(142) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "2780..."; flush stdout }
$ns duplex-link $n(64) $n(140) 1.5Mb 470ms DropTail
$ns duplex-link $n(64) $n(133) 1.5Mb 410ms DropTail
$ns duplex-link $n(64) $n(129) 1.5Mb 480ms DropTail
$ns duplex-link $n(64) $n(121) 1.5Mb 610ms DropTail
$ns duplex-link $n(64) $n(109) 1.5Mb 700ms DropTail
$ns duplex-link $n(64) $n(106) 1.5Mb 610ms DropTail
$ns duplex-link $n(64) $n(104) 1.5Mb 490ms DropTail
$ns duplex-link $n(64) $n(100) 1.5Mb 450ms DropTail
$ns duplex-link $n(64) $n(87) 1.5Mb 710ms DropTail
$ns duplex-link $n(64) $n(82) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "2790..."; flush stdout }
$ns duplex-link $n(64) $n(81) 1.5Mb 440ms DropTail
$ns duplex-link $n(64) $n(73) 1.5Mb 490ms DropTail
$ns duplex-link $n(65) $n(244) 1.5Mb 780ms DropTail
$ns duplex-link $n(65) $n(229) 1.5Mb 570ms DropTail
$ns duplex-link $n(65) $n(219) 1.5Mb 90ms DropTail
$ns duplex-link $n(65) $n(216) 1.5Mb 370ms DropTail
$ns duplex-link $n(65) $n(207) 1.5Mb 400ms DropTail
$ns duplex-link $n(65) $n(206) 1.5Mb 220ms DropTail
$ns duplex-link $n(65) $n(205) 1.5Mb 340ms DropTail
$ns duplex-link $n(65) $n(200) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "2800..."; flush stdout }
$ns duplex-link $n(65) $n(199) 1.5Mb 560ms DropTail
$ns duplex-link $n(65) $n(196) 1.5Mb 550ms DropTail
$ns duplex-link $n(65) $n(195) 1.5Mb 450ms DropTail
$ns duplex-link $n(65) $n(191) 1.5Mb 420ms DropTail
$ns duplex-link $n(65) $n(188) 1.5Mb 430ms DropTail
$ns duplex-link $n(65) $n(186) 1.5Mb 640ms DropTail
$ns duplex-link $n(65) $n(180) 1.5Mb 540ms DropTail
$ns duplex-link $n(65) $n(168) 1.5Mb 760ms DropTail
$ns duplex-link $n(65) $n(155) 1.5Mb 520ms DropTail
$ns duplex-link $n(65) $n(142) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "2810..."; flush stdout }
$ns duplex-link $n(65) $n(141) 1.5Mb 760ms DropTail
$ns duplex-link $n(65) $n(136) 1.5Mb 620ms DropTail
$ns duplex-link $n(65) $n(123) 1.5Mb 440ms DropTail
$ns duplex-link $n(65) $n(118) 1.5Mb 640ms DropTail
$ns duplex-link $n(65) $n(116) 1.5Mb 410ms DropTail
$ns duplex-link $n(65) $n(114) 1.5Mb 490ms DropTail
$ns duplex-link $n(65) $n(110) 1.5Mb 660ms DropTail
$ns duplex-link $n(65) $n(108) 1.5Mb 330ms DropTail
$ns duplex-link $n(65) $n(107) 1.5Mb 330ms DropTail
$ns duplex-link $n(65) $n(105) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "2820..."; flush stdout }
$ns duplex-link $n(65) $n(103) 1.5Mb 900ms DropTail
$ns duplex-link $n(65) $n(97) 1.5Mb 370ms DropTail
$ns duplex-link $n(65) $n(95) 1.5Mb 580ms DropTail
$ns duplex-link $n(65) $n(94) 1.5Mb 360ms DropTail
$ns duplex-link $n(65) $n(88) 1.5Mb 290ms DropTail
$ns duplex-link $n(65) $n(79) 1.5Mb 210ms DropTail
$ns duplex-link $n(65) $n(69) 1.5Mb 340ms DropTail
$ns duplex-link $n(65) $n(67) 1.5Mb 700ms DropTail
$ns duplex-link $n(65) $n(66) 1.5Mb 360ms DropTail
$ns duplex-link $n(66) $n(245) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "2830..."; flush stdout }
$ns duplex-link $n(66) $n(244) 1.5Mb 410ms DropTail
$ns duplex-link $n(66) $n(230) 1.5Mb 510ms DropTail
$ns duplex-link $n(66) $n(227) 1.5Mb 520ms DropTail
$ns duplex-link $n(66) $n(226) 1.5Mb 570ms DropTail
$ns duplex-link $n(66) $n(221) 1.5Mb 280ms DropTail
$ns duplex-link $n(66) $n(214) 1.5Mb 370ms DropTail
$ns duplex-link $n(66) $n(210) 1.5Mb 370ms DropTail
$ns duplex-link $n(66) $n(206) 1.5Mb 550ms DropTail
$ns duplex-link $n(66) $n(199) 1.5Mb 660ms DropTail
$ns duplex-link $n(66) $n(195) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "2840..."; flush stdout }
$ns duplex-link $n(66) $n(194) 1.5Mb 440ms DropTail
$ns duplex-link $n(66) $n(193) 1.5Mb 670ms DropTail
$ns duplex-link $n(66) $n(188) 1.5Mb 360ms DropTail
$ns duplex-link $n(66) $n(182) 1.5Mb 450ms DropTail
$ns duplex-link $n(66) $n(176) 1.5Mb 160ms DropTail
$ns duplex-link $n(66) $n(175) 1.5Mb 300ms DropTail
$ns duplex-link $n(66) $n(169) 1.5Mb 450ms DropTail
$ns duplex-link $n(66) $n(166) 1.5Mb 590ms DropTail
$ns duplex-link $n(66) $n(165) 1.5Mb 580ms DropTail
$ns duplex-link $n(66) $n(161) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "2850..."; flush stdout }
$ns duplex-link $n(66) $n(153) 1.5Mb 540ms DropTail
$ns duplex-link $n(66) $n(148) 1.5Mb 90ms DropTail
$ns duplex-link $n(66) $n(147) 1.5Mb 190ms DropTail
$ns duplex-link $n(66) $n(143) 1.5Mb 520ms DropTail
$ns duplex-link $n(66) $n(142) 1.5Mb 410ms DropTail
$ns duplex-link $n(66) $n(138) 1.5Mb 330ms DropTail
$ns duplex-link $n(66) $n(135) 1.5Mb 340ms DropTail
$ns duplex-link $n(66) $n(133) 1.5Mb 410ms DropTail
$ns duplex-link $n(66) $n(132) 1.5Mb 10ms DropTail
$ns duplex-link $n(66) $n(124) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "2860..."; flush stdout }
$ns duplex-link $n(66) $n(116) 1.5Mb 690ms DropTail
$ns duplex-link $n(66) $n(113) 1.5Mb 460ms DropTail
$ns duplex-link $n(66) $n(110) 1.5Mb 300ms DropTail
$ns duplex-link $n(66) $n(108) 1.5Mb 40ms DropTail
$ns duplex-link $n(66) $n(107) 1.5Mb 200ms DropTail
$ns duplex-link $n(66) $n(103) 1.5Mb 570ms DropTail
$ns duplex-link $n(66) $n(99) 1.5Mb 520ms DropTail
$ns duplex-link $n(66) $n(91) 1.5Mb 380ms DropTail
$ns duplex-link $n(66) $n(87) 1.5Mb 280ms DropTail
$ns duplex-link $n(66) $n(79) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "2870..."; flush stdout }
$ns duplex-link $n(66) $n(68) 1.5Mb 400ms DropTail
$ns duplex-link $n(67) $n(249) 1.5Mb 670ms DropTail
$ns duplex-link $n(67) $n(240) 1.5Mb 930ms DropTail
$ns duplex-link $n(67) $n(235) 1.5Mb 790ms DropTail
$ns duplex-link $n(67) $n(234) 1.5Mb 550ms DropTail
$ns duplex-link $n(67) $n(225) 1.5Mb 190ms DropTail
$ns duplex-link $n(67) $n(212) 1.5Mb 450ms DropTail
$ns duplex-link $n(67) $n(211) 1.5Mb 690ms DropTail
$ns duplex-link $n(67) $n(208) 1.5Mb 140ms DropTail
$ns duplex-link $n(67) $n(207) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "2880..."; flush stdout }
$ns duplex-link $n(67) $n(203) 1.5Mb 970ms DropTail
$ns duplex-link $n(67) $n(201) 1.5Mb 190ms DropTail
$ns duplex-link $n(67) $n(186) 1.5Mb 270ms DropTail
$ns duplex-link $n(67) $n(185) 1.5Mb 630ms DropTail
$ns duplex-link $n(67) $n(170) 1.5Mb 310ms DropTail
$ns duplex-link $n(67) $n(166) 1.5Mb 690ms DropTail
$ns duplex-link $n(67) $n(165) 1.5Mb 230ms DropTail
$ns duplex-link $n(67) $n(158) 1.5Mb 110ms DropTail
$ns duplex-link $n(67) $n(154) 1.5Mb 730ms DropTail
$ns duplex-link $n(67) $n(149) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "2890..."; flush stdout }
$ns duplex-link $n(67) $n(147) 1.5Mb 490ms DropTail
$ns duplex-link $n(67) $n(144) 1.5Mb 630ms DropTail
$ns duplex-link $n(67) $n(137) 1.5Mb 400ms DropTail
$ns duplex-link $n(67) $n(136) 1.5Mb 130ms DropTail
$ns duplex-link $n(67) $n(134) 1.5Mb 710ms DropTail
$ns duplex-link $n(67) $n(133) 1.5Mb 480ms DropTail
$ns duplex-link $n(67) $n(122) 1.5Mb 640ms DropTail
$ns duplex-link $n(67) $n(119) 1.5Mb 710ms DropTail
$ns duplex-link $n(67) $n(106) 1.5Mb 430ms DropTail
$ns duplex-link $n(67) $n(105) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "2900..."; flush stdout }
$ns duplex-link $n(67) $n(103) 1.5Mb 220ms DropTail
$ns duplex-link $n(67) $n(100) 1.5Mb 750ms DropTail
$ns duplex-link $n(67) $n(99) 1.5Mb 850ms DropTail
$ns duplex-link $n(67) $n(96) 1.5Mb 360ms DropTail
$ns duplex-link $n(67) $n(94) 1.5Mb 380ms DropTail
$ns duplex-link $n(67) $n(92) 1.5Mb 550ms DropTail
$ns duplex-link $n(67) $n(88) 1.5Mb 440ms DropTail
$ns duplex-link $n(67) $n(85) 1.5Mb 250ms DropTail
$ns duplex-link $n(67) $n(79) 1.5Mb 510ms DropTail
$ns duplex-link $n(67) $n(71) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "2910..."; flush stdout }
$ns duplex-link $n(68) $n(237) 1.5Mb 800ms DropTail
$ns duplex-link $n(68) $n(228) 1.5Mb 520ms DropTail
$ns duplex-link $n(68) $n(227) 1.5Mb 710ms DropTail
$ns duplex-link $n(68) $n(222) 1.5Mb 640ms DropTail
$ns duplex-link $n(68) $n(211) 1.5Mb 690ms DropTail
$ns duplex-link $n(68) $n(209) 1.5Mb 480ms DropTail
$ns duplex-link $n(68) $n(206) 1.5Mb 660ms DropTail
$ns duplex-link $n(68) $n(201) 1.5Mb 410ms DropTail
$ns duplex-link $n(68) $n(200) 1.5Mb 180ms DropTail
$ns duplex-link $n(68) $n(199) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "2920..."; flush stdout }
$ns duplex-link $n(68) $n(195) 1.5Mb 370ms DropTail
$ns duplex-link $n(68) $n(190) 1.5Mb 800ms DropTail
$ns duplex-link $n(68) $n(185) 1.5Mb 670ms DropTail
$ns duplex-link $n(68) $n(178) 1.5Mb 440ms DropTail
$ns duplex-link $n(68) $n(173) 1.5Mb 680ms DropTail
$ns duplex-link $n(68) $n(167) 1.5Mb 690ms DropTail
$ns duplex-link $n(68) $n(165) 1.5Mb 460ms DropTail
$ns duplex-link $n(68) $n(162) 1.5Mb 260ms DropTail
$ns duplex-link $n(68) $n(152) 1.5Mb 470ms DropTail
$ns duplex-link $n(68) $n(132) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "2930..."; flush stdout }
$ns duplex-link $n(68) $n(130) 1.5Mb 350ms DropTail
$ns duplex-link $n(68) $n(124) 1.5Mb 190ms DropTail
$ns duplex-link $n(68) $n(123) 1.5Mb 760ms DropTail
$ns duplex-link $n(68) $n(122) 1.5Mb 640ms DropTail
$ns duplex-link $n(68) $n(108) 1.5Mb 400ms DropTail
$ns duplex-link $n(68) $n(105) 1.5Mb 570ms DropTail
$ns duplex-link $n(68) $n(104) 1.5Mb 350ms DropTail
$ns duplex-link $n(68) $n(92) 1.5Mb 810ms DropTail
$ns duplex-link $n(68) $n(89) 1.5Mb 850ms DropTail
$ns duplex-link $n(68) $n(88) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "2940..."; flush stdout }
$ns duplex-link $n(68) $n(87) 1.5Mb 180ms DropTail
$ns duplex-link $n(68) $n(83) 1.5Mb 590ms DropTail
$ns duplex-link $n(68) $n(78) 1.5Mb 400ms DropTail
$ns duplex-link $n(68) $n(76) 1.5Mb 300ms DropTail
$ns duplex-link $n(68) $n(75) 1.5Mb 380ms DropTail
$ns duplex-link $n(68) $n(74) 1.5Mb 560ms DropTail
$ns duplex-link $n(69) $n(246) 1.5Mb 90ms DropTail
$ns duplex-link $n(69) $n(232) 1.5Mb 450ms DropTail
$ns duplex-link $n(69) $n(231) 1.5Mb 390ms DropTail
$ns duplex-link $n(69) $n(226) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "2950..."; flush stdout }
$ns duplex-link $n(69) $n(218) 1.5Mb 470ms DropTail
$ns duplex-link $n(69) $n(217) 1.5Mb 420ms DropTail
$ns duplex-link $n(69) $n(202) 1.5Mb 470ms DropTail
$ns duplex-link $n(69) $n(194) 1.5Mb 530ms DropTail
$ns duplex-link $n(69) $n(185) 1.5Mb 360ms DropTail
$ns duplex-link $n(69) $n(184) 1.5Mb 290ms DropTail
$ns duplex-link $n(69) $n(182) 1.5Mb 330ms DropTail
$ns duplex-link $n(69) $n(180) 1.5Mb 560ms DropTail
$ns duplex-link $n(69) $n(166) 1.5Mb 480ms DropTail
$ns duplex-link $n(69) $n(163) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "2960..."; flush stdout }
$ns duplex-link $n(69) $n(159) 1.5Mb 340ms DropTail
$ns duplex-link $n(69) $n(151) 1.5Mb 300ms DropTail
$ns duplex-link $n(69) $n(145) 1.5Mb 330ms DropTail
$ns duplex-link $n(69) $n(144) 1.5Mb 420ms DropTail
$ns duplex-link $n(69) $n(142) 1.5Mb 480ms DropTail
$ns duplex-link $n(69) $n(140) 1.5Mb 410ms DropTail
$ns duplex-link $n(69) $n(139) 1.5Mb 340ms DropTail
$ns duplex-link $n(69) $n(133) 1.5Mb 520ms DropTail
$ns duplex-link $n(69) $n(130) 1.5Mb 410ms DropTail
$ns duplex-link $n(69) $n(129) 1.5Mb 60ms DropTail
if {$verbose} { puts -nonewline "2970..."; flush stdout }
$ns duplex-link $n(69) $n(116) 1.5Mb 720ms DropTail
$ns duplex-link $n(69) $n(115) 1.5Mb 380ms DropTail
$ns duplex-link $n(69) $n(110) 1.5Mb 360ms DropTail
$ns duplex-link $n(69) $n(107) 1.5Mb 290ms DropTail
$ns duplex-link $n(69) $n(101) 1.5Mb 470ms DropTail
$ns duplex-link $n(69) $n(99) 1.5Mb 480ms DropTail
$ns duplex-link $n(69) $n(98) 1.5Mb 360ms DropTail
$ns duplex-link $n(69) $n(97) 1.5Mb 70ms DropTail
$ns duplex-link $n(69) $n(96) 1.5Mb 140ms DropTail
$ns duplex-link $n(69) $n(91) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "2980..."; flush stdout }
$ns duplex-link $n(69) $n(88) 1.5Mb 150ms DropTail
$ns duplex-link $n(69) $n(80) 1.5Mb 340ms DropTail
$ns duplex-link $n(69) $n(72) 1.5Mb 160ms DropTail
$ns duplex-link $n(69) $n(70) 1.5Mb 310ms DropTail
$ns duplex-link $n(70) $n(248) 1.5Mb 750ms DropTail
$ns duplex-link $n(70) $n(244) 1.5Mb 630ms DropTail
$ns duplex-link $n(70) $n(243) 1.5Mb 370ms DropTail
$ns duplex-link $n(70) $n(239) 1.5Mb 160ms DropTail
$ns duplex-link $n(70) $n(231) 1.5Mb 480ms DropTail
$ns duplex-link $n(70) $n(230) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "2990..."; flush stdout }
$ns duplex-link $n(70) $n(219) 1.5Mb 510ms DropTail
$ns duplex-link $n(70) $n(213) 1.5Mb 160ms DropTail
$ns duplex-link $n(70) $n(209) 1.5Mb 570ms DropTail
$ns duplex-link $n(70) $n(208) 1.5Mb 450ms DropTail
$ns duplex-link $n(70) $n(205) 1.5Mb 340ms DropTail
$ns duplex-link $n(70) $n(201) 1.5Mb 500ms DropTail
$ns duplex-link $n(70) $n(194) 1.5Mb 850ms DropTail
$ns duplex-link $n(70) $n(191) 1.5Mb 280ms DropTail
$ns duplex-link $n(70) $n(190) 1.5Mb 850ms DropTail
$ns duplex-link $n(70) $n(189) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "3000..."; flush stdout }
$ns duplex-link $n(70) $n(182) 1.5Mb 170ms DropTail
$ns duplex-link $n(70) $n(178) 1.5Mb 450ms DropTail
$ns duplex-link $n(70) $n(174) 1.5Mb 850ms DropTail
$ns duplex-link $n(70) $n(172) 1.5Mb 870ms DropTail
$ns duplex-link $n(70) $n(159) 1.5Mb 50ms DropTail
$ns duplex-link $n(70) $n(158) 1.5Mb 390ms DropTail
$ns duplex-link $n(70) $n(156) 1.5Mb 400ms DropTail
$ns duplex-link $n(70) $n(154) 1.5Mb 480ms DropTail
$ns duplex-link $n(70) $n(151) 1.5Mb 580ms DropTail
$ns duplex-link $n(70) $n(145) 1.5Mb 10ms DropTail
if {$verbose} { puts -nonewline "3010..."; flush stdout }
$ns duplex-link $n(70) $n(143) 1.5Mb 260ms DropTail
$ns duplex-link $n(70) $n(134) 1.5Mb 290ms DropTail
$ns duplex-link $n(70) $n(128) 1.5Mb 810ms DropTail
$ns duplex-link $n(70) $n(126) 1.5Mb 90ms DropTail
$ns duplex-link $n(70) $n(123) 1.5Mb 770ms DropTail
$ns duplex-link $n(70) $n(121) 1.5Mb 320ms DropTail
$ns duplex-link $n(70) $n(120) 1.5Mb 700ms DropTail
$ns duplex-link $n(70) $n(110) 1.5Mb 530ms DropTail
$ns duplex-link $n(70) $n(103) 1.5Mb 500ms DropTail
$ns duplex-link $n(70) $n(100) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "3020..."; flush stdout }
$ns duplex-link $n(70) $n(90) 1.5Mb 640ms DropTail
$ns duplex-link $n(70) $n(89) 1.5Mb 830ms DropTail
$ns duplex-link $n(70) $n(82) 1.5Mb 400ms DropTail
$ns duplex-link $n(70) $n(80) 1.5Mb 660ms DropTail
$ns duplex-link $n(70) $n(76) 1.5Mb 220ms DropTail
$ns duplex-link $n(71) $n(237) 1.5Mb 440ms DropTail
$ns duplex-link $n(71) $n(231) 1.5Mb 560ms DropTail
$ns duplex-link $n(71) $n(218) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(214) 1.5Mb 590ms DropTail
$ns duplex-link $n(71) $n(213) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "3030..."; flush stdout }
$ns duplex-link $n(71) $n(209) 1.5Mb 690ms DropTail
$ns duplex-link $n(71) $n(208) 1.5Mb 450ms DropTail
$ns duplex-link $n(71) $n(206) 1.5Mb 330ms DropTail
$ns duplex-link $n(71) $n(198) 1.5Mb 820ms DropTail
$ns duplex-link $n(71) $n(191) 1.5Mb 270ms DropTail
$ns duplex-link $n(71) $n(188) 1.5Mb 510ms DropTail
$ns duplex-link $n(71) $n(187) 1.5Mb 80ms DropTail
$ns duplex-link $n(71) $n(186) 1.5Mb 550ms DropTail
$ns duplex-link $n(71) $n(185) 1.5Mb 390ms DropTail
$ns duplex-link $n(71) $n(182) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "3040..."; flush stdout }
$ns duplex-link $n(71) $n(181) 1.5Mb 620ms DropTail
$ns duplex-link $n(71) $n(177) 1.5Mb 400ms DropTail
$ns duplex-link $n(71) $n(176) 1.5Mb 410ms DropTail
$ns duplex-link $n(71) $n(175) 1.5Mb 560ms DropTail
$ns duplex-link $n(71) $n(162) 1.5Mb 310ms DropTail
$ns duplex-link $n(71) $n(159) 1.5Mb 320ms DropTail
$ns duplex-link $n(71) $n(143) 1.5Mb 290ms DropTail
$ns duplex-link $n(71) $n(140) 1.5Mb 300ms DropTail
$ns duplex-link $n(71) $n(139) 1.5Mb 410ms DropTail
$ns duplex-link $n(71) $n(138) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "3050..."; flush stdout }
$ns duplex-link $n(71) $n(136) 1.5Mb 470ms DropTail
$ns duplex-link $n(71) $n(123) 1.5Mb 520ms DropTail
$ns duplex-link $n(71) $n(110) 1.5Mb 530ms DropTail
$ns duplex-link $n(71) $n(106) 1.5Mb 110ms DropTail
$ns duplex-link $n(71) $n(102) 1.5Mb 190ms DropTail
$ns duplex-link $n(71) $n(101) 1.5Mb 440ms DropTail
$ns duplex-link $n(71) $n(100) 1.5Mb 290ms DropTail
$ns duplex-link $n(71) $n(90) 1.5Mb 450ms DropTail
$ns duplex-link $n(71) $n(86) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(84) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "3060..."; flush stdout }
$ns duplex-link $n(71) $n(82) 1.5Mb 310ms DropTail
$ns duplex-link $n(72) $n(245) 1.5Mb 600ms DropTail
$ns duplex-link $n(72) $n(242) 1.5Mb 830ms DropTail
$ns duplex-link $n(72) $n(232) 1.5Mb 310ms DropTail
$ns duplex-link $n(72) $n(207) 1.5Mb 340ms DropTail
$ns duplex-link $n(72) $n(206) 1.5Mb 450ms DropTail
$ns duplex-link $n(72) $n(192) 1.5Mb 480ms DropTail
$ns duplex-link $n(72) $n(189) 1.5Mb 600ms DropTail
$ns duplex-link $n(72) $n(188) 1.5Mb 600ms DropTail
$ns duplex-link $n(72) $n(178) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "3070..."; flush stdout }
$ns duplex-link $n(72) $n(174) 1.5Mb 710ms DropTail
$ns duplex-link $n(72) $n(172) 1.5Mb 710ms DropTail
$ns duplex-link $n(72) $n(167) 1.5Mb 480ms DropTail
$ns duplex-link $n(72) $n(162) 1.5Mb 230ms DropTail
$ns duplex-link $n(72) $n(157) 1.5Mb 350ms DropTail
$ns duplex-link $n(72) $n(153) 1.5Mb 690ms DropTail
$ns duplex-link $n(72) $n(144) 1.5Mb 260ms DropTail
$ns duplex-link $n(72) $n(133) 1.5Mb 680ms DropTail
$ns duplex-link $n(72) $n(132) 1.5Mb 260ms DropTail
$ns duplex-link $n(72) $n(131) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "3080..."; flush stdout }
$ns duplex-link $n(72) $n(128) 1.5Mb 640ms DropTail
$ns duplex-link $n(72) $n(125) 1.5Mb 380ms DropTail
$ns duplex-link $n(72) $n(124) 1.5Mb 350ms DropTail
$ns duplex-link $n(72) $n(121) 1.5Mb 260ms DropTail
$ns duplex-link $n(72) $n(116) 1.5Mb 780ms DropTail
$ns duplex-link $n(72) $n(114) 1.5Mb 280ms DropTail
$ns duplex-link $n(72) $n(105) 1.5Mb 550ms DropTail
$ns duplex-link $n(72) $n(104) 1.5Mb 200ms DropTail
$ns duplex-link $n(72) $n(102) 1.5Mb 250ms DropTail
$ns duplex-link $n(72) $n(101) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "3090..."; flush stdout }
$ns duplex-link $n(72) $n(95) 1.5Mb 350ms DropTail
$ns duplex-link $n(72) $n(86) 1.5Mb 240ms DropTail
$ns duplex-link $n(72) $n(84) 1.5Mb 390ms DropTail
$ns duplex-link $n(72) $n(78) 1.5Mb 310ms DropTail
$ns duplex-link $n(73) $n(246) 1.5Mb 360ms DropTail
$ns duplex-link $n(73) $n(240) 1.5Mb 300ms DropTail
$ns duplex-link $n(73) $n(239) 1.5Mb 370ms DropTail
$ns duplex-link $n(73) $n(236) 1.5Mb 190ms DropTail
$ns duplex-link $n(73) $n(235) 1.5Mb 180ms DropTail
$ns duplex-link $n(73) $n(234) 1.5Mb 100ms DropTail
if {$verbose} { puts -nonewline "3100..."; flush stdout }
$ns duplex-link $n(73) $n(231) 1.5Mb 670ms DropTail
$ns duplex-link $n(73) $n(229) 1.5Mb 570ms DropTail
$ns duplex-link $n(73) $n(227) 1.5Mb 210ms DropTail
$ns duplex-link $n(73) $n(219) 1.5Mb 80ms DropTail
$ns duplex-link $n(73) $n(216) 1.5Mb 440ms DropTail
$ns duplex-link $n(73) $n(215) 1.5Mb 290ms DropTail
$ns duplex-link $n(73) $n(214) 1.5Mb 690ms DropTail
$ns duplex-link $n(73) $n(212) 1.5Mb 300ms DropTail
$ns duplex-link $n(73) $n(210) 1.5Mb 600ms DropTail
$ns duplex-link $n(73) $n(208) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "3110..."; flush stdout }
$ns duplex-link $n(73) $n(207) 1.5Mb 370ms DropTail
$ns duplex-link $n(73) $n(205) 1.5Mb 290ms DropTail
$ns duplex-link $n(73) $n(203) 1.5Mb 370ms DropTail
$ns duplex-link $n(73) $n(202) 1.5Mb 550ms DropTail
$ns duplex-link $n(73) $n(200) 1.5Mb 470ms DropTail
$ns duplex-link $n(73) $n(192) 1.5Mb 750ms DropTail
$ns duplex-link $n(73) $n(191) 1.5Mb 370ms DropTail
$ns duplex-link $n(73) $n(189) 1.5Mb 320ms DropTail
$ns duplex-link $n(73) $n(187) 1.5Mb 200ms DropTail
$ns duplex-link $n(73) $n(186) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "3120..."; flush stdout }
$ns duplex-link $n(73) $n(184) 1.5Mb 550ms DropTail
$ns duplex-link $n(73) $n(161) 1.5Mb 740ms DropTail
$ns duplex-link $n(73) $n(160) 1.5Mb 450ms DropTail
$ns duplex-link $n(73) $n(156) 1.5Mb 540ms DropTail
$ns duplex-link $n(73) $n(154) 1.5Mb 130ms DropTail
$ns duplex-link $n(73) $n(153) 1.5Mb 420ms DropTail
$ns duplex-link $n(73) $n(147) 1.5Mb 360ms DropTail
$ns duplex-link $n(73) $n(146) 1.5Mb 470ms DropTail
$ns duplex-link $n(73) $n(143) 1.5Mb 390ms DropTail
$ns duplex-link $n(73) $n(137) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "3130..."; flush stdout }
$ns duplex-link $n(73) $n(135) 1.5Mb 620ms DropTail
$ns duplex-link $n(73) $n(129) 1.5Mb 300ms DropTail
$ns duplex-link $n(73) $n(128) 1.5Mb 440ms DropTail
$ns duplex-link $n(73) $n(126) 1.5Mb 480ms DropTail
$ns duplex-link $n(73) $n(124) 1.5Mb 630ms DropTail
$ns duplex-link $n(73) $n(119) 1.5Mb 800ms DropTail
$ns duplex-link $n(73) $n(111) 1.5Mb 700ms DropTail
$ns duplex-link $n(73) $n(109) 1.5Mb 340ms DropTail
$ns duplex-link $n(73) $n(99) 1.5Mb 200ms DropTail
$ns duplex-link $n(73) $n(98) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "3140..."; flush stdout }
$ns duplex-link $n(73) $n(97) 1.5Mb 300ms DropTail
$ns duplex-link $n(73) $n(83) 1.5Mb 130ms DropTail
$ns duplex-link $n(73) $n(78) 1.5Mb 430ms DropTail
$ns duplex-link $n(73) $n(75) 1.5Mb 290ms DropTail
$ns duplex-link $n(74) $n(249) 1.5Mb 470ms DropTail
$ns duplex-link $n(74) $n(245) 1.5Mb 890ms DropTail
$ns duplex-link $n(74) $n(243) 1.5Mb 480ms DropTail
$ns duplex-link $n(74) $n(239) 1.5Mb 510ms DropTail
$ns duplex-link $n(74) $n(234) 1.5Mb 620ms DropTail
$ns duplex-link $n(74) $n(233) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "3150..."; flush stdout }
$ns duplex-link $n(74) $n(225) 1.5Mb 360ms DropTail
$ns duplex-link $n(74) $n(219) 1.5Mb 650ms DropTail
$ns duplex-link $n(74) $n(217) 1.5Mb 560ms DropTail
$ns duplex-link $n(74) $n(204) 1.5Mb 420ms DropTail
$ns duplex-link $n(74) $n(202) 1.5Mb 420ms DropTail
$ns duplex-link $n(74) $n(186) 1.5Mb 110ms DropTail
$ns duplex-link $n(74) $n(184) 1.5Mb 170ms DropTail
$ns duplex-link $n(74) $n(180) 1.5Mb 580ms DropTail
$ns duplex-link $n(74) $n(178) 1.5Mb 430ms DropTail
$ns duplex-link $n(74) $n(152) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "3160..."; flush stdout }
$ns duplex-link $n(74) $n(139) 1.5Mb 480ms DropTail
$ns duplex-link $n(74) $n(137) 1.5Mb 230ms DropTail
$ns duplex-link $n(74) $n(130) 1.5Mb 260ms DropTail
$ns duplex-link $n(74) $n(127) 1.5Mb 160ms DropTail
$ns duplex-link $n(74) $n(122) 1.5Mb 610ms DropTail
$ns duplex-link $n(74) $n(114) 1.5Mb 850ms DropTail
$ns duplex-link $n(74) $n(112) 1.5Mb 580ms DropTail
$ns duplex-link $n(74) $n(107) 1.5Mb 470ms DropTail
$ns duplex-link $n(74) $n(101) 1.5Mb 740ms DropTail
$ns duplex-link $n(74) $n(96) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "3170..."; flush stdout }
$ns duplex-link $n(74) $n(95) 1.5Mb 230ms DropTail
$ns duplex-link $n(74) $n(90) 1.5Mb 380ms DropTail
$ns duplex-link $n(74) $n(83) 1.5Mb 830ms DropTail
$ns duplex-link $n(74) $n(79) 1.5Mb 530ms DropTail
$ns duplex-link $n(75) $n(246) 1.5Mb 350ms DropTail
$ns duplex-link $n(75) $n(242) 1.5Mb 960ms DropTail
$ns duplex-link $n(75) $n(229) 1.5Mb 780ms DropTail
$ns duplex-link $n(75) $n(227) 1.5Mb 380ms DropTail
$ns duplex-link $n(75) $n(219) 1.5Mb 350ms DropTail
$ns duplex-link $n(75) $n(217) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "3180..."; flush stdout }
$ns duplex-link $n(75) $n(209) 1.5Mb 810ms DropTail
$ns duplex-link $n(75) $n(202) 1.5Mb 780ms DropTail
$ns duplex-link $n(75) $n(201) 1.5Mb 770ms DropTail
$ns duplex-link $n(75) $n(199) 1.5Mb 230ms DropTail
$ns duplex-link $n(75) $n(198) 1.5Mb 1020ms DropTail
$ns duplex-link $n(75) $n(176) 1.5Mb 610ms DropTail
$ns duplex-link $n(75) $n(171) 1.5Mb 690ms DropTail
$ns duplex-link $n(75) $n(139) 1.5Mb 610ms DropTail
$ns duplex-link $n(75) $n(138) 1.5Mb 780ms DropTail
$ns duplex-link $n(75) $n(137) 1.5Mb 750ms DropTail
if {$verbose} { puts -nonewline "3190..."; flush stdout }
$ns duplex-link $n(75) $n(135) 1.5Mb 600ms DropTail
$ns duplex-link $n(75) $n(129) 1.5Mb 400ms DropTail
$ns duplex-link $n(75) $n(119) 1.5Mb 1030ms DropTail
$ns duplex-link $n(75) $n(108) 1.5Mb 420ms DropTail
$ns duplex-link $n(75) $n(107) 1.5Mb 560ms DropTail
$ns duplex-link $n(75) $n(84) 1.5Mb 590ms DropTail
$ns duplex-link $n(75) $n(83) 1.5Mb 260ms DropTail
$ns duplex-link $n(75) $n(76) 1.5Mb 90ms DropTail
$ns duplex-link $n(76) $n(249) 1.5Mb 960ms DropTail
$ns duplex-link $n(76) $n(244) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "3200..."; flush stdout }
$ns duplex-link $n(76) $n(237) 1.5Mb 630ms DropTail
$ns duplex-link $n(76) $n(233) 1.5Mb 540ms DropTail
$ns duplex-link $n(76) $n(223) 1.5Mb 230ms DropTail
$ns duplex-link $n(76) $n(220) 1.5Mb 780ms DropTail
$ns duplex-link $n(76) $n(212) 1.5Mb 170ms DropTail
$ns duplex-link $n(76) $n(211) 1.5Mb 590ms DropTail
$ns duplex-link $n(76) $n(199) 1.5Mb 210ms DropTail
$ns duplex-link $n(76) $n(195) 1.5Mb 90ms DropTail
$ns duplex-link $n(76) $n(186) 1.5Mb 700ms DropTail
$ns duplex-link $n(76) $n(184) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "3210..."; flush stdout }
$ns duplex-link $n(76) $n(179) 1.5Mb 70ms DropTail
$ns duplex-link $n(76) $n(175) 1.5Mb 740ms DropTail
$ns duplex-link $n(76) $n(165) 1.5Mb 750ms DropTail
$ns duplex-link $n(76) $n(153) 1.5Mb 770ms DropTail
$ns duplex-link $n(76) $n(148) 1.5Mb 490ms DropTail
$ns duplex-link $n(76) $n(146) 1.5Mb 410ms DropTail
$ns duplex-link $n(76) $n(139) 1.5Mb 640ms DropTail
$ns duplex-link $n(76) $n(133) 1.5Mb 860ms DropTail
$ns duplex-link $n(76) $n(125) 1.5Mb 510ms DropTail
$ns duplex-link $n(76) $n(120) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "3220..."; flush stdout }
$ns duplex-link $n(76) $n(114) 1.5Mb 100ms DropTail
$ns duplex-link $n(76) $n(105) 1.5Mb 740ms DropTail
$ns duplex-link $n(76) $n(98) 1.5Mb 660ms DropTail
$ns duplex-link $n(76) $n(95) 1.5Mb 530ms DropTail
$ns duplex-link $n(76) $n(92) 1.5Mb 910ms DropTail
$ns duplex-link $n(76) $n(88) 1.5Mb 450ms DropTail
$ns duplex-link $n(76) $n(82) 1.5Mb 190ms DropTail
$ns duplex-link $n(76) $n(77) 1.5Mb 350ms DropTail
$ns duplex-link $n(77) $n(249) 1.5Mb 840ms DropTail
$ns duplex-link $n(77) $n(245) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "3230..."; flush stdout }
$ns duplex-link $n(77) $n(241) 1.5Mb 390ms DropTail
$ns duplex-link $n(77) $n(239) 1.5Mb 160ms DropTail
$ns duplex-link $n(77) $n(218) 1.5Mb 480ms DropTail
$ns duplex-link $n(77) $n(214) 1.5Mb 390ms DropTail
$ns duplex-link $n(77) $n(210) 1.5Mb 120ms DropTail
$ns duplex-link $n(77) $n(209) 1.5Mb 410ms DropTail
$ns duplex-link $n(77) $n(205) 1.5Mb 300ms DropTail
$ns duplex-link $n(77) $n(200) 1.5Mb 250ms DropTail
$ns duplex-link $n(77) $n(194) 1.5Mb 800ms DropTail
$ns duplex-link $n(77) $n(192) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "3240..."; flush stdout }
$ns duplex-link $n(77) $n(182) 1.5Mb 310ms DropTail
$ns duplex-link $n(77) $n(181) 1.5Mb 890ms DropTail
$ns duplex-link $n(77) $n(177) 1.5Mb 760ms DropTail
$ns duplex-link $n(77) $n(168) 1.5Mb 360ms DropTail
$ns duplex-link $n(77) $n(167) 1.5Mb 720ms DropTail
$ns duplex-link $n(77) $n(149) 1.5Mb 650ms DropTail
$ns duplex-link $n(77) $n(148) 1.5Mb 330ms DropTail
$ns duplex-link $n(77) $n(128) 1.5Mb 780ms DropTail
$ns duplex-link $n(77) $n(126) 1.5Mb 250ms DropTail
$ns duplex-link $n(77) $n(118) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "3250..."; flush stdout }
$ns duplex-link $n(77) $n(117) 1.5Mb 600ms DropTail
$ns duplex-link $n(77) $n(113) 1.5Mb 710ms DropTail
$ns duplex-link $n(77) $n(101) 1.5Mb 760ms DropTail
$ns duplex-link $n(77) $n(95) 1.5Mb 270ms DropTail
$ns duplex-link $n(78) $n(240) 1.5Mb 650ms DropTail
$ns duplex-link $n(78) $n(229) 1.5Mb 910ms DropTail
$ns duplex-link $n(78) $n(221) 1.5Mb 700ms DropTail
$ns duplex-link $n(78) $n(212) 1.5Mb 300ms DropTail
$ns duplex-link $n(78) $n(208) 1.5Mb 700ms DropTail
$ns duplex-link $n(78) $n(207) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "3260..."; flush stdout }
$ns duplex-link $n(78) $n(204) 1.5Mb 600ms DropTail
$ns duplex-link $n(78) $n(201) 1.5Mb 810ms DropTail
$ns duplex-link $n(78) $n(193) 1.5Mb 120ms DropTail
$ns duplex-link $n(78) $n(191) 1.5Mb 70ms DropTail
$ns duplex-link $n(78) $n(188) 1.5Mb 850ms DropTail
$ns duplex-link $n(78) $n(181) 1.5Mb 930ms DropTail
$ns duplex-link $n(78) $n(179) 1.5Mb 80ms DropTail
$ns duplex-link $n(78) $n(164) 1.5Mb 140ms DropTail
$ns duplex-link $n(78) $n(154) 1.5Mb 350ms DropTail
$ns duplex-link $n(78) $n(142) 1.5Mb 900ms DropTail
if {$verbose} { puts -nonewline "3270..."; flush stdout }
$ns duplex-link $n(78) $n(140) 1.5Mb 530ms DropTail
$ns duplex-link $n(78) $n(139) 1.5Mb 750ms DropTail
$ns duplex-link $n(78) $n(137) 1.5Mb 870ms DropTail
$ns duplex-link $n(78) $n(133) 1.5Mb 990ms DropTail
$ns duplex-link $n(78) $n(132) 1.5Mb 560ms DropTail
$ns duplex-link $n(78) $n(127) 1.5Mb 860ms DropTail
$ns duplex-link $n(78) $n(126) 1.5Mb 230ms DropTail
$ns duplex-link $n(78) $n(118) 1.5Mb 800ms DropTail
$ns duplex-link $n(78) $n(117) 1.5Mb 640ms DropTail
$ns duplex-link $n(78) $n(113) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "3280..."; flush stdout }
$ns duplex-link $n(78) $n(108) 1.5Mb 540ms DropTail
$ns duplex-link $n(78) $n(104) 1.5Mb 500ms DropTail
$ns duplex-link $n(78) $n(99) 1.5Mb 490ms DropTail
$ns duplex-link $n(78) $n(91) 1.5Mb 380ms DropTail
$ns duplex-link $n(78) $n(88) 1.5Mb 570ms DropTail
$ns duplex-link $n(78) $n(82) 1.5Mb 140ms DropTail
$ns duplex-link $n(79) $n(249) 1.5Mb 550ms DropTail
$ns duplex-link $n(79) $n(244) 1.5Mb 570ms DropTail
$ns duplex-link $n(79) $n(240) 1.5Mb 420ms DropTail
$ns duplex-link $n(79) $n(218) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "3290..."; flush stdout }
$ns duplex-link $n(79) $n(211) 1.5Mb 200ms DropTail
$ns duplex-link $n(79) $n(207) 1.5Mb 190ms DropTail
$ns duplex-link $n(79) $n(206) 1.5Mb 420ms DropTail
$ns duplex-link $n(79) $n(201) 1.5Mb 700ms DropTail
$ns duplex-link $n(79) $n(200) 1.5Mb 500ms DropTail
$ns duplex-link $n(79) $n(182) 1.5Mb 450ms DropTail
$ns duplex-link $n(79) $n(180) 1.5Mb 420ms DropTail
$ns duplex-link $n(79) $n(176) 1.5Mb 250ms DropTail
$ns duplex-link $n(79) $n(172) 1.5Mb 420ms DropTail
$ns duplex-link $n(79) $n(168) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "3300..."; flush stdout }
$ns duplex-link $n(79) $n(165) 1.5Mb 740ms DropTail
$ns duplex-link $n(79) $n(147) 1.5Mb 190ms DropTail
$ns duplex-link $n(79) $n(144) 1.5Mb 530ms DropTail
$ns duplex-link $n(79) $n(140) 1.5Mb 270ms DropTail
$ns duplex-link $n(79) $n(139) 1.5Mb 210ms DropTail
$ns duplex-link $n(79) $n(135) 1.5Mb 500ms DropTail
$ns duplex-link $n(79) $n(125) 1.5Mb 560ms DropTail
$ns duplex-link $n(79) $n(121) 1.5Mb 330ms DropTail
$ns duplex-link $n(79) $n(120) 1.5Mb 350ms DropTail
$ns duplex-link $n(79) $n(115) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "3310..."; flush stdout }
$ns duplex-link $n(79) $n(111) 1.5Mb 530ms DropTail
$ns duplex-link $n(79) $n(107) 1.5Mb 160ms DropTail
$ns duplex-link $n(79) $n(105) 1.5Mb 470ms DropTail
$ns duplex-link $n(79) $n(101) 1.5Mb 290ms DropTail
$ns duplex-link $n(79) $n(94) 1.5Mb 150ms DropTail
$ns duplex-link $n(79) $n(84) 1.5Mb 580ms DropTail
$ns duplex-link $n(79) $n(83) 1.5Mb 320ms DropTail
$ns duplex-link $n(79) $n(82) 1.5Mb 500ms DropTail
$ns duplex-link $n(79) $n(81) 1.5Mb 170ms DropTail
$ns duplex-link $n(80) $n(244) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "3320..."; flush stdout }
$ns duplex-link $n(80) $n(242) 1.5Mb 330ms DropTail
$ns duplex-link $n(80) $n(233) 1.5Mb 280ms DropTail
$ns duplex-link $n(80) $n(231) 1.5Mb 510ms DropTail
$ns duplex-link $n(80) $n(226) 1.5Mb 420ms DropTail
$ns duplex-link $n(80) $n(225) 1.5Mb 720ms DropTail
$ns duplex-link $n(80) $n(219) 1.5Mb 330ms DropTail
$ns duplex-link $n(80) $n(216) 1.5Mb 600ms DropTail
$ns duplex-link $n(80) $n(215) 1.5Mb 690ms DropTail
$ns duplex-link $n(80) $n(213) 1.5Mb 530ms DropTail
$ns duplex-link $n(80) $n(211) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "3330..."; flush stdout }
$ns duplex-link $n(80) $n(210) 1.5Mb 590ms DropTail
$ns duplex-link $n(80) $n(204) 1.5Mb 640ms DropTail
$ns duplex-link $n(80) $n(202) 1.5Mb 150ms DropTail
$ns duplex-link $n(80) $n(189) 1.5Mb 370ms DropTail
$ns duplex-link $n(80) $n(187) 1.5Mb 510ms DropTail
$ns duplex-link $n(80) $n(183) 1.5Mb 400ms DropTail
$ns duplex-link $n(80) $n(179) 1.5Mb 720ms DropTail
$ns duplex-link $n(80) $n(176) 1.5Mb 140ms DropTail
$ns duplex-link $n(80) $n(175) 1.5Mb 260ms DropTail
$ns duplex-link $n(80) $n(169) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "3340..."; flush stdout }
$ns duplex-link $n(80) $n(156) 1.5Mb 410ms DropTail
$ns duplex-link $n(80) $n(142) 1.5Mb 480ms DropTail
$ns duplex-link $n(80) $n(141) 1.5Mb 560ms DropTail
$ns duplex-link $n(80) $n(128) 1.5Mb 200ms DropTail
$ns duplex-link $n(80) $n(123) 1.5Mb 120ms DropTail
$ns duplex-link $n(80) $n(121) 1.5Mb 400ms DropTail
$ns duplex-link $n(80) $n(119) 1.5Mb 400ms DropTail
$ns duplex-link $n(80) $n(113) 1.5Mb 440ms DropTail
$ns duplex-link $n(80) $n(112) 1.5Mb 280ms DropTail
$ns duplex-link $n(80) $n(106) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "3350..."; flush stdout }
$ns duplex-link $n(80) $n(96) 1.5Mb 220ms DropTail
$ns duplex-link $n(80) $n(90) 1.5Mb 60ms DropTail
$ns duplex-link $n(81) $n(247) 1.5Mb 430ms DropTail
$ns duplex-link $n(81) $n(243) 1.5Mb 110ms DropTail
$ns duplex-link $n(81) $n(240) 1.5Mb 590ms DropTail
$ns duplex-link $n(81) $n(208) 1.5Mb 220ms DropTail
$ns duplex-link $n(81) $n(207) 1.5Mb 60ms DropTail
$ns duplex-link $n(81) $n(206) 1.5Mb 560ms DropTail
$ns duplex-link $n(81) $n(203) 1.5Mb 620ms DropTail
$ns duplex-link $n(81) $n(202) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "3360..."; flush stdout }
$ns duplex-link $n(81) $n(194) 1.5Mb 440ms DropTail
$ns duplex-link $n(81) $n(192) 1.5Mb 480ms DropTail
$ns duplex-link $n(81) $n(187) 1.5Mb 340ms DropTail
$ns duplex-link $n(81) $n(186) 1.5Mb 280ms DropTail
$ns duplex-link $n(81) $n(185) 1.5Mb 300ms DropTail
$ns duplex-link $n(81) $n(173) 1.5Mb 360ms DropTail
$ns duplex-link $n(81) $n(169) 1.5Mb 450ms DropTail
$ns duplex-link $n(81) $n(162) 1.5Mb 170ms DropTail
$ns duplex-link $n(81) $n(161) 1.5Mb 450ms DropTail
$ns duplex-link $n(81) $n(158) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "3370..."; flush stdout }
$ns duplex-link $n(81) $n(155) 1.5Mb 150ms DropTail
$ns duplex-link $n(81) $n(154) 1.5Mb 440ms DropTail
$ns duplex-link $n(81) $n(135) 1.5Mb 330ms DropTail
$ns duplex-link $n(81) $n(126) 1.5Mb 480ms DropTail
$ns duplex-link $n(81) $n(123) 1.5Mb 360ms DropTail
$ns duplex-link $n(81) $n(102) 1.5Mb 100ms DropTail
$ns duplex-link $n(81) $n(96) 1.5Mb 20ms DropTail
$ns duplex-link $n(82) $n(248) 1.5Mb 750ms DropTail
$ns duplex-link $n(82) $n(247) 1.5Mb 670ms DropTail
$ns duplex-link $n(82) $n(244) 1.5Mb 930ms DropTail
if {$verbose} { puts -nonewline "3380..."; flush stdout }
$ns duplex-link $n(82) $n(241) 1.5Mb 360ms DropTail
$ns duplex-link $n(82) $n(229) 1.5Mb 880ms DropTail
$ns duplex-link $n(82) $n(228) 1.5Mb 40ms DropTail
$ns duplex-link $n(82) $n(224) 1.5Mb 220ms DropTail
$ns duplex-link $n(82) $n(222) 1.5Mb 740ms DropTail
$ns duplex-link $n(82) $n(221) 1.5Mb 740ms DropTail
$ns duplex-link $n(82) $n(216) 1.5Mb 680ms DropTail
$ns duplex-link $n(82) $n(213) 1.5Mb 320ms DropTail
$ns duplex-link $n(82) $n(209) 1.5Mb 930ms DropTail
$ns duplex-link $n(82) $n(205) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "3390..."; flush stdout }
$ns duplex-link $n(82) $n(201) 1.5Mb 890ms DropTail
$ns duplex-link $n(82) $n(200) 1.5Mb 330ms DropTail
$ns duplex-link $n(82) $n(192) 1.5Mb 800ms DropTail
$ns duplex-link $n(82) $n(190) 1.5Mb 1030ms DropTail
$ns duplex-link $n(82) $n(186) 1.5Mb 850ms DropTail
$ns duplex-link $n(82) $n(184) 1.5Mb 740ms DropTail
$ns duplex-link $n(82) $n(174) 1.5Mb 980ms DropTail
$ns duplex-link $n(82) $n(170) 1.5Mb 460ms DropTail
$ns duplex-link $n(82) $n(160) 1.5Mb 510ms DropTail
$ns duplex-link $n(82) $n(149) 1.5Mb 970ms DropTail
if {$verbose} { puts -nonewline "3400..."; flush stdout }
$ns duplex-link $n(82) $n(147) 1.5Mb 680ms DropTail
$ns duplex-link $n(82) $n(145) 1.5Mb 400ms DropTail
$ns duplex-link $n(82) $n(143) 1.5Mb 150ms DropTail
$ns duplex-link $n(82) $n(135) 1.5Mb 720ms DropTail
$ns duplex-link $n(82) $n(133) 1.5Mb 970ms DropTail
$ns duplex-link $n(82) $n(123) 1.5Mb 800ms DropTail
$ns duplex-link $n(82) $n(122) 1.5Mb 580ms DropTail
$ns duplex-link $n(82) $n(114) 1.5Mb 180ms DropTail
$ns duplex-link $n(82) $n(110) 1.5Mb 810ms DropTail
$ns duplex-link $n(82) $n(104) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "3410..."; flush stdout }
$ns duplex-link $n(82) $n(103) 1.5Mb 890ms DropTail
$ns duplex-link $n(82) $n(93) 1.5Mb 660ms DropTail
$ns duplex-link $n(83) $n(249) 1.5Mb 850ms DropTail
$ns duplex-link $n(83) $n(247) 1.5Mb 730ms DropTail
$ns duplex-link $n(83) $n(246) 1.5Mb 450ms DropTail
$ns duplex-link $n(83) $n(245) 1.5Mb 300ms DropTail
$ns duplex-link $n(83) $n(240) 1.5Mb 270ms DropTail
$ns duplex-link $n(83) $n(238) 1.5Mb 440ms DropTail
$ns duplex-link $n(83) $n(236) 1.5Mb 290ms DropTail
$ns duplex-link $n(83) $n(235) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "3420..."; flush stdout }
$ns duplex-link $n(83) $n(234) 1.5Mb 210ms DropTail
$ns duplex-link $n(83) $n(233) 1.5Mb 300ms DropTail
$ns duplex-link $n(83) $n(230) 1.5Mb 80ms DropTail
$ns duplex-link $n(83) $n(224) 1.5Mb 230ms DropTail
$ns duplex-link $n(83) $n(219) 1.5Mb 210ms DropTail
$ns duplex-link $n(83) $n(218) 1.5Mb 380ms DropTail
$ns duplex-link $n(83) $n(212) 1.5Mb 350ms DropTail
$ns duplex-link $n(83) $n(206) 1.5Mb 100ms DropTail
$ns duplex-link $n(83) $n(203) 1.5Mb 350ms DropTail
$ns duplex-link $n(83) $n(200) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "3430..."; flush stdout }
$ns duplex-link $n(83) $n(198) 1.5Mb 920ms DropTail
$ns duplex-link $n(83) $n(195) 1.5Mb 360ms DropTail
$ns duplex-link $n(83) $n(190) 1.5Mb 870ms DropTail
$ns duplex-link $n(83) $n(184) 1.5Mb 670ms DropTail
$ns duplex-link $n(83) $n(182) 1.5Mb 400ms DropTail
$ns duplex-link $n(83) $n(180) 1.5Mb 670ms DropTail
$ns duplex-link $n(83) $n(169) 1.5Mb 700ms DropTail
$ns duplex-link $n(83) $n(165) 1.5Mb 970ms DropTail
$ns duplex-link $n(83) $n(157) 1.5Mb 680ms DropTail
$ns duplex-link $n(83) $n(151) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "3440..."; flush stdout }
$ns duplex-link $n(83) $n(149) 1.5Mb 820ms DropTail
$ns duplex-link $n(83) $n(147) 1.5Mb 490ms DropTail
$ns duplex-link $n(83) $n(140) 1.5Mb 150ms DropTail
$ns duplex-link $n(83) $n(131) 1.5Mb 70ms DropTail
$ns duplex-link $n(83) $n(126) 1.5Mb 500ms DropTail
$ns duplex-link $n(83) $n(125) 1.5Mb 740ms DropTail
$ns duplex-link $n(83) $n(118) 1.5Mb 730ms DropTail
$ns duplex-link $n(83) $n(115) 1.5Mb 770ms DropTail
$ns duplex-link $n(83) $n(108) 1.5Mb 410ms DropTail
$ns duplex-link $n(83) $n(106) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "3450..."; flush stdout }
$ns duplex-link $n(83) $n(102) 1.5Mb 360ms DropTail
$ns duplex-link $n(83) $n(100) 1.5Mb 160ms DropTail
$ns duplex-link $n(83) $n(97) 1.5Mb 400ms DropTail
$ns duplex-link $n(83) $n(95) 1.5Mb 650ms DropTail
$ns duplex-link $n(83) $n(93) 1.5Mb 740ms DropTail
$ns duplex-link $n(83) $n(91) 1.5Mb 70ms DropTail
$ns duplex-link $n(84) $n(248) 1.5Mb 790ms DropTail
$ns duplex-link $n(84) $n(243) 1.5Mb 470ms DropTail
$ns duplex-link $n(84) $n(231) 1.5Mb 240ms DropTail
$ns duplex-link $n(84) $n(230) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "3460..."; flush stdout }
$ns duplex-link $n(84) $n(227) 1.5Mb 870ms DropTail
$ns duplex-link $n(84) $n(226) 1.5Mb 810ms DropTail
$ns duplex-link $n(84) $n(222) 1.5Mb 650ms DropTail
$ns duplex-link $n(84) $n(218) 1.5Mb 640ms DropTail
$ns duplex-link $n(84) $n(213) 1.5Mb 400ms DropTail
$ns duplex-link $n(84) $n(204) 1.5Mb 30ms DropTail
$ns duplex-link $n(84) $n(198) 1.5Mb 900ms DropTail
$ns duplex-link $n(84) $n(194) 1.5Mb 870ms DropTail
$ns duplex-link $n(84) $n(190) 1.5Mb 710ms DropTail
$ns duplex-link $n(84) $n(186) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "3470..."; flush stdout }
$ns duplex-link $n(84) $n(185) 1.5Mb 730ms DropTail
$ns duplex-link $n(84) $n(182) 1.5Mb 470ms DropTail
$ns duplex-link $n(84) $n(179) 1.5Mb 540ms DropTail
$ns duplex-link $n(84) $n(175) 1.5Mb 540ms DropTail
$ns duplex-link $n(84) $n(173) 1.5Mb 780ms DropTail
$ns duplex-link $n(84) $n(172) 1.5Mb 860ms DropTail
$ns duplex-link $n(84) $n(171) 1.5Mb 110ms DropTail
$ns duplex-link $n(84) $n(165) 1.5Mb 240ms DropTail
$ns duplex-link $n(84) $n(146) 1.5Mb 220ms DropTail
$ns duplex-link $n(84) $n(144) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "3480..."; flush stdout }
$ns duplex-link $n(84) $n(143) 1.5Mb 570ms DropTail
$ns duplex-link $n(84) $n(141) 1.5Mb 230ms DropTail
$ns duplex-link $n(84) $n(139) 1.5Mb 680ms DropTail
$ns duplex-link $n(84) $n(129) 1.5Mb 420ms DropTail
$ns duplex-link $n(84) $n(121) 1.5Mb 260ms DropTail
$ns duplex-link $n(84) $n(120) 1.5Mb 640ms DropTail
$ns duplex-link $n(84) $n(113) 1.5Mb 850ms DropTail
$ns duplex-link $n(84) $n(111) 1.5Mb 370ms DropTail
$ns duplex-link $n(84) $n(104) 1.5Mb 430ms DropTail
$ns duplex-link $n(85) $n(246) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "3490..."; flush stdout }
$ns duplex-link $n(85) $n(245) 1.5Mb 650ms DropTail
$ns duplex-link $n(85) $n(233) 1.5Mb 450ms DropTail
$ns duplex-link $n(85) $n(230) 1.5Mb 610ms DropTail
$ns duplex-link $n(85) $n(227) 1.5Mb 620ms DropTail
$ns duplex-link $n(85) $n(224) 1.5Mb 390ms DropTail
$ns duplex-link $n(85) $n(215) 1.5Mb 620ms DropTail
$ns duplex-link $n(85) $n(207) 1.5Mb 120ms DropTail
$ns duplex-link $n(85) $n(204) 1.5Mb 320ms DropTail
$ns duplex-link $n(85) $n(202) 1.5Mb 410ms DropTail
$ns duplex-link $n(85) $n(199) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "3500..."; flush stdout }
$ns duplex-link $n(85) $n(192) 1.5Mb 380ms DropTail
$ns duplex-link $n(85) $n(189) 1.5Mb 590ms DropTail
$ns duplex-link $n(85) $n(177) 1.5Mb 590ms DropTail
$ns duplex-link $n(85) $n(176) 1.5Mb 190ms DropTail
$ns duplex-link $n(85) $n(175) 1.5Mb 280ms DropTail
$ns duplex-link $n(85) $n(172) 1.5Mb 520ms DropTail
$ns duplex-link $n(85) $n(167) 1.5Mb 640ms DropTail
$ns duplex-link $n(85) $n(162) 1.5Mb 90ms DropTail
$ns duplex-link $n(85) $n(144) 1.5Mb 540ms DropTail
$ns duplex-link $n(85) $n(141) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "3510..."; flush stdout }
$ns duplex-link $n(85) $n(129) 1.5Mb 110ms DropTail
$ns duplex-link $n(85) $n(126) 1.5Mb 460ms DropTail
$ns duplex-link $n(85) $n(121) 1.5Mb 90ms DropTail
$ns duplex-link $n(85) $n(101) 1.5Mb 540ms DropTail
$ns duplex-link $n(85) $n(94) 1.5Mb 140ms DropTail
$ns duplex-link $n(85) $n(90) 1.5Mb 280ms DropTail
$ns duplex-link $n(86) $n(242) 1.5Mb 1070ms DropTail
$ns duplex-link $n(86) $n(239) 1.5Mb 270ms DropTail
$ns duplex-link $n(86) $n(234) 1.5Mb 420ms DropTail
$ns duplex-link $n(86) $n(233) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "3520..."; flush stdout }
$ns duplex-link $n(86) $n(228) 1.5Mb 320ms DropTail
$ns duplex-link $n(86) $n(226) 1.5Mb 1060ms DropTail
$ns duplex-link $n(86) $n(224) 1.5Mb 280ms DropTail
$ns duplex-link $n(86) $n(222) 1.5Mb 740ms DropTail
$ns duplex-link $n(86) $n(220) 1.5Mb 890ms DropTail
$ns duplex-link $n(86) $n(219) 1.5Mb 530ms DropTail
$ns duplex-link $n(86) $n(214) 1.5Mb 680ms DropTail
$ns duplex-link $n(86) $n(211) 1.5Mb 710ms DropTail
$ns duplex-link $n(86) $n(209) 1.5Mb 720ms DropTail
$ns duplex-link $n(86) $n(202) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "3530..."; flush stdout }
$ns duplex-link $n(86) $n(199) 1.5Mb 230ms DropTail
$ns duplex-link $n(86) $n(197) 1.5Mb 110ms DropTail
$ns duplex-link $n(86) $n(190) 1.5Mb 960ms DropTail
$ns duplex-link $n(86) $n(189) 1.5Mb 800ms DropTail
$ns duplex-link $n(86) $n(187) 1.5Mb 280ms DropTail
$ns duplex-link $n(86) $n(183) 1.5Mb 790ms DropTail
$ns duplex-link $n(86) $n(178) 1.5Mb 520ms DropTail
$ns duplex-link $n(86) $n(177) 1.5Mb 720ms DropTail
$ns duplex-link $n(86) $n(173) 1.5Mb 680ms DropTail
$ns duplex-link $n(86) $n(172) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "3540..."; flush stdout }
$ns duplex-link $n(86) $n(169) 1.5Mb 350ms DropTail
$ns duplex-link $n(86) $n(168) 1.5Mb 660ms DropTail
$ns duplex-link $n(86) $n(166) 1.5Mb 120ms DropTail
$ns duplex-link $n(86) $n(164) 1.5Mb 200ms DropTail
$ns duplex-link $n(86) $n(160) 1.5Mb 320ms DropTail
$ns duplex-link $n(86) $n(156) 1.5Mb 540ms DropTail
$ns duplex-link $n(86) $n(154) 1.5Mb 440ms DropTail
$ns duplex-link $n(86) $n(147) 1.5Mb 690ms DropTail
$ns duplex-link $n(86) $n(138) 1.5Mb 820ms DropTail
$ns duplex-link $n(86) $n(132) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "3550..."; flush stdout }
$ns duplex-link $n(86) $n(130) 1.5Mb 590ms DropTail
$ns duplex-link $n(86) $n(122) 1.5Mb 660ms DropTail
$ns duplex-link $n(86) $n(121) 1.5Mb 450ms DropTail
$ns duplex-link $n(86) $n(118) 1.5Mb 680ms DropTail
$ns duplex-link $n(86) $n(115) 1.5Mb 670ms DropTail
$ns duplex-link $n(86) $n(107) 1.5Mb 680ms DropTail
$ns duplex-link $n(86) $n(106) 1.5Mb 300ms DropTail
$ns duplex-link $n(86) $n(102) 1.5Mb 490ms DropTail
$ns duplex-link $n(86) $n(94) 1.5Mb 550ms DropTail
$ns duplex-link $n(86) $n(87) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "3560..."; flush stdout }
$ns duplex-link $n(87) $n(249) 1.5Mb 730ms DropTail
$ns duplex-link $n(87) $n(237) 1.5Mb 750ms DropTail
$ns duplex-link $n(87) $n(233) 1.5Mb 600ms DropTail
$ns duplex-link $n(87) $n(232) 1.5Mb 520ms DropTail
$ns duplex-link $n(87) $n(231) 1.5Mb 230ms DropTail
$ns duplex-link $n(87) $n(229) 1.5Mb 560ms DropTail
$ns duplex-link $n(87) $n(226) 1.5Mb 720ms DropTail
$ns duplex-link $n(87) $n(222) 1.5Mb 490ms DropTail
$ns duplex-link $n(87) $n(216) 1.5Mb 930ms DropTail
$ns duplex-link $n(87) $n(209) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "3570..."; flush stdout }
$ns duplex-link $n(87) $n(208) 1.5Mb 200ms DropTail
$ns duplex-link $n(87) $n(204) 1.5Mb 140ms DropTail
$ns duplex-link $n(87) $n(197) 1.5Mb 440ms DropTail
$ns duplex-link $n(87) $n(196) 1.5Mb 420ms DropTail
$ns duplex-link $n(87) $n(187) 1.5Mb 390ms DropTail
$ns duplex-link $n(87) $n(186) 1.5Mb 360ms DropTail
$ns duplex-link $n(87) $n(185) 1.5Mb 570ms DropTail
$ns duplex-link $n(87) $n(180) 1.5Mb 720ms DropTail
$ns duplex-link $n(87) $n(178) 1.5Mb 330ms DropTail
$ns duplex-link $n(87) $n(169) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "3580..."; flush stdout }
$ns duplex-link $n(87) $n(167) 1.5Mb 720ms DropTail
$ns duplex-link $n(87) $n(165) 1.5Mb 360ms DropTail
$ns duplex-link $n(87) $n(164) 1.5Mb 440ms DropTail
$ns duplex-link $n(87) $n(161) 1.5Mb 250ms DropTail
$ns duplex-link $n(87) $n(156) 1.5Mb 160ms DropTail
$ns duplex-link $n(87) $n(154) 1.5Mb 570ms DropTail
$ns duplex-link $n(87) $n(153) 1.5Mb 810ms DropTail
$ns duplex-link $n(87) $n(152) 1.5Mb 400ms DropTail
$ns duplex-link $n(87) $n(151) 1.5Mb 520ms DropTail
$ns duplex-link $n(87) $n(147) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "3590..."; flush stdout }
$ns duplex-link $n(87) $n(128) 1.5Mb 690ms DropTail
$ns duplex-link $n(87) $n(121) 1.5Mb 100ms DropTail
$ns duplex-link $n(87) $n(118) 1.5Mb 310ms DropTail
$ns duplex-link $n(87) $n(107) 1.5Mb 480ms DropTail
$ns duplex-link $n(87) $n(106) 1.5Mb 260ms DropTail
$ns duplex-link $n(87) $n(102) 1.5Mb 330ms DropTail
$ns duplex-link $n(87) $n(96) 1.5Mb 290ms DropTail
$ns duplex-link $n(87) $n(93) 1.5Mb 180ms DropTail
$ns duplex-link $n(88) $n(249) 1.5Mb 510ms DropTail
$ns duplex-link $n(88) $n(246) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "3600..."; flush stdout }
$ns duplex-link $n(88) $n(235) 1.5Mb 360ms DropTail
$ns duplex-link $n(88) $n(232) 1.5Mb 570ms DropTail
$ns duplex-link $n(88) $n(222) 1.5Mb 200ms DropTail
$ns duplex-link $n(88) $n(220) 1.5Mb 380ms DropTail
$ns duplex-link $n(88) $n(215) 1.5Mb 520ms DropTail
$ns duplex-link $n(88) $n(212) 1.5Mb 300ms DropTail
$ns duplex-link $n(88) $n(209) 1.5Mb 580ms DropTail
$ns duplex-link $n(88) $n(203) 1.5Mb 530ms DropTail
$ns duplex-link $n(88) $n(202) 1.5Mb 340ms DropTail
$ns duplex-link $n(88) $n(197) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "3610..."; flush stdout }
$ns duplex-link $n(88) $n(193) 1.5Mb 670ms DropTail
$ns duplex-link $n(88) $n(190) 1.5Mb 490ms DropTail
$ns duplex-link $n(88) $n(189) 1.5Mb 400ms DropTail
$ns duplex-link $n(88) $n(187) 1.5Mb 320ms DropTail
$ns duplex-link $n(88) $n(184) 1.5Mb 310ms DropTail
$ns duplex-link $n(88) $n(171) 1.5Mb 560ms DropTail
$ns duplex-link $n(88) $n(167) 1.5Mb 490ms DropTail
$ns duplex-link $n(88) $n(165) 1.5Mb 670ms DropTail
$ns duplex-link $n(88) $n(164) 1.5Mb 430ms DropTail
$ns duplex-link $n(88) $n(159) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "3620..."; flush stdout }
$ns duplex-link $n(88) $n(156) 1.5Mb 320ms DropTail
$ns duplex-link $n(88) $n(144) 1.5Mb 550ms DropTail
$ns duplex-link $n(88) $n(126) 1.5Mb 510ms DropTail
$ns duplex-link $n(88) $n(124) 1.5Mb 480ms DropTail
$ns duplex-link $n(88) $n(120) 1.5Mb 290ms DropTail
$ns duplex-link $n(88) $n(119) 1.5Mb 590ms DropTail
$ns duplex-link $n(88) $n(115) 1.5Mb 400ms DropTail
$ns duplex-link $n(88) $n(110) 1.5Mb 370ms DropTail
$ns duplex-link $n(88) $n(102) 1.5Mb 50ms DropTail
$ns duplex-link $n(88) $n(99) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "3630..."; flush stdout }
$ns duplex-link $n(88) $n(90) 1.5Mb 210ms DropTail
$ns duplex-link $n(89) $n(247) 1.5Mb 900ms DropTail
$ns duplex-link $n(89) $n(246) 1.5Mb 630ms DropTail
$ns duplex-link $n(89) $n(239) 1.5Mb 680ms DropTail
$ns duplex-link $n(89) $n(235) 1.5Mb 300ms DropTail
$ns duplex-link $n(89) $n(230) 1.5Mb 480ms DropTail
$ns duplex-link $n(89) $n(229) 1.5Mb 400ms DropTail
$ns duplex-link $n(89) $n(228) 1.5Mb 790ms DropTail
$ns duplex-link $n(89) $n(223) 1.5Mb 830ms DropTail
$ns duplex-link $n(89) $n(222) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "3640..."; flush stdout }
$ns duplex-link $n(89) $n(217) 1.5Mb 160ms DropTail
$ns duplex-link $n(89) $n(215) 1.5Mb 680ms DropTail
$ns duplex-link $n(89) $n(206) 1.5Mb 560ms DropTail
$ns duplex-link $n(89) $n(199) 1.5Mb 920ms DropTail
$ns duplex-link $n(89) $n(193) 1.5Mb 900ms DropTail
$ns duplex-link $n(89) $n(190) 1.5Mb 580ms DropTail
$ns duplex-link $n(89) $n(188) 1.5Mb 190ms DropTail
$ns duplex-link $n(89) $n(187) 1.5Mb 600ms DropTail
$ns duplex-link $n(89) $n(185) 1.5Mb 180ms DropTail
$ns duplex-link $n(89) $n(177) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "3650..."; flush stdout }
$ns duplex-link $n(89) $n(173) 1.5Mb 200ms DropTail
$ns duplex-link $n(89) $n(169) 1.5Mb 910ms DropTail
$ns duplex-link $n(89) $n(168) 1.5Mb 830ms DropTail
$ns duplex-link $n(89) $n(167) 1.5Mb 520ms DropTail
$ns duplex-link $n(89) $n(164) 1.5Mb 710ms DropTail
$ns duplex-link $n(89) $n(151) 1.5Mb 260ms DropTail
$ns duplex-link $n(89) $n(150) 1.5Mb 330ms DropTail
$ns duplex-link $n(89) $n(149) 1.5Mb 580ms DropTail
$ns duplex-link $n(89) $n(146) 1.5Mb 690ms DropTail
$ns duplex-link $n(89) $n(145) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "3660..."; flush stdout }
$ns duplex-link $n(89) $n(140) 1.5Mb 350ms DropTail
$ns duplex-link $n(89) $n(134) 1.5Mb 890ms DropTail
$ns duplex-link $n(89) $n(124) 1.5Mb 870ms DropTail
$ns duplex-link $n(89) $n(120) 1.5Mb 410ms DropTail
$ns duplex-link $n(89) $n(117) 1.5Mb 220ms DropTail
$ns duplex-link $n(89) $n(110) 1.5Mb 690ms DropTail
$ns duplex-link $n(89) $n(108) 1.5Mb 460ms DropTail
$ns duplex-link $n(89) $n(107) 1.5Mb 270ms DropTail
$ns duplex-link $n(89) $n(105) 1.5Mb 650ms DropTail
$ns duplex-link $n(89) $n(92) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "3670..."; flush stdout }
$ns duplex-link $n(90) $n(244) 1.5Mb 430ms DropTail
$ns duplex-link $n(90) $n(238) 1.5Mb 490ms DropTail
$ns duplex-link $n(90) $n(237) 1.5Mb 470ms DropTail
$ns duplex-link $n(90) $n(235) 1.5Mb 470ms DropTail
$ns duplex-link $n(90) $n(228) 1.5Mb 790ms DropTail
$ns duplex-link $n(90) $n(223) 1.5Mb 640ms DropTail
$ns duplex-link $n(90) $n(217) 1.5Mb 180ms DropTail
$ns duplex-link $n(90) $n(213) 1.5Mb 530ms DropTail
$ns duplex-link $n(90) $n(212) 1.5Mb 500ms DropTail
$ns duplex-link $n(90) $n(197) 1.5Mb 710ms DropTail
if {$verbose} { puts -nonewline "3680..."; flush stdout }
$ns duplex-link $n(90) $n(193) 1.5Mb 870ms DropTail
$ns duplex-link $n(90) $n(192) 1.5Mb 640ms DropTail
$ns duplex-link $n(90) $n(189) 1.5Mb 430ms DropTail
$ns duplex-link $n(90) $n(184) 1.5Mb 310ms DropTail
$ns duplex-link $n(90) $n(183) 1.5Mb 340ms DropTail
$ns duplex-link $n(90) $n(173) 1.5Mb 340ms DropTail
$ns duplex-link $n(90) $n(171) 1.5Mb 620ms DropTail
$ns duplex-link $n(90) $n(170) 1.5Mb 500ms DropTail
$ns duplex-link $n(90) $n(158) 1.5Mb 580ms DropTail
$ns duplex-link $n(90) $n(157) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "3690..."; flush stdout }
$ns duplex-link $n(90) $n(156) 1.5Mb 370ms DropTail
$ns duplex-link $n(90) $n(132) 1.5Mb 240ms DropTail
$ns duplex-link $n(90) $n(126) 1.5Mb 700ms DropTail
$ns duplex-link $n(90) $n(122) 1.5Mb 260ms DropTail
$ns duplex-link $n(90) $n(117) 1.5Mb 250ms DropTail
$ns duplex-link $n(90) $n(112) 1.5Mb 310ms DropTail
$ns duplex-link $n(90) $n(110) 1.5Mb 340ms DropTail
$ns duplex-link $n(90) $n(105) 1.5Mb 300ms DropTail
$ns duplex-link $n(90) $n(104) 1.5Mb 300ms DropTail
$ns duplex-link $n(90) $n(102) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "3700..."; flush stdout }
$ns duplex-link $n(90) $n(99) 1.5Mb 600ms DropTail
$ns duplex-link $n(90) $n(98) 1.5Mb 310ms DropTail
$ns duplex-link $n(90) $n(97) 1.5Mb 410ms DropTail
$ns duplex-link $n(90) $n(93) 1.5Mb 640ms DropTail
$ns duplex-link $n(91) $n(222) 1.5Mb 490ms DropTail
$ns duplex-link $n(91) $n(218) 1.5Mb 380ms DropTail
$ns duplex-link $n(91) $n(213) 1.5Mb 320ms DropTail
$ns duplex-link $n(91) $n(211) 1.5Mb 320ms DropTail
$ns duplex-link $n(91) $n(204) 1.5Mb 670ms DropTail
$ns duplex-link $n(91) $n(203) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "3710..."; flush stdout }
$ns duplex-link $n(91) $n(201) 1.5Mb 850ms DropTail
$ns duplex-link $n(91) $n(197) 1.5Mb 360ms DropTail
$ns duplex-link $n(91) $n(194) 1.5Mb 570ms DropTail
$ns duplex-link $n(91) $n(184) 1.5Mb 600ms DropTail
$ns duplex-link $n(91) $n(178) 1.5Mb 330ms DropTail
$ns duplex-link $n(91) $n(177) 1.5Mb 260ms DropTail
$ns duplex-link $n(91) $n(176) 1.5Mb 500ms DropTail
$ns duplex-link $n(91) $n(174) 1.5Mb 740ms DropTail
$ns duplex-link $n(91) $n(169) 1.5Mb 640ms DropTail
$ns duplex-link $n(91) $n(167) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "3720..."; flush stdout }
$ns duplex-link $n(91) $n(166) 1.5Mb 450ms DropTail
$ns duplex-link $n(91) $n(163) 1.5Mb 330ms DropTail
$ns duplex-link $n(91) $n(162) 1.5Mb 470ms DropTail
$ns duplex-link $n(91) $n(156) 1.5Mb 590ms DropTail
$ns duplex-link $n(91) $n(152) 1.5Mb 220ms DropTail
$ns duplex-link $n(91) $n(151) 1.5Mb 240ms DropTail
$ns duplex-link $n(91) $n(149) 1.5Mb 760ms DropTail
$ns duplex-link $n(91) $n(141) 1.5Mb 760ms DropTail
$ns duplex-link $n(91) $n(140) 1.5Mb 150ms DropTail
$ns duplex-link $n(91) $n(139) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "3730..."; flush stdout }
$ns duplex-link $n(91) $n(136) 1.5Mb 620ms DropTail
$ns duplex-link $n(91) $n(132) 1.5Mb 370ms DropTail
$ns duplex-link $n(91) $n(128) 1.5Mb 510ms DropTail
$ns duplex-link $n(91) $n(122) 1.5Mb 300ms DropTail
$ns duplex-link $n(91) $n(120) 1.5Mb 600ms DropTail
$ns duplex-link $n(91) $n(118) 1.5Mb 660ms DropTail
$ns duplex-link $n(91) $n(104) 1.5Mb 320ms DropTail
$ns duplex-link $n(91) $n(101) 1.5Mb 360ms DropTail
$ns duplex-link $n(91) $n(97) 1.5Mb 330ms DropTail
$ns duplex-link $n(91) $n(96) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "3740..."; flush stdout }
$ns duplex-link $n(91) $n(92) 1.5Mb 790ms DropTail
$ns duplex-link $n(92) $n(249) 1.5Mb 150ms DropTail
$ns duplex-link $n(92) $n(247) 1.5Mb 730ms DropTail
$ns duplex-link $n(92) $n(242) 1.5Mb 250ms DropTail
$ns duplex-link $n(92) $n(240) 1.5Mb 860ms DropTail
$ns duplex-link $n(92) $n(229) 1.5Mb 160ms DropTail
$ns duplex-link $n(92) $n(222) 1.5Mb 310ms DropTail
$ns duplex-link $n(92) $n(221) 1.5Mb 490ms DropTail
$ns duplex-link $n(92) $n(210) 1.5Mb 680ms DropTail
$ns duplex-link $n(92) $n(209) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "3750..."; flush stdout }
$ns duplex-link $n(92) $n(207) 1.5Mb 400ms DropTail
$ns duplex-link $n(92) $n(199) 1.5Mb 1130ms DropTail
$ns duplex-link $n(92) $n(198) 1.5Mb 180ms DropTail
$ns duplex-link $n(92) $n(192) 1.5Mb 700ms DropTail
$ns duplex-link $n(92) $n(191) 1.5Mb 970ms DropTail
$ns duplex-link $n(92) $n(190) 1.5Mb 30ms DropTail
$ns duplex-link $n(92) $n(187) 1.5Mb 790ms DropTail
$ns duplex-link $n(92) $n(181) 1.5Mb 550ms DropTail
$ns duplex-link $n(92) $n(174) 1.5Mb 90ms DropTail
$ns duplex-link $n(92) $n(173) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "3760..."; flush stdout }
$ns duplex-link $n(92) $n(169) 1.5Mb 790ms DropTail
$ns duplex-link $n(92) $n(166) 1.5Mb 1050ms DropTail
$ns duplex-link $n(92) $n(165) 1.5Mb 700ms DropTail
$ns duplex-link $n(92) $n(156) 1.5Mb 480ms DropTail
$ns duplex-link $n(92) $n(153) 1.5Mb 660ms DropTail
$ns duplex-link $n(92) $n(151) 1.5Mb 580ms DropTail
$ns duplex-link $n(92) $n(147) 1.5Mb 360ms DropTail
$ns duplex-link $n(92) $n(144) 1.5Mb 1000ms DropTail
$ns duplex-link $n(92) $n(139) 1.5Mb 370ms DropTail
$ns duplex-link $n(92) $n(138) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "3770..."; flush stdout }
$ns duplex-link $n(92) $n(122) 1.5Mb 540ms DropTail
$ns duplex-link $n(92) $n(121) 1.5Mb 540ms DropTail
$ns duplex-link $n(92) $n(120) 1.5Mb 190ms DropTail
$ns duplex-link $n(92) $n(116) 1.5Mb 860ms DropTail
$ns duplex-link $n(92) $n(114) 1.5Mb 1010ms DropTail
$ns duplex-link $n(92) $n(112) 1.5Mb 600ms DropTail
$ns duplex-link $n(92) $n(103) 1.5Mb 730ms DropTail
$ns duplex-link $n(92) $n(95) 1.5Mb 480ms DropTail
$ns duplex-link $n(92) $n(93) 1.5Mb 770ms DropTail
$ns duplex-link $n(93) $n(247) 1.5Mb 40ms DropTail
if {$verbose} { puts -nonewline "3780..."; flush stdout }
$ns duplex-link $n(93) $n(244) 1.5Mb 460ms DropTail
$ns duplex-link $n(93) $n(232) 1.5Mb 560ms DropTail
$ns duplex-link $n(93) $n(230) 1.5Mb 820ms DropTail
$ns duplex-link $n(93) $n(218) 1.5Mb 590ms DropTail
$ns duplex-link $n(93) $n(216) 1.5Mb 1090ms DropTail
$ns duplex-link $n(93) $n(210) 1.5Mb 90ms DropTail
$ns duplex-link $n(93) $n(196) 1.5Mb 580ms DropTail
$ns duplex-link $n(93) $n(189) 1.5Mb 910ms DropTail
$ns duplex-link $n(93) $n(186) 1.5Mb 490ms DropTail
$ns duplex-link $n(93) $n(179) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "3790..."; flush stdout }
$ns duplex-link $n(93) $n(175) 1.5Mb 570ms DropTail
$ns duplex-link $n(93) $n(173) 1.5Mb 780ms DropTail
$ns duplex-link $n(93) $n(171) 1.5Mb 170ms DropTail
$ns duplex-link $n(93) $n(159) 1.5Mb 310ms DropTail
$ns duplex-link $n(93) $n(158) 1.5Mb 160ms DropTail
$ns duplex-link $n(93) $n(156) 1.5Mb 290ms DropTail
$ns duplex-link $n(93) $n(147) 1.5Mb 630ms DropTail
$ns duplex-link $n(93) $n(145) 1.5Mb 270ms DropTail
$ns duplex-link $n(93) $n(144) 1.5Mb 470ms DropTail
$ns duplex-link $n(93) $n(137) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "3800..."; flush stdout }
$ns duplex-link $n(93) $n(133) 1.5Mb 710ms DropTail
$ns duplex-link $n(93) $n(124) 1.5Mb 60ms DropTail
$ns duplex-link $n(93) $n(123) 1.5Mb 800ms DropTail
$ns duplex-link $n(93) $n(121) 1.5Mb 270ms DropTail
$ns duplex-link $n(93) $n(109) 1.5Mb 340ms DropTail
$ns duplex-link $n(93) $n(106) 1.5Mb 400ms DropTail
$ns duplex-link $n(93) $n(105) 1.5Mb 510ms DropTail
$ns duplex-link $n(93) $n(104) 1.5Mb 430ms DropTail
$ns duplex-link $n(93) $n(97) 1.5Mb 350ms DropTail
$ns duplex-link $n(94) $n(248) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "3810..."; flush stdout }
$ns duplex-link $n(94) $n(242) 1.5Mb 520ms DropTail
$ns duplex-link $n(94) $n(241) 1.5Mb 230ms DropTail
$ns duplex-link $n(94) $n(240) 1.5Mb 560ms DropTail
$ns duplex-link $n(94) $n(239) 1.5Mb 290ms DropTail
$ns duplex-link $n(94) $n(236) 1.5Mb 220ms DropTail
$ns duplex-link $n(94) $n(231) 1.5Mb 390ms DropTail
$ns duplex-link $n(94) $n(224) 1.5Mb 360ms DropTail
$ns duplex-link $n(94) $n(219) 1.5Mb 260ms DropTail
$ns duplex-link $n(94) $n(216) 1.5Mb 660ms DropTail
$ns duplex-link $n(94) $n(215) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "3820..."; flush stdout }
$ns duplex-link $n(94) $n(205) 1.5Mb 120ms DropTail
$ns duplex-link $n(94) $n(203) 1.5Mb 590ms DropTail
$ns duplex-link $n(94) $n(200) 1.5Mb 510ms DropTail
$ns duplex-link $n(94) $n(197) 1.5Mb 520ms DropTail
$ns duplex-link $n(94) $n(196) 1.5Mb 230ms DropTail
$ns duplex-link $n(94) $n(190) 1.5Mb 450ms DropTail
$ns duplex-link $n(94) $n(183) 1.5Mb 370ms DropTail
$ns duplex-link $n(94) $n(182) 1.5Mb 480ms DropTail
$ns duplex-link $n(94) $n(161) 1.5Mb 480ms DropTail
$ns duplex-link $n(94) $n(160) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "3830..."; flush stdout }
$ns duplex-link $n(94) $n(156) 1.5Mb 260ms DropTail
$ns duplex-link $n(94) $n(149) 1.5Mb 390ms DropTail
$ns duplex-link $n(94) $n(148) 1.5Mb 110ms DropTail
$ns duplex-link $n(94) $n(147) 1.5Mb 150ms DropTail
$ns duplex-link $n(94) $n(145) 1.5Mb 470ms DropTail
$ns duplex-link $n(94) $n(139) 1.5Mb 210ms DropTail
$ns duplex-link $n(94) $n(133) 1.5Mb 390ms DropTail
$ns duplex-link $n(94) $n(128) 1.5Mb 380ms DropTail
$ns duplex-link $n(94) $n(125) 1.5Mb 450ms DropTail
$ns duplex-link $n(94) $n(121) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "3840..."; flush stdout }
$ns duplex-link $n(94) $n(118) 1.5Mb 290ms DropTail
$ns duplex-link $n(94) $n(115) 1.5Mb 330ms DropTail
$ns duplex-link $n(94) $n(112) 1.5Mb 190ms DropTail
$ns duplex-link $n(94) $n(102) 1.5Mb 90ms DropTail
$ns duplex-link $n(94) $n(97) 1.5Mb 220ms DropTail
$ns duplex-link $n(95) $n(248) 1.5Mb 550ms DropTail
$ns duplex-link $n(95) $n(242) 1.5Mb 660ms DropTail
$ns duplex-link $n(95) $n(241) 1.5Mb 400ms DropTail
$ns duplex-link $n(95) $n(238) 1.5Mb 290ms DropTail
$ns duplex-link $n(95) $n(237) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "3850..."; flush stdout }
$ns duplex-link $n(95) $n(234) 1.5Mb 440ms DropTail
$ns duplex-link $n(95) $n(229) 1.5Mb 430ms DropTail
$ns duplex-link $n(95) $n(227) 1.5Mb 740ms DropTail
$ns duplex-link $n(95) $n(221) 1.5Mb 50ms DropTail
$ns duplex-link $n(95) $n(220) 1.5Mb 650ms DropTail
$ns duplex-link $n(95) $n(219) 1.5Mb 500ms DropTail
$ns duplex-link $n(95) $n(218) 1.5Mb 670ms DropTail
$ns duplex-link $n(95) $n(217) 1.5Mb 530ms DropTail
$ns duplex-link $n(95) $n(211) 1.5Mb 570ms DropTail
$ns duplex-link $n(95) $n(207) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "3860..."; flush stdout }
$ns duplex-link $n(95) $n(204) 1.5Mb 240ms DropTail
$ns duplex-link $n(95) $n(199) 1.5Mb 730ms DropTail
$ns duplex-link $n(95) $n(198) 1.5Mb 650ms DropTail
$ns duplex-link $n(95) $n(185) 1.5Mb 500ms DropTail
$ns duplex-link $n(95) $n(183) 1.5Mb 250ms DropTail
$ns duplex-link $n(95) $n(173) 1.5Mb 580ms DropTail
$ns duplex-link $n(95) $n(172) 1.5Mb 600ms DropTail
$ns duplex-link $n(95) $n(163) 1.5Mb 330ms DropTail
$ns duplex-link $n(95) $n(149) 1.5Mb 390ms DropTail
$ns duplex-link $n(95) $n(146) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "3870..."; flush stdout }
$ns duplex-link $n(95) $n(142) 1.5Mb 250ms DropTail
$ns duplex-link $n(95) $n(140) 1.5Mb 650ms DropTail
$ns duplex-link $n(95) $n(132) 1.5Mb 230ms DropTail
$ns duplex-link $n(95) $n(123) 1.5Mb 530ms DropTail
$ns duplex-link $n(95) $n(119) 1.5Mb 640ms DropTail
$ns duplex-link $n(95) $n(112) 1.5Mb 420ms DropTail
$ns duplex-link $n(95) $n(107) 1.5Mb 400ms DropTail
$ns duplex-link $n(95) $n(103) 1.5Mb 340ms DropTail
$ns duplex-link $n(95) $n(102) 1.5Mb 310ms DropTail
$ns duplex-link $n(95) $n(100) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "3880..."; flush stdout }
$ns duplex-link $n(95) $n(98) 1.5Mb 150ms DropTail
$ns duplex-link $n(96) $n(248) 1.5Mb 340ms DropTail
$ns duplex-link $n(96) $n(245) 1.5Mb 540ms DropTail
$ns duplex-link $n(96) $n(236) 1.5Mb 220ms DropTail
$ns duplex-link $n(96) $n(235) 1.5Mb 440ms DropTail
$ns duplex-link $n(96) $n(234) 1.5Mb 250ms DropTail
$ns duplex-link $n(96) $n(227) 1.5Mb 530ms DropTail
$ns duplex-link $n(96) $n(223) 1.5Mb 440ms DropTail
$ns duplex-link $n(96) $n(220) 1.5Mb 440ms DropTail
$ns duplex-link $n(96) $n(215) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "3890..."; flush stdout }
$ns duplex-link $n(96) $n(214) 1.5Mb 370ms DropTail
$ns duplex-link $n(96) $n(210) 1.5Mb 390ms DropTail
$ns duplex-link $n(96) $n(200) 1.5Mb 490ms DropTail
$ns duplex-link $n(96) $n(199) 1.5Mb 680ms DropTail
$ns duplex-link $n(96) $n(190) 1.5Mb 450ms DropTail
$ns duplex-link $n(96) $n(185) 1.5Mb 280ms DropTail
$ns duplex-link $n(96) $n(183) 1.5Mb 360ms DropTail
$ns duplex-link $n(96) $n(180) 1.5Mb 440ms DropTail
$ns duplex-link $n(96) $n(179) 1.5Mb 530ms DropTail
$ns duplex-link $n(96) $n(170) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "3900..."; flush stdout }
$ns duplex-link $n(96) $n(163) 1.5Mb 90ms DropTail
$ns duplex-link $n(96) $n(161) 1.5Mb 460ms DropTail
$ns duplex-link $n(96) $n(150) 1.5Mb 540ms DropTail
$ns duplex-link $n(96) $n(147) 1.5Mb 170ms DropTail
$ns duplex-link $n(96) $n(146) 1.5Mb 240ms DropTail
$ns duplex-link $n(96) $n(144) 1.5Mb 560ms DropTail
$ns duplex-link $n(96) $n(139) 1.5Mb 230ms DropTail
$ns duplex-link $n(96) $n(137) 1.5Mb 280ms DropTail
$ns duplex-link $n(96) $n(135) 1.5Mb 350ms DropTail
$ns duplex-link $n(96) $n(129) 1.5Mb 70ms DropTail
if {$verbose} { puts -nonewline "3910..."; flush stdout }
$ns duplex-link $n(96) $n(127) 1.5Mb 280ms DropTail
$ns duplex-link $n(96) $n(125) 1.5Mb 430ms DropTail
$ns duplex-link $n(96) $n(123) 1.5Mb 340ms DropTail
$ns duplex-link $n(96) $n(122) 1.5Mb 280ms DropTail
$ns duplex-link $n(96) $n(120) 1.5Mb 270ms DropTail
$ns duplex-link $n(96) $n(109) 1.5Mb 310ms DropTail
$ns duplex-link $n(96) $n(106) 1.5Mb 240ms DropTail
$ns duplex-link $n(96) $n(105) 1.5Mb 320ms DropTail
$ns duplex-link $n(96) $n(104) 1.5Mb 100ms DropTail
$ns duplex-link $n(96) $n(102) 1.5Mb 100ms DropTail
if {$verbose} { puts -nonewline "3920..."; flush stdout }
$ns duplex-link $n(96) $n(99) 1.5Mb 530ms DropTail
$ns duplex-link $n(96) $n(98) 1.5Mb 270ms DropTail
$ns duplex-link $n(97) $n(243) 1.5Mb 130ms DropTail
$ns duplex-link $n(97) $n(242) 1.5Mb 740ms DropTail
$ns duplex-link $n(97) $n(241) 1.5Mb 160ms DropTail
$ns duplex-link $n(97) $n(240) 1.5Mb 600ms DropTail
$ns duplex-link $n(97) $n(238) 1.5Mb 90ms DropTail
$ns duplex-link $n(97) $n(218) 1.5Mb 420ms DropTail
$ns duplex-link $n(97) $n(207) 1.5Mb 250ms DropTail
$ns duplex-link $n(97) $n(194) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "3930..."; flush stdout }
$ns duplex-link $n(97) $n(192) 1.5Mb 440ms DropTail
$ns duplex-link $n(97) $n(188) 1.5Mb 530ms DropTail
$ns duplex-link $n(97) $n(182) 1.5Mb 270ms DropTail
$ns duplex-link $n(97) $n(167) 1.5Mb 510ms DropTail
$ns duplex-link $n(97) $n(164) 1.5Mb 280ms DropTail
$ns duplex-link $n(97) $n(162) 1.5Mb 150ms DropTail
$ns duplex-link $n(97) $n(157) 1.5Mb 290ms DropTail
$ns duplex-link $n(97) $n(154) 1.5Mb 360ms DropTail
$ns duplex-link $n(97) $n(153) 1.5Mb 650ms DropTail
$ns duplex-link $n(97) $n(149) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "3940..."; flush stdout }
$ns duplex-link $n(97) $n(148) 1.5Mb 210ms DropTail
$ns duplex-link $n(97) $n(137) 1.5Mb 470ms DropTail
$ns duplex-link $n(97) $n(136) 1.5Mb 320ms DropTail
$ns duplex-link $n(97) $n(134) 1.5Mb 420ms DropTail
$ns duplex-link $n(97) $n(130) 1.5Mb 410ms DropTail
$ns duplex-link $n(97) $n(128) 1.5Mb 570ms DropTail
$ns duplex-link $n(97) $n(111) 1.5Mb 470ms DropTail
$ns duplex-link $n(97) $n(107) 1.5Mb 360ms DropTail
$ns duplex-link $n(97) $n(106) 1.5Mb 60ms DropTail
$ns duplex-link $n(97) $n(102) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "3950..."; flush stdout }
$ns duplex-link $n(97) $n(98) 1.5Mb 390ms DropTail
$ns duplex-link $n(98) $n(249) 1.5Mb 470ms DropTail
$ns duplex-link $n(98) $n(241) 1.5Mb 490ms DropTail
$ns duplex-link $n(98) $n(236) 1.5Mb 460ms DropTail
$ns duplex-link $n(98) $n(234) 1.5Mb 520ms DropTail
$ns duplex-link $n(98) $n(232) 1.5Mb 780ms DropTail
$ns duplex-link $n(98) $n(231) 1.5Mb 160ms DropTail
$ns duplex-link $n(98) $n(212) 1.5Mb 500ms DropTail
$ns duplex-link $n(98) $n(211) 1.5Mb 570ms DropTail
$ns duplex-link $n(98) $n(197) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "3960..."; flush stdout }
$ns duplex-link $n(98) $n(184) 1.5Mb 70ms DropTail
$ns duplex-link $n(98) $n(180) 1.5Mb 540ms DropTail
$ns duplex-link $n(98) $n(177) 1.5Mb 750ms DropTail
$ns duplex-link $n(98) $n(171) 1.5Mb 340ms DropTail
$ns duplex-link $n(98) $n(162) 1.5Mb 260ms DropTail
$ns duplex-link $n(98) $n(158) 1.5Mb 310ms DropTail
$ns duplex-link $n(98) $n(157) 1.5Mb 210ms DropTail
$ns duplex-link $n(98) $n(156) 1.5Mb 140ms DropTail
$ns duplex-link $n(98) $n(154) 1.5Mb 710ms DropTail
$ns duplex-link $n(98) $n(151) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "3970..."; flush stdout }
$ns duplex-link $n(98) $n(149) 1.5Mb 250ms DropTail
$ns duplex-link $n(98) $n(144) 1.5Mb 720ms DropTail
$ns duplex-link $n(98) $n(136) 1.5Mb 90ms DropTail
$ns duplex-link $n(98) $n(129) 1.5Mb 310ms DropTail
$ns duplex-link $n(98) $n(128) 1.5Mb 570ms DropTail
$ns duplex-link $n(98) $n(122) 1.5Mb 520ms DropTail
$ns duplex-link $n(98) $n(104) 1.5Mb 340ms DropTail
$ns duplex-link $n(98) $n(102) 1.5Mb 370ms DropTail
$ns duplex-link $n(98) $n(101) 1.5Mb 660ms DropTail
$ns duplex-link $n(98) $n(100) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "3980..."; flush stdout }
$ns duplex-link $n(99) $n(246) 1.5Mb 550ms DropTail
$ns duplex-link $n(99) $n(245) 1.5Mb 220ms DropTail
$ns duplex-link $n(99) $n(239) 1.5Mb 550ms DropTail
$ns duplex-link $n(99) $n(238) 1.5Mb 550ms DropTail
$ns duplex-link $n(99) $n(237) 1.5Mb 260ms DropTail
$ns duplex-link $n(99) $n(235) 1.5Mb 160ms DropTail
$ns duplex-link $n(99) $n(234) 1.5Mb 300ms DropTail
$ns duplex-link $n(99) $n(227) 1.5Mb 20ms DropTail
$ns duplex-link $n(99) $n(223) 1.5Mb 640ms DropTail
$ns duplex-link $n(99) $n(219) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "3990..."; flush stdout }
$ns duplex-link $n(99) $n(218) 1.5Mb 470ms DropTail
$ns duplex-link $n(99) $n(217) 1.5Mb 510ms DropTail
$ns duplex-link $n(99) $n(207) 1.5Mb 560ms DropTail
$ns duplex-link $n(99) $n(206) 1.5Mb 110ms DropTail
$ns duplex-link $n(99) $n(202) 1.5Mb 700ms DropTail
$ns duplex-link $n(99) $n(200) 1.5Mb 600ms DropTail
$ns duplex-link $n(99) $n(196) 1.5Mb 710ms DropTail
$ns duplex-link $n(99) $n(192) 1.5Mb 940ms DropTail
$ns duplex-link $n(99) $n(183) 1.5Mb 880ms DropTail
$ns duplex-link $n(99) $n(180) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "4000..."; flush stdout }
$ns duplex-link $n(99) $n(169) 1.5Mb 810ms DropTail
$ns duplex-link $n(99) $n(167) 1.5Mb 60ms DropTail
$ns duplex-link $n(99) $n(164) 1.5Mb 390ms DropTail
$ns duplex-link $n(99) $n(153) 1.5Mb 420ms DropTail
$ns duplex-link $n(99) $n(145) 1.5Mb 640ms DropTail
$ns duplex-link $n(99) $n(143) 1.5Mb 470ms DropTail
$ns duplex-link $n(99) $n(142) 1.5Mb 930ms DropTail
$ns duplex-link $n(99) $n(136) 1.5Mb 770ms DropTail
$ns duplex-link $n(99) $n(127) 1.5Mb 790ms DropTail
$ns duplex-link $n(99) $n(125) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "4010..."; flush stdout }
$ns duplex-link $n(99) $n(120) 1.5Mb 690ms DropTail
$ns duplex-link $n(99) $n(110) 1.5Mb 820ms DropTail
$ns duplex-link $n(99) $n(102) 1.5Mb 430ms DropTail
$ns duplex-link $n(99) $n(100) 1.5Mb 140ms DropTail
$ns duplex-link $n(100) $n(244) 1.5Mb 820ms DropTail
$ns duplex-link $n(100) $n(241) 1.5Mb 260ms DropTail
$ns duplex-link $n(100) $n(238) 1.5Mb 490ms DropTail
$ns duplex-link $n(100) $n(237) 1.5Mb 170ms DropTail
$ns duplex-link $n(100) $n(231) 1.5Mb 770ms DropTail
$ns duplex-link $n(100) $n(229) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "4020..."; flush stdout }
$ns duplex-link $n(100) $n(227) 1.5Mb 130ms DropTail
$ns duplex-link $n(100) $n(215) 1.5Mb 340ms DropTail
$ns duplex-link $n(100) $n(213) 1.5Mb 450ms DropTail
$ns duplex-link $n(100) $n(204) 1.5Mb 760ms DropTail
$ns duplex-link $n(100) $n(198) 1.5Mb 790ms DropTail
$ns duplex-link $n(100) $n(196) 1.5Mb 580ms DropTail
$ns duplex-link $n(100) $n(193) 1.5Mb 570ms DropTail
$ns duplex-link $n(100) $n(185) 1.5Mb 300ms DropTail
$ns duplex-link $n(100) $n(176) 1.5Mb 490ms DropTail
$ns duplex-link $n(100) $n(162) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "4030..."; flush stdout }
$ns duplex-link $n(100) $n(160) 1.5Mb 570ms DropTail
$ns duplex-link $n(100) $n(153) 1.5Mb 320ms DropTail
$ns duplex-link $n(100) $n(151) 1.5Mb 170ms DropTail
$ns duplex-link $n(100) $n(150) 1.5Mb 140ms DropTail
$ns duplex-link $n(100) $n(148) 1.5Mb 490ms DropTail
$ns duplex-link $n(100) $n(144) 1.5Mb 570ms DropTail
$ns duplex-link $n(100) $n(143) 1.5Mb 500ms DropTail
$ns duplex-link $n(100) $n(136) 1.5Mb 660ms DropTail
$ns duplex-link $n(100) $n(131) 1.5Mb 220ms DropTail
$ns duplex-link $n(100) $n(128) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "4040..."; flush stdout }
$ns duplex-link $n(100) $n(123) 1.5Mb 440ms DropTail
$ns duplex-link $n(100) $n(118) 1.5Mb 680ms DropTail
$ns duplex-link $n(100) $n(105) 1.5Mb 720ms DropTail
$ns duplex-link $n(101) $n(247) 1.5Mb 860ms DropTail
$ns duplex-link $n(101) $n(246) 1.5Mb 570ms DropTail
$ns duplex-link $n(101) $n(240) 1.5Mb 250ms DropTail
$ns duplex-link $n(101) $n(238) 1.5Mb 620ms DropTail
$ns duplex-link $n(101) $n(233) 1.5Mb 110ms DropTail
$ns duplex-link $n(101) $n(232) 1.5Mb 740ms DropTail
$ns duplex-link $n(101) $n(228) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "4050..."; flush stdout }
$ns duplex-link $n(101) $n(220) 1.5Mb 180ms DropTail
$ns duplex-link $n(101) $n(212) 1.5Mb 570ms DropTail
$ns duplex-link $n(101) $n(210) 1.5Mb 800ms DropTail
$ns duplex-link $n(101) $n(203) 1.5Mb 230ms DropTail
$ns duplex-link $n(101) $n(202) 1.5Mb 420ms DropTail
$ns duplex-link $n(101) $n(196) 1.5Mb 510ms DropTail
$ns duplex-link $n(101) $n(194) 1.5Mb 270ms DropTail
$ns duplex-link $n(101) $n(193) 1.5Mb 780ms DropTail
$ns duplex-link $n(101) $n(192) 1.5Mb 920ms DropTail
$ns duplex-link $n(101) $n(190) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "4060..."; flush stdout }
$ns duplex-link $n(101) $n(189) 1.5Mb 50ms DropTail
$ns duplex-link $n(101) $n(172) 1.5Mb 350ms DropTail
$ns duplex-link $n(101) $n(167) 1.5Mb 400ms DropTail
$ns duplex-link $n(101) $n(165) 1.5Mb 1010ms DropTail
$ns duplex-link $n(101) $n(162) 1.5Mb 600ms DropTail
$ns duplex-link $n(101) $n(148) 1.5Mb 510ms DropTail
$ns duplex-link $n(101) $n(147) 1.5Mb 320ms DropTail
$ns duplex-link $n(101) $n(141) 1.5Mb 830ms DropTail
$ns duplex-link $n(101) $n(134) 1.5Mb 780ms DropTail
$ns duplex-link $n(101) $n(128) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "4070..."; flush stdout }
$ns duplex-link $n(101) $n(125) 1.5Mb 850ms DropTail
$ns duplex-link $n(101) $n(113) 1.5Mb 200ms DropTail
$ns duplex-link $n(101) $n(111) 1.5Mb 770ms DropTail
$ns duplex-link $n(101) $n(110) 1.5Mb 690ms DropTail
$ns duplex-link $n(101) $n(105) 1.5Mb 670ms DropTail
$ns duplex-link $n(102) $n(230) 1.5Mb 420ms DropTail
$ns duplex-link $n(102) $n(223) 1.5Mb 420ms DropTail
$ns duplex-link $n(102) $n(221) 1.5Mb 370ms DropTail
$ns duplex-link $n(102) $n(217) 1.5Mb 310ms DropTail
$ns duplex-link $n(102) $n(215) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "4080..."; flush stdout }
$ns duplex-link $n(102) $n(214) 1.5Mb 460ms DropTail
$ns duplex-link $n(102) $n(201) 1.5Mb 620ms DropTail
$ns duplex-link $n(102) $n(189) 1.5Mb 410ms DropTail
$ns duplex-link $n(102) $n(181) 1.5Mb 490ms DropTail
$ns duplex-link $n(102) $n(174) 1.5Mb 490ms DropTail
$ns duplex-link $n(102) $n(173) 1.5Mb 280ms DropTail
$ns duplex-link $n(102) $n(145) 1.5Mb 430ms DropTail
$ns duplex-link $n(102) $n(142) 1.5Mb 500ms DropTail
$ns duplex-link $n(102) $n(134) 1.5Mb 550ms DropTail
$ns duplex-link $n(102) $n(122) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "4090..."; flush stdout }
$ns duplex-link $n(102) $n(120) 1.5Mb 340ms DropTail
$ns duplex-link $n(102) $n(119) 1.5Mb 640ms DropTail
$ns duplex-link $n(102) $n(110) 1.5Mb 390ms DropTail
$ns duplex-link $n(102) $n(105) 1.5Mb 420ms DropTail
$ns duplex-link $n(103) $n(249) 1.5Mb 870ms DropTail
$ns duplex-link $n(103) $n(247) 1.5Mb 220ms DropTail
$ns duplex-link $n(103) $n(234) 1.5Mb 740ms DropTail
$ns duplex-link $n(103) $n(231) 1.5Mb 240ms DropTail
$ns duplex-link $n(103) $n(230) 1.5Mb 1020ms DropTail
$ns duplex-link $n(103) $n(224) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "4100..."; flush stdout }
$ns duplex-link $n(103) $n(209) 1.5Mb 180ms DropTail
$ns duplex-link $n(103) $n(206) 1.5Mb 1020ms DropTail
$ns duplex-link $n(103) $n(205) 1.5Mb 550ms DropTail
$ns duplex-link $n(103) $n(202) 1.5Mb 780ms DropTail
$ns duplex-link $n(103) $n(196) 1.5Mb 600ms DropTail
$ns duplex-link $n(103) $n(192) 1.5Mb 90ms DropTail
$ns duplex-link $n(103) $n(180) 1.5Mb 940ms DropTail
$ns duplex-link $n(103) $n(178) 1.5Mb 630ms DropTail
$ns duplex-link $n(103) $n(173) 1.5Mb 920ms DropTail
$ns duplex-link $n(103) $n(167) 1.5Mb 1050ms DropTail
if {$verbose} { puts -nonewline "4110..."; flush stdout }
$ns duplex-link $n(103) $n(164) 1.5Mb 750ms DropTail
$ns duplex-link $n(103) $n(163) 1.5Mb 670ms DropTail
$ns duplex-link $n(103) $n(161) 1.5Mb 130ms DropTail
$ns duplex-link $n(103) $n(156) 1.5Mb 340ms DropTail
$ns duplex-link $n(103) $n(148) 1.5Mb 490ms DropTail
$ns duplex-link $n(103) $n(144) 1.5Mb 710ms DropTail
$ns duplex-link $n(103) $n(143) 1.5Mb 760ms DropTail
$ns duplex-link $n(103) $n(141) 1.5Mb 190ms DropTail
$ns duplex-link $n(103) $n(134) 1.5Mb 790ms DropTail
$ns duplex-link $n(103) $n(132) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "4120..."; flush stdout }
$ns duplex-link $n(103) $n(131) 1.5Mb 970ms DropTail
$ns duplex-link $n(103) $n(124) 1.5Mb 230ms DropTail
$ns duplex-link $n(103) $n(121) 1.5Mb 390ms DropTail
$ns duplex-link $n(103) $n(111) 1.5Mb 340ms DropTail
$ns duplex-link $n(103) $n(110) 1.5Mb 370ms DropTail
$ns duplex-link $n(103) $n(106) 1.5Mb 590ms DropTail
$ns duplex-link $n(104) $n(248) 1.5Mb 400ms DropTail
$ns duplex-link $n(104) $n(245) 1.5Mb 530ms DropTail
$ns duplex-link $n(104) $n(244) 1.5Mb 470ms DropTail
$ns duplex-link $n(104) $n(234) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "4130..."; flush stdout }
$ns duplex-link $n(104) $n(232) 1.5Mb 490ms DropTail
$ns duplex-link $n(104) $n(230) 1.5Mb 470ms DropTail
$ns duplex-link $n(104) $n(224) 1.5Mb 260ms DropTail
$ns duplex-link $n(104) $n(220) 1.5Mb 490ms DropTail
$ns duplex-link $n(104) $n(219) 1.5Mb 240ms DropTail
$ns duplex-link $n(104) $n(217) 1.5Mb 380ms DropTail
$ns duplex-link $n(104) $n(210) 1.5Mb 360ms DropTail
$ns duplex-link $n(104) $n(209) 1.5Mb 530ms DropTail
$ns duplex-link $n(104) $n(208) 1.5Mb 270ms DropTail
$ns duplex-link $n(104) $n(200) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "4140..."; flush stdout }
$ns duplex-link $n(104) $n(179) 1.5Mb 430ms DropTail
$ns duplex-link $n(104) $n(162) 1.5Mb 160ms DropTail
$ns duplex-link $n(104) $n(160) 1.5Mb 230ms DropTail
$ns duplex-link $n(104) $n(156) 1.5Mb 270ms DropTail
$ns duplex-link $n(104) $n(153) 1.5Mb 560ms DropTail
$ns duplex-link $n(104) $n(147) 1.5Mb 250ms DropTail
$ns duplex-link $n(104) $n(143) 1.5Mb 440ms DropTail
$ns duplex-link $n(104) $n(133) 1.5Mb 490ms DropTail
$ns duplex-link $n(104) $n(126) 1.5Mb 410ms DropTail
$ns duplex-link $n(104) $n(124) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "4150..."; flush stdout }
$ns duplex-link $n(104) $n(122) 1.5Mb 300ms DropTail
$ns duplex-link $n(104) $n(120) 1.5Mb 370ms DropTail
$ns duplex-link $n(104) $n(117) 1.5Mb 280ms DropTail
$ns duplex-link $n(104) $n(108) 1.5Mb 50ms DropTail
$ns duplex-link $n(105) $n(248) 1.5Mb 500ms DropTail
$ns duplex-link $n(105) $n(247) 1.5Mb 470ms DropTail
$ns duplex-link $n(105) $n(239) 1.5Mb 500ms DropTail
$ns duplex-link $n(105) $n(236) 1.5Mb 530ms DropTail
$ns duplex-link $n(105) $n(231) 1.5Mb 230ms DropTail
$ns duplex-link $n(105) $n(226) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "4160..."; flush stdout }
$ns duplex-link $n(105) $n(224) 1.5Mb 660ms DropTail
$ns duplex-link $n(105) $n(222) 1.5Mb 340ms DropTail
$ns duplex-link $n(105) $n(220) 1.5Mb 600ms DropTail
$ns duplex-link $n(105) $n(217) 1.5Mb 490ms DropTail
$ns duplex-link $n(105) $n(216) 1.5Mb 950ms DropTail
$ns duplex-link $n(105) $n(215) 1.5Mb 880ms DropTail
$ns duplex-link $n(105) $n(203) 1.5Mb 890ms DropTail
$ns duplex-link $n(105) $n(195) 1.5Mb 830ms DropTail
$ns duplex-link $n(105) $n(193) 1.5Mb 980ms DropTail
$ns duplex-link $n(105) $n(192) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "4170..."; flush stdout }
$ns duplex-link $n(105) $n(189) 1.5Mb 720ms DropTail
$ns duplex-link $n(105) $n(186) 1.5Mb 40ms DropTail
$ns duplex-link $n(105) $n(176) 1.5Mb 230ms DropTail
$ns duplex-link $n(105) $n(170) 1.5Mb 490ms DropTail
$ns duplex-link $n(105) $n(161) 1.5Mb 340ms DropTail
$ns duplex-link $n(105) $n(160) 1.5Mb 450ms DropTail
$ns duplex-link $n(105) $n(151) 1.5Mb 560ms DropTail
$ns duplex-link $n(105) $n(147) 1.5Mb 350ms DropTail
$ns duplex-link $n(105) $n(144) 1.5Mb 800ms DropTail
$ns duplex-link $n(105) $n(138) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "4180..."; flush stdout }
$ns duplex-link $n(105) $n(133) 1.5Mb 210ms DropTail
$ns duplex-link $n(105) $n(126) 1.5Mb 720ms DropTail
$ns duplex-link $n(105) $n(120) 1.5Mb 260ms DropTail
$ns duplex-link $n(105) $n(112) 1.5Mb 520ms DropTail
$ns duplex-link $n(105) $n(107) 1.5Mb 400ms DropTail
$ns duplex-link $n(106) $n(249) 1.5Mb 740ms DropTail
$ns duplex-link $n(106) $n(246) 1.5Mb 110ms DropTail
$ns duplex-link $n(106) $n(242) 1.5Mb 770ms DropTail
$ns duplex-link $n(106) $n(240) 1.5Mb 560ms DropTail
$ns duplex-link $n(106) $n(233) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "4190..."; flush stdout }
$ns duplex-link $n(106) $n(232) 1.5Mb 350ms DropTail
$ns duplex-link $n(106) $n(231) 1.5Mb 460ms DropTail
$ns duplex-link $n(106) $n(226) 1.5Mb 790ms DropTail
$ns duplex-link $n(106) $n(223) 1.5Mb 240ms DropTail
$ns duplex-link $n(106) $n(221) 1.5Mb 380ms DropTail
$ns duplex-link $n(106) $n(215) 1.5Mb 380ms DropTail
$ns duplex-link $n(106) $n(214) 1.5Mb 500ms DropTail
$ns duplex-link $n(106) $n(205) 1.5Mb 130ms DropTail
$ns duplex-link $n(106) $n(203) 1.5Mb 630ms DropTail
$ns duplex-link $n(106) $n(200) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "4200..."; flush stdout }
$ns duplex-link $n(106) $n(195) 1.5Mb 310ms DropTail
$ns duplex-link $n(106) $n(193) 1.5Mb 460ms DropTail
$ns duplex-link $n(106) $n(192) 1.5Mb 500ms DropTail
$ns duplex-link $n(106) $n(191) 1.5Mb 290ms DropTail
$ns duplex-link $n(106) $n(184) 1.5Mb 380ms DropTail
$ns duplex-link $n(106) $n(172) 1.5Mb 650ms DropTail
$ns duplex-link $n(106) $n(171) 1.5Mb 500ms DropTail
$ns duplex-link $n(106) $n(169) 1.5Mb 370ms DropTail
$ns duplex-link $n(106) $n(168) 1.5Mb 500ms DropTail
$ns duplex-link $n(106) $n(160) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "4210..."; flush stdout }
$ns duplex-link $n(106) $n(153) 1.5Mb 640ms DropTail
$ns duplex-link $n(106) $n(151) 1.5Mb 340ms DropTail
$ns duplex-link $n(106) $n(150) 1.5Mb 530ms DropTail
$ns duplex-link $n(106) $n(141) 1.5Mb 490ms DropTail
$ns duplex-link $n(106) $n(140) 1.5Mb 400ms DropTail
$ns duplex-link $n(106) $n(136) 1.5Mb 380ms DropTail
$ns duplex-link $n(106) $n(112) 1.5Mb 220ms DropTail
$ns duplex-link $n(106) $n(111) 1.5Mb 530ms DropTail
$ns duplex-link $n(106) $n(109) 1.5Mb 90ms DropTail
$ns duplex-link $n(106) $n(107) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "4220..."; flush stdout }
$ns duplex-link $n(107) $n(244) 1.5Mb 520ms DropTail
$ns duplex-link $n(107) $n(241) 1.5Mb 300ms DropTail
$ns duplex-link $n(107) $n(235) 1.5Mb 350ms DropTail
$ns duplex-link $n(107) $n(220) 1.5Mb 250ms DropTail
$ns duplex-link $n(107) $n(217) 1.5Mb 130ms DropTail
$ns duplex-link $n(107) $n(215) 1.5Mb 610ms DropTail
$ns duplex-link $n(107) $n(214) 1.5Mb 510ms DropTail
$ns duplex-link $n(107) $n(213) 1.5Mb 470ms DropTail
$ns duplex-link $n(107) $n(209) 1.5Mb 650ms DropTail
$ns duplex-link $n(107) $n(207) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "4230..."; flush stdout }
$ns duplex-link $n(107) $n(204) 1.5Mb 620ms DropTail
$ns duplex-link $n(107) $n(199) 1.5Mb 780ms DropTail
$ns duplex-link $n(107) $n(191) 1.5Mb 630ms DropTail
$ns duplex-link $n(107) $n(182) 1.5Mb 600ms DropTail
$ns duplex-link $n(107) $n(177) 1.5Mb 370ms DropTail
$ns duplex-link $n(107) $n(165) 1.5Mb 750ms DropTail
$ns duplex-link $n(107) $n(163) 1.5Mb 120ms DropTail
$ns duplex-link $n(107) $n(162) 1.5Mb 370ms DropTail
$ns duplex-link $n(107) $n(156) 1.5Mb 410ms DropTail
$ns duplex-link $n(107) $n(154) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "4240..."; flush stdout }
$ns duplex-link $n(107) $n(145) 1.5Mb 620ms DropTail
$ns duplex-link $n(107) $n(143) 1.5Mb 650ms DropTail
$ns duplex-link $n(107) $n(142) 1.5Mb 510ms DropTail
$ns duplex-link $n(107) $n(139) 1.5Mb 50ms DropTail
$ns duplex-link $n(107) $n(130) 1.5Mb 580ms DropTail
$ns duplex-link $n(107) $n(125) 1.5Mb 610ms DropTail
$ns duplex-link $n(107) $n(116) 1.5Mb 540ms DropTail
$ns duplex-link $n(108) $n(241) 1.5Mb 180ms DropTail
$ns duplex-link $n(108) $n(233) 1.5Mb 310ms DropTail
$ns duplex-link $n(108) $n(232) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "4250..."; flush stdout }
$ns duplex-link $n(108) $n(231) 1.5Mb 400ms DropTail
$ns duplex-link $n(108) $n(227) 1.5Mb 490ms DropTail
$ns duplex-link $n(108) $n(220) 1.5Mb 450ms DropTail
$ns duplex-link $n(108) $n(218) 1.5Mb 550ms DropTail
$ns duplex-link $n(108) $n(216) 1.5Mb 650ms DropTail
$ns duplex-link $n(108) $n(213) 1.5Mb 290ms DropTail
$ns duplex-link $n(108) $n(205) 1.5Mb 70ms DropTail
$ns duplex-link $n(108) $n(204) 1.5Mb 430ms DropTail
$ns duplex-link $n(108) $n(198) 1.5Mb 610ms DropTail
$ns duplex-link $n(108) $n(196) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "4260..."; flush stdout }
$ns duplex-link $n(108) $n(192) 1.5Mb 510ms DropTail
$ns duplex-link $n(108) $n(191) 1.5Mb 470ms DropTail
$ns duplex-link $n(108) $n(189) 1.5Mb 460ms DropTail
$ns duplex-link $n(108) $n(188) 1.5Mb 360ms DropTail
$ns duplex-link $n(108) $n(178) 1.5Mb 40ms DropTail
$ns duplex-link $n(108) $n(167) 1.5Mb 510ms DropTail
$ns duplex-link $n(108) $n(157) 1.5Mb 320ms DropTail
$ns duplex-link $n(108) $n(151) 1.5Mb 240ms DropTail
$ns duplex-link $n(108) $n(149) 1.5Mb 440ms DropTail
$ns duplex-link $n(108) $n(148) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "4270..."; flush stdout }
$ns duplex-link $n(108) $n(146) 1.5Mb 240ms DropTail
$ns duplex-link $n(108) $n(143) 1.5Mb 490ms DropTail
$ns duplex-link $n(108) $n(142) 1.5Mb 450ms DropTail
$ns duplex-link $n(108) $n(135) 1.5Mb 370ms DropTail
$ns duplex-link $n(108) $n(134) 1.5Mb 570ms DropTail
$ns duplex-link $n(108) $n(130) 1.5Mb 430ms DropTail
$ns duplex-link $n(108) $n(118) 1.5Mb 320ms DropTail
$ns duplex-link $n(108) $n(114) 1.5Mb 520ms DropTail
$ns duplex-link $n(108) $n(112) 1.5Mb 160ms DropTail
$ns duplex-link $n(109) $n(247) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "4280..."; flush stdout }
$ns duplex-link $n(109) $n(236) 1.5Mb 160ms DropTail
$ns duplex-link $n(109) $n(226) 1.5Mb 850ms DropTail
$ns duplex-link $n(109) $n(220) 1.5Mb 690ms DropTail
$ns duplex-link $n(109) $n(217) 1.5Mb 590ms DropTail
$ns duplex-link $n(109) $n(215) 1.5Mb 390ms DropTail
$ns duplex-link $n(109) $n(208) 1.5Mb 390ms DropTail
$ns duplex-link $n(109) $n(207) 1.5Mb 360ms DropTail
$ns duplex-link $n(109) $n(205) 1.5Mb 210ms DropTail
$ns duplex-link $n(109) $n(201) 1.5Mb 550ms DropTail
$ns duplex-link $n(109) $n(198) 1.5Mb 880ms DropTail
if {$verbose} { puts -nonewline "4290..."; flush stdout }
$ns duplex-link $n(109) $n(185) 1.5Mb 520ms DropTail
$ns duplex-link $n(109) $n(181) 1.5Mb 760ms DropTail
$ns duplex-link $n(109) $n(177) 1.5Mb 570ms DropTail
$ns duplex-link $n(109) $n(171) 1.5Mb 470ms DropTail
$ns duplex-link $n(109) $n(149) 1.5Mb 680ms DropTail
$ns duplex-link $n(109) $n(143) 1.5Mb 250ms DropTail
$ns duplex-link $n(109) $n(140) 1.5Mb 470ms DropTail
$ns duplex-link $n(109) $n(132) 1.5Mb 280ms DropTail
$ns duplex-link $n(109) $n(126) 1.5Mb 190ms DropTail
$ns duplex-link $n(109) $n(122) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "4300..."; flush stdout }
$ns duplex-link $n(109) $n(117) 1.5Mb 460ms DropTail
$ns duplex-link $n(109) $n(113) 1.5Mb 520ms DropTail
$ns duplex-link $n(110) $n(249) 1.5Mb 500ms DropTail
$ns duplex-link $n(110) $n(247) 1.5Mb 360ms DropTail
$ns duplex-link $n(110) $n(233) 1.5Mb 610ms DropTail
$ns duplex-link $n(110) $n(229) 1.5Mb 360ms DropTail
$ns duplex-link $n(110) $n(226) 1.5Mb 450ms DropTail
$ns duplex-link $n(110) $n(223) 1.5Mb 520ms DropTail
$ns duplex-link $n(110) $n(222) 1.5Mb 380ms DropTail
$ns duplex-link $n(110) $n(221) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "4310..."; flush stdout }
$ns duplex-link $n(110) $n(216) 1.5Mb 960ms DropTail
$ns duplex-link $n(110) $n(213) 1.5Mb 510ms DropTail
$ns duplex-link $n(110) $n(211) 1.5Mb 600ms DropTail
$ns duplex-link $n(110) $n(209) 1.5Mb 240ms DropTail
$ns duplex-link $n(110) $n(208) 1.5Mb 90ms DropTail
$ns duplex-link $n(110) $n(205) 1.5Mb 340ms DropTail
$ns duplex-link $n(110) $n(196) 1.5Mb 230ms DropTail
$ns duplex-link $n(110) $n(191) 1.5Mb 730ms DropTail
$ns duplex-link $n(110) $n(188) 1.5Mb 520ms DropTail
$ns duplex-link $n(110) $n(185) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "4320..."; flush stdout }
$ns duplex-link $n(110) $n(183) 1.5Mb 120ms DropTail
$ns duplex-link $n(110) $n(179) 1.5Mb 710ms DropTail
$ns duplex-link $n(110) $n(167) 1.5Mb 850ms DropTail
$ns duplex-link $n(110) $n(165) 1.5Mb 360ms DropTail
$ns duplex-link $n(110) $n(160) 1.5Mb 350ms DropTail
$ns duplex-link $n(110) $n(150) 1.5Mb 820ms DropTail
$ns duplex-link $n(110) $n(139) 1.5Mb 440ms DropTail
$ns duplex-link $n(110) $n(130) 1.5Mb 210ms DropTail
$ns duplex-link $n(110) $n(113) 1.5Mb 750ms DropTail
$ns duplex-link $n(110) $n(112) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "4330..."; flush stdout }
$ns duplex-link $n(111) $n(249) 1.5Mb 530ms DropTail
$ns duplex-link $n(111) $n(234) 1.5Mb 610ms DropTail
$ns duplex-link $n(111) $n(229) 1.5Mb 410ms DropTail
$ns duplex-link $n(111) $n(227) 1.5Mb 900ms DropTail
$ns duplex-link $n(111) $n(223) 1.5Mb 580ms DropTail
$ns duplex-link $n(111) $n(204) 1.5Mb 360ms DropTail
$ns duplex-link $n(111) $n(199) 1.5Mb 930ms DropTail
$ns duplex-link $n(111) $n(198) 1.5Mb 570ms DropTail
$ns duplex-link $n(111) $n(185) 1.5Mb 590ms DropTail
$ns duplex-link $n(111) $n(183) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "4340..."; flush stdout }
$ns duplex-link $n(111) $n(182) 1.5Mb 700ms DropTail
$ns duplex-link $n(111) $n(181) 1.5Mb 790ms DropTail
$ns duplex-link $n(111) $n(173) 1.5Mb 710ms DropTail
$ns duplex-link $n(111) $n(169) 1.5Mb 460ms DropTail
$ns duplex-link $n(111) $n(163) 1.5Mb 460ms DropTail
$ns duplex-link $n(111) $n(159) 1.5Mb 630ms DropTail
$ns duplex-link $n(111) $n(154) 1.5Mb 800ms DropTail
$ns duplex-link $n(111) $n(144) 1.5Mb 780ms DropTail
$ns duplex-link $n(111) $n(141) 1.5Mb 150ms DropTail
$ns duplex-link $n(111) $n(136) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "4350..."; flush stdout }
$ns duplex-link $n(111) $n(134) 1.5Mb 850ms DropTail
$ns duplex-link $n(111) $n(131) 1.5Mb 880ms DropTail
$ns duplex-link $n(111) $n(129) 1.5Mb 400ms DropTail
$ns duplex-link $n(111) $n(128) 1.5Mb 670ms DropTail
$ns duplex-link $n(111) $n(123) 1.5Mb 570ms DropTail
$ns duplex-link $n(111) $n(121) 1.5Mb 290ms DropTail
$ns duplex-link $n(111) $n(116) 1.5Mb 1030ms DropTail
$ns duplex-link $n(112) $n(243) 1.5Mb 130ms DropTail
$ns duplex-link $n(112) $n(241) 1.5Mb 110ms DropTail
$ns duplex-link $n(112) $n(236) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "4360..."; flush stdout }
$ns duplex-link $n(112) $n(231) 1.5Mb 560ms DropTail
$ns duplex-link $n(112) $n(227) 1.5Mb 330ms DropTail
$ns duplex-link $n(112) $n(225) 1.5Mb 730ms DropTail
$ns duplex-link $n(112) $n(224) 1.5Mb 250ms DropTail
$ns duplex-link $n(112) $n(212) 1.5Mb 280ms DropTail
$ns duplex-link $n(112) $n(209) 1.5Mb 690ms DropTail
$ns duplex-link $n(112) $n(203) 1.5Mb 430ms DropTail
$ns duplex-link $n(112) $n(202) 1.5Mb 430ms DropTail
$ns duplex-link $n(112) $n(196) 1.5Mb 400ms DropTail
$ns duplex-link $n(112) $n(181) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "4370..."; flush stdout }
$ns duplex-link $n(112) $n(173) 1.5Mb 190ms DropTail
$ns duplex-link $n(112) $n(171) 1.5Mb 650ms DropTail
$ns duplex-link $n(112) $n(170) 1.5Mb 370ms DropTail
$ns duplex-link $n(112) $n(160) 1.5Mb 390ms DropTail
$ns duplex-link $n(112) $n(147) 1.5Mb 240ms DropTail
$ns duplex-link $n(112) $n(146) 1.5Mb 380ms DropTail
$ns duplex-link $n(112) $n(142) 1.5Mb 610ms DropTail
$ns duplex-link $n(112) $n(140) 1.5Mb 230ms DropTail
$ns duplex-link $n(112) $n(135) 1.5Mb 520ms DropTail
$ns duplex-link $n(112) $n(124) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "4380..."; flush stdout }
$ns duplex-link $n(112) $n(121) 1.5Mb 360ms DropTail
$ns duplex-link $n(112) $n(119) 1.5Mb 690ms DropTail
$ns duplex-link $n(112) $n(113) 1.5Mb 260ms DropTail
$ns duplex-link $n(113) $n(249) 1.5Mb 730ms DropTail
$ns duplex-link $n(113) $n(247) 1.5Mb 830ms DropTail
$ns duplex-link $n(113) $n(242) 1.5Mb 700ms DropTail
$ns duplex-link $n(113) $n(236) 1.5Mb 370ms DropTail
$ns duplex-link $n(113) $n(234) 1.5Mb 280ms DropTail
$ns duplex-link $n(113) $n(233) 1.5Mb 160ms DropTail
$ns duplex-link $n(113) $n(226) 1.5Mb 860ms DropTail
if {$verbose} { puts -nonewline "4390..."; flush stdout }
$ns duplex-link $n(113) $n(223) 1.5Mb 670ms DropTail
$ns duplex-link $n(113) $n(211) 1.5Mb 210ms DropTail
$ns duplex-link $n(113) $n(205) 1.5Mb 450ms DropTail
$ns duplex-link $n(113) $n(187) 1.5Mb 380ms DropTail
$ns duplex-link $n(113) $n(184) 1.5Mb 690ms DropTail
$ns duplex-link $n(113) $n(179) 1.5Mb 570ms DropTail
$ns duplex-link $n(113) $n(175) 1.5Mb 680ms DropTail
$ns duplex-link $n(113) $n(166) 1.5Mb 650ms DropTail
$ns duplex-link $n(113) $n(164) 1.5Mb 460ms DropTail
$ns duplex-link $n(113) $n(159) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "4400..."; flush stdout }
$ns duplex-link $n(113) $n(157) 1.5Mb 730ms DropTail
$ns duplex-link $n(113) $n(155) 1.5Mb 610ms DropTail
$ns duplex-link $n(113) $n(147) 1.5Mb 420ms DropTail
$ns duplex-link $n(113) $n(142) 1.5Mb 860ms DropTail
$ns duplex-link $n(113) $n(138) 1.5Mb 670ms DropTail
$ns duplex-link $n(113) $n(132) 1.5Mb 450ms DropTail
$ns duplex-link $n(113) $n(130) 1.5Mb 850ms DropTail
$ns duplex-link $n(113) $n(127) 1.5Mb 700ms DropTail
$ns duplex-link $n(113) $n(125) 1.5Mb 830ms DropTail
$ns duplex-link $n(113) $n(124) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "4410..."; flush stdout }
$ns duplex-link $n(113) $n(121) 1.5Mb 620ms DropTail
$ns duplex-link $n(113) $n(120) 1.5Mb 580ms DropTail
$ns duplex-link $n(114) $n(246) 1.5Mb 400ms DropTail
$ns duplex-link $n(114) $n(245) 1.5Mb 700ms DropTail
$ns duplex-link $n(114) $n(233) 1.5Mb 630ms DropTail
$ns duplex-link $n(114) $n(231) 1.5Mb 720ms DropTail
$ns duplex-link $n(114) $n(218) 1.5Mb 70ms DropTail
$ns duplex-link $n(114) $n(215) 1.5Mb 270ms DropTail
$ns duplex-link $n(114) $n(204) 1.5Mb 550ms DropTail
$ns duplex-link $n(114) $n(202) 1.5Mb 890ms DropTail
if {$verbose} { puts -nonewline "4420..."; flush stdout }
$ns duplex-link $n(114) $n(198) 1.5Mb 1130ms DropTail
$ns duplex-link $n(114) $n(190) 1.5Mb 1010ms DropTail
$ns duplex-link $n(114) $n(181) 1.5Mb 930ms DropTail
$ns duplex-link $n(114) $n(174) 1.5Mb 980ms DropTail
$ns duplex-link $n(114) $n(164) 1.5Mb 130ms DropTail
$ns duplex-link $n(114) $n(155) 1.5Mb 630ms DropTail
$ns duplex-link $n(114) $n(150) 1.5Mb 660ms DropTail
$ns duplex-link $n(114) $n(141) 1.5Mb 740ms DropTail
$ns duplex-link $n(114) $n(140) 1.5Mb 540ms DropTail
$ns duplex-link $n(114) $n(139) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "4430..."; flush stdout }
$ns duplex-link $n(114) $n(133) 1.5Mb 960ms DropTail
$ns duplex-link $n(114) $n(132) 1.5Mb 530ms DropTail
$ns duplex-link $n(114) $n(131) 1.5Mb 380ms DropTail
$ns duplex-link $n(114) $n(129) 1.5Mb 490ms DropTail
$ns duplex-link $n(114) $n(117) 1.5Mb 640ms DropTail
$ns duplex-link $n(115) $n(234) 1.5Mb 550ms DropTail
$ns duplex-link $n(115) $n(230) 1.5Mb 830ms DropTail
$ns duplex-link $n(115) $n(227) 1.5Mb 840ms DropTail
$ns duplex-link $n(115) $n(221) 1.5Mb 110ms DropTail
$ns duplex-link $n(115) $n(220) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "4440..."; flush stdout }
$ns duplex-link $n(115) $n(216) 1.5Mb 990ms DropTail
$ns duplex-link $n(115) $n(203) 1.5Mb 920ms DropTail
$ns duplex-link $n(115) $n(197) 1.5Mb 710ms DropTail
$ns duplex-link $n(115) $n(195) 1.5Mb 760ms DropTail
$ns duplex-link $n(115) $n(184) 1.5Mb 90ms DropTail
$ns duplex-link $n(115) $n(183) 1.5Mb 130ms DropTail
$ns duplex-link $n(115) $n(182) 1.5Mb 650ms DropTail
$ns duplex-link $n(115) $n(174) 1.5Mb 430ms DropTail
$ns duplex-link $n(115) $n(173) 1.5Mb 650ms DropTail
$ns duplex-link $n(115) $n(170) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "4450..."; flush stdout }
$ns duplex-link $n(115) $n(167) 1.5Mb 870ms DropTail
$ns duplex-link $n(115) $n(148) 1.5Mb 240ms DropTail
$ns duplex-link $n(115) $n(145) 1.5Mb 550ms DropTail
$ns duplex-link $n(115) $n(142) 1.5Mb 100ms DropTail
$ns duplex-link $n(115) $n(135) 1.5Mb 200ms DropTail
$ns duplex-link $n(115) $n(132) 1.5Mb 330ms DropTail
$ns duplex-link $n(115) $n(128) 1.5Mb 630ms DropTail
$ns duplex-link $n(115) $n(122) 1.5Mb 570ms DropTail
$ns duplex-link $n(116) $n(246) 1.5Mb 810ms DropTail
$ns duplex-link $n(116) $n(244) 1.5Mb 1050ms DropTail
if {$verbose} { puts -nonewline "4460..."; flush stdout }
$ns duplex-link $n(116) $n(238) 1.5Mb 840ms DropTail
$ns duplex-link $n(116) $n(237) 1.5Mb 200ms DropTail
$ns duplex-link $n(116) $n(235) 1.5Mb 300ms DropTail
$ns duplex-link $n(116) $n(230) 1.5Mb 420ms DropTail
$ns duplex-link $n(116) $n(229) 1.5Mb 710ms DropTail
$ns duplex-link $n(116) $n(225) 1.5Mb 1240ms DropTail
$ns duplex-link $n(116) $n(224) 1.5Mb 680ms DropTail
$ns duplex-link $n(116) $n(221) 1.5Mb 970ms DropTail
$ns duplex-link $n(116) $n(212) 1.5Mb 770ms DropTail
$ns duplex-link $n(116) $n(209) 1.5Mb 1180ms DropTail
if {$verbose} { puts -nonewline "4470..."; flush stdout }
$ns duplex-link $n(116) $n(207) 1.5Mb 700ms DropTail
$ns duplex-link $n(116) $n(206) 1.5Mb 490ms DropTail
$ns duplex-link $n(116) $n(201) 1.5Mb 1240ms DropTail
$ns duplex-link $n(116) $n(198) 1.5Mb 820ms DropTail
$ns duplex-link $n(116) $n(195) 1.5Mb 840ms DropTail
$ns duplex-link $n(116) $n(193) 1.5Mb 880ms DropTail
$ns duplex-link $n(116) $n(183) 1.5Mb 980ms DropTail
$ns duplex-link $n(116) $n(176) 1.5Mb 700ms DropTail
$ns duplex-link $n(116) $n(166) 1.5Mb 950ms DropTail
$ns duplex-link $n(116) $n(160) 1.5Mb 910ms DropTail
if {$verbose} { puts -nonewline "4480..."; flush stdout }
$ns duplex-link $n(116) $n(157) 1.5Mb 980ms DropTail
$ns duplex-link $n(116) $n(156) 1.5Mb 930ms DropTail
$ns duplex-link $n(116) $n(152) 1.5Mb 540ms DropTail
$ns duplex-link $n(116) $n(147) 1.5Mb 580ms DropTail
$ns duplex-link $n(116) $n(141) 1.5Mb 1100ms DropTail
$ns duplex-link $n(116) $n(135) 1.5Mb 1030ms DropTail
$ns duplex-link $n(116) $n(128) 1.5Mb 420ms DropTail
$ns duplex-link $n(117) $n(247) 1.5Mb 690ms DropTail
$ns duplex-link $n(117) $n(244) 1.5Mb 640ms DropTail
$ns duplex-link $n(117) $n(242) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "4490..."; flush stdout }
$ns duplex-link $n(117) $n(241) 1.5Mb 260ms DropTail
$ns duplex-link $n(117) $n(234) 1.5Mb 240ms DropTail
$ns duplex-link $n(117) $n(233) 1.5Mb 80ms DropTail
$ns duplex-link $n(117) $n(232) 1.5Mb 640ms DropTail
$ns duplex-link $n(117) $n(209) 1.5Mb 760ms DropTail
$ns duplex-link $n(117) $n(201) 1.5Mb 810ms DropTail
$ns duplex-link $n(117) $n(198) 1.5Mb 570ms DropTail
$ns duplex-link $n(117) $n(195) 1.5Mb 610ms DropTail
$ns duplex-link $n(117) $n(191) 1.5Mb 570ms DropTail
$ns duplex-link $n(117) $n(174) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "4500..."; flush stdout }
$ns duplex-link $n(117) $n(169) 1.5Mb 700ms DropTail
$ns duplex-link $n(117) $n(167) 1.5Mb 410ms DropTail
$ns duplex-link $n(117) $n(157) 1.5Mb 560ms DropTail
$ns duplex-link $n(117) $n(154) 1.5Mb 350ms DropTail
$ns duplex-link $n(117) $n(151) 1.5Mb 60ms DropTail
$ns duplex-link $n(117) $n(147) 1.5Mb 180ms DropTail
$ns duplex-link $n(117) $n(142) 1.5Mb 640ms DropTail
$ns duplex-link $n(117) $n(136) 1.5Mb 510ms DropTail
$ns duplex-link $n(117) $n(120) 1.5Mb 340ms DropTail
$ns duplex-link $n(118) $n(248) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "4510..."; flush stdout }
$ns duplex-link $n(118) $n(238) 1.5Mb 440ms DropTail
$ns duplex-link $n(118) $n(236) 1.5Mb 470ms DropTail
$ns duplex-link $n(118) $n(230) 1.5Mb 800ms DropTail
$ns duplex-link $n(118) $n(220) 1.5Mb 610ms DropTail
$ns duplex-link $n(118) $n(216) 1.5Mb 930ms DropTail
$ns duplex-link $n(118) $n(197) 1.5Mb 710ms DropTail
$ns duplex-link $n(118) $n(195) 1.5Mb 760ms DropTail
$ns duplex-link $n(118) $n(190) 1.5Mb 320ms DropTail
$ns duplex-link $n(118) $n(188) 1.5Mb 480ms DropTail
$ns duplex-link $n(118) $n(184) 1.5Mb 80ms DropTail
if {$verbose} { puts -nonewline "4520..."; flush stdout }
$ns duplex-link $n(118) $n(180) 1.5Mb 530ms DropTail
$ns duplex-link $n(118) $n(179) 1.5Mb 720ms DropTail
$ns duplex-link $n(118) $n(176) 1.5Mb 220ms DropTail
$ns duplex-link $n(118) $n(165) 1.5Mb 400ms DropTail
$ns duplex-link $n(118) $n(163) 1.5Mb 350ms DropTail
$ns duplex-link $n(118) $n(157) 1.5Mb 220ms DropTail
$ns duplex-link $n(118) $n(147) 1.5Mb 340ms DropTail
$ns duplex-link $n(118) $n(144) 1.5Mb 730ms DropTail
$ns duplex-link $n(118) $n(134) 1.5Mb 800ms DropTail
$ns duplex-link $n(118) $n(133) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "4530..."; flush stdout }
$ns duplex-link $n(118) $n(131) 1.5Mb 790ms DropTail
$ns duplex-link $n(118) $n(128) 1.5Mb 560ms DropTail
$ns duplex-link $n(118) $n(126) 1.5Mb 640ms DropTail
$ns duplex-link $n(118) $n(122) 1.5Mb 520ms DropTail
$ns duplex-link $n(118) $n(120) 1.5Mb 280ms DropTail
$ns duplex-link $n(118) $n(119) 1.5Mb 500ms DropTail
$ns duplex-link $n(119) $n(247) 1.5Mb 890ms DropTail
$ns duplex-link $n(119) $n(243) 1.5Mb 680ms DropTail
$ns duplex-link $n(119) $n(241) 1.5Mb 770ms DropTail
$ns duplex-link $n(119) $n(236) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "4540..."; flush stdout }
$ns duplex-link $n(119) $n(233) 1.5Mb 660ms DropTail
$ns duplex-link $n(119) $n(231) 1.5Mb 660ms DropTail
$ns duplex-link $n(119) $n(227) 1.5Mb 940ms DropTail
$ns duplex-link $n(119) $n(214) 1.5Mb 600ms DropTail
$ns duplex-link $n(119) $n(202) 1.5Mb 250ms DropTail
$ns duplex-link $n(119) $n(198) 1.5Mb 40ms DropTail
$ns duplex-link $n(119) $n(196) 1.5Mb 360ms DropTail
$ns duplex-link $n(119) $n(190) 1.5Mb 180ms DropTail
$ns duplex-link $n(119) $n(187) 1.5Mb 910ms DropTail
$ns duplex-link $n(119) $n(186) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "4550..."; flush stdout }
$ns duplex-link $n(119) $n(178) 1.5Mb 590ms DropTail
$ns duplex-link $n(119) $n(171) 1.5Mb 840ms DropTail
$ns duplex-link $n(119) $n(168) 1.5Mb 670ms DropTail
$ns duplex-link $n(119) $n(159) 1.5Mb 1030ms DropTail
$ns duplex-link $n(119) $n(153) 1.5Mb 650ms DropTail
$ns duplex-link $n(119) $n(152) 1.5Mb 680ms DropTail
$ns duplex-link $n(119) $n(148) 1.5Mb 570ms DropTail
$ns duplex-link $n(119) $n(135) 1.5Mb 740ms DropTail
$ns duplex-link $n(119) $n(129) 1.5Mb 640ms DropTail
$ns duplex-link $n(119) $n(128) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "4560..."; flush stdout }
$ns duplex-link $n(119) $n(123) 1.5Mb 370ms DropTail
$ns duplex-link $n(120) $n(249) 1.5Mb 230ms DropTail
$ns duplex-link $n(120) $n(237) 1.5Mb 560ms DropTail
$ns duplex-link $n(120) $n(235) 1.5Mb 560ms DropTail
$ns duplex-link $n(120) $n(231) 1.5Mb 450ms DropTail
$ns duplex-link $n(120) $n(228) 1.5Mb 880ms DropTail
$ns duplex-link $n(120) $n(213) 1.5Mb 600ms DropTail
$ns duplex-link $n(120) $n(201) 1.5Mb 660ms DropTail
$ns duplex-link $n(120) $n(200) 1.5Mb 760ms DropTail
$ns duplex-link $n(120) $n(198) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "4570..."; flush stdout }
$ns duplex-link $n(120) $n(192) 1.5Mb 640ms DropTail
$ns duplex-link $n(120) $n(189) 1.5Mb 500ms DropTail
$ns duplex-link $n(120) $n(186) 1.5Mb 230ms DropTail
$ns duplex-link $n(120) $n(182) 1.5Mb 740ms DropTail
$ns duplex-link $n(120) $n(181) 1.5Mb 430ms DropTail
$ns duplex-link $n(120) $n(171) 1.5Mb 620ms DropTail
$ns duplex-link $n(120) $n(165) 1.5Mb 680ms DropTail
$ns duplex-link $n(120) $n(164) 1.5Mb 720ms DropTail
$ns duplex-link $n(120) $n(157) 1.5Mb 460ms DropTail
$ns duplex-link $n(120) $n(151) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "4580..."; flush stdout }
$ns duplex-link $n(120) $n(148) 1.5Mb 280ms DropTail
$ns duplex-link $n(120) $n(144) 1.5Mb 830ms DropTail
$ns duplex-link $n(120) $n(136) 1.5Mb 360ms DropTail
$ns duplex-link $n(120) $n(122) 1.5Mb 350ms DropTail
$ns duplex-link $n(121) $n(248) 1.5Mb 530ms DropTail
$ns duplex-link $n(121) $n(247) 1.5Mb 250ms DropTail
$ns duplex-link $n(121) $n(246) 1.5Mb 130ms DropTail
$ns duplex-link $n(121) $n(245) 1.5Mb 720ms DropTail
$ns duplex-link $n(121) $n(243) 1.5Mb 230ms DropTail
$ns duplex-link $n(121) $n(235) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "4590..."; flush stdout }
$ns duplex-link $n(121) $n(230) 1.5Mb 640ms DropTail
$ns duplex-link $n(121) $n(224) 1.5Mb 390ms DropTail
$ns duplex-link $n(121) $n(221) 1.5Mb 140ms DropTail
$ns duplex-link $n(121) $n(220) 1.5Mb 640ms DropTail
$ns duplex-link $n(121) $n(204) 1.5Mb 230ms DropTail
$ns duplex-link $n(121) $n(195) 1.5Mb 530ms DropTail
$ns duplex-link $n(121) $n(188) 1.5Mb 530ms DropTail
$ns duplex-link $n(121) $n(185) 1.5Mb 470ms DropTail
$ns duplex-link $n(121) $n(180) 1.5Mb 620ms DropTail
$ns duplex-link $n(121) $n(174) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "4600..."; flush stdout }
$ns duplex-link $n(121) $n(173) 1.5Mb 530ms DropTail
$ns duplex-link $n(121) $n(168) 1.5Mb 260ms DropTail
$ns duplex-link $n(121) $n(166) 1.5Mb 550ms DropTail
$ns duplex-link $n(121) $n(158) 1.5Mb 250ms DropTail
$ns duplex-link $n(121) $n(139) 1.5Mb 420ms DropTail
$ns duplex-link $n(121) $n(131) 1.5Mb 610ms DropTail
$ns duplex-link $n(121) $n(128) 1.5Mb 590ms DropTail
$ns duplex-link $n(121) $n(126) 1.5Mb 400ms DropTail
$ns duplex-link $n(121) $n(123) 1.5Mb 530ms DropTail
$ns duplex-link $n(122) $n(248) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "4610..."; flush stdout }
$ns duplex-link $n(122) $n(241) 1.5Mb 270ms DropTail
$ns duplex-link $n(122) $n(236) 1.5Mb 310ms DropTail
$ns duplex-link $n(122) $n(232) 1.5Mb 650ms DropTail
$ns duplex-link $n(122) $n(231) 1.5Mb 640ms DropTail
$ns duplex-link $n(122) $n(220) 1.5Mb 230ms DropTail
$ns duplex-link $n(122) $n(210) 1.5Mb 650ms DropTail
$ns duplex-link $n(122) $n(209) 1.5Mb 770ms DropTail
$ns duplex-link $n(122) $n(200) 1.5Mb 640ms DropTail
$ns duplex-link $n(122) $n(174) 1.5Mb 470ms DropTail
$ns duplex-link $n(122) $n(170) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "4620..."; flush stdout }
$ns duplex-link $n(122) $n(156) 1.5Mb 520ms DropTail
$ns duplex-link $n(122) $n(155) 1.5Mb 430ms DropTail
$ns duplex-link $n(122) $n(145) 1.5Mb 630ms DropTail
$ns duplex-link $n(122) $n(142) 1.5Mb 650ms DropTail
$ns duplex-link $n(122) $n(134) 1.5Mb 690ms DropTail
$ns duplex-link $n(123) $n(247) 1.5Mb 770ms DropTail
$ns duplex-link $n(123) $n(244) 1.5Mb 580ms DropTail
$ns duplex-link $n(123) $n(240) 1.5Mb 530ms DropTail
$ns duplex-link $n(123) $n(234) 1.5Mb 450ms DropTail
$ns duplex-link $n(123) $n(230) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "4630..."; flush stdout }
$ns duplex-link $n(123) $n(225) 1.5Mb 830ms DropTail
$ns duplex-link $n(123) $n(220) 1.5Mb 150ms DropTail
$ns duplex-link $n(123) $n(210) 1.5Mb 710ms DropTail
$ns duplex-link $n(123) $n(209) 1.5Mb 740ms DropTail
$ns duplex-link $n(123) $n(199) 1.5Mb 940ms DropTail
$ns duplex-link $n(123) $n(195) 1.5Mb 820ms DropTail
$ns duplex-link $n(123) $n(189) 1.5Mb 330ms DropTail
$ns duplex-link $n(123) $n(188) 1.5Mb 20ms DropTail
$ns duplex-link $n(123) $n(186) 1.5Mb 430ms DropTail
$ns duplex-link $n(123) $n(181) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "4640..."; flush stdout }
$ns duplex-link $n(123) $n(180) 1.5Mb 110ms DropTail
$ns duplex-link $n(123) $n(178) 1.5Mb 330ms DropTail
$ns duplex-link $n(123) $n(166) 1.5Mb 900ms DropTail
$ns duplex-link $n(123) $n(165) 1.5Mb 860ms DropTail
$ns duplex-link $n(123) $n(159) 1.5Mb 790ms DropTail
$ns duplex-link $n(123) $n(158) 1.5Mb 750ms DropTail
$ns duplex-link $n(123) $n(155) 1.5Mb 430ms DropTail
$ns duplex-link $n(123) $n(139) 1.5Mb 110ms DropTail
$ns duplex-link $n(123) $n(137) 1.5Mb 310ms DropTail
$ns duplex-link $n(123) $n(135) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "4650..."; flush stdout }
$ns duplex-link $n(123) $n(130) 1.5Mb 690ms DropTail
$ns duplex-link $n(123) $n(125) 1.5Mb 750ms DropTail
$ns duplex-link $n(124) $n(237) 1.5Mb 880ms DropTail
$ns duplex-link $n(124) $n(235) 1.5Mb 800ms DropTail
$ns duplex-link $n(124) $n(217) 1.5Mb 730ms DropTail
$ns duplex-link $n(124) $n(210) 1.5Mb 30ms DropTail
$ns duplex-link $n(124) $n(208) 1.5Mb 270ms DropTail
$ns duplex-link $n(124) $n(183) 1.5Mb 450ms DropTail
$ns duplex-link $n(124) $n(179) 1.5Mb 510ms DropTail
$ns duplex-link $n(124) $n(178) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "4660..."; flush stdout }
$ns duplex-link $n(124) $n(175) 1.5Mb 510ms DropTail
$ns duplex-link $n(124) $n(168) 1.5Mb 250ms DropTail
$ns duplex-link $n(124) $n(148) 1.5Mb 350ms DropTail
$ns duplex-link $n(124) $n(143) 1.5Mb 540ms DropTail
$ns duplex-link $n(124) $n(141) 1.5Mb 230ms DropTail
$ns duplex-link $n(124) $n(132) 1.5Mb 400ms DropTail
$ns duplex-link $n(124) $n(130) 1.5Mb 170ms DropTail
$ns duplex-link $n(125) $n(246) 1.5Mb 300ms DropTail
$ns duplex-link $n(125) $n(220) 1.5Mb 870ms DropTail
$ns duplex-link $n(125) $n(218) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "4670..."; flush stdout }
$ns duplex-link $n(125) $n(215) 1.5Mb 750ms DropTail
$ns duplex-link $n(125) $n(211) 1.5Mb 750ms DropTail
$ns duplex-link $n(125) $n(209) 1.5Mb 270ms DropTail
$ns duplex-link $n(125) $n(196) 1.5Mb 520ms DropTail
$ns duplex-link $n(125) $n(186) 1.5Mb 420ms DropTail
$ns duplex-link $n(125) $n(182) 1.5Mb 470ms DropTail
$ns duplex-link $n(125) $n(166) 1.5Mb 580ms DropTail
$ns duplex-link $n(125) $n(165) 1.5Mb 240ms DropTail
$ns duplex-link $n(125) $n(164) 1.5Mb 550ms DropTail
$ns duplex-link $n(125) $n(153) 1.5Mb 960ms DropTail
if {$verbose} { puts -nonewline "4680..."; flush stdout }
$ns duplex-link $n(125) $n(147) 1.5Mb 590ms DropTail
$ns duplex-link $n(125) $n(145) 1.5Mb 320ms DropTail
$ns duplex-link $n(125) $n(141) 1.5Mb 210ms DropTail
$ns duplex-link $n(126) $n(249) 1.5Mb 1000ms DropTail
$ns duplex-link $n(126) $n(247) 1.5Mb 370ms DropTail
$ns duplex-link $n(126) $n(241) 1.5Mb 380ms DropTail
$ns duplex-link $n(126) $n(240) 1.5Mb 760ms DropTail
$ns duplex-link $n(126) $n(229) 1.5Mb 820ms DropTail
$ns duplex-link $n(126) $n(221) 1.5Mb 520ms DropTail
$ns duplex-link $n(126) $n(218) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "4690..."; flush stdout }
$ns duplex-link $n(126) $n(216) 1.5Mb 910ms DropTail
$ns duplex-link $n(126) $n(210) 1.5Mb 370ms DropTail
$ns duplex-link $n(126) $n(208) 1.5Mb 530ms DropTail
$ns duplex-link $n(126) $n(204) 1.5Mb 380ms DropTail
$ns duplex-link $n(126) $n(203) 1.5Mb 840ms DropTail
$ns duplex-link $n(126) $n(197) 1.5Mb 150ms DropTail
$ns duplex-link $n(126) $n(192) 1.5Mb 500ms DropTail
$ns duplex-link $n(126) $n(178) 1.5Mb 500ms DropTail
$ns duplex-link $n(126) $n(176) 1.5Mb 640ms DropTail
$ns duplex-link $n(126) $n(170) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "4700..."; flush stdout }
$ns duplex-link $n(126) $n(161) 1.5Mb 570ms DropTail
$ns duplex-link $n(126) $n(160) 1.5Mb 270ms DropTail
$ns duplex-link $n(126) $n(155) 1.5Mb 520ms DropTail
$ns duplex-link $n(126) $n(145) 1.5Mb 80ms DropTail
$ns duplex-link $n(126) $n(141) 1.5Mb 590ms DropTail
$ns duplex-link $n(126) $n(135) 1.5Mb 460ms DropTail
$ns duplex-link $n(126) $n(130) 1.5Mb 530ms DropTail
$ns duplex-link $n(126) $n(127) 1.5Mb 730ms DropTail
$ns duplex-link $n(127) $n(244) 1.5Mb 210ms DropTail
$ns duplex-link $n(127) $n(240) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "4710..."; flush stdout }
$ns duplex-link $n(127) $n(239) 1.5Mb 500ms DropTail
$ns duplex-link $n(127) $n(231) 1.5Mb 300ms DropTail
$ns duplex-link $n(127) $n(230) 1.5Mb 790ms DropTail
$ns duplex-link $n(127) $n(229) 1.5Mb 200ms DropTail
$ns duplex-link $n(127) $n(228) 1.5Mb 910ms DropTail
$ns duplex-link $n(127) $n(224) 1.5Mb 640ms DropTail
$ns duplex-link $n(127) $n(222) 1.5Mb 260ms DropTail
$ns duplex-link $n(127) $n(220) 1.5Mb 520ms DropTail
$ns duplex-link $n(127) $n(218) 1.5Mb 870ms DropTail
$ns duplex-link $n(127) $n(214) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "4720..."; flush stdout }
$ns duplex-link $n(127) $n(207) 1.5Mb 240ms DropTail
$ns duplex-link $n(127) $n(206) 1.5Mb 840ms DropTail
$ns duplex-link $n(127) $n(192) 1.5Mb 500ms DropTail
$ns duplex-link $n(127) $n(189) 1.5Mb 650ms DropTail
$ns duplex-link $n(127) $n(186) 1.5Mb 70ms DropTail
$ns duplex-link $n(127) $n(175) 1.5Mb 20ms DropTail
$ns duplex-link $n(127) $n(173) 1.5Mb 560ms DropTail
$ns duplex-link $n(127) $n(172) 1.5Mb 400ms DropTail
$ns duplex-link $n(127) $n(162) 1.5Mb 350ms DropTail
$ns duplex-link $n(127) $n(152) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "4730..."; flush stdout }
$ns duplex-link $n(127) $n(151) 1.5Mb 490ms DropTail
$ns duplex-link $n(127) $n(147) 1.5Mb 280ms DropTail
$ns duplex-link $n(127) $n(144) 1.5Mb 810ms DropTail
$ns duplex-link $n(127) $n(133) 1.5Mb 150ms DropTail
$ns duplex-link $n(127) $n(132) 1.5Mb 310ms DropTail
$ns duplex-link $n(128) $n(244) 1.5Mb 680ms DropTail
$ns duplex-link $n(128) $n(235) 1.5Mb 370ms DropTail
$ns duplex-link $n(128) $n(233) 1.5Mb 250ms DropTail
$ns duplex-link $n(128) $n(229) 1.5Mb 300ms DropTail
$ns duplex-link $n(128) $n(227) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "4740..."; flush stdout }
$ns duplex-link $n(128) $n(225) 1.5Mb 920ms DropTail
$ns duplex-link $n(128) $n(211) 1.5Mb 190ms DropTail
$ns duplex-link $n(128) $n(204) 1.5Mb 830ms DropTail
$ns duplex-link $n(128) $n(201) 1.5Mb 920ms DropTail
$ns duplex-link $n(128) $n(185) 1.5Mb 140ms DropTail
$ns duplex-link $n(128) $n(184) 1.5Mb 570ms DropTail
$ns duplex-link $n(128) $n(179) 1.5Mb 830ms DropTail
$ns duplex-link $n(128) $n(178) 1.5Mb 370ms DropTail
$ns duplex-link $n(128) $n(177) 1.5Mb 360ms DropTail
$ns duplex-link $n(128) $n(169) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "4750..."; flush stdout }
$ns duplex-link $n(128) $n(166) 1.5Mb 910ms DropTail
$ns duplex-link $n(128) $n(159) 1.5Mb 820ms DropTail
$ns duplex-link $n(128) $n(158) 1.5Mb 830ms DropTail
$ns duplex-link $n(128) $n(152) 1.5Mb 370ms DropTail
$ns duplex-link $n(128) $n(151) 1.5Mb 270ms DropTail
$ns duplex-link $n(128) $n(147) 1.5Mb 240ms DropTail
$ns duplex-link $n(128) $n(143) 1.5Mb 820ms DropTail
$ns duplex-link $n(128) $n(139) 1.5Mb 170ms DropTail
$ns duplex-link $n(128) $n(133) 1.5Mb 440ms DropTail
$ns duplex-link $n(128) $n(131) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "4760..."; flush stdout }
$ns duplex-link $n(128) $n(129) 1.5Mb 450ms DropTail
$ns duplex-link $n(129) $n(244) 1.5Mb 440ms DropTail
$ns duplex-link $n(129) $n(237) 1.5Mb 500ms DropTail
$ns duplex-link $n(129) $n(226) 1.5Mb 620ms DropTail
$ns duplex-link $n(129) $n(225) 1.5Mb 540ms DropTail
$ns duplex-link $n(129) $n(220) 1.5Mb 490ms DropTail
$ns duplex-link $n(129) $n(215) 1.5Mb 510ms DropTail
$ns duplex-link $n(129) $n(212) 1.5Mb 230ms DropTail
$ns duplex-link $n(129) $n(210) 1.5Mb 350ms DropTail
$ns duplex-link $n(129) $n(209) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "4770..."; flush stdout }
$ns duplex-link $n(129) $n(203) 1.5Mb 620ms DropTail
$ns duplex-link $n(129) $n(194) 1.5Mb 480ms DropTail
$ns duplex-link $n(129) $n(190) 1.5Mb 520ms DropTail
$ns duplex-link $n(129) $n(188) 1.5Mb 400ms DropTail
$ns duplex-link $n(129) $n(178) 1.5Mb 80ms DropTail
$ns duplex-link $n(129) $n(170) 1.5Mb 240ms DropTail
$ns duplex-link $n(129) $n(158) 1.5Mb 420ms DropTail
$ns duplex-link $n(129) $n(157) 1.5Mb 280ms DropTail
$ns duplex-link $n(129) $n(146) 1.5Mb 200ms DropTail
$ns duplex-link $n(130) $n(245) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "4780..."; flush stdout }
$ns duplex-link $n(130) $n(235) 1.5Mb 840ms DropTail
$ns duplex-link $n(130) $n(221) 1.5Mb 130ms DropTail
$ns duplex-link $n(130) $n(217) 1.5Mb 700ms DropTail
$ns duplex-link $n(130) $n(216) 1.5Mb 1090ms DropTail
$ns duplex-link $n(130) $n(206) 1.5Mb 890ms DropTail
$ns duplex-link $n(130) $n(205) 1.5Mb 400ms DropTail
$ns duplex-link $n(130) $n(204) 1.5Mb 170ms DropTail
$ns duplex-link $n(130) $n(202) 1.5Mb 620ms DropTail
$ns duplex-link $n(130) $n(201) 1.5Mb 140ms DropTail
$ns duplex-link $n(130) $n(198) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "4790..."; flush stdout }
$ns duplex-link $n(130) $n(197) 1.5Mb 650ms DropTail
$ns duplex-link $n(130) $n(196) 1.5Mb 430ms DropTail
$ns duplex-link $n(130) $n(195) 1.5Mb 700ms DropTail
$ns duplex-link $n(130) $n(194) 1.5Mb 780ms DropTail
$ns duplex-link $n(130) $n(191) 1.5Mb 690ms DropTail
$ns duplex-link $n(130) $n(184) 1.5Mb 220ms DropTail
$ns duplex-link $n(130) $n(180) 1.5Mb 770ms DropTail
$ns duplex-link $n(130) $n(176) 1.5Mb 430ms DropTail
$ns duplex-link $n(130) $n(166) 1.5Mb 700ms DropTail
$ns duplex-link $n(130) $n(164) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "4800..."; flush stdout }
$ns duplex-link $n(130) $n(161) 1.5Mb 50ms DropTail
$ns duplex-link $n(130) $n(160) 1.5Mb 290ms DropTail
$ns duplex-link $n(130) $n(158) 1.5Mb 80ms DropTail
$ns duplex-link $n(130) $n(152) 1.5Mb 570ms DropTail
$ns duplex-link $n(130) $n(149) 1.5Mb 480ms DropTail
$ns duplex-link $n(130) $n(144) 1.5Mb 650ms DropTail
$ns duplex-link $n(130) $n(135) 1.5Mb 80ms DropTail
$ns duplex-link $n(131) $n(249) 1.5Mb 920ms DropTail
$ns duplex-link $n(131) $n(247) 1.5Mb 770ms DropTail
$ns duplex-link $n(131) $n(245) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "4810..."; flush stdout }
$ns duplex-link $n(131) $n(232) 1.5Mb 360ms DropTail
$ns duplex-link $n(131) $n(223) 1.5Mb 540ms DropTail
$ns duplex-link $n(131) $n(221) 1.5Mb 750ms DropTail
$ns duplex-link $n(131) $n(219) 1.5Mb 280ms DropTail
$ns duplex-link $n(131) $n(215) 1.5Mb 130ms DropTail
$ns duplex-link $n(131) $n(210) 1.5Mb 730ms DropTail
$ns duplex-link $n(131) $n(202) 1.5Mb 750ms DropTail
$ns duplex-link $n(131) $n(198) 1.5Mb 990ms DropTail
$ns duplex-link $n(131) $n(197) 1.5Mb 370ms DropTail
$ns duplex-link $n(131) $n(195) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "4820..."; flush stdout }
$ns duplex-link $n(131) $n(191) 1.5Mb 310ms DropTail
$ns duplex-link $n(131) $n(188) 1.5Mb 630ms DropTail
$ns duplex-link $n(131) $n(178) 1.5Mb 470ms DropTail
$ns duplex-link $n(131) $n(166) 1.5Mb 440ms DropTail
$ns duplex-link $n(131) $n(162) 1.5Mb 580ms DropTail
$ns duplex-link $n(131) $n(152) 1.5Mb 350ms DropTail
$ns duplex-link $n(131) $n(141) 1.5Mb 870ms DropTail
$ns duplex-link $n(131) $n(140) 1.5Mb 210ms DropTail
$ns duplex-link $n(132) $n(237) 1.5Mb 500ms DropTail
$ns duplex-link $n(132) $n(236) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "4830..."; flush stdout }
$ns duplex-link $n(132) $n(233) 1.5Mb 340ms DropTail
$ns duplex-link $n(132) $n(227) 1.5Mb 520ms DropTail
$ns duplex-link $n(132) $n(221) 1.5Mb 280ms DropTail
$ns duplex-link $n(132) $n(218) 1.5Mb 570ms DropTail
$ns duplex-link $n(132) $n(216) 1.5Mb 680ms DropTail
$ns duplex-link $n(132) $n(212) 1.5Mb 270ms DropTail
$ns duplex-link $n(132) $n(209) 1.5Mb 500ms DropTail
$ns duplex-link $n(132) $n(208) 1.5Mb 240ms DropTail
$ns duplex-link $n(132) $n(204) 1.5Mb 410ms DropTail
$ns duplex-link $n(132) $n(201) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "4840..."; flush stdout }
$ns duplex-link $n(132) $n(199) 1.5Mb 640ms DropTail
$ns duplex-link $n(132) $n(191) 1.5Mb 490ms DropTail
$ns duplex-link $n(132) $n(188) 1.5Mb 370ms DropTail
$ns duplex-link $n(132) $n(187) 1.5Mb 320ms DropTail
$ns duplex-link $n(132) $n(186) 1.5Mb 300ms DropTail
$ns duplex-link $n(132) $n(185) 1.5Mb 300ms DropTail
$ns duplex-link $n(132) $n(183) 1.5Mb 380ms DropTail
$ns duplex-link $n(132) $n(174) 1.5Mb 460ms DropTail
$ns duplex-link $n(132) $n(172) 1.5Mb 470ms DropTail
$ns duplex-link $n(132) $n(161) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "4850..."; flush stdout }
$ns duplex-link $n(132) $n(150) 1.5Mb 530ms DropTail
$ns duplex-link $n(132) $n(147) 1.5Mb 200ms DropTail
$ns duplex-link $n(132) $n(146) 1.5Mb 220ms DropTail
$ns duplex-link $n(132) $n(144) 1.5Mb 520ms DropTail
$ns duplex-link $n(132) $n(133) 1.5Mb 430ms DropTail
$ns duplex-link $n(133) $n(248) 1.5Mb 400ms DropTail
$ns duplex-link $n(133) $n(244) 1.5Mb 320ms DropTail
$ns duplex-link $n(133) $n(229) 1.5Mb 150ms DropTail
$ns duplex-link $n(133) $n(226) 1.5Mb 160ms DropTail
$ns duplex-link $n(133) $n(223) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "4860..."; flush stdout }
$ns duplex-link $n(133) $n(220) 1.5Mb 490ms DropTail
$ns duplex-link $n(133) $n(219) 1.5Mb 610ms DropTail
$ns duplex-link $n(133) $n(218) 1.5Mb 1000ms DropTail
$ns duplex-link $n(133) $n(216) 1.5Mb 890ms DropTail
$ns duplex-link $n(133) $n(211) 1.5Mb 540ms DropTail
$ns duplex-link $n(133) $n(208) 1.5Mb 370ms DropTail
$ns duplex-link $n(133) $n(203) 1.5Mb 840ms DropTail
$ns duplex-link $n(133) $n(186) 1.5Mb 210ms DropTail
$ns duplex-link $n(133) $n(185) 1.5Mb 440ms DropTail
$ns duplex-link $n(133) $n(184) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "4870..."; flush stdout }
$ns duplex-link $n(133) $n(182) 1.5Mb 860ms DropTail
$ns duplex-link $n(133) $n(181) 1.5Mb 550ms DropTail
$ns duplex-link $n(133) $n(180) 1.5Mb 350ms DropTail
$ns duplex-link $n(133) $n(173) 1.5Mb 590ms DropTail
$ns duplex-link $n(133) $n(171) 1.5Mb 620ms DropTail
$ns duplex-link $n(133) $n(167) 1.5Mb 900ms DropTail
$ns duplex-link $n(133) $n(163) 1.5Mb 430ms DropTail
$ns duplex-link $n(133) $n(162) 1.5Mb 490ms DropTail
$ns duplex-link $n(133) $n(160) 1.5Mb 610ms DropTail
$ns duplex-link $n(133) $n(159) 1.5Mb 830ms DropTail
if {$verbose} { puts -nonewline "4880..."; flush stdout }
$ns duplex-link $n(133) $n(148) 1.5Mb 380ms DropTail
$ns duplex-link $n(133) $n(137) 1.5Mb 110ms DropTail
$ns duplex-link $n(133) $n(135) 1.5Mb 520ms DropTail
$ns duplex-link $n(134) $n(248) 1.5Mb 850ms DropTail
$ns duplex-link $n(134) $n(247) 1.5Mb 570ms DropTail
$ns duplex-link $n(134) $n(241) 1.5Mb 430ms DropTail
$ns duplex-link $n(134) $n(236) 1.5Mb 410ms DropTail
$ns duplex-link $n(134) $n(233) 1.5Mb 680ms DropTail
$ns duplex-link $n(134) $n(231) 1.5Mb 760ms DropTail
$ns duplex-link $n(134) $n(207) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "4890..."; flush stdout }
$ns duplex-link $n(134) $n(206) 1.5Mb 450ms DropTail
$ns duplex-link $n(134) $n(204) 1.5Mb 580ms DropTail
$ns duplex-link $n(134) $n(202) 1.5Mb 940ms DropTail
$ns duplex-link $n(134) $n(201) 1.5Mb 790ms DropTail
$ns duplex-link $n(134) $n(200) 1.5Mb 200ms DropTail
$ns duplex-link $n(134) $n(194) 1.5Mb 950ms DropTail
$ns duplex-link $n(134) $n(187) 1.5Mb 300ms DropTail
$ns duplex-link $n(134) $n(184) 1.5Mb 730ms DropTail
$ns duplex-link $n(134) $n(179) 1.5Mb 80ms DropTail
$ns duplex-link $n(134) $n(177) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "4900..."; flush stdout }
$ns duplex-link $n(134) $n(173) 1.5Mb 690ms DropTail
$ns duplex-link $n(134) $n(167) 1.5Mb 510ms DropTail
$ns duplex-link $n(134) $n(160) 1.5Mb 450ms DropTail
$ns duplex-link $n(134) $n(152) 1.5Mb 540ms DropTail
$ns duplex-link $n(134) $n(145) 1.5Mb 280ms DropTail
$ns duplex-link $n(134) $n(141) 1.5Mb 780ms DropTail
$ns duplex-link $n(134) $n(140) 1.5Mb 580ms DropTail
$ns duplex-link $n(134) $n(139) 1.5Mb 780ms DropTail
$ns duplex-link $n(134) $n(137) 1.5Mb 890ms DropTail
$ns duplex-link $n(135) $n(242) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "4910..."; flush stdout }
$ns duplex-link $n(135) $n(241) 1.5Mb 480ms DropTail
$ns duplex-link $n(135) $n(234) 1.5Mb 520ms DropTail
$ns duplex-link $n(135) $n(232) 1.5Mb 650ms DropTail
$ns duplex-link $n(135) $n(231) 1.5Mb 110ms DropTail
$ns duplex-link $n(135) $n(228) 1.5Mb 760ms DropTail
$ns duplex-link $n(135) $n(219) 1.5Mb 590ms DropTail
$ns duplex-link $n(135) $n(218) 1.5Mb 680ms DropTail
$ns duplex-link $n(135) $n(214) 1.5Mb 180ms DropTail
$ns duplex-link $n(135) $n(213) 1.5Mb 400ms DropTail
$ns duplex-link $n(135) $n(203) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "4920..."; flush stdout }
$ns duplex-link $n(135) $n(200) 1.5Mb 460ms DropTail
$ns duplex-link $n(135) $n(195) 1.5Mb 630ms DropTail
$ns duplex-link $n(135) $n(194) 1.5Mb 740ms DropTail
$ns duplex-link $n(135) $n(187) 1.5Mb 520ms DropTail
$ns duplex-link $n(135) $n(186) 1.5Mb 310ms DropTail
$ns duplex-link $n(135) $n(185) 1.5Mb 620ms DropTail
$ns duplex-link $n(135) $n(183) 1.5Mb 330ms DropTail
$ns duplex-link $n(135) $n(178) 1.5Mb 400ms DropTail
$ns duplex-link $n(135) $n(175) 1.5Mb 390ms DropTail
$ns duplex-link $n(135) $n(174) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "4930..."; flush stdout }
$ns duplex-link $n(135) $n(173) 1.5Mb 690ms DropTail
$ns duplex-link $n(135) $n(171) 1.5Mb 140ms DropTail
$ns duplex-link $n(135) $n(160) 1.5Mb 210ms DropTail
$ns duplex-link $n(135) $n(154) 1.5Mb 690ms DropTail
$ns duplex-link $n(135) $n(147) 1.5Mb 500ms DropTail
$ns duplex-link $n(135) $n(144) 1.5Mb 570ms DropTail
$ns duplex-link $n(136) $n(248) 1.5Mb 540ms DropTail
$ns duplex-link $n(136) $n(241) 1.5Mb 440ms DropTail
$ns duplex-link $n(136) $n(239) 1.5Mb 340ms DropTail
$ns duplex-link $n(136) $n(237) 1.5Mb 750ms DropTail
if {$verbose} { puts -nonewline "4940..."; flush stdout }
$ns duplex-link $n(136) $n(226) 1.5Mb 520ms DropTail
$ns duplex-link $n(136) $n(219) 1.5Mb 530ms DropTail
$ns duplex-link $n(136) $n(216) 1.5Mb 930ms DropTail
$ns duplex-link $n(136) $n(215) 1.5Mb 760ms DropTail
$ns duplex-link $n(136) $n(206) 1.5Mb 790ms DropTail
$ns duplex-link $n(136) $n(205) 1.5Mb 280ms DropTail
$ns duplex-link $n(136) $n(200) 1.5Mb 540ms DropTail
$ns duplex-link $n(136) $n(197) 1.5Mb 620ms DropTail
$ns duplex-link $n(136) $n(196) 1.5Mb 260ms DropTail
$ns duplex-link $n(136) $n(194) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "4950..."; flush stdout }
$ns duplex-link $n(136) $n(193) 1.5Mb 830ms DropTail
$ns duplex-link $n(136) $n(181) 1.5Mb 730ms DropTail
$ns duplex-link $n(136) $n(176) 1.5Mb 260ms DropTail
$ns duplex-link $n(136) $n(174) 1.5Mb 460ms DropTail
$ns duplex-link $n(136) $n(171) 1.5Mb 270ms DropTail
$ns duplex-link $n(136) $n(170) 1.5Mb 320ms DropTail
$ns duplex-link $n(136) $n(167) 1.5Mb 800ms DropTail
$ns duplex-link $n(136) $n(165) 1.5Mb 340ms DropTail
$ns duplex-link $n(136) $n(160) 1.5Mb 270ms DropTail
$ns duplex-link $n(136) $n(148) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "4960..."; flush stdout }
$ns duplex-link $n(136) $n(146) 1.5Mb 180ms DropTail
$ns duplex-link $n(136) $n(144) 1.5Mb 640ms DropTail
$ns duplex-link $n(136) $n(140) 1.5Mb 680ms DropTail
$ns duplex-link $n(137) $n(243) 1.5Mb 400ms DropTail
$ns duplex-link $n(137) $n(242) 1.5Mb 350ms DropTail
$ns duplex-link $n(137) $n(238) 1.5Mb 540ms DropTail
$ns duplex-link $n(137) $n(232) 1.5Mb 870ms DropTail
$ns duplex-link $n(137) $n(227) 1.5Mb 760ms DropTail
$ns duplex-link $n(137) $n(221) 1.5Mb 330ms DropTail
$ns duplex-link $n(137) $n(214) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "4970..."; flush stdout }
$ns duplex-link $n(137) $n(208) 1.5Mb 270ms DropTail
$ns duplex-link $n(137) $n(207) 1.5Mb 230ms DropTail
$ns duplex-link $n(137) $n(201) 1.5Mb 570ms DropTail
$ns duplex-link $n(137) $n(200) 1.5Mb 750ms DropTail
$ns duplex-link $n(137) $n(196) 1.5Mb 50ms DropTail
$ns duplex-link $n(137) $n(193) 1.5Mb 980ms DropTail
$ns duplex-link $n(137) $n(192) 1.5Mb 560ms DropTail
$ns duplex-link $n(137) $n(185) 1.5Mb 370ms DropTail
$ns duplex-link $n(137) $n(178) 1.5Mb 330ms DropTail
$ns duplex-link $n(137) $n(177) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "4980..."; flush stdout }
$ns duplex-link $n(137) $n(172) 1.5Mb 340ms DropTail
$ns duplex-link $n(137) $n(171) 1.5Mb 540ms DropTail
$ns duplex-link $n(137) $n(169) 1.5Mb 630ms DropTail
$ns duplex-link $n(137) $n(167) 1.5Mb 810ms DropTail
$ns duplex-link $n(137) $n(159) 1.5Mb 720ms DropTail
$ns duplex-link $n(137) $n(155) 1.5Mb 240ms DropTail
$ns duplex-link $n(137) $n(150) 1.5Mb 730ms DropTail
$ns duplex-link $n(137) $n(148) 1.5Mb 260ms DropTail
$ns duplex-link $n(137) $n(144) 1.5Mb 830ms DropTail
$ns duplex-link $n(137) $n(143) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "4990..."; flush stdout }
$ns duplex-link $n(138) $n(248) 1.5Mb 350ms DropTail
$ns duplex-link $n(138) $n(245) 1.5Mb 720ms DropTail
$ns duplex-link $n(138) $n(242) 1.5Mb 320ms DropTail
$ns duplex-link $n(138) $n(229) 1.5Mb 110ms DropTail
$ns duplex-link $n(138) $n(227) 1.5Mb 770ms DropTail
$ns duplex-link $n(138) $n(223) 1.5Mb 700ms DropTail
$ns duplex-link $n(138) $n(210) 1.5Mb 550ms DropTail
$ns duplex-link $n(138) $n(200) 1.5Mb 780ms DropTail
$ns duplex-link $n(138) $n(198) 1.5Mb 300ms DropTail
$ns duplex-link $n(138) $n(196) 1.5Mb 80ms DropTail
if {$verbose} { puts -nonewline "5000..."; flush stdout }
$ns duplex-link $n(138) $n(194) 1.5Mb 370ms DropTail
$ns duplex-link $n(138) $n(192) 1.5Mb 590ms DropTail
$ns duplex-link $n(138) $n(190) 1.5Mb 140ms DropTail
$ns duplex-link $n(138) $n(182) 1.5Mb 770ms DropTail
$ns duplex-link $n(138) $n(179) 1.5Mb 830ms DropTail
$ns duplex-link $n(138) $n(177) 1.5Mb 670ms DropTail
$ns duplex-link $n(138) $n(176) 1.5Mb 170ms DropTail
$ns duplex-link $n(138) $n(167) 1.5Mb 820ms DropTail
$ns duplex-link $n(138) $n(155) 1.5Mb 270ms DropTail
$ns duplex-link $n(138) $n(152) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "5010..."; flush stdout }
$ns duplex-link $n(138) $n(150) 1.5Mb 730ms DropTail
$ns duplex-link $n(138) $n(148) 1.5Mb 290ms DropTail
$ns duplex-link $n(138) $n(147) 1.5Mb 250ms DropTail
$ns duplex-link $n(138) $n(143) 1.5Mb 840ms DropTail
$ns duplex-link $n(138) $n(141) 1.5Mb 440ms DropTail
$ns duplex-link $n(139) $n(240) 1.5Mb 490ms DropTail
$ns duplex-link $n(139) $n(235) 1.5Mb 370ms DropTail
$ns duplex-link $n(139) $n(234) 1.5Mb 350ms DropTail
$ns duplex-link $n(139) $n(233) 1.5Mb 230ms DropTail
$ns duplex-link $n(139) $n(230) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "5020..."; flush stdout }
$ns duplex-link $n(139) $n(224) 1.5Mb 500ms DropTail
$ns duplex-link $n(139) $n(221) 1.5Mb 480ms DropTail
$ns duplex-link $n(139) $n(218) 1.5Mb 750ms DropTail
$ns duplex-link $n(139) $n(209) 1.5Mb 670ms DropTail
$ns duplex-link $n(139) $n(203) 1.5Mb 490ms DropTail
$ns duplex-link $n(139) $n(197) 1.5Mb 690ms DropTail
$ns duplex-link $n(139) $n(179) 1.5Mb 700ms DropTail
$ns duplex-link $n(139) $n(174) 1.5Mb 310ms DropTail
$ns duplex-link $n(139) $n(172) 1.5Mb 220ms DropTail
$ns duplex-link $n(139) $n(162) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "5030..."; flush stdout }
$ns duplex-link $n(139) $n(160) 1.5Mb 520ms DropTail
$ns duplex-link $n(139) $n(155) 1.5Mb 340ms DropTail
$ns duplex-link $n(139) $n(149) 1.5Mb 370ms DropTail
$ns duplex-link $n(139) $n(146) 1.5Mb 470ms DropTail
$ns duplex-link $n(139) $n(142) 1.5Mb 520ms DropTail
$ns duplex-link $n(140) $n(249) 1.5Mb 740ms DropTail
$ns duplex-link $n(140) $n(245) 1.5Mb 170ms DropTail
$ns duplex-link $n(140) $n(241) 1.5Mb 280ms DropTail
$ns duplex-link $n(140) $n(239) 1.5Mb 500ms DropTail
$ns duplex-link $n(140) $n(232) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "5040..."; flush stdout }
$ns duplex-link $n(140) $n(224) 1.5Mb 330ms DropTail
$ns duplex-link $n(140) $n(223) 1.5Mb 620ms DropTail
$ns duplex-link $n(140) $n(221) 1.5Mb 700ms DropTail
$ns duplex-link $n(140) $n(214) 1.5Mb 800ms DropTail
$ns duplex-link $n(140) $n(211) 1.5Mb 220ms DropTail
$ns duplex-link $n(140) $n(209) 1.5Mb 920ms DropTail
$ns duplex-link $n(140) $n(203) 1.5Mb 230ms DropTail
$ns duplex-link $n(140) $n(201) 1.5Mb 950ms DropTail
$ns duplex-link $n(140) $n(192) 1.5Mb 880ms DropTail
$ns duplex-link $n(140) $n(188) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "5050..."; flush stdout }
$ns duplex-link $n(140) $n(180) 1.5Mb 550ms DropTail
$ns duplex-link $n(140) $n(171) 1.5Mb 870ms DropTail
$ns duplex-link $n(140) $n(161) 1.5Mb 870ms DropTail
$ns duplex-link $n(140) $n(157) 1.5Mb 700ms DropTail
$ns duplex-link $n(140) $n(149) 1.5Mb 750ms DropTail
$ns duplex-link $n(140) $n(148) 1.5Mb 510ms DropTail
$ns duplex-link $n(141) $n(242) 1.5Mb 760ms DropTail
$ns duplex-link $n(141) $n(226) 1.5Mb 610ms DropTail
$ns duplex-link $n(141) $n(225) 1.5Mb 160ms DropTail
$ns duplex-link $n(141) $n(223) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "5060..."; flush stdout }
$ns duplex-link $n(141) $n(220) 1.5Mb 810ms DropTail
$ns duplex-link $n(141) $n(217) 1.5Mb 690ms DropTail
$ns duplex-link $n(141) $n(213) 1.5Mb 520ms DropTail
$ns duplex-link $n(141) $n(211) 1.5Mb 740ms DropTail
$ns duplex-link $n(141) $n(201) 1.5Mb 160ms DropTail
$ns duplex-link $n(141) $n(196) 1.5Mb 400ms DropTail
$ns duplex-link $n(141) $n(192) 1.5Mb 170ms DropTail
$ns duplex-link $n(141) $n(184) 1.5Mb 200ms DropTail
$ns duplex-link $n(141) $n(183) 1.5Mb 260ms DropTail
$ns duplex-link $n(141) $n(179) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "5070..."; flush stdout }
$ns duplex-link $n(141) $n(169) 1.5Mb 330ms DropTail
$ns duplex-link $n(141) $n(167) 1.5Mb 940ms DropTail
$ns duplex-link $n(141) $n(161) 1.5Mb 70ms DropTail
$ns duplex-link $n(141) $n(149) 1.5Mb 440ms DropTail
$ns duplex-link $n(141) $n(146) 1.5Mb 260ms DropTail
$ns duplex-link $n(141) $n(145) 1.5Mb 500ms DropTail
$ns duplex-link $n(142) $n(236) 1.5Mb 590ms DropTail
$ns duplex-link $n(142) $n(230) 1.5Mb 930ms DropTail
$ns duplex-link $n(142) $n(224) 1.5Mb 720ms DropTail
$ns duplex-link $n(142) $n(223) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "5080..."; flush stdout }
$ns duplex-link $n(142) $n(209) 1.5Mb 200ms DropTail
$ns duplex-link $n(142) $n(207) 1.5Mb 370ms DropTail
$ns duplex-link $n(142) $n(205) 1.5Mb 460ms DropTail
$ns duplex-link $n(142) $n(173) 1.5Mb 730ms DropTail
$ns duplex-link $n(142) $n(169) 1.5Mb 500ms DropTail
$ns duplex-link $n(142) $n(160) 1.5Mb 460ms DropTail
$ns duplex-link $n(142) $n(159) 1.5Mb 680ms DropTail
$ns duplex-link $n(142) $n(158) 1.5Mb 320ms DropTail
$ns duplex-link $n(142) $n(156) 1.5Mb 240ms DropTail
$ns duplex-link $n(143) $n(247) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "5090..."; flush stdout }
$ns duplex-link $n(143) $n(240) 1.5Mb 630ms DropTail
$ns duplex-link $n(143) $n(238) 1.5Mb 310ms DropTail
$ns duplex-link $n(143) $n(222) 1.5Mb 720ms DropTail
$ns duplex-link $n(143) $n(209) 1.5Mb 820ms DropTail
$ns duplex-link $n(143) $n(206) 1.5Mb 390ms DropTail
$ns duplex-link $n(143) $n(205) 1.5Mb 430ms DropTail
$ns duplex-link $n(143) $n(201) 1.5Mb 760ms DropTail
$ns duplex-link $n(143) $n(194) 1.5Mb 870ms DropTail
$ns duplex-link $n(143) $n(190) 1.5Mb 990ms DropTail
$ns duplex-link $n(143) $n(183) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "5100..."; flush stdout }
$ns duplex-link $n(143) $n(182) 1.5Mb 100ms DropTail
$ns duplex-link $n(143) $n(169) 1.5Mb 480ms DropTail
$ns duplex-link $n(143) $n(153) 1.5Mb 810ms DropTail
$ns duplex-link $n(143) $n(146) 1.5Mb 480ms DropTail
$ns duplex-link $n(144) $n(248) 1.5Mb 820ms DropTail
$ns duplex-link $n(144) $n(241) 1.5Mb 390ms DropTail
$ns duplex-link $n(144) $n(236) 1.5Mb 360ms DropTail
$ns duplex-link $n(144) $n(232) 1.5Mb 100ms DropTail
$ns duplex-link $n(144) $n(229) 1.5Mb 880ms DropTail
$ns duplex-link $n(144) $n(227) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "5110..."; flush stdout }
$ns duplex-link $n(144) $n(220) 1.5Mb 890ms DropTail
$ns duplex-link $n(144) $n(208) 1.5Mb 630ms DropTail
$ns duplex-link $n(144) $n(206) 1.5Mb 470ms DropTail
$ns duplex-link $n(144) $n(203) 1.5Mb 800ms DropTail
$ns duplex-link $n(144) $n(183) 1.5Mb 830ms DropTail
$ns duplex-link $n(144) $n(181) 1.5Mb 950ms DropTail
$ns duplex-link $n(144) $n(180) 1.5Mb 960ms DropTail
$ns duplex-link $n(144) $n(176) 1.5Mb 700ms DropTail
$ns duplex-link $n(144) $n(172) 1.5Mb 950ms DropTail
$ns duplex-link $n(144) $n(171) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "5120..."; flush stdout }
$ns duplex-link $n(144) $n(167) 1.5Mb 530ms DropTail
$ns duplex-link $n(144) $n(163) 1.5Mb 570ms DropTail
$ns duplex-link $n(144) $n(162) 1.5Mb 470ms DropTail
$ns duplex-link $n(144) $n(159) 1.5Mb 160ms DropTail
$ns duplex-link $n(144) $n(158) 1.5Mb 610ms DropTail
$ns duplex-link $n(144) $n(156) 1.5Mb 590ms DropTail
$ns duplex-link $n(144) $n(155) 1.5Mb 610ms DropTail
$ns duplex-link $n(144) $n(154) 1.5Mb 400ms DropTail
$ns duplex-link $n(144) $n(153) 1.5Mb 880ms DropTail
$ns duplex-link $n(144) $n(148) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "5130..."; flush stdout }
$ns duplex-link $n(145) $n(240) 1.5Mb 780ms DropTail
$ns duplex-link $n(145) $n(229) 1.5Mb 770ms DropTail
$ns duplex-link $n(145) $n(226) 1.5Mb 960ms DropTail
$ns duplex-link $n(145) $n(219) 1.5Mb 520ms DropTail
$ns duplex-link $n(145) $n(217) 1.5Mb 740ms DropTail
$ns duplex-link $n(145) $n(216) 1.5Mb 930ms DropTail
$ns duplex-link $n(145) $n(214) 1.5Mb 560ms DropTail
$ns duplex-link $n(145) $n(208) 1.5Mb 460ms DropTail
$ns duplex-link $n(145) $n(205) 1.5Mb 350ms DropTail
$ns duplex-link $n(145) $n(202) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "5140..."; flush stdout }
$ns duplex-link $n(145) $n(199) 1.5Mb 360ms DropTail
$ns duplex-link $n(145) $n(194) 1.5Mb 860ms DropTail
$ns duplex-link $n(145) $n(186) 1.5Mb 620ms DropTail
$ns duplex-link $n(145) $n(185) 1.5Mb 680ms DropTail
$ns duplex-link $n(145) $n(180) 1.5Mb 890ms DropTail
$ns duplex-link $n(145) $n(174) 1.5Mb 860ms DropTail
$ns duplex-link $n(145) $n(170) 1.5Mb 160ms DropTail
$ns duplex-link $n(145) $n(168) 1.5Mb 520ms DropTail
$ns duplex-link $n(145) $n(161) 1.5Mb 480ms DropTail
$ns duplex-link $n(145) $n(158) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "5150..."; flush stdout }
$ns duplex-link $n(145) $n(151) 1.5Mb 590ms DropTail
$ns duplex-link $n(145) $n(147) 1.5Mb 620ms DropTail
$ns duplex-link $n(146) $n(247) 1.5Mb 210ms DropTail
$ns duplex-link $n(146) $n(243) 1.5Mb 250ms DropTail
$ns duplex-link $n(146) $n(232) 1.5Mb 530ms DropTail
$ns duplex-link $n(146) $n(213) 1.5Mb 260ms DropTail
$ns duplex-link $n(146) $n(209) 1.5Mb 350ms DropTail
$ns duplex-link $n(146) $n(205) 1.5Mb 190ms DropTail
$ns duplex-link $n(146) $n(198) 1.5Mb 740ms DropTail
$ns duplex-link $n(146) $n(195) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "5160..."; flush stdout }
$ns duplex-link $n(146) $n(194) 1.5Mb 660ms DropTail
$ns duplex-link $n(146) $n(191) 1.5Mb 480ms DropTail
$ns duplex-link $n(146) $n(188) 1.5Mb 580ms DropTail
$ns duplex-link $n(146) $n(187) 1.5Mb 370ms DropTail
$ns duplex-link $n(146) $n(180) 1.5Mb 670ms DropTail
$ns duplex-link $n(146) $n(176) 1.5Mb 330ms DropTail
$ns duplex-link $n(146) $n(172) 1.5Mb 660ms DropTail
$ns duplex-link $n(146) $n(171) 1.5Mb 270ms DropTail
$ns duplex-link $n(146) $n(168) 1.5Mb 270ms DropTail
$ns duplex-link $n(146) $n(167) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "5170..."; flush stdout }
$ns duplex-link $n(146) $n(153) 1.5Mb 770ms DropTail
$ns duplex-link $n(146) $n(151) 1.5Mb 480ms DropTail
$ns duplex-link $n(146) $n(150) 1.5Mb 720ms DropTail
$ns duplex-link $n(147) $n(247) 1.5Mb 610ms DropTail
$ns duplex-link $n(147) $n(242) 1.5Mb 390ms DropTail
$ns duplex-link $n(147) $n(232) 1.5Mb 710ms DropTail
$ns duplex-link $n(147) $n(231) 1.5Mb 480ms DropTail
$ns duplex-link $n(147) $n(230) 1.5Mb 530ms DropTail
$ns duplex-link $n(147) $n(225) 1.5Mb 690ms DropTail
$ns duplex-link $n(147) $n(218) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "5180..."; flush stdout }
$ns duplex-link $n(147) $n(214) 1.5Mb 470ms DropTail
$ns duplex-link $n(147) $n(210) 1.5Mb 550ms DropTail
$ns duplex-link $n(147) $n(202) 1.5Mb 200ms DropTail
$ns duplex-link $n(147) $n(199) 1.5Mb 800ms DropTail
$ns duplex-link $n(147) $n(198) 1.5Mb 440ms DropTail
$ns duplex-link $n(147) $n(191) 1.5Mb 650ms DropTail
$ns duplex-link $n(147) $n(182) 1.5Mb 610ms DropTail
$ns duplex-link $n(147) $n(181) 1.5Mb 360ms DropTail
$ns duplex-link $n(147) $n(180) 1.5Mb 270ms DropTail
$ns duplex-link $n(147) $n(170) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "5190..."; flush stdout }
$ns duplex-link $n(147) $n(159) 1.5Mb 630ms DropTail
$ns duplex-link $n(147) $n(157) 1.5Mb 450ms DropTail
$ns duplex-link $n(147) $n(154) 1.5Mb 490ms DropTail
$ns duplex-link $n(147) $n(151) 1.5Mb 220ms DropTail
$ns duplex-link $n(148) $n(246) 1.5Mb 190ms DropTail
$ns duplex-link $n(148) $n(243) 1.5Mb 180ms DropTail
$ns duplex-link $n(148) $n(242) 1.5Mb 570ms DropTail
$ns duplex-link $n(148) $n(241) 1.5Mb 290ms DropTail
$ns duplex-link $n(148) $n(235) 1.5Mb 530ms DropTail
$ns duplex-link $n(148) $n(234) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "5200..."; flush stdout }
$ns duplex-link $n(148) $n(228) 1.5Mb 670ms DropTail
$ns duplex-link $n(148) $n(222) 1.5Mb 260ms DropTail
$ns duplex-link $n(148) $n(221) 1.5Mb 200ms DropTail
$ns duplex-link $n(148) $n(220) 1.5Mb 510ms DropTail
$ns duplex-link $n(148) $n(215) 1.5Mb 620ms DropTail
$ns duplex-link $n(148) $n(211) 1.5Mb 420ms DropTail
$ns duplex-link $n(148) $n(210) 1.5Mb 320ms DropTail
$ns duplex-link $n(148) $n(194) 1.5Mb 480ms DropTail
$ns duplex-link $n(148) $n(193) 1.5Mb 730ms DropTail
$ns duplex-link $n(148) $n(176) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "5210..."; flush stdout }
$ns duplex-link $n(148) $n(173) 1.5Mb 430ms DropTail
$ns duplex-link $n(148) $n(156) 1.5Mb 160ms DropTail
$ns duplex-link $n(149) $n(245) 1.5Mb 810ms DropTail
$ns duplex-link $n(149) $n(241) 1.5Mb 620ms DropTail
$ns duplex-link $n(149) $n(223) 1.5Mb 760ms DropTail
$ns duplex-link $n(149) $n(216) 1.5Mb 910ms DropTail
$ns duplex-link $n(149) $n(210) 1.5Mb 590ms DropTail
$ns duplex-link $n(149) $n(209) 1.5Mb 470ms DropTail
$ns duplex-link $n(149) $n(207) 1.5Mb 340ms DropTail
$ns duplex-link $n(149) $n(206) 1.5Mb 920ms DropTail
if {$verbose} { puts -nonewline "5220..."; flush stdout }
$ns duplex-link $n(149) $n(203) 1.5Mb 860ms DropTail
$ns duplex-link $n(149) $n(185) 1.5Mb 460ms DropTail
$ns duplex-link $n(149) $n(180) 1.5Mb 390ms DropTail
$ns duplex-link $n(149) $n(175) 1.5Mb 110ms DropTail
$ns duplex-link $n(149) $n(155) 1.5Mb 330ms DropTail
$ns duplex-link $n(149) $n(150) 1.5Mb 820ms DropTail
$ns duplex-link $n(150) $n(246) 1.5Mb 620ms DropTail
$ns duplex-link $n(150) $n(240) 1.5Mb 40ms DropTail
$ns duplex-link $n(150) $n(235) 1.5Mb 90ms DropTail
$ns duplex-link $n(150) $n(229) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "5230..."; flush stdout }
$ns duplex-link $n(150) $n(224) 1.5Mb 450ms DropTail
$ns duplex-link $n(150) $n(221) 1.5Mb 820ms DropTail
$ns duplex-link $n(150) $n(218) 1.5Mb 630ms DropTail
$ns duplex-link $n(150) $n(217) 1.5Mb 420ms DropTail
$ns duplex-link $n(150) $n(216) 1.5Mb 170ms DropTail
$ns duplex-link $n(150) $n(207) 1.5Mb 560ms DropTail
$ns duplex-link $n(150) $n(200) 1.5Mb 730ms DropTail
$ns duplex-link $n(150) $n(196) 1.5Mb 680ms DropTail
$ns duplex-link $n(150) $n(189) 1.5Mb 180ms DropTail
$ns duplex-link $n(150) $n(177) 1.5Mb 60ms DropTail
if {$verbose} { puts -nonewline "5240..."; flush stdout }
$ns duplex-link $n(150) $n(176) 1.5Mb 600ms DropTail
$ns duplex-link $n(150) $n(171) 1.5Mb 990ms DropTail
$ns duplex-link $n(150) $n(165) 1.5Mb 1110ms DropTail
$ns duplex-link $n(150) $n(163) 1.5Mb 450ms DropTail
$ns duplex-link $n(150) $n(161) 1.5Mb 980ms DropTail
$ns duplex-link $n(150) $n(156) 1.5Mb 770ms DropTail
$ns duplex-link $n(151) $n(243) 1.5Mb 230ms DropTail
$ns duplex-link $n(151) $n(231) 1.5Mb 630ms DropTail
$ns duplex-link $n(151) $n(230) 1.5Mb 320ms DropTail
$ns duplex-link $n(151) $n(225) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "5250..."; flush stdout }
$ns duplex-link $n(151) $n(217) 1.5Mb 220ms DropTail
$ns duplex-link $n(151) $n(213) 1.5Mb 420ms DropTail
$ns duplex-link $n(151) $n(199) 1.5Mb 670ms DropTail
$ns duplex-link $n(151) $n(198) 1.5Mb 630ms DropTail
$ns duplex-link $n(151) $n(191) 1.5Mb 520ms DropTail
$ns duplex-link $n(151) $n(184) 1.5Mb 490ms DropTail
$ns duplex-link $n(151) $n(182) 1.5Mb 520ms DropTail
$ns duplex-link $n(151) $n(175) 1.5Mb 480ms DropTail
$ns duplex-link $n(151) $n(169) 1.5Mb 680ms DropTail
$ns duplex-link $n(151) $n(168) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "5260..."; flush stdout }
$ns duplex-link $n(151) $n(161) 1.5Mb 720ms DropTail
$ns duplex-link $n(151) $n(153) 1.5Mb 300ms DropTail
$ns duplex-link $n(152) $n(242) 1.5Mb 600ms DropTail
$ns duplex-link $n(152) $n(241) 1.5Mb 110ms DropTail
$ns duplex-link $n(152) $n(238) 1.5Mb 310ms DropTail
$ns duplex-link $n(152) $n(231) 1.5Mb 540ms DropTail
$ns duplex-link $n(152) $n(226) 1.5Mb 680ms DropTail
$ns duplex-link $n(152) $n(219) 1.5Mb 100ms DropTail
$ns duplex-link $n(152) $n(198) 1.5Mb 670ms DropTail
$ns duplex-link $n(152) $n(194) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "5270..."; flush stdout }
$ns duplex-link $n(152) $n(189) 1.5Mb 340ms DropTail
$ns duplex-link $n(152) $n(187) 1.5Mb 240ms DropTail
$ns duplex-link $n(152) $n(184) 1.5Mb 410ms DropTail
$ns duplex-link $n(152) $n(170) 1.5Mb 350ms DropTail
$ns duplex-link $n(152) $n(169) 1.5Mb 550ms DropTail
$ns duplex-link $n(153) $n(247) 1.5Mb 970ms DropTail
$ns duplex-link $n(153) $n(240) 1.5Mb 290ms DropTail
$ns duplex-link $n(153) $n(232) 1.5Mb 850ms DropTail
$ns duplex-link $n(153) $n(231) 1.5Mb 880ms DropTail
$ns duplex-link $n(153) $n(229) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "5280..."; flush stdout }
$ns duplex-link $n(153) $n(227) 1.5Mb 400ms DropTail
$ns duplex-link $n(153) $n(225) 1.5Mb 1080ms DropTail
$ns duplex-link $n(153) $n(219) 1.5Mb 370ms DropTail
$ns duplex-link $n(153) $n(206) 1.5Mb 530ms DropTail
$ns duplex-link $n(153) $n(205) 1.5Mb 580ms DropTail
$ns duplex-link $n(153) $n(196) 1.5Mb 580ms DropTail
$ns duplex-link $n(153) $n(195) 1.5Mb 820ms DropTail
$ns duplex-link $n(153) $n(194) 1.5Mb 270ms DropTail
$ns duplex-link $n(153) $n(187) 1.5Mb 620ms DropTail
$ns duplex-link $n(153) $n(186) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "5290..."; flush stdout }
$ns duplex-link $n(153) $n(177) 1.5Mb 230ms DropTail
$ns duplex-link $n(153) $n(176) 1.5Mb 520ms DropTail
$ns duplex-link $n(153) $n(175) 1.5Mb 650ms DropTail
$ns duplex-link $n(153) $n(174) 1.5Mb 570ms DropTail
$ns duplex-link $n(153) $n(170) 1.5Mb 780ms DropTail
$ns duplex-link $n(153) $n(168) 1.5Mb 920ms DropTail
$ns duplex-link $n(153) $n(167) 1.5Mb 480ms DropTail
$ns duplex-link $n(153) $n(166) 1.5Mb 910ms DropTail
$ns duplex-link $n(153) $n(161) 1.5Mb 990ms DropTail
$ns duplex-link $n(153) $n(158) 1.5Mb 980ms DropTail
if {$verbose} { puts -nonewline "5300..."; flush stdout }
$ns duplex-link $n(153) $n(156) 1.5Mb 770ms DropTail
$ns duplex-link $n(154) $n(233) 1.5Mb 320ms DropTail
$ns duplex-link $n(154) $n(231) 1.5Mb 760ms DropTail
$ns duplex-link $n(154) $n(223) 1.5Mb 490ms DropTail
$ns duplex-link $n(154) $n(218) 1.5Mb 340ms DropTail
$ns duplex-link $n(154) $n(215) 1.5Mb 160ms DropTail
$ns duplex-link $n(154) $n(212) 1.5Mb 310ms DropTail
$ns duplex-link $n(154) $n(209) 1.5Mb 890ms DropTail
$ns duplex-link $n(154) $n(202) 1.5Mb 680ms DropTail
$ns duplex-link $n(154) $n(195) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "5310..."; flush stdout }
$ns duplex-link $n(154) $n(190) 1.5Mb 860ms DropTail
$ns duplex-link $n(154) $n(188) 1.5Mb 570ms DropTail
$ns duplex-link $n(154) $n(185) 1.5Mb 440ms DropTail
$ns duplex-link $n(154) $n(183) 1.5Mb 800ms DropTail
$ns duplex-link $n(154) $n(166) 1.5Mb 420ms DropTail
$ns duplex-link $n(154) $n(158) 1.5Mb 770ms DropTail
$ns duplex-link $n(155) $n(244) 1.5Mb 260ms DropTail
$ns duplex-link $n(155) $n(241) 1.5Mb 360ms DropTail
$ns duplex-link $n(155) $n(237) 1.5Mb 650ms DropTail
$ns duplex-link $n(155) $n(226) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "5320..."; flush stdout }
$ns duplex-link $n(155) $n(221) 1.5Mb 140ms DropTail
$ns duplex-link $n(155) $n(220) 1.5Mb 560ms DropTail
$ns duplex-link $n(155) $n(212) 1.5Mb 370ms DropTail
$ns duplex-link $n(155) $n(205) 1.5Mb 200ms DropTail
$ns duplex-link $n(155) $n(203) 1.5Mb 770ms DropTail
$ns duplex-link $n(155) $n(193) 1.5Mb 780ms DropTail
$ns duplex-link $n(155) $n(191) 1.5Mb 600ms DropTail
$ns duplex-link $n(155) $n(185) 1.5Mb 410ms DropTail
$ns duplex-link $n(155) $n(183) 1.5Mb 230ms DropTail
$ns duplex-link $n(155) $n(182) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "5330..."; flush stdout }
$ns duplex-link $n(155) $n(179) 1.5Mb 590ms DropTail
$ns duplex-link $n(155) $n(173) 1.5Mb 500ms DropTail
$ns duplex-link $n(155) $n(168) 1.5Mb 250ms DropTail
$ns duplex-link $n(155) $n(167) 1.5Mb 710ms DropTail
$ns duplex-link $n(155) $n(166) 1.5Mb 660ms DropTail
$ns duplex-link $n(155) $n(165) 1.5Mb 440ms DropTail
$ns duplex-link $n(155) $n(162) 1.5Mb 140ms DropTail
$ns duplex-link $n(155) $n(161) 1.5Mb 310ms DropTail
$ns duplex-link $n(155) $n(159) 1.5Mb 480ms DropTail
$ns duplex-link $n(155) $n(158) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "5340..."; flush stdout }
$ns duplex-link $n(156) $n(246) 1.5Mb 230ms DropTail
$ns duplex-link $n(156) $n(244) 1.5Mb 230ms DropTail
$ns duplex-link $n(156) $n(241) 1.5Mb 410ms DropTail
$ns duplex-link $n(156) $n(240) 1.5Mb 810ms DropTail
$ns duplex-link $n(156) $n(236) 1.5Mb 370ms DropTail
$ns duplex-link $n(156) $n(231) 1.5Mb 130ms DropTail
$ns duplex-link $n(156) $n(230) 1.5Mb 730ms DropTail
$ns duplex-link $n(156) $n(226) 1.5Mb 560ms DropTail
$ns duplex-link $n(156) $n(225) 1.5Mb 310ms DropTail
$ns duplex-link $n(156) $n(221) 1.5Mb 40ms DropTail
if {$verbose} { puts -nonewline "5350..."; flush stdout }
$ns duplex-link $n(156) $n(217) 1.5Mb 530ms DropTail
$ns duplex-link $n(156) $n(216) 1.5Mb 920ms DropTail
$ns duplex-link $n(156) $n(208) 1.5Mb 40ms DropTail
$ns duplex-link $n(156) $n(201) 1.5Mb 310ms DropTail
$ns duplex-link $n(156) $n(199) 1.5Mb 740ms DropTail
$ns duplex-link $n(156) $n(195) 1.5Mb 630ms DropTail
$ns duplex-link $n(156) $n(186) 1.5Mb 210ms DropTail
$ns duplex-link $n(156) $n(185) 1.5Mb 510ms DropTail
$ns duplex-link $n(156) $n(183) 1.5Mb 250ms DropTail
$ns duplex-link $n(156) $n(170) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "5360..."; flush stdout }
$ns duplex-link $n(156) $n(160) 1.5Mb 220ms DropTail
$ns duplex-link $n(157) $n(247) 1.5Mb 180ms DropTail
$ns duplex-link $n(157) $n(246) 1.5Mb 230ms DropTail
$ns duplex-link $n(157) $n(242) 1.5Mb 740ms DropTail
$ns duplex-link $n(157) $n(228) 1.5Mb 730ms DropTail
$ns duplex-link $n(157) $n(224) 1.5Mb 490ms DropTail
$ns duplex-link $n(157) $n(212) 1.5Mb 370ms DropTail
$ns duplex-link $n(157) $n(211) 1.5Mb 630ms DropTail
$ns duplex-link $n(157) $n(204) 1.5Mb 160ms DropTail
$ns duplex-link $n(157) $n(202) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "5370..."; flush stdout }
$ns duplex-link $n(157) $n(192) 1.5Mb 200ms DropTail
$ns duplex-link $n(157) $n(189) 1.5Mb 770ms DropTail
$ns duplex-link $n(157) $n(187) 1.5Mb 480ms DropTail
$ns duplex-link $n(157) $n(186) 1.5Mb 280ms DropTail
$ns duplex-link $n(157) $n(179) 1.5Mb 560ms DropTail
$ns duplex-link $n(157) $n(176) 1.5Mb 350ms DropTail
$ns duplex-link $n(157) $n(175) 1.5Mb 360ms DropTail
$ns duplex-link $n(157) $n(172) 1.5Mb 680ms DropTail
$ns duplex-link $n(157) $n(165) 1.5Mb 290ms DropTail
$ns duplex-link $n(157) $n(162) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "5380..."; flush stdout }
$ns duplex-link $n(158) $n(245) 1.5Mb 970ms DropTail
$ns duplex-link $n(158) $n(240) 1.5Mb 990ms DropTail
$ns duplex-link $n(158) $n(239) 1.5Mb 360ms DropTail
$ns duplex-link $n(158) $n(228) 1.5Mb 810ms DropTail
$ns duplex-link $n(158) $n(222) 1.5Mb 610ms DropTail
$ns duplex-link $n(158) $n(221) 1.5Mb 180ms DropTail
$ns duplex-link $n(158) $n(219) 1.5Mb 680ms DropTail
$ns duplex-link $n(158) $n(215) 1.5Mb 820ms DropTail
$ns duplex-link $n(158) $n(214) 1.5Mb 220ms DropTail
$ns duplex-link $n(158) $n(212) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "5390..."; flush stdout }
$ns duplex-link $n(158) $n(208) 1.5Mb 250ms DropTail
$ns duplex-link $n(158) $n(206) 1.5Mb 890ms DropTail
$ns duplex-link $n(158) $n(204) 1.5Mb 110ms DropTail
$ns duplex-link $n(158) $n(203) 1.5Mb 1040ms DropTail
$ns duplex-link $n(158) $n(202) 1.5Mb 680ms DropTail
$ns duplex-link $n(158) $n(194) 1.5Mb 830ms DropTail
$ns duplex-link $n(158) $n(193) 1.5Mb 820ms DropTail
$ns duplex-link $n(158) $n(192) 1.5Mb 50ms DropTail
$ns duplex-link $n(158) $n(185) 1.5Mb 720ms DropTail
$ns duplex-link $n(158) $n(163) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "5400..."; flush stdout }
$ns duplex-link $n(159) $n(243) 1.5Mb 390ms DropTail
$ns duplex-link $n(159) $n(232) 1.5Mb 250ms DropTail
$ns duplex-link $n(159) $n(228) 1.5Mb 390ms DropTail
$ns duplex-link $n(159) $n(226) 1.5Mb 980ms DropTail
$ns duplex-link $n(159) $n(223) 1.5Mb 60ms DropTail
$ns duplex-link $n(159) $n(219) 1.5Mb 510ms DropTail
$ns duplex-link $n(159) $n(215) 1.5Mb 440ms DropTail
$ns duplex-link $n(159) $n(214) 1.5Mb 590ms DropTail
$ns duplex-link $n(159) $n(211) 1.5Mb 680ms DropTail
$ns duplex-link $n(159) $n(208) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "5410..."; flush stdout }
$ns duplex-link $n(159) $n(204) 1.5Mb 340ms DropTail
$ns duplex-link $n(159) $n(203) 1.5Mb 840ms DropTail
$ns duplex-link $n(159) $n(198) 1.5Mb 1030ms DropTail
$ns duplex-link $n(159) $n(187) 1.5Mb 280ms DropTail
$ns duplex-link $n(159) $n(185) 1.5Mb 680ms DropTail
$ns duplex-link $n(159) $n(183) 1.5Mb 700ms DropTail
$ns duplex-link $n(159) $n(182) 1.5Mb 130ms DropTail
$ns duplex-link $n(159) $n(174) 1.5Mb 880ms DropTail
$ns duplex-link $n(159) $n(167) 1.5Mb 600ms DropTail
$ns duplex-link $n(160) $n(249) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "5420..."; flush stdout }
$ns duplex-link $n(160) $n(231) 1.5Mb 310ms DropTail
$ns duplex-link $n(160) $n(229) 1.5Mb 590ms DropTail
$ns duplex-link $n(160) $n(226) 1.5Mb 770ms DropTail
$ns duplex-link $n(160) $n(223) 1.5Mb 180ms DropTail
$ns duplex-link $n(160) $n(217) 1.5Mb 600ms DropTail
$ns duplex-link $n(160) $n(213) 1.5Mb 190ms DropTail
$ns duplex-link $n(160) $n(211) 1.5Mb 580ms DropTail
$ns duplex-link $n(160) $n(209) 1.5Mb 420ms DropTail
$ns duplex-link $n(160) $n(208) 1.5Mb 260ms DropTail
$ns duplex-link $n(160) $n(205) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "5430..."; flush stdout }
$ns duplex-link $n(160) $n(202) 1.5Mb 620ms DropTail
$ns duplex-link $n(160) $n(197) 1.5Mb 360ms DropTail
$ns duplex-link $n(160) $n(194) 1.5Mb 710ms DropTail
$ns duplex-link $n(160) $n(181) 1.5Mb 800ms DropTail
$ns duplex-link $n(160) $n(167) 1.5Mb 650ms DropTail
$ns duplex-link $n(160) $n(166) 1.5Mb 430ms DropTail
$ns duplex-link $n(160) $n(165) 1.5Mb 440ms DropTail
$ns duplex-link $n(160) $n(164) 1.5Mb 360ms DropTail
$ns duplex-link $n(160) $n(163) 1.5Mb 360ms DropTail
$ns duplex-link $n(160) $n(161) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "5440..."; flush stdout }
$ns duplex-link $n(161) $n(239) 1.5Mb 420ms DropTail
$ns duplex-link $n(161) $n(235) 1.5Mb 890ms DropTail
$ns duplex-link $n(161) $n(233) 1.5Mb 790ms DropTail
$ns duplex-link $n(161) $n(228) 1.5Mb 880ms DropTail
$ns duplex-link $n(161) $n(212) 1.5Mb 530ms DropTail
$ns duplex-link $n(161) $n(200) 1.5Mb 560ms DropTail
$ns duplex-link $n(161) $n(197) 1.5Mb 680ms DropTail
$ns duplex-link $n(161) $n(190) 1.5Mb 590ms DropTail
$ns duplex-link $n(161) $n(189) 1.5Mb 930ms DropTail
$ns duplex-link $n(161) $n(185) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "5450..."; flush stdout }
$ns duplex-link $n(161) $n(181) 1.5Mb 950ms DropTail
$ns duplex-link $n(161) $n(179) 1.5Mb 690ms DropTail
$ns duplex-link $n(161) $n(176) 1.5Mb 480ms DropTail
$ns duplex-link $n(161) $n(175) 1.5Mb 440ms DropTail
$ns duplex-link $n(161) $n(162) 1.5Mb 310ms DropTail
$ns duplex-link $n(162) $n(246) 1.5Mb 100ms DropTail
$ns duplex-link $n(162) $n(240) 1.5Mb 710ms DropTail
$ns duplex-link $n(162) $n(239) 1.5Mb 160ms DropTail
$ns duplex-link $n(162) $n(236) 1.5Mb 250ms DropTail
$ns duplex-link $n(162) $n(229) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "5460..."; flush stdout }
$ns duplex-link $n(162) $n(219) 1.5Mb 410ms DropTail
$ns duplex-link $n(162) $n(218) 1.5Mb 550ms DropTail
$ns duplex-link $n(162) $n(215) 1.5Mb 590ms DropTail
$ns duplex-link $n(162) $n(211) 1.5Mb 510ms DropTail
$ns duplex-link $n(162) $n(210) 1.5Mb 200ms DropTail
$ns duplex-link $n(162) $n(209) 1.5Mb 380ms DropTail
$ns duplex-link $n(162) $n(200) 1.5Mb 370ms DropTail
$ns duplex-link $n(162) $n(198) 1.5Mb 700ms DropTail
$ns duplex-link $n(162) $n(195) 1.5Mb 500ms DropTail
$ns duplex-link $n(162) $n(175) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "5470..."; flush stdout }
$ns duplex-link $n(162) $n(166) 1.5Mb 530ms DropTail
$ns duplex-link $n(163) $n(248) 1.5Mb 270ms DropTail
$ns duplex-link $n(163) $n(241) 1.5Mb 200ms DropTail
$ns duplex-link $n(163) $n(238) 1.5Mb 330ms DropTail
$ns duplex-link $n(163) $n(231) 1.5Mb 460ms DropTail
$ns duplex-link $n(163) $n(229) 1.5Mb 330ms DropTail
$ns duplex-link $n(163) $n(220) 1.5Mb 360ms DropTail
$ns duplex-link $n(163) $n(218) 1.5Mb 600ms DropTail
$ns duplex-link $n(163) $n(214) 1.5Mb 460ms DropTail
$ns duplex-link $n(163) $n(204) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "5480..."; flush stdout }
$ns duplex-link $n(163) $n(203) 1.5Mb 520ms DropTail
$ns duplex-link $n(163) $n(201) 1.5Mb 640ms DropTail
$ns duplex-link $n(163) $n(198) 1.5Mb 570ms DropTail
$ns duplex-link $n(163) $n(196) 1.5Mb 270ms DropTail
$ns duplex-link $n(163) $n(189) 1.5Mb 380ms DropTail
$ns duplex-link $n(163) $n(183) 1.5Mb 430ms DropTail
$ns duplex-link $n(163) $n(179) 1.5Mb 540ms DropTail
$ns duplex-link $n(163) $n(175) 1.5Mb 330ms DropTail
$ns duplex-link $n(163) $n(166) 1.5Mb 620ms DropTail
$ns duplex-link $n(163) $n(164) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "5490..."; flush stdout }
$ns duplex-link $n(164) $n(249) 1.5Mb 940ms DropTail
$ns duplex-link $n(164) $n(245) 1.5Mb 580ms DropTail
$ns duplex-link $n(164) $n(240) 1.5Mb 550ms DropTail
$ns duplex-link $n(164) $n(231) 1.5Mb 660ms DropTail
$ns duplex-link $n(164) $n(229) 1.5Mb 770ms DropTail
$ns duplex-link $n(164) $n(228) 1.5Mb 190ms DropTail
$ns duplex-link $n(164) $n(227) 1.5Mb 410ms DropTail
$ns duplex-link $n(164) $n(225) 1.5Mb 750ms DropTail
$ns duplex-link $n(164) $n(224) 1.5Mb 110ms DropTail
$ns duplex-link $n(164) $n(218) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "5500..."; flush stdout }
$ns duplex-link $n(164) $n(207) 1.5Mb 510ms DropTail
$ns duplex-link $n(164) $n(204) 1.5Mb 530ms DropTail
$ns duplex-link $n(164) $n(199) 1.5Mb 230ms DropTail
$ns duplex-link $n(164) $n(197) 1.5Mb 100ms DropTail
$ns duplex-link $n(164) $n(194) 1.5Mb 770ms DropTail
$ns duplex-link $n(164) $n(187) 1.5Mb 120ms DropTail
$ns duplex-link $n(164) $n(165) 1.5Mb 790ms DropTail
$ns duplex-link $n(165) $n(247) 1.5Mb 270ms DropTail
$ns duplex-link $n(165) $n(237) 1.5Mb 1080ms DropTail
$ns duplex-link $n(165) $n(217) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "5510..."; flush stdout }
$ns duplex-link $n(165) $n(215) 1.5Mb 990ms DropTail
$ns duplex-link $n(165) $n(214) 1.5Mb 270ms DropTail
$ns duplex-link $n(165) $n(208) 1.5Mb 360ms DropTail
$ns duplex-link $n(165) $n(207) 1.5Mb 580ms DropTail
$ns duplex-link $n(165) $n(204) 1.5Mb 260ms DropTail
$ns duplex-link $n(165) $n(199) 1.5Mb 920ms DropTail
$ns duplex-link $n(165) $n(197) 1.5Mb 770ms DropTail
$ns duplex-link $n(165) $n(196) 1.5Mb 590ms DropTail
$ns duplex-link $n(165) $n(193) 1.5Mb 980ms DropTail
$ns duplex-link $n(165) $n(192) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "5520..."; flush stdout }
$ns duplex-link $n(165) $n(166) 1.5Mb 810ms DropTail
$ns duplex-link $n(166) $n(249) 1.5Mb 1110ms DropTail
$ns duplex-link $n(166) $n(247) 1.5Mb 540ms DropTail
$ns duplex-link $n(166) $n(245) 1.5Mb 760ms DropTail
$ns duplex-link $n(166) $n(240) 1.5Mb 730ms DropTail
$ns duplex-link $n(166) $n(237) 1.5Mb 770ms DropTail
$ns duplex-link $n(166) $n(231) 1.5Mb 740ms DropTail
$ns duplex-link $n(166) $n(229) 1.5Mb 930ms DropTail
$ns duplex-link $n(166) $n(227) 1.5Mb 580ms DropTail
$ns duplex-link $n(166) $n(223) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "5530..."; flush stdout }
$ns duplex-link $n(166) $n(222) 1.5Mb 800ms DropTail
$ns duplex-link $n(166) $n(217) 1.5Mb 840ms DropTail
$ns duplex-link $n(166) $n(212) 1.5Mb 300ms DropTail
$ns duplex-link $n(166) $n(211) 1.5Mb 740ms DropTail
$ns duplex-link $n(166) $n(208) 1.5Mb 690ms DropTail
$ns duplex-link $n(166) $n(203) 1.5Mb 820ms DropTail
$ns duplex-link $n(166) $n(200) 1.5Mb 170ms DropTail
$ns duplex-link $n(166) $n(177) 1.5Mb 710ms DropTail
$ns duplex-link $n(166) $n(175) 1.5Mb 870ms DropTail
$ns duplex-link $n(166) $n(170) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "5540..."; flush stdout }
$ns duplex-link $n(166) $n(169) 1.5Mb 470ms DropTail
$ns duplex-link $n(166) $n(168) 1.5Mb 770ms DropTail
$ns duplex-link $n(167) $n(248) 1.5Mb 570ms DropTail
$ns duplex-link $n(167) $n(247) 1.5Mb 850ms DropTail
$ns duplex-link $n(167) $n(241) 1.5Mb 360ms DropTail
$ns duplex-link $n(167) $n(235) 1.5Mb 220ms DropTail
$ns duplex-link $n(167) $n(234) 1.5Mb 320ms DropTail
$ns duplex-link $n(167) $n(231) 1.5Mb 900ms DropTail
$ns duplex-link $n(167) $n(227) 1.5Mb 70ms DropTail
$ns duplex-link $n(167) $n(226) 1.5Mb 1030ms DropTail
if {$verbose} { puts -nonewline "5550..."; flush stdout }
$ns duplex-link $n(167) $n(225) 1.5Mb 1040ms DropTail
$ns duplex-link $n(167) $n(216) 1.5Mb 360ms DropTail
$ns duplex-link $n(167) $n(215) 1.5Mb 220ms DropTail
$ns duplex-link $n(167) $n(201) 1.5Mb 1030ms DropTail
$ns duplex-link $n(167) $n(191) 1.5Mb 410ms DropTail
$ns duplex-link $n(167) $n(186) 1.5Mb 840ms DropTail
$ns duplex-link $n(167) $n(182) 1.5Mb 490ms DropTail
$ns duplex-link $n(167) $n(179) 1.5Mb 470ms DropTail
$ns duplex-link $n(167) $n(178) 1.5Mb 500ms DropTail
$ns duplex-link $n(167) $n(174) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "5560..."; flush stdout }
$ns duplex-link $n(167) $n(168) 1.5Mb 940ms DropTail
$ns duplex-link $n(168) $n(247) 1.5Mb 280ms DropTail
$ns duplex-link $n(168) $n(238) 1.5Mb 440ms DropTail
$ns duplex-link $n(168) $n(235) 1.5Mb 850ms DropTail
$ns duplex-link $n(168) $n(234) 1.5Mb 620ms DropTail
$ns duplex-link $n(168) $n(230) 1.5Mb 900ms DropTail
$ns duplex-link $n(168) $n(227) 1.5Mb 920ms DropTail
$ns duplex-link $n(168) $n(224) 1.5Mb 650ms DropTail
$ns duplex-link $n(168) $n(221) 1.5Mb 130ms DropTail
$ns duplex-link $n(168) $n(215) 1.5Mb 880ms DropTail
if {$verbose} { puts -nonewline "5570..."; flush stdout }
$ns duplex-link $n(168) $n(212) 1.5Mb 530ms DropTail
$ns duplex-link $n(168) $n(211) 1.5Mb 730ms DropTail
$ns duplex-link $n(168) $n(207) 1.5Mb 390ms DropTail
$ns duplex-link $n(168) $n(193) 1.5Mb 920ms DropTail
$ns duplex-link $n(168) $n(186) 1.5Mb 250ms DropTail
$ns duplex-link $n(168) $n(184) 1.5Mb 180ms DropTail
$ns duplex-link $n(168) $n(182) 1.5Mb 650ms DropTail
$ns duplex-link $n(169) $n(248) 1.5Mb 800ms DropTail
$ns duplex-link $n(169) $n(242) 1.5Mb 970ms DropTail
$ns duplex-link $n(169) $n(241) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "5580..."; flush stdout }
$ns duplex-link $n(169) $n(237) 1.5Mb 890ms DropTail
$ns duplex-link $n(169) $n(224) 1.5Mb 480ms DropTail
$ns duplex-link $n(169) $n(220) 1.5Mb 900ms DropTail
$ns duplex-link $n(169) $n(216) 1.5Mb 1070ms DropTail
$ns duplex-link $n(169) $n(208) 1.5Mb 360ms DropTail
$ns duplex-link $n(169) $n(204) 1.5Mb 100ms DropTail
$ns duplex-link $n(169) $n(201) 1.5Mb 290ms DropTail
$ns duplex-link $n(169) $n(199) 1.5Mb 580ms DropTail
$ns duplex-link $n(169) $n(194) 1.5Mb 890ms DropTail
$ns duplex-link $n(169) $n(174) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "5590..."; flush stdout }
$ns duplex-link $n(169) $n(173) 1.5Mb 760ms DropTail
$ns duplex-link $n(170) $n(246) 1.5Mb 100ms DropTail
$ns duplex-link $n(170) $n(244) 1.5Mb 500ms DropTail
$ns duplex-link $n(170) $n(237) 1.5Mb 690ms DropTail
$ns duplex-link $n(170) $n(228) 1.5Mb 500ms DropTail
$ns duplex-link $n(170) $n(227) 1.5Mb 620ms DropTail
$ns duplex-link $n(170) $n(223) 1.5Mb 140ms DropTail
$ns duplex-link $n(170) $n(222) 1.5Mb 520ms DropTail
$ns duplex-link $n(170) $n(221) 1.5Mb 300ms DropTail
$ns duplex-link $n(170) $n(220) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "5600..."; flush stdout }
$ns duplex-link $n(170) $n(215) 1.5Mb 500ms DropTail
$ns duplex-link $n(170) $n(201) 1.5Mb 430ms DropTail
$ns duplex-link $n(170) $n(197) 1.5Mb 310ms DropTail
$ns duplex-link $n(170) $n(196) 1.5Mb 490ms DropTail
$ns duplex-link $n(170) $n(193) 1.5Mb 520ms DropTail
$ns duplex-link $n(170) $n(191) 1.5Mb 350ms DropTail
$ns duplex-link $n(170) $n(190) 1.5Mb 700ms DropTail
$ns duplex-link $n(170) $n(185) 1.5Mb 550ms DropTail
$ns duplex-link $n(170) $n(181) 1.5Mb 800ms DropTail
$ns duplex-link $n(170) $n(176) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "5610..."; flush stdout }
$ns duplex-link $n(170) $n(172) 1.5Mb 740ms DropTail
$ns duplex-link $n(171) $n(228) 1.5Mb 840ms DropTail
$ns duplex-link $n(171) $n(223) 1.5Mb 410ms DropTail
$ns duplex-link $n(171) $n(222) 1.5Mb 650ms DropTail
$ns duplex-link $n(171) $n(219) 1.5Mb 720ms DropTail
$ns duplex-link $n(171) $n(216) 1.5Mb 1150ms DropTail
$ns duplex-link $n(171) $n(208) 1.5Mb 280ms DropTail
$ns duplex-link $n(171) $n(205) 1.5Mb 460ms DropTail
$ns duplex-link $n(171) $n(204) 1.5Mb 130ms DropTail
$ns duplex-link $n(171) $n(200) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "5620..."; flush stdout }
$ns duplex-link $n(171) $n(199) 1.5Mb 790ms DropTail
$ns duplex-link $n(171) $n(198) 1.5Mb 860ms DropTail
$ns duplex-link $n(171) $n(179) 1.5Mb 650ms DropTail
$ns duplex-link $n(171) $n(174) 1.5Mb 720ms DropTail
$ns duplex-link $n(172) $n(247) 1.5Mb 860ms DropTail
$ns duplex-link $n(172) $n(243) 1.5Mb 510ms DropTail
$ns duplex-link $n(172) $n(228) 1.5Mb 940ms DropTail
$ns duplex-link $n(172) $n(224) 1.5Mb 710ms DropTail
$ns duplex-link $n(172) $n(212) 1.5Mb 710ms DropTail
$ns duplex-link $n(172) $n(201) 1.5Mb 900ms DropTail
if {$verbose} { puts -nonewline "5630..."; flush stdout }
$ns duplex-link $n(172) $n(194) 1.5Mb 80ms DropTail
$ns duplex-link $n(172) $n(189) 1.5Mb 390ms DropTail
$ns duplex-link $n(172) $n(180) 1.5Mb 10ms DropTail
$ns duplex-link $n(172) $n(177) 1.5Mb 510ms DropTail
$ns duplex-link $n(172) $n(175) 1.5Mb 380ms DropTail
$ns duplex-link $n(172) $n(173) 1.5Mb 380ms DropTail
$ns duplex-link $n(173) $n(246) 1.5Mb 470ms DropTail
$ns duplex-link $n(173) $n(235) 1.5Mb 130ms DropTail
$ns duplex-link $n(173) $n(233) 1.5Mb 10ms DropTail
$ns duplex-link $n(173) $n(217) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "5640..."; flush stdout }
$ns duplex-link $n(173) $n(203) 1.5Mb 270ms DropTail
$ns duplex-link $n(173) $n(202) 1.5Mb 420ms DropTail
$ns duplex-link $n(173) $n(199) 1.5Mb 720ms DropTail
$ns duplex-link $n(173) $n(192) 1.5Mb 840ms DropTail
$ns duplex-link $n(173) $n(190) 1.5Mb 630ms DropTail
$ns duplex-link $n(173) $n(174) 1.5Mb 540ms DropTail
$ns duplex-link $n(174) $n(243) 1.5Mb 530ms DropTail
$ns duplex-link $n(174) $n(239) 1.5Mb 690ms DropTail
$ns duplex-link $n(174) $n(236) 1.5Mb 630ms DropTail
$ns duplex-link $n(174) $n(233) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "5650..."; flush stdout }
$ns duplex-link $n(174) $n(230) 1.5Mb 830ms DropTail
$ns duplex-link $n(174) $n(226) 1.5Mb 160ms DropTail
$ns duplex-link $n(174) $n(224) 1.5Mb 760ms DropTail
$ns duplex-link $n(174) $n(205) 1.5Mb 530ms DropTail
$ns duplex-link $n(174) $n(200) 1.5Mb 910ms DropTail
$ns duplex-link $n(174) $n(193) 1.5Mb 1100ms DropTail
$ns duplex-link $n(174) $n(190) 1.5Mb 120ms DropTail
$ns duplex-link $n(174) $n(186) 1.5Mb 310ms DropTail
$ns duplex-link $n(175) $n(249) 1.5Mb 310ms DropTail
$ns duplex-link $n(175) $n(240) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "5660..."; flush stdout }
$ns duplex-link $n(175) $n(237) 1.5Mb 680ms DropTail
$ns duplex-link $n(175) $n(226) 1.5Mb 290ms DropTail
$ns duplex-link $n(175) $n(220) 1.5Mb 500ms DropTail
$ns duplex-link $n(175) $n(217) 1.5Mb 390ms DropTail
$ns duplex-link $n(175) $n(211) 1.5Mb 500ms DropTail
$ns duplex-link $n(175) $n(205) 1.5Mb 380ms DropTail
$ns duplex-link $n(175) $n(196) 1.5Mb 70ms DropTail
$ns duplex-link $n(175) $n(195) 1.5Mb 820ms DropTail
$ns duplex-link $n(175) $n(182) 1.5Mb 730ms DropTail
$ns duplex-link $n(175) $n(178) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "5670..."; flush stdout }
$ns duplex-link $n(175) $n(177) 1.5Mb 690ms DropTail
$ns duplex-link $n(175) $n(176) 1.5Mb 160ms DropTail
$ns duplex-link $n(176) $n(244) 1.5Mb 350ms DropTail
$ns duplex-link $n(176) $n(243) 1.5Mb 260ms DropTail
$ns duplex-link $n(176) $n(241) 1.5Mb 360ms DropTail
$ns duplex-link $n(176) $n(237) 1.5Mb 530ms DropTail
$ns duplex-link $n(176) $n(236) 1.5Mb 360ms DropTail
$ns duplex-link $n(176) $n(235) 1.5Mb 510ms DropTail
$ns duplex-link $n(176) $n(230) 1.5Mb 620ms DropTail
$ns duplex-link $n(176) $n(217) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "5680..."; flush stdout }
$ns duplex-link $n(176) $n(215) 1.5Mb 700ms DropTail
$ns duplex-link $n(176) $n(201) 1.5Mb 580ms DropTail
$ns duplex-link $n(176) $n(199) 1.5Mb 820ms DropTail
$ns duplex-link $n(176) $n(194) 1.5Mb 350ms DropTail
$ns duplex-link $n(176) $n(193) 1.5Mb 830ms DropTail
$ns duplex-link $n(177) $n(248) 1.5Mb 360ms DropTail
$ns duplex-link $n(177) $n(244) 1.5Mb 880ms DropTail
$ns duplex-link $n(177) $n(243) 1.5Mb 420ms DropTail
$ns duplex-link $n(177) $n(238) 1.5Mb 600ms DropTail
$ns duplex-link $n(177) $n(232) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "5690..."; flush stdout }
$ns duplex-link $n(177) $n(229) 1.5Mb 600ms DropTail
$ns duplex-link $n(177) $n(225) 1.5Mb 1020ms DropTail
$ns duplex-link $n(177) $n(223) 1.5Mb 720ms DropTail
$ns duplex-link $n(177) $n(219) 1.5Mb 230ms DropTail
$ns duplex-link $n(177) $n(216) 1.5Mb 210ms DropTail
$ns duplex-link $n(177) $n(213) 1.5Mb 560ms DropTail
$ns duplex-link $n(177) $n(204) 1.5Mb 860ms DropTail
$ns duplex-link $n(177) $n(203) 1.5Mb 130ms DropTail
$ns duplex-link $n(177) $n(187) 1.5Mb 440ms DropTail
$ns duplex-link $n(177) $n(178) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "5700..."; flush stdout }
$ns duplex-link $n(178) $n(249) 1.5Mb 520ms DropTail
$ns duplex-link $n(178) $n(248) 1.5Mb 310ms DropTail
$ns duplex-link $n(178) $n(243) 1.5Mb 90ms DropTail
$ns duplex-link $n(178) $n(236) 1.5Mb 180ms DropTail
$ns duplex-link $n(178) $n(233) 1.5Mb 280ms DropTail
$ns duplex-link $n(178) $n(231) 1.5Mb 430ms DropTail
$ns duplex-link $n(178) $n(230) 1.5Mb 460ms DropTail
$ns duplex-link $n(178) $n(227) 1.5Mb 470ms DropTail
$ns duplex-link $n(178) $n(218) 1.5Mb 570ms DropTail
$ns duplex-link $n(178) $n(214) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "5710..."; flush stdout }
$ns duplex-link $n(178) $n(213) 1.5Mb 320ms DropTail
$ns duplex-link $n(178) $n(198) 1.5Mb 590ms DropTail
$ns duplex-link $n(178) $n(187) 1.5Mb 310ms DropTail
$ns duplex-link $n(179) $n(244) 1.5Mb 820ms DropTail
$ns duplex-link $n(179) $n(241) 1.5Mb 350ms DropTail
$ns duplex-link $n(179) $n(236) 1.5Mb 330ms DropTail
$ns duplex-link $n(179) $n(234) 1.5Mb 370ms DropTail
$ns duplex-link $n(179) $n(233) 1.5Mb 610ms DropTail
$ns duplex-link $n(179) $n(222) 1.5Mb 720ms DropTail
$ns duplex-link $n(179) $n(217) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "5720..."; flush stdout }
$ns duplex-link $n(179) $n(212) 1.5Mb 230ms DropTail
$ns duplex-link $n(179) $n(211) 1.5Mb 660ms DropTail
$ns duplex-link $n(179) $n(209) 1.5Mb 790ms DropTail
$ns duplex-link $n(179) $n(208) 1.5Mb 620ms DropTail
$ns duplex-link $n(179) $n(200) 1.5Mb 150ms DropTail
$ns duplex-link $n(179) $n(195) 1.5Mb 50ms DropTail
$ns duplex-link $n(179) $n(194) 1.5Mb 870ms DropTail
$ns duplex-link $n(179) $n(191) 1.5Mb 60ms DropTail
$ns duplex-link $n(179) $n(185) 1.5Mb 680ms DropTail
$ns duplex-link $n(180) $n(240) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "5730..."; flush stdout }
$ns duplex-link $n(180) $n(217) 1.5Mb 170ms DropTail
$ns duplex-link $n(180) $n(214) 1.5Mb 660ms DropTail
$ns duplex-link $n(180) $n(206) 1.5Mb 760ms DropTail
$ns duplex-link $n(180) $n(196) 1.5Mb 340ms DropTail
$ns duplex-link $n(180) $n(191) 1.5Mb 900ms DropTail
$ns duplex-link $n(181) $n(249) 1.5Mb 450ms DropTail
$ns duplex-link $n(181) $n(248) 1.5Mb 190ms DropTail
$ns duplex-link $n(181) $n(247) 1.5Mb 960ms DropTail
$ns duplex-link $n(181) $n(236) 1.5Mb 600ms DropTail
$ns duplex-link $n(181) $n(233) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "5740..."; flush stdout }
$ns duplex-link $n(181) $n(217) 1.5Mb 210ms DropTail
$ns duplex-link $n(181) $n(216) 1.5Mb 390ms DropTail
$ns duplex-link $n(181) $n(212) 1.5Mb 730ms DropTail
$ns duplex-link $n(181) $n(210) 1.5Mb 900ms DropTail
$ns duplex-link $n(181) $n(207) 1.5Mb 510ms DropTail
$ns duplex-link $n(181) $n(199) 1.5Mb 1010ms DropTail
$ns duplex-link $n(181) $n(195) 1.5Mb 890ms DropTail
$ns duplex-link $n(181) $n(188) 1.5Mb 210ms DropTail
$ns duplex-link $n(181) $n(185) 1.5Mb 250ms DropTail
$ns duplex-link $n(181) $n(183) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "5750..."; flush stdout }
$ns duplex-link $n(182) $n(248) 1.5Mb 730ms DropTail
$ns duplex-link $n(182) $n(236) 1.5Mb 280ms DropTail
$ns duplex-link $n(182) $n(235) 1.5Mb 570ms DropTail
$ns duplex-link $n(182) $n(226) 1.5Mb 1010ms DropTail
$ns duplex-link $n(182) $n(224) 1.5Mb 190ms DropTail
$ns duplex-link $n(182) $n(221) 1.5Mb 540ms DropTail
$ns duplex-link $n(182) $n(220) 1.5Mb 810ms DropTail
$ns duplex-link $n(182) $n(214) 1.5Mb 670ms DropTail
$ns duplex-link $n(182) $n(207) 1.5Mb 520ms DropTail
$ns duplex-link $n(182) $n(195) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "5760..."; flush stdout }
$ns duplex-link $n(182) $n(194) 1.5Mb 830ms DropTail
$ns duplex-link $n(182) $n(192) 1.5Mb 570ms DropTail
$ns duplex-link $n(183) $n(249) 1.5Mb 420ms DropTail
$ns duplex-link $n(183) $n(244) 1.5Mb 100ms DropTail
$ns duplex-link $n(183) $n(240) 1.5Mb 910ms DropTail
$ns duplex-link $n(183) $n(235) 1.5Mb 780ms DropTail
$ns duplex-link $n(183) $n(223) 1.5Mb 640ms DropTail
$ns duplex-link $n(183) $n(221) 1.5Mb 240ms DropTail
$ns duplex-link $n(183) $n(218) 1.5Mb 910ms DropTail
$ns duplex-link $n(183) $n(214) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "5770..."; flush stdout }
$ns duplex-link $n(183) $n(207) 1.5Mb 320ms DropTail
$ns duplex-link $n(183) $n(206) 1.5Mb 920ms DropTail
$ns duplex-link $n(183) $n(198) 1.5Mb 460ms DropTail
$ns duplex-link $n(183) $n(194) 1.5Mb 570ms DropTail
$ns duplex-link $n(183) $n(192) 1.5Mb 430ms DropTail
$ns duplex-link $n(183) $n(189) 1.5Mb 760ms DropTail
$ns duplex-link $n(184) $n(245) 1.5Mb 770ms DropTail
$ns duplex-link $n(184) $n(242) 1.5Mb 590ms DropTail
$ns duplex-link $n(184) $n(239) 1.5Mb 340ms DropTail
$ns duplex-link $n(184) $n(233) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "5780..."; flush stdout }
$ns duplex-link $n(184) $n(229) 1.5Mb 360ms DropTail
$ns duplex-link $n(184) $n(214) 1.5Mb 140ms DropTail
$ns duplex-link $n(184) $n(213) 1.5Mb 440ms DropTail
$ns duplex-link $n(184) $n(203) 1.5Mb 840ms DropTail
$ns duplex-link $n(184) $n(201) 1.5Mb 360ms DropTail
$ns duplex-link $n(184) $n(193) 1.5Mb 830ms DropTail
$ns duplex-link $n(184) $n(192) 1.5Mb 330ms DropTail
$ns duplex-link $n(185) $n(247) 1.5Mb 720ms DropTail
$ns duplex-link $n(185) $n(246) 1.5Mb 460ms DropTail
$ns duplex-link $n(185) $n(234) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "5790..."; flush stdout }
$ns duplex-link $n(185) $n(228) 1.5Mb 700ms DropTail
$ns duplex-link $n(185) $n(227) 1.5Mb 430ms DropTail
$ns duplex-link $n(185) $n(223) 1.5Mb 670ms DropTail
$ns duplex-link $n(185) $n(211) 1.5Mb 100ms DropTail
$ns duplex-link $n(185) $n(202) 1.5Mb 270ms DropTail
$ns duplex-link $n(185) $n(200) 1.5Mb 700ms DropTail
$ns duplex-link $n(185) $n(195) 1.5Mb 680ms DropTail
$ns duplex-link $n(185) $n(192) 1.5Mb 770ms DropTail
$ns duplex-link $n(185) $n(187) 1.5Mb 470ms DropTail
$ns duplex-link $n(186) $n(249) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "5800..."; flush stdout }
$ns duplex-link $n(186) $n(248) 1.5Mb 470ms DropTail
$ns duplex-link $n(186) $n(246) 1.5Mb 400ms DropTail
$ns duplex-link $n(186) $n(245) 1.5Mb 790ms DropTail
$ns duplex-link $n(186) $n(244) 1.5Mb 160ms DropTail
$ns duplex-link $n(186) $n(239) 1.5Mb 460ms DropTail
$ns duplex-link $n(186) $n(236) 1.5Mb 490ms DropTail
$ns duplex-link $n(186) $n(233) 1.5Mb 570ms DropTail
$ns duplex-link $n(186) $n(232) 1.5Mb 820ms DropTail
$ns duplex-link $n(186) $n(226) 1.5Mb 360ms DropTail
$ns duplex-link $n(186) $n(222) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "5810..."; flush stdout }
$ns duplex-link $n(186) $n(210) 1.5Mb 400ms DropTail
$ns duplex-link $n(186) $n(201) 1.5Mb 440ms DropTail
$ns duplex-link $n(186) $n(200) 1.5Mb 680ms DropTail
$ns duplex-link $n(186) $n(199) 1.5Mb 920ms DropTail
$ns duplex-link $n(186) $n(196) 1.5Mb 140ms DropTail
$ns duplex-link $n(186) $n(193) 1.5Mb 940ms DropTail
$ns duplex-link $n(187) $n(246) 1.5Mb 250ms DropTail
$ns duplex-link $n(187) $n(244) 1.5Mb 710ms DropTail
$ns duplex-link $n(187) $n(240) 1.5Mb 480ms DropTail
$ns duplex-link $n(187) $n(238) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "5820..."; flush stdout }
$ns duplex-link $n(187) $n(233) 1.5Mb 390ms DropTail
$ns duplex-link $n(187) $n(232) 1.5Mb 260ms DropTail
$ns duplex-link $n(187) $n(223) 1.5Mb 300ms DropTail
$ns duplex-link $n(187) $n(221) 1.5Mb 520ms DropTail
$ns duplex-link $n(187) $n(217) 1.5Mb 540ms DropTail
$ns duplex-link $n(187) $n(210) 1.5Mb 480ms DropTail
$ns duplex-link $n(187) $n(201) 1.5Mb 710ms DropTail
$ns duplex-link $n(187) $n(190) 1.5Mb 800ms DropTail
$ns duplex-link $n(187) $n(189) 1.5Mb 520ms DropTail
$ns duplex-link $n(187) $n(188) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "5830..."; flush stdout }
$ns duplex-link $n(188) $n(247) 1.5Mb 780ms DropTail
$ns duplex-link $n(188) $n(229) 1.5Mb 210ms DropTail
$ns duplex-link $n(188) $n(228) 1.5Mb 830ms DropTail
$ns duplex-link $n(188) $n(223) 1.5Mb 770ms DropTail
$ns duplex-link $n(188) $n(219) 1.5Mb 370ms DropTail
$ns duplex-link $n(188) $n(213) 1.5Mb 630ms DropTail
$ns duplex-link $n(188) $n(198) 1.5Mb 360ms DropTail
$ns duplex-link $n(188) $n(189) 1.5Mb 310ms DropTail
$ns duplex-link $n(189) $n(249) 1.5Mb 610ms DropTail
$ns duplex-link $n(189) $n(248) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "5840..."; flush stdout }
$ns duplex-link $n(189) $n(246) 1.5Mb 610ms DropTail
$ns duplex-link $n(189) $n(238) 1.5Mb 650ms DropTail
$ns duplex-link $n(189) $n(235) 1.5Mb 170ms DropTail
$ns duplex-link $n(189) $n(232) 1.5Mb 750ms DropTail
$ns duplex-link $n(189) $n(219) 1.5Mb 280ms DropTail
$ns duplex-link $n(189) $n(214) 1.5Mb 830ms DropTail
$ns duplex-link $n(189) $n(203) 1.5Mb 180ms DropTail
$ns duplex-link $n(189) $n(199) 1.5Mb 820ms DropTail
$ns duplex-link $n(189) $n(190) 1.5Mb 690ms DropTail
$ns duplex-link $n(190) $n(243) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "5850..."; flush stdout }
$ns duplex-link $n(190) $n(242) 1.5Mb 280ms DropTail
$ns duplex-link $n(190) $n(240) 1.5Mb 880ms DropTail
$ns duplex-link $n(190) $n(236) 1.5Mb 670ms DropTail
$ns duplex-link $n(190) $n(232) 1.5Mb 1040ms DropTail
$ns duplex-link $n(190) $n(222) 1.5Mb 330ms DropTail
$ns duplex-link $n(190) $n(220) 1.5Mb 510ms DropTail
$ns duplex-link $n(190) $n(217) 1.5Mb 430ms DropTail
$ns duplex-link $n(190) $n(212) 1.5Mb 750ms DropTail
$ns duplex-link $n(190) $n(202) 1.5Mb 220ms DropTail
$ns duplex-link $n(191) $n(249) 1.5Mb 1010ms DropTail
if {$verbose} { puts -nonewline "5860..."; flush stdout }
$ns duplex-link $n(191) $n(243) 1.5Mb 410ms DropTail
$ns duplex-link $n(191) $n(236) 1.5Mb 310ms DropTail
$ns duplex-link $n(191) $n(235) 1.5Mb 530ms DropTail
$ns duplex-link $n(191) $n(227) 1.5Mb 460ms DropTail
$ns duplex-link $n(191) $n(225) 1.5Mb 780ms DropTail
$ns duplex-link $n(191) $n(224) 1.5Mb 180ms DropTail
$ns duplex-link $n(191) $n(207) 1.5Mb 570ms DropTail
$ns duplex-link $n(191) $n(206) 1.5Mb 360ms DropTail
$ns duplex-link $n(191) $n(202) 1.5Mb 850ms DropTail
$ns duplex-link $n(191) $n(193) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "5870..."; flush stdout }
$ns duplex-link $n(192) $n(249) 1.5Mb 830ms DropTail
$ns duplex-link $n(192) $n(246) 1.5Mb 390ms DropTail
$ns duplex-link $n(192) $n(245) 1.5Mb 1020ms DropTail
$ns duplex-link $n(192) $n(244) 1.5Mb 350ms DropTail
$ns duplex-link $n(192) $n(242) 1.5Mb 910ms DropTail
$ns duplex-link $n(192) $n(236) 1.5Mb 560ms DropTail
$ns duplex-link $n(192) $n(230) 1.5Mb 920ms DropTail
$ns duplex-link $n(192) $n(226) 1.5Mb 770ms DropTail
$ns duplex-link $n(192) $n(217) 1.5Mb 800ms DropTail
$ns duplex-link $n(192) $n(197) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "5880..."; flush stdout }
$ns duplex-link $n(192) $n(196) 1.5Mb 550ms DropTail
$ns duplex-link $n(193) $n(248) 1.5Mb 890ms DropTail
$ns duplex-link $n(193) $n(242) 1.5Mb 1190ms DropTail
$ns duplex-link $n(193) $n(241) 1.5Mb 480ms DropTail
$ns duplex-link $n(193) $n(225) 1.5Mb 940ms DropTail
$ns duplex-link $n(193) $n(223) 1.5Mb 440ms DropTail
$ns duplex-link $n(193) $n(222) 1.5Mb 860ms DropTail
$ns duplex-link $n(193) $n(218) 1.5Mb 100ms DropTail
$ns duplex-link $n(193) $n(211) 1.5Mb 740ms DropTail
$ns duplex-link $n(193) $n(209) 1.5Mb 990ms DropTail
if {$verbose} { puts -nonewline "5890..."; flush stdout }
$ns duplex-link $n(193) $n(202) 1.5Mb 1000ms DropTail
$ns duplex-link $n(193) $n(201) 1.5Mb 930ms DropTail
$ns duplex-link $n(193) $n(200) 1.5Mb 340ms DropTail
$ns duplex-link $n(194) $n(248) 1.5Mb 100ms DropTail
$ns duplex-link $n(194) $n(245) 1.5Mb 450ms DropTail
$ns duplex-link $n(194) $n(243) 1.5Mb 480ms DropTail
$ns duplex-link $n(194) $n(242) 1.5Mb 240ms DropTail
$ns duplex-link $n(194) $n(236) 1.5Mb 550ms DropTail
$ns duplex-link $n(194) $n(235) 1.5Mb 440ms DropTail
$ns duplex-link $n(194) $n(227) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "5900..."; flush stdout }
$ns duplex-link $n(194) $n(226) 1.5Mb 460ms DropTail
$ns duplex-link $n(194) $n(218) 1.5Mb 920ms DropTail
$ns duplex-link $n(194) $n(217) 1.5Mb 120ms DropTail
$ns duplex-link $n(194) $n(216) 1.5Mb 520ms DropTail
$ns duplex-link $n(194) $n(205) 1.5Mb 510ms DropTail
$ns duplex-link $n(195) $n(248) 1.5Mb 780ms DropTail
$ns duplex-link $n(195) $n(239) 1.5Mb 340ms DropTail
$ns duplex-link $n(195) $n(237) 1.5Mb 670ms DropTail
$ns duplex-link $n(195) $n(227) 1.5Mb 480ms DropTail
$ns duplex-link $n(195) $n(221) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "5910..."; flush stdout }
$ns duplex-link $n(195) $n(220) 1.5Mb 840ms DropTail
$ns duplex-link $n(195) $n(218) 1.5Mb 50ms DropTail
$ns duplex-link $n(195) $n(216) 1.5Mb 780ms DropTail
$ns duplex-link $n(195) $n(215) 1.5Mb 230ms DropTail
$ns duplex-link $n(195) $n(211) 1.5Mb 650ms DropTail
$ns duplex-link $n(195) $n(204) 1.5Mb 570ms DropTail
$ns duplex-link $n(195) $n(201) 1.5Mb 780ms DropTail
$ns duplex-link $n(195) $n(199) 1.5Mb 130ms DropTail
$ns duplex-link $n(195) $n(198) 1.5Mb 1110ms DropTail
$ns duplex-link $n(196) $n(247) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "5920..."; flush stdout }
$ns duplex-link $n(196) $n(238) 1.5Mb 490ms DropTail
$ns duplex-link $n(196) $n(234) 1.5Mb 470ms DropTail
$ns duplex-link $n(196) $n(231) 1.5Mb 360ms DropTail
$ns duplex-link $n(196) $n(225) 1.5Mb 560ms DropTail
$ns duplex-link $n(196) $n(223) 1.5Mb 630ms DropTail
$ns duplex-link $n(196) $n(220) 1.5Mb 430ms DropTail
$ns duplex-link $n(196) $n(215) 1.5Mb 790ms DropTail
$ns duplex-link $n(196) $n(212) 1.5Mb 530ms DropTail
$ns duplex-link $n(196) $n(211) 1.5Mb 430ms DropTail
$ns duplex-link $n(196) $n(201) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "5930..."; flush stdout }
$ns duplex-link $n(197) $n(240) 1.5Mb 650ms DropTail
$ns duplex-link $n(197) $n(236) 1.5Mb 310ms DropTail
$ns duplex-link $n(197) $n(224) 1.5Mb 200ms DropTail
$ns duplex-link $n(197) $n(213) 1.5Mb 190ms DropTail
$ns duplex-link $n(197) $n(208) 1.5Mb 610ms DropTail
$ns duplex-link $n(197) $n(207) 1.5Mb 570ms DropTail
$ns duplex-link $n(197) $n(199) 1.5Mb 170ms DropTail
$ns duplex-link $n(198) $n(246) 1.5Mb 770ms DropTail
$ns duplex-link $n(198) $n(241) 1.5Mb 760ms DropTail
$ns duplex-link $n(198) $n(237) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "5940..."; flush stdout }
$ns duplex-link $n(198) $n(224) 1.5Mb 910ms DropTail
$ns duplex-link $n(198) $n(220) 1.5Mb 450ms DropTail
$ns duplex-link $n(198) $n(208) 1.5Mb 600ms DropTail
$ns duplex-link $n(198) $n(207) 1.5Mb 520ms DropTail
$ns duplex-link $n(198) $n(205) 1.5Mb 680ms DropTail
$ns duplex-link $n(198) $n(204) 1.5Mb 880ms DropTail
$ns duplex-link $n(198) $n(203) 1.5Mb 840ms DropTail
$ns duplex-link $n(198) $n(199) 1.5Mb 1240ms DropTail
$ns duplex-link $n(199) $n(247) 1.5Mb 650ms DropTail
$ns duplex-link $n(199) $n(237) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "5950..."; flush stdout }
$ns duplex-link $n(199) $n(232) 1.5Mb 90ms DropTail
$ns duplex-link $n(199) $n(230) 1.5Mb 510ms DropTail
$ns duplex-link $n(199) $n(227) 1.5Mb 560ms DropTail
$ns duplex-link $n(199) $n(220) 1.5Mb 950ms DropTail
$ns duplex-link $n(199) $n(218) 1.5Mb 80ms DropTail
$ns duplex-link $n(199) $n(213) 1.5Mb 360ms DropTail
$ns duplex-link $n(199) $n(206) 1.5Mb 440ms DropTail
$ns duplex-link $n(200) $n(236) 1.5Mb 330ms DropTail
$ns duplex-link $n(200) $n(235) 1.5Mb 660ms DropTail
$ns duplex-link $n(200) $n(233) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "5960..."; flush stdout }
$ns duplex-link $n(200) $n(229) 1.5Mb 810ms DropTail
$ns duplex-link $n(200) $n(222) 1.5Mb 700ms DropTail
$ns duplex-link $n(200) $n(221) 1.5Mb 510ms DropTail
$ns duplex-link $n(200) $n(219) 1.5Mb 510ms DropTail
$ns duplex-link $n(200) $n(217) 1.5Mb 760ms DropTail
$ns duplex-link $n(200) $n(214) 1.5Mb 630ms DropTail
$ns duplex-link $n(200) $n(208) 1.5Mb 530ms DropTail
$ns duplex-link $n(200) $n(201) 1.5Mb 590ms DropTail
$ns duplex-link $n(201) $n(244) 1.5Mb 330ms DropTail
$ns duplex-link $n(201) $n(243) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "5970..."; flush stdout }
$ns duplex-link $n(201) $n(233) 1.5Mb 880ms DropTail
$ns duplex-link $n(201) $n(227) 1.5Mb 1030ms DropTail
$ns duplex-link $n(201) $n(226) 1.5Mb 760ms DropTail
$ns duplex-link $n(201) $n(224) 1.5Mb 720ms DropTail
$ns duplex-link $n(201) $n(219) 1.5Mb 800ms DropTail
$ns duplex-link $n(201) $n(213) 1.5Mb 580ms DropTail
$ns duplex-link $n(201) $n(212) 1.5Mb 590ms DropTail
$ns duplex-link $n(201) $n(211) 1.5Mb 890ms DropTail
$ns duplex-link $n(201) $n(209) 1.5Mb 150ms DropTail
$ns duplex-link $n(201) $n(206) 1.5Mb 1010ms DropTail
if {$verbose} { puts -nonewline "5980..."; flush stdout }
$ns duplex-link $n(202) $n(245) 1.5Mb 600ms DropTail
$ns duplex-link $n(202) $n(244) 1.5Mb 470ms DropTail
$ns duplex-link $n(202) $n(240) 1.5Mb 660ms DropTail
$ns duplex-link $n(202) $n(237) 1.5Mb 530ms DropTail
$ns duplex-link $n(202) $n(236) 1.5Mb 530ms DropTail
$ns duplex-link $n(202) $n(234) 1.5Mb 520ms DropTail
$ns duplex-link $n(202) $n(233) 1.5Mb 410ms DropTail
$ns duplex-link $n(202) $n(227) 1.5Mb 690ms DropTail
$ns duplex-link $n(202) $n(223) 1.5Mb 770ms DropTail
$ns duplex-link $n(202) $n(214) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "5990..."; flush stdout }
$ns duplex-link $n(203) $n(245) 1.5Mb 70ms DropTail
$ns duplex-link $n(203) $n(243) 1.5Mb 560ms DropTail
$ns duplex-link $n(203) $n(239) 1.5Mb 730ms DropTail
$ns duplex-link $n(203) $n(232) 1.5Mb 740ms DropTail
$ns duplex-link $n(203) $n(231) 1.5Mb 980ms DropTail
$ns duplex-link $n(203) $n(221) 1.5Mb 900ms DropTail
$ns duplex-link $n(203) $n(220) 1.5Mb 390ms DropTail
$ns duplex-link $n(203) $n(207) 1.5Mb 630ms DropTail
$ns duplex-link $n(203) $n(204) 1.5Mb 1000ms DropTail
$ns duplex-link $n(204) $n(239) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "6000..."; flush stdout }
$ns duplex-link $n(204) $n(229) 1.5Mb 670ms DropTail
$ns duplex-link $n(204) $n(226) 1.5Mb 790ms DropTail
$ns duplex-link $n(204) $n(225) 1.5Mb 220ms DropTail
$ns duplex-link $n(204) $n(224) 1.5Mb 520ms DropTail
$ns duplex-link $n(204) $n(219) 1.5Mb 640ms DropTail
$ns duplex-link $n(204) $n(210) 1.5Mb 40ms DropTail
$ns duplex-link $n(204) $n(209) 1.5Mb 290ms DropTail
$ns duplex-link $n(204) $n(207) 1.5Mb 450ms DropTail
$ns duplex-link $n(205) $n(237) 1.5Mb 510ms DropTail
$ns duplex-link $n(205) $n(236) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "6010..."; flush stdout }
$ns duplex-link $n(205) $n(229) 1.5Mb 430ms DropTail
$ns duplex-link $n(205) $n(225) 1.5Mb 540ms DropTail
$ns duplex-link $n(205) $n(217) 1.5Mb 400ms DropTail
$ns duplex-link $n(205) $n(214) 1.5Mb 400ms DropTail
$ns duplex-link $n(206) $n(243) 1.5Mb 450ms DropTail
$ns duplex-link $n(206) $n(236) 1.5Mb 380ms DropTail
$ns duplex-link $n(206) $n(228) 1.5Mb 280ms DropTail
$ns duplex-link $n(206) $n(226) 1.5Mb 1050ms DropTail
$ns duplex-link $n(206) $n(223) 1.5Mb 590ms DropTail
$ns duplex-link $n(206) $n(222) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "6020..."; flush stdout }
$ns duplex-link $n(206) $n(214) 1.5Mb 910ms DropTail
$ns duplex-link $n(206) $n(213) 1.5Mb 450ms DropTail
$ns duplex-link $n(207) $n(244) 1.5Mb 380ms DropTail
$ns duplex-link $n(207) $n(240) 1.5Mb 600ms DropTail
$ns duplex-link $n(207) $n(236) 1.5Mb 270ms DropTail
$ns duplex-link $n(207) $n(230) 1.5Mb 560ms DropTail
$ns duplex-link $n(207) $n(221) 1.5Mb 280ms DropTail
$ns duplex-link $n(207) $n(219) 1.5Mb 310ms DropTail
$ns duplex-link $n(207) $n(213) 1.5Mb 380ms DropTail
$ns duplex-link $n(208) $n(245) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "6030..."; flush stdout }
$ns duplex-link $n(208) $n(242) 1.5Mb 620ms DropTail
$ns duplex-link $n(208) $n(240) 1.5Mb 810ms DropTail
$ns duplex-link $n(208) $n(236) 1.5Mb 390ms DropTail
$ns duplex-link $n(208) $n(224) 1.5Mb 510ms DropTail
$ns duplex-link $n(208) $n(212) 1.5Mb 410ms DropTail
$ns duplex-link $n(209) $n(247) 1.5Mb 310ms DropTail
$ns duplex-link $n(209) $n(238) 1.5Mb 520ms DropTail
$ns duplex-link $n(209) $n(230) 1.5Mb 990ms DropTail
$ns duplex-link $n(209) $n(222) 1.5Mb 610ms DropTail
$ns duplex-link $n(209) $n(221) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "6040..."; flush stdout }
$ns duplex-link $n(209) $n(220) 1.5Mb 880ms DropTail
$ns duplex-link $n(209) $n(214) 1.5Mb 140ms DropTail
$ns duplex-link $n(209) $n(213) 1.5Mb 610ms DropTail
$ns duplex-link $n(210) $n(247) 1.5Mb 60ms DropTail
$ns duplex-link $n(210) $n(243) 1.5Mb 400ms DropTail
$ns duplex-link $n(210) $n(239) 1.5Mb 250ms DropTail
$ns duplex-link $n(210) $n(234) 1.5Mb 500ms DropTail
$ns duplex-link $n(210) $n(228) 1.5Mb 690ms DropTail
$ns duplex-link $n(210) $n(226) 1.5Mb 760ms DropTail
$ns duplex-link $n(210) $n(218) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "6050..."; flush stdout }
$ns duplex-link $n(211) $n(247) 1.5Mb 770ms DropTail
$ns duplex-link $n(211) $n(246) 1.5Mb 480ms DropTail
$ns duplex-link $n(211) $n(245) 1.5Mb 240ms DropTail
$ns duplex-link $n(211) $n(244) 1.5Mb 700ms DropTail
$ns duplex-link $n(211) $n(238) 1.5Mb 530ms DropTail
$ns duplex-link $n(211) $n(234) 1.5Mb 290ms DropTail
$ns duplex-link $n(211) $n(227) 1.5Mb 340ms DropTail
$ns duplex-link $n(211) $n(226) 1.5Mb 650ms DropTail
$ns duplex-link $n(211) $n(219) 1.5Mb 190ms DropTail
$ns duplex-link $n(211) $n(217) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "6060..."; flush stdout }
$ns duplex-link $n(211) $n(212) 1.5Mb 490ms DropTail
$ns duplex-link $n(212) $n(248) 1.5Mb 580ms DropTail
$ns duplex-link $n(212) $n(242) 1.5Mb 840ms DropTail
$ns duplex-link $n(212) $n(240) 1.5Mb 590ms DropTail
$ns duplex-link $n(212) $n(239) 1.5Mb 100ms DropTail
$ns duplex-link $n(212) $n(236) 1.5Mb 130ms DropTail
$ns duplex-link $n(212) $n(233) 1.5Mb 460ms DropTail
$ns duplex-link $n(212) $n(215) 1.5Mb 360ms DropTail
$ns duplex-link $n(213) $n(247) 1.5Mb 370ms DropTail
$ns duplex-link $n(213) $n(246) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "6070..."; flush stdout }
$ns duplex-link $n(213) $n(244) 1.5Mb 620ms DropTail
$ns duplex-link $n(213) $n(240) 1.5Mb 620ms DropTail
$ns duplex-link $n(213) $n(239) 1.5Mb 100ms DropTail
$ns duplex-link $n(213) $n(238) 1.5Mb 90ms DropTail
$ns duplex-link $n(213) $n(236) 1.5Mb 160ms DropTail
$ns duplex-link $n(213) $n(234) 1.5Mb 240ms DropTail
$ns duplex-link $n(213) $n(229) 1.5Mb 650ms DropTail
$ns duplex-link $n(213) $n(220) 1.5Mb 690ms DropTail
$ns duplex-link $n(214) $n(243) 1.5Mb 460ms DropTail
$ns duplex-link $n(214) $n(239) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "6080..."; flush stdout }
$ns duplex-link $n(214) $n(238) 1.5Mb 460ms DropTail
$ns duplex-link $n(214) $n(232) 1.5Mb 810ms DropTail
$ns duplex-link $n(214) $n(231) 1.5Mb 70ms DropTail
$ns duplex-link $n(215) $n(247) 1.5Mb 730ms DropTail
$ns duplex-link $n(215) $n(240) 1.5Mb 430ms DropTail
$ns duplex-link $n(215) $n(235) 1.5Mb 400ms DropTail
$ns duplex-link $n(215) $n(232) 1.5Mb 250ms DropTail
$ns duplex-link $n(215) $n(227) 1.5Mb 280ms DropTail
$ns duplex-link $n(215) $n(225) 1.5Mb 950ms DropTail
$ns duplex-link $n(215) $n(221) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "6090..."; flush stdout }
$ns duplex-link $n(216) $n(236) 1.5Mb 620ms DropTail
$ns duplex-link $n(216) $n(232) 1.5Mb 810ms DropTail
$ns duplex-link $n(216) $n(230) 1.5Mb 350ms DropTail
$ns duplex-link $n(216) $n(229) 1.5Mb 740ms DropTail
$ns duplex-link $n(216) $n(228) 1.5Mb 700ms DropTail
$ns duplex-link $n(216) $n(221) 1.5Mb 960ms DropTail
$ns duplex-link $n(216) $n(218) 1.5Mb 800ms DropTail
$ns duplex-link $n(216) $n(217) 1.5Mb 490ms DropTail
$ns duplex-link $n(217) $n(249) 1.5Mb 360ms DropTail
$ns duplex-link $n(217) $n(236) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "6100..."; flush stdout }
$ns duplex-link $n(217) $n(234) 1.5Mb 390ms DropTail
$ns duplex-link $n(217) $n(231) 1.5Mb 640ms DropTail
$ns duplex-link $n(217) $n(226) 1.5Mb 490ms DropTail
$ns duplex-link $n(217) $n(225) 1.5Mb 840ms DropTail
$ns duplex-link $n(217) $n(220) 1.5Mb 130ms DropTail
$ns duplex-link $n(218) $n(247) 1.5Mb 610ms DropTail
$ns duplex-link $n(218) $n(246) 1.5Mb 450ms DropTail
$ns duplex-link $n(218) $n(243) 1.5Mb 490ms DropTail
$ns duplex-link $n(218) $n(241) 1.5Mb 400ms DropTail
$ns duplex-link $n(218) $n(237) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "6110..."; flush stdout }
$ns duplex-link $n(218) $n(229) 1.5Mb 920ms DropTail
$ns duplex-link $n(218) $n(226) 1.5Mb 1150ms DropTail
$ns duplex-link $n(218) $n(225) 1.5Mb 840ms DropTail
$ns duplex-link $n(219) $n(238) 1.5Mb 380ms DropTail
$ns duplex-link $n(219) $n(237) 1.5Mb 260ms DropTail
$ns duplex-link $n(219) $n(232) 1.5Mb 500ms DropTail
$ns duplex-link $n(219) $n(230) 1.5Mb 250ms DropTail
$ns duplex-link $n(219) $n(229) 1.5Mb 490ms DropTail
$ns duplex-link $n(219) $n(226) 1.5Mb 740ms DropTail
$ns duplex-link $n(219) $n(224) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "6120..."; flush stdout }
$ns duplex-link $n(219) $n(222) 1.5Mb 340ms DropTail
$ns duplex-link $n(220) $n(245) 1.5Mb 350ms DropTail
$ns duplex-link $n(220) $n(244) 1.5Mb 730ms DropTail
$ns duplex-link $n(220) $n(243) 1.5Mb 470ms DropTail
$ns duplex-link $n(220) $n(229) 1.5Mb 340ms DropTail
$ns duplex-link $n(220) $n(226) 1.5Mb 550ms DropTail
$ns duplex-link $n(220) $n(223) 1.5Mb 840ms DropTail
$ns duplex-link $n(221) $n(249) 1.5Mb 600ms DropTail
$ns duplex-link $n(221) $n(248) 1.5Mb 590ms DropTail
$ns duplex-link $n(221) $n(241) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "6130..."; flush stdout }
$ns duplex-link $n(221) $n(236) 1.5Mb 420ms DropTail
$ns duplex-link $n(221) $n(229) 1.5Mb 450ms DropTail
$ns duplex-link $n(221) $n(228) 1.5Mb 780ms DropTail
$ns duplex-link $n(221) $n(224) 1.5Mb 530ms DropTail
$ns duplex-link $n(222) $n(233) 1.5Mb 300ms DropTail
$ns duplex-link $n(222) $n(230) 1.5Mb 580ms DropTail
$ns duplex-link $n(222) $n(226) 1.5Mb 400ms DropTail
$ns duplex-link $n(223) $n(249) 1.5Mb 930ms DropTail
$ns duplex-link $n(223) $n(245) 1.5Mb 790ms DropTail
$ns duplex-link $n(223) $n(239) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "6140..."; flush stdout }
$ns duplex-link $n(223) $n(238) 1.5Mb 150ms DropTail
$ns duplex-link $n(223) $n(234) 1.5Mb 400ms DropTail
$ns duplex-link $n(223) $n(233) 1.5Mb 650ms DropTail
$ns duplex-link $n(223) $n(226) 1.5Mb 940ms DropTail
$ns duplex-link $n(223) $n(224) 1.5Mb 310ms DropTail
$ns duplex-link $n(224) $n(245) 1.5Mb 490ms DropTail
$ns duplex-link $n(224) $n(241) 1.5Mb 140ms DropTail
$ns duplex-link $n(224) $n(239) 1.5Mb 230ms DropTail
$ns duplex-link $n(224) $n(237) 1.5Mb 490ms DropTail
$ns duplex-link $n(224) $n(235) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "6150..."; flush stdout }
$ns duplex-link $n(224) $n(229) 1.5Mb 670ms DropTail
$ns duplex-link $n(224) $n(226) 1.5Mb 900ms DropTail
$ns duplex-link $n(225) $n(246) 1.5Mb 470ms DropTail
$ns duplex-link $n(225) $n(244) 1.5Mb 320ms DropTail
$ns duplex-link $n(225) $n(243) 1.5Mb 600ms DropTail
$ns duplex-link $n(226) $n(249) 1.5Mb 170ms DropTail
$ns duplex-link $n(226) $n(247) 1.5Mb 820ms DropTail
$ns duplex-link $n(226) $n(245) 1.5Mb 880ms DropTail
$ns duplex-link $n(226) $n(240) 1.5Mb 950ms DropTail
$ns duplex-link $n(226) $n(237) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "6160..."; flush stdout }
$ns duplex-link $n(226) $n(233) 1.5Mb 690ms DropTail
$ns duplex-link $n(226) $n(230) 1.5Mb 990ms DropTail
$ns duplex-link $n(227) $n(249) 1.5Mb 850ms DropTail
$ns duplex-link $n(227) $n(248) 1.5Mb 510ms DropTail
$ns duplex-link $n(227) $n(247) 1.5Mb 850ms DropTail
$ns duplex-link $n(227) $n(239) 1.5Mb 560ms DropTail
$ns duplex-link $n(227) $n(238) 1.5Mb 560ms DropTail
$ns duplex-link $n(227) $n(231) 1.5Mb 880ms DropTail
$ns duplex-link $n(227) $n(229) 1.5Mb 720ms DropTail
$ns duplex-link $n(228) $n(243) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "6170..."; flush stdout }
$ns duplex-link $n(228) $n(235) 1.5Mb 510ms DropTail
$ns duplex-link $n(228) $n(234) 1.5Mb 400ms DropTail
$ns duplex-link $n(229) $n(239) 1.5Mb 590ms DropTail
$ns duplex-link $n(229) $n(235) 1.5Mb 590ms DropTail
$ns duplex-link $n(229) $n(233) 1.5Mb 440ms DropTail
$ns duplex-link $n(230) $n(247) 1.5Mb 820ms DropTail
$ns duplex-link $n(230) $n(243) 1.5Mb 420ms DropTail
$ns duplex-link $n(230) $n(240) 1.5Mb 200ms DropTail
$ns duplex-link $n(230) $n(234) 1.5Mb 280ms DropTail
$ns duplex-link $n(231) $n(247) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "6180..."; flush stdout }
$ns duplex-link $n(231) $n(237) 1.5Mb 860ms DropTail
$ns duplex-link $n(232) $n(240) 1.5Mb 660ms DropTail
$ns duplex-link $n(232) $n(237) 1.5Mb 700ms DropTail
$ns duplex-link $n(233) $n(248) 1.5Mb 220ms DropTail
$ns duplex-link $n(233) $n(243) 1.5Mb 300ms DropTail
$ns duplex-link $n(233) $n(239) 1.5Mb 500ms DropTail
$ns duplex-link $n(233) $n(237) 1.5Mb 160ms DropTail
$ns duplex-link $n(234) $n(235) 1.5Mb 270ms DropTail
$ns duplex-link $n(235) $n(248) 1.5Mb 360ms DropTail
$ns duplex-link $n(235) $n(245) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "6190..."; flush stdout }
$ns duplex-link $n(235) $n(238) 1.5Mb 550ms DropTail
$ns duplex-link $n(236) $n(245) 1.5Mb 480ms DropTail
$ns duplex-link $n(236) $n(242) 1.5Mb 720ms DropTail
$ns duplex-link $n(236) $n(241) 1.5Mb 50ms DropTail
$ns duplex-link $n(236) $n(239) 1.5Mb 180ms DropTail
$ns duplex-link $n(237) $n(248) 1.5Mb 320ms DropTail
$ns duplex-link $n(237) $n(247) 1.5Mb 900ms DropTail
$ns duplex-link $n(237) $n(245) 1.5Mb 70ms DropTail
$ns duplex-link $n(238) $n(246) 1.5Mb 90ms DropTail
$ns duplex-link $n(239) $n(249) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "6200..."; flush stdout }
$ns duplex-link $n(239) $n(247) 1.5Mb 290ms DropTail
$ns duplex-link $n(239) $n(246) 1.5Mb 70ms DropTail
$ns duplex-link $n(239) $n(243) 1.5Mb 210ms DropTail
$ns duplex-link $n(240) $n(249) 1.5Mb 810ms DropTail
$ns duplex-link $n(241) $n(249) 1.5Mb 690ms DropTail
$ns duplex-link $n(241) $n(248) 1.5Mb 430ms DropTail
$ns duplex-link $n(241) $n(245) 1.5Mb 430ms DropTail
$ns duplex-link $n(242) $n(247) 1.5Mb 920ms DropTail
$ns duplex-link $n(244) $n(248) 1.5Mb 620ms DropTail
$ns duplex-link $n(247) $n(249) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "6210..."; flush stdout }
if {$verbose} { puts ""}

set mproto CtrMcast
set mrthandle [$ns mrtproto $mproto {}]
$ns at 0 "$mrthandle switch-treetype $g"

if {$verbose} {puts "starting"}
set rcvr118 [new Agent/Null]
$ns attach-agent $n(118) $rcvr118
$ns at 1 "$n(118) join-group $rcvr118 $g"
set rcvr87 [new Agent/Null]
$ns attach-agent $n(87) $rcvr87
$ns at 2 "$n(87) join-group $rcvr87 $g"
set rcvr241 [new Agent/Null]
$ns attach-agent $n(241) $rcvr241
$ns at 3 "$n(241) join-group $rcvr241 $g"
set rcvr123 [new Agent/Null]
$ns attach-agent $n(123) $rcvr123
$ns at 4 "$n(123) join-group $rcvr123 $g"
set rcvr17 [new Agent/Null]
$ns attach-agent $n(17) $rcvr17
$ns at 5 "$n(17) join-group $rcvr17 $g"
set rcvr65 [new Agent/Null]
$ns attach-agent $n(65) $rcvr65
$ns at 6 "$n(65) join-group $rcvr65 $g"
set rcvr164 [new Agent/Null]
$ns attach-agent $n(164) $rcvr164
$ns at 7 "$n(164) join-group $rcvr164 $g"
set rcvr197 [new Agent/Null]
$ns attach-agent $n(197) $rcvr197
$ns at 8 "$n(197) join-group $rcvr197 $g"
set rcvr19 [new Agent/Null]
$ns attach-agent $n(19) $rcvr19
$ns at 9 "$n(19) join-group $rcvr19 $g"
set rcvr66 [new Agent/Null]
$ns attach-agent $n(66) $rcvr66
$ns at 10 "$n(66) join-group $rcvr66 $g"

set sender [new Agent/CBR]
$sender set dst_ $g
$sender set class_ 2
$ns attach-agent $n(2) $sender

$ns at 0 "$sender start"

# START ns
$ns at 10.99 "[$ns clearMemTrace]"
$ns at 11 "exit 0"
$ns run

