#
# tcl/ex/newmcast/cmcast-100.tcl
#
# Copyright (C) 1997 by USC/ISI
# All rights reserved.                                            
#                                                                
# Redistribution and use in source and binary forms are permitted
# provided that the above copyright notice and this paragraph are
# duplicated in all such forms and that any documentation, advertising
# materials, and other materials related to such distribution and use
# acknowledge that the software was developed by the University of
# Southern California, Information Sciences Institute.  The name of the
# University may not be used to endorse or promote products derived from
# this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# 
# Contributed by Polly Huang (USC/ISI), http://www-scf.usc.edu/~bhuang
# 
#
# Generated by sgb2nsctr, sgb2nsctr created by Polly Huang
# GRAPH (#nodes #edges id uu vv ww xx yy zz):
# 100 1900 geo(0,{100,100,3,0.200,0.250,75.000}) 100 

set verbose 1
set ns [new Simulator]
Simulator set EnableMcast_ 1
Simulator set NumberInterfaces_ 1
Node expandaddr
set g [Node allocaddr]

if {$verbose} { puts "creating 100 nodes..." }
for {set i 0} {$i < 100} {incr i} {
	set n($i) [$ns node]
}

# EDGES (from-node to-node length a b):
if {$verbose} { puts -nonewline "Creating links 0..."; flush stdout }
$ns duplex-link $n(0) $n(98) 1.5Mb 500ms DropTail
$ns duplex-link $n(0) $n(96) 1.5Mb 240ms DropTail
$ns duplex-link $n(0) $n(93) 1.5Mb 520ms DropTail
$ns duplex-link $n(0) $n(90) 1.5Mb 400ms DropTail
$ns duplex-link $n(0) $n(82) 1.5Mb 350ms DropTail
$ns duplex-link $n(0) $n(70) 1.5Mb 360ms DropTail
$ns duplex-link $n(0) $n(61) 1.5Mb 430ms DropTail
$ns duplex-link $n(0) $n(59) 1.5Mb 300ms DropTail
$ns duplex-link $n(0) $n(53) 1.5Mb 470ms DropTail
$ns duplex-link $n(0) $n(50) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "10..."; flush stdout }
$ns duplex-link $n(0) $n(49) 1.5Mb 430ms DropTail
$ns duplex-link $n(0) $n(37) 1.5Mb 290ms DropTail
$ns duplex-link $n(0) $n(22) 1.5Mb 360ms DropTail
$ns duplex-link $n(0) $n(17) 1.5Mb 660ms DropTail
$ns duplex-link $n(0) $n(10) 1.5Mb 630ms DropTail
$ns duplex-link $n(0) $n(7) 1.5Mb 480ms DropTail
$ns duplex-link $n(0) $n(4) 1.5Mb 410ms DropTail
$ns duplex-link $n(0) $n(2) 1.5Mb 470ms DropTail
$ns duplex-link $n(1) $n(99) 1.5Mb 1020ms DropTail
$ns duplex-link $n(1) $n(90) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "20..."; flush stdout }
$ns duplex-link $n(1) $n(84) 1.5Mb 280ms DropTail
$ns duplex-link $n(1) $n(77) 1.5Mb 420ms DropTail
$ns duplex-link $n(1) $n(76) 1.5Mb 760ms DropTail
$ns duplex-link $n(1) $n(74) 1.5Mb 270ms DropTail
$ns duplex-link $n(1) $n(72) 1.5Mb 600ms DropTail
$ns duplex-link $n(1) $n(56) 1.5Mb 670ms DropTail
$ns duplex-link $n(1) $n(53) 1.5Mb 1130ms DropTail
$ns duplex-link $n(1) $n(51) 1.5Mb 80ms DropTail
$ns duplex-link $n(1) $n(49) 1.5Mb 710ms DropTail
$ns duplex-link $n(1) $n(42) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "30..."; flush stdout }
$ns duplex-link $n(1) $n(36) 1.5Mb 870ms DropTail
$ns duplex-link $n(1) $n(34) 1.5Mb 800ms DropTail
$ns duplex-link $n(1) $n(29) 1.5Mb 380ms DropTail
$ns duplex-link $n(1) $n(21) 1.5Mb 60ms DropTail
$ns duplex-link $n(1) $n(11) 1.5Mb 340ms DropTail
$ns duplex-link $n(1) $n(10) 1.5Mb 890ms DropTail
$ns duplex-link $n(2) $n(96) 1.5Mb 560ms DropTail
$ns duplex-link $n(2) $n(85) 1.5Mb 670ms DropTail
$ns duplex-link $n(2) $n(83) 1.5Mb 360ms DropTail
$ns duplex-link $n(2) $n(79) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "40..."; flush stdout }
$ns duplex-link $n(2) $n(73) 1.5Mb 350ms DropTail
$ns duplex-link $n(2) $n(71) 1.5Mb 510ms DropTail
$ns duplex-link $n(2) $n(66) 1.5Mb 570ms DropTail
$ns duplex-link $n(2) $n(65) 1.5Mb 280ms DropTail
$ns duplex-link $n(2) $n(58) 1.5Mb 930ms DropTail
$ns duplex-link $n(2) $n(20) 1.5Mb 110ms DropTail
$ns duplex-link $n(2) $n(14) 1.5Mb 830ms DropTail
$ns duplex-link $n(3) $n(96) 1.5Mb 370ms DropTail
$ns duplex-link $n(3) $n(94) 1.5Mb 350ms DropTail
$ns duplex-link $n(3) $n(90) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "50..."; flush stdout }
$ns duplex-link $n(3) $n(89) 1.5Mb 330ms DropTail
$ns duplex-link $n(3) $n(87) 1.5Mb 630ms DropTail
$ns duplex-link $n(3) $n(86) 1.5Mb 900ms DropTail
$ns duplex-link $n(3) $n(83) 1.5Mb 680ms DropTail
$ns duplex-link $n(3) $n(78) 1.5Mb 940ms DropTail
$ns duplex-link $n(3) $n(73) 1.5Mb 560ms DropTail
$ns duplex-link $n(3) $n(66) 1.5Mb 390ms DropTail
$ns duplex-link $n(3) $n(61) 1.5Mb 680ms DropTail
$ns duplex-link $n(3) $n(59) 1.5Mb 260ms DropTail
$ns duplex-link $n(3) $n(50) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "60..."; flush stdout }
$ns duplex-link $n(3) $n(45) 1.5Mb 630ms DropTail
$ns duplex-link $n(3) $n(43) 1.5Mb 690ms DropTail
$ns duplex-link $n(3) $n(41) 1.5Mb 890ms DropTail
$ns duplex-link $n(3) $n(27) 1.5Mb 790ms DropTail
$ns duplex-link $n(3) $n(25) 1.5Mb 420ms DropTail
$ns duplex-link $n(3) $n(11) 1.5Mb 390ms DropTail
$ns duplex-link $n(3) $n(6) 1.5Mb 480ms DropTail
$ns duplex-link $n(4) $n(88) 1.5Mb 320ms DropTail
$ns duplex-link $n(4) $n(87) 1.5Mb 130ms DropTail
$ns duplex-link $n(4) $n(85) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "70..."; flush stdout }
$ns duplex-link $n(4) $n(77) 1.5Mb 240ms DropTail
$ns duplex-link $n(4) $n(75) 1.5Mb 560ms DropTail
$ns duplex-link $n(4) $n(65) 1.5Mb 580ms DropTail
$ns duplex-link $n(4) $n(62) 1.5Mb 220ms DropTail
$ns duplex-link $n(4) $n(52) 1.5Mb 440ms DropTail
$ns duplex-link $n(4) $n(50) 1.5Mb 400ms DropTail
$ns duplex-link $n(4) $n(49) 1.5Mb 480ms DropTail
$ns duplex-link $n(4) $n(26) 1.5Mb 240ms DropTail
$ns duplex-link $n(4) $n(22) 1.5Mb 290ms DropTail
$ns duplex-link $n(4) $n(7) 1.5Mb 80ms DropTail
if {$verbose} { puts -nonewline "80..."; flush stdout }
$ns duplex-link $n(4) $n(6) 1.5Mb 90ms DropTail
$ns duplex-link $n(5) $n(97) 1.5Mb 450ms DropTail
$ns duplex-link $n(5) $n(93) 1.5Mb 750ms DropTail
$ns duplex-link $n(5) $n(79) 1.5Mb 220ms DropTail
$ns duplex-link $n(5) $n(76) 1.5Mb 650ms DropTail
$ns duplex-link $n(5) $n(67) 1.5Mb 620ms DropTail
$ns duplex-link $n(5) $n(58) 1.5Mb 680ms DropTail
$ns duplex-link $n(5) $n(39) 1.5Mb 70ms DropTail
$ns duplex-link $n(5) $n(35) 1.5Mb 600ms DropTail
$ns duplex-link $n(5) $n(31) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "90..."; flush stdout }
$ns duplex-link $n(5) $n(16) 1.5Mb 350ms DropTail
$ns duplex-link $n(5) $n(12) 1.5Mb 160ms DropTail
$ns duplex-link $n(5) $n(8) 1.5Mb 110ms DropTail
$ns duplex-link $n(5) $n(7) 1.5Mb 530ms DropTail
$ns duplex-link $n(6) $n(98) 1.5Mb 210ms DropTail
$ns duplex-link $n(6) $n(73) 1.5Mb 440ms DropTail
$ns duplex-link $n(6) $n(72) 1.5Mb 270ms DropTail
$ns duplex-link $n(6) $n(69) 1.5Mb 160ms DropTail
$ns duplex-link $n(6) $n(61) 1.5Mb 200ms DropTail
$ns duplex-link $n(6) $n(58) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "100..."; flush stdout }
$ns duplex-link $n(6) $n(56) 1.5Mb 320ms DropTail
$ns duplex-link $n(6) $n(54) 1.5Mb 240ms DropTail
$ns duplex-link $n(6) $n(51) 1.5Mb 330ms DropTail
$ns duplex-link $n(6) $n(50) 1.5Mb 370ms DropTail
$ns duplex-link $n(6) $n(42) 1.5Mb 400ms DropTail
$ns duplex-link $n(6) $n(36) 1.5Mb 500ms DropTail
$ns duplex-link $n(6) $n(35) 1.5Mb 580ms DropTail
$ns duplex-link $n(6) $n(30) 1.5Mb 410ms DropTail
$ns duplex-link $n(6) $n(22) 1.5Mb 230ms DropTail
$ns duplex-link $n(6) $n(10) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "110..."; flush stdout }
$ns duplex-link $n(6) $n(7) 1.5Mb 160ms DropTail
$ns duplex-link $n(7) $n(95) 1.5Mb 70ms DropTail
$ns duplex-link $n(7) $n(94) 1.5Mb 310ms DropTail
$ns duplex-link $n(7) $n(93) 1.5Mb 310ms DropTail
$ns duplex-link $n(7) $n(77) 1.5Mb 310ms DropTail
$ns duplex-link $n(7) $n(72) 1.5Mb 420ms DropTail
$ns duplex-link $n(7) $n(65) 1.5Mb 650ms DropTail
$ns duplex-link $n(7) $n(59) 1.5Mb 480ms DropTail
$ns duplex-link $n(7) $n(54) 1.5Mb 300ms DropTail
$ns duplex-link $n(7) $n(48) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "120..."; flush stdout }
$ns duplex-link $n(7) $n(44) 1.5Mb 80ms DropTail
$ns duplex-link $n(7) $n(37) 1.5Mb 730ms DropTail
$ns duplex-link $n(7) $n(34) 1.5Mb 630ms DropTail
$ns duplex-link $n(7) $n(33) 1.5Mb 680ms DropTail
$ns duplex-link $n(7) $n(27) 1.5Mb 340ms DropTail
$ns duplex-link $n(7) $n(25) 1.5Mb 530ms DropTail
$ns duplex-link $n(7) $n(24) 1.5Mb 490ms DropTail
$ns duplex-link $n(7) $n(10) 1.5Mb 690ms DropTail
$ns duplex-link $n(8) $n(98) 1.5Mb 400ms DropTail
$ns duplex-link $n(8) $n(93) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "130..."; flush stdout }
$ns duplex-link $n(8) $n(90) 1.5Mb 90ms DropTail
$ns duplex-link $n(8) $n(88) 1.5Mb 260ms DropTail
$ns duplex-link $n(8) $n(85) 1.5Mb 370ms DropTail
$ns duplex-link $n(8) $n(82) 1.5Mb 780ms DropTail
$ns duplex-link $n(8) $n(80) 1.5Mb 60ms DropTail
$ns duplex-link $n(8) $n(65) 1.5Mb 450ms DropTail
$ns duplex-link $n(8) $n(62) 1.5Mb 690ms DropTail
$ns duplex-link $n(8) $n(60) 1.5Mb 320ms DropTail
$ns duplex-link $n(8) $n(58) 1.5Mb 660ms DropTail
$ns duplex-link $n(8) $n(55) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "140..."; flush stdout }
$ns duplex-link $n(8) $n(38) 1.5Mb 700ms DropTail
$ns duplex-link $n(8) $n(36) 1.5Mb 270ms DropTail
$ns duplex-link $n(8) $n(23) 1.5Mb 610ms DropTail
$ns duplex-link $n(8) $n(13) 1.5Mb 500ms DropTail
$ns duplex-link $n(8) $n(9) 1.5Mb 350ms DropTail
$ns duplex-link $n(9) $n(97) 1.5Mb 580ms DropTail
$ns duplex-link $n(9) $n(96) 1.5Mb 400ms DropTail
$ns duplex-link $n(9) $n(85) 1.5Mb 390ms DropTail
$ns duplex-link $n(9) $n(79) 1.5Mb 530ms DropTail
$ns duplex-link $n(9) $n(73) 1.5Mb 710ms DropTail
if {$verbose} { puts -nonewline "150..."; flush stdout }
$ns duplex-link $n(9) $n(70) 1.5Mb 770ms DropTail
$ns duplex-link $n(9) $n(60) 1.5Mb 630ms DropTail
$ns duplex-link $n(9) $n(55) 1.5Mb 370ms DropTail
$ns duplex-link $n(9) $n(41) 1.5Mb 880ms DropTail
$ns duplex-link $n(9) $n(28) 1.5Mb 840ms DropTail
$ns duplex-link $n(9) $n(26) 1.5Mb 610ms DropTail
$ns duplex-link $n(9) $n(25) 1.5Mb 590ms DropTail
$ns duplex-link $n(9) $n(20) 1.5Mb 920ms DropTail
$ns duplex-link $n(9) $n(12) 1.5Mb 400ms DropTail
$ns duplex-link $n(9) $n(11) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "160..."; flush stdout }
$ns duplex-link $n(9) $n(10) 1.5Mb 480ms DropTail
$ns duplex-link $n(10) $n(95) 1.5Mb 670ms DropTail
$ns duplex-link $n(10) $n(87) 1.5Mb 780ms DropTail
$ns duplex-link $n(10) $n(83) 1.5Mb 710ms DropTail
$ns duplex-link $n(10) $n(81) 1.5Mb 520ms DropTail
$ns duplex-link $n(10) $n(80) 1.5Mb 280ms DropTail
$ns duplex-link $n(10) $n(79) 1.5Mb 480ms DropTail
$ns duplex-link $n(10) $n(76) 1.5Mb 900ms DropTail
$ns duplex-link $n(10) $n(74) 1.5Mb 640ms DropTail
$ns duplex-link $n(10) $n(67) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "170..."; flush stdout }
$ns duplex-link $n(10) $n(65) 1.5Mb 570ms DropTail
$ns duplex-link $n(10) $n(64) 1.5Mb 110ms DropTail
$ns duplex-link $n(10) $n(59) 1.5Mb 330ms DropTail
$ns duplex-link $n(10) $n(55) 1.5Mb 650ms DropTail
$ns duplex-link $n(10) $n(53) 1.5Mb 620ms DropTail
$ns duplex-link $n(10) $n(51) 1.5Mb 810ms DropTail
$ns duplex-link $n(10) $n(49) 1.5Mb 220ms DropTail
$ns duplex-link $n(10) $n(30) 1.5Mb 940ms DropTail
$ns duplex-link $n(10) $n(28) 1.5Mb 500ms DropTail
$ns duplex-link $n(10) $n(27) 1.5Mb 930ms DropTail
if {$verbose} { puts -nonewline "180..."; flush stdout }
$ns duplex-link $n(10) $n(22) 1.5Mb 400ms DropTail
$ns duplex-link $n(10) $n(17) 1.5Mb 670ms DropTail
$ns duplex-link $n(10) $n(16) 1.5Mb 360ms DropTail
$ns duplex-link $n(11) $n(97) 1.5Mb 470ms DropTail
$ns duplex-link $n(11) $n(92) 1.5Mb 270ms DropTail
$ns duplex-link $n(11) $n(91) 1.5Mb 720ms DropTail
$ns duplex-link $n(11) $n(86) 1.5Mb 770ms DropTail
$ns duplex-link $n(11) $n(81) 1.5Mb 330ms DropTail
$ns duplex-link $n(11) $n(72) 1.5Mb 560ms DropTail
$ns duplex-link $n(11) $n(61) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "190..."; flush stdout }
$ns duplex-link $n(11) $n(53) 1.5Mb 910ms DropTail
$ns duplex-link $n(11) $n(50) 1.5Mb 210ms DropTail
$ns duplex-link $n(11) $n(49) 1.5Mb 400ms DropTail
$ns duplex-link $n(11) $n(48) 1.5Mb 470ms DropTail
$ns duplex-link $n(11) $n(35) 1.5Mb 850ms DropTail
$ns duplex-link $n(11) $n(27) 1.5Mb 540ms DropTail
$ns duplex-link $n(11) $n(26) 1.5Mb 460ms DropTail
$ns duplex-link $n(11) $n(25) 1.5Mb 560ms DropTail
$ns duplex-link $n(11) $n(24) 1.5Mb 420ms DropTail
$ns duplex-link $n(11) $n(20) 1.5Mb 940ms DropTail
if {$verbose} { puts -nonewline "200..."; flush stdout }
$ns duplex-link $n(11) $n(19) 1.5Mb 410ms DropTail
$ns duplex-link $n(11) $n(17) 1.5Mb 120ms DropTail
$ns duplex-link $n(12) $n(86) 1.5Mb 630ms DropTail
$ns duplex-link $n(12) $n(80) 1.5Mb 110ms DropTail
$ns duplex-link $n(12) $n(70) 1.5Mb 550ms DropTail
$ns duplex-link $n(12) $n(67) 1.5Mb 470ms DropTail
$ns duplex-link $n(12) $n(38) 1.5Mb 530ms DropTail
$ns duplex-link $n(12) $n(35) 1.5Mb 540ms DropTail
$ns duplex-link $n(12) $n(32) 1.5Mb 490ms DropTail
$ns duplex-link $n(12) $n(29) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "210..."; flush stdout }
$ns duplex-link $n(12) $n(28) 1.5Mb 480ms DropTail
$ns duplex-link $n(12) $n(22) 1.5Mb 120ms DropTail
$ns duplex-link $n(12) $n(21) 1.5Mb 570ms DropTail
$ns duplex-link $n(13) $n(96) 1.5Mb 290ms DropTail
$ns duplex-link $n(13) $n(90) 1.5Mb 400ms DropTail
$ns duplex-link $n(13) $n(89) 1.5Mb 730ms DropTail
$ns duplex-link $n(13) $n(87) 1.5Mb 180ms DropTail
$ns duplex-link $n(13) $n(82) 1.5Mb 750ms DropTail
$ns duplex-link $n(13) $n(74) 1.5Mb 200ms DropTail
$ns duplex-link $n(13) $n(70) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "220..."; flush stdout }
$ns duplex-link $n(13) $n(62) 1.5Mb 230ms DropTail
$ns duplex-link $n(13) $n(59) 1.5Mb 490ms DropTail
$ns duplex-link $n(13) $n(55) 1.5Mb 80ms DropTail
$ns duplex-link $n(13) $n(51) 1.5Mb 170ms DropTail
$ns duplex-link $n(13) $n(48) 1.5Mb 490ms DropTail
$ns duplex-link $n(13) $n(40) 1.5Mb 570ms DropTail
$ns duplex-link $n(13) $n(26) 1.5Mb 240ms DropTail
$ns duplex-link $n(14) $n(95) 1.5Mb 510ms DropTail
$ns duplex-link $n(14) $n(82) 1.5Mb 320ms DropTail
$ns duplex-link $n(14) $n(79) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "230..."; flush stdout }
$ns duplex-link $n(14) $n(73) 1.5Mb 490ms DropTail
$ns duplex-link $n(14) $n(68) 1.5Mb 200ms DropTail
$ns duplex-link $n(14) $n(65) 1.5Mb 550ms DropTail
$ns duplex-link $n(14) $n(62) 1.5Mb 390ms DropTail
$ns duplex-link $n(14) $n(61) 1.5Mb 370ms DropTail
$ns duplex-link $n(14) $n(55) 1.5Mb 510ms DropTail
$ns duplex-link $n(14) $n(50) 1.5Mb 820ms DropTail
$ns duplex-link $n(14) $n(47) 1.5Mb 830ms DropTail
$ns duplex-link $n(14) $n(44) 1.5Mb 490ms DropTail
$ns duplex-link $n(14) $n(40) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "240..."; flush stdout }
$ns duplex-link $n(14) $n(25) 1.5Mb 570ms DropTail
$ns duplex-link $n(14) $n(19) 1.5Mb 470ms DropTail
$ns duplex-link $n(14) $n(18) 1.5Mb 430ms DropTail
$ns duplex-link $n(15) $n(94) 1.5Mb 490ms DropTail
$ns duplex-link $n(15) $n(86) 1.5Mb 1030ms DropTail
$ns duplex-link $n(15) $n(79) 1.5Mb 510ms DropTail
$ns duplex-link $n(15) $n(78) 1.5Mb 1060ms DropTail
$ns duplex-link $n(15) $n(70) 1.5Mb 950ms DropTail
$ns duplex-link $n(15) $n(56) 1.5Mb 770ms DropTail
$ns duplex-link $n(15) $n(52) 1.5Mb 900ms DropTail
if {$verbose} { puts -nonewline "250..."; flush stdout }
$ns duplex-link $n(15) $n(50) 1.5Mb 300ms DropTail
$ns duplex-link $n(15) $n(49) 1.5Mb 240ms DropTail
$ns duplex-link $n(15) $n(48) 1.5Mb 410ms DropTail
$ns duplex-link $n(15) $n(45) 1.5Mb 770ms DropTail
$ns duplex-link $n(15) $n(40) 1.5Mb 520ms DropTail
$ns duplex-link $n(15) $n(38) 1.5Mb 930ms DropTail
$ns duplex-link $n(15) $n(36) 1.5Mb 430ms DropTail
$ns duplex-link $n(15) $n(27) 1.5Mb 930ms DropTail
$ns duplex-link $n(16) $n(99) 1.5Mb 820ms DropTail
$ns duplex-link $n(16) $n(98) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "260..."; flush stdout }
$ns duplex-link $n(16) $n(90) 1.5Mb 220ms DropTail
$ns duplex-link $n(16) $n(86) 1.5Mb 890ms DropTail
$ns duplex-link $n(16) $n(81) 1.5Mb 380ms DropTail
$ns duplex-link $n(16) $n(80) 1.5Mb 260ms DropTail
$ns duplex-link $n(16) $n(76) 1.5Mb 830ms DropTail
$ns duplex-link $n(16) $n(75) 1.5Mb 840ms DropTail
$ns duplex-link $n(16) $n(74) 1.5Mb 290ms DropTail
$ns duplex-link $n(16) $n(68) 1.5Mb 730ms DropTail
$ns duplex-link $n(16) $n(61) 1.5Mb 590ms DropTail
$ns duplex-link $n(16) $n(60) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "270..."; flush stdout }
$ns duplex-link $n(16) $n(59) 1.5Mb 370ms DropTail
$ns duplex-link $n(16) $n(58) 1.5Mb 620ms DropTail
$ns duplex-link $n(16) $n(57) 1.5Mb 770ms DropTail
$ns duplex-link $n(16) $n(53) 1.5Mb 830ms DropTail
$ns duplex-link $n(16) $n(41) 1.5Mb 880ms DropTail
$ns duplex-link $n(16) $n(40) 1.5Mb 540ms DropTail
$ns duplex-link $n(16) $n(39) 1.5Mb 280ms DropTail
$ns duplex-link $n(16) $n(38) 1.5Mb 840ms DropTail
$ns duplex-link $n(16) $n(37) 1.5Mb 880ms DropTail
$ns duplex-link $n(16) $n(29) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "280..."; flush stdout }
$ns duplex-link $n(17) $n(97) 1.5Mb 550ms DropTail
$ns duplex-link $n(17) $n(96) 1.5Mb 430ms DropTail
$ns duplex-link $n(17) $n(92) 1.5Mb 340ms DropTail
$ns duplex-link $n(17) $n(88) 1.5Mb 510ms DropTail
$ns duplex-link $n(17) $n(85) 1.5Mb 360ms DropTail
$ns duplex-link $n(17) $n(84) 1.5Mb 450ms DropTail
$ns duplex-link $n(17) $n(81) 1.5Mb 430ms DropTail
$ns duplex-link $n(17) $n(80) 1.5Mb 490ms DropTail
$ns duplex-link $n(17) $n(78) 1.5Mb 940ms DropTail
$ns duplex-link $n(17) $n(69) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "290..."; flush stdout }
$ns duplex-link $n(17) $n(63) 1.5Mb 890ms DropTail
$ns duplex-link $n(17) $n(56) 1.5Mb 680ms DropTail
$ns duplex-link $n(17) $n(52) 1.5Mb 740ms DropTail
$ns duplex-link $n(17) $n(48) 1.5Mb 590ms DropTail
$ns duplex-link $n(17) $n(45) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(42) 1.5Mb 450ms DropTail
$ns duplex-link $n(17) $n(34) 1.5Mb 850ms DropTail
$ns duplex-link $n(17) $n(30) 1.5Mb 310ms DropTail
$ns duplex-link $n(17) $n(28) 1.5Mb 970ms DropTail
$ns duplex-link $n(17) $n(23) 1.5Mb 970ms DropTail
if {$verbose} { puts -nonewline "300..."; flush stdout }
$ns duplex-link $n(17) $n(22) 1.5Mb 370ms DropTail
$ns duplex-link $n(18) $n(97) 1.5Mb 130ms DropTail
$ns duplex-link $n(18) $n(96) 1.5Mb 120ms DropTail
$ns duplex-link $n(18) $n(94) 1.5Mb 140ms DropTail
$ns duplex-link $n(18) $n(92) 1.5Mb 520ms DropTail
$ns duplex-link $n(18) $n(84) 1.5Mb 340ms DropTail
$ns duplex-link $n(18) $n(79) 1.5Mb 250ms DropTail
$ns duplex-link $n(18) $n(77) 1.5Mb 260ms DropTail
$ns duplex-link $n(18) $n(75) 1.5Mb 430ms DropTail
$ns duplex-link $n(18) $n(59) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "310..."; flush stdout }
$ns duplex-link $n(18) $n(56) 1.5Mb 260ms DropTail
$ns duplex-link $n(18) $n(55) 1.5Mb 140ms DropTail
$ns duplex-link $n(18) $n(42) 1.5Mb 440ms DropTail
$ns duplex-link $n(18) $n(41) 1.5Mb 430ms DropTail
$ns duplex-link $n(18) $n(40) 1.5Mb 370ms DropTail
$ns duplex-link $n(18) $n(36) 1.5Mb 450ms DropTail
$ns duplex-link $n(18) $n(28) 1.5Mb 670ms DropTail
$ns duplex-link $n(18) $n(20) 1.5Mb 770ms DropTail
$ns duplex-link $n(19) $n(98) 1.5Mb 350ms DropTail
$ns duplex-link $n(19) $n(95) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "320..."; flush stdout }
$ns duplex-link $n(19) $n(57) 1.5Mb 420ms DropTail
$ns duplex-link $n(19) $n(40) 1.5Mb 230ms DropTail
$ns duplex-link $n(19) $n(37) 1.5Mb 440ms DropTail
$ns duplex-link $n(19) $n(36) 1.5Mb 320ms DropTail
$ns duplex-link $n(19) $n(35) 1.5Mb 440ms DropTail
$ns duplex-link $n(19) $n(29) 1.5Mb 420ms DropTail
$ns duplex-link $n(19) $n(27) 1.5Mb 420ms DropTail
$ns duplex-link $n(19) $n(24) 1.5Mb 290ms DropTail
$ns duplex-link $n(19) $n(23) 1.5Mb 460ms DropTail
$ns duplex-link $n(19) $n(22) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "330..."; flush stdout }
$ns duplex-link $n(20) $n(96) 1.5Mb 670ms DropTail
$ns duplex-link $n(20) $n(94) 1.5Mb 650ms DropTail
$ns duplex-link $n(20) $n(85) 1.5Mb 790ms DropTail
$ns duplex-link $n(20) $n(73) 1.5Mb 460ms DropTail
$ns duplex-link $n(20) $n(70) 1.5Mb 940ms DropTail
$ns duplex-link $n(20) $n(66) 1.5Mb 680ms DropTail
$ns duplex-link $n(20) $n(64) 1.5Mb 470ms DropTail
$ns duplex-link $n(20) $n(63) 1.5Mb 840ms DropTail
$ns duplex-link $n(20) $n(60) 1.5Mb 370ms DropTail
$ns duplex-link $n(20) $n(58) 1.5Mb 1040ms DropTail
if {$verbose} { puts -nonewline "340..."; flush stdout }
$ns duplex-link $n(20) $n(56) 1.5Mb 690ms DropTail
$ns duplex-link $n(20) $n(54) 1.5Mb 690ms DropTail
$ns duplex-link $n(20) $n(53) 1.5Mb 170ms DropTail
$ns duplex-link $n(20) $n(52) 1.5Mb 800ms DropTail
$ns duplex-link $n(20) $n(48) 1.5Mb 470ms DropTail
$ns duplex-link $n(20) $n(40) 1.5Mb 400ms DropTail
$ns duplex-link $n(20) $n(39) 1.5Mb 540ms DropTail
$ns duplex-link $n(20) $n(38) 1.5Mb 760ms DropTail
$ns duplex-link $n(20) $n(32) 1.5Mb 240ms DropTail
$ns duplex-link $n(20) $n(26) 1.5Mb 1110ms DropTail
if {$verbose} { puts -nonewline "350..."; flush stdout }
$ns duplex-link $n(20) $n(25) 1.5Mb 440ms DropTail
$ns duplex-link $n(20) $n(22) 1.5Mb 690ms DropTail
$ns duplex-link $n(20) $n(21) 1.5Mb 1140ms DropTail
$ns duplex-link $n(21) $n(78) 1.5Mb 830ms DropTail
$ns duplex-link $n(21) $n(76) 1.5Mb 710ms DropTail
$ns duplex-link $n(21) $n(74) 1.5Mb 230ms DropTail
$ns duplex-link $n(21) $n(64) 1.5Mb 810ms DropTail
$ns duplex-link $n(21) $n(61) 1.5Mb 280ms DropTail
$ns duplex-link $n(21) $n(60) 1.5Mb 780ms DropTail
$ns duplex-link $n(21) $n(58) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "360..."; flush stdout }
$ns duplex-link $n(21) $n(44) 1.5Mb 210ms DropTail
$ns duplex-link $n(21) $n(42) 1.5Mb 220ms DropTail
$ns duplex-link $n(21) $n(40) 1.5Mb 750ms DropTail
$ns duplex-link $n(21) $n(38) 1.5Mb 740ms DropTail
$ns duplex-link $n(21) $n(33) 1.5Mb 850ms DropTail
$ns duplex-link $n(21) $n(31) 1.5Mb 940ms DropTail
$ns duplex-link $n(21) $n(30) 1.5Mb 90ms DropTail
$ns duplex-link $n(21) $n(29) 1.5Mb 340ms DropTail
$ns duplex-link $n(22) $n(99) 1.5Mb 610ms DropTail
$ns duplex-link $n(22) $n(91) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "370..."; flush stdout }
$ns duplex-link $n(22) $n(84) 1.5Mb 530ms DropTail
$ns duplex-link $n(22) $n(80) 1.5Mb 140ms DropTail
$ns duplex-link $n(22) $n(79) 1.5Mb 240ms DropTail
$ns duplex-link $n(22) $n(74) 1.5Mb 310ms DropTail
$ns duplex-link $n(22) $n(73) 1.5Mb 430ms DropTail
$ns duplex-link $n(22) $n(70) 1.5Mb 560ms DropTail
$ns duplex-link $n(22) $n(62) 1.5Mb 500ms DropTail
$ns duplex-link $n(22) $n(58) 1.5Mb 470ms DropTail
$ns duplex-link $n(22) $n(57) 1.5Mb 570ms DropTail
$ns duplex-link $n(22) $n(34) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "380..."; flush stdout }
$ns duplex-link $n(22) $n(26) 1.5Mb 530ms DropTail
$ns duplex-link $n(23) $n(98) 1.5Mb 810ms DropTail
$ns duplex-link $n(23) $n(96) 1.5Mb 530ms DropTail
$ns duplex-link $n(23) $n(95) 1.5Mb 730ms DropTail
$ns duplex-link $n(23) $n(94) 1.5Mb 520ms DropTail
$ns duplex-link $n(23) $n(89) 1.5Mb 480ms DropTail
$ns duplex-link $n(23) $n(84) 1.5Mb 860ms DropTail
$ns duplex-link $n(23) $n(81) 1.5Mb 540ms DropTail
$ns duplex-link $n(23) $n(78) 1.5Mb 470ms DropTail
$ns duplex-link $n(23) $n(75) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "390..."; flush stdout }
$ns duplex-link $n(23) $n(74) 1.5Mb 910ms DropTail
$ns duplex-link $n(23) $n(71) 1.5Mb 330ms DropTail
$ns duplex-link $n(23) $n(70) 1.5Mb 620ms DropTail
$ns duplex-link $n(23) $n(61) 1.5Mb 750ms DropTail
$ns duplex-link $n(23) $n(56) 1.5Mb 390ms DropTail
$ns duplex-link $n(23) $n(38) 1.5Mb 400ms DropTail
$ns duplex-link $n(23) $n(34) 1.5Mb 420ms DropTail
$ns duplex-link $n(23) $n(31) 1.5Mb 280ms DropTail
$ns duplex-link $n(23) $n(29) 1.5Mb 860ms DropTail
$ns duplex-link $n(23) $n(25) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "400..."; flush stdout }
$ns duplex-link $n(24) $n(82) 1.5Mb 740ms DropTail
$ns duplex-link $n(24) $n(71) 1.5Mb 450ms DropTail
$ns duplex-link $n(24) $n(65) 1.5Mb 390ms DropTail
$ns duplex-link $n(24) $n(58) 1.5Mb 650ms DropTail
$ns duplex-link $n(24) $n(56) 1.5Mb 500ms DropTail
$ns duplex-link $n(24) $n(42) 1.5Mb 790ms DropTail
$ns duplex-link $n(24) $n(41) 1.5Mb 750ms DropTail
$ns duplex-link $n(24) $n(39) 1.5Mb 10ms DropTail
$ns duplex-link $n(24) $n(36) 1.5Mb 220ms DropTail
$ns duplex-link $n(24) $n(33) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "410..."; flush stdout }
$ns duplex-link $n(24) $n(31) 1.5Mb 360ms DropTail
$ns duplex-link $n(24) $n(27) 1.5Mb 690ms DropTail
$ns duplex-link $n(25) $n(95) 1.5Mb 470ms DropTail
$ns duplex-link $n(25) $n(86) 1.5Mb 570ms DropTail
$ns duplex-link $n(25) $n(85) 1.5Mb 350ms DropTail
$ns duplex-link $n(25) $n(81) 1.5Mb 260ms DropTail
$ns duplex-link $n(25) $n(67) 1.5Mb 600ms DropTail
$ns duplex-link $n(25) $n(66) 1.5Mb 250ms DropTail
$ns duplex-link $n(25) $n(60) 1.5Mb 70ms DropTail
$ns duplex-link $n(25) $n(52) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "420..."; flush stdout }
$ns duplex-link $n(25) $n(49) 1.5Mb 290ms DropTail
$ns duplex-link $n(25) $n(41) 1.5Mb 560ms DropTail
$ns duplex-link $n(25) $n(33) 1.5Mb 310ms DropTail
$ns duplex-link $n(25) $n(32) 1.5Mb 300ms DropTail
$ns duplex-link $n(25) $n(30) 1.5Mb 800ms DropTail
$ns duplex-link $n(25) $n(28) 1.5Mb 340ms DropTail
$ns duplex-link $n(25) $n(27) 1.5Mb 600ms DropTail
$ns duplex-link $n(26) $n(96) 1.5Mb 460ms DropTail
$ns duplex-link $n(26) $n(94) 1.5Mb 480ms DropTail
$ns duplex-link $n(26) $n(89) 1.5Mb 920ms DropTail
if {$verbose} { puts -nonewline "430..."; flush stdout }
$ns duplex-link $n(26) $n(88) 1.5Mb 530ms DropTail
$ns duplex-link $n(26) $n(86) 1.5Mb 460ms DropTail
$ns duplex-link $n(26) $n(85) 1.5Mb 350ms DropTail
$ns duplex-link $n(26) $n(76) 1.5Mb 530ms DropTail
$ns duplex-link $n(26) $n(75) 1.5Mb 600ms DropTail
$ns duplex-link $n(26) $n(72) 1.5Mb 400ms DropTail
$ns duplex-link $n(26) $n(56) 1.5Mb 480ms DropTail
$ns duplex-link $n(26) $n(53) 1.5Mb 1010ms DropTail
$ns duplex-link $n(26) $n(52) 1.5Mb 460ms DropTail
$ns duplex-link $n(26) $n(51) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "440..."; flush stdout }
$ns duplex-link $n(26) $n(38) 1.5Mb 560ms DropTail
$ns duplex-link $n(26) $n(36) 1.5Mb 800ms DropTail
$ns duplex-link $n(26) $n(35) 1.5Mb 740ms DropTail
$ns duplex-link $n(26) $n(32) 1.5Mb 940ms DropTail
$ns duplex-link $n(26) $n(29) 1.5Mb 510ms DropTail
$ns duplex-link $n(26) $n(28) 1.5Mb 1010ms DropTail
$ns duplex-link $n(26) $n(27) 1.5Mb 160ms DropTail
$ns duplex-link $n(27) $n(99) 1.5Mb 750ms DropTail
$ns duplex-link $n(27) $n(93) 1.5Mb 100ms DropTail
$ns duplex-link $n(27) $n(90) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "450..."; flush stdout }
$ns duplex-link $n(27) $n(84) 1.5Mb 150ms DropTail
$ns duplex-link $n(27) $n(75) 1.5Mb 450ms DropTail
$ns duplex-link $n(27) $n(72) 1.5Mb 280ms DropTail
$ns duplex-link $n(27) $n(65) 1.5Mb 640ms DropTail
$ns duplex-link $n(27) $n(63) 1.5Mb 420ms DropTail
$ns duplex-link $n(27) $n(51) 1.5Mb 410ms DropTail
$ns duplex-link $n(27) $n(49) 1.5Mb 710ms DropTail
$ns duplex-link $n(27) $n(33) 1.5Mb 860ms DropTail
$ns duplex-link $n(27) $n(32) 1.5Mb 830ms DropTail
$ns duplex-link $n(27) $n(31) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "460..."; flush stdout }
$ns duplex-link $n(28) $n(99) 1.5Mb 290ms DropTail
$ns duplex-link $n(28) $n(98) 1.5Mb 830ms DropTail
$ns duplex-link $n(28) $n(97) 1.5Mb 640ms DropTail
$ns duplex-link $n(28) $n(88) 1.5Mb 500ms DropTail
$ns duplex-link $n(28) $n(87) 1.5Mb 830ms DropTail
$ns duplex-link $n(28) $n(84) 1.5Mb 1000ms DropTail
$ns duplex-link $n(28) $n(81) 1.5Mb 590ms DropTail
$ns duplex-link $n(28) $n(74) 1.5Mb 910ms DropTail
$ns duplex-link $n(28) $n(66) 1.5Mb 580ms DropTail
$ns duplex-link $n(28) $n(55) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "470..."; flush stdout }
$ns duplex-link $n(28) $n(53) 1.5Mb 130ms DropTail
$ns duplex-link $n(28) $n(46) 1.5Mb 220ms DropTail
$ns duplex-link $n(28) $n(41) 1.5Mb 830ms DropTail
$ns duplex-link $n(28) $n(39) 1.5Mb 460ms DropTail
$ns duplex-link $n(28) $n(34) 1.5Mb 690ms DropTail
$ns duplex-link $n(28) $n(29) 1.5Mb 830ms DropTail
$ns duplex-link $n(29) $n(99) 1.5Mb 850ms DropTail
$ns duplex-link $n(29) $n(97) 1.5Mb 500ms DropTail
$ns duplex-link $n(29) $n(96) 1.5Mb 340ms DropTail
$ns duplex-link $n(29) $n(95) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "480..."; flush stdout }
$ns duplex-link $n(29) $n(94) 1.5Mb 340ms DropTail
$ns duplex-link $n(29) $n(84) 1.5Mb 510ms DropTail
$ns duplex-link $n(29) $n(77) 1.5Mb 550ms DropTail
$ns duplex-link $n(29) $n(73) 1.5Mb 660ms DropTail
$ns duplex-link $n(29) $n(72) 1.5Mb 590ms DropTail
$ns duplex-link $n(29) $n(65) 1.5Mb 690ms DropTail
$ns duplex-link $n(29) $n(64) 1.5Mb 510ms DropTail
$ns duplex-link $n(29) $n(63) 1.5Mb 850ms DropTail
$ns duplex-link $n(29) $n(60) 1.5Mb 600ms DropTail
$ns duplex-link $n(29) $n(55) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "490..."; flush stdout }
$ns duplex-link $n(29) $n(46) 1.5Mb 720ms DropTail
$ns duplex-link $n(29) $n(43) 1.5Mb 770ms DropTail
$ns duplex-link $n(29) $n(42) 1.5Mb 540ms DropTail
$ns duplex-link $n(29) $n(39) 1.5Mb 380ms DropTail
$ns duplex-link $n(29) $n(38) 1.5Mb 780ms DropTail
$ns duplex-link $n(29) $n(30) 1.5Mb 430ms DropTail
$ns duplex-link $n(30) $n(98) 1.5Mb 340ms DropTail
$ns duplex-link $n(30) $n(94) 1.5Mb 570ms DropTail
$ns duplex-link $n(30) $n(93) 1.5Mb 320ms DropTail
$ns duplex-link $n(30) $n(91) 1.5Mb 880ms DropTail
if {$verbose} { puts -nonewline "500..."; flush stdout }
$ns duplex-link $n(30) $n(88) 1.5Mb 630ms DropTail
$ns duplex-link $n(30) $n(86) 1.5Mb 710ms DropTail
$ns duplex-link $n(30) $n(82) 1.5Mb 940ms DropTail
$ns duplex-link $n(30) $n(77) 1.5Mb 410ms DropTail
$ns duplex-link $n(30) $n(76) 1.5Mb 760ms DropTail
$ns duplex-link $n(30) $n(72) 1.5Mb 610ms DropTail
$ns duplex-link $n(30) $n(71) 1.5Mb 720ms DropTail
$ns duplex-link $n(30) $n(70) 1.5Mb 560ms DropTail
$ns duplex-link $n(30) $n(64) 1.5Mb 900ms DropTail
$ns duplex-link $n(30) $n(61) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "510..."; flush stdout }
$ns duplex-link $n(30) $n(60) 1.5Mb 860ms DropTail
$ns duplex-link $n(30) $n(46) 1.5Mb 960ms DropTail
$ns duplex-link $n(30) $n(39) 1.5Mb 750ms DropTail
$ns duplex-link $n(30) $n(37) 1.5Mb 930ms DropTail
$ns duplex-link $n(31) $n(96) 1.5Mb 470ms DropTail
$ns duplex-link $n(31) $n(88) 1.5Mb 390ms DropTail
$ns duplex-link $n(31) $n(85) 1.5Mb 580ms DropTail
$ns duplex-link $n(31) $n(82) 1.5Mb 590ms DropTail
$ns duplex-link $n(31) $n(77) 1.5Mb 780ms DropTail
$ns duplex-link $n(31) $n(65) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "520..."; flush stdout }
$ns duplex-link $n(31) $n(58) 1.5Mb 840ms DropTail
$ns duplex-link $n(31) $n(37) 1.5Mb 490ms DropTail
$ns duplex-link $n(31) $n(36) 1.5Mb 140ms DropTail
$ns duplex-link $n(31) $n(35) 1.5Mb 460ms DropTail
$ns duplex-link $n(32) $n(93) 1.5Mb 910ms DropTail
$ns duplex-link $n(32) $n(89) 1.5Mb 370ms DropTail
$ns duplex-link $n(32) $n(74) 1.5Mb 910ms DropTail
$ns duplex-link $n(32) $n(73) 1.5Mb 250ms DropTail
$ns duplex-link $n(32) $n(67) 1.5Mb 890ms DropTail
$ns duplex-link $n(32) $n(65) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "530..."; flush stdout }
$ns duplex-link $n(32) $n(61) 1.5Mb 820ms DropTail
$ns duplex-link $n(32) $n(58) 1.5Mb 870ms DropTail
$ns duplex-link $n(32) $n(57) 1.5Mb 90ms DropTail
$ns duplex-link $n(32) $n(52) 1.5Mb 580ms DropTail
$ns duplex-link $n(32) $n(44) 1.5Mb 800ms DropTail
$ns duplex-link $n(32) $n(41) 1.5Mb 700ms DropTail
$ns duplex-link $n(33) $n(87) 1.5Mb 720ms DropTail
$ns duplex-link $n(33) $n(86) 1.5Mb 880ms DropTail
$ns duplex-link $n(33) $n(83) 1.5Mb 530ms DropTail
$ns duplex-link $n(33) $n(79) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "540..."; flush stdout }
$ns duplex-link $n(33) $n(76) 1.5Mb 770ms DropTail
$ns duplex-link $n(33) $n(75) 1.5Mb 720ms DropTail
$ns duplex-link $n(33) $n(67) 1.5Mb 770ms DropTail
$ns duplex-link $n(33) $n(65) 1.5Mb 400ms DropTail
$ns duplex-link $n(33) $n(61) 1.5Mb 780ms DropTail
$ns duplex-link $n(33) $n(48) 1.5Mb 240ms DropTail
$ns duplex-link $n(33) $n(46) 1.5Mb 370ms DropTail
$ns duplex-link $n(33) $n(44) 1.5Mb 690ms DropTail
$ns duplex-link $n(33) $n(43) 1.5Mb 570ms DropTail
$ns duplex-link $n(34) $n(92) 1.5Mb 940ms DropTail
if {$verbose} { puts -nonewline "550..."; flush stdout }
$ns duplex-link $n(34) $n(75) 1.5Mb 70ms DropTail
$ns duplex-link $n(34) $n(72) 1.5Mb 220ms DropTail
$ns duplex-link $n(34) $n(67) 1.5Mb 640ms DropTail
$ns duplex-link $n(34) $n(64) 1.5Mb 820ms DropTail
$ns duplex-link $n(34) $n(63) 1.5Mb 60ms DropTail
$ns duplex-link $n(34) $n(60) 1.5Mb 510ms DropTail
$ns duplex-link $n(34) $n(58) 1.5Mb 520ms DropTail
$ns duplex-link $n(34) $n(49) 1.5Mb 720ms DropTail
$ns duplex-link $n(34) $n(46) 1.5Mb 480ms DropTail
$ns duplex-link $n(34) $n(40) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "560..."; flush stdout }
$ns duplex-link $n(34) $n(39) 1.5Mb 700ms DropTail
$ns duplex-link $n(34) $n(35) 1.5Mb 220ms DropTail
$ns duplex-link $n(35) $n(98) 1.5Mb 780ms DropTail
$ns duplex-link $n(35) $n(95) 1.5Mb 670ms DropTail
$ns duplex-link $n(35) $n(92) 1.5Mb 950ms DropTail
$ns duplex-link $n(35) $n(87) 1.5Mb 590ms DropTail
$ns duplex-link $n(35) $n(83) 1.5Mb 150ms DropTail
$ns duplex-link $n(35) $n(79) 1.5Mb 410ms DropTail
$ns duplex-link $n(35) $n(77) 1.5Mb 570ms DropTail
$ns duplex-link $n(35) $n(75) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "570..."; flush stdout }
$ns duplex-link $n(35) $n(73) 1.5Mb 240ms DropTail
$ns duplex-link $n(35) $n(66) 1.5Mb 510ms DropTail
$ns duplex-link $n(35) $n(60) 1.5Mb 400ms DropTail
$ns duplex-link $n(35) $n(58) 1.5Mb 690ms DropTail
$ns duplex-link $n(35) $n(57) 1.5Mb 270ms DropTail
$ns duplex-link $n(35) $n(55) 1.5Mb 660ms DropTail
$ns duplex-link $n(35) $n(51) 1.5Mb 890ms DropTail
$ns duplex-link $n(35) $n(50) 1.5Mb 810ms DropTail
$ns duplex-link $n(35) $n(49) 1.5Mb 670ms DropTail
$ns duplex-link $n(35) $n(45) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "580..."; flush stdout }
$ns duplex-link $n(36) $n(90) 1.5Mb 310ms DropTail
$ns duplex-link $n(36) $n(78) 1.5Mb 690ms DropTail
$ns duplex-link $n(36) $n(64) 1.5Mb 250ms DropTail
$ns duplex-link $n(36) $n(63) 1.5Mb 670ms DropTail
$ns duplex-link $n(36) $n(59) 1.5Mb 160ms DropTail
$ns duplex-link $n(36) $n(57) 1.5Mb 290ms DropTail
$ns duplex-link $n(36) $n(54) 1.5Mb 360ms DropTail
$ns duplex-link $n(36) $n(52) 1.5Mb 580ms DropTail
$ns duplex-link $n(36) $n(48) 1.5Mb 140ms DropTail
$ns duplex-link $n(36) $n(39) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "590..."; flush stdout }
$ns duplex-link $n(37) $n(88) 1.5Mb 480ms DropTail
$ns duplex-link $n(37) $n(79) 1.5Mb 420ms DropTail
$ns duplex-link $n(37) $n(77) 1.5Mb 540ms DropTail
$ns duplex-link $n(37) $n(73) 1.5Mb 260ms DropTail
$ns duplex-link $n(37) $n(70) 1.5Mb 430ms DropTail
$ns duplex-link $n(37) $n(68) 1.5Mb 510ms DropTail
$ns duplex-link $n(37) $n(67) 1.5Mb 750ms DropTail
$ns duplex-link $n(37) $n(66) 1.5Mb 510ms DropTail
$ns duplex-link $n(37) $n(64) 1.5Mb 760ms DropTail
$ns duplex-link $n(37) $n(63) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "600..."; flush stdout }
$ns duplex-link $n(37) $n(56) 1.5Mb 260ms DropTail
$ns duplex-link $n(37) $n(54) 1.5Mb 660ms DropTail
$ns duplex-link $n(37) $n(49) 1.5Mb 690ms DropTail
$ns duplex-link $n(37) $n(41) 1.5Mb 350ms DropTail
$ns duplex-link $n(37) $n(39) 1.5Mb 670ms DropTail
$ns duplex-link $n(38) $n(90) 1.5Mb 650ms DropTail
$ns duplex-link $n(38) $n(84) 1.5Mb 550ms DropTail
$ns duplex-link $n(38) $n(83) 1.5Mb 310ms DropTail
$ns duplex-link $n(38) $n(82) 1.5Mb 150ms DropTail
$ns duplex-link $n(38) $n(80) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "610..."; flush stdout }
$ns duplex-link $n(38) $n(78) 1.5Mb 130ms DropTail
$ns duplex-link $n(38) $n(75) 1.5Mb 50ms DropTail
$ns duplex-link $n(38) $n(68) 1.5Mb 340ms DropTail
$ns duplex-link $n(38) $n(66) 1.5Mb 450ms DropTail
$ns duplex-link $n(38) $n(54) 1.5Mb 620ms DropTail
$ns duplex-link $n(38) $n(49) 1.5Mb 690ms DropTail
$ns duplex-link $n(38) $n(42) 1.5Mb 670ms DropTail
$ns duplex-link $n(39) $n(97) 1.5Mb 450ms DropTail
$ns duplex-link $n(39) $n(91) 1.5Mb 480ms DropTail
$ns duplex-link $n(39) $n(90) 1.5Mb 100ms DropTail
if {$verbose} { puts -nonewline "620..."; flush stdout }
$ns duplex-link $n(39) $n(89) 1.5Mb 250ms DropTail
$ns duplex-link $n(39) $n(81) 1.5Mb 280ms DropTail
$ns duplex-link $n(39) $n(71) 1.5Mb 450ms DropTail
$ns duplex-link $n(39) $n(63) 1.5Mb 760ms DropTail
$ns duplex-link $n(39) $n(56) 1.5Mb 510ms DropTail
$ns duplex-link $n(39) $n(55) 1.5Mb 430ms DropTail
$ns duplex-link $n(40) $n(85) 1.5Mb 390ms DropTail
$ns duplex-link $n(40) $n(73) 1.5Mb 140ms DropTail
$ns duplex-link $n(40) $n(65) 1.5Mb 120ms DropTail
$ns duplex-link $n(40) $n(60) 1.5Mb 40ms DropTail
if {$verbose} { puts -nonewline "630..."; flush stdout }
$ns duplex-link $n(40) $n(58) 1.5Mb 640ms DropTail
$ns duplex-link $n(40) $n(57) 1.5Mb 230ms DropTail
$ns duplex-link $n(40) $n(42) 1.5Mb 810ms DropTail
$ns duplex-link $n(41) $n(98) 1.5Mb 660ms DropTail
$ns duplex-link $n(41) $n(91) 1.5Mb 450ms DropTail
$ns duplex-link $n(41) $n(88) 1.5Mb 530ms DropTail
$ns duplex-link $n(41) $n(86) 1.5Mb 10ms DropTail
$ns duplex-link $n(41) $n(83) 1.5Mb 480ms DropTail
$ns duplex-link $n(41) $n(78) 1.5Mb 190ms DropTail
$ns duplex-link $n(41) $n(61) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "640..."; flush stdout }
$ns duplex-link $n(41) $n(60) 1.5Mb 620ms DropTail
$ns duplex-link $n(41) $n(55) 1.5Mb 520ms DropTail
$ns duplex-link $n(41) $n(53) 1.5Mb 780ms DropTail
$ns duplex-link $n(41) $n(49) 1.5Mb 780ms DropTail
$ns duplex-link $n(41) $n(43) 1.5Mb 420ms DropTail
$ns duplex-link $n(42) $n(99) 1.5Mb 980ms DropTail
$ns duplex-link $n(42) $n(85) 1.5Mb 440ms DropTail
$ns duplex-link $n(42) $n(84) 1.5Mb 120ms DropTail
$ns duplex-link $n(42) $n(80) 1.5Mb 740ms DropTail
$ns duplex-link $n(42) $n(64) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "650..."; flush stdout }
$ns duplex-link $n(42) $n(63) 1.5Mb 680ms DropTail
$ns duplex-link $n(42) $n(59) 1.5Mb 760ms DropTail
$ns duplex-link $n(42) $n(57) 1.5Mb 970ms DropTail
$ns duplex-link $n(42) $n(56) 1.5Mb 590ms DropTail
$ns duplex-link $n(43) $n(91) 1.5Mb 60ms DropTail
$ns duplex-link $n(43) $n(87) 1.5Mb 550ms DropTail
$ns duplex-link $n(43) $n(86) 1.5Mb 420ms DropTail
$ns duplex-link $n(43) $n(84) 1.5Mb 700ms DropTail
$ns duplex-link $n(43) $n(82) 1.5Mb 220ms DropTail
$ns duplex-link $n(43) $n(70) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "660..."; flush stdout }
$ns duplex-link $n(43) $n(66) 1.5Mb 420ms DropTail
$ns duplex-link $n(43) $n(65) 1.5Mb 170ms DropTail
$ns duplex-link $n(43) $n(51) 1.5Mb 840ms DropTail
$ns duplex-link $n(43) $n(50) 1.5Mb 720ms DropTail
$ns duplex-link $n(43) $n(45) 1.5Mb 710ms DropTail
$ns duplex-link $n(44) $n(95) 1.5Mb 50ms DropTail
$ns duplex-link $n(44) $n(88) 1.5Mb 350ms DropTail
$ns duplex-link $n(44) $n(80) 1.5Mb 460ms DropTail
$ns duplex-link $n(44) $n(79) 1.5Mb 430ms DropTail
$ns duplex-link $n(44) $n(77) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "670..."; flush stdout }
$ns duplex-link $n(44) $n(76) 1.5Mb 520ms DropTail
$ns duplex-link $n(44) $n(68) 1.5Mb 300ms DropTail
$ns duplex-link $n(44) $n(67) 1.5Mb 90ms DropTail
$ns duplex-link $n(44) $n(61) 1.5Mb 140ms DropTail
$ns duplex-link $n(44) $n(58) 1.5Mb 160ms DropTail
$ns duplex-link $n(44) $n(55) 1.5Mb 70ms DropTail
$ns duplex-link $n(44) $n(53) 1.5Mb 870ms DropTail
$ns duplex-link $n(44) $n(49) 1.5Mb 520ms DropTail
$ns duplex-link $n(45) $n(97) 1.5Mb 360ms DropTail
$ns duplex-link $n(45) $n(92) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "680..."; flush stdout }
$ns duplex-link $n(45) $n(86) 1.5Mb 550ms DropTail
$ns duplex-link $n(45) $n(84) 1.5Mb 170ms DropTail
$ns duplex-link $n(45) $n(77) 1.5Mb 250ms DropTail
$ns duplex-link $n(45) $n(76) 1.5Mb 580ms DropTail
$ns duplex-link $n(45) $n(70) 1.5Mb 410ms DropTail
$ns duplex-link $n(45) $n(59) 1.5Mb 570ms DropTail
$ns duplex-link $n(45) $n(57) 1.5Mb 830ms DropTail
$ns duplex-link $n(45) $n(52) 1.5Mb 510ms DropTail
$ns duplex-link $n(46) $n(82) 1.5Mb 450ms DropTail
$ns duplex-link $n(46) $n(79) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "690..."; flush stdout }
$ns duplex-link $n(46) $n(64) 1.5Mb 440ms DropTail
$ns duplex-link $n(46) $n(61) 1.5Mb 690ms DropTail
$ns duplex-link $n(46) $n(59) 1.5Mb 300ms DropTail
$ns duplex-link $n(46) $n(53) 1.5Mb 200ms DropTail
$ns duplex-link $n(47) $n(83) 1.5Mb 700ms DropTail
$ns duplex-link $n(47) $n(82) 1.5Mb 880ms DropTail
$ns duplex-link $n(47) $n(67) 1.5Mb 500ms DropTail
$ns duplex-link $n(47) $n(61) 1.5Mb 590ms DropTail
$ns duplex-link $n(47) $n(56) 1.5Mb 610ms DropTail
$ns duplex-link $n(47) $n(55) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "700..."; flush stdout }
$ns duplex-link $n(47) $n(54) 1.5Mb 170ms DropTail
$ns duplex-link $n(47) $n(52) 1.5Mb 730ms DropTail
$ns duplex-link $n(47) $n(50) 1.5Mb 60ms DropTail
$ns duplex-link $n(47) $n(48) 1.5Mb 320ms DropTail
$ns duplex-link $n(48) $n(91) 1.5Mb 330ms DropTail
$ns duplex-link $n(48) $n(77) 1.5Mb 570ms DropTail
$ns duplex-link $n(48) $n(72) 1.5Mb 410ms DropTail
$ns duplex-link $n(48) $n(57) 1.5Mb 360ms DropTail
$ns duplex-link $n(48) $n(55) 1.5Mb 420ms DropTail
$ns duplex-link $n(49) $n(92) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "710..."; flush stdout }
$ns duplex-link $n(49) $n(89) 1.5Mb 260ms DropTail
$ns duplex-link $n(49) $n(84) 1.5Mb 720ms DropTail
$ns duplex-link $n(49) $n(80) 1.5Mb 60ms DropTail
$ns duplex-link $n(49) $n(79) 1.5Mb 280ms DropTail
$ns duplex-link $n(49) $n(78) 1.5Mb 820ms DropTail
$ns duplex-link $n(49) $n(76) 1.5Mb 700ms DropTail
$ns duplex-link $n(49) $n(72) 1.5Mb 550ms DropTail
$ns duplex-link $n(49) $n(71) 1.5Mb 480ms DropTail
$ns duplex-link $n(49) $n(70) 1.5Mb 720ms DropTail
$ns duplex-link $n(50) $n(92) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "720..."; flush stdout }
$ns duplex-link $n(50) $n(89) 1.5Mb 470ms DropTail
$ns duplex-link $n(50) $n(83) 1.5Mb 720ms DropTail
$ns duplex-link $n(50) $n(78) 1.5Mb 910ms DropTail
$ns duplex-link $n(50) $n(76) 1.5Mb 780ms DropTail
$ns duplex-link $n(50) $n(73) 1.5Mb 590ms DropTail
$ns duplex-link $n(50) $n(51) 1.5Mb 470ms DropTail
$ns duplex-link $n(51) $n(99) 1.5Mb 960ms DropTail
$ns duplex-link $n(51) $n(88) 1.5Mb 530ms DropTail
$ns duplex-link $n(51) $n(75) 1.5Mb 780ms DropTail
$ns duplex-link $n(51) $n(69) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "730..."; flush stdout }
$ns duplex-link $n(51) $n(64) 1.5Mb 780ms DropTail
$ns duplex-link $n(51) $n(60) 1.5Mb 760ms DropTail
$ns duplex-link $n(51) $n(59) 1.5Mb 640ms DropTail
$ns duplex-link $n(51) $n(55) 1.5Mb 250ms DropTail
$ns duplex-link $n(52) $n(96) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(89) 1.5Mb 730ms DropTail
$ns duplex-link $n(52) $n(85) 1.5Mb 400ms DropTail
$ns duplex-link $n(52) $n(78) 1.5Mb 200ms DropTail
$ns duplex-link $n(52) $n(76) 1.5Mb 70ms DropTail
$ns duplex-link $n(52) $n(72) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "740..."; flush stdout }
$ns duplex-link $n(52) $n(66) 1.5Mb 390ms DropTail
$ns duplex-link $n(52) $n(58) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(57) 1.5Mb 490ms DropTail
$ns duplex-link $n(52) $n(54) 1.5Mb 560ms DropTail
$ns duplex-link $n(53) $n(98) 1.5Mb 880ms DropTail
$ns duplex-link $n(53) $n(85) 1.5Mb 720ms DropTail
$ns duplex-link $n(53) $n(78) 1.5Mb 680ms DropTail
$ns duplex-link $n(53) $n(65) 1.5Mb 270ms DropTail
$ns duplex-link $n(53) $n(61) 1.5Mb 890ms DropTail
$ns duplex-link $n(53) $n(57) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "750..."; flush stdout }
$ns duplex-link $n(54) $n(96) 1.5Mb 150ms DropTail
$ns duplex-link $n(54) $n(95) 1.5Mb 280ms DropTail
$ns duplex-link $n(54) $n(77) 1.5Mb 500ms DropTail
$ns duplex-link $n(54) $n(76) 1.5Mb 620ms DropTail
$ns duplex-link $n(54) $n(69) 1.5Mb 280ms DropTail
$ns duplex-link $n(54) $n(68) 1.5Mb 550ms DropTail
$ns duplex-link $n(54) $n(67) 1.5Mb 390ms DropTail
$ns duplex-link $n(54) $n(65) 1.5Mb 460ms DropTail
$ns duplex-link $n(54) $n(62) 1.5Mb 510ms DropTail
$ns duplex-link $n(54) $n(59) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "760..."; flush stdout }
$ns duplex-link $n(54) $n(58) 1.5Mb 480ms DropTail
$ns duplex-link $n(54) $n(57) 1.5Mb 580ms DropTail
$ns duplex-link $n(55) $n(98) 1.5Mb 140ms DropTail
$ns duplex-link $n(55) $n(93) 1.5Mb 310ms DropTail
$ns duplex-link $n(55) $n(74) 1.5Mb 230ms DropTail
$ns duplex-link $n(55) $n(63) 1.5Mb 600ms DropTail
$ns duplex-link $n(55) $n(60) 1.5Mb 520ms DropTail
$ns duplex-link $n(56) $n(89) 1.5Mb 600ms DropTail
$ns duplex-link $n(56) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(56) $n(84) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "770..."; flush stdout }
$ns duplex-link $n(56) $n(80) 1.5Mb 480ms DropTail
$ns duplex-link $n(56) $n(75) 1.5Mb 170ms DropTail
$ns duplex-link $n(56) $n(66) 1.5Mb 280ms DropTail
$ns duplex-link $n(56) $n(64) 1.5Mb 640ms DropTail
$ns duplex-link $n(57) $n(95) 1.5Mb 710ms DropTail
$ns duplex-link $n(57) $n(86) 1.5Mb 620ms DropTail
$ns duplex-link $n(57) $n(78) 1.5Mb 520ms DropTail
$ns duplex-link $n(57) $n(76) 1.5Mb 470ms DropTail
$ns duplex-link $n(57) $n(69) 1.5Mb 460ms DropTail
$ns duplex-link $n(57) $n(65) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "780..."; flush stdout }
$ns duplex-link $n(57) $n(64) 1.5Mb 530ms DropTail
$ns duplex-link $n(58) $n(97) 1.5Mb 310ms DropTail
$ns duplex-link $n(58) $n(94) 1.5Mb 420ms DropTail
$ns duplex-link $n(58) $n(91) 1.5Mb 640ms DropTail
$ns duplex-link $n(58) $n(89) 1.5Mb 850ms DropTail
$ns duplex-link $n(58) $n(83) 1.5Mb 710ms DropTail
$ns duplex-link $n(58) $n(82) 1.5Mb 670ms DropTail
$ns duplex-link $n(58) $n(80) 1.5Mb 600ms DropTail
$ns duplex-link $n(58) $n(75) 1.5Mb 550ms DropTail
$ns duplex-link $n(58) $n(60) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "790..."; flush stdout }
$ns duplex-link $n(59) $n(97) 1.5Mb 370ms DropTail
$ns duplex-link $n(59) $n(95) 1.5Mb 440ms DropTail
$ns duplex-link $n(59) $n(88) 1.5Mb 150ms DropTail
$ns duplex-link $n(59) $n(75) 1.5Mb 540ms DropTail
$ns duplex-link $n(59) $n(74) 1.5Mb 510ms DropTail
$ns duplex-link $n(59) $n(69) 1.5Mb 300ms DropTail
$ns duplex-link $n(59) $n(67) 1.5Mb 560ms DropTail
$ns duplex-link $n(59) $n(62) 1.5Mb 640ms DropTail
$ns duplex-link $n(60) $n(98) 1.5Mb 570ms DropTail
$ns duplex-link $n(60) $n(95) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "800..."; flush stdout }
$ns duplex-link $n(60) $n(91) 1.5Mb 230ms DropTail
$ns duplex-link $n(60) $n(90) 1.5Mb 330ms DropTail
$ns duplex-link $n(60) $n(89) 1.5Mb 250ms DropTail
$ns duplex-link $n(60) $n(85) 1.5Mb 420ms DropTail
$ns duplex-link $n(60) $n(82) 1.5Mb 510ms DropTail
$ns duplex-link $n(60) $n(80) 1.5Mb 280ms DropTail
$ns duplex-link $n(60) $n(77) 1.5Mb 620ms DropTail
$ns duplex-link $n(60) $n(76) 1.5Mb 500ms DropTail
$ns duplex-link $n(60) $n(74) 1.5Mb 660ms DropTail
$ns duplex-link $n(61) $n(87) 1.5Mb 60ms DropTail
if {$verbose} { puts -nonewline "810..."; flush stdout }
$ns duplex-link $n(61) $n(77) 1.5Mb 100ms DropTail
$ns duplex-link $n(61) $n(73) 1.5Mb 560ms DropTail
$ns duplex-link $n(61) $n(69) 1.5Mb 290ms DropTail
$ns duplex-link $n(62) $n(92) 1.5Mb 720ms DropTail
$ns duplex-link $n(62) $n(82) 1.5Mb 670ms DropTail
$ns duplex-link $n(62) $n(69) 1.5Mb 370ms DropTail
$ns duplex-link $n(63) $n(98) 1.5Mb 740ms DropTail
$ns duplex-link $n(63) $n(96) 1.5Mb 550ms DropTail
$ns duplex-link $n(63) $n(89) 1.5Mb 820ms DropTail
$ns duplex-link $n(63) $n(78) 1.5Mb 50ms DropTail
if {$verbose} { puts -nonewline "820..."; flush stdout }
$ns duplex-link $n(63) $n(71) 1.5Mb 300ms DropTail
$ns duplex-link $n(63) $n(67) 1.5Mb 660ms DropTail
$ns duplex-link $n(64) $n(95) 1.5Mb 620ms DropTail
$ns duplex-link $n(64) $n(91) 1.5Mb 560ms DropTail
$ns duplex-link $n(64) $n(81) 1.5Mb 440ms DropTail
$ns duplex-link $n(64) $n(74) 1.5Mb 620ms DropTail
$ns duplex-link $n(64) $n(71) 1.5Mb 580ms DropTail
$ns duplex-link $n(64) $n(68) 1.5Mb 840ms DropTail
$ns duplex-link $n(64) $n(65) 1.5Mb 470ms DropTail
$ns duplex-link $n(65) $n(98) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "830..."; flush stdout }
$ns duplex-link $n(65) $n(87) 1.5Mb 570ms DropTail
$ns duplex-link $n(65) $n(85) 1.5Mb 460ms DropTail
$ns duplex-link $n(65) $n(84) 1.5Mb 740ms DropTail
$ns duplex-link $n(65) $n(79) 1.5Mb 210ms DropTail
$ns duplex-link $n(65) $n(78) 1.5Mb 490ms DropTail
$ns duplex-link $n(65) $n(73) 1.5Mb 70ms DropTail
$ns duplex-link $n(66) $n(90) 1.5Mb 220ms DropTail
$ns duplex-link $n(66) $n(87) 1.5Mb 280ms DropTail
$ns duplex-link $n(66) $n(85) 1.5Mb 110ms DropTail
$ns duplex-link $n(66) $n(81) 1.5Mb 10ms DropTail
if {$verbose} { puts -nonewline "840..."; flush stdout }
$ns duplex-link $n(66) $n(67) 1.5Mb 350ms DropTail
$ns duplex-link $n(67) $n(97) 1.5Mb 370ms DropTail
$ns duplex-link $n(67) $n(95) 1.5Mb 130ms DropTail
$ns duplex-link $n(67) $n(86) 1.5Mb 570ms DropTail
$ns duplex-link $n(67) $n(80) 1.5Mb 530ms DropTail
$ns duplex-link $n(67) $n(78) 1.5Mb 720ms DropTail
$ns duplex-link $n(67) $n(73) 1.5Mb 650ms DropTail
$ns duplex-link $n(67) $n(72) 1.5Mb 430ms DropTail
$ns duplex-link $n(68) $n(99) 1.5Mb 690ms DropTail
$ns duplex-link $n(68) $n(91) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "850..."; flush stdout }
$ns duplex-link $n(68) $n(87) 1.5Mb 180ms DropTail
$ns duplex-link $n(68) $n(86) 1.5Mb 230ms DropTail
$ns duplex-link $n(68) $n(85) 1.5Mb 350ms DropTail
$ns duplex-link $n(68) $n(75) 1.5Mb 380ms DropTail
$ns duplex-link $n(69) $n(97) 1.5Mb 70ms DropTail
$ns duplex-link $n(69) $n(96) 1.5Mb 140ms DropTail
$ns duplex-link $n(69) $n(95) 1.5Mb 250ms DropTail
$ns duplex-link $n(69) $n(83) 1.5Mb 390ms DropTail
$ns duplex-link $n(69) $n(76) 1.5Mb 330ms DropTail
$ns duplex-link $n(69) $n(73) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "860..."; flush stdout }
$ns duplex-link $n(69) $n(72) 1.5Mb 160ms DropTail
$ns duplex-link $n(70) $n(93) 1.5Mb 260ms DropTail
$ns duplex-link $n(70) $n(92) 1.5Mb 850ms DropTail
$ns duplex-link $n(70) $n(85) 1.5Mb 390ms DropTail
$ns duplex-link $n(70) $n(84) 1.5Mb 310ms DropTail
$ns duplex-link $n(70) $n(83) 1.5Mb 530ms DropTail
$ns duplex-link $n(70) $n(82) 1.5Mb 400ms DropTail
$ns duplex-link $n(70) $n(77) 1.5Mb 160ms DropTail
$ns duplex-link $n(71) $n(99) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(97) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "870..."; flush stdout }
$ns duplex-link $n(71) $n(94) 1.5Mb 280ms DropTail
$ns duplex-link $n(71) $n(87) 1.5Mb 370ms DropTail
$ns duplex-link $n(71) $n(86) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(72) $n(85) 1.5Mb 280ms DropTail
$ns duplex-link $n(72) $n(81) 1.5Mb 280ms DropTail
$ns duplex-link $n(73) $n(93) 1.5Mb 660ms DropTail
$ns duplex-link $n(73) $n(92) 1.5Mb 720ms DropTail
$ns duplex-link $n(73) $n(89) 1.5Mb 410ms DropTail
$ns duplex-link $n(73) $n(83) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "880..."; flush stdout }
$ns duplex-link $n(73) $n(81) 1.5Mb 330ms DropTail
$ns duplex-link $n(73) $n(76) 1.5Mb 350ms DropTail
$ns duplex-link $n(74) $n(98) 1.5Mb 100ms DropTail
$ns duplex-link $n(74) $n(96) 1.5Mb 370ms DropTail
$ns duplex-link $n(74) $n(94) 1.5Mb 380ms DropTail
$ns duplex-link $n(74) $n(90) 1.5Mb 380ms DropTail
$ns duplex-link $n(74) $n(84) 1.5Mb 420ms DropTail
$ns duplex-link $n(74) $n(83) 1.5Mb 830ms DropTail
$ns duplex-link $n(74) $n(81) 1.5Mb 370ms DropTail
$ns duplex-link $n(75) $n(92) 1.5Mb 910ms DropTail
if {$verbose} { puts -nonewline "890..."; flush stdout }
$ns duplex-link $n(75) $n(91) 1.5Mb 240ms DropTail
$ns duplex-link $n(75) $n(90) 1.5Mb 640ms DropTail
$ns duplex-link $n(75) $n(82) 1.5Mb 120ms DropTail
$ns duplex-link $n(75) $n(80) 1.5Mb 630ms DropTail
$ns duplex-link $n(76) $n(94) 1.5Mb 470ms DropTail
$ns duplex-link $n(76) $n(83) 1.5Mb 350ms DropTail
$ns duplex-link $n(76) $n(82) 1.5Mb 190ms DropTail
$ns duplex-link $n(76) $n(77) 1.5Mb 350ms DropTail
$ns duplex-link $n(77) $n(88) 1.5Mb 430ms DropTail
$ns duplex-link $n(77) $n(81) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "900..."; flush stdout }
$ns duplex-link $n(77) $n(80) 1.5Mb 600ms DropTail
$ns duplex-link $n(78) $n(94) 1.5Mb 600ms DropTail
$ns duplex-link $n(78) $n(83) 1.5Mb 390ms DropTail
$ns duplex-link $n(79) $n(97) 1.5Mb 250ms DropTail
$ns duplex-link $n(79) $n(96) 1.5Mb 160ms DropTail
$ns duplex-link $n(79) $n(91) 1.5Mb 250ms DropTail
$ns duplex-link $n(79) $n(88) 1.5Mb 80ms DropTail
$ns duplex-link $n(79) $n(85) 1.5Mb 270ms DropTail
$ns duplex-link $n(80) $n(95) 1.5Mb 410ms DropTail
$ns duplex-link $n(80) $n(87) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "910..."; flush stdout }
$ns duplex-link $n(80) $n(82) 1.5Mb 730ms DropTail
$ns duplex-link $n(81) $n(97) 1.5Mb 190ms DropTail
$ns duplex-link $n(81) $n(94) 1.5Mb 40ms DropTail
$ns duplex-link $n(81) $n(84) 1.5Mb 440ms DropTail
$ns duplex-link $n(81) $n(83) 1.5Mb 460ms DropTail
$ns duplex-link $n(82) $n(92) 1.5Mb 1020ms DropTail
$ns duplex-link $n(82) $n(85) 1.5Mb 610ms DropTail
$ns duplex-link $n(83) $n(98) 1.5Mb 730ms DropTail
$ns duplex-link $n(83) $n(96) 1.5Mb 460ms DropTail
$ns duplex-link $n(83) $n(95) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "920..."; flush stdout }
$ns duplex-link $n(83) $n(84) 1.5Mb 760ms DropTail
$ns duplex-link $n(84) $n(95) 1.5Mb 260ms DropTail
$ns duplex-link $n(84) $n(89) 1.5Mb 910ms DropTail
$ns duplex-link $n(85) $n(98) 1.5Mb 200ms DropTail
$ns duplex-link $n(85) $n(97) 1.5Mb 190ms DropTail
$ns duplex-link $n(85) $n(92) 1.5Mb 470ms DropTail
$ns duplex-link $n(86) $n(99) 1.5Mb 600ms DropTail
$ns duplex-link $n(86) $n(97) 1.5Mb 330ms DropTail
$ns duplex-link $n(86) $n(95) 1.5Mb 530ms DropTail
$ns duplex-link $n(86) $n(94) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "930..."; flush stdout }
$ns duplex-link $n(86) $n(87) 1.5Mb 390ms DropTail
$ns duplex-link $n(88) $n(99) 1.5Mb 450ms DropTail
$ns duplex-link $n(88) $n(96) 1.5Mb 80ms DropTail
$ns duplex-link $n(89) $n(98) 1.5Mb 660ms DropTail
$ns duplex-link $n(89) $n(93) 1.5Mb 920ms DropTail
$ns duplex-link $n(90) $n(98) 1.5Mb 310ms DropTail
$ns duplex-link $n(90) $n(97) 1.5Mb 410ms DropTail
$ns duplex-link $n(90) $n(96) 1.5Mb 200ms DropTail
$ns duplex-link $n(90) $n(92) 1.5Mb 290ms DropTail
$ns duplex-link $n(90) $n(91) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "940..."; flush stdout }
$ns duplex-link $n(91) $n(94) 1.5Mb 380ms DropTail
$ns duplex-link $n(92) $n(98) 1.5Mb 350ms DropTail
$ns duplex-link $n(92) $n(97) 1.5Mb 640ms DropTail
$ns duplex-link $n(92) $n(95) 1.5Mb 480ms DropTail
$ns duplex-link $n(93) $n(98) 1.5Mb 420ms DropTail
$ns duplex-link $n(93) $n(97) 1.5Mb 350ms DropTail
$ns duplex-link $n(93) $n(96) 1.5Mb 470ms DropTail
$ns duplex-link $n(94) $n(96) 1.5Mb 20ms DropTail
$ns duplex-link $n(94) $n(95) 1.5Mb 250ms DropTail
$ns duplex-link $n(97) $n(99) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "950..."; flush stdout }
if {$verbose} { puts ""}

set mproto CtrMcast
set mrthandle [$ns mrtproto $mproto {}]
$ns at 0 "$mrthandle switch-treetype $g"

if {$verbose} {puts "starting"}
set rcvr18 [new Agent/Null]
$ns attach-agent $n(18) $rcvr18
$ns at 1 "$n(18) join-group $rcvr18 $g"
set rcvr87 [new Agent/Null]
$ns attach-agent $n(87) $rcvr87
$ns at 2 "$n(87) join-group $rcvr87 $g"
set rcvr91 [new Agent/Null]
$ns attach-agent $n(91) $rcvr91
$ns at 3 "$n(91) join-group $rcvr91 $g"
set rcvr23 [new Agent/Null]
$ns attach-agent $n(23) $rcvr23
$ns at 4 "$n(23) join-group $rcvr23 $g"
set rcvr17 [new Agent/Null]
$ns attach-agent $n(17) $rcvr17
$ns at 5 "$n(17) join-group $rcvr17 $g"
set rcvr65 [new Agent/Null]
$ns attach-agent $n(65) $rcvr65
$ns at 6 "$n(65) join-group $rcvr65 $g"
set rcvr14 [new Agent/Null]
$ns attach-agent $n(14) $rcvr14
$ns at 7 "$n(14) join-group $rcvr14 $g"
set rcvr97 [new Agent/Null]
$ns attach-agent $n(97) $rcvr97
$ns at 8 "$n(97) join-group $rcvr97 $g"
set rcvr19 [new Agent/Null]
$ns attach-agent $n(19) $rcvr19
$ns at 9 "$n(19) join-group $rcvr19 $g"
set rcvr66 [new Agent/Null]
$ns attach-agent $n(66) $rcvr66
$ns at 10 "$n(66) join-group $rcvr66 $g"

set sender [new Agent/CBR]
$sender set dst_ $g
$sender set class_ 2
$ns attach-agent $n(2) $sender

$ns at 0 "$sender start"

# START ns
$ns at 10.99 "[$ns clearMemTrace]"
$ns at 11 "exit 0"

$ns run

