/*
 * Copyright (c) 2004, 2005 Marcus Glocker <marcus@nazgul.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "config.h"

/*
 * Typedefs
 */
typedef unsigned short int	us_int;

/*
 * Memory mapped mimes types
 */
extern int mimes_size;
extern char *mimes;

/*
 * Constant strings
 */
extern const char *month[12];
extern const char *day[7];
extern const char *http_s_200;
extern const char *http_s_206;
extern const char *http_s_301;
extern const char *http_s_302;
extern const char *http_s_304;
extern const char *http_s_401;
extern const char *http_s_403;
extern const char *http_s_404;
extern const char *http_s_413;
extern const char *http_s_500;
extern const char *http_s_501;
extern const char *http_s_503;
extern const char *http_fn_dat;
extern const char *http_fn_srv;
extern const char *http_fn_lmd;
extern const char *http_fn_clt;
extern const char *http_fn_ims;
extern const char *http_fn_ref;
extern const char *http_fn_agt;
extern const char *http_fn_con;
extern const char *http_fn_alv;
extern const char *http_fn_cok;
extern const char *http_fn_teg;
extern const char *http_fn_cte;
extern const char *http_fn_loc;
extern const char *http_fn_hos;
extern const char *http_fn_aut;
extern const char *http_fn_auw;
extern const char *http_fn_ran;
extern const char *http_fn_rac;
extern const char *http_fv_srv;
extern const char *http_fv_pro;
extern const char *http_fv_cgi;
extern const char *http_fv_teg;
extern const char *http_fv_lch;
extern const char *http_fv_con_alv;
extern const char *http_fv_con_cls;

/*
 * Strings
 */
extern char http_fv_alv[128];
extern char http_fv_cte[128];
extern char http_url[128];
extern char http_sig[128];
extern char http_path[128];

/*
 * Server configuration values
 */
struct cfg {
	int	serverport;		/* Listener Port */
	char	serverportc[8];		/* Listener Port in char */
	char	serverip4[24];		/* IPv4 Address */
	char	serverip6[24];		/* IPv6 Address */
	char	servername[1024];	/* Servers connect URL */
	char	serveradmin[1024];	/* Server Admin Email */
	char	serverroot[1024];	/* Full Path to server root */
	char	servermimes[1024];	/* Filename for mime types */
	char	logserver[1024];	/* Filename for server log */
	char	logpid[1024];		/* Filename for server pid */
	char	logaccess[1024];	/* Filename for access log */
	char	docroot[1024];		/* Full Path to server document root */
	char	docindex[1024];		/* Filename for index documents */
	char	cgiroot[1024];		/* Full Path to cgi root */
	char	cgialias[1024];		/* Alias for cgi calls */
	char	user[1024];		/* Server runs under that user */
	char	htaccess[1024];		/* Filename for basic auth */
	char	htpasswd[1024];		/* Full Filename for basic auth users */
	char	file[1024];		/* Full Filename for config file */
	int	ssl;			/* SSL Flag */
	int	sslport;		/* SSL Listener Port */
	char	sslportc[8];		/* SSL Listener Port in char */
	char	sslcert[1024];		/* SSL Full Filename for server cert */
	char	sslcertkey[1024];	/* SSL Full Filename for server key */
	char	c401[1024];		/* Filename for 401 custom response */
	char	c403[1024];		/* Filename for 403 custom response */
	char	c404[1024];		/* Filename for 404 custom response */
};
extern struct cfg config;

/*
 * Information structure for header
 */
struct header {
	char	rq_method[1024];	/* Request Method */
	char	rq_uri[1024];		/* Request URI */
	char	rq_protocol[1024];	/* Request HTTP Protocol */
	char	rq_files[1024];		/* Request Filename */
	char	rq_filep[1024];		/* Request Path */
	char	rq_filef[1024];		/* Request Filename with Path */
	char	rq_query[1024];		/* Request Query String */
	char	rq_option[1024];	/* Request Option String */
	char	rq_script[1024];	/* Request Script String */
	char	rq_index[1024];		/* Request Index Filename */
	char	rq_docrootv[1024];	/* Request Virtual Docroot */
	char	rq_fv_usr[1024];	/* Request Remote User */
	char	rq_fv_cte[1024];	/* Request Value Content-Type: */
	char	rq_fv_ims[1024];	/* Request Value If-Modified-Since: */
	char	rq_fv_ref[1024];	/* Request Value Referer: */
	char	rq_fv_agt[1024];	/* Request Value User-Agent: */
	char	rq_fv_con[1024];	/* Request Value Connection: */
	char	rq_fv_cok[1024];	/* Request Value Cookie: */
	char	rq_fv_clt[1024];	/* Request Value Content-Length: */
	char	rq_fv_hos[1024];	/* Request Value Host: */
	char	rq_fv_aut[1024];	/* Request Value Authorization: */
	char	rq_fv_ran[1024];	/* Request Value Range: */
	char	rp_fv_dat[1024];	/* Response Value Date: */
	char	rp_fv_dam[1024];	/* Response Value ? */
	char	rp_fv_cte[1024];	/* Response Value Content-Type: */
	char	rp_fv_loc[1024];	/* Response Value Location: */
	char	rp_fv_auw[1024];	/* Response Value WWW-Authenticate: */
	char	rp_header[8192];	/* Response Header */
	int	rp_fsize;		/* Repsonse File Size */
	int	rp_foffs;		/* Response File Offset */
	int	rp_hsize;		/* Response Header Size */
	us_int	rp_status;		/* Response Status */
	us_int	x_opt;			/* Flag for Option */
	us_int	x_qry;			/* Flag for Query */
	us_int	x_sct;			/* Flag for Script */
	us_int	x_ims;			/* Flag for If-Modified-Since: */
	us_int	x_ref;			/* Flag for Referer: */
	us_int	x_agt;			/* Flag for User-Agent: */
	us_int	x_con;			/* Flag for Connection: */
	us_int	x_cok;			/* Flag for Cookie: */
	us_int	x_clt;			/* Flag for Content-Lenght: */
	us_int	x_hos;			/* Flag for Host: */
	us_int	x_aut;			/* Flag for Authorization: */
	us_int	x_ran;			/* Flag for Range: */
	us_int	x_cgi;			/* Flag for CGI */
	us_int	x_idx;			/* Flag for Index */
	us_int	x_dov;			/* Flag for Virutal Host */
};

/*
 * Information structure for each connection
 */
struct connection {
	int	to;			/* Timeout */
	us_int	state;			/* 0 = close, 1 = keep alive */
	char	ip[24];			/* Client IP */
	char	pt[8];			/* Client Port */
	int	pfdo;			/* Partitial, Open File Desc */
	int	pfdn[HDN];		/* Partitial, File Desc */
	int	pfds[HDN];		/* Partitial, Bytes sent */
	us_int	status[HDN];		/* Response status */
	char	*plreq[HDN];		/* Partitial, Log Request */
	char	*plref[HDN];		/* Partitial, Log Referer */
	char	*plagt[HDN];		/* Partitial, Log Client */
	char	*pllog[HDN];		/* Partitial, Log File */
	SSL	*ssl;			/* SSL Object */
	us_int	x_ssl;			/* Flag for SSL Connection */
	us_int	x_ip6;			/* Flag for IPv6 Connection */
	us_int	x_chk[HDN];		/* Flag for Chunked Data */
};
extern struct connection c[];
