/*
 * Copyright (c) 2004 Marcus Glocker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* strcutf()
 *	separates filename from path
 * Return:
 *	0 = success
 *
 */

int
strcutf(char *dst1, char *dst2, const char *src, const int dsize1, 
	const int dsize2)
{
	int	i, j, k, x, slash;

	for (i = 0, slash = 0; src[i] != '\0'; i++) {
		if (src[i] == '/')
			slash++;
	}

	for (i = 0, j = 0, k = 0, x = 0; src[i] != '\0'; i++) {
		if (x == slash && j != dsize1-1) {
			dst1[j] = src[i];
			j++;
		} else if (k != dsize2-1) {
			dst2[k] = src[i];
			k++;
		}
		if (src[i] == '/' && x != slash)
			x++;
	}

	/* terminate string */
	dst1[j] = '\0';	/* filename */
	dst2[k] = '\0';	/* path */

	return 0;
}
