#
# configuration file builder script for no-ip
#
CONFIG=./no-ip.conf
if [ -e $CONFIG ]
then
    EXISTS=Y
else
    EXISTS=N
fi
#
# get answers
#
echo "Greetings!"
echo
echo "The no-ip dynamic DNS system requires a configuration file."
echo "The answers to the next five questions will build one."
echo
echo "What is your email address for no-ip.com? (name@email.addr)"
/bin/echo -n "> "
read LOGIN
echo "What is the password for the login account? (password)"
/bin/echo -n "> "
read PASSWORD
#
GRP=foo
while [ "$GRP" = "foo" ] 
do
    echo "Are you using a groupname instead of a host.domain.name? (Y/N)"
    echo "Answer 'N' if you do not understand the question."
    /bin/echo -n "> "
    read GRP
    case $GRP in
	Y*)	GRP=Y;;
	y*)	GRP=Y;;
	N*)	GRP=N;;
	n*)	GRP=N;;
	*)	GRP=foo
		echo "===> Try again!";;
    esac
done
#
hostdom="BoGuS"
if [ "$GRP" = "Y" ] 
then
    echo "What is the groupname you are using? (mygroup)"
    /bin/echo -n "> "
    read HOST
else
    while [ "$hostdom" = "BoGuS" ]
    do
	echo "What is the host.domain.name you are using? (host.no-ip.com)"
	/bin/echo -n "> "
	read FQDN
	HOST=`echo $FQDN | awk -F. '{print $1}'` 
	FOO2=`echo $FQDN | awk -F. '{print $2}'` 
	FOO3=`echo $FQDN | awk -F. '{print $3}'` 
	if [ "$HOST" = "" -o "$FOO2" = "" ]
	then
	    echo "===> host.domain.name must have at least two fields divided by dots."
	else
	    hostdom="ok"
	fi
	if [ "$FOO3" = "" ] 
	then
	    DOMAIN=$HOST.$FOO2 
	    HOST="-"
	else
	    DOMAIN=$FOO2.$FOO3 
	fi
    done
fi
#
NAT=foo
while [ $NAT = "foo" ]
do
    echo "Do you have a router which uses NAT/masquerading? (Y/N)" 
    /bin/echo -n "> " 
    read NAT
    case $NAT in
	Y*)	NAT=Y;;
	y*)	NAT=Y;;
	N*)	NAT=N;;
	n*)	NAT=N;;
	*)	NAT=foo
		echo "===> Try again!";;
    esac
done
#
if [ "$NAT" = "N" ] 
then
    devs=`tail +3 /proc/net/dev | awk -F: '{print $1}' | tr -d ' '|tr '\n' ' '`
    DEV=foo
    while [ "$DEV" = "foo" ]
    do
	echo "Which device is your net connection? (one of: $devs)"
	/bin/echo -n "> "
	read DEVICE
	for i in $devs;do
	    if [ "$DEVICE" = "$i" ] 
	    then
		DEV=$i
	    fi
	done
	if [ "$DEV" = "foo" ]
	then
	    echo "===> Try again!"
	fi
    done
else
    DEV="unused"
fi
#
# make config file 
#
echo "LOGIN    = $LOGIN"		>$CONFIG
echo "PASSWORD = $PASSWORD"	>>$CONFIG
if [ "$GRP" = "Y" ] 
then
    echo "GROUP    = $HOST"	>>$CONFIG
    echo "HOSTNAME = ;"		>>$CONFIG
    echo "DOMAIN   = ;"		>>$CONFIG
else
    echo "GROUP    = ;"		>>$CONFIG
    echo "HOSTNAME = $HOST"	>>$CONFIG
    echo "DOMAIN   = $DOMAIN"	>>$CONFIG
fi
echo "DAEMON   = Y"		>>$CONFIG
echo "PROXY    = Y"		>>$CONFIG
echo "INTERVAL = 10"		>>$CONFIG
echo "NAT      = $NAT"		>>$CONFIG
echo "DEVICE   = $DEV"		>>$CONFIG
#
if [ "$EXISTS" = "Y" ] 
then
    echo "Configuration file [$CONFIG] updated." 
else
    echo "Configuration file [$CONFIG] created." 
fi
exit 0
