.\"
.\" %nmhwarning%
.\" $Id: post.man,v 1.4 2000/03/04 00:02:47 danh Exp $
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH POST %manext8% MH.6.8 [%nmhversion%]
.SH NAME
post \- deliver a message
.SH SYNOPSIS
.in +.5i
.ti -.5i
%libdir%/post 
\%[\-alias\ aliasfile]
.br
\%[\-filter\ filterfile] \%[\-nofilter]
\%[\-format] \%[\-noformat]
.br
\%[\-mime] \%[\-nomime]
\%[\-msgid] \%[\-nomsgid]
\%[\-verbose]
.br
\%[\-noverbose]
\%[\-watch] \%[\-nowatch]
\%[\-width\ columns]
.br
file
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIPost\fR is the default program called by \fIsend\fR\0(1) to deliver
the message in \fIfile\fR to local and remote users.  In fact, most of
the features attributed to \fIsend\fR in its manual page are performed by
\fIpost\fR, with \fIsend\fR acting as a relatively simple preprocessor.
Thus, it is \fIpost\fR which parses the various header fields, appends
From: and Date: lines, and interacts with the mail transport system.
\fIPost\fR will not normally be called directly by the user.

\fIPost\fR searches the \*(lqTo:\*(rq, \*(lqcc:\*(rq, \*(lqBcc:\*(rq,
\*(lqFcc:\*(rq, and \*(lqResent\-xxx:\*(rq header lines of the specified
message for destination addresses, checks these addresses for validity,
and formats them so as to conform to ARPAnet Internet Message Format
protocol, unless the `\-noformat' flag is set.  This will normally cause
\*(lq@\fIlocal\-site\fR\*(rq to be appended to each local destination
address, as well as any local return addresses.  The `\-width\ columns'
switch can be used to indicate the preferred length of the header
components that contain addresses.

If a \*(lqBcc:\*(rq field is encountered, its addresses will be used for
delivery, and the \*(lqBcc:\*(rq field will be removed from the message
sent to sighted recipients.  The blind recipients will receive an entirely
new message with a minimal set of headers.  Included in the body of the
message will be a copy of the message sent to the sighted recipients.
If `\-filter\ filterfile' is specified, then this copy is filtered
(re\-formatted) by \fImhl\fR prior to being sent to the blind recipients.
Alternately, if the `\-mime' switch is given, then \fIpost\fR will use
the MIME rules for encapsulation.

The `\-alias\ aliasfile' switch can be used to specify a file that post
should take aliases from.  More than one file can be specified, each
being preceded with `\-alias'.  In any event, the primary alias file is
read first.

The `\-msgid' switch indicates that a \*(lqMessage\-ID:\*(rq or
\*(lqResent\-Message\-ID:\*(rq field should be added to the header.

The `\-verbose' switch indicates that the user should be informed of
each step of the posting/filing process.

The `\-watch' switch indicates that the user would like to watch the
transport system's handling of the message (e.g., local and \*(lqfast\*(rq
delivery).

Under normal circumstances, \fIpost\fR constructs the "From:" line of the
message from the user's login name, the full name from the GECOS field of the
passwd file, and the fully\-qualified name of the local machine (or the value of
"localname" in mts.conf, if set).  An example is "From: Dan Harkless
<dan@machine.company.com>".  There are four ways to override these values,
however.  Note that they apply equally to "Resent\-From:" lines in messages sent
with \fIdist\fR.

The first way is GECOS\-based username masquerading.  If the "masquerade:" line
in mts.conf contains "mmailid", this processing is activated.  If a user's GECOS
field in the passwd file is of the form "Full Name <fakename>" then "fakename"
will be used in place of the real username.  For instance, a GECOS field of "Dan
Harkless <Dan.Harkless>" would result in "From: Dan Harkless
<Dan.Harkless@machine.company.com>".  Naturally if you were doing something like
this you'd want to set up an MTA alias (e.g. in /etc/aliases) from, for
instance, "Dan.Harkless" to "dan".

The second way to override default construction of "From:" is to set the
\fB$SIGNATURE\fR environment variable.  This variable overrides the full name
from the GECOS field, even if GECOS\-based masquerading is being done.  This
processing is always active, and does not need to be enabled from mts.conf.

The third way is controlled by the "user_extension" value of "masquerade:" line
of mts.conf.  When that's turned on, setting the \fB$USERNAME_EXTENSION\fR
environment variable will result in its value being appended the user's login
name.  For instance, if I set \fB$USERNAME_EXTENSION\fR to "+www", my "From:"
line will contain "Dan Harkless <dan+www@machine.company.com>" (or
"Dan.Harkless+www" if I'm using mmailid masquerading as well).  Recent versions
of sendmail automatically deliver all mail sent to \fIuser\fR+\fIstring\fR to
\fIuser\fR.  qmail has a similar feature which uses '\-' as the delimiter by
default, but can use other characters as well.

The fourth method of address masquerading is to specify a "From:" line manually
in the message draft.  It will be used as provided (after alias substitution),
but normally, to discourage email forgery, the user's \fIreal\fR address will be
used in the SMTP envelope "From:" and in a "Sender:" header.  However, if the
"masquerade:" line of mts.conf contains "draft_from", the SMTP envelope "From:"
will use the address given in the draft "From:", and there will be no "Sender:"
header.  This is useful in pretending to send mail "directly" from a remote POP3
account, or when remote email robots give improper precedence to the envelope
"From:".  Note that your MTA may still reveal your real identity (e.g.
sendmail's "X\-Authentication\-Warning:" header). 

.Fi
^%etcdir%/mts.conf~^nmh mts configuration file
^%etcdir%/MailAliases~^global nmh alias file
^%bindir%/refile~^Program to process Fcc:s
^%libdir%/mhl~^Program to process Bcc:s
.Pr
\fIpost\fR does \fBNOT\fR consult the user's \&.mh\(ruprofile
.Sa
\fIStandard for the Format of ARPA Internet Text Messages\fR (RFC\-822),
.br
mhmail(1), send(1), mh\-mail(5), mh\-alias(5), mh\-tailor(5)
.De
`\-alias %etcdir%/MailAliases'
.Ds
`\-format'
.Ds
`\-nomime'
.Ds
`\-nomsgid'
.Ds
`\-noverbose'
.Ds
`\-nowatch'
.Ds
`\-width\ 72'
.Ds
`\-nofilter'
.Co
None
.Bu
\*(lqReply\-To:\*(rq fields are allowed to have groups in them according
to the 822 specification, but \fIpost\fR won't let you use them.
.En
