/*

Copyright (C) 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_ta_h
#define __nd_ta_h

#include <nd.h>
#include <plugins/libnd_ta.h>

typedef struct nd_ta_data
{
  LND_TraceSet      *traces;
  int                it_count;

  /* Name of output file */
  char              *output_dir;

  gboolean           do_basic;
  gboolean           do_ip;
  gboolean           do_ports;
  gboolean           do_src_ports;
  gboolean           do_dst_ports;
  gboolean           do_flows;

} ND_TAData;

void                 nd_ta_browse_input(void);
void                 nd_ta_browse_output(void);
void                 nd_ta_run(void);
void                 nd_ta_save(void);

#endif
