/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtkhex.h>

#include <nd.h>
#include <nd_gui.h>
#include <nd_protocol_inst.h>
#include <nd_raw_protocol.h>

#define ND_RAW_HEX_KEY "raw_hex"

/* These are the implementations of ND_Protocol's callbacks: */
static GtkWidget *raw_create_gui(LND_Trace *trace, LND_ProtoInfo *pinf);
static void       raw_set_gui(const LND_Packet *packet, LND_ProtoInfo *pinf);


static ND_Protocol  *raw_gui = NULL;
static LND_Protocol *raw = NULL;


void         
nd_raw_proto_init(void)
{
  D_ENTER;

  if (!raw_gui)
    {
      raw = libnd_raw_proto_get();

      raw_gui = nd_proto_new(raw);	
      raw_gui->create_gui = raw_create_gui;
      raw_gui->set_gui    = raw_set_gui;
    }
  
  D_RETURN;
}


ND_Protocol *
nd_raw_proto_get(void)
{
  return raw_gui;
}


static gboolean
on_hex_changed(GtkWidget *widget,
	       int index,
	       int len,
	       gpointer user_data)
{
  LND_Trace *trace = user_data;

  libnd_packet_modified(nd_trace_get_current_packet(trace));

  return FALSE;
  TOUCH(widget);
  TOUCH(index);
  TOUCH(len);
}

static gboolean
on_hex_destroy(GtkObject *object)
{
  nd_gui_del_monowidth_widget(GTK_WIDGET(object));
  return FALSE;
}

/* Protocol method implementations: ------------------------------------ */

static GtkWidget *
raw_create_gui(LND_Trace *trace, LND_ProtoInfo *pinf)
{
  GtkWidget *hex = gtk_hex_new();

  gtk_signal_connect(GTK_OBJECT(hex), "changed",
		     GTK_SIGNAL_FUNC(on_hex_changed),
		     trace);

  gtk_signal_connect(GTK_OBJECT(GTK_HEX(hex)->hex_text), "destroy",
		     GTK_SIGNAL_FUNC(on_hex_destroy),
		     trace);

  libnd_reg_set_data(pinf->registry, ND_RAW_HEX_KEY, hex);
  nd_gui_add_monowidth_widget(GTK_HEX(hex)->hex_text);  
  gtk_widget_show(hex);

  return hex;
}


static void       
raw_set_gui(const LND_Packet *packet, LND_ProtoInfo *pinf)
{
  guchar *data = libnd_packet_get_data(packet, libnd_raw_proto_get(), pinf->inst.nesting);
  guchar *data_end = libnd_packet_get_data_end(packet, libnd_raw_proto_get(), pinf->inst.nesting);
  GtkHex *hex;

  if (!pinf)
    {
      D(("Protocol info for raw at %i not found\n", pinf->inst.nesting));
      return;
    }
  
  hex = libnd_reg_get_data(pinf->registry, ND_RAW_HEX_KEY);

  /* Only if the data really change, do we update. When updating, we
   * lose the cursor location, so we must avoid unnecessary updates.
   */
  if (data != hex->data || data_end - data != (int) hex->data_size)
    gtk_hex_set_content(hex, data, data_end - data);
}


ND_ProtoInfo *
nd_raw_proto_get_gui(LND_Trace *trace)
{
  static ND_ProtoInfo *raw_pinf = NULL;
  static LND_Trace    *last_trace = NULL;

  if (!trace)
    return NULL;

  if (raw_pinf && trace == last_trace)
    return raw_pinf;

  last_trace = trace;
  raw_pinf = nd_proto_info_get(nd_trace_get_proto_info(trace, raw, 0));

  return raw_pinf;
}

