/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_ip_h
#define __nd_ip_h

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include <protocols/ip/libnd_ip.h>

#ifndef IPTOS_LOWCOST
#define IPTOS_LOWCOST 0x02
#endif

#include <nd.h>

#define ND_IP_PAYLOAD_LENGTH(iphdr) (ntohs(iphdr->ip_len) - (iphdr->ip_hl << 2))
#define ND_IP_PAYLOAD(iphdr) (((guchar *) iphdr) + (iphdr->ip_hl << 2))
#define ND_IP_FRAG_OFFSET(iphdr) ((ntohs(iphdr->ip_off) & IP_OFFMASK) << 3)

extern ND_MenuData ip_menu_p_data[];
extern ND_MenuData ip_menu_tos_data[];
extern ND_MenuData ip_menu_ecn_data[];


/* These are the implementations for IPv4 of ND_Protocol's callbacks: */
GtkWidget *nd_ip_create_gui(LND_Trace *trace, LND_ProtoInfo *pinf);
void       nd_ip_set_gui(const LND_Packet *packet, LND_ProtoInfo *pinf);

/* Generic accessor function for the IPv4 Protocol implementation: */
inline LND_Protocol *nd_ip_get(void);
inline ND_Protocol  *nd_ip_get_gui(void);

/* Helper functions to set a trace's IP GUI table to a packet's content: */
void       nd_ip_set_gui_v(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_hl(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_ecn(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_tos(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_len(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_id(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_rf(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_df(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_mf(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_off(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_ttl(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_p(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_sum(const LND_Packet *packet, LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_src(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_dst(LND_ProtoInfo *pinf, struct ip *iphdr);
void       nd_ip_set_gui_options(LND_ProtoInfo *pinf, struct ip *iphdr,
				 const LND_Packet *packet);

#endif
