/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <nd.h>
#include "nd_ip.h"
#include "nd_ipfrag.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"


void
on_ip_frag1_spinbutton_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ND_FragData *data;
  int offset;

  data = gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(editable))), "data");
  offset = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));
  nd_ip_frag_adjust(data, offset, 0);

  return;
  TOUCH(user_data);
}


void
on_ip_frag2_spinbutton_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  ND_FragData *data;
  int offset;

  data = gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(editable))), "data");
  offset = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));
  nd_ip_frag_adjust(data, offset, 1);
  
  return;
  TOUCH(user_data);
}


void
on_ip_frag_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  ND_FragData *data;

  data = gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(button))), "data");
  nd_ip_frag_apply(data);
  
  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
on_ip_frag_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  ND_FragData *data;

  data = gtk_object_get_data(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(button))), "data");
  nd_ip_frag_cancel(data
);  

  return;
  TOUCH(button);
  TOUCH(user_data);
}

