/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xsl.ui;

import org.netbeans.modules.xml.core.lib.AbstractUtil;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.nodes.Node;
import org.openide.nodes.Children;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.lookup.Lookups;
import org.openide.ErrorManager;

import java.util.Comparator;
import java.util.Arrays;
import java.util.Collections;
import java.awt.*;

/**
 *
 * @author Libor Kramolis
 * @version 0.2
 */
class Util extends AbstractUtil {

    /** Default and only one instance of this class. */
    public static final Util THIS = new Util();

    /** Nobody can create instance of it, just me. */
    private Util () {
    }

    // copy pasted from SourceTasksView >>>

    /** Logical view over all opened projects */
    static Node projectView() {

        Children.SortedArray kids = new Children.SortedArray();
        kids.setComparator(new Comparator() {
                public int compare(Object o1, Object o2) {
                    return ((Node) o1).getDisplayName().compareToIgnoreCase(((Node) o2).getDisplayName());
                }
            });

        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int pi = 0; pi<projects.length; pi++) {
            Project project = projects[pi];
            Sources sources = ProjectUtils.getSources(project);
            SourceGroup[] group =sources.getSourceGroups(Sources.TYPE_GENERIC);
            Arrays.sort(group, new Comparator() {
                public int compare(Object o1, Object o2) {
                    return ((SourceGroup) o1).getDisplayName().compareToIgnoreCase(((SourceGroup) o2).getDisplayName());
                }
            });

            for (int i=0; i<group.length; i++) {
                FileObject folder = group[i].getRootFolder();
                if (folder.isFolder()) {
                    kids.add(new Node[] {new FolderNode(folder, group[i])});
                    if (icons == null) {
                        try {
                            DataObject dobj = DataObject.find(folder);
                            icons = dobj.getNodeDelegate();
                        } catch (DataObjectNotFoundException e) {
                            ErrorManager err = ErrorManager.getDefault();
                            err.notify(e);
                        }
                    }
                } else {
                    try {
                        kids.add(new Node[] {new FilterNode(DataObject.find(folder).getNodeDelegate())});
                    } catch (DataObjectNotFoundException e) {
                        ErrorManager err = ErrorManager.getDefault();
                        err.notify(e);
                    }
                }
            }
        }
        final Node content = new AbstractNode(kids) {
            public void setName(String name) {
                super.setName(name);
                super.setIconBase("org/netbeans/modules/xsl/resources/repository");  // NOI18N
            }
        };

        content.setName(THIS.getString("projects"));
        return content;
    }

    // handle select folder life-time
    static Node icons = null;

    /** Visualizes folder structure. */
    private static class FolderNode extends AbstractNode {

        private final FileObject fileObject;
        private SourceGroup group;

        public FolderNode(FileObject fileObject, SourceGroup root) {
            super(new FolderContent(fileObject, root), Lookups.singleton(fileObject));
            this.fileObject = fileObject;
            group = root;
        }

        public FolderNode(FileObject fileObject) {
            super(new FolderContent(fileObject), Lookups.singleton(fileObject));
            this.fileObject = fileObject;
        }

        public String getDisplayName() {
            if (group != null) {
                return group.getDisplayName();
            } else {
                return fileObject.getName();
            }
        }

        public Image getIcon(int type) {

            // XXX how to convert icon to image?
//            if (group != null) {
//                Icon icon  = group.getIcon(false);
//                if (icon != null) {
//                    return icon.
//                }
//            }

            // XXX how to dynamically get icon (that is subject to L&F)
            if (icons != null) {
                return icons.getIcon(type);
            } else {
                return super.getIcon(type);
            }
        }

        public Image getOpenedIcon(int type) {
            // XXX how to dynamically get icon (that is subject to L&F)
            if (icons != null) {
                return icons.getOpenedIcon(type);
            } else {
                return super.getOpenedIcon(type);
            }
        }

        private static class FolderContent extends Children.Keys {

            private final FileObject fileObject;
            private final SourceGroup group;

            public FolderContent(FileObject fileObject) {
                this(fileObject, null);
            }

            public FolderContent(FileObject fileObject, SourceGroup group) {
                this.fileObject = fileObject;
            	this.group = group;
            }

            protected void addNotify() {
                FileObject[] fo = fileObject.getChildren();
                Arrays.sort(fo, new Comparator() {
                    public int compare(Object o1, Object o2) {
                        return ((FileObject) o1).getNameExt().compareToIgnoreCase(((FileObject) o2).getNameExt());
                    }
                });
                setKeys(Arrays.asList(fo));
            }

            protected void removeNotify() {
                setKeys(Collections.EMPTY_SET);
            }

            protected Node[] createNodes(Object key) {
                FileObject fo = (FileObject) key;
                if (group == null || group.contains(fo)) {
                    if (fo.isFolder()) {
                        return new Node[] {new FolderNode(fo)};
                    } else {
                        try {
                            return new Node[] {new FilterNode(DataObject.find(fo).getNodeDelegate())};
                        } catch (DataObjectNotFoundException e) {
                            ErrorManager err = ErrorManager.getDefault();
                            err.notify(e);
                        }
                    }
                }
                return new Node[0];
            }
        }
    }

    // copy pasted from SourceTasksView <<<

}
