/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xsl.scenario;

import org.netbeans.modules.xml.api.scenario.*;

/**
 * This is a ScenarioFactory implementation which creates scenarios of 
 * type FileXSLScenario.
 * //!!! What is relation to ScenarioCookie?
 *
 * @author  asgeir@dimonsoftware.com
 */
public class FileXSLScenarioFactory implements ScenarioFactory {
    
    /** Creates a new instance of FileXSLScenarioFactory */
    public FileXSLScenarioFactory() {
    }
    
    /**
     * Creates a new FileXSLScenario.
     * @return a newly constructed FileXSLScenario.
     */
    public Scenario createScenario() {
        return new FileXSLScenario();
    }
    
    /**
     * Decides if the scenario type created by this factory is allowed
     * for this DataObject
     * @param dataObject The DataObject which should be tested for this Factory.
     * @return true if this factory should be allowed for that DataObject.
     */
    public boolean isEnabled(org.openide.loaders.DataObject dataObject) {
        return (dataObject instanceof org.netbeans.modules.xsl.XSLDataObject);
    }
    
    /**
     * Get a more detailed describtion of the scenario type created by this factory.
     * @return The describtion of the scenario type created by this factory.
     */
    public String getDescription() {
        return Util.THIS.getString("NAME_file_scenario_factory_description");
    }
    
    /**
     * Get the name of the scenario type created by this Factory.
     * @return The name of the scenario type created by this Factory.
     */
    public String getName() {
        return Util.THIS.getString("NAME_file_scenario_factory_name");
    }
    
    /** 
     * @return  The name of the scenario type created by this Factory.
     */
    public String toString() {
        return getName();
    }

    /** @link dependency */
    /*# FileXSLScenario lnkFileXSLScenario; */
}
