/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xsl.api;

import java.io.IOException;
import org.openide.loaders.DataObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.netbeans.modules.xml.api.scenario.Scenario;

/**
 * Have a notion of transformed document which is helpfull
 * for XPath expressions, etc.
 *
 * @author  asgeir@dimonsoftware.com
 */
public interface XSLScenario extends Scenario {
    
    /**
     * @param dataObject We should get rid of it as scemarion is
     *        accessed as cookie held by DataObject.
     * @param reload If true the document will be reparsed although it has been parsed before
     * @return a sample document to be transformed (it can really
     * exist or can be generated from a grammar on fly).
     */
    Document getSourceDocument(DataObject dataObject, boolean reload)  throws SAXException, IOException;
}
