/*
 * MessagePanel.java
 *
 * Created on July 20, 2006, 5:16 PM
 */

package org.netbeans.modules.xml.xam.ui.customizer;

import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.Utilities;

/**
 *
 * @author  Ajit Bhate
 */
public class MessagePanel extends javax.swing.JPanel implements MessageDisplayer
{
	static final long serialVersionUID = 1L;
	
	/** Creates new form MessagePanel */
	public MessagePanel()
	{
		initComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        panel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        panel.setLayout(null);

        GroupLayout panelLayout = new GroupLayout(panel);
        panel.setLayout(panelLayout);
        panelLayout.setAutocreateGaps(true);
        panelLayout.setAutocreateContainerGaps(true);
        GroupLayout.ParallelGroup hGroup =
        panelLayout.createParallelGroup();
        panelLayout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup =
        panelLayout.createSequentialGroup();
        panelLayout.setVerticalGroup(vGroup);
        add(panel, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents

	public void annotate(String message, MessageDisplayer.Type type)
	{
		if(!isVisible()) setVisible(true);
		JLabel messageLabel = new JLabel(message);
		switch(type)
		{
			case ERROR:
				messageLabel.setIcon(new ImageIcon(Utilities.loadImage(
						"org/openide/resources/error.gif"))); // NOI18N
				break;
			case WARNING:
				messageLabel.setIcon(new ImageIcon(Utilities.loadImage(
						"org/openide/resources/warning.gif"))); // NOI18N
				break;
			case INFO:
			default:
		}
		GroupLayout layout = (GroupLayout)panel.getLayout();
		((GroupLayout.ParallelGroup)layout.getHorizontalGroup()).add(messageLabel);
		((GroupLayout.SequentialGroup)layout.getVerticalGroup()).add(messageLabel);
	}

	public void clear()
	{
		remove(panel);
		initComponents();
		setVisible(false);
	}

	public JComponent getComponent()
	{
		return this;
	}
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel panel;
    // End of variables declaration//GEN-END:variables
	
}
