/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.xam.ui.actions;

import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.cookies.GetSuperCookie;
import org.netbeans.modules.xml.xam.ui.cookies.ViewComponentCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Ajit Bhate
 */
public class ShowSuperAction extends AbstractShowComponentAction
{
    static final long serialVersionUID = 1L;
    /**
     *
     */
    public ShowSuperAction() {
        super();
    }


    /**
     *
     */
    public String getName() {
        return NbBundle.getMessage(ShowSuperAction.class,
                "LBL_ShowSuperAction_Name"); // NOI18N
    }
    
    
    /**
     *
     */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(getClass());
    }
    
	protected ViewComponentCookie.View getView()
	{
		return ViewComponentCookie.View.SUPER;
	}
    
	protected Class[] cookieClasses()
	{
		return new Class[]{GetSuperCookie.class};
	}
	
	protected Component getComponent(Node n)
	{
		GetSuperCookie cake = (GetSuperCookie)n.
				getCookie(GetSuperCookie.class);
                try {
                    if(cake!=null) return cake.getSuper();
                } catch (IllegalStateException ise) {
                    // Happens if the component is no longer in the model.
                    // Ignore this here since the subclass will deal with it.
                }
		return null;
	}
	
}
