/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JPanel;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.xml.xam.ui.ProjectConstants;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 * @author  rico
 */
public class SelectSchemaPanel extends JPanel implements ExplorerManager.Provider {
    
    public static final String SCHEMA_FILE_EXTENSION = "xsd";
    
    private ExplorerManager manager;
    private Node[] selectedNodes;
    private JPanel panel;
    private Project project;
    
    /**
     * Creates a new instance of SelectSchemaPanel
     */
    public SelectSchemaPanel(Project project) {
        this.project = project;
        initComponents();
        manager = new ExplorerManager();
        manager.addPropertyChangeListener(
                new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent pce) {
                selectedNodes = manager.getSelectedNodes();
            }
        });
        populateTree();
    }
    
    public Node[] getSelectedNodes(){
        return selectedNodes;
    }
    
    public ExplorerManager getExplorerManager() {
        return manager;
    }
    
    private void populateTree(){
        LogicalViewProvider lvp = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
        Node projectView = lvp.createLogicalView();
        Children.Array children = new Children.Array();
        FilterNode filter = new FilterNode(projectView, new SourceListViewChildren());
        children.add(new FilterNode[] {filter});
        Node root = new AbstractNode(children);
        manager.setRootContext(filter);
        
    }
    
    private void initComponents() {
        panel = new JPanel();
        setLayout(new BorderLayout());
        BorderLayout bl = new BorderLayout();
        panel.setLayout(bl);
        bl.setVgap(10);
        add(panel, BorderLayout.CENTER);
        
        BeanTreeView btv = new BeanTreeView();
        btv.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        btv.getAccessibleContext().
                setAccessibleName(NbBundle.getMessage(SelectSchemaPanel.class,"LBL_Schemas"));
        btv.getAccessibleContext().setAccessibleDescription
                (NbBundle.getMessage(SelectSchemaPanel.class,"TTL_SelectSchemas"));
        String projectName = project.getProjectDirectory().getName();
        String classesLabel = projectName + " " +
                NbBundle.getMessage(SelectSchemaPanel.class, "LBL_Schemas") + ":";
        JLabel label = new JLabel(classesLabel);
        panel.add(label, BorderLayout.NORTH);
        panel.add(btv, BorderLayout.CENTER);   //NOI18N
        panel.validate();
        validate();
    }
    
    
    class SourceListViewChildren extends Children.Keys {
        public static final String KEY_SOURCES = "sourcesKey"; //NOI18N
        
        public Node[] createNodes(Object key) {
            FileObject fo = (FileObject) key;
//            ModelSource modelSource = org.netbeans.modules.xml.retriever.catalog.Utilities.getModelSource(fo, false); 
//            SchemaModel model = SchemaModelFactory.getDefault().getModel(modelSource);
//            List<Class<? extends SchemaComponent>> filters = new ArrayList<Class<? extends SchemaComponent>>();
//            filters.add(GlobalSimpleType.class);
//            filters.add(GlobalComplexType.class);
//            filters.add(GlobalElement.class);
//            CategorizedSchemaNodeFactory factory = new CategorizedSchemaNodeFactory(
//                    model, filters, Lookup.EMPTY);
            try {
                DataObject dataObj = DataObject.find(fo);
                 if(dataObj != null) {
                    return new Node[] {new SchemaFileNode(dataObj.getNodeDelegate(), 
                        FileUtil.getRelativePath(project.getProjectDirectory(), fo))};

                 }   
            } catch(Exception ex) {
                ErrorManager.getDefault().notify(ex);
            }
             
            return new Node[] {};
//            return new Node[] {new SchemaFileNode(
//                    factory.createNode(model.getSchema()), 
//                    FileUtil.getRelativePath(projectDir, fo))};
            
        }
        
//        protected Node[] createNodes(Object key) {
//            Node n = null;
//            List sourceNodes = new LinkedList();
//            if (key == KEY_SOURCES) {
//                Sources sources = ProjectUtils.getSources(project);
//                SourceGroup[] groups = sources.getSourceGroups(ProjectConstants.JAVA_SOURCES_TYPE);
//                //sourceNodes.addAll(Arrays.asList(groups));
//                for(int i = 0; i < groups.length; i++){
//                    SourceGroup group = groups[i];
//                    File projectDirFile = FileUtil.toFile(group.getRootFolder());
//                    File[] files = recursiveListFiles(projectDirFile, new SchemaFileFilter());
//                    for (File file : files) {
//                        FileObject fo = FileUtil.toFileObject(file);
//                        keys.add(fo);
//                    }
//                    SourceGroup group = groups[i];
//                    FileObject fileObject = group.getRootFolder();
//                    try {
//                        DataObject dObj = DataObject.find(fileObject);
//                        if(dObj != null) {
//                            sourceNodes.add(dObj.getNodeDelegate());
//                        }
//                    } catch(Exception ex) {
//                        ErrorManager.getDefault().notify(ex);
//                    }
//                    //sourceNodes.add(PackageView.createPackageView(groups[i]));
//                }
//            }
//            return (Node[])sourceNodes.toArray(new Node[sourceNodes.size()]);
//        }
//        
        @Override
        protected void addNotify() {
//            super.addNotify();
//            createNodes();
            
            resetKeys();
        }
        
        private void resetKeys() {
            ArrayList keys = new ArrayList();
            Sources sources = ProjectUtils.getSources(project);
            SourceGroup[] srcGroups = sources.getSourceGroups(ProjectConstants.JAVA_SOURCES_TYPE);
            if(srcGroups == null || srcGroups.length == 0) {
                srcGroups = sources.getSourceGroups(Sources.TYPE_GENERIC);
            }
            for (SourceGroup srcGroup : srcGroups) {
                File projectDirFile = FileUtil.toFile(srcGroup.getRootFolder());
                File[] files = recursiveListFiles(projectDirFile, new SchemaFileFilter());
                for (File file : files) {
                    FileObject fo = FileUtil.toFileObject(file);
                    keys.add(fo);
                }
            }
            this.setKeys(keys);
        }
        
        private void createNodes() {
            List l = new ArrayList();
            l.add(KEY_SOURCES);
            setKeys(l);
        }
        
        @Override
        protected void removeNotify() {
            setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }
        
    }
    
    private File[] recursiveListFiles(File file, FileFilter filter) {
        List<File> files = new ArrayList<File>();
        File[] filesArr = file.listFiles(new SchemaFileFilter());
        files.addAll(Arrays.asList(filesArr));
        File[] dirs = file.listFiles(new DirFileFilter());
        for (File dir : dirs) {
            files.addAll(Arrays.asList(recursiveListFiles(dir, filter)));
        }
        return files.toArray(new File[files.size()]);
    }
    
    static class SchemaFileFilter implements FileFilter {
        
        public boolean accept(File pathname) {
            boolean result = false;
            String fileName = pathname.getName();
            String fileExtension = null;
            int dotIndex = fileName.lastIndexOf('.');
            if(dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex +1);
            }
            
            if(fileExtension != null 
                    && (fileExtension.equalsIgnoreCase(SCHEMA_FILE_EXTENSION))) {
                result = true;
            }
            
            return result;
        }
    }
    
    static class DirFileFilter implements FileFilter {
        
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
    
    class SchemaFileNode extends FilterNode {

        String displayName;
        
        public SchemaFileNode(Node original, String path) {
            super(original, Children.LEAF);
            displayName = path;
            
        }

        @Override
        public String getDisplayName() {
            return displayName;
        }
        
        
        
    }
    
     static class SchemaFileNodeChildren extends FilterNode.Children {
        
         public SchemaFileNodeChildren(Node node) {
            super(node);
        }
        
        @Override
        protected Node[] createNodes(Object key) {
            return new Node[] {new CategoryFilterNode((Node)key)};
        }
        
    }
     
     static class CategoryFilterNode extends FilterNode {
         
         public CategoryFilterNode(Node node) {
             super(node, new CategoryFilterChildren(node));
         }
         
         
     }

      static class CategoryFilterChildren extends FilterNode.Children {
         
         public CategoryFilterChildren(Node node) {
             super(node);
         }
         
         @Override
         protected Node[] createNodes(Object key) {
             return new Node[] {new ChildLessNode((Node)key)};
         }
         
     }
     
     static class ChildLessNode extends FilterNode {
         
        
         public ChildLessNode(Node node) {
             super(node, Children.LEAF);
         }
         
     }
}
