/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElement;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElementInfo;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElementInfoContainer;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElements;
import org.netbeans.modules.xml.wsdl.ui.wsdl.util.DisplayObject;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class CreateBindingFromPortTypeVisualPanel1 extends JPanel {
    
    private String bindingName;
    private Collection operations;
    private WSDLExtensibilityElements mElements;
    
    /** Creates new form CreateBindingFromPortTypeVisualPanel1 */
    public CreateBindingFromPortTypeVisualPanel1(PortType portType, WSDLExtensibilityElements elements) {
        bindingName = NameGenerator.getInstance().generateUniqueBindingName(portType.getModel(), portType.getName());
        operations = portType.getOperations();
        mElements = elements;
        initComponents();
        init();
    }
    
    private void init() {
        jTextField1.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                fireChangeEvent();
            }
            public void insertUpdate(DocumentEvent e) {
                fireChangeEvent();
            }
            public void removeUpdate(DocumentEvent e) {
                fireChangeEvent();
            }
        });
        jList1.setModel(new DefaultComboBoxModel(operations.toArray()));
        
        jList1.setCellRenderer(new DefaultListCellRenderer() {
        
            @Override
            public Component getListCellRendererComponent(JList list, Object value,
                    int index, boolean isSelected, boolean cellHasFocus) {
                
                Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                setText(((Operation) list.getModel().getElementAt(index)).getName());
                return comp;
            }
        
        });
        
        if (jList1.isSelectionEmpty()) {
            jList1.setSelectedIndex(0);
        }
        ArrayList<DisplayObject> comboboxList = new ArrayList<DisplayObject>();
        WSDLExtensibilityElement element = mElements.getWSDLExtensibilityElement(WSDLExtensibilityElements.ELEMENT_BINDING);
        List elementInfos = element.getWSDLExtensibilityElementInfos();
        Iterator it = elementInfos.iterator();
        while(it.hasNext()) {
            WSDLExtensibilityElementInfo elementInfo = (WSDLExtensibilityElementInfo) it.next();
            DataObject dataObject = elementInfo.getDataObject();
            Node delegateNode = dataObject.getNodeDelegate();
            if(delegateNode != null) {
                DisplayObject nameValuePair = new DisplayObject(delegateNode.getDisplayName(), elementInfo);
                comboboxList.add(nameValuePair);
            }
        }
        
        
        Iterator aweIt = element.getAllWSDLExtensibilityElementInfoContainers().iterator();
        while(aweIt.hasNext()) {
            WSDLExtensibilityElementInfoContainer provider = (WSDLExtensibilityElementInfoContainer) aweIt.next();
            List infos = provider.getAllWSDLExtensibilityElementInfo();
            if (infos != null) {
                for (int i = 0; i < infos.size(); i++) {
                    WSDLExtensibilityElementInfo elementInfo = (WSDLExtensibilityElementInfo) infos.get(i);
                    DataObject dataObject = elementInfo.getDataObject();
                    Node delegateNode = dataObject.getNodeDelegate();
                    if(delegateNode != null) {
                        DisplayObject nameValuePair = new DisplayObject(delegateNode.getDisplayName(), elementInfo);
                        comboboxList.add(nameValuePair);
                    }
                }
            }
        }    
        jComboBox1.setModel(new DefaultComboBoxModel(comboboxList.toArray()));

        
        
    }
    
    public String getName() {
        return NbBundle.getMessage(CreateBindingFromPortTypeVisualPanel1.class, "CreateBindingFromPortTypeVisualPanel1_NAME");
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jTextField1 = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jComboBox1 = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        jTextField1.setText(bindingName);
        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField1ActionPerformed(evt);
            }
        });

        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });

        jScrollPane1.setViewportView(jList1);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(CreateBindingFromPortTypeVisualPanel1.class, "CreateBindingFromPortTypeVisualPanel1.jLabel1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(CreateBindingFromPortTypeVisualPanel1.class, "CreateBindingFromPortTypeVisualPanel1.jLabel2.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(CreateBindingFromPortTypeVisualPanel1.class, "CreateBindingFromPortTypeVisualPanel1.jLabel3.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(jLabel2)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, jComboBox1, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, jTextField1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(jTextField1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(jComboBox1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel3)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 224, Short.MAX_VALUE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged
        fireChangeEvent();
    }//GEN-LAST:event_jList1ValueChanged

    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField1ActionPerformed
        fireChangeEvent();
    }//GEN-LAST:event_jTextField1ActionPerformed
    
    public String getBindingName() {
        return jTextField1.getText();
    }
    
    public JComponent getBindingNameComponent() {
        return jTextField1;
    }
    
    public Object[] getSelectedOperations() {
        return jList1.getSelectedValues();
    }
    
    public JComponent getOperationsComponent() {
        return jList1;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JList jList1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField jTextField1;
    // End of variables declaration//GEN-END:variables
    
    
    
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    public final void addChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.add(l);
        }
    }
    public final void removeChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.remove(l);
        }
    }
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        synchronized (listeners) {
            it = new HashSet<ChangeListener>(listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }
    
    public void storeValues(WizardDescriptor d) {
        if (d != null) {
            d.putProperty("bindingName", getBindingName());
            d.putProperty("selectedOperations", getSelectedOperations());
            d.putProperty("protocol", jComboBox1.getSelectedItem());
        }
    }
}

