/*
 * LocalizedTemplateGroup.java
 *
 * Created on September 1, 2006, 12:15 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.xml.wsdl.ui.view.wizard.localized;

import java.util.List;
import org.netbeans.modules.xml.wsdl.ui.spi.ExtensibilityElementTemplateProvider;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.TemplateGroup;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.TemplateType;

/**
 *
 * @author radval
 */
public class LocalizedTemplateGroup {
    
    public static final String TEMPLATE_GROUP="TEMPLATEGROUP";//NOI18N
    
    private TemplateGroup mTGroup;
    
    private ExtensibilityElementTemplateProvider mProvider;
    
    private LocalizedTemplate[] mLtts = null;
    
    /** Creates a new instance of LocalizedTemplateGroup */
    public LocalizedTemplateGroup(TemplateGroup tGroup, ExtensibilityElementTemplateProvider provider) {
        this.mTGroup = tGroup;
        this.mProvider = provider;
    }
    
    public String getName() {
        String lName = null;
        String name = TEMPLATE_GROUP + "_name"; //NOI18N
        try {
            lName =  this.mProvider.getLocalizedMessage(name, null);
        } catch (Exception ex) {
            lName = "UNKNOWN_NAME";
        }
        
        return lName;
    }
    
    public String getPrefix() {
        String lPrefix = null;
        String name = TEMPLATE_GROUP + "_prefix_" + this.mTGroup.getPrefix(); //NOI18N
        try {
            lPrefix =  this.mProvider.getLocalizedMessage(name, null);
        } catch (Exception ex) {
            lPrefix = "UNKNOWN_PREFIX";
        }
        
        return lPrefix;
    }
  
    public String getNamespace() {
        return this.mTGroup.getNamespace();
    }
    
    public TemplateGroup getDelegate() {
        return this.mTGroup;
    }
    
    public LocalizedTemplate[] getTemplate() { 
        if(mLtts != null) {
            return mLtts;
        }
        
        TemplateType[] tts = this.mTGroup.getTemplate();
        if(tts != null) {
            mLtts = new LocalizedTemplate[tts.length];
            for(int i =0; i < tts.length; i++) {
                TemplateType tt = tts[i];
                LocalizedTemplate ltt = new LocalizedTemplate(this, tt, this.mProvider);
                mLtts[i] = ltt;
            }
        }
        
        return mLtts;
    }
    
    public String toString() {
        return getName();
    }
}
