/*
 * LocalizedTemplate.java
 *
 * Created on September 1, 2006, 12:21 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.xml.wsdl.ui.view.wizard.localized;

import org.netbeans.modules.xml.wsdl.ui.spi.ExtensibilityElementTemplateProvider;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.TemplateType;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.WsdlElementType;

/**
 *
 * @author radval
 */
public class LocalizedTemplate {
    
    public static final String TEMPLATE = "TEMPLATE"; //NOI18N
    
    private LocalizedTemplateGroup mParent;
    
    private TemplateType mTemplateType;
    
    private ExtensibilityElementTemplateProvider mProvider;
    
    /** Creates a new instance of LocalizedTemplate */
    public LocalizedTemplate(LocalizedTemplateGroup parent, TemplateType template, ExtensibilityElementTemplateProvider provider) {
        this.mParent = parent;
        this.mTemplateType = template;
        this.mProvider = provider;
    }
    
    public LocalizedTemplateGroup getTemplateGroup() {
        return this.mParent;
    }
    
    public String getName() {
        String lName = null;
        try {
         String name = TEMPLATE + "_name_" + this.mTemplateType.getName(); //NOI18N
         lName = this.mProvider.getLocalizedMessage(name, null);
        } catch (Exception ex) {
            lName = this.mTemplateType.getName();
        }
        
        return lName;
    }
    
    public TemplateType getDelegate() {
        return this.mTemplateType;
    }

    public ExtensibilityElementTemplateProvider getMProvider() {
        return mProvider;
    }
    
    /**
     * get WSDLElementType 
     * @param wsdlElementName name attribute of <wsdlElement> 
     */
    public WsdlElementType getWSDLElementType(String wsdlElementName) {
        WsdlElementType wsdlElement = null;
        
        WsdlElementType[] wsdlElements = this.mTemplateType.getWsdlElement();
        if(wsdlElements != null) {
            for(int i = 0; i < wsdlElements.length; i++) {
                WsdlElementType w = wsdlElements[i];
                if(wsdlElementName.equals(w.getName())) {
                    wsdlElement = w;
                    break;
                }
            }
        }
        
        return wsdlElement;
    }
}
