/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.wsdl.ui.view.treeeditor;

import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeMemberEvent;

public class WSDLNodeListener extends NodeAdapter {
    private Node node;

    public WSDLNodeListener(Node node) {
        this.node = node;
    }

    @Override
    public void childrenAdded(NodeMemberEvent ev) {
        if (!ev.getNode().equals(node)) {
            return;
        }

        Node[] children = ev.getDelta();
        if (children != null && children.length > 0) {
            if (children.length == 1) {
                ActionHelper.selectNode(children[0], node);
            } else {
                ActionHelper.selectNode(node);  
            }
        }
        
    }
}
