/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * Created on May 18, 2005
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor;

import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.ui.cookies.AddChildWSDLElementCookie;
import org.netbeans.modules.xml.wsdl.ui.cookies.WSDLElementCookie;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype.NewTypesFactory;
import org.netbeans.modules.xml.xam.Component;
import org.openide.nodes.Children;
import org.openide.nodes.Node;



/**
 * @author radval
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public abstract class WSDLElementContainerNode extends WSDLElementNode {

    
    public WSDLElementContainerNode(Children children, WSDLComponent element, NewTypesFactory newTypesFactory) {
        super(children, element, newTypesFactory);
        this.getCookieSet().add(new AddChildWSDLElementCookie(element));
    }
    public WSDLElementContainerNode(Children children, WSDLComponent element) {
        super(children, element);
        this.getCookieSet().add(new AddChildWSDLElementCookie(element));
    }
    
    Node findChildNode(Component child) {
        Node childNode = null;
        if(child == null) {
            return null;
        }
        
        Node[] childNodes = this.getChildren().getNodes();
        for(int i =0; i < childNodes.length; i++) {
            Node node = childNodes[i];
            
            WSDLElementCookie cookie = (WSDLElementCookie) node.getCookie(WSDLElementCookie.class);
            
            if(cookie != null && child.equals(cookie.getWSDLComponent())) {
                childNode = node;
                break;
            }
        }
        return childNode;
    }
}
