/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * Created on May 17, 2005
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.namespace.QName;

import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.ui.cookies.AddChildWSDLElementCookie;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElements;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype.ExtensibilityElementNewTypesFactory;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;

/**
 * @author Ritesh Adval
 *
 *
 */
public class BPELExtensibilityElementsFolderNode extends FolderNode {
    
    private Definitions mDef = null;
    private static Set<String> bpelExtensionNamespaceSet = new HashSet<String>();
    public static String[] bpelExtensionNamespaces = {"http://schemas.xmlsoap.org/ws/2004/03/partner-link/",
    "http://schemas.xmlsoap.org/ws/2004/03/business-process/"};
    
    static {
        bpelExtensionNamespaceSet.addAll(Arrays.asList(bpelExtensionNamespaces));
    }
    
    public BPELExtensibilityElementsFolderNode(Definitions element) {
        super(new ExtensibilityElementsFolderChildren(element), element,
                ExtensibilityElement.class);
        mDef = element;
        
        this.setDisplayName(NbBundle.
                getMessage(BPELExtensibilityElementsFolderNode.class,
                "BPEL_EXTENSIBILITY_ELEMENTS_FOLDER_NODE_NAME"));
        getCookieSet().add(new AddChildWSDLElementCookie(element));
    }
    
    public static Set<String> getSupportedExtensionNamespaceSet() {
        return bpelExtensionNamespaceSet;
    }


    @Override
    public final NewType[] getNewTypes() {
        if (isEditable()) {
            return new ExtensibilityElementNewTypesFactory(WSDLExtensibilityElements.ELEMENT_DEFINITIONS, bpelExtensionNamespaces).getNewTypes(mDef);
        }
        return new NewType[] {};
    }
    
    
    public Object getWSDLConstruct() {
        return mDef;
    }
    
    public static final class ExtensibilityElementsFolderChildren extends GenericWSDLComponentChildren {
        public ExtensibilityElementsFolderChildren(Definitions definitions) {
            super(definitions);
            
        }
        
        @Override
        protected Collection getKeys() {
            Definitions def = (Definitions) getWSDLComponent();
            
            List<ExtensibilityElement> list = def.getExtensibilityElements();
            List<ExtensibilityElement> finalList = new ArrayList<ExtensibilityElement>();
            if (list != null) {
                for (ExtensibilityElement element : list) {
                    if (bpelExtensionNamespaceSet.contains(element.getQName().getNamespaceURI())) {
                        finalList.add(element);
                    }
                }
            }
            return finalList;
        }
    }

    @Override
    public Class getType() {
        return ExtensibilityElement.class;
    }

    @Override
    public boolean canHold(WSDLComponent comp) {
        if (comp instanceof ExtensibilityElement) {
            QName qname = ((ExtensibilityElement) comp).getQName();
            return bpelExtensionNamespaceSet.contains(qname.getNamespaceURI());
        }
        return false;
    }
}

