/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * AbstractChildren.java
 *
 * Created on April 26, 2006, 12:54 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor;

import java.util.Collection;
import java.util.Collections;

import javax.swing.SwingUtilities;

import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.nodes.Children;


/**
 *
 * @author radval
 */
public abstract class AbstractChildren extends Children.Keys implements ComponentListener {
    
    
    private WSDLComponent mElement;

        
    /** Creates a new instance of AbstractChildren */
    public AbstractChildren(WSDLComponent wsdlComponent) {
        this.mElement = wsdlComponent;
        mElement.getModel().addComponentListener(this);
    }
    
    public WSDLComponent getWSDLComponent() {
            return this.mElement;
    }
    
    protected void refreshChildren() {
    }
    
    
    public void childrenAdded(ComponentEvent evt) {
        if(!isSameAsMyWSDLElement((Component) evt.getSource())) {
            return;
        }
        
        Runnable run = new Runnable() {
            public void run() {
                refreshChildren();
            }
        };
        
        SwingUtilities.invokeLater(run);
        
        
    }

    public void childrenDeleted(ComponentEvent evt) {
        if(!isSameAsMyWSDLElement((Component) evt.getSource())) {
            return;
        }
        removeChild(evt.getSource());

    }

    public void valueChanged(ComponentEvent evt) {
        if(!isSameAsMyWSDLElement((Component) evt.getSource())) {
            return;
        }
        Runnable run = new Runnable() {
            public void run() {
                refreshChildren();
            }
        };
        
        SwingUtilities.invokeLater(run);
    }
    
    
    private void removeChild(Object key) {
        Runnable run = new Runnable() {
            public void run() {
                refreshChildren();
            }
        };
        
        SwingUtilities.invokeLater(run);
        
    }

    protected void addNotify() {
        super.addNotify();
        refreshChildren();
    }

    protected void removeNotify() {
        super.removeNotify();
        super.nodes.clear();
        refresh();
    }
        
   /**
     * call this method before any method of XMLElementListener to check
     * if this is the same source.
     * @param node
     * @return
     */
    protected boolean isSameAsMyWSDLElement(Component node) {
            if(node != null && node.equals(getWSDLComponent())) {
                    return true;
            }


            return false;
    }
        
    
    protected Collection getKeys() {
        return Collections.EMPTY_LIST;
    }
    

}
