/*
 * BindingConfigurationDialogPanel.java
 *
 * Created on September 8, 2006, 2:22 PM
 */

package org.netbeans.modules.xml.wsdl.ui.view;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.xml.wsdl.model.Binding;

import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.localized.LocalizedTemplate;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.localized.LocalizedTemplateGroup;

/**
 *
 * @author  skini
 */
public class BindingConfigurationDialogPanel extends javax.swing.JPanel {
    
    private String mErrorMessage = null;
    
    public static final String APPLY_CHANGE = "APPLY_CHANGE";
    /** Creates new form BindingConfigurationDialogPanel */
    public BindingConfigurationDialogPanel(WSDLModel model) {
        mModel = model;
        initComponents();
        initGUI();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingConfigurationPanel1 = new org.netbeans.modules.xml.wsdl.ui.view.BindingConfigurationPanel();
        commonMessagePanel1 = new org.netbeans.modules.xml.wsdl.ui.view.common.CommonMessagePanel();

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(bindingConfigurationPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 420, Short.MAX_VALUE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(commonMessagePanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 301, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(10, 10, 10))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(bindingConfigurationPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 264, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(commonMessagePanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void initGUI() {
        DocumentListener bindingNameListener  = new BindingNameChangeListener();
        DocumentListener serviceNameListener  = new ServiceNameChangeListener();
        DocumentListener servicePortNameListener  = new ServicePortNameChangeListener();
        
        this.bindingConfigurationPanel1.getBindingNameTextField().getDocument().addDocumentListener(bindingNameListener);
        this.bindingConfigurationPanel1.getServiceNameTextField().getDocument().addDocumentListener(serviceNameListener);
        this.bindingConfigurationPanel1.getServicePortTextField().getDocument().addDocumentListener(servicePortNameListener);
    }
    
    
    public String getBindingName() {
        return bindingConfigurationPanel1.getBindingName();
    }
    
    public void setBindingName(String bindingName) {
        bindingConfigurationPanel1.setBindingName(bindingName);
        
    }

    public void setServiceName(String svcName) {
        bindingConfigurationPanel1.setServiceName(svcName);
        
    }

    public void setServicePortName(String string) {
        bindingConfigurationPanel1.setServicePortName(string);
        
    }

    public LocalizedTemplateGroup getBindingType() {
        return bindingConfigurationPanel1.getBindingType();
    }

    public LocalizedTemplate getBindingSubType() {
        return bindingConfigurationPanel1.getBindingSubType();
    }

    public String getServiceName() {
        return bindingConfigurationPanel1.getServiceName();
    }

    public String getServicePortName() {
        return bindingConfigurationPanel1.getServicePortName();
    }
    
    
    private boolean isValidName(String text) {
        try {
            boolean isValid  = org.netbeans.modules.xml.xam.dom.Utils.isValidNCName(text);
            if(!isValid) {
                mErrorMessage = "Name \"" + text + "\" is not a valid NCName";
            } else {
                mErrorMessage = null;
            }
            
        }  catch(Exception ex) {
            ex.printStackTrace();
        }
        
        return mErrorMessage == null;
    }
    
    private void validateAll() {
        boolean validBinding = isValidName(this.bindingConfigurationPanel1.getBindingName());
        if(!validBinding) {
            updateMessagePanel();
            return;
        }
        
        
        boolean isBindingExist = isBindingExists();
        if(isBindingExist) {
            updateMessagePanel();
            return;
        }
        
        boolean validService = isValidName(this.bindingConfigurationPanel1.getServiceName());
        if(!validService) {
            updateMessagePanel();
            return;
        }
        
        
        boolean validPort = isValidName(this.bindingConfigurationPanel1.getServicePortName());
        if(!validPort) {
            updateMessagePanel();
            return;
        }
        
        
        String serviceName = this.bindingConfigurationPanel1.getServiceName();
        String portName = this.bindingConfigurationPanel1.getServicePortName();
        
        boolean isServicePortExist = isServicePortExists(serviceName, portName);
        if(isServicePortExist) {
            updateMessagePanel();
            return;
        }
        
        
        this.mErrorMessage = null;
        updateMessagePanel();
        
    }
    
    private boolean isBindingExists() {
        boolean exist = false;
        
        String text = this.bindingConfigurationPanel1.getBindingName();
        Binding b = mModel.findComponentByName(text, Binding.class);
            
        if(b != null) {
            this.mErrorMessage = "Binding \"" + text + "\" already exists.";
            exist = true;
        } 
                
        return exist;
    }
 
    
    
    public boolean isServicePortExists(String serviceName, String portName) {
        boolean exist = false;
        if(serviceName != null && portName != null) {
            Service service = mModel.findComponentByName(serviceName, Service.class);
            if(service != null) {
                exist = NameGenerator.getInstance().isServicePortExists(getServicePortName(), service);
                if (exist) {
                    this.mErrorMessage = "Service port" + getServicePortName() + " already exists.";
                }
            }
        }
        return exist;
    }
    
    private void updateMessagePanel() {
        if(this.mErrorMessage != null) {
            commonMessagePanel1.setErrorMessage(mErrorMessage);
            firePropertyChange(APPLY_CHANGE, !commonMessagePanel1.isStateValid(), commonMessagePanel1.isStateValid());
        } else {
            commonMessagePanel1.setMessage("");
            firePropertyChange(APPLY_CHANGE, !commonMessagePanel1.isStateValid(), commonMessagePanel1.isStateValid());
        }
    }
    
    private void isValidName(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            String text = doc.getText(0, doc.getLength());
            boolean isValid  = org.netbeans.modules.xml.xam.dom.Utils.isValidNCName(text);
            if(!isValid) {
                commonMessagePanel1.setErrorMessage("Name \"" + text + "\" is not a valid NCName");
            } else {
                commonMessagePanel1.setMessage("");
            }
            firePropertyChange(APPLY_CHANGE, !commonMessagePanel1.isStateValid(), commonMessagePanel1.isStateValid());
        }  catch(Exception ex) {
            ex.printStackTrace();
        }
    }
    

    class BindingNameChangeListener implements DocumentListener {
        
        public void changedUpdate(DocumentEvent e) {
            validateAll();
        }
        
        public void insertUpdate(DocumentEvent e) {
            validateAll();
        }
        
        public void removeUpdate(DocumentEvent e) {
            validateAll();
        }
    }
    
    class ServiceNameChangeListener implements DocumentListener {
        
        public void changedUpdate(DocumentEvent e) {
            validateAll();
        }
        
        public void insertUpdate(DocumentEvent e) {
            validateAll();
        }
        
        public void removeUpdate(DocumentEvent e) {
            validateAll();
        }
    }
    class ServicePortNameChangeListener implements DocumentListener {
        
        public void changedUpdate(DocumentEvent e) {
            validateAll();
        }
        
        public void insertUpdate(DocumentEvent e) {
            validateAll();
        }
        
        public void removeUpdate(DocumentEvent e) {
            validateAll();
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.netbeans.modules.xml.wsdl.ui.view.BindingConfigurationPanel bindingConfigurationPanel1;
    private org.netbeans.modules.xml.wsdl.ui.view.common.CommonMessagePanel commonMessagePanel1;
    // End of variables declaration//GEN-END:variables
    private WSDLModel mModel;
    
//    public void doesBindingExist() {
//        boolean exists = NameGenerator.getInstance().isBindingExists(getBindingName(), mModel);
//        if (commonMessagePanel1.isStateValid()) {
//            if (exists)
//                commonMessagePanel1.setErrorMessage("Binding Name " + getBindingName() + " already exists.");
//        }
//    }
//
//    public boolean doesServiceExists() {
//        return NameGenerator.getInstance().isServiceExists(getServiceName(), mModel);
//    }
//    
//    public void doesServicePortExists() {
//        if (doesServiceExists()) {
//            Service service = mModel.findComponentByName(getServiceName(), Service.class);
//            boolean exists = NameGenerator.getInstance().isServicePortExists(getServicePortName(), service);
//            if (commonMessagePanel1.isStateValid()) {
//                if (exists)
//                    commonMessagePanel1.setErrorMessage("Service port" + getServicePortName() + " already exists.");
//            }
//        }
//    }
}
