/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.wsdl.ui.spi;

import java.util.Collection;

import javax.xml.namespace.QName;

import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.openide.nodes.Node;

/**
 * This is a SPI for WSDL extensibility elements provider to implement in order to configure the way
 * wsdl editor behaves with the extensibility elements.
 *
 * @author skini
 *
 */

public abstract class ExtensibilityElementConfigurator {


    /**
     * Should return the qname of the element(s) supported by this configurator.
     * 
     * @return collection of QName(s)
     */
    public abstract Collection<QName> getSupportedQNames();
    
    
    /**
     * Return the Node.Property for the attribute name to be shown on the property sheet in wsdl editor.
     * The Property.setName() should be done if a different name is to be shown.
     * Setting value of extensibility element may result in exception if already in transaction in this method.
     * 
     * By default, name is set as value of attributeName and the description set to the documentation provided
     * in the schema or as the qname of the element.
     * If both have not been provided, then it should be set on the Node.Property before returning it.  
     * 
     * @param extensibilityElement the extensibility element
     * @param qname the qname of the element interested in
     * @param attributeName the name of the attribute
     * @return Node.Property instance for this attribute
     */
    public abstract Node.Property getProperty(ExtensibilityElement extensibilityElement, QName qname, String attributeName);
    
    
    /**
     * Specifies whether this attribute should be hidden (in the property sheet).
     * If returns true, then the attribute is not shown on the property sheet.
     * 
     * This method can be used to hide attributes and create a Property editor for multiple properties.
     * For e.g. Part can have element or type but not both, so set type as hidden and create a node.property 
     * for element with name as "Element or Type" and appropriately change the setValue or getValue to set appropriate
     * attribute.
     * 
     * @param qname qname of the element
     * @param attributeName name of the attribute
     * @return true if to be hidden
     */
    public boolean isHidden(ExtensibilityElement extensibilityElement, QName qname, String attributeName) {
        return false;
    }
    
    /**
     * Specifies the name of the attribute, the value of which will be as the display name for this element.
     * 
     * @param extensibilityElement
     * @param qname
     * @return the attribute name.
     */
    public abstract String getDisplayAttributeName(ExtensibilityElement extensibilityElement, QName qname);
    
    /**
     * Returns a initial value for this attribute. return a value which will be used as a prefix and
     * unique names generated by wsdl editor. prefix1, prefix2 etc..
     * 
     * 
     * @param qname
     * @param attributeName
     * @return String either default value(if boolean or enumerated), otherwise prefix
     */
    
    public abstract String getAttributeUniqueValuePrefix(ExtensibilityElement extensibilityElement, QName qname, String attributeName);
    
    /**
     * Gives a default value for the attribute.
     * 
     * 
     * @param qname
     * @param attributeName
     * @return
     */
    public abstract String getDefaultValue(ExtensibilityElement extensibilityElement, QName qname, String attributeName);
    
    public abstract String getTypeDisplayName(ExtensibilityElement extensibilityElement, QName qname);
    

    public String getHtmlDisplayNameDecoration(ExtensibilityElement construct, QName name) {
        return null;
    }
    
}
