/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.tools.generator;

import java.awt.*;
import java.util.*;
import java.beans.*;

import org.openide.src.Type;
import org.openide.src.Identifier;
import org.openide.util.*;

import javax.swing.*;
import javax.swing.table.*;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * Allows to define mapping element name => (method identifier, return type)
 * in visual way. Class holding methods performing convertions is called parslet (set
 * of mini-parsers).
 *
 * @author  Petr Kuzel
 * @version 
 */
public final class SAXGeneratorParsletPanel extends SAXGeneratorAbstractPanel {

    /** Serial Version UID */
    private static final long serialVersionUID =6038099487791703339L;    


    private TableModel tableModel;  //it is based on model

    private static final int ELEMENT_COLUMN = 0;
    private static final int METHOD_COLUMN = 1;  // represents parslet
    private static final int TYPE_COLUMN = 2;    
    private static final int COLUMNS = 3;
    
    private static final String NO_METHOD = "[none]"; // NOI18N
    
    private final String[] COLUMN_NAMES = new String[] {
        Util.THIS.getString ("SAXGeneratorParsletPanel.table.column1"),
        Util.THIS.getString ("SAXGeneratorParsletPanel.table.column2"),
        Util.THIS.getString ("SAXGeneratorParsletPanel.table.column3"),
    };

    private final ValidatingTextField.Validator TYPE_VALIDATOR = new ValidatingTextField.Validator() {
        public boolean isValid(String value) {
            boolean ret = GenerateSupportUtils.isValidReturnType(value);
            setValid(ret);
            return ret;
        }
        
        public String getReason() {
            return Util.THIS.getString("MSG_parslet_err_1");
        }
    };
    
    private final ValidatingTextField.Validator METHOD_VALIDATOR = new ValidatingTextField.Validator() {
        public boolean isValid(String value) {
            boolean ret = NO_METHOD.equals(value) || Utilities.isJavaIdentifier(value);
            setValid(ret);
            return ret;
        }
        
        public String getReason() {
            return Util.THIS.getString("MSG_parslet_err_2");
        }
        
    };
    
    /** Creates new form SAXGeneratorParsletPanel */
    public SAXGeneratorParsletPanel() {
//        try {
//            this.putClientProperty("WizardPanel_helpURL", new URL("nbresloc:/org/netbeans/modules/xml/tools/generator/SAXGeneratorParsletPanel.html"));  //NOI18N
//        } catch (MalformedURLException ex) {
//        }            
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        descTextArea = new javax.swing.JTextArea();
        tableScrollPane = new javax.swing.JScrollPane();
        table = new javax.swing.JTable();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(480, 350));
        setName(Util.THIS.getString ("SAXGeneratorParsletPanel.Form.name"));
        descTextArea.setWrapStyleWord(true);
        descTextArea.setLineWrap(true);
        descTextArea.setEditable(false);
        descTextArea.setForeground(new java.awt.Color(102, 102, 153));
        descTextArea.setFont(javax.swing.UIManager.getFont ("Label.font"));
        descTextArea.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/xml/tools/generator/Bundle").getString("DESC_saxw_convertors"));
        descTextArea.setDisabledTextColor(javax.swing.UIManager.getColor ("Label.foreground"));
        descTextArea.setEnabled(false);
        descTextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        add(descTextArea, gridBagConstraints);

        table.setModel(tableModel);
        tableScrollPane.setViewportView(table);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(tableScrollPane, gridBagConstraints);

    }//GEN-END:initComponents


    /**
     * Prepare all models used by this form
     */
    private void initModels() {
        
        // there is one huge table allowing main customization
        
        tableModel = new ParsletsTableModel();
    }
    
    
    /**
     * Upadate view according to model.
     */
    protected void initView() {
        initModels();
        initComponents ();
	
        table = new ParsletsTable();
        table.setModel(tableModel);        
        tableScrollPane.setViewportView(table);  //install it
        
        initAccessibility();
    }

    protected void updateView() {
    }
    
    /**
     * Our table model directly updates model data.
     * We need just reset parslets if not used.
     */
    protected void updateModel() {
//        if (parsletsCheckBox.isSelected()==false) {
//            model.getParsletBindings().clear();
//        }
    }

    
    // ~~~~~~~~~~~~~~ Table and its model ~~~~~~~~~~~~~~~~~~~~
    
    /**
     * The table using dynamic cell editors for TYPE_COLUMN and METHOD_COLUMN
     */
    private class ParsletsTable extends JTable {

        /** Serial Version UID */
        private static final long serialVersionUID =1076091649418718319L;
        
        public ParsletsTable() {
            getTableHeader().setReorderingAllowed(false);
            setRowHeight(Util.getTextCellHeight(this));
        }
        
        public TableCellEditor getCellEditor(int row, int column) {
            
            switch (column) {                
                
                case METHOD_COLUMN:
                    Vector all = new Vector(model.getParsletBindings().keySet());
                    JComboBox editor = new JComboBox(all);
                    editor.addItem(NO_METHOD);
                    ValidatingTextField methodInput = new ValidatingTextField();
                    methodInput.setValidator(METHOD_VALIDATOR);
                    editor.setEditor(methodInput);
                    editor.setEditable(true);
                    return new DefaultCellEditor(editor);
                
                case TYPE_COLUMN:
                    String[] vals = {
                        "int", "boolean","long", "java.util.Date", "java.net.URL", // NOI18N
                        "java.lang.String", "java.lang.String[]" // NOI18N
                    };
                    JComboBox type_editor = new JComboBox(vals);
                    ValidatingTextField typeInput = new ValidatingTextField();
                    typeInput.setValidator(TYPE_VALIDATOR);
                    type_editor.setEditor(typeInput);
                    type_editor.setEditable(true);                    
                    return new DefaultCellEditor(type_editor);

                    
                default:
                    return super.getCellEditor(row, column);
            }
        }
        
    }
    
    /**
     * Model contrainig some parslets issues
     */
    private class ParsletsTableModel extends AbstractTableModel {
            
        /** Serial Version UID */
        private static final long serialVersionUID =3516749023312029787L;
        
        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        public int getRowCount() {
            if (model == null) return 0;
            return model.getElementBindings().size();
        }

        public int getColumnCount() {
            return COLUMNS;
        }


        /**
          * @return Type or String depending on column
          */
        public Object getValueAt(int row, int column) {
            ElementBindings.Entry entry = model.getElementBindings().getEntry(row);
            ParsletBindings parslets = model.getParsletBindings();

            // set to parslet or null if none assigned
            String parslet = entry.getParslet();

            switch (column) {
                
                case ELEMENT_COLUMN: 
                    return entry.getElement();
                    
                case TYPE_COLUMN: 
                    if (parslet == null) {
                        return String.class.getName();
                    } else {
                        return parslets.getReturnType(parslet).toString();
                    }
                    
                case METHOD_COLUMN: 
                    if (parslet == null) {
                        return NO_METHOD;
                    } else {
                        return parslet;
                    }
            }
            return null;
        }

        /**
          * @param value must be a String regardless column
          */
        public void setValueAt(Object value, int row, int col) {

//            new RuntimeException("Setting Value to " + value).printStackTrace();
            
            if (col == TYPE_COLUMN) {
                if (TYPE_VALIDATOR.isValid((String) value) == false) return;
            } else if (col == METHOD_COLUMN) {
                if (METHOD_VALIDATOR.isValid((String)value) == false) return;
            }
            
            ElementBindings binds = model.getElementBindings();
            ElementBindings.Entry entry = binds.getEntry(row);

            // set to parslet or null if none assigned
            String currentParslet = entry.getParslet();

            ParsletBindings parslets = model.getParsletBindings();
            ParsletBindings.Entry parsletEntry = parslets.getEntry(currentParslet);

            switch (col) {
                case TYPE_COLUMN:
                    // all parslets of the same name must return same type
                    if (currentParslet == null) {
                       break;  // can not set a value
                    } else {
                        if (binds.getParsletUsageCount(currentParslet)>1) {
                            if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("Cannot change"); // NOI18N
                        } else {
                            Type returnType = 
                                Type.createClass(Identifier.create((String)value));
                            parsletEntry.setReturnType(returnType); 
                        }
                    }
                    break;

                // setting parslet determines return value    
                case METHOD_COLUMN:    
                                        
                    String identifier = (String)value;
                    String oldReturnType = parslets.getReturnType(currentParslet).toString();
                    
                    if (binds.getParsletUsageCount(currentParslet) == 1) {
                        parslets.remove(currentParslet);
                    }
                    if (NO_METHOD.equals(identifier) == false) {
                        entry.setParslet(identifier);
                    
                        if (parslets.getEntry(identifier) == null) {
                            //parslets.put(identifier, (String) getValueAt(row, TYPE_COLUMN));
                            parslets.put(identifier, oldReturnType);
                        } else {
                            fireTableRowsUpdated(row,row);
                        }
                    } else {
                        entry.setParslet(null);
                        fireTableRowsUpdated(row,row);
                    }
                    break;

            }
//            if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug(model.toString());

        }

        public boolean isCellEditable(int row, int col) {
            return col != ELEMENT_COLUMN;
        }
    };  //ParsletsTableModel
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable table;
    private javax.swing.JTextArea descTextArea;
    private javax.swing.JScrollPane tableScrollPane;
    // End of variables declaration//GEN-END:variables

    /** Initialize accesibility
     */    
    public void initAccessibility(){

        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_SAXGeneratorParsletPanel"));
        table.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_ParsletsTable"));
        table.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_ParsletsTable"));        
    }
}
