/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.text.syntax;

import java.util.*;
import org.netbeans.modules.xml.core.actions.CollectSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.ViewAction;
import org.openide.modules.*;
import org.openide.util.*;
import org.openide.util.actions.SystemAction;

/**
 * Represents a list  of optional (enableness driven) actions.
 * Possible actions are hardcoded in {@link #getPossibleActions()}.
 *
 * @author Libor Kramolis
 */
final class XMLViewActions extends CollectSystemAction {

    /** Serial Version UID */
    private static final long serialVersionUID = 8223872687291078210L;

    /**
     */
    protected final Class getActionLookClass () {
        // will not be called because rewritten getPossibleActions by subclasses
        return null;
    }

    protected Collection getPossibleActions () {
        Collection actions = new Vector(2);
        
        // XXX #48712 heuristics: enable open action only if tree editor installed
        boolean visualEditorInstalled = false;
        Lookup lookup = Lookup.getDefault();
        Lookup.Template t = new Lookup.Template(ModuleInfo.class);
        Iterator it = lookup.lookup(t).allInstances().iterator();
        while (it.hasNext()) {
            ModuleInfo next = (ModuleInfo) it.next();
            if (next.getCodeNameBase().equals("org.netbeans.modules.xml.tree") && next.isEnabled()) {  // NOI18N
                visualEditorInstalled = true;
                break;
            }
        }
        if (visualEditorInstalled) {                
            actions.add (SystemAction.get (OpenAction.class));
        }
        actions.add (SystemAction.get (ViewAction.class));
        return actions;
    }


    /* Do nothing.
     * This action itself does nothing, it only presents other actions.
     * @param ev ignored
     */
    public void actionPerformed (java.awt.event.ActionEvent e) {
    }


    /* Getter for name
     */
    public String getName () {
        return Util.THIS.getString ("NAME_WeakXMLActions");
    }

    /* Getter for help.
     */
    public HelpCtx getHelpCtx () {
        return new HelpCtx (XMLViewActions.class);
    }

}
