/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * MemberTypesPanel.java
 *
 * Created on January 25, 2006, 12:50 PM
 */

package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.nodes.schema.UnionNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/**
 *
 * @author  Administrator
 */
public class MemberTypesPanel extends javax.swing.JPanel 
    implements ActionListener, ListSelectionListener {
    
    static final long serialVersionUID = 1L;
    private transient SchemaModel model;

    /**
     * Creates new form MemberTypesPanel
     */
    public MemberTypesPanel(SchemaModel model,
            Collection<GlobalSimpleType> initialSelection) {
        this.model = model;
        initComponents();
        memberTypesList.setModel(new MemberTypesModel(initialSelection));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        memberTypesList = new javax.swing.JList();
        upButton = new javax.swing.JButton();
        downButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(addButton, org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "LBL_Add"));
        addButton.setToolTipText(org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "HINT_Add"));
        addButton.addActionListener(this);

        org.openide.awt.Mnemonics.setLocalizedText(removeButton, org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "LBL_Remove"));
        removeButton.setToolTipText(org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "HINT_Remove"));
        removeButton.addActionListener(this);
        removeButton.setEnabled(false);

        memberTypesList.addListSelectionListener(this);
        jScrollPane1.setViewportView(memberTypesList);

        org.openide.awt.Mnemonics.setLocalizedText(upButton, org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "LBL_Up"));
        upButton.setToolTipText(org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "HINT_Up"));
        upButton.setEnabled(false);
        upButton.addActionListener(this);

        org.openide.awt.Mnemonics.setLocalizedText(downButton, org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "LBL_Down"));
        downButton.setToolTipText(org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "HINT_Down"));
        downButton.setEnabled(false);
        downButton.addActionListener(this);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setLabelFor(memberTypesList);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(MemberTypesPanel.class, "LBL_CurrentlySelectedMemberTypes"));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(26, 26, 26)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 117, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 209, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(19, 19, 19)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(addButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 86, Short.MAX_VALUE)
                        .add(removeButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(downButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 86, Short.MAX_VALUE)
                    .add(upButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 86, Short.MAX_VALUE))
                .add(87, 87, 87))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(26, 26, 26)
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(addButton)
                        .add(13, 13, 13)
                        .add(removeButton)
                        .add(15, 15, 15)
                        .add(upButton)
                        .add(15, 15, 15)
                        .add(downButton))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 144, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(44, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    public void actionPerformed(ActionEvent e) {
        if(e.getSource().equals(addButton)) {
            Dialog selector = getSelectorDialog();
            selector.setVisible(true);
        } else if(e.getSource().equals(removeButton)) {
            int[] indices = memberTypesList.getSelectedIndices();
            for (int ctr = indices.length;ctr>0;ctr--) {
                MemberTypesModel model = (MemberTypesModel) memberTypesList.getModel();
                model.removeMember(indices[ctr-1]);
            }
            memberTypesList.setSelectedIndex(0);
        } else if(e.getSource().equals(upButton)) {
            int selectedIndex = memberTypesList.getSelectedIndex();
            MemberTypesModel model = (MemberTypesModel) memberTypesList.getModel();
            model.moveMember(selectedIndex,true);
            memberTypesList.setSelectedIndex(selectedIndex-1);
        } else if(e.getSource().equals(downButton)) {
            int selectedIndex = memberTypesList.getSelectedIndex();
            MemberTypesModel model = (MemberTypesModel) memberTypesList.getModel();
            model.moveMember(selectedIndex,false);
            memberTypesList.setSelectedIndex(selectedIndex+1);
        }
    }
    
    public void valueChanged(ListSelectionEvent e) {
        if(e.getSource().equals(memberTypesList)) {
            if(memberTypesList.getSelectedIndices()==null || memberTypesList.getModel().getSize()==0) {
                removeButton.setEnabled(false);
                upButton.setEnabled(false);
                downButton.setEnabled(false);
            } else {
                removeButton.setEnabled(true);
                if(memberTypesList.getSelectedIndices().length>1) {
                    upButton.setEnabled(false);
                    downButton.setEnabled(false);
                } else {
                    int selectedIndex = memberTypesList.getSelectedIndex();
                    if(selectedIndex==0){
                        upButton.setEnabled(false);
                    } else {
                        upButton.setEnabled(true);
                    }
                    if(selectedIndex==memberTypesList.getModel().getSize()-1) {
                        downButton.setEnabled(false);
                    } else {
                        downButton.setEnabled(true);
                    }
                }
            }
        }
    }
    
    private Dialog getSelectorDialog() {
        final SchemaComponentSelectionPanel panel =  new SchemaComponentSelectionPanel
				<GlobalSimpleType>(
                model, GlobalSimpleType.class,
                null, Collections.unmodifiableCollection(getCurrentSelection()), true);
        DialogDescriptor descriptor = new SchemaComponentSelDialogDesc(panel,
                NbBundle.getMessage(GlobalReferenceEditor.class,
                "LBL_Custom_Property_Editor_Title",
                new Object[] {NbBundle.getMessage(UnionNode.class, "LBL_UnionNode_TypeDisplayName")
                        , NbBundle.getMessage(UnionNode.class, "PROP_MemberTypes_DisplayName")}),
                true,
                new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    try {
                        MemberTypesModel model = (MemberTypesModel) memberTypesList.getModel();
                        model.addMember((GlobalSimpleType)panel.getCurrentSelection());
                    } catch (IllegalArgumentException iae) {
                        ErrorManager.getDefault().annotate(iae, ErrorManager.USER,
                                iae.getMessage(), iae.getLocalizedMessage(),
                                null, new java.util.Date());
                        throw iae;
                    }
                }
            }
        }
        );
        
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        return dlg;
        
    }

    public List<GlobalSimpleType> getCurrentSelection() {
        return ((MemberTypesModel)memberTypesList.getModel()).getMembers();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JButton downButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList memberTypesList;
    private javax.swing.JButton removeButton;
    private javax.swing.JButton upButton;
    // End of variables declaration//GEN-END:variables
    
    public static class MemberTypesModel extends AbstractListModel {
    static final long serialVersionUID = 1L;
        private List<GlobalSimpleType> members;
        public MemberTypesModel(Collection<GlobalSimpleType> members) {
            super();
            this.members = new ArrayList<GlobalSimpleType>();
            if(members != null)
                this.members.addAll(members);
        }

        public int getSize() {
            return members.size();
        }

        public Object getElementAt(int index) {
            return members.isEmpty()?"":members.get(index)==null?"":members.get(index).getName();
        }
        
        public List<GlobalSimpleType> getMembers() {
            return members;
        }
        
        public void addMember(GlobalSimpleType member) {
            members.add(member);
            super.fireIntervalAdded(this,getSize(),getSize());
        }

        public void removeMember(int index) {
            if(index>-1) {
                members.remove(index);
                super.fireIntervalRemoved(this,index,index);
            }
        }
        
        public void moveMember(int index, boolean up) {
            GlobalSimpleType movedMember = members.remove(index);
            int newIndex = up?index-1:index+1;
            members.add(newIndex,movedMember);
            super.fireContentsChanged(this,index,newIndex);
        }
    }
}
