/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.schema.core.actions;

import java.io.IOException;
import org.netbeans.modules.xml.axi.SchemaGeneratorFactory;
import org.netbeans.modules.xml.schema.abe.wizard.SchemaTransformWizard;
import org.netbeans.modules.xml.schema.core.SchemaDataObject;
import org.netbeans.modules.xml.schema.core.SchemaEditorSupport;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.SchemaModelCookie;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

/**
 * An action on the SchemaDataObject node (SchemaNode)
 * to "Transform" the schema (from one design pattern to another)
 *
 * @author Ayub Khan
 */
public class SchemaTransformAction extends CookieAction {
    private static final long serialVersionUID = 1L;
    
    private static final Class[] COOKIE_ARRAY =
            new Class[] {SchemaModelCookie.class};
    
    /** Creates a new instance of SchemaViewOpenAction */
    public SchemaTransformAction() {
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected void performAction(Node[] node) {
        assert node.length==1:
            "Length of nodes array should be 1";
        try {
            SchemaModel sm = getSchemaModel(node);
//            if(isValidSchema(sm))
            showWizard(sm);
        } catch (IOException ex) {
//            ex.printStackTrace();
        }
    }
    
    private SchemaModel getSchemaModel(final Node[] node) throws IOException {
        if(node == null || node.length == 0 || node[0] == null)
            return null;
        
        SchemaDataObject sdo = (SchemaDataObject)node[0].getLookup().lookup(
                SchemaDataObject.class);
        if (sdo != null){
            SchemaEditorSupport editor = sdo.getSchemaEditorSupport();
            return editor.getModel();
        }
        return null;
    }
    
    private boolean isValidSchema(SchemaModel sm) {
        if(sm != null) {
            SchemaGeneratorFactory.TransformHint hint =
                    SchemaGeneratorFactory.getDefault().canTransformSchema(
                    sm, null, null);
            if(hint != SchemaGeneratorFactory.TransformHint.INVALID_SCHEMA)
                return true;
        }
        return false;
    }
    
    protected boolean enable(Node[] node) {
//        if(super.enable(node)) {
//            SchemaModel sm = null;
//            try {
//                sm = getSchemaModel(node);
//            } catch (IOException ex) {
//            }
//            return isValidSchema(sm);
//        }
//        return false;
        if(super.enable(node)) {
            SchemaModel sm = null;
            try {
                sm = getSchemaModel(node);
            } catch (IOException ex) {
            }
            return XAMUtils.isWritable(sm);
        }
        return false;
//	return super.enable(node);
    }
    
    public String getName() {
        return NbBundle.getMessage(
                SchemaViewOpenAction.class, "LBL_ApplyDesignPattern_Name");
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected boolean asynchronous() {
        
        return false;
    }
    
    private void showWizard(SchemaModel sm) {
        if(sm != null)
            new SchemaTransformWizard(sm).show();
    }
    
    protected int mode() {
        return CookieAction.MODE_EXACTLY_ONE;
    }
    
    protected Class[] cookieClasses() {
        return COOKIE_ARRAY;
    }
}
