/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * CatalogModelHelper.java
 *
 * Created on June 9, 2006, 4:37 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.xml.schema.completion.util;

import java.net.URI;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * Helps in getting the model for code completion.
 *
 * @author Samaresh (Samaresh.Panda@Sun.Com)
 */
public class CatalogModelHelper {
    
    private FileObject primaryFile;
    private ModelSource modelSource;
    private CatalogModel catalogModel;
    private String fileLocation;
    
    /**
     * This must be created in an AWT thread, since it uses
     * WindowManager to find the active file.
     */
    public CatalogModelHelper() {
        try {
            org.openide.windows.Mode mode = WindowManager.getDefault().findMode("editor"); //NOI18N
            TopComponent activatedTC = mode.getSelectedTopComponent();
            DataObject activeFile = (DataObject)activatedTC.getLookup().lookup(DataObject.class);
            primaryFile = activeFile.getPrimaryFile();
            String path = primaryFile.getPath();
            fileLocation = path.substring(0, path.indexOf(primaryFile.getName()));
//System.out.println("Folder: " + fileLocation);
            modelSource = Utilities.getModelSource(primaryFile, true);
            CatalogModelFactory factory = CatalogModelFactory.getDefault();
            catalogModel = factory.getCatalogModel(modelSource);        
        } catch (CatalogModelException ex) {
            //just catch
            ex.printStackTrace();            
        }
    }
    
    public String getFileLocation() {
        return fileLocation;
    }
    
    private ModelSource getModelSource() {
        return modelSource;
    }
    
    private CatalogModel getCatalogModel() {
        return catalogModel;
    }
    
    public AXIModel getModel(String schemaLocation) {
        if(catalogModel == null)
            return null;
        try {
            ModelSource schemaModelSource = catalogModel.getModelSource(new URI(schemaLocation),
                    modelSource);
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(schemaModelSource);        
            return AXIModelFactory.getDefault().getModel(schemaModel);
        } catch(Exception ex) {
            //just catch
            ex.printStackTrace();
        }
        return null;
    }
        
}
