/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.schema.abe.wizard;

import org.openide.*;
import org.openide.util.*;
import org.openide.windows.*;
import java.awt.*;
import java.awt.Dialog;

/**
 *
 * @author  Ayub Khan
 */
public class SchemaTransformProgressPanel extends javax.swing.JPanel {
    // Variables declaration - do not modify
    private javax.swing.JLabel jLabel1;
    private javax.swing.JProgressBar progressBar;
    
    private Dialog dialog;
    
    /**
     *
     *
     */
    public SchemaTransformProgressPanel() {
        super();
        initComponents();
    }
    
    /**
     *
     *
     */
    public DialogDescriptor createDialog(String message) {
        SchemaTransformProgressPanel panel = new SchemaTransformProgressPanel();
        DialogDescriptor descriptor = new DialogDescriptor(
                panel, NbBundle.getMessage(
                SchemaTransformProgressPanel.class,
                "MSG_SchemaTransform_ProgressPanel", new Object[]{message})
                ); // NOI18N
        
        final Object[] OPTIONS = new Object[0];
        descriptor.setOptions(OPTIONS);
        descriptor.setClosingOptions(OPTIONS);
        descriptor.setModal(true);
        descriptor.setOptionsAlign(DialogDescriptor.BOTTOM_ALIGN);
        
        dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        int windowX = mainWindow.getX();
        int windowY = mainWindow.getY();
        int windowWidth = mainWindow.getWidth();
        int windowHeight = mainWindow.getHeight();
        int dialogWidth = dialog.getWidth();
        int dialogHeight = dialog.getHeight();
        int dialogX = (int)(windowWidth/2.0) - (int)(dialogWidth/2.0);
        int dialogY = (int)(windowHeight/2.0) - (int)(dialogHeight/2.0);
        
        dialog.setLocation(dialogX, dialogY);
        
        return descriptor;
    }
    
    /**
     *
     *
     */
    public void showDialog(String message) {
        assert dialog != null : "invoke createDialog, then call this method";
        dialog.setVisible(true);
    }
    
    /**
     *
     *
     */
    public void hideDialog() {
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
            dialog = null;
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 15, 10)));
        setMinimumSize(new java.awt.Dimension(100, 38));
        setPreferredSize(new java.awt.Dimension(250, 55));
        jLabel1.setText(
            java.util.ResourceBundle.getBundle("org/netbeans/modules/xml/schema/abe/wizard/Bundle")
                                    .getString("MSG_SchemaTransform_ProgressPanelMessage")
        );
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel1, gridBagConstraints);

        progressBar.setIndeterminate(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(progressBar, gridBagConstraints);
    }//GEN-END:initComponents
    
}
