/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * WhereUsedReader.java
 *
 * Created on October 26, 2005, 11:27 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.xml.refactoring.ui.readers;

import java.awt.Color;
import java.awt.Image;
import java.beans.BeanInfo;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Utilities;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.spi.project.ui.LogicalViewProvider;

import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.DocumentModel;

import org.netbeans.modules.xml.nbprefuse.AnalysisConstants;
import org.netbeans.modules.xml.refactoring.FindUsageResult;
import org.netbeans.modules.xml.refactoring.UsageGroup;
import org.netbeans.modules.xml.refactoring.ui.j.ui.CheckNode;
import org.netbeans.modules.xml.refactoring.ui.util.AnalysisUtilities;
import org.netbeans.modules.xml.refactoring.RefactoringManager;
import org.netbeans.modules.xml.refactoring.Usage;
import org.netbeans.modules.xml.refactoring.UsageSet;
import org.netbeans.modules.xml.refactoring.spi.UIHelper;

import prefuse.data.Node;
import prefuse.data.Edge;
import prefuse.data.Graph;

/**
 *
 * @author Jeri Lockhart
 *
 * Reader for Where Used query and Complex Type Derivations query
 */
public class WhereUsedReader {
    
    private static final ImageIcon FIND_USAGES_ICON = new ImageIcon(
            Utilities.loadImage(
            "org/netbeans/modules/refactoring/resources/"+
            "findusages.png"));
    
    public static final prefuse.data.Schema FIND_USAGES_NODES_SCHEMA =
            new prefuse.data.Schema();   // prefuse graph schema
    static {
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.LABEL,
                String.class, AnalysisConstants.EMPTY_STRING);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.ID,
                String.class, AnalysisConstants.EMPTY_STRING);
        FIND_USAGES_NODES_SCHEMA.addColumn(
                AnalysisConstants.COMPONENT_TYPE_NAME,
                String.class, AnalysisConstants.EMPTY_STRING);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.ELEMENT_TYPE,
                String.class, AnalysisConstants.EMPTY_STRING);
        // type of a GE, LE, GA, or LA
        
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.XML_FILENAME,
                String.class, AnalysisConstants.EMPTY_STRING);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.FILE_OBJECT,
                FileObject.class);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.FILE_TYPE,
                String.class, AnalysisConstants.EMPTY_STRING);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.TOOLTIP,
                String.class, AnalysisConstants.EMPTY_STRING); // name
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.XAM_COMPONENT,
                Component.class);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.OPENIDE_NODE,
                org.openide.nodes.Node.class);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.JAVA_AWT_IMAGE,
                Image.class);
        
        // used to set node visible or not visible, depending on whether the
        // file node is expanded or collapsed
        //  -1 = always visible, any other value matches a
        // FILE_NODE_FILE_GROUP
        // the file node itself has a FILE_GROUP of -1 because it is always
        // visible
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.FILE_GROUP,
                int.class, -1);
        // a File Node has a positive value for this column, other nodes
        //   have a -1 value
        FIND_USAGES_NODES_SCHEMA.addColumn(
                AnalysisConstants.FILE_NODE_FILE_GROUP, int.class, -1);
        // assigned number of schema file group
        
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.IS_PRIMITIVE,
                boolean.class, false);  // is builtin type
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.IS_QUERY_NODE,
                boolean.class, false);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.IS_USAGE_NODE,
                boolean.class, false);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.IS_FILE_NODE,
                boolean.class, false);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.IS_EXPANDED,
                boolean.class, false);
        FIND_USAGES_NODES_SCHEMA.addColumn(AnalysisConstants.MOUSEOVER,
                boolean.class, false);
    }
    
    
    
    public static final prefuse.data.Schema FIND_USAGES_EDGES_SCHEMA =
            new prefuse.data.Schema();   // prefuse graph schema
    static {
        FIND_USAGES_EDGES_SCHEMA.addColumn(AnalysisConstants.LABEL,
                String.class, AnalysisConstants.EMPTY_STRING);
        FIND_USAGES_EDGES_SCHEMA.addColumn(AnalysisConstants.EDGE_TYPE,
                String.class, AnalysisConstants.EMPTY_STRING);
        //  "file-edge-type" "generalization", "reference" "composition"
        
        FIND_USAGES_EDGES_SCHEMA.addColumn(AnalysisConstants.TOOLTIP,
                String.class, AnalysisConstants.EMPTY_STRING);
        // used to set edge visible or not visible, depending on whether the
        // file node is expanded or collapsed
        //  -1 = always visible, any other value matches a
        // FILE_NODE_FILE_GROUP
        // the file node itself has a FILE_GROUP of -1 because it is
        // always visible
        FIND_USAGES_EDGES_SCHEMA.addColumn(AnalysisConstants.FILE_GROUP,
                int.class, -1);
    }
    
    /**
     * graph for WhereUsedView
     * @param buildTreeModel true, if the logical DefaultTreeModel
     *                       for the Find Usages output window is to be built
     *                       at the same time that the graph is being created
     *
     *  Logical View of Explorer Tree
     *    Root Node "Usages of Xyz [3 occurrences]"
     *        Project Node
     *             Source Root Node
     *                  Folder Node
     *                       Schema File Node
     *                            Usage Node
     *
     *
     * @param queryComponent the Component that is the query target
     * @param  buildTreeModel build a CheckNode tree model for the explorer view
     * @param  isPrimitive  is the query component a primitive type
     * @param  model  the Model of this Multiview's schema file
     *
     */
    public Object[] loadGraph(FindUsageResult fuResult,
            Referenceable queryComponent,
            boolean buildTreeModel,
            boolean isPrimitive,
            Model model) 
    {
        if (fuResult == null) {
            return new Object[0];
        }
        
        List<Component> componentsInGraph = new ArrayList<Component>();
        int fileGroupNumber = 0;
        int usagesCount = 0;
//        System.out.println("loadGraph start " + start);// Get current time
        
        Graph graph = new Graph(true);        // isDirected
        graph.getNodeTable().addColumns(FIND_USAGES_NODES_SCHEMA);
        graph.getEdgeTable().addColumns(FIND_USAGES_EDGES_SCHEMA);
        
        
        // Get collection of nodes where the global is used
//        FindUsageVisitor usage = new FindUsageVisitor();
//        Preview preview = null;
        
        // **********************************************
        //    IF BUILD TREE MODEL - START
        // **********************************************
        DefaultTreeModel treeModel = null;
        if (buildTreeModel){
            treeModel = new DefaultTreeModel(
                new CheckNode(AnalysisUtilities.getName(queryComponent), FIND_USAGES_ICON));
        }   // end if buildTreeModel
        // **********************************************
        //    IF BUILD TREE MODEL - END
        // **********************************************
        
        
        // get usages for the current schema file
        // get project from SC
        // Get source roots in project
        // for each treeModelRoot, get schema model
        // find usages in each model
        //  - create file node
        //  - hide nodes from other files
        
        UsageSet usageSet = null;
        try {
            usageSet = fuResult.get();
        } catch (InterruptedException ex) {
            ErrorManager.getDefault().notify(ex);
        } catch (ExecutionException ex) {
            ErrorManager.getDefault().notify(ex);
        }
        
        Node queryNode =  createQueryNode(graph,
                queryComponent,
                getUIHelper(queryComponent),
                false,
                componentsInGraph,
                false,
                fileGroupNumber);
        
        //  Map of SourceGroups and their packages
        Map<SourceGroup, Map<FileObject,Set<UsageGroup>>> sortedUses =
                usageSet.getSortedUsages();
        Set<Entry<SourceGroup,Map<FileObject,Set<UsageGroup>>>> sgUses =
                sortedUses.entrySet();
        LogicalViewProvider viewProvider = null;
        Project project = null;
        CheckNode projectNode = null;
        for (Entry<SourceGroup, Map<FileObject, Set<UsageGroup>>> sgUse:sgUses){
            Set<Entry<FileObject,Set<UsageGroup>>> pkgUses = sgUse.getValue().entrySet();
            for (Entry<FileObject, Set<UsageGroup>> pkgUse:pkgUses){
                Set<UsageGroup> usages = pkgUse.getValue();
                for (UsageGroup usage:usages){
                    int count =  usage.getItems().size();
                    if (count < 1){
                        continue;
                    }
                    usagesCount += count;
                    addUsagesToGraph(
                            usage,
                            graph,
                            isPrimitive,
                            componentsInGraph,
                            queryComponent,
                            queryNode,
                            ++fileGroupNumber);
                    if (buildTreeModel){
                        addUsagesToTreeModel(usage, treeModel);
                    }
                }
            }
        }
        
        if (buildTreeModel){
            ((CheckNode)treeModel.getRoot()).setLabel(
                    createRootTreeNodeLabel(
                AnalysisUtilities.getName(queryComponent), usagesCount));
        }
        if (usagesCount == 1) {
            StatusDisplayer.getDefault().setStatusText(
                    MessageFormat.format(NbBundle.getMessage(
                    WhereUsedReader.class,
                    "LBL_Usage_Found"),
                    new Object[] {
                queryNode.getString(AnalysisConstants.LABEL)
            }
            ));
        } else {
            StatusDisplayer.getDefault().setStatusText(
                    MessageFormat.format(NbBundle.getMessage(
                    WhereUsedReader.class,
                    "LBL_Usages_Found"),
                    new Object[] {Integer.valueOf(usagesCount),
                    queryNode.getString(AnalysisConstants.LABEL)
            }
            ));
        }
        
//        GraphUtilities.dumpGraph(graph);
        
        return new Object[] {graph, treeModel};
        
    }

    private static UIHelper getUIHelper(Referenceable component) {
        return RefactoringManager.getInstance().getTargetComponentUIHelper(component);
    }
    
    private static String createRootTreeNodeLabel(String name, int usagesCount){
        
        String description = MessageFormat.format(NbBundle.getMessage(
                WhereUsedReader.class,
                "DSC_WhereUsed"),
                new Object[] {name} );
        
        StringBuilder desc = new StringBuilder(" [" + usagesCount); // NOI18N
        desc.append(' ');
        desc.append(usagesCount == 1 ?
            NbBundle.getMessage(WhereUsedReader.class, "LBL_Occurrence") :
            NbBundle.getMessage(WhereUsedReader.class, "LBL_Occurrences")
            );
        desc.append(']');
        return description + desc.toString();
    }
    
    
    /**
     *
     * Get usages in one schema file
     * @param  usage collection of Items found in one model
     * @param  graph the prefuse Graph
     * @param  isPrimitive  is the query component a primitive type
     * @param  componentsInGraph the list of SchemaComponents that are already in the graph
     * @param  queryComponent the query component
     * @param  queryNode prefuse node representing queryComponent
     * @param  fileGroupNumber  number of fileGrp
     *
     */
    private void addUsagesToGraph(
            UsageGroup usage,
            Graph graph,
            boolean isPrimitive,
            List<Component> componentsInGraph,
            Referenceable queryComponent,
            Node queryNode,
            int fileGroupNumber) {
//        Map<Component, List<Component>> um =
        Collection<Usage> items = usage.getItems();
        UIHelper uiHelper = usage.getEngine().getUIHelper();
        
        // *****************************
        // *** FILE NODE
        // *****************************
        // create file node and attach it to the query node
        Node fileNode = createFileNode(graph,
                queryComponent,
                (FileObject)usage.getModel().getModelSource().getLookup().lookup(FileObject.class),
                queryNode,
                fileGroupNumber);
        
        // create a special edge from the file node to the query node
        //  that will be visible when the file node is collapsed
        //  This edge uses the default prefuse renderer, e.g.,
        //    a small solid arrow head
        //  When the file node is expanded, this edge will be
        //  hidden.  See FindUsagesFocusControl (double click)
        Edge fileEdge = graph.addEdge(fileNode,queryNode);
        fileEdge.setString(AnalysisConstants.EDGE_TYPE,
                AnalysisConstants.FILE_EDGE_TYPE);
        fileEdge.setInt(AnalysisConstants.FILE_GROUP,
                fileGroupNumber);
        
        for (Usage item:items){
            
            List<Component> aPath = uiHelper.getRelevantPathFromRoot(item.getComponent());
            Node parent = fileNode;
            // if queryComponent is primitive skip the top level (schema)element
            int i = isPrimitive?1:0;
            for (; i < aPath.size();i++){
                Component sc = aPath.get(i);
                Node pn = null;
                
                if (componentsInGraph.contains(sc)){
                    // there's already a Node for this Component,
                    //    find it in Graph
                    pn = findDup(graph, sc);
                    assert pn != null:"Cannot find Node for Component "
                            +
                            sc; //NOI18N
                }
                
                if (pn == null){
                    pn = createNode(graph,
                            sc,
                            uiHelper,
                            isPrimitive,
                            componentsInGraph,
                            queryComponent,
                            fileGroupNumber);
                }
                
                AnalysisUtilities.ToolTipLine topLine = null;
                 // Usage node is last
                if (i == aPath.size()-1){
                    pn.setBoolean(AnalysisConstants.IS_USAGE_NODE, true);
                    
                    topLine = new AnalysisUtilities.ToolTipLine((
                            MessageFormat.format(NbBundle.getMessage(
                            WhereUsedReader.class, "LBL_Uses_Component"),
                            new Object[] {queryNode.getString(
                                    AnalysisConstants.LABEL) })),
                            100,
                            Color.BLACK.getRGB(),
                            AnalysisUtilities.ToolTipLine.
                            HorizontalAlignment.CENTER);
                    // Connect this usage node to the Query Node
                    // with the appropriate edge (composition or reference)
                    addApppropriateEdge(graph,
                            pn,
                            queryNode,
                            fileGroupNumber,
                            item.getType());
                    
                }// END if (i == aPath.size()-1)
                
               AnalysisUtilities.ToolTipLine typeLine =
                        new AnalysisUtilities.ToolTipLine(getCompTypeDisplayName(pn),
                        100,
                        Color.BLACK.getRGB(),
                        AnalysisUtilities.ToolTipLine.
                        HorizontalAlignment.CENTER);
                String toolTip = AnalysisUtilities.createHTMLToolTip(
                        new AnalysisUtilities.ToolTipLine[] {topLine, typeLine});
                pn.setString(AnalysisConstants.TOOLTIP, toolTip);
                
                
                // connect it to its parent
                addApppropriateEdge(graph,
                        pn,
                        parent,
                        fileGroupNumber,
                        null);
                parent = pn;
                
                
            }
        }
        
    }
    
    /**
     *
     *  Get usages in one schema file
     *  Project
     *    Source Group
     *      Folder
     *        File1
     *           ParentComp1
     *             Usage1
     *             Usage2
     *           ParentComp2
     *             ParentComp3
     *                 Usage3
     *                 Usage4
     *        SubFolder
     *             File3
     *                Usage6
     *        File2
     *           ParentComp4
     *             Usage5
     *
     */
    private void addUsagesToTreeModel(UsageGroup usageGroup, DefaultTreeModel treeModel) {
        assert usageGroup != null:"usageGroup cannot be null";
        CheckNode fileTreeNode = createFileTreeNode(usageGroup.getFileObject(),treeModel);
        Map<Component,CheckNode> componentsInModel =
                new HashMap<Component,CheckNode>();
        
        UIHelper uiHelper = usageGroup.getEngine().getUIHelper();
        org.openide.nodes.Node helperNode = null;
        Collection<Usage> items = usageGroup.getItems();
        for (Usage item:items){
            List<Component> aPath =  uiHelper.getRelevantPathFromRoot(item.getComponent());// item.getPathFromRoot();
            assert aPath.size() > 0:
                "There should be at least a usage component";//NOI18N
            for (int i = 0; i< aPath.size(); i++)  {
                Component comp = aPath.get(i);
                helperNode = uiHelper.getDisplayNode(comp);
                CheckNode node = null;
                if (componentsInModel.containsKey(comp)) {
                    node = componentsInModel.get(comp);
                } else {
                    if (comp == item.getComponent()) {
                        node = new CheckNode(item, helperNode);
                    } else {
                        node = new CheckNode(comp, helperNode);
                    }
                    componentsInModel.put(comp, node);
                }
                if (i==0){
                    // the first Component in the path is a child of the file node
                    fileTreeNode.add(node);
                } else {
                    CheckNode parentNode =null;
                    Component parent = aPath.get(i-1);
                    parentNode = componentsInModel.get(Component.class.cast(parent));
                    assert parentNode != null:"The relevantPath is invalid";
                    parentNode.add(node);
                }
                if (i == aPath.size()-1){
                    // this is the usage node
                    String htmlDisplayName = helperNode.getHtmlDisplayName();
                    String usageTreeNodeLabel =
                            MessageFormat.format(
                            NbBundle.getMessage(
                            WhereUsedReader.class,
                            "LBL_Usage_Node"),
                            new Object[] {
                        helperNode.getName(),
                        helperNode.getShortDescription(),  // comp type
                        htmlDisplayName==null?AnalysisConstants.EMPTY_STRING:htmlDisplayName
                    });
                    node.setLabel(usageTreeNodeLabel);
                }
            }
        }
    }
    
    private static String getCompTypeDisplayName(final Node pn) {
        String compType = null;
        if (pn.canGetBoolean(AnalysisConstants.IS_PRIMITIVE) &&
                pn.getBoolean(AnalysisConstants.IS_PRIMITIVE)){
            compType = NbBundle.getMessage(WhereUsedReader.class,
                    "LBL_Primitive_Type");
        } else {
            compType = pn.getString(AnalysisConstants.COMPONENT_TYPE_NAME);
        }
        return compType;
    }
    
    /**
     * Adds a Reference edge or Generalization edge from
     * "from" node to the queryNode
     * or adds composition edge if edgeType is null
     *
     */
    private static void addApppropriateEdge(Graph graph, Node from, Node queryNode,
            int fileGroupNumber, Usage.Type edgeType){
        Edge edge = graph.addEdge(from, queryNode);
//        edge.setBoolean(AnalysisConstants.SHOW, isVisible);
        edge.setInt(AnalysisConstants.FILE_GROUP, Integer.valueOf(fileGroupNumber));
        if ( edgeType == Usage.Type.GENERALIZATION){
            edge.setString(AnalysisConstants.EDGE_TYPE, AnalysisConstants.GENERALIZATION);
        } else if ( edgeType == Usage.Type.REFERENCE){
            edge.setString(AnalysisConstants.EDGE_TYPE,
                    AnalysisConstants.REFERENCE);
            from.setString(AnalysisConstants.LABEL,
                    MessageFormat.format(NbBundle.getMessage(
                    WhereUsedReader.class,
                    "LBL_References_Ref"),
                    new Object[]
            {queryNode.getString(AnalysisConstants.LABEL)}));
        } else {
            edge.setString(AnalysisConstants.EDGE_TYPE, AnalysisConstants.COMPOSITION);
        }
    }
    
    private static Node findDup(Graph graph, Component sc){
        Iterator it = graph.nodes();
        while (it.hasNext()){
            Node n= Node.class.cast(it.next());
            Object nodeSC = n.get(AnalysisConstants.XAM_COMPONENT);
            if ((n.canGetBoolean(AnalysisConstants.IS_FILE_NODE) &&
                    n.getBoolean(AnalysisConstants.IS_FILE_NODE) == false)
                    && nodeSC != null){
                if (nodeSC == sc){
                    return n;
                }
            }
        }
        return null;
    }
    
    private static Node createQueryNode(Graph graph,
            Referenceable query,
            UIHelper uiHelper,
            boolean isPrimitive,
            List<Component> componentsInGraph,
            boolean showOnlyDerivations,
            int fileGroupNumber
            ) {
        //  TODO remove this temporary hack when UIHelper for query Component is available
        Node queryNode = null;
        Component queryComponent = null;
        if (query instanceof Component) {
            queryComponent = (Component) query;
        } else {
            if (query instanceof DocumentModel) {
                queryComponent = ((DocumentModel) query).getRootComponent();
            }
        }
        if (uiHelper == null){
            String name = "";   //NOI18N
            if (query instanceof Named){
                name = ((Named)Named.class.cast(query)).getName();
            }
            queryNode = graph.addNode();
            //componentsInGraph.add(queryComponent);
            queryNode.setBoolean(AnalysisConstants.IS_PRIMITIVE, isPrimitive);
            queryNode.setString(AnalysisConstants.LABEL, name);
            queryNode.setString(AnalysisConstants.COMPONENT_TYPE_NAME, "" ); //NOI18N
            queryNode.set(AnalysisConstants.XAM_COMPONENT, query  );
            queryNode.setInt(AnalysisConstants.FILE_GROUP, fileGroupNumber);
            
        } else {
            queryNode = createNode(graph, queryComponent, uiHelper, isPrimitive, componentsInGraph, query, fileGroupNumber);
        }
        
        queryNode.setBoolean(AnalysisConstants.IS_QUERY_NODE, true);
        // unset the FILE_GROUP because this node is always visible
        queryNode.setInt(AnalysisConstants.FILE_GROUP,-1);
        // reset IS_PRIMITIVE in case it is
        queryNode.setBoolean(AnalysisConstants.IS_PRIMITIVE, isPrimitive);
        
        AnalysisUtilities.ToolTipLine topLine = new AnalysisUtilities.ToolTipLine((
                showOnlyDerivations?
                    NbBundle.getMessage(WhereUsedReader.class,
                "LBL_Base_Complex_Type"):
                    NbBundle.getMessage(WhereUsedReader.class,
                "LBL_Query_Component")),
                100,
                Color.BLACK.getRGB(),
                AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
        String compType = getCompTypeDisplayName(queryNode);
        AnalysisUtilities.ToolTipLine typeLine = new AnalysisUtilities.ToolTipLine(
                compType,
                100,
                Color.BLACK.getRGB(),
                AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
        String toolTip = AnalysisUtilities.createHTMLToolTip(new AnalysisUtilities.ToolTipLine[] {
            topLine, typeLine});
        
        queryNode.setString(AnalysisConstants.TOOLTIP, toolTip);
        return queryNode;
    }
    
    
    private static Node createFileNode(Graph graph, Referenceable queryComp,
            FileObject fobj, Node queryNode, int fileGroupNumber){
        if (queryComp == null || fobj == null){
            return null;
        }
        String fileType = AnalysisUtilities.getXmlFileType(fobj);
        Node n = graph.addNode();
        n.setString(AnalysisConstants.FILE_TYPE,fileType);
        n.setInt(AnalysisConstants.FILE_NODE_FILE_GROUP, fileGroupNumber);
        n.setBoolean(AnalysisConstants.IS_EXPANDED, false);
        n.setBoolean(AnalysisConstants.IS_FILE_NODE, true);
        n.set(AnalysisConstants.JAVA_AWT_IMAGE, AnalysisUtilities.getImage(fobj));
        if (fobj != null){
            n.setString(
                    AnalysisConstants.LABEL, fobj.getName()+"."+fobj.getExt());  // NOI18N
            n.setString(
                    AnalysisConstants.XML_FILENAME,
                    fobj.getName()+"."+fobj.getExt());  // NOI18N
            n.set(AnalysisConstants.FILE_OBJECT, fobj);
            
            // "Schema file containing usages of XYZ"
            AnalysisUtilities.ToolTipLine topLine = new AnalysisUtilities.ToolTipLine(
                    MessageFormat.format(
                    NbBundle.getMessage(WhereUsedReader.class,
                    "LBL_Xml_File_With_Usages"),new Object[]{
                AnalysisUtilities.getXmlFileTypeDisplayName(fileType),
                queryNode.getString(AnalysisConstants.LABEL)}),
                    100,
                    Color.BLACK.getRGB(),
                    AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
            AnalysisUtilities.ToolTipLine typeLine =
                    new AnalysisUtilities.ToolTipLine(
                    FileUtil.getFileDisplayName(fobj),
                    100,
                    Color.BLACK.getRGB(),
                    AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
            String toolTip = AnalysisUtilities.createHTMLToolTip(
                    new AnalysisUtilities.ToolTipLine[] {topLine, typeLine});
            
            n.setString(AnalysisConstants.TOOLTIP,
                    toolTip);
        }
        return n;
    }
    /**
     *
     *
     */
    private static Node createNode(Graph graph,
            Component comp,
            UIHelper uiHelper,
            boolean isPrimitive,
            List<Component> componentsInGraph,
            Referenceable queryComponent,
            int fileGroupNumber
            ){
        Node n = graph.addNode();
        if (componentsInGraph != null){
            componentsInGraph.add(comp);
        }
//        DisplayInfo dInfo = div.getDisplayInfo(comp);
        org.openide.nodes.Node displayNode = uiHelper.getDisplayNode(comp);
        
        // if the queryComponent node is a primitive,
        // check if the usage node is also a primitive, i.e.,
        // from the same model (the W3c Schema model)
        if (isPrimitive){
            if (comp.getModel() ==
                    ((Component) queryComponent).getModel()) {
                n.setBoolean(AnalysisConstants.IS_PRIMITIVE, true);
            }
        }
        n.setBoolean(AnalysisConstants.IS_PRIMITIVE, false);
        n.setString(AnalysisConstants.LABEL, displayNode.getName());
        n.setString(AnalysisConstants.COMPONENT_TYPE_NAME, displayNode.getShortDescription() );
        n.set(AnalysisConstants.XAM_COMPONENT, comp  );
        n.set(AnalysisConstants.OPENIDE_NODE, displayNode  );
        n.setInt(AnalysisConstants.FILE_GROUP, fileGroupNumber);
        n.set(AnalysisConstants.JAVA_AWT_IMAGE, displayNode.getIcon(BeanInfo.ICON_COLOR_16x16));
        
        return n;
    }
    
      
    /**
     *  Create a tree model and a graph that contain only the
     *    target Component
     *
     *
     */
    public static Object[] createDeletePreviewModels(NamedReferenceable target){
        Object[] models = null;
        // create prefuse graph with target as only node
        Graph graph = new Graph(true);
        graph.getNodeTable().addColumns(WhereUsedReader.FIND_USAGES_NODES_SCHEMA);
        graph.getEdgeTable().addColumns(WhereUsedReader.FIND_USAGES_EDGES_SCHEMA);
        createQueryNode(
                graph,
                target,
                getUIHelper(target),
                false,  // is primitive
                null,  // components in graph - empty
                false,  // show only derivations
                0);     // file group number
 
        CheckNode root = new CheckNode(target.getName(),FIND_USAGES_ICON);
        
        models = new Object[] {graph, new DefaultTreeModel(root)};
        insertTargetComponent(target, models, NbBundle.getMessage(WhereUsedReader.class, "LBL_Delete"));
        return models;
    }
    
    /**
     *  Insert nodes for the target component  into the usages Tree Model
     * @param ref the target to insert
     * @param models an array containing the prefuse graph and a DefaultTreeModel
     * @param nodeLabel "Delete" or "Rename"
     *
     */
    public static Object[] insertTargetComponent(Referenceable ref, Object[] models, String nodeLabel){
        assert (ref instanceof Named) || (ref instanceof Model) :
            "Target is not NamedComponent or DocumentModel";
        //  don't do anything with the graph
        DefaultTreeModel treeModel = null;
        for (Object obj:models){
            if (obj instanceof DefaultTreeModel){
                treeModel = DefaultTreeModel.class.cast(obj);
            }
        }
        assert treeModel != null:"There is no tree model";

        CheckNode targetNode = AnalysisUtilities.findCheckNode(treeModel, ref);
        if (targetNode == null){
            Component targetComponent = ref instanceof Component ? (Component) ref :
                ref instanceof DocumentModel ? ((DocumentModel) ref).getRootComponent() :null;
            assert targetComponent != null : "target is not Component or DocumentModel";
            FileObject targetFobj = AnalysisUtilities.getFileObject(targetComponent);
            CheckNode targetFileNode = createFileTreeNode(targetFobj, treeModel);
            
            UIHelper helper = RefactoringManager.getInstance().getTargetComponentUIHelper(ref);
            if (helper == null){
                helper = new UIHelper();
            }
            org.openide.nodes.Node displayNode = AnalysisUtilities.getDisplayNode(ref); 
            String name = AnalysisUtilities.getName(ref); 
            targetNode = new CheckNode(ref, displayNode);
            targetNode.setLabel(nodeLabel + " <b>" + name + "</b>");
            targetFileNode.add(targetNode);
        }
        targetNode.setCheckEnabled(false);
        
        return models;
    }

    private static CheckNode createFileTreeNode(FileObject targetFobj, DefaultTreeModel treeModel) {
        CheckNode root = (CheckNode)treeModel.getRoot();
        assert root != null:"There is no root in the tree model";
        CheckNode targetFileNode = null;
        DataObject dobj = null;
        try {
            dobj = DataObject.find(targetFobj);
        } catch (DataObjectNotFoundException ex) {
        }
        assert dobj != null:"No data object found for "+targetFobj;
        Project project = FileOwnerQuery.getOwner(targetFobj);
        
        if (project == null) {
            CheckNode ret = new CheckNode(dobj.getPrimaryFile(), dobj.getNodeDelegate());
            root.add(ret);
            return ret;
        }
        
        LogicalViewProvider viewProvider = (LogicalViewProvider)project.
                getLookup().lookup(LogicalViewProvider.class);
        
        CheckNode projectNode = AnalysisUtilities.findCheckNode(treeModel,project);
        if(projectNode==null) {
            projectNode = new CheckNode(project,viewProvider.createLogicalView());
            root.add(projectNode);
        }
        
        org.openide.nodes.Node projNode = projectNode.getOrigNode();
        org.openide.nodes.Node logicalNode = viewProvider.findPath(projNode, targetFobj);
        if(logicalNode==null) {
            logicalNode = viewProvider.findPath(projNode, dobj);
        }
        if(logicalNode!=null) {
            List<org.openide.nodes.Node> path = 
                    new ArrayList<org.openide.nodes.Node>();
            org.openide.nodes.Node parent = logicalNode;
            path.add(logicalNode);
            while((parent=parent.getParentNode())!=null)
                path.add(0,parent);
            assert path.remove(0) == projNode:"given fobj must be under project";
            CheckNode parentNode = projectNode;
            for(org.openide.nodes.Node node:path) {
                DataObject o = (DataObject) node.getLookup().lookup(DataObject.class);
                if (o == null) continue;
                targetFileNode = AnalysisUtilities.findCheckNode(treeModel, o.getPrimaryFile());
                if(targetFileNode==null) {
                    targetFileNode = new CheckNode(o.getPrimaryFile(), node);
                    parentNode.add(targetFileNode);
                }
                parentNode = targetFileNode;
            }
        } else {
            targetFileNode = new CheckNode(dobj.getPrimaryFile(), dobj.getNodeDelegate());
            projectNode.add(targetFileNode);
        }
        return targetFileNode;
    }
  
}
