/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring.ui.j.ui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.*;
import java.util.concurrent.ExecutionException;
//import javax.jmi.reflect.RefObject;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.nbprefuse.View;
import org.netbeans.modules.xml.refactoring.DeleteRequest;
import org.netbeans.modules.xml.refactoring.FindUsageResult;
import org.netbeans.modules.xml.refactoring.RefactoringManager;
import org.netbeans.modules.xml.refactoring.RenameRequest;
import org.netbeans.modules.xml.refactoring.Usage;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.netbeans.modules.xml.refactoring.RefactorRequest;
import org.netbeans.modules.xml.refactoring.UsageSet;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.refactoring.FileRenameRequest;
import org.netbeans.modules.xml.refactoring.ui.j.api.ProgressEvent;
import org.netbeans.modules.xml.refactoring.ui.j.api.ProgressListener;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.ParametersPanel;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.RefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.WhereUsedQueryUI;
import org.netbeans.modules.xml.refactoring.ui.readers.WhereUsedReader;
import org.netbeans.modules.xml.refactoring.ui.util.AnalysisUtilities;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.nodes.NodeListener;
import prefuse.data.Graph;


/**
 * Panel for showing proposed changes (refactoring elements) of any refactoring.
 *
 * @author  Pavel Flaska, Martin Matula
 * @author  Jeri Lockhart
 */
//public class RefactoringPanel extends JPanel implements InvalidationListener {
public class RefactoringPanel extends JPanel  implements TreeSelectionListener,
        PropertyChangeListener, NodeListener, ComponentListener {
    public static final long serialVersionUID = 1L;
    
    // PRIVATE FIELDS
    /* tree contains elements which will be changed by refactoring action */
    private transient JTree tree = null;
    
    private transient DefaultTreeModel treeModel = null;
    /* toolbar button causing refresh of the data */
    private transient JButton refreshButton = null;
    /* button lying in the toolbar allows expansion of all nodes in a tree */
    private transient JToggleButton expandButton = null;
    private JToolBar toolBar = null;
    
    private transient JButton refactorButton = null;
    private transient JButton cancelButton = null;
    private transient ButtonL buttonListener = null;
    private transient JButton rerunButton = null;
    
    private final RefactoringUI ui;
    private final boolean isQuery;
    
    private transient boolean isVisible = false;
//    private transient RefactoringSession session = null;
    private transient ParametersPanel parametersPanel = null;
    private javax.swing.JSplitPane splitPane;
    private transient JScrollPane treeScrollPane = null;
    private transient JPanel southPanel;
    private Action callback = null;
    
    private static final int MAX_ROWS = 50;
    
    private transient JToggleButton logicalViewButton = null;
    private transient JToggleButton physicalViewButton = null;
    private transient ProgressListener progressListener;
    
    private transient JButton prevMatch = null;
    private transient JButton nextMatch = null;
    private WeakReference refCallerTC;
    
    private AnalysisViewer analysisViewer;
    
    public static final String
            NODE_SELECTION_CHANGE = "node-selection-change"; // NOI18N  fire
    
    private transient Cancellable cancellableFindUsagesTask;
    ParametersPanel.Results results;
     
    public RefactoringPanel(RefactoringUI ui) {
        this(ui, (TopComponent) null);
    }
    
    public RefactoringPanel(RefactoringUI ui, TopComponent caller) {
        this(ui, caller, null);
    }
    
    @SuppressWarnings("unchecked")
    public RefactoringPanel(RefactoringUI ui, TopComponent caller, Action callback) {
        if (caller!=null)
            refCallerTC = new WeakReference(caller);
        this.ui = ui;
        this.isQuery = ui.isQuery();
        this.callback = callback;
        initialize();
        addListeners();
        boolean skipsParameters = (ui instanceof WhereUsedQueryUI) || 
            ui.getRefactorRequest() != null && ui.getRefactorRequest().getUsages() != null;
        refresh(! skipsParameters);
    }
    
    public RefactoringPanel(RefactoringUI ui, Action callback) {
        this(ui, null, callback);
    }
    
    private void addListeners() {
        addDataOjectNodeListener();
        addComponentListener();
    }
    
    private void addComponentListener() {
        if (ui.getTarget() instanceof DocumentComponent) {
            DocumentComponent target = (DocumentComponent) ui.getTarget();
            if (target.getParent() != null) {
                target.getModel().addComponentListener( (ComponentListener)
                    WeakListeners.create(ComponentListener.class, this, target.getModel()));
            }
        }
    }
    
    private void addDataOjectNodeListener() {
        Model targetModel = RefactorRequest.getModel(ui.getTarget());
        assert targetModel != null : "null target model";
        DataObject dobj = (DataObject) targetModel.getModelSource().getLookup().lookup(DataObject.class);
        assert dobj != null : "model source lookup has no data object";
        Node node = dobj.getNodeDelegate();
        node.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, this, node));
    }
    
    public static void checkEventThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL,
                    new IllegalStateException(
                    "This must happen in event thread!")); //NOI18N
        }
    }
    
    /* initializes all the ui */
    private void initialize() {
        checkEventThread();
        setFocusCycleRoot(true);
        setLayout(new BorderLayout());
        // add panel with buttons
        JButton[] buttons = getButtons();
        //if (buttons.length != 0) {
        // there will be at least one button on panel
        southPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < buttons.length; i++) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.insets = new Insets(5, 5, 5, 0);
            southPanel.add(buttons[i], c);
        }
        JPanel pp = new JPanel(new BorderLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1;
        c.fill = c.HORIZONTAL;
        southPanel.add(pp, c);
        
        if (!isQuery|| callback != null) {
            add(southPanel, BorderLayout.SOUTH);
        }
        //}
        // put the toolbar to the panel. If the getToolBar() returns null,
        // suppose the toolbar does not exist.
        JToolBar toolBar = getToolBar();
        if (toolBar != null)
            add(toolBar, BorderLayout.WEST);
        
//        if (isQuery){
        analysisViewer = new AnalysisViewer();
        analysisViewer.addPropertyChangeListener(
                AnalysisViewer.PROP_GRAPH_NODE_SELECTION_CHANGED_RELAY,this);
        analysisViewer.getPanel().setMinimumSize(new Dimension(10,10));
        analysisViewer.getPanel().setPreferredSize(new Dimension(10,10));
        splitPane = new javax.swing.JSplitPane();
        //displayPanel = new javax.swing.JPanel(); - get from View
        add(splitPane, BorderLayout.CENTER);
        splitPane.setRightComponent(analysisViewer.getPanel());
        splitPane.setLeftComponent(new JLabel(""));// NOI18N
        splitPane.setResizeWeight(0.5); // halfway
//        }
        
        validate();
    }
    
    /**
     * Returns the toolbar. In this default implementation, toolbar is
     * oriented vertically in the west and contains 'expand tree' toggle
     * button and refresh button.
     * Override this method and return null if you do not want toolbar
     * in your panel.
     *
     * @return  toolBar with actions for refactoring panel
     */
    private JToolBar getToolBar() {
        checkEventThread();
        refreshButton = new JButton(
                new ImageIcon(Utilities.loadImage(
                "org/netbeans/modules/refactoring/resources/refresh.png")) // NOI18N
                );
        Dimension dim = new Dimension(24, 24);
        refreshButton.setMaximumSize(dim);
        refreshButton.setMinimumSize(dim);
        refreshButton.setPreferredSize(dim);
        refreshButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, "HINT_refresh") // NOI18N
        );
        refreshButton.setMnemonic(
            NbBundle.getMessage(RefactoringPanel.class, "MNEM_refresh").charAt(0)
        );
        refreshButton.addActionListener(getButtonListener());
        // expand button settings
        expandButton = new JToggleButton(
                new ImageIcon(Utilities.loadImage(
                "org/netbeans/modules/refactoring/resources/expandTree.png")) // NOI18N
                );
        expandButton.setSelectedIcon(
                new ImageIcon(Utilities.loadImage(
                "org/netbeans/modules/refactoring/resources/colapseTree.png")) // NOI18N
                );
        expandButton.setMaximumSize(dim);
        expandButton.setMinimumSize(dim);
        expandButton.setPreferredSize(dim);
        expandButton.setSelected(true);
        expandButton.setToolTipText(
                NbBundle.getMessage(RefactoringPanel.class, "HINT_expandAll") // NOI18N
                );
        expandButton.setMnemonic(
            NbBundle.getMessage(RefactoringPanel.class, "MNEM_expandAll").charAt(0) // NOI18N
        );
        expandButton.addActionListener(getButtonListener());
        // create toolbar
        toolBar = new JToolBar(JToolBar.VERTICAL);
        toolBar.setFloatable(false);
        
        logicalViewButton = new JToggleButton(
                new ImageIcon(Utilities.loadImage(
                "org/netbeans/modules/refactoring/resources/logical_view.png")) // NOI18N
                );
        
        logicalViewButton.setMaximumSize(dim);
        logicalViewButton.setMinimumSize(dim);
        logicalViewButton.setPreferredSize(dim);
        logicalViewButton.setSelected(true);
        logicalViewButton.setToolTipText(
                NbBundle.getMessage(RefactoringPanel.class, "HINT_logicalView") // NOI18N
                );
        
        logicalViewButton.setMnemonic(
            NbBundle.getMessage(RefactoringPanel.class, "MNEM_logicalView").charAt(0) // NOI18N
        );
        logicalViewButton.addActionListener(getButtonListener());
        
        physicalViewButton = new JToggleButton(
                new ImageIcon(Utilities.loadImage(
                "org/netbeans/modules/refactoring/resources/file_view.png")) // NOI18N
                );
        
        physicalViewButton.setMaximumSize(dim);
        physicalViewButton.setMinimumSize(dim);
        physicalViewButton.setPreferredSize(dim);
        physicalViewButton.setToolTipText(
                NbBundle.getMessage(RefactoringPanel.class, "HINT_physicalView") // NOI18N
                );
        physicalViewButton.setMnemonic(
            NbBundle.getMessage(RefactoringPanel.class, "MNEM_physicalView").charAt(0) // NOI18N
        );
        physicalViewButton.addActionListener(getButtonListener());
        
        // TODO enable physical view button
        physicalViewButton.setEnabled(false);
        
        nextMatch = new JButton(
                new ImageIcon(Utilities.loadImage(
                "org/netbeans/modules/refactoring/resources/nextmatch.png")) // NOI18N
                );
        
        nextMatch.setMaximumSize(dim);
        nextMatch.setMinimumSize(dim);
        nextMatch.setPreferredSize(dim);
        nextMatch.setToolTipText(
                NbBundle.getMessage(RefactoringPanel.class, "HINT_nextMatch") // NOI18N
                );
        nextMatch.addActionListener(getButtonListener());
        
        prevMatch = new JButton(
                new ImageIcon(Utilities.loadImage(
                "org/netbeans/modules/refactoring/resources/prevmatch.png")) // NOI18N
                );
        
        prevMatch.setMaximumSize(dim);
        prevMatch.setMinimumSize(dim);
        prevMatch.setPreferredSize(dim);
        prevMatch.setToolTipText(
                NbBundle.getMessage(RefactoringPanel.class, "HINT_prevMatch") // NOI18N
                );
        prevMatch.addActionListener(getButtonListener());
        
        toolBar.add(refreshButton);
        toolBar.add(expandButton);
        toolBar.add(logicalViewButton);
        toolBar.add(physicalViewButton);
        toolBar.add(prevMatch);
        toolBar.add(nextMatch);
        
        return toolBar;
    }
    
    /**
     * Returns array of available buttons. Initially, it returns only
     * basic "do refactoring/cancel refactoring" button. Override this method,
     * if you want to provide any other buttons with different action to be
     * performed.
     *
     * @return  array of avasilable buttons.
     */
    private JButton[] getButtons() {
        checkEventThread();
        if (isQuery) {
            refactorButton = null;
            if (callback==null) {
                return new JButton[] {};
            } else {
                rerunButton = new JButton((String) callback.getValue(
                        callback.NAME)); // NOI18N
                rerunButton.addActionListener(getButtonListener());
                return new JButton[] {rerunButton};
            }
        } else {
            refactorButton = new JButton(NbBundle.getMessage(
                    RefactoringPanel.class, "LBL_DoRefactor")); // NOI18N
            refactorButton.setToolTipText(NbBundle.getMessage(
                    RefactoringPanel.class, "HINT_DoRefactor")); // NOI18N
            Mnemonics.setLocalizedText(refactorButton, NbBundle.getMessage(
                    RefactoringPanel.class, "LBL_DoRefactor"));
            refactorButton.addActionListener(getButtonListener());
            cancelButton = new JButton(NbBundle.getMessage(
                    RefactoringPanel.class, "LBL_CancelRefactor")); // NOI18N
            Mnemonics.setLocalizedText(cancelButton,NbBundle.getMessage(
                    RefactoringPanel.class, "LBL_CancelRefactor"));
            cancelButton.setToolTipText(NbBundle.getMessage(
                    RefactoringPanel.class, "HINT_CancelRefactor")); // NOI18N
            cancelButton.addActionListener(getButtonListener());
            return new JButton[] {refactorButton, cancelButton};
        }
    }
    
    private static final byte LOGICAL = 0;
    private static final byte PHYSICAL = 1;
    
    private byte currentView = LOGICAL;
    
    void switchToLogicalView() {
        logicalViewButton.setSelected(true);
        if (currentView == LOGICAL)
            return ;
        currentView = LOGICAL;
        physicalViewButton.setSelected(false);
        refresh(false);
    }
    
    void switchToPhysicalView() {
        physicalViewButton.setSelected(true);
        if (currentView == PHYSICAL)
            return ;
        currentView = PHYSICAL;
        logicalViewButton.setSelected(false);
        refresh(false);
    }
    
    /**
     * Overrides default ExplorerPanel behaviour. Does nothing now.
     */
    protected void updateTitle() {
    }
    
    /**
     * Method is responsible for making changes in sources.
     */
    private void refactor() {
        checkEventThread();
        disableComponents(RefactoringPanel.this);
        progressListener = new ProgressL();
        final ProgressEvent progressEvent = new ProgressEvent(this,0, 0, -1);
        RequestProcessor.getDefault().post(new Runnable() {
            public void run() {
                try {
                    // TODO need progress component
                    progressListener.start(progressEvent);
                    RefactoringManager.getInstance().process(results.getRefactorRequest());
                } catch (IOException ioe) {
                    String msg = ioe.getMessage();
                    NotifyDescriptor nd = new NotifyDescriptor.Message(
                        msg, NotifyDescriptor.ERROR_MESSAGE);
                    DialogDisplayer.getDefault().notify(nd);
                } finally {
                    progressListener.stop(progressEvent);
                    progressListener = null;
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            RefactoringPanel.this.close();
                        }
                    });
                }
            }
        });
    }
    
    /**
     * Cancel refactor action. This default implementation is closing window
     * only. It can return result state. In this implementation it returns
     * everytime 0.
     *
     * @return  result of cancel operation. Zero represent successful cancel.
     */
    private int cancel() {
        checkEventThread();
        this.close();
        return 0;
    }
    
    void close() {
        if (isQuery) {
            RefactoringPanelContainer.getUsagesComponent().removePanel(this);
        } else {
            RefactoringPanelContainer.getRefactoringComponent().removePanel(this);
        }
        closeNotify();
    }
    
    
    /*
     * Initializes button listener. The subclasses must not need this listener.
     * This is the reason of lazy initialization.
     */
    private ButtonL getButtonListener() {
        if (buttonListener == null)
            buttonListener = new ButtonL();
        
        return buttonListener;
    }
    
    /* expandAll nodes in the tree */
    public void expandAll() {
        checkEventThread();
        final Cursor old = getCursor();
        expandButton.setEnabled(false);
        treeScrollPane.getViewport().remove(tree);
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                int row = 0;
                while (row < tree.getRowCount()) {
                    tree.expandRow(row);
                    row++;
                }
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        treeScrollPane.setViewportView(tree);
                        setCursor(old);
                        expandButton.setEnabled(true);
                        expandButton.setToolTipText(
                                NbBundle.getMessage(RefactoringPanel.class,
                                "HINT_collapseAll") // NOI18N
                                );
                        requestFocus();
                    }
                });
            }});
    }
    
    /* collapseAll nodes in the tree */
    public void collapseAll() {
        checkEventThread();
        expandButton.setEnabled(false);
        final Cursor old = getCursor();
        treeScrollPane.getViewport().remove(tree);
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                int row = tree.getRowCount() - 1;
                while (row > 0) {
                    tree.collapseRow(row);
                    row--;
                }
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        treeScrollPane.setViewportView(tree);
                        setCursor(old);
                        expandButton.setEnabled(true);
                        expandButton.setToolTipText(
                                NbBundle.getMessage(RefactoringPanel.class,
                                "HINT_expandAll") // NOI18N
                                );
                        requestFocus();
                    }
                });
            }});
    }
    
    public void invalidateObject() {
        if (isQuery) {
            return;
        }
        Runnable invalidate = new Runnable() {
            public void run() {
                setRefactoringEnabled(false, false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            invalidate.run();
        } else {
            SwingUtilities.invokeLater(invalidate);
        }
    }
    
    private void refresh(final boolean showParametersPanel) {
        checkEventThread();
        
        
        if (showParametersPanel) {
            // create parameters panel for refactoring
            if (parametersPanel == null) {
                parametersPanel = new ParametersPanel(ui);
            }
            // show parameters dialog
            ParametersPanel.Results oldResults = results;
            results = parametersPanel.showDialog();
	   
            // if no elements were returned, then cancel was pressed
            if (results == null) {
                results = oldResults;
                return;
            } else if (results.getResult() == ParametersPanel.Results.Result.SKIP_PREVIEW){
                // do refactoring without showing the preview
                
                //TODO maybe new style async progress bar
                progressListener = new ProgressL();
                final ProgressEvent progressEvent = new ProgressEvent(this,0, 0, -1);
                try {
                    progressListener.start(progressEvent);
                    RefactoringManager.getInstance().process(results.getRefactorRequest());
                    StatusDisplayer.getDefault().setStatusText(
                            NbBundle.getMessage(RefactoringPanel.class,
                            "LBL_Refactoring_Completed"));
                } catch (IOException ioe) {
                    String msg = ioe.getMessage();
                    NotifyDescriptor nd = new NotifyDescriptor.Message(
                        msg, NotifyDescriptor.ERROR_MESSAGE);
                    DialogDisplayer.getDefault().notify(nd);
                } finally {
                    progressListener.stop(progressEvent);
                    progressListener = null;
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            RefactoringPanel.this.close();
                        }
                    });
                }
                return;
            }
            
//            session = tempSession;
        } else if (! isQuery && results == null) {
            results = new ParametersPanel.Results();
            RefactorRequest rr = ui.getRefactorRequest();
            assert rr != null : "Unexpected null refactor request for non-query";
            results.setRefactorRequest(ui.getRefactorRequest());
        }
        
        final String description = ui.getDescription();
        setToolTipText("<html>" + description + "</html>"); // NOI18N
        setName(ui.getName());
        
        if (isQuery){
            showQuery(showParametersPanel);
        } else {
            showPreview(showParametersPanel, description);
        }
    }
    
    private void showPreview(final boolean showParametersPanel, String description) 
                                                throws MissingResourceException {
        
        final View view = ui.getView();
        final FindUsageResult fuResult = results.getUsagesResult();
        final RefactorRequest refactorRequest = results.getRefactorRequest();
        try {
            fuResult.get().addPropertyChangeListener(
                    WeakListeners.propertyChange(this, refactorRequest.getUsages()));
        } catch (InterruptedException ex) {
            ErrorManager.getDefault().notify(ex);
        } catch (ExecutionException ex) {
            ErrorManager.getDefault().notify(ex);
        }
        final Referenceable ref = ((WhereUsedView)view).getQueryComponent();
        final String name = refactorRequest.getTargetName();
        RequestProcessor.getDefault().post(new Runnable(){
            public void run() {
                addPropertyChangeListener(NODE_SELECTION_CHANGE, view);
                // The Preview for delete contains only the target, not the usages
                Object[] models = null;
                String rootLabel = null;
                //TODO abstract out these if's with'
                if (refactorRequest instanceof DeleteRequest){
                    assert ref instanceof NamedReferenceable;
                    models = WhereUsedReader.createDeletePreviewModels((NamedReferenceable) ref);
                    rootLabel = MessageFormat.format(
                            NbBundle.getMessage(
                                RefactoringPanel.class, "LBL_Delete_Preview_TreeRoot_Label"), 
                                new Object[] {name});
                } 
                else if (refactorRequest instanceof RenameRequest ||
                         refactorRequest instanceof FileRenameRequest) {
                    models = ((WhereUsedView)view).createModels(fuResult);
                    models = WhereUsedReader.insertTargetComponent(ref, models, refactorRequest.getDescription());
                    rootLabel = MessageFormat.format(
                            NbBundle.getMessage(RefactoringPanel.class, 
                            "LBL_Rename_Preview_TreeRoot_Label"),
                            AnalysisUtilities.getChangeValues(refactorRequest));
                }
                //  replace usages label on root node of tree model with preview label
                for (Object obj:models){
                    if (obj instanceof DefaultTreeModel){
                        Object root = ((DefaultTreeModel)obj).getRoot();
                        if (root instanceof CheckNode){
                            ((CheckNode)root).setLabel(rootLabel);
                        }
                    }
                }
                
                if (fuResult.isCancelled()) {
                    return;
                }
                
                if (models != null){
                    for (Object o:models){
                        if (o instanceof DefaultTreeModel){
                            treeModel = DefaultTreeModel.class.cast(o);
                            break;
                        }
                        else if (refactorRequest instanceof DeleteRequest && o instanceof Graph){
                            ((WhereUsedView)view).setGraph((prefuse.data.Graph)o);
                        }
                    }
                }
                assert treeModel != null:"Tree Model should not be null";
                SwingUtilities.invokeLater(new Runnable(){
                    public void run() {
                        
                        if (!isVisible) {
                            // dock it into output window area and display
                            RefactoringPanelContainer cont = isQuery ?
                                RefactoringPanelContainer.getUsagesComponent() :
                                RefactoringPanelContainer.getRefactoringComponent();
                            if (cont == null){
                                ErrorManager.getDefault().log(
                                        ErrorManager.ERROR,
                                        "XML Find Failed to open RefactoringPanelContainer. The problem could be that the XML settings and wstcref files in userdir Windows2Local are obsolete.  Try removing xml-find-usages.* and xml-find-usages.* and restart the IDE.");
                                return;
                            }
                            cont.open();
                            cont.requestActive();
                            cont.addPanel(RefactoringPanel.this);
                            isVisible = true;
                        }
                        setRefactoringEnabled(false, true);
                        
                        if (view != null){
                            if (tree == null) {
                                // add panel with appropriate content
                                tree = new JTree(treeModel) {
                                    
                                    public static final long serialVersionUID = 1L;
                                    public TreePath getNextMatch(
                                            String prefix,
                                            int startingRow,
                                            Position.Bias bias) {
                                        try {
                                            return super.getNextMatch(
                                                    prefix,
                                                    startingRow,
                                                    bias);
                                        } catch (NullPointerException e) {
                                            //Work around for 43112
                                        }
                                        return null;
                                    }
                                };
                                ToolTipManager.sharedInstance().
                                        registerComponent(tree);
                                tree.setCellRenderer(
                                        new CheckRenderer(isQuery));
                                String s = NbBundle.getMessage(
                                        RefactoringPanel.class,
                                        "ACSD_usagesTree"); // NOI18N
                                tree.getAccessibleContext().
                                        setAccessibleDescription(s);
                                tree.getAccessibleContext().
                                        setAccessibleName(s);
                                CheckNodeListener l =
                                        new CheckNodeListener(isQuery);
                                l.addFindInSchemaViewListener(analysisViewer);
                                tree.addMouseListener(l);
                                tree.addKeyListener(l);
                                
                                tree.addTreeSelectionListener(
                                        RefactoringPanel.this);
                                
                                tree.setToggleClickCount(0);
                                treeScrollPane = new JScrollPane(tree);
                                
                                splitPane.setLeftComponent(
                                        treeScrollPane);
                                RefactoringPanel.this.validate();
                            } else {
                                tree.setModel(treeModel);
                            }
                            tree.setRowHeight((int)
                            ((CheckRenderer)
                            tree.getCellRenderer()).
                                    getPreferredSize().getHeight());
                            
                            if (showParametersPanel) {
                                if (tree.getRowCount() < MAX_ROWS)
                                    expandAll();
                                else
                                    expandButton.setSelected(false);
                            } else {
                                if (expandButton.isSelected())
                                    expandAll();
                                else
                                    expandButton.setSelected(false);
                            }
                            
                            tree.setSelectionRow(0);
                            requestFocus();
                            setRefactoringEnabled(true, true);
                            analysisViewer.showView(view);
                            splitPane.setDividerLocation(0.50);
                        }
                    }
                });
            }});
            
    }
    
    private void showQuery(final boolean showParametersPanel) throws MissingResourceException {
        final View view = ((WhereUsedQueryUI)ui).getView();
        Referenceable ref = ((WhereUsedView)view).getQueryComponent();
        final FindUsageResult fuResult =
                RefactoringManager.getInstance().findUsages(ref);
        RequestProcessor.getDefault().post(new Runnable(){
            public void run() {
                ProgressHandle ph = ProgressHandleFactory.createHandle(
                        NbBundle.getMessage(RefactoringPanel.class,
                        "LBL_Finding_Usages"),
                        fuResult
                        );
                ph.start();
                ph.switchToIndeterminate();
                addPropertyChangeListener(NODE_SELECTION_CHANGE, view);
                Object[] models = ((WhereUsedView)view).createModels(fuResult);
                
                if (fuResult.isCancelled()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WhereUsedReader.class,
                            "LBL_Query_Cancelled"));
                    ph.finish();
                    return;
                    
                }
                
                if (models != null){
                    for (Object o:models){
                        if (o instanceof DefaultTreeModel){
                            treeModel = DefaultTreeModel.class.cast(o);
                            break;
                        }
                    }
                }
                assert treeModel != null:"Tree Model should not be null";
                ph.finish();
                SwingUtilities.invokeLater(new Runnable(){
                    public void run() {
                        
                        if (!isVisible) {
                            // dock it into output window area and display
                            RefactoringPanelContainer cont = isQuery ?
                                RefactoringPanelContainer.getUsagesComponent() :
                                RefactoringPanelContainer.getRefactoringComponent();
                            if (cont == null){
                                ErrorManager.getDefault().log(
                                        ErrorManager.ERROR,
                                        "XML Find Failed to open RefactoringPanelContainer. The problem could be that the XML settings and wstcref files in userdir Windows2Local are obsolete.  Try removing xml-find-usages.* and xml-find-usages.* and restart the IDE.");
                                return;
                            }
                            cont.open();
                            cont.requestActive();
                            cont.addPanel(RefactoringPanel.this);
                            isVisible = true;
                        }
                        setRefactoringEnabled(false, true);
                        
                        if (view != null){
                            if (tree == null) {
                                // add panel with appropriate content
                                tree = new JTree(treeModel) {
                                    
                                    public static final long serialVersionUID = 1L;
                                    public TreePath getNextMatch(
                                            String prefix,
                                            int startingRow,
                                            Position.Bias bias) {
                                        try {
                                            return super.getNextMatch(
                                                    prefix,
                                                    startingRow,
                                                    bias);
                                        } catch (NullPointerException e) {
                                            //Work around for 43112
                                        }
                                        return null;
                                    }
                                };
                                ToolTipManager.sharedInstance().
                                        registerComponent(tree);
                                tree.setCellRenderer(
                                        new CheckRenderer(isQuery));
                                String s = NbBundle.getMessage(
                                        RefactoringPanel.class,
                                        "ACSD_usagesTree"); // NOI18N
                                tree.getAccessibleContext().
                                        setAccessibleDescription(s);
                                tree.getAccessibleContext().
                                        setAccessibleName(s);
                                CheckNodeListener l =
                                        new CheckNodeListener(isQuery);
                                l.addFindInSchemaViewListener(analysisViewer);
                                tree.addMouseListener(l);
                                tree.addKeyListener(l);
                                
                                tree.addTreeSelectionListener(
                                        RefactoringPanel.this);
                                
                                tree.setToggleClickCount(0);
                                treeScrollPane = new JScrollPane(tree);
                                
                                splitPane.setLeftComponent(
                                        treeScrollPane);
                                RefactoringPanel.this.validate();
                            } else {
                                tree.setModel(treeModel);
                            }
                            tree.setRowHeight((int)
                            ((CheckRenderer)
                            tree.getCellRenderer()).
                                    getPreferredSize().getHeight());
                            
                            if (showParametersPanel) {
                                if (tree.getRowCount() < MAX_ROWS)
                                    expandAll();
                                else
                                    expandButton.setSelected(false);
                            } else {
                                if (expandButton.isSelected())
                                    expandAll();
                                else
                                    expandButton.setSelected(false);
                            }
                            
                            tree.setSelectionRow(0);
                            requestFocus();
                            setRefactoringEnabled(true, true);
                            analysisViewer.showView(view);
                            splitPane.setDividerLocation(0.50);
                        }
                    }
                });
            }});
    }
    
    public void requestFocus() {
        super.requestFocus();
        if (refactorButton != null) {
            refactorButton.requestFocus();
        } else {
            if (tree!=null)
                tree.requestFocus();
        }
    }
    
    void setRefactoringEnabled(boolean enabled, boolean isRefreshing) {
        checkEventThread();
        if (tree != null) {
            if (!enabled) {
                CheckNode c = (CheckNode) tree.getModel().getRoot();
                if (!isRefreshing) {
                    c.setNeedsRefresh();
                } else {
                    c.setDisabled();
                }
                tree.setModel(new DefaultTreeModel(c, false));
            }
//            tree.validate();
            tree.setEnabled(enabled);
            if (refactorButton != null) {
                refactorButton.setEnabled(enabled);
            }
        }
    }
    
    // disables all components in a given container
    private static void disableComponents(Container c) {
        checkEventThread();
        Component children[] = c.getComponents();
        for (int i = 0; i < children.length; i++) {
            if (children[i].isEnabled()) {
                children[i].setEnabled(false);
            }
            if (children[i] instanceof Container) {
                disableComponents((Container) children[i]);
            }
        }
    }
    
    void selectNextUsage() {
        selectNextPrev(true);
    }
    
    void selectPrevUsage() {
        selectNextPrev(false);
    }
    
    private void selectNextPrev(final boolean next) {
        int newRow = getSelectedRow();
        int maxcount = tree.getRowCount();
        CheckNode node;
        do {
            if (next) {
                newRow++;
                if (newRow>=maxcount)
                    newRow = 0;
            } else {
                newRow--;
                if (newRow<0)
                    newRow = maxcount-1;
            }
            TreePath path = tree.getPathForRow(newRow);
            node = (CheckNode) path.getLastPathComponent();
            if (!node.isLeaf()) {
                tree.expandRow(newRow);
                maxcount = tree.getRowCount();
            }
        }
        while (!node.isLeaf());
        tree.setSelectionRow(newRow);
    }
    
    private int getSelectedRow() {
        int[] rows = tree.getSelectionRows();
        if (rows == null || rows.length == 0)
            return 0;
        return rows[0];
    }
    
    ////////////////////////////////////////////////////////////////////////////
    // INNER CLASSES
    ////////////////////////////////////////////////////////////////////////////
    
    private class ButtonL implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object o = event.getSource();
            // Cancel button pressed, remove refactoring panel
            if (o == cancelButton) {
                cancel();
            } else if (o == refactorButton) {
                refactor();
            } else if (o == rerunButton) {
                close();
                callback.actionPerformed(event);
            }
            // expandAll button selected/deselected
            else if (o == expandButton && tree != null) {
                if (expandButton.isSelected())
                    expandAll();
                else
                    collapseAll();
            } else if (o == refreshButton) {
                refresh((ui instanceof WhereUsedQueryUI)?false:true);
            } else if (o == physicalViewButton) {
                switchToPhysicalView();
            } else if (o == logicalViewButton) {
                switchToLogicalView();
            } else if (o == nextMatch) {
                selectNextUsage();
            } else if (o == prevMatch) {
                selectPrevUsage();
            }
        }
    } // end ButtonL
    ////////////////////////////////////////////////////////////////////////////
    
    protected void closeNotify() {
        if (tree!=null)
            ToolTipManager.sharedInstance().unregisterComponent(tree);
        if (refCallerTC != null) {
            TopComponent tc = (TopComponent) refCallerTC.get();
            if (tc != null && tc.isShowing()) {
                tc.requestActive();
            }
        }
    }
    
    
    /**
     *  Implement TreeSelectionListener
     *
     */
    
    public void valueChanged(TreeSelectionEvent e) {
        
        CheckNode node = (CheckNode)
        tree.getLastSelectedPathComponent();
        
        if (node == null) {
            // unselect
            firePropertyChange(NODE_SELECTION_CHANGE, new Object(), null);
            return;
        }
        
        Object userObject = node.getUserObject();
        if (userObject == null){
            // this shouldn't happen because the CheckNodes should
            // have a user object (SchemaComponent, Project, FileObject, etc)
            firePropertyChange(NODE_SELECTION_CHANGE, null, new Object());
        } else {
            firePropertyChange(NODE_SELECTION_CHANGE, null, userObject);
        }
       Node usageNode = node.getOrigNode();
       setActivatedNodes(usageNode);

    }

	private void setActivatedNodes(Node tmpUsageNode) {
	    
	    //lativ begin
	    TopComponent usagesTopComponent = isQuery ? 
                RefactoringPanelContainer.getUsagesComponent() : 
                RefactoringPanelContainer.getRefactoringComponent();
	    if (usagesTopComponent != null) {
		if (tmpUsageNode != null) {
		    usagesTopComponent.setActivatedNodes(new Node[] {tmpUsageNode});
		} else {
		    usagesTopComponent.setActivatedNodes(new Node[0]);
		}
	    }
	}
    
    /**
     *  Graph node selection change listener
     *    when a graph node is selected, select the
     *    corresponding explorer node, if there is one
     * This method gets called when a bound property is changed.
     *
     * @param evt A PropertyChangeEvent object describing the event source
     *   	and the property that has changed.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(
                AnalysisViewer.PROP_GRAPH_NODE_SELECTION_CHANGED_RELAY)){
            // originally fired from FindUsagesFocusControl
            // selectionFocusControl instance in WhereUsedView when the
            // user clicked on a graph node, then
            // relayed by AnalysisViewer
            Object newVal = evt.getNewValue();
            if (newVal == null){
                // unselect selected node in JTree
                tree.getSelectionModel().clearSelection();
		setActivatedNodes(null);
            } else {
                // select the corresponding JTree node
		int index = findTreeRowForUserObject(newVal);
                tree.setSelectionRow(index);
		Node activatedNode = null;
		if (index != -1) {
		    TreePath tp = tree.getPathForRow(index);
		    CheckNode cn = (CheckNode) tp.getLastPathComponent();
		    activatedNode = cn.getOrigNode();
		}
		setActivatedNodes(activatedNode);
            }
        } else if (evt.getPropertyName().equals(UsageSet.VALID_PROPERTY)){
            Boolean valid = (Boolean)evt.getNewValue();
            if (!valid){
                invalidateObject();
            }
        }
    }
    
    /**
     * Find the tree row containing the CheckNode for
     *  the passed SchemaComponent or FileObject
     * @param  userObject a SchemaComponent or FileObject
     *
     *
     */
    private int findTreeRowForUserObject(Object userObject){
        CheckNode root = (CheckNode)treeModel.getRoot();
	int currentRow = -1;
        if (root != null) {
	    currentRow = inspectTreeNodes(root, userObject);
	}
        return currentRow;
    }
    
    private boolean matchesUsage(Object targetObject, CheckNode treeNode) {
	return  treeNode.getUserObject() instanceof Usage &&
	       ((Usage) treeNode.getUserObject()).getComponent() == targetObject;
    }
    
    private int inspectTreeNodes(CheckNode node, Object userObject){
        Enumeration children = node.children();
	int foundRow = -1;
        while(children.hasMoreElements() && foundRow == -1){
            CheckNode child = (CheckNode)children.nextElement();
            if (child.getUserObject() == userObject ||
		matchesUsage(userObject, child)) {
                foundRow = tree.getRowForPath(new TreePath(child.getPath()));
            } else {
                foundRow = inspectTreeNodes(child, userObject);
            }
        }
	return foundRow;
    }
    
    /**
     * long-running task Find Usages task that can be cancelled
     *
     *
     */
    public void setCancellable(Cancellable cancellable) {
        this.cancellableFindUsagesTask = cancellable;
    }

    //Begin:NodeListener
    public void nodeDestroyed(NodeEvent ev) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                close();
            }
        });
    }

    public void childrenReordered(NodeReorderEvent ev) {
    }

    public void childrenRemoved(NodeMemberEvent ev) {
    }

    public void childrenAdded(NodeMemberEvent ev) {
    }

    public void valueChanged(ComponentEvent evt) {
    }

    public void childrenDeleted(ComponentEvent evt) {
        if (ui.getTarget() instanceof DocumentComponent) {
            DocumentComponent component = (DocumentComponent) ui.getTarget();
            if (component.getParent() == null || component.getModel() == null) {
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        close();
                    }
                });
            }
        }
    }

    public void childrenAdded(ComponentEvent evt) {
    }
    //End:NodeListener
    
    private static class ProgressL implements ProgressListener {
        
        private ProgressHandle handle;
        private Dialog d;
        private int counter;
        
        public void start(final ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    counter = 0;
                    final String lab = NbBundle.getMessage(RefactoringPanel.class, "LBL_RefactorProgressLabel");
                    handle = ProgressHandleFactory.createHandle(lab);
                    JComponent progress = ProgressHandleFactory.createProgressComponent(handle);
                    JPanel component = new JPanel();
                    component.setLayout(new BorderLayout());
                    component.setBorder(new EmptyBorder(12,12,11,11));
                    JLabel label = new JLabel(lab);
                    label.setBorder(new EmptyBorder(0, 0, 6, 0));
                    component.add(label, BorderLayout.NORTH);
                    component.add(progress, BorderLayout.CENTER);
                    DialogDescriptor desc = new DialogDescriptor(component, NbBundle.getMessage(RefactoringPanel.class, "LBL_RefactoringInProgress"), true, new Object[]{}, null, 0, null, null);
                    desc.setLeaf(true);
                    d = DialogDisplayer.getDefault().createDialog(desc);
                    ((JDialog) d).setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
                    
                    
                    if (event.getCount()==-1) {
                        handle.start();
                        handle.switchToIndeterminate();
                    } else {
                        handle.start(event.getCount());
                    }
                    
                    d.setVisible(true);
                }
            });
        }
        
        public void step(ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    handle.progress(++counter);
                }
            });
        }
        
        public void stop(ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    handle.finish();
                    d.setVisible(false);
                }
            });
        }
    }
} // end Refactor Panel
