/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.refactoring.ui.j.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.modules.xml.refactoring.DeleteRequest;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.ErrorItem.Level;
import org.netbeans.modules.xml.refactoring.UsageSet;
import org.netbeans.modules.xml.refactoring.ui.j.api.Problem;
import org.netbeans.modules.xml.refactoring.ui.j.api.ProblemDetails;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.ParametersPanel;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.RefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.WhereUsedQueryUI;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

/**
 *
 * @author  Jan Becicka
 */
public class ProblemComponent extends javax.swing.JPanel {
    
    private static Color bgColor =  new Color(240, 240, 240);
    private ErrorItem errorItem;
    private RefactoringUI ui;
    private static double buttonWidth;
//    private boolean showFindUsagesButton;
    
    /**
     * Creates new form ProblemComponent 
     */
    public ProblemComponent(ErrorItem errorItem, RefactoringUI ui) {
        initComponents();
        this.ui = ui;
        icon.setIcon(errorItem.getLevel()==Level.FATAL?ErrorPanel.getFatalErrorIcon():ErrorPanel.getNonfatalErrorIcon());
        problemDescription.setText(errorItem.getMessage());
        this.errorItem = errorItem;
        
        //TODO straighten out usability issue of Safe Delete whether to allow 
        // cascade delete where possible
        if (ui.getRefactorRequest() instanceof DeleteRequest) {
            DeleteRequest request = (DeleteRequest) ui.getRefactorRequest();
            UsageSet usageSet = request.getUsages();
            if (usageSet != null && ! usageSet.isEmpty()) {
                setLightBackground();
                String showUsagesButtonHint = NbBundle.getMessage(ProblemComponent.class, "LBL_ShowUsages"); //NOI18N
                buttonWidth = Math.max(new JButton(showUsagesButtonHint).getMinimumSize().getWidth(), buttonWidth);
                org.openide.awt.Mnemonics.setLocalizedText(showUsages, showUsagesButtonHint);
                showUsages.setPreferredSize(new Dimension((int) buttonWidth, (int) showUsages.getMinimumSize().getHeight()));
            } else {
                showUsages.setVisible(false);
            }
        } else {
            showUsages.setVisible(false);
        }
        validate();
    }
    
    static void initButtonSize(Problem problem) {
        buttonWidth = -1.0;
        while (problem != null) {
            ProblemDetails pdi = problem.getDetails();
            if (pdi != null) {
                buttonWidth = Math.max(new JButton(pdi.getDetailsHint()).getMinimumSize().getWidth(), buttonWidth);
            }
            problem = problem.getNext();
        }
        
    }
    
    public void setLightBackground() {
        setBackground(Color.WHITE);
        problemDescription.setBackground(Color.WHITE);
        icon.setBackground(Color.WHITE);
        showUsages.setBackground(Color.WHITE);
    }
    
    public void setDarkBackground() {
        Color bgColor =  new Color(240, 240, 240);
        setBackground(bgColor);
        problemDescription.setBackground(bgColor);
        icon.setBackground(bgColor);
        showUsages.setBackground(bgColor);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        icon = new javax.swing.JLabel();
        problemDescription = new javax.swing.JTextArea();
        showUsages = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
        icon.setBackground(javax.swing.UIManager.getDefaults().getColor("TextArea.background"));
        icon.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 6, 1, 6));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(icon, gridBagConstraints);

        problemDescription.setEditable(false);
        problemDescription.setLineWrap(true);
        problemDescription.setWrapStyleWord(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(problemDescription, gridBagConstraints);
        problemDescription.getAccessibleContext().setAccessibleName(null);
        problemDescription.getAccessibleContext().setAccessibleDescription(null);

        showUsages.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showUsagesActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(showUsages, gridBagConstraints);
        showUsages.getAccessibleContext().setAccessibleName(showUsages.getText());
        showUsages.getAccessibleContext().setAccessibleDescription(showUsages.getText());

    }// </editor-fold>//GEN-END:initComponents

    private void showUsagesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showUsagesActionPerformed
         Container c = this;
         while (!(c instanceof ParametersPanel)) {
             c = c.getParent();
         }
         final ParametersPanel parametersPanel = (ParametersPanel) c;
         Cancellable doCloseParent = new Cancellable() {
             public boolean cancel() {
                 parametersPanel.cancel.doClick();
                 return true;
             }
         };
         
        // showUsages
        Referenceable ref = ui.getRefactorRequest().getTarget();
        WhereUsedView wuv = new WhereUsedView(ref);
        WhereUsedQueryUI queryUI = new WhereUsedQueryUI(wuv, ref);
        doCloseParent.cancel();
        new RefactoringPanel(queryUI, new CallbackAction(ui)).setVisible(true);
    }//GEN-LAST:event_showUsagesActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel icon;
    private javax.swing.JTextArea problemDescription;
    private javax.swing.JButton showUsages;
    // End of variables declaration//GEN-END:variables
    
    private class CallbackAction extends AbstractAction {
        RefactoringUI ui;
        
        public CallbackAction(RefactoringUI ui) {
            super(MessageFormat.format(NbBundle.getMessage(ProblemComponent.class, "LBL_Rerun"), new Object[]{ui.getName()}));
            this.ui = ui;
        }
        
        public void actionPerformed(ActionEvent event) {
            ui.getRefactorRequest().setUsages(null);
            new RefactoringPanel(ui).setVisible(true);
        }
    }
}
